<?php

require_once(__DIR__ . "/class.stock.php");
require_once(__DIR__ . "/db.rf_database.php");
require_once(__DIR__ . "/db.tc_table.php");
require_once(__DIR__ . "/db.tc_property_trf.php");
require_once(__DIR__ . "/db.tc_prop_stock_update.php");
require_once(__DIR__ . "/db.tr_rule.php");
require_once(__DIR__ . "/functions.financial.php");
require_once(__DIR__ . '/class.lock.php');
ini_set('mysql.connect_timeout', 3600);
ini_set('default_socket_timeout', 3600);

function extractChangesDT7() {

	global $lDB;
	global $transferId;
	global $sysLocked;
	global $principal_id;
	global $dbcode;

	# Step 0 - Lock transfer
	$lock = new Lock("data_transfer_$principal_id"."_"."$dbcode");
	if(!$lock->Acquire()) {
		setProgressReport("!FALSE!, Unable to extract changes as this transfer is locked by another process. This is usually caused by two processes attempting the send and/or recieve transfer at the same time. [1016]",1);
		callException(1016);
		return 0;
	}

	# Step 1 - run DT16 for each tc_table
	$waitList = array();
	if ($sysLocked || (isset($_POST['transferDirection']) && $_POST['transferDirection'] == "5")) {
		$waitList = array();
	}
	$pending = array();
	$sql = "SELECT tc_table_name FROM tc_table WHERE tc_table_sys_code < 5 ORDER BY tc_table_seq";
	$list = $lDB->get($sql,3);
	$amax = sizeof($list);
	$startTime = time();
	for($a=0;$a<$amax;$a++) {
		if (!in_array($list[$a],$waitList)) {
			$lDB->begin();
			$result = exportTableToFileDT16($list[$a]);
			$lDB->commit();
			if (!$result) {
				return 0;
			}
		} else {
			array_push($pending,$list[$a]);
		}
		$diffTime = time() - $startTime;
		if($diffTime > 10) { // If 10 seconds (or more) has elapsed, send something down the line to prevent timeout
			setProgressReport(".");
			$startTime = time();
		}
	}

	# Step 2 - run DT16 for pending tables if a transfer has already been created
	if ($transferId != "") {
		$bmax = sizeof($pending);
		for($b=0;$b<$bmax;$b++) {
			$lDB->begin();
			if (!exportTableToFileDT16($pending[$b])) {
				$lDB->commit();
				return 0;
			} else {
				$lDB->commit();
			}
		}
		$diffTime = time() - $startTime;
		if($diffTime > 10) { // If 10 seconds (or more) has elapsed, send something down the line to prevent timeout
			setProgressReport(".");
			$startTime = time();
		}
	}
	return 1;
}

function abortTransferDT8() {

	global $TDfilePath;
	global $tdSendTime;

	global $sysLocked;
	global $lDB;

	global $remoteTransferDB;

	if ($sysLocked) {
		$lDB->put("UPDATE rf_system SET rf_sys_locked_yn = 0");
		$sysLocked = false;
	}

	$undo = true;
	if ($tdSendTime != "" && $tdSendTime != "0000-00-00 00:00:00") {
		setProgressReport("Unable to undo this transfer, closing..");
		closeTransferFailDT18();
		setProgressReport("Transfer closed",1);
		$undo = false;
	}

	# Step 1 - Verify transfer folder
	if (!is_dir($TDfilePath)) {
		setProgressReport("Unable to undo transfer: No folder",1);
		$undo = false;
	}

	# Step 2 move all data in processing (_prc) tables back to source tables
	$lDB->put("
		INSERT INTO tc_property_trf
		SELECT * FROM tc_property_trf_prc WHERE tc_property_trf_prc.rf_db_code = '".$remoteTransferDB."'
		ON DUPLICATE KEY UPDATE tc_property_trf.tc_prop_record_id=tc_property_trf.tc_prop_record_id");
	$lDB->put("DELETE FROM tc_property_trf_prc WHERE tc_property_trf_prc.rf_db_code = '".$remoteTransferDB."'");
	$lDB->put("
		INSERT INTO tc_prop_stock_update
		SELECT * FROM tc_prop_stock_update_prc WHERE tc_prop_stock_update_prc.rf_db_code = '".$remoteTransferDB."'
		ON DUPLICATE KEY UPDATE tc_prop_stock_update.ac_accomm_type_id=tc_prop_stock_update.ac_accomm_type_id");
	$lDB->put("DELETE FROM tc_prop_stock_update_prc WHERE tc_prop_stock_update_prc.rf_db_code = '".$remoteTransferDB."'");
	setProgressReport("Moved processing data back to source tables",1);

	$failurecounter = 0;
	$undocounter = 0;
	# Step 3 - Undo each transfer file
	if ($undo) {
		$failurecounter = 0;
		$undocounter = 0;
		$dp = opendir($TDfilePath);
		while ($fileName = readdir($dp)) {
			# Skip the directory indexes
			if ($fileName != "." && $fileName != "..") {
				# Verify this is a file and not a subdirectory
				if (is_file($TDfilePath.$fileName)) {
					if (!undoFileDT20($TDfilePath,$fileName)) {
						$failurecounter++;
					} else {
						$undocounter++;
					}
				}
			}
		}
		$undoPercentage = $undocounter + $failurecounter == 0 ? 0 : (($undocounter / ($undocounter + $failurecounter)) * 100);
		setProgressReport("Undone ".$undoPercentage."% of the changed tables",1);
	}

	# Step 4 - Close transfer
	closeTransferFailDT18();
	setProgressReport("Transfer Undone",1);
	return 0;
}

function exportControlTablesDT9() {

	global $TDfilePath, $lDB;

	# Step 1 - Export tc_transfer_table
	$lDB->begin();
	if (!exportTableToFileDT16("tc_transfer_table")) {
		setProgressReport("Error exporting tc_transfer_table control records",1);
		$lDB->commit();
		return 0;
	} else {
		$lDB->commit();
	}

	# Step 2 - Export tc_transfer
	$lDB->begin();
	if (!exportTableToFileDT16("tc_transfer")) {
		setProgressReport("Error exporting tc_transfer control records",1);
		$lDB->commit();
		return 0;
	} else {
		$lDB->commit();
	}

	# Step 3 - Test files
	if (!is_file($TDfilePath."tc_transfer.txt")) {
		setProgressReport("Unable to find control files in ".$TDfilePath,1);
		return 0;
	}

	return 1;
}

function createZipFileFromFolderDT10($zipFile,$filePath) {

	# Step 1 - test transfer folder and files
	if (!is_dir($filePath)){
		setProgressReport("Unable to open transfer folder",1);
		return 0;
	} else {
		if (!is_file($filePath."tc_transfer.txt")) {
			setProgressReport("Unable to find control files in:".$filePath,1);
			return 0;
		}
	}

	# Step 2 - Delete the zipfile if it already exists
	if (is_file($zipFile)) { unlink($zipFile); }
	if (is_file($zipFile)) {
		setProgressReport("Unable to delete old zipfile",1);
		return 0;
	}

	# Step 3 - Test and create the zipfile
	$zipFileObj = new PclZip($zipFile);
	if (!is_object($zipFileObj)) {
		setProgressReport("Unable to create zipfile object",1);
		return 0;
	}

	$filePath2 = $filePath;
	if(preg_match("/:/",$filePath)) {
		$temp = explode(":",$filePath);
		$filePath2 = $temp[1];
	}

	# Step 4 - Add transfer files to zip
	$dp = opendir($filePath2);
	if ($dp === false) {
		echo "Unable to open :".$filePath2."<br>";
	}
	while ($fileName = readdir($dp)) {
		# Skip the directory indexes
		if ($fileName != "." && $fileName != ".." && substr($fileName,strlen($fileName)-4,4) == ".txt") {
			# Verify this is a file and not a subdirectory
			$filePath2 = str_replace("\\","/",$filePath);
			if (is_file($filePath2.$fileName)) {
				$result = $zipFileObj->add($filePath2.$fileName,PCLZIP_OPT_REMOVE_ALL_PATH);
				$amax = sizeof($result);
				if ($result != false && $amax != 0) {
					for($a=0;$a<$amax;$a++) {
						$fileResult = $result[$a];
						if ($fileResult['status'] != "ok") {
							setProgressReport("File: ".$fileResult['stored_filename']." corrupted",1);
							return 0;
						} else {
							if ($fileResult['size'] == $fileResult['compressed_size']) {
								$fp = fopen($filePath2.$fileName,"a");
								$string = "#";
								for ($n=0;$n<8;$n++) {
									$string .= $string;
								}
								fwrite($fp,$string);
								fclose($fp);

								$delIndex = getNoCompressIndex($zipFileObj);
								$zipFileObj->deleteByIndex($delIndex);
								$result = $zipFileObj->add($filePath2.$fileName,PCLZIP_OPT_REMOVE_ALL_PATH);
								if ($result[0]['status'] != "ok") {
									setProgressReport("File: ".$result[0]['stored_filename']." corrupted",1);
									return 0;
								} else {
									if ($result[0]['size'] == $result[0]['compressed_size']) {
										setProgressReport("FATAL ERROR! Zip generation exception. Unable to continue. Exception details: '".$zipFileObj->errorInfo(true)."'",1);
										return 0;
									}
								}
							}
						}
					}
				} else {
					global $g_pcl_error_code;
					global $g_pcl_error_string;
					setProgressReport($g_pcl_error_code,2);
					setProgressReport($g_pcl_error_string,2);
					setProgressReport("Failed writing file: ".$filePath2.$fileName." to ".$zipFile." (zipfile). Zip exception reported: '".$zipFileObj->errorInfo(true)."'",1);
					return 0;
				}
			}
		}
	}

	return 1;
}

function getNoCompressIndex(&$zipFile) {
	$result = $zipFile->listContent();
	$amax = sizeof($result);
	if ($result != false && $amax != 0) {
		for($a=0;$a<$amax;$a++) {
			$fileResult = $result[$a];
			if ($fileResult['status'] != "ok") {
				setProgressReport("File: ".$fileResult['stored_filename']." corrupted",1);
				return 0;
			} else {
				if ($fileResult['size'] == $fileResult['compressed_size']) {
					return $fileResult['index'];
				}
			}
		}
	}
}


function testZipFileDT11($zipFile) {

	# Step 1 - Test that the zipfile exist
	if (!is_file($zipFile)) {
		$temp = explode("/",$zipFile);
		$file = $temp[(sizeof($temp)-1)];
		setProgressReport("</b>File: <b>".$file."</b> not found<b>",1);
		echo $file."<br>";
		return 0;
	}

	# Step 2 - Open the zipfile
	$zipFile = new PclZip($zipFile);
	if (!is_object($zipFile)) {
		setProgressReport("Unable to create zipfile handler",1);
		return 0;
	}

	# Step 3 - Check each file inside the zip
	$result = $zipFile->listContent();
	$amax = sizeof($result);
	if ($result != false && $amax != 0) {
		for($a=0;$a<$amax;$a++) {
			$fileResult = $result[$a];
			if ($fileResult['status'] != "ok") {
				setProgressReport("File: ".$fileResult['stored_filename']." corrupted",1);
				return 0;
			}
		}
	} else {
		setProgressReport("Corrupt or missing zipfile",1);
		return 0;
	}

	return 1;
}

function extractZipFileDT13($zipFile,$zipFolder) {

	# Step 1 - test zip file
	if (!testZipFileDT11($zipFile)) {
		setProgressReport("Missing or corrupted zipfile",1);
		return 0;
	}

	# Step 2 - Create and test extract folder
	if (!is_dir($zipFolder)) { mkdir($zipFolder,0777); }
	if (!is_dir($zipFolder)) {
		setProgressReport("Unable to create zipfolder",1);
		return 0;
	}

	# Step 3 - Open zipfile
	$zipFile = new PclZip($zipFile);
	if (!is_object($zipFile)) {
		setProgressReport("Unable to open zipfile",1);
		return 0;
	}

	# Step 4 - Extract each file from the zipfile
	$zipFolder2 = $zipFolder;
	if(preg_match("/:/",$zipFolder)) {
		$temp = explode(":",$zipFolder);
		$zipFolder2 = $temp[1];
	}
	$zipFolder2 = str_replace("\\","/",$zipFolder);
	$result = $zipFile->extract($zipFolder2);
	$amax = sizeof($result);
	if ($result != false && $amax != 0) {
		for($a=0;$a<$amax;$a++) {
			$fileResult = $result[$a];
			if ($fileResult['status'] != "ok") {
				setProgressReport("Failed extracting: ".$fileResult['stored_filename']." (".$fileResult['status'].")",1);
				return 0;
			} else {
				if (!is_file($fileResult['filename'])) {
					setProgressReport("File ".$fileResult['stored_filename']." not created",1);
					return 0;
				}
			}
		}
	} else {
		setProgressReport("Extraction failed",1);
		return 0;
	}

	return 1;
}

function exportTableToFileDT16($table) {

	global $dbcode;
	global $lDB;
	global $transferId;
	global $TDfilePath;
	global $mysqlTableInfoList;
	global $remoteTransferDB;
	global $timezone;

	$sql = "";
	$copySql = ""; // copy specific table's contents to processing table for performance reasons
	$deleteSql = ""; // delete copied source data
	# Step 1 - Check for changes
	if ($GLOBALS['isWebServer']) {
		if ($table == "td_deletions") {
			$table = "td_prop_deletions";
		}
		if ($table == "tc_res_update") {
			$table = "tc_prop_res_update";
		}
		$tableId = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = '".$table."'",4);
		$sql = "SELECT COUNT(*) FROM tc_property_trf_prc WHERE tc_table_id = '".$tableId."' AND rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
		$copySql = "
			INSERT INTO tc_property_trf_prc
			SELECT * FROM tc_property_trf WHERE tc_property_trf.tc_table_id = '".$tableId."' AND tc_property_trf.rf_db_code = '".$remoteTransferDB."'
			ON DUPLICATE KEY UPDATE tc_property_trf_prc.tc_prop_record_id=tc_property_trf_prc.tc_prop_record_id";
		$deleteSql = "DELETE FROM tc_property_trf WHERE tc_property_trf.tc_table_id = '".$tableId."' AND tc_property_trf.rf_db_code = '".$remoteTransferDB."'";

		if ($table == "td_prop_deletions") {
			$sql = "SELECT COUNT(*) FROM td_prop_deletions WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
			$copySql = "";
			$deleteSql = "";
		}
		if ($table == "tc_prop_res_update") {
			$sql = "SELECT COUNT(*) FROM tc_prop_res_update WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
			$copySql = "";
			$deleteSql = "";
		}
		if ($table == "tc_prop_stock_update") {
			$sql = "SELECT COUNT(*) FROM tc_prop_stock_update_prc WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
			$copySql = "
				INSERT INTO tc_prop_stock_update_prc
				SELECT * FROM tc_prop_stock_update WHERE tc_prop_stock_update.rf_db_code = '".$remoteTransferDB."'
				ON DUPLICATE KEY UPDATE tc_prop_stock_update_prc.rf_db_code=tc_prop_stock_update.rf_db_code";
			$deleteSql = "DELETE FROM tc_prop_stock_update WHERE tc_prop_stock_update.rf_db_code = '".$remoteTransferDB."'";
		}

		// Reset IX fields
		$tempFlag = $GLOBALS['flagChngs'];
		$GLOBALS['flagChngs'] = "0";
		if (in_array($table,$GLOBALS['ixTableList'])) {
			$lDB->put("UPDATE $table SET ".$table."_trf_yn = 1 WHERE ".$table."_trf_yn = 0");
		}
		$GLOBALS['flagChngs'] = $tempFlag;
	} else {
		$sql = "SELECT COUNT(*) FROM ".$table;
		if (
			$table != "td_deletions"
			&& $table != "tc_res_update"
			&& $table != "tc_prop_stock_update"
		) {
			$sql .= " WHERE ".$table."_trf_yn = '0'";
		}
		$sql .= " FOR UPDATE";
	}
	if ($copySql) {
		$lDB->put($copySql);
	}
	if ($deleteSql) {
		$lDB->put($deleteSql);
	}
	$count = $lDB->get($sql,4);

	if(!isset($GLOBALS['dtLocked'])) { $GLOBALS['dtLocked'] = false; }

	if ($count == "0") {
		return 1;
	}

	# Step 2 - Create transfer, path and export file
	$fileName = $table.".txt";
	if ($table == "td_prop_deletions") {
		$fileName = "td_deletions.txt";
	}
	if ($table == "tc_prop_res_update") {
		$fileName = "tc_res_update.txt";
	}
	if (!is_dir($TDfilePath) || $TDfilePath == "") {
		if ($dbcode[0] != "W") {
			# Offline: create transfer
			if (!createTransferDT17($lDB)) {
				setProgressReport("Unable to create transfer",1);
				return 0;
			}
		} else {
			# Web: create the folder
			mkdir($TDfilePath,0777);
			if (!is_dir($TDfilePath)) {
				setProgressReport("Unable to create folder: ".$TDfilePath,1);
				abortTransferDT8();
				return 0;
			}
		}
	}

	$fp = fopen($TDfilePath.$fileName,"ab");
	if ($fp == false) {
		setProgressReport("Unable to create ".$TDfilePath.$fileName,1);
		return 0;
	}

	# Step 3 - Analyze table
	$tableKey = getMysqlTableKeysDT30($table,$lDB);
	$tableKeyCount = $tableKey['count'];
	$tableKeyField = $tableKey['field'];

	$tableId = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = '".$table."'",4);

	if (!is_array($mysqlTableInfoList)) {
		$mysqlTableInfoList = array();
	}
	if (!in_array($table,array_keys($mysqlTableInfoList))) {
		$mysqlTableInfoList[$table] = array("count" => $tableKeyCount, "keyfield" => $tableKeyField, "tableId" => $tableId);
	}

	$hasKeys = (sizeof($tableKeyCount) > 0);
	$isDeletion = ($table == "td_deletions" || $table == "td_prop_deletions");
	$isResUpdate = ($table == "tc_res_update" || $table == "tc_prop_res_update");
	$isStockUpdate = ($table == "tc_prop_stock_update");
	$isControl = ($table == "tc_transfer" || $table == "tc_transfer_table");

	if (extension_loaded('newrelic')) { // Ensure PHP agent is available
		newrelic_ignore_transaction();
	}

	# Step 5 - Read changes from database
	setProgressReport(" + Changes in ".$table." [".$count."]..");
	$sql = "";
	if ($GLOBALS['isWebServer']) {
		if($table == "td_prop_deletions") {
			$sql = "SELECT tc_table_id, td_record_id FROM td_prop_deletions WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
		} elseif($table == "tc_prop_res_update") {
			$sql = "SELECT tc_prop_res_update_id, rv_reservation_id FROM tc_prop_res_update WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
		} elseif($table == "tc_prop_stock_update") {
			$sql = "SELECT ac_accomm_type_id, tc_prop_stock_date, tc_prop_stock_type_ind FROM tc_prop_stock_update WHERE rf_db_code = '".$remoteTransferDB."' FOR UPDATE";
		} else {
			$recordList = $lDB->get("SELECT tc_prop_record_id FROM tc_property_trf_prc WHERE tc_table_id = '".$tableId."' AND rf_db_code = '".$remoteTransferDB."' FOR UPDATE",3);
			$sql = "SELECT * FROM ".$table." WHERE ".$tableKeyField." IN ('".join("','",$recordList)."') FOR UPDATE";
			# Remove old deletion entries (records which no longer exist)
			$removeList = $lDB->get("
				SELECT
					tc_property_trf_prc.tc_prop_record_id
				FROM
					tc_property_trf_prc
					LEFT JOIN $table ON $tableKeyField = tc_property_trf_prc.tc_prop_record_id
				WHERE
					tc_property_trf_prc.tc_table_id = '$tableId'
					AND $tableKeyField IS NULL
			",3);
			$tempFlag = $GLOBALS['flagChngs'];
			$GLOBALS['flagChngs'] = "0";
			foreach($removeList as $removeItem) {
				db_tc_property_trf_prc_delete($remoteTransferDB,$tableId,$removeItem);
			}
			$removeList = $lDB->get("
				SELECT
					tc_property_trf.tc_prop_record_id
				FROM
					tc_property_trf
					LEFT JOIN $table ON $tableKeyField = tc_property_trf.tc_prop_record_id
				WHERE
					tc_property_trf.tc_table_id = '$tableId'
					AND $tableKeyField IS NULL
			",3);
			foreach($removeList as $removeItem) {
				db_tc_property_trf_delete($remoteTransferDB,$tableId,$removeItem);
			}
			$GLOBALS['flagChngs'] = $tempFlag;
		}
	} else {
		switch ($table) {
		case "td_deletions":
			$sql = "SELECT * FROM td_deletions ORDER BY td_dlt_table_id FOR UPDATE";
			break;
		case "tc_res_update":
			$sql = "SELECT * FROM tc_res_update";
			break;
		case "tc_prop_stock_update":
			$sql = "
				SELECT
					ac_accomm_type_id,
					tc_prop_stock_date,
					tc_prop_stock_type_ind
				FROM
					tc_prop_stock_update
				FOR UPDATE
			";
			break;
		default:
			$sql = "SELECT * FROM ".$table." WHERE ".$table."_trf_yn = '0' FOR UPDATE";
			break;
		}
	}

	$originalTimezone = $timezone;

	set_timezone('UTC');
	$result = $lDB->get($sql,0);
	set_timezone($originalTimezone);

	$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
	if ($error != "") {
		setProgressReport("Error determining changed records in ".$table." (MySQL said: ".$error.")",1);
		return 0;
	}
	$resultCount = mysqli_num_rows($result);

	# Step 6 - Process each row
	$rowCounter = 0;
	$rowKey = "";
	for($a=0;$a<$resultCount;$a++) {
		set_timezone('UTC');
		$rowKey = "";
		$rowArray = mysqli_fetch_assoc($result);
		$row = array_values($rowArray);

		if (!$isDeletion && !$isResUpdate && !$isStockUpdate) {
			# Prepare the output string
			$cols = sizeof($row);
			for($b=0;$b<$cols;$b++) {
				# Build the row's key
				if (in_array($b,$tableKeyCount)) {
					$rowKey .= $row[$b];
				}

				if (($b+1) == $cols) {
					# If this is the last column (trf_yn), set value to 1
					$row[$b] = "1";
				} else {
					# Else remove chars that can break the import process
					if($row[$b] === null) {
						$row[$b] = "|null|";
					} else {
						$row[$b] = htmlspecialchars($row[$b], ENT_QUOTES);
						$row[$b] = str_replace("'","", $row[$b]);
						$row[$b] = str_replace('"',"", $row[$b]);
						$row[$b] = str_replace("|eol|","|/eol|", $row[$b]);
						$row[$b] = str_replace("|null|","|/null|", $row[$b]);
						$row[$b] = str_replace("|return|","|/return|", $row[$b]);
						$row[$b] = str_replace("|newline|","|/newline|", $row[$b]);
						$row[$b] = str_replace("\r","|return|",$row[$b]);
						$row[$b] = str_replace("\n","|newline|",$row[$b]);
					}
				}
			}
		}
		$string = !empty($row)?join("','",$row)."|eol|\r\n":"";
		set_timezone($originalTimezone);

		# Write string to file
		$stringcount = fwrite($fp,$string);
		if ($stringcount != strlen($string)) {
			setProgressReport("Error writing line: ".($a+1)." to ".$fileName,1);
			fclose($fp);
			chmod($TDfilePath.$fileName,0777);
			return 0;
		}

		$rowCounter++;
		if ($hasKeys && !$isDeletion && !$isResUpdate && !$isStockUpdate) {
			$tempFlag = $GLOBALS['flagChngs'];
			$GLOBALS['flagChngs'] = "0";
			if ($GLOBALS['isWebServer']) {
				db_tc_property_trf_prc_delete($remoteTransferDB,$tableId,$rowKey);
			} else {
				$lDB->put("UPDATE ".$table." SET ".$table."_trf_yn = '1' WHERE ".$tableKeyField." = '".$rowKey."'");
			}
			$GLOBALS['flagChngs'] = $tempFlag;
			$error = mysqli_error($lDB->conn);
			if ($error != "") {
				$error = htmlspecialchars($error, ENT_QUOTES);
				setProgressReport("Error updating transfer flag. (MySQL said: ".$error.")",1);
				return 0;
			}
		}

		if ($isDeletion) {
			$deletionRows = $rowArray;
			$tempFlag = $GLOBALS['flagChngs'];
			$GLOBALS['flagChngs'] = "0";
			if (count($deletionRows) > 0) {
				if ($GLOBALS['isWebServer']) {
					$sql = "
						DELETE
						FROM td_prop_deletions
						WHERE
							rf_db_code = '".$remoteTransferDB."'
							AND tc_table_id = '".$deletionRows['tc_table_id']."'
							AND td_record_id = '".$deletionRows['td_record_id'] ."'";
				} else {
					$sql = "
						DELETE
						FROM td_deletions
						WHERE
							td_dlt_table_id = '".$deletionRows['td_dlt_table_id']."'
							AND td_dlt_rec_id  = '".$deletionRows['td_dlt_rec_id']."'";
				}
				$lDB->put($sql);
			}
			$GLOBALS['flagChngs'] = $tempFlag;
		}

		if ($isResUpdate) {
			$tempFlag = $GLOBALS['flagChngs'];
			$GLOBALS['flagChngs'] = "0";
			$resUpdateRows = $rowArray;
			if (count($resUpdateRows) > 0) {
				if ($GLOBALS['isWebServer']) {
					$sql = "
						DELETE
						FROM tc_prop_res_update
						WHERE
							rf_db_code = '".$remoteTransferDB."'
							AND tc_prop_res_update_id = '".$resUpdateRows['tc_prop_res_update_id']."'
							AND rv_reservation_id = '".$resUpdateRows['rv_reservation_id']."'";
				} else {
					$sql = "
						DELETE
						FROM tc_res_update
						WHERE
							tc_res_update_id = '".$resUpdateRows['tc_res_update_id']."'
							AND rv_reservation_id = '".$resUpdateRows['rv_reservation_id']."'";
				}
				$lDB->put($sql);
			}
			$GLOBALS['flagChngs'] = $tempFlag;
		}

		if ($isStockUpdate) {
			$tempFlag = $GLOBALS['flagChngs'];
			$GLOBALS['flagChngs'] = "0";
			$stockUpdateRows = $rowArray;
			if (count($stockUpdateRows) > 0) {
				$sql = "
					DELETE
					FROM tc_prop_stock_update_prc
					WHERE
						ac_accomm_type_id = '".$stockUpdateRows['ac_accomm_type_id']."'
						AND tc_prop_stock_date = '".$stockUpdateRows['tc_prop_stock_date']."'
						AND tc_prop_stock_type_ind = '".$stockUpdateRows['tc_prop_stock_type_ind'] ."'";
				if ($GLOBALS['isWebServer']) {
					$sql .= " AND rf_db_code = '".$remoteTransferDB."'";
				}
				$lDB->put($sql);
			}
			$GLOBALS['flagChngs'] = $tempFlag;
		}
	}

	# Step 7 - Set transfer table entry
	if (!$isControl) {
		$transferCheck = $lDB->get("SELECT COUNT(*) FROM tc_transfer_table WHERE tc_transfer_id = '$transferId' AND tc_table_id = '$tableId'",4);
		if($transferCheck > 0) {
			$sql = "UPDATE tc_transfer_table set tc_trf_tbl_last_exp_rec = '".$rowKey."', tc_trf_tbl_recs_exp = '".$rowCounter."' WHERE tc_transfer_id = '$transferId' AND tc_table_id = '$tableId'";
		} else {
			$sql = "INSERT INTO tc_transfer_table (tc_transfer_table_db, tc_transfer_table_id,  tc_trf_tbl_last_exp_rec, tc_trf_tbl_last_imp_rec, tc_trf_tbl_recs_exp, tc_trf_tbl_recs_imp, tc_transfer_id, tc_table_id) VALUES ('".$dbcode."','','".$rowKey."','','".$rowCounter."','','".$transferId."','".$tableId."')";
		}
		$lDB->put($sql);
	}

	# Step 8 - Close file and set permissions
	fclose($fp);
	chmod($TDfilePath.$fileName,0777);


	# Step 9 - Verify file exists
	if ($rowCounter > 0) {
		if (!is_file($TDfilePath.$fileName)) {
			setProgressReport("Transfer file not found",1);
			return 0;
		}
	}

	return 1;
}

function closeTransferFailDT18() {

	global $transferId;
	global $transferName;
	global $lDB;
	global $isWebServer;

	setProgressReport("The transfer has been completed under abnormal conditions. Please send the generated e-mail to ResRequest support.",1);
	if (!$isWebServer) {
		echo "
			<script language=\"javascript\">
				downloadLogURL = '".getTransferDirDT37($transferName,TRANSFER_DIR_LOG).$transferName.".log"."';
			</script>
		";
	}

	# Step 1 - Close transfer
	$now = date("Y-m-d H-i-s");
	$sql = "UPDATE tc_transfer SET tc_trf_time_close = '".$now."' WHERE tc_transfer.tc_transfer_ix = '".$transferId."'";
	$lDB->put($sql);
}

function importTableFromFileDT19($fileName) {

	global $lDB;
	global $dbcode;
	global $mysqlTableInfoList;
	global $transferId;
	global $remoteTransferDB;
	global $timezone;

	if (!is_array($mysqlTableInfoList)) {
		$mysqlTableInfoList = array();
	}

	# Step 1 - Get the table information
	$temp = explode("/",$fileName);
	$table = str_replace(".txt","",$temp[(sizeof($temp)-1)]);
	$fieldList = array();
	$tableId = "";
	if ($table != "td_deletions" && $table != "tc_res_update" && $table != "tc_prop_stock_update") {
		if (!in_array($table,$mysqlTableInfoList)) {

			# Get the table information manually
			$tableKey = getMysqlTableKeysDT30($table,$lDB);
			$tableKeyCount = $tableKey['count'];
			$tableKeyField = $tableKey['field'];

			$tableFieldList = $lDB->get("show fields from ".$table,2);
			$amax = sizeof($tableFieldList);
			for ($a=0;$a<$amax;$a++) {
				array_push($fieldList,$tableFieldList[$a]['Field']);
			}
			$fieldCount = $amax;

			$tableId = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = '".$table."'",4);

			$mysqlTableInfoList[$table] = array("count" => $tableKeyCount, "keyfield" => $tableKeyField, "tableId" => $tableId);

		} else {

			# Get the table information from the stored array
			$tableKeyCount = $mysqlTableInfoList[$table]['count'];
			$tableKeyField = $mysqlTableInfoList[$table]['keyfield'];
			$tableId = $mysqlTableInfoList[$table]['tableId'];
			$fieldList = $mysqlTableInfoList[$table]['fieldList'];

			# In case we have incomplete table data
			if (sizeof($fieldList) == "0") {
				$tableFieldList = $lDB->get("show fields from ".$table,2);
				$fieldList = array();
				$amax = sizeof($tableFieldList);
				for ($a=0;$a<$amax;$a++) {
					array_push($fieldList,$tableFieldList[$a]['Field']);
				}
				$mysqlTableInfoList[$table]['fieldList'] = $fieldList;
			}
			$fieldCount = sizeof($fieldList);
		}
	}

	# Step 2 - Open file
	if (!is_file($fileName)) {
		setProgressReport("Unable to find ".$fileName,1);
		return 0;
	}
	$fp = fopen($fileName,"rb");
	if ($fp == false) {
		setProgressReport("Unable to open ".$fileName,1);
		return 0;
	}

	# Step 3 - Import each line
	$originalTimezone = $timezone;
	$rowCounter = 0;
	$addTrfList = array($transferId);
	$startTime = time();
	$masterFieldList = $fieldList;
	$fileLine = "";
	$lineKey = "";
	if($table == "tc_prop_stock_update") {
		$stockUpdates = array();
	}
	while (!feof($fp)) {
		$fieldList = $masterFieldList;
		# Add data to the $fileLine string
		$fileLine .= trim(fgets($fp,65536));

		# If we have the end of line character, import this line
		if (substr($fileLine,strlen($fileLine)-5,5) == "|eol|") {
			$rowCounter++;
			$fileLine = str_replace("|eol|","",$fileLine);
			$values = explode("','",$fileLine);
			$amax = sizeof($values);

			if ($table != "td_deletions" && $table != "tc_res_update" && $table != "tc_prop_stock_update") {
				if ($amax != $fieldCount) {
					setProgressReport($amax." != ".$fieldCount,1);
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				# Verify the values in the line won't break the sql statement
				$fieldReference = array();
				$lineKey = "";
				for($a=0;$a<$amax;$a++) {
					$values[$a] = html_entity_decode($values[$a],ENT_QUOTES);
					$values[$a] = addslashes($values[$a]);
					if (substr($values[$a],strlen($values[$a])-1,1) == "\\") {
						$values[$a] .= " ";
					}
					$values[$a] = str_replace("|return|","\r",$values[$a]);
					$values[$a] = str_replace("|newline|","\n",$values[$a]);
					$values[$a] = str_replace("|/return|","|return|", $values[$a]);
					$values[$a] = str_replace("|/newline|","|newline|", $values[$a]);
					$field = $fieldList[$a];
					$fieldReference[$field] = $a;
					if (in_array($a,$tableKeyCount)) {
						$lineKey .= $values[$a];
					}
				}

				$sql = "SELECT COUNT(*) FROM ".$table." WHERE ".$tableKeyField." = '".$lineKey."'";
				if ($table == "tc_transfer" && $lineKey == $transferId && !$GLOBALS['isWebServer']) {
					$fileLine = "";
					continue;
				}
				$count = $lDB->get($sql,4);
				if ($count > 0) {
					# Do field level update on some records
					if ($GLOBALS['dbcode'][0] == "W") {
						# On the Web server
						switch ($table) {
						case "tc_transfer":
							if ($lineKey == $transferId) {
								$update = array("tc_trf_file_size","tc_trf_time_extract","tc_trf_time_send","tc_trf_time_close","sc_transfer_id");
								for ($c=0;$c<$fieldCount;$c++) {
									if (!in_array($fieldList[$c],$update)) {
										$fieldList[$c] = "";
									}
								}
							} else {
								if ($lDB->get("SELECT tc_trf_time_close FROM tc_transfer WHERE tc_transfer_ix = '".$lineKey."'",4) == "0000-00-00 00:00:00") {
									array_push($addTrfList,$lineKey);
								}
							}
							// Add code to flag previous transfer records that are being completed with this send transfer for transfer to all other properties
							break;
						case "tc_transfer_table":
							break;
							$update = array("tc_trf_tbl_recs_imp","tc_trf_tbl_last_imp_rec");
							for ($c=0;$c<$fieldCount;$c++){
								if (!in_array($fieldList[$c],$update)) {
									$fieldList[$c] = "";
								}
							}
							#debug("tc_transfer_table:",$fieldList,$values);
							// Add code to flag previous transfer records that are being completed with this send transfer for transfer to all other properties
							break;
						}
					} else {
						# On the Offline server
						switch ($table) {
						case "tc_transfer":
							$update = array("tc_trf_time_imp_start","tc_trf_time_imp_end","sc_transfer_id");
							for ($c=0;$c<$fieldCount;$c++) {
								if (!in_array($fieldList[$c],$update)) {
									$fieldList[$c] = "";
								}
							}
							break;
						}
					}

					# Run an update query
					$sql = "UPDATE ".$table." SET ";
					$sqladd = "";
					$commaCount = 0;
					for ($b=0;$b<$fieldCount;$b++) {
						if (!in_array($b,$tableKeyCount)) {
							if ($fieldList[$b] != "") {
								if ($commaCount != "0") {
									$sqladd .= ", ";
								}
								$sqladd .= $fieldList[$b] . " = '".$values[$b]."'";
								$commaCount++;
							}
						}
					}
					if ($sqladd == "") {
						setProgressReport("Error building update query",1);
						return 0;
					}
					$sql .= $sqladd;
					$sql .= " WHERE ".$tableKeyField." = '".$lineKey."'";
				} else {
					# Do an insert
					$GLOBALS['incrementSequence'] = "0";
					$sql = "INSERT INTO ".$table." (".join(",",$fieldList).") VALUES ('".join("', '",$values)."')";
				}
				$GLOBALS['flagChngs'] = "0";
				$sql = str_replace("'|null|'","NULL",$sql);

				set_timezone('UTC');
				$result = $lDB->put($sql);
				$GLOBALS['incrementSequence'] = "1";
				set_timezone($originalTimezone);

				if(!$result) {
					$error = htmlspecialchars($lDB->error);
					setProgressReport("Unable to insert/update a record from ".$table.". (MySQL said: ".$error.")",1);
					return 0;
				}

				if ($GLOBALS['isWebServer']) {
					$tempFlag = $GLOBALS['flagChngs'];
					$GLOBALS['flagChngs'] = "0";
					$rfDbCodeList = db_tr_rule_get_remote_codes($table,$lineKey,$remoteTransferDB);
					foreach($rfDbCodeList as $rf_db_code) {
						db_tc_property_trf_insert($rf_db_code,$tableId,$lineKey);
					}
					$GLOBALS['flagChngs'] = $tempFlag;
				}
				$GLOBALS['flagChngs'] = "1";
			} elseif ($table == "td_deletions") {
				# For td_deletions
				if ($amax != "2") {
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				$tableName = $lDB->get("SELECT tc_table_name FROM tc_table WHERE tc_table_id = '".$values[0]."'",4);
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to delete a record. (MySQL said: ".$error.")",1);
					return 0;
				}
				if (in_array($tableName,$mysqlTableInfoList)) {
					$keyCount = $mysqlTableInfoList[$tableName]['count'];
					$keyField = $mysqlTableInfoList[$tableName]['keyfield'];
				} else {
					$tableKey = getMysqlTableKeysDT30($tableName,$lDB);
					$keyCount = $tableKey['count'];
					$keyField = $tableKey['field'];
				}

				$lineKey = $values[1];
				$sql = "DELETE FROM ".$tableName." WHERE ".$keyField." = '".$lineKey."'";
				$GLOBALS['flagChngs'] = "0";
				$result = $lDB->put($sql);
				if(!$result) {
					$error = htmlspecialchars($lDB->error);
					setProgressReport("Unable to delete a record from ".$tableName.". (MySQL said: ".$error.")",1);
					return 0;
				}

				// If on the web - update the td_prop_deletions for the other tables
				if ($GLOBALS['isWebServer']) {
					$tempFlag = $GLOBALS['flagChngs'];
					$GLOBALS['flagChngs'] = "0";
					$rfDbCodeList = db_tr_rule_get_remote_codes($table,$lineKey,$remoteTransferDB);
					foreach($rfDbCodeList as $rf_db_code) {
						db_td_prop_deletions_insert($rf_db_code,$values[0],$lineKey);
					}
					$GLOBALS['flagChngs'] = $tempFlag;
				}
				$GLOBALS['flagChngs'] = "1";
			} elseif($table == "tc_res_update") {
				# For tc_res_update
				if ($amax != "2") {
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				// Update the reservation.... values[0] = tc_res_update_id, values[1] = rv_reservation_id
				$GLOBALS['transferResUpdate'] = true;
				recalcTotals($values[1]);
				$GLOBALS['transferResUpdate'] = false;

				// If on the web - update the tc_prop_res_update for other environments
				if ($GLOBALS['isWebServer']) {
					$varName = "non".$remoteTransferDB."List";
					$varList = isset($GLOBALS[$varName])?$GLOBALS[$varName]:"";
					$rfDbCodeList = $varList;
					if (!is_array($varList)) {
						$rfDbCodeList = db_rf_database_get_remote_codes($remoteTransferDB);
						$GLOBALS[$varName] = $rfDbCodeList;
					}

					$tempFlag = $GLOBALS['flagChngs'];
					$GLOBALS['flagChngs'] = "0";
					$recordKey = $lineKey;
					$jmax = sizeof($rfDbCodeList);
					for ($j=0;$j<$jmax;$j++) {
						$rfDbCode = $rfDbCodeList[$j];
						$count = $lDB->get("SELECT COUNT(*) FROM tc_prop_res_update WHERE rf_db_code = '$rfDbCode' AND rv_reservation_id = '".$values[1]."'",4);
						if ($count < 1) {
							$lDB->put("
								INSERT IGNORE INTO tc_prop_res_update (
									tc_prop_res_update_id,
									rf_db_code,
									rv_reservation_id
								) VALUES (
									GET_UUID(),
									'$rfDbCode',
									'".$values[1]."'
								)
							");
						}
					}
					$GLOBALS['flagChngs'] = $tempFlag;
				}
				$GLOBALS['flagChngs'] = "1";
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to add reservation update. (MySQL said: ".$error.")",1);
					return 0;
				}
			} elseif($table == "tc_prop_stock_update") {
				# For tc_prop_stock_update
				if ($amax != "3") {
					setProgressReport("Invalid field count ($amax) for ".$table,1);
					return 0;
				}

				// Update the reservation.... values[0] = tc_res_update_id, values[1] = rv_reservation_id
				// Process the stock updates....
				//   values[0] = ac_accomm_type_id
				//   values[1] = tc_prop_stock_date
				//   values[2] = tc_prop_stock_type_ind
				list($ac_accomm_type_id,$tc_prop_stock_date,$tc_prop_stock_type_ind) = $values;
				if(!array_key_exists($ac_accomm_type_id,$stockUpdates)) {
					$stockUpdates[$ac_accomm_type_id] = array();
				}
				if(!array_key_exists($tc_prop_stock_type_ind,$stockUpdates[$ac_accomm_type_id])) {
					$stockUpdates[$ac_accomm_type_id][$tc_prop_stock_type_ind] = array();
				}
				$stockUpdates[$ac_accomm_type_id][$tc_prop_stock_type_ind][] = $tc_prop_stock_date;

				// If on the web - update the tc_prop_stock_update for other environments
				if ($GLOBALS['isWebServer']) {
					$varName = "non".$remoteTransferDB."List";
					$rfDbCodeList = $GLOBALS[$varName];
					if (!is_array($GLOBALS[$varName])) {
						$rfDbCodeList = db_rf_database_get_remote_codes($remoteTransferDB);
						$GLOBALS[$varName] = $rfDbCodeList;
					}

					$tempFlag = $GLOBALS['flagChngs'];
					$GLOBALS['flagChngs'] = "0";
					$recordKey = $lineKey;
					$jmax = sizeof($rfDbCodeList);
					for ($j=0;$j<$jmax;$j++) {
						$rfDbCode = $rfDbCodeList[$j];
						$count = $lDB->get("
							SELECT
								COUNT(*)
							FROM
								tc_prop_stock_update
							WHERE
								rf_db_code = '$rfDbCode'
								AND ac_accomm_type_id = '".$values[0]."'
								AND tc_prop_stock_date = '".$values[1]."'
								AND tc_prop_stokc_type_ind = '".$values[2]."'
						",4);
						if ($count < 1) {
							$lDB->put("
								INSERT IGNORE INTO tc_prop_stock_update (
									ac_accomm_type_id,
									tc_prop_stock_date,
									tc_prop_stock_type_ind,
									rf_db_code
								) VALUES (
									'".$values[0]."',
									'".$values[1]."',
									'".$values[2]."',
									'$rfDbCode'
								)
							");
						}
					}
					$GLOBALS['flagChngs'] = $tempFlag;
				}
				$GLOBALS['flagChngs'] = "1";
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to add reservation update. (MySQL said: ".$error.")",1);
					return 0;
				}
			}
			$fileLine = "";
		} else {
			//$fileLine .= "\n"; // \r & \n are now encoded.
			$fileLine .= "";
		}
		$diffTime = time() - $startTime;
		if($diffTime > 10) { // If 10 seconds (or more) has elapsed, send something down the line to prevent timeout
			setProgressReport(".");
			$startTime = time();
		}
	}

	if($table == "tc_prop_stock_update") {
		$today = date("Y-m-d");
		foreach($stockUpdates as $ac_accomm_type_id=>$components) {
			$stock = new Stock($ac_accomm_type_id);
			$allDates = array();
			foreach($components as $component=>$dates) {
				$dates = array_unique($dates);
				$allDates = array_merge($allDates,$dates);
				$stock->ClearCache(db_tc_prop_stock_update_code($component), $dates, true);
			}
			if($GLOBALS['isWebServer']) {
				$allDates = array_unique($allDates);
				$stock->NotifyCache($allDates);
			}
			unset($allDates);
			unset($stock);
		}
		unset($today);
	}

	if ($table != "tc_transfer" && $table != "tc_transfer_table") {
		$tmptmp = $GLOBALS['flagChngs'];
		$GLOBALS['flagChngs'] = 1;
		$sql = "UPDATE tc_transfer_table SET tc_trf_tbl_recs_imp = '".$rowCounter."', tc_trf_tbl_last_imp_rec = '".$lineKey."' WHERE tc_transfer_id = '".$transferId."' AND tc_table_id = '".$tableId."'";
		$GLOBALS['lDB']->put($sql);
		$GLOBALS['flagChngs'] = $tmptmp;
	}

	setProgressReport(" + Imported ".$table." [".$rowCounter."]..");

	$tc_transfer_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer'",4);
	$tc_transfer_table_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer_table'",4);
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = 0;
	if ($GLOBALS['isWebServer']) {
		// Special for sending updated transfer records
		if ($table == "tc_transfer") {
			$rfDbCodeList = db_rf_database_get_remote_codes($GLOBALS['dbcode']);

			$jmax = sizeof($rfDbCodeList);
			for ($j=0;$j<$jmax;$j++) {
				$rfDbCode = $rfDbCodeList[$j];
				if ($GLOBALS['dbcode'] != $rfDbCode) {
					$nmax = sizeof($addTrfList);
					for ($n=1;$n<$nmax;$n++) {
						$lineTrfId = $addTrfList[$n];
						if ($lineTrfId != $transferId) {
							$count = $lDB->get("SELECT COUNT(*) FROM tc_property_trf WHERE rf_db_code = '".$rfDbCode."' AND tc_table_id = '".$tc_transfer_table_key."' AND tc_prop_record_id = '".$lineTrfId."'",4);
							if ($count == "0") {
								db_tc_property_trf_insert($rfDbCode,$tc_transfer_key,$lineTrfId);

								$list = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id = '$lineTrfId'",3);
								foreach($list as $item) {
									db_tc_property_trf_insert($rfDbCode,$tc_transfer_table_key,$item);
								}
							}
						}
					}
				}
			}
		}
	}
	$GLOBALS['flagChngs'] = $tmptmp;

	if ($table != "tc_transfer" && $table != "tc_transfer_table" && $table != "td_deletions" && $table != "tc_res_update" && $table != "tc_prop_stock_update") {
		$sql = "
			SELECT
				tc_transfer_table.tc_trf_tbl_recs_exp,
				tc_transfer_table.tc_trf_tbl_recs_imp
			FROM
				tc_transfer_table
				INNER JOIN tc_transfer ON tc_transfer.tc_transfer_ix = tc_transfer_table.tc_transfer_id
			WHERE
				tc_transfer_table.tc_transfer_id = '".$transferId."'
				AND tc_transfer_table.tc_table_id = '".$tableId."'
			ORDER BY
				tc_transfer.tc_trf_time_start DESC,
				tc_transfer_table.tc_transfer_table_id DESC
		";
		$check = $lDB->get($sql,1);
		if ($check['tc_trf_tbl_recs_exp'] != $check['tc_trf_tbl_recs_imp']) {
			setProgressReport("Table: ".$table." import unsuccessful: ".$check['tc_trf_tbl_recs_exp']." ?= ".$check['tc_trf_tbl_recs_imp'],1);
			return 0;
		}
	}

	return 1;
}

function undoFileDT20($TDfilePath,$fileName) {

	global $lDB;
	global $dbcode;
	global $TDfilePath;
	global $mysqlTableInfoList;
	global $remoteTransferDB;

	if (!is_array($mysqlTableInfoList)) {
		$mysqlTableInfoList = array();
	}

	# Step 1 - Get the table information
	$table = str_replace(".txt","",$fileName);
	if ($table != "td_deletions" && $table != "tc_res_update" && $table != "tc_prop_stock_update") {
		if (!in_array($table,$mysqlTableInfoList)) {
			# Get the table information manually
			$tableKey = getMysqlTableKeysDT30($table,$lDB);
			$tableKeyCount = $tableKey['count'];
			$tableKeyField = $tableKey['field'];

			$tableFieldList = $lDB->get("show fields from ".$table,2);
			$fieldList = array();
			$amax = sizeof($tableFieldList);
			for ($a=0;$a<$amax;$a++) {
				array_push($fieldList,$tableFieldList[$a]['Field']);
			}
			$fieldCount = $amax;

			$tableId = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = '".$table."'",4);

			$mysqlTableInfoList[$table] = array("count" => $tableKeyCount, "keyfield" => $tableKeyField, "tableId" => $tableId);
		} else {
			# Get the table information from the stored array
			$tableKeyCount = $mysqlTableInfoList[$table]['count'];
			$tableKeyField = $mysqlTableInfoList[$table]['keyfield'];
			$tableId = $mysqlTableInfoList[$table]['tableId'];
			$fieldList = $mysqlTableInfoList[$table]['fieldList'];

			# In case we have incomplete table data
			if ($fieldList == "") {
				$tableFieldList = $lDB->get("show fields from ".$table,2);
				$fieldList = array();
				$amax = sizeof($tableFieldList);
				for ($a=0;$a<$amax;$a++) {
					array_push($fieldList,$tableFieldList[$a]['Field']);
				}
				$mysqlTableInfoList[$table]['fieldList'] = $fieldList;
			}
			$fieldCount = sizeof($fieldList);
		}
	}

	# Step 2 - Open file
	if (!is_file($TDfilePath.$fileName)) {
		setProgressReport("Unable to find ".$TDfilePath.$fileName,1);
		return 0;
	}
	$fp = fopen($TDfilePath.$fileName,"rb");
	if ($fp == false) {
		setProgressReport("Unable to open ".$TDfilePath.$fileName,1);
		return 0;
	}

	# Step 3 - Undo each line
	$fileLine = "";
	while (!feof($fp)) {
		# Add data to the $fileLine string
		$fileLine .= trim(fgets($fp,65536));

		# If we have the end of line charachter, import this line
		if (substr($fileLine,strlen($fileLine)-5,5) == "|eol|") {
			$fileLine = str_replace("|eol|","",$fileLine);
			$values = explode("','",$fileLine);
			$amax = sizeof($values);

			if ($table != "td_deletions" && $table != "tc_res_update" && $table != "tc_prop_stock_update") {
				if ($amax != $fieldCount) {
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				# Verify the values in the line won't break the sql statement
				$lineKey = "";
				for($a=0;$a<$amax;$a++) {
					$values[$a] = str_replace("'","",$values[$a]);
					$values[$a] = str_replace('"',"",$values[$a]);
					if (substr($values[$a],strlen($values[$a])-1,1) == "\\") {
						$values[$a] .= " ";
					}
					$values[$a] = str_replace("|return|","\r",$values[$a]);
					$values[$a] = str_replace("|newline|","\n",$values[$a]);
					$values[$a] = str_replace("|/return|","|return|", $values[$a]);
					$values[$a] = str_replace("|/newline|","|newline|", $values[$a]);
					if (in_array($a,$tableKeyCount)) {
						$lineKey .= $values[$a];
					}
				}

				/*
				// A Aborting sequence should come here somewhere
				$sql = "select count(*) from ".$table." where ".$tableKeyField." = '".$lineKey."'";
				$count = $lDB->get($sql,4);
				if ($count > 0) {
				*/

				$GLOBALS['flagChngs'] = "0";
				if ($GLOBALS['isWebServer']) {
					# Insert the tc_property_trf record
					db_tc_property_trf_insert($remoteTransferDB,$tableId,$lineKey);
				} else {
					# Run an update query
					$lDB->put("UPDATE ".$table." SET ".$table."_trf_yn = '0' WHERE ".$tableKeyField." = '".$lineKey."'");
				}
				$GLOBALS['flagChngs'] = "1";
			} elseif($table == "td_deletions") {
				# For td_deletions
				if ($amax != "2") {
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				if ($GLOBALS['isWebServer']) {
					$sql = "INSERT IGNORE INTO td_prop_deletions VALUES ('".$remoteTransferDB."','".join("', '",$values)."')";
				} else {
					$sql = "INSERT INTO ".$table." VALUES ('".join("', '",$values)."')";
				}
				$lDB->put($sql);
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to recreate a delete entry in ".$table.". (MySQL said: ".$error.")",1);
					return 0;
				}
			} elseif($table == "tc_res_update") {
				# For tc_res_update
				if ($amax != "2") {
					setProgressReport("Invalid field count for ".$table,1);
					return 0;
				}

				if ($GLOBALS['isWebServer']) {
					$sql = "INSERT IGNORE INTO tc_prop_res_update VALUES ('".$values[0]."','".$remoteTransferDB."','".$values[1]."')";
				} else {
					$sql = "INSERT INTO ".$table." VALUES ('".join("', '",$values)."')";
				}
				$lDB->put($sql);
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to recreate a reservation update entry in ".$table.". (MySQL said: ".$error.")",1);
					return 0;
				}
			} elseif($table == "tc_prop_stock_update") {
				# For tc_prop_stock_update
				if ($amax != "3") {
					setProgressReport("Invalid field count ($amax) for ".$table,1);
					return 0;
				}

				if ($GLOBALS['isWebServer']) {
					$rfDbCode = $remoteTransferDB;
				} else {
					$rfDbCode = "WA";
				}

				$sql = "
					INSERT IGNORE INTO tc_prop_stock_update VALUES (
						'".$values[0]."',
						'".$values[1]."',
						'".$values[2]."',
						'".$rfDbCode."'
					)
				";

				$lDB->put($sql);
				$error = htmlspecialchars(mysqli_error($lDB->conn), ENT_QUOTES);
				if ($error != "") {
					setProgressReport("Unable to recreate a stock update entry in ".$table.". (MySQL said: ".$error.")",1);
					return 0;
				}
			}
			$fileLine = "";
		} else {
//			$fileLine .= "\n";
			$fileLine .= "";
		}
	}

	return 1;
}

function importTransferFilesDT22($transferPath,$update=true,$notSendTransfer=true) {

	global $lDB;
	global $transferId;
	global $dbcode;
	global $transferState;

	# Step 1 - Verify transfer folder
	if (!is_dir($transferPath)) {
		setProgressReport("Report folder missing",1);
		return 0;
	}
	if (!is_file($transferPath."tc_transfer.txt")) {
		setProgressReport("Control files missing",1);
		return 0;
	} else {
		// tc_sequence should be first
		if (is_file($transferPath."tc_sequence.txt")) {
			if (!importTableFromFileDT19($transferPath."tc_sequence.txt")) {
				setProgressReport("Error importing tc_sequence.txt",1);
				return 0;
			}
		}
		if ($notSendTransfer || !$GLOBALS['isWebServer']) {
			if (!importTableFromFileDT19($transferPath."tc_transfer.txt")) {
				setProgressReport("Error importing tc_transfer.txt",1);
				return 0;
			}
		}
		if (is_file($transferPath."tc_transfer_table.txt")) {
			if (!importTableFromFileDT19($transferPath."tc_transfer_table.txt")) {
				setProgressReport("Error importing tc_transfer_table.txt",1);
				return 0;
			}
		}
	}

	# Step 2 - Check the folders, and possible tc_table.txt file
	if (!is_dir($transferPath)) {
		setProgressReport("Unable to open transfer folder",1);
	}
	if (is_file($transferPath."tc_table.txt")) {
		if (!importTableFromFileDT19($transferPath."tc_table.txt")) {
			setProgressReport("Error importing tc_table.txt",1);
			return 0;
		}
	}
	$sql = "SELECT tc_table_name FROM tc_table WHERE tc_table_sys_code < 5 ORDER BY tc_table_seq";
	$list = $lDB->get($sql,3);

	# Step 3 - Update import_start time
	if ($update) {
		$now = date("Y-m-d H:i:s");
		$sql = "UPDATE tc_transfer SET tc_trf_time_imp_start = '".$now."', tc_trf_time_imp_start_tz = '".date("e")."' WHERE tc_transfer.tc_transfer_ix = '".$transferId."'";
		$lDB->put($sql);
	}

	# Step 4 - Import each transfer file
	$imax = sizeof($list);
	for ($i=0;$i<$imax;$i++) {
		$fileName = $list[$i].".txt";
		# Skip the tc_table table
		if ($fileName != "tc_table.txt" && $fileName != "tc_transfer.txt" && $fileName != "tc_transfer_table.txt" && $fileName != "tc_sequence.txt") {
			# Verify this file exist
			if (is_file($transferPath.$fileName)) {
				if (!importTableFromFileDT19($transferPath.$fileName)) {
					setProgressReport("Error importing ".$fileName,1);
					return 0;
				}
			}
		}
	}

	# Step 5 - Update import_end time
	$now = date("Y-m-d H:i:s");
	if ($update) {
		$sql = "update tc_transfer set tc_trf_time_imp_end = '".$now."', tc_trf_time_imp_end_tz = '".date("e")."' where tc_transfer.tc_transfer_ix = '".$transferId."'";
		$lDB->put($sql);
	}

	if ($GLOBALS['dbcode'][0] != "W") {
		$import = makeDateTime($now);
		if ($transferState == "send") {
			updateTimeValue("importTime",join(" ",$import));
		} else {
			updateTimeValue("recieveTime",join(" ",$import));
		}
	}

	return 1;
}

function getMysqlTableKeysDT30($table,$lDB) {

	$sql = "SELECT tc_table_key_ind FROM tc_table WHERE tc_table_name = '".$table."'";
	$tableKeyInfo = $lDB->get($sql,4);
	$result = array();

	switch ($tableKeyInfo) {
	case 0:
		$key = $table."_ix";
		$count = array("2");
		break;
	case 1:
		$key = $table."_id";
		$count = array("0");
		break;
	case 2:
		$key = $table."_ix";
		$count = array("2");
		break;
	case 3:
		$key = $table."_ix";
		$count = array("2");
		break;
	}

	$result['count'] = $count;
	$result['field'] = $key;

	return $result;
}

function deleteRecursiveDT31($file) {
	# Step 1 - set file/folder rights to 777
	chmod($file,0777);

	# Step 2 - test if folder
	if (is_dir($file)) {
		# Delete all contents and then the folder
		$dp = opendir($file);
		while($fileName = readdir($dp)) {
			if ($fileName != "." && $fileName != "..") {
				# Delete sub-file/folder recursively
				deleteRecursiveDT31($file."/".$fileName);
			}
		}
		closedir($dp);
		rmdir($file);
	} else {
		# Delete file
		unlink($file);
	}
}

function splitTransferFileDT36($filename) {
	$parts = preg_split("/[_.]/",$filename);
	$parts = array_pad($parts,7,"");

	$detail = array();
	$detail['principal'] = $parts[0];
	$detail['transfer_id'] = $parts[1];
	$detail['transfer_db'] = substr($parts[1],0,2);
	$detail['date'] = $parts[2];
	$detail['time'] = $parts[3];
	$detail['dbcode'] = $parts[4];
	$detail['userid'] = $parts[5];
	$detail['ext'] = $parts[6];

	return $detail;
}

define("TRANSFER_DIR_SEND","send");
define("TRANSFER_DIR_RECEIVE","receive");
define("TRANSFER_DIR_REPORT","report");
define("TRANSFER_DIR_LOG","log");
define("TRANSFER_DIR_ROCKETMAILER","rocketmailer");
define("TRANSFER_DIR_TIMEZONEFIX","timezonefix");
define("TRANSFER_DIR_SURVEY_BATCHES","surveybatches");

function getTransferDirDT37($filename,$section=TRANSFER_DIR_SEND, $parent='') {
	global $principal_id;
	global $isWebServer;
	global $dbcode;

	$detail = splitTransferFileDT36($filename);

	if (isset($detail['date']) && !empty($detail['date'])) {
		$transferDir = $parent.$GLOBALS['DTdir'];

		if(!is_dir($transferDir)) {
			mkdir($transferDir);
		}

		$transferDir .= $principal_id . "/";
		if(!is_dir($transferDir)) {
			mkdir($transferDir);
		}

		$transferDir .= $detail['transfer_db'] . "/";
		if(!is_dir($transferDir)) {
			mkdir($transferDir);
		}

		list($year,$month,$day) = explode("-",$detail['date']);
		$transferDir .= $year . "-" . $month . "/";
		if(!is_dir($transferDir)) {
			mkdir($transferDir);
		}

		$transferDir .= $section."/";
		if(!is_dir($transferDir)) {
			mkdir($transferDir);
		}

		if(!is_dir($transferDir)) {
			return false;
		}
	} else {
		return false;
	}

	return $transferDir;
}

function setProgressReport($message,$mode="0") {

	global $dbcode;
	global $logFile;
	global $transferName;

	if(!isset($GLOBALS['tdPendingLogData'])) { $GLOBALS['tdPendingLogData'] = ""; }

	if (!$logFile) {
		if ($transferName != "") {
			$logStash = getTransferDirDT37($transferName,TRANSFER_DIR_LOG);
			$logFile = fopen($logStash.$transferName.".log","a+");
			$temp = explode("|||",$GLOBALS['tdPendingLogData']);
			$amax = sizeof($temp);
			for($a=0;$a<$amax;$a++) {
				$currentTime = date("Y-m-d H:i:s") .": ";
				fwrite($logFile,$currentTime.$temp[$a]."\r\n");
			}
		}
	}

	if($mode != "2") {
		$b1 = "";
		$b2 = "";
		if ($mode=="1") {
			$b1 = "<b>";
			$b2 = "</b>";
		}
		if ($GLOBALS['dbcode'][0] != "W") {
			echo "<!--";
			for($a=0;$a<(3963-(strlen($message)));$a++) { echo "#"; }
			echo "-->\n";
			echo "<script>document.getElementById('displayDiv').innerHTML += '".$b1.$message.$b2.".<br>';document.getElementById('displayDiv').scrollTop = document.getElementById('displayDiv').scrollHeight;</script>\n";
		} else {
			echo $b1.$message.$b2.".<br>";
		}
	}
	if ($logFile) {
		$currentTime = date("Y-m-d H:i:s") .": ";
		fwrite($logFile,$currentTime.$message.". \r\n");
	} else {
		$GLOBALS['tdPendingLogData'] .= $message.". |||";
	}
	ob_flush();
	flush();
}


function callException($msgId) {
	global $lDB;
	global $transferId;

	$sql = "UPDATE tc_transfer SET sc_transfer_id = '".$msgId."' WHERE tc_transfer.tc_transfer_ix = '".$transferId."'";
	$lDB->put($sql);
}


function splitURI($uri) {
	$matches = array();
	preg_match("/(.+?):(?:\/\/){0,1}(?:()(?::(.+)){0,1}){0,1}([^\/:]+){0,1}(?::(\d+)){0,1}(?:\/([^?#]+)){0,1}(?:\?([^#]+)){0,1}(?:#(.+)){0,1}/",$uri,$matches);

	$result = array();

	$result['uri'] = $uri;
	if(!empty($matches[1])) { $result['protocol'] = strtolower($matches[1]); }
	if(!empty($matches[2])) { $result['user'] = $matches[2]; }
	if(!empty($matches[3])) { $result['password'] = $matches[3]; }
	if(!empty($matches[4])) { $result['host'] = $matches[4]; }
	if(!empty($matches[5])) { $result['port'] = $matches[5]; } else {
		if($result['protocol'] == "ftp") { $result['port'] = "21"; }
		if($result['protocol'] == "http") { $result['port'] = "80"; }
		if($result['protocol'] == "https") { $result['port'] = "443"; }
	}
	if(!empty($matches[6])) {
		$result['path'] = explode("/",rtrim($matches[6],"/"));
	} else {
		$result['path'] = array();
	}
	$result['query'] = array();
	if(!empty($matches[7])) {
		$list = explode("&",$matches[7]);
		foreach($list as $item) {
			$queryItems = explode("=",$item);
			if(sizeof($queryItems) > 1) {
				list($key,$value) = $queryItems;
			} else {
				$key = $item;
				$value = "";
			}
			$result['query'][$key] = $value;
		}
	}
	if(!empty($matches[8])) { $result['fragment'] = $matches[8]; }
	return $result;
}

function testSplitURI() {
	//$url = "http://site.something.com";
	//$url = "http://site.something.com/directory";
	//$url = "http://site.something.com/directory/#anchor";
	//$url = "http://usersite.something.com/directory";
	//$url = "http://user:passwordsite.something.com/directory";
	//$url = "http://user:passwordsite.something.com:88/directory";
	//$url = "http://user:passwordsite.something.com:88/directory/";
	//$url = "http://user:passwordsite.something.com:88/directory/subdir/#anchor";
	//$url = "http://user:passwordsite.something.com:88/directory/subdir/?thing=another&one=1";
	//$url = "http://user:passwordsite.something.com:88/directory/subdir/file.php?something=whatever&anotherthing=somethingelse#anchor";
	//$url = "ftp://ftp.somewhere.com";
	//$url = "ftp://ftp.somewhere.com/";
	//$url = "ftp://ftp.somewhere.com/directory";
	//$url = "ftp://ftp.somewhere.com/directory/";
	//$url = "ftp://ftp.somewhere.com/directory/filename.txt";
	//$url = 'http://www.google.com/search?hl=en&lr=&c2coff=1&rls=GGLG%2CGGLG%3A2005-26%2CGGLG%3Aen&q=http%3A%2F%2Fwww.google.com%2Fsearch%3Fhl%3Den%26lr%3D%26c2coff%3D1%26rls%3DGGLG%252CGGLG%253A2005-26%252CGGLG%253Aen%26q%3Dhttp%253A%252F%252Fwww.google.com%252Fsearch%253Fhl%253Den%2526lr%253D%2526c2coff%253D1%2526rls%253DGGLG%25252CGGLG%25253A2005-26%25252CGGLG%25253Aen%2526q%253Dhttp%25253A%25252F%25252Fwww.google.com%25252Fsearch%25253Fsourceid%25253Dnavclient%252526ie%25253DUTF-8%252526rls%25253DGGLG%25252CGGLG%25253A2005-26%25252CGGLG%25253Aen%252526q%25253Dhttp%2525253A%2525252F%2525252Fwww%2525252Egoogle%2525252Ecom%2525252Fsearch%2525253Fsourceid%2525253Dnavclient%25252526ie%2525253DUTF%2525252D8%25252526rls%2525253DGGLG%2525252CGGLG%2525253A2005%2525252D26%2525252CGGLG%2525253Aen%25252526q%2525253Dhttp%252525253A%252525252F%252525252Fuk2%252525252Emultimap%252525252Ecom%252525252Fmap%252525252Fbrowse%252525252Ecgi%252525253Fclient%252525253Dpublic%2525252526GridE%252525253D%252525252D0%252525252E12640%2525252526GridN%252525253D51%252525252E50860%2525252526lon%252525253D%252525252D0%252525252E12640%2525252526lat%252525253D51%252525252E50860%2525252526search%252525255Fresult%252525253DLondon%25252525252CGreater%252525252520London%2525252526db%252525253Dfreegaz%2525252526cidr%252525255Fclient%252525253Dnone%2525252526lang%252525253D%2525252526place%252525253DLondon%252525252CGreater%252525252BLondon%2525252526pc%252525253D%2525252526advanced%252525253D%2525252526client%252525253Dpublic%2525252526addr2%252525253D%2525252526quicksearch%252525253DLondon%2525252526addr3%252525253D%2525252526scale%252525253D100000%2525252526addr1%252525253D%2526btnG%253DSearch%26btnG%3DSearch&btnG=Search';
	//$url = "file:///home/light/file.txt";
	//$url = "mailto:dylanbresrequest.com";
}

function parseHTTPResponse($response) {
	if(empty($response) || !is_string($response)) {
		return array('error'=>true,'reason'=>"Invalid response string");
	}

	$response = explode("\r\n",$response);

	$type = array_shift($response);
	$headers = array();

	$item = true;
	while(sizeof($response) > 0 && !empty($item)) {
		$item = array_shift($response);
		$headerItems = explode(": ",$item);
		if(sizeof($headerItems) > 1) {
			list($key,$value) = $headerItems;
		} else {
			$key = $item;
			$value = "";
		}
		$headers[$key] = $value;
	}
	array_pop($headers);
	return array(
		'error'=>false,
		'reason'=>"Ok",
		'protocol'=>$type,
		'headers'=>$headers,
		'body'=>join("\r\n",$response)
	);
}

function fwrite_stream($fp, $string) {
	for($written = 0; $written < strlen($string); $written += $fwrite) {
		$fwrite = fwrite($fp, substr($string, $written));
		if($fwrite === false || $fwrite == 0) {
			return $written;
		}
	}
    return $written;
}

function postHTTP($url, $post = array(), $files = array()) {
	global $curlSettingsDT;

	if(empty($url) || !is_string($url)) {
		return array('error'=>true,'reason'=>"Invalid URL");
	} else {
		$url = splitURI($url);
		if(!in_array($url['protocol'], array("http","https"))) {
			return array('error'=>true,'reason'=>"Invalid URL");
		}
	}

	if(!is_array($post)) {
		return array('error'=>true,'reason'=>"Invalid POST data");
	}

	if(!is_array($files)) {
		return array('error'=>true,'reason'=>"Invalid files array");
	}

	$post = "";
	$postData = array(); // Files to upload

	foreach($files as $key=>$file) {
		$postData[$key] = curl_file_create ($file['tmp_name']);
	}

	$timeout = 0;
	$errno = 0;
	$errstr = "";

	ini_set('track_errors', 1);

	$additionalHeaders = array(
		'Expect:', // Stop cURL from adding "HTTP/1.1 100 Continue" header.
		'Accept:', // Stop cURL from adding "Accept: */*" header.
		'Connection: close'
	);

	if($curlSettingsDT[CURLOPT_SSL_VERIFYPEER] !== true || $curlSettingsDT[CURLOPT_SSL_VERIFYHOST] != 2) {
		error_log("Notice: cURL HTTPS verification settings for DTs has been modified.");
	}

	$ch = curl_init();

	// cURL options.
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt_array($ch, $curlSettingsDT);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_HEADER, true);
	curl_setopt($ch, CURLOPT_HTTPHEADER, $additionalHeaders);
	curl_setopt($ch, CURLOPT_PORT , $url['port']);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);

	if ($url['protocol'] == "https") {
		reset($url);
		curl_setopt($ch,CURLOPT_URL, 'https://'.$url['host']."/".$url['path'][0]."?".key($url['query']));
		if($timeout > 0) {
			curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); 
		} else {
			curl_setopt($ch, CURLOPT_TIMEOUT, 30); 
		}
	} else {
		curl_setopt($ch,CURLOPT_URL, $url['uri']);
		if($timeout > 0) {
			curl_setopt($ch, CURLOPT_TIMEOUT, $timeout); 
		} else {
			curl_setopt($ch, CURLOPT_TIMEOUT, 30); 
		}
	}

	$response = curl_exec($ch);

	if(curl_errno($ch)) {
		return array('error'=>true,'reason'=>"cURL error: (" . curl_errno($ch) . ") " . curl_error($ch));
	}

	curl_close($ch);

	return array('error'=>false,'reason'=>"Ok",'response'=>parseHTTPResponse($response));
}
