<?php

function displayPasswordScreenDT1() {

	global $transferId;
	global $trDataBuffer;
	global $trDataPassword;
	global $sysLocked;

	$trDataBuffer['password'] = $trDataPassword;
	$trDataBuffer['recieveOnly'] = "";
	$trDataBuffer['sendRecieve'] = "";
	$trDataBuffer['dataUpgrade'] = "";

	# Step 1 - Verify valid trdata folder -- OBSOLETE

	if ($sysLocked) {
		$trDataBuffer['sendRecieve'] .= " disabled";
		$trDataBuffer['recieveOnly'] .= " disabled";
		$trDataBuffer['dataUpgrade'] .= " disabled";

		$trDataBuffer['dataUpgrade'] .= " checked";
		if ($trDataBuffer['screenMessage'] == "") {
			$trDataBuffer['screenMessage'] = "<br>Transfers completed - awaiting new database from web.";
		}
		$trDataBuffer['screenMessage'] = "<b>Database Upgrade in progess:</b> ".$trDataBuffer['screenMessage'];
	} else {
		# Step 2 - Determine transfer state
		switch (determineTransferStateDT4()) {
		case 2:
			$trDataBuffer['recieveOnly'] .= " checked";

			$trDataBuffer['sendRecieve'] .= " disabled";
			$trDataBuffer['recieveOnly'] .= " disabled";
			$trDataBuffer['dataUpgrade'] = " disabled";
			break;
		case 1:
			$trDataBuffer['sendRecieve'] .= " checked";

			$trDataBuffer['sendRecieve'] .= " disabled";
			$trDataBuffer['recieveOnly'] .= " disabled";
			$trDataBuffer['dataUpgrade'] = " disabled";
			break;
		case 0:
			$trDataBuffer['sendRecieve'] .= " checked";
			$trDataBuffer['recieveOnly'] = "";
			$trDataBuffer['dataUpgrade'] = "";
			break;
		}
	}

	# Step 3 - output screen
	$HTML = join("",file(__DIR__ . "/../../../public/html/transfer_start.htm"));
	$HTML = showpage($trDataBuffer,$HTML);
	echo $HTML;
	flush();
	die();
}

function processTransferDT2() {

	global $transferId;
	global $trDataBuffer;
	global $sysLocked;

	$HTML = join("",file(__DIR__ . "/../../../public/html/transfer_details.htm"));

	# Step 1 - Verify valid trdata folder - OBSOLETE

	$result = determineTransferStateDT4();
	$HTML = showpage($trDataBuffer,$HTML);
	echo $HTML;
	flush();

	if (($sysLocked || $_POST['transferDirection'] == "5") && $result != "0") {
		setProgressReport("Starting Database Upgrade..");
	}

	# Step 2 - Determine transfer state
	switch ($result) {
	case 0:
		if ($sysLocked) {
			setProgressReport("Resuming database upgrade..",1);
			if (!testOnlineDT27()) {
				return 0;
			}
			downloadDBFromWebDT33();
		} else {
			setProgressReport("Starting new transfer..",1);
			processNewTransferDT5();
		}
		break;
	case 1:
		setProgressReport("Recovering send transfer..",1);
		// Recover send transfer;
		recoverTransferInfoDT32();
		if(recoverSendTransferDT25()) {
			processRecieveTransferDT23();
		}
		break;
	case 2:
		setProgressReport("Recovering receive transfer..",1);
		recoverTransferInfoDT32();
		recoverRecieveTransferDT28();
		break;
	}
	$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM tc_transfer WHERE tc_trf_time_close = '0000-00-00 00:00:00' AND tc_transfer_ix = '$transferId'",4);
	if($check <= 0) {
		echo "<script>document.getElementById('closeButton').innerHTML = 'OK';</script>";
		flush();
	}
}

function determineTransferStateDT4() {

	global $lDB;
	global $trDataBuffer;
	global $transferId;
	global $transferState;

	$trDataBuffer['screenMessage'] = "";
	$trDataBuffer['TRANSFERID'] = "";
	$trDataBuffer['STARTDATE'] = "";
	$trDataBuffer['EXTRACTTIME'] = "";
	$trDataBuffer['SENDTIME'] = "";
	$trDataBuffer['IMPORTEND'] = "";
	$trDataBuffer['TOTALTIME'] = "";

	# Step 1 - Find open recieve transfers
	$receive = $lDB->get("SELECT COUNT(*) FROM tc_transfer WHERE tc_trf_time_close = '0000-00-00 00:00:00' AND (tc_trf_source = '$GLOBALS[remoteDbCode]') AND tc_transfer_db = '$GLOBALS[dbcode]'",4);
	if ($receive > 0) {
		$data = $lDB->get("
			SELECT
				tc_transfer.tc_transfer_ix,
				tc_trf_time_start,
				tc_trf_time_extract,
				tc_trf_time_send,
				tc_trf_time_imp_end
			FROM
				tc_transfer
			WHERE
				tc_trf_time_close = '0000-00-00 00:00:00'
				AND tc_trf_source = '$GLOBALS[remoteDbCode]'
				AND tc_transfer_db = '$GLOBALS[dbcode]'
			ORDER BY
				tc_transfer_id desc
		",1);
		$start = makeDateTime($data[1]);
		$extract = makeDateTime($data[2]);
		$send = makeDateTime($data[3]);
		$import = makeDateTime($data[4]);

		$trDataBuffer['screenMessage'] .= "Recover open receive transfer<br> started on <b>$start[date]</b> at <b>$start[time]</b>.<br>";
		$trDataBuffer['TRANSFERID'] = $data[0];
		$transferId = $data[0];

		if ($receive > 1) {
			$lDB->put("UPDATE tc_transfer SET tc_trf_time_close = tc_trf_time_start WHERE tc_trf_time_close = '0000-00-00 00:00:00' AND tc_transfer_db != '$GLOBALS[dbcode]' AND tc_transfer.tc_transfer_ix != '$transferId'");
		}
		$trDataBuffer['STARTDATE'] = join(" ",$start);
		$trDataBuffer['EXTRACTTIME'] = join(" ",$extract);
		$trDataBuffer['SENDTIME'] = join(" ",$send);
		$trDataBuffer['IMPORTEND'] = join(" ",$import);
		return 2;
	}

	# Step 2 - Find open send transfers
	$send = $lDB->get("SELECT COUNT(*) FROM tc_transfer WHERE tc_trf_time_close = '0000-00-00 00:00:00' AND tc_trf_source = '$GLOBALS[dbcode]' AND tc_transfer_db = '$GLOBALS[dbcode]'",4);
	if ($send > 0) {
		$data = $lDB->get("
			SELECT
				tc_transfer.tc_transfer_ix,
				tc_trf_time_start,
				tc_trf_time_extract,
				tc_trf_time_send,
				tc_trf_time_imp_end
			FROM
				tc_transfer
			WHERE
				tc_trf_time_close = '0000-00-00 00:00:00'
				AND tc_trf_source = '$GLOBALS[dbcode]'
				AND tc_transfer_db = '$GLOBALS[dbcode]'",1);
		$start = makeDateTime($data[1]);
		$extract = makeDateTime($data[2]);
		$send = makeDateTime($data[3]);
		$import = makeDateTime($data[4]);

		$trDataBuffer['screenMessage'] .= "Recover an open send transfer<br> started on <b>$start[date]</b> at <b>$start[time]</b>.<br>";
		$trDataBuffer['TRANSFERID'] = $data[0];
		$transferId = $data[0];
		$trDataBuffer['STARTDATE'] = join(" ",$start);
		$trDataBuffer['EXTRACTTIME'] = join(" ",$extract);
		$trDataBuffer['SENDTIME'] = join(" ",$send);
		$trDataBuffer['IMPORTEND'] = join(" ",$import);
		return 1;
	}

	# Step 3 - Find open send transfers
	$data = $lDB->get("SELECT tc_trf_time_close FROM tc_transfer WHERE tc_transfer_db = '$GLOBALS[dbcode]' order by tc_trf_time_close desc LIMIT 1",4);
	$start = makeDateTime($data);
	if ($data > 0) {
		$trDataBuffer['screenMessage'] .= "Last transfer completed<br> on <b>$start[date]</b> at <b>$start[time]</b>.<br>";
	} else {
		$trDataBuffer['screenMessage'] .= "This is the first time you<br> will start a transfer.<br>";
	}
	return 0;
}

function processNewTransferDT5() {
	if ($_POST['transferDirection'] == "0" || $_POST['transferDirection'] == "5") {
		if (processSendTransferDT6()) {
			if(!processRecieveTransferDT23()) {
				return 0;
			}
		} else {
			return 0;
		}
	} else {
		if(!processRecieveTransferDT23()) {
			return 0;
		}
	}
	return 1;
}

function processSendTransferDT6($recoverStep=1) {

	global $lDB;
	global $transferId;
	global $transferName;
	global $transferDir;
	global $TDfilePath;
	global $transferState;

	global $sysLocked;

	# Set the global transferState
	$transferState = "send";

	if ($recoverStep <= 1) {
		# Step 1 - Extract changes;
		setProgressReport("Extracting changes..");
		if (extractChangesDT7()) {
			if ($transferId == "") {
				setProgressReport("No changes found, proceeding with control tables..");
				if (!createTransferDT17($lDB)) {
					setProgressReport("Unable to create transfer",1);
					return 0;
				}
			}
		} else {
			setProgressReport("An error occured while extracting changes",1);
			callException(1056);
			abortTransferDT8();
			setProgressReport("Transfer undone",1);
			return 0;
		}
	}

	if ($recoverStep <= 2) {
		# Step 2 - Export control records
		setProgressReport("Extracting control records..");
		if (!exportControlTablesDT9()) {
			setProgressReport("An error occured while extracting control records",1);
			abortTransferDT8();
			setProgressReport("Transfer undone",1);
			callException(1056);
			return 0;
		}
	}

	if ($recoverStep <= 3) {
		# Step 3 - Update control times
		$now = date("Y-m-d H:i:s");
		$lDB->put("UPDATE tc_transfer SET tc_trf_time_extract = '$now', tc_trf_time_extract_tz = '".date("e")."' where tc_transfer.tc_transfer_ix = '$transferId'");

		$extract = makeDateTime($now);
		updateTimeValue("extractTime",join(" ",$extract));
	}

	if ($recoverStep <= 4) {
		# Step 4 - Zip transfer files
		$zipFilePath = $transferDir.$transferName.".zip";
		if (createZipFileFromFolderDT10($zipFilePath,$TDfilePath)) {
			if (testZipFileDT11($zipFilePath)) {
				setProgressReport("Packaged files..");
			} else {
				setProgressReport("An error occured while packaging files",1);
				callException(1004);
				enableButtonTD("abortTransfer");
				enableButtonTD("continueTransfer");
				return 0;
			}
		} else {
			setProgressReport("An error occured while packaging files",1);
			callException(1004);
			enableButtonTD("abortTransfer");
			enableButtonTD("continueTransfer");
			return 0;
		}
		$filesize = filesize($zipFilePath);
		$lDB->put("UPDATE tc_transfer SET tc_trf_file_size = '$filesize' WHERE tc_transfer.tc_transfer_ix = '$transferId'");
	}

	if ($recoverStep <= 5) {
		# Step 5 - Activate Web Process
		if (!connectOfflineToWebDT12()) {
			enableButtonTD("abortTransfer");
			enableButtonTD("continueTransfer");
			return 0;
		}
	}

	if ($recoverStep <= 6) {
		# Step 6 - Unzip File
		$reportDir = getTransferDirDT37($transferName,TRANSFER_DIR_REPORT);
		$reportZipFile = $reportDir.$transferName."_report.zip";
		$reportFolder = $reportDir.$transferName."_report/";
		if (extractZipFileDT13($reportZipFile,$reportFolder)) {
			setProgressReport("Report package opened..");
		} else {
			callException(1029);
			enableButtonTD("continueTransfer");
			return 0;
		}
	}

	if ($recoverStep <= 7) {
		# Step 7 - Import Report
		$reportDir = getTransferDirDT37($transferName,TRANSFER_DIR_REPORT);
		$reportFolder = $reportDir.$transferName."_report/";
		if (importTransferFilesDT22($reportFolder,false)) {
			setProgressReport("Report imported..");
		} else {
			setProgressReport("Report corrupted",1);
			callException(1060);
			closeTransferFailDT18();
			setProgressReport("Transfer closed",1);
			return 0;
		}
	}

	if ($recoverStep <= 8) {
		# Step 8 - Close Transfer (Success)
		closeTransferTrueDT15();
		setProgressReport("Send transfer completed successfully",1);
		callException(1033);
		echo "
			<script language=\"javascript\">
				downloadLogURL = '".getTransferDirDT37($transferName,TRANSFER_DIR_LOG).$transferName.".log"."';
			</script>
		";
		$tmpFlag = $GLOBALS['flagChngs'];
		$GLOBALS['flagChngs'] = 0;
		$lDB->put("UPDATE tc_transfer SET tc_transfer_trf_yn = 0 WHERE tc_transfer.tc_transfer_ix = '".$transferId."'");
		$lDB->put("UPDATE tc_transfer_table SET tc_transfer_table_trf_yn = 1 WHERE tc_transfer_id = '".$transferId."'");
		$GLOBALS['flagChngs'] = $tmpFlag;
		return 1;
	}
}

function connectOfflineToWebDT12($recoverStep=1) {

	global $lDB;
	global $transferName;
	global $transferDir;
	global $transferId;
	global $principal_id;
	global $logFile;
	global $DTSERVERIP;
	global $DTremoteHostOverride;
	global $context;

	$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
	setProgressReport($GLOBALS['remoteDbCode']);
	$web_server = $_SESSION['principal_name_short'] . ".$DTSERVERIP";
	if($DTremoteHostOverride !== false) {
		$web_server = $DTremoteHostOverride;
	}
	if ($_SESSION['system'] == "upgrade") {
		$web_server = "upgrade.".$web_server;
	}
	setProgressReport("Connecting to ".$web_server."..");
	$lDB->select();

	$fileName = $transferName.".zip";

	# Step 1 - Test online connectivity
	if (!testOnlineDT27()) {
		callException(1006);
		return 0;
	}
	# Step 1a - Test system version
	if (!testVersionDT34()) {
		callException(1062);
		abortTransferDT8();
		setProgressReport("Transfer undone",1);
		return 0;
	}

	if ($recoverStep <= 2) {
		# Step 2 - connect to ftp
		// Replaced by HTTP upload
	}

	if ($recoverStep <= 3) {
		# Step 3 - Upload zipfile
		setProgressReport("Uploading export package..");
		$upload_address = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$GLOBALS[userid]+8";
		$source_file = $transferDir.$fileName;
		$destination_file = $fileName;
		$upload = postHTTP($upload_address,array(),array(array('name'=>$destination_file,'tmp_name'=>$source_file)));
		if($upload['error']) {
			if ($GLOBALS['DTprotocol'] == 'https://') {
				setProgressReport("HTTPS Upload failed ($upload[reason])",1);
			} else {
				setProgressReport("HTTP Upload failed ($upload[reason])",1);
			}
			callException(1011);
			return 0;
		}

		$check = explode("|",$upload['response']['body']);
		if(strpos($check[0],"!FALSE!") !== false) {
			if ($GLOBALS['DTprotocol'] == 'https://') {
				setProgressReport("HTTPS Upload failed (".$check[1].")",1);
			} else {
				setProgressReport("HTTP Upload failed (".$check[1].")",1);
			}
			callException(1011);
			return 0;
		}
	}

	if ($recoverStep <= 4) {
		# Step 4 - Update sendtime
		// <redundant, now done inside step 5>
	}

	if ($recoverStep <= 5) {
		# Step 5 - Request import URL
		$dbStatus = "1";
		if (!isMasterDB("1")) {
			$dbStatus = "0";
		}
		$remote_job_address = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$GLOBALS[userid]+0+$fileName+$dbStatus+$GLOBALS[dbcode]";
		setProgressReport("Initiating web import to ".$remote_job_address);

		$geturl = false;
		if ($GLOBALS['DTprotocol'] == 'https://') {
			$geturl = fopen($remote_job_address, "r", false, $context);
		} else {
			$geturl = fopen($remote_job_address, "r");
		}
		if ($geturl == false) {
			setProgressReport("Unable to request import URL",1);
			callException(1012);
			return 0;
		}

		callException(1013);

		# Read result from URL
		$result = "";
		$stay_connected = $GLOBALS['trdStayConnected'];
		if ($stay_connected == "1") {
			while (!feof ($geturl)) {
				$line = fgets($geturl, 4096);
				$result .= $line;
			}

			if (preg_match("/!START!/",$result)) {
				$tempa = explode("!START!",$result);
				$result = "!START!".$tempa[1];
			}
			if (preg_match("/!TRUE!/",$result)) {
				$tempa = explode("!TRUE!",$result);
				$result = $tempa[0]."!TRUE!";
			}
			$logDir = getTransferDirDT37($transferName,TRANSFER_DIR_LOG);
			$logFile = fopen($logDir.$transferName.".log","a+");
			$temp = explode("<br>",$result);
			$amax = sizeof($temp);
			fwrite($logFile,"\r\nStarting Web Output...\r\n");
			for($a=0;$a<$amax;$a++) {
				fwrite($logFile,$temp[$a]."\r\n");
			}
			fwrite($logFile,"Closing Web Output...\r\n\r\n");

			if ($GLOBALS['trdDestEcho'] == "1") {
				echo $result."<br>";
			}
			fclose ($geturl);

			# Verify import was successful, otherwise #echo error message
			if (!preg_match("/!TRUE!/",$result)) {
				if (preg_match("/!FALSE!/",$result)) {
					setProgressReport("Web rejected export package",1);
					$temp = explode("!FALSE!",$result);
					$error = $temp[1];
					$tmp = explode("[",$error);
					$imax = sizeof($tmp);
					$exception = "1058";
					for ($i=1;$i<$imax;$i++) {
						if (preg_match("/]/",$tmp[$i])) {
							$tmp2 = explode("]",$tmp[$i]);
							if (!preg_match("/[A-z]/",trim($tmp2[0]))) {
								$exception = trim($tmp2[0]);
								break;
							}
						}
					}
					setProgressReport("<i>!FALSE!".$error."</i>");
					callException($exception);
					return 0;
				} else {
					setProgressReport("Connection to ResRequest server lost",1);
					return 0;
				}
			} else {
				$sendtime = date("Y-m-d H:i:s");
				$lDB->put("UPDATE tc_transfer SET tc_trf_time_send = '$sendtime' WHERE tc_transfer.tc_transfer_ix = '$transferId'");
				setProgressReport("Web accepted export package");

				$send = makeDateTime($sendtime);
				updateTimeValue("exportTime",join(" ",$send));

				setProgressReport("Web imported export package..");
			}
		} else {
			$result = fgets($geturl,512);
			if (!preg_match("/!START!/",$result)) {
				if (preg_match("/!FALSE!/",$result)) {
					setProgressReport("Web rejected export package",1);
					$temp = explode("!FALSE!",$result);
					$error = $temp[1];
					setProgressReport("<i>!FALSE!".$error."</i>");
					callException(1058);
					return 0;
				} else {
					setProgressReport("Connection to ResRequest server lost",1);
					return 0;
				}
				fclose($geturl);
				return 0;
			} else {
				$sendtime = date("Y-m-d H:i:s");
				$lDB->put("UPDATE tc_transfer SET tc_trf_time_send = '$sendtime' WHERE tc_transfer.tc_transfer_ix = '$transferId'");

				$send = makeDateTime($sendtime);
				updateTimeValue("exportTime",join(" ",$send));
			}
		}
	}

	if ($recoverStep <= 6) {
		# Step 6 - Download Reportfile
		setProgressReport("Downloading report package..");
		$reportZipFile = $transferName."_report.zip";
		$reportDir = getTransferDirDT37($transferName,TRANSFER_DIR_REPORT);
		$localReportZipFile = $reportDir.$reportZipFile;

		$client = $_SESSION['principal_name_short'];
		$userId = $lDB->get("SELECT tc_user_id FROM tc_transfer WHERE tc_transfer.tc_transfer_ix = '".$transferId."'",4);
		$sourceReportZipFile = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$userId+9+".TRANSFER_DIR_REPORT."+$reportZipFile";
		setProgressReport("File: ".$sourceReportZipFile);

		$local = fopen($localReportZipFile,"wb");

		$url = $sourceReportZipFile;

		flush();
		ob_start();
		if (readfile($url, false, $context)) {
			$file = ob_get_contents();
			ob_end_clean();
			$size = strlen($file);
			@fwrite($local,$file);
			@fclose($local);
			unset($file);
			if (!is_file($localReportZipFile)) {
				setProgressReport("Unable to download report zipfile",1);
				callException(1028);
				return 0;
			}
			setProgressReport("Downloaded report zipfile..");
			return 1;
		} else {
			setProgressReport("Failed downloading report zipfile",1);
			callException(1028);
			return 0;
		}
	}
}


function closeTransferTrueDT15() {

	global $lDB;
	global $transferId;
	global $transferName;
	global $transferDir;

	# Step 1 - Update transfer record
	$now = date("Y-m-d H:i:s");
	$now_tz = date("e");
	$lDB->put("UPDATE tc_transfer SET tc_trf_time_close = '$now', tc_trf_time_close_tz = '".$now_tz."', sc_transfer_id = '52' where tc_transfer.tc_transfer_ix = '$transferId'");

	// Update time transfered
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = 0;
	$lDB->put("UPDATE rf_default SET rf_date_transfer = '$now', rf_date_transfer_tz = '".$now_tz."'");
	$GLOBALS['flagChngs'] = $tmptmp;

	$temp = explode("_",$transferName);
	$start = $temp[2]." ".str_replace("-",":",$temp[3]);
	$close = $now;

	$startTemp = explode(" ",$start);
	$startDate = explode("-",$startTemp[0]);
	$startTime = explode(":",$startTemp[1]);

	$closeTemp = explode(" ",$close);
	$closeDate = explode("-",$closeTemp[0]);
	$closeTime = explode(":",$closeTemp[1]);

	$startTemp = explode(" ",$start);
	$startDate = explode("-",$startTemp[0]);
	$startTime = explode(":",$startTemp[1]);

	$closeTemp = explode(" ",$close);
	$closeDate = explode("-",$closeTemp[0]);
	$closeTime = explode(":",$closeTemp[1]);

	$start = date("U",mktime($startTime[0],$startTime[1],$startTime[2],$startDate[1],$startDate[2],$startDate[0]));
	$close = date("U",mktime($closeTime[0],$closeTime[1],$closeTime[2],$closeDate[1],$closeDate[2],$closeDate[0]));

	$result = $close - $start;
	if ($result < 1) {
		$time = "00:00:00";
	} else {
		$mins = $result % 3600;
		$secs = $mins % 60;
		$time = str_pad((($result-$mins) / 3600),2,"0",STR_PAD_LEFT).":".str_pad((($mins-$secs) / 60),2,"0",STR_PAD_LEFT).":".str_pad(($secs % 60),2,"0",STR_PAD_LEFT);
	}
	updateTimeValue("totalTime",$time,"innerHTML");

	# Step 2 - Delete transfer folder
	if (is_dir($transferDir.$transferName."/")) {
		deleteRecursiveDT31($transferDir.$transferName."/");
		if (is_dir($transferDir.$transferName."/")) {
			setProgressReport("(unable to delete redundant transfer folder)",1);
		}
	}

	# Step 3 - Delete export folder
	$exportDir = getTransferDirDT37($transferName,TRANSFER_DIR_RECEIVE);
	if (is_dir($exportDir.$transferName."/")) {
		deleteRecursiveDT31($exportDir.$transferName."/");
		if (is_dir($exportDir.$transferName."/")) {
			setProgressReport("(unable to delete redundant transfer folder)",1);
		}
	}

	# Step 4 - Delete report folder
	$reportDir = getTransferDirDT37($transferName,TRANSFER_DIR_REPORT);
	if (is_dir($reportDir.$transferName."_report/")) {
		deleteRecursiveDT31($reportDir.$transferName."_report/");
		if (is_dir($reportDir.$transferName."_report/")) {
			setProgressReport("(unable to delete redundant report folder)",1);
		}
	}
}

function createTransferDT17($lDB) {

	global $dbcode;
	global $transferId;
	global $transferName;
	global $transferDir;
	global $TDfolderName;
	global $TDfilePath;
	global $webroot;
	global $principal_id;
	global $DTremotePrincipalOverride;
	global $sysLocked;
	global $context;

	# Step 1 - Create new transfer record with trf_direction = 0;
	$now = date("Y-m-d H:i:s");
	$lDB->put("
		INSERT INTO tc_transfer (
			tc_transfer_db,
			tc_trf_time_start,
			tc_trf_time_start_tz,
			tc_user_id,
			tc_trf_source
		) VALUES (
			'$dbcode',
			'$now',
			'".date("e")."',
			'$GLOBALS[userid]',
			'$dbcode'
		)
	");
	$error = htmlspecialchars(@mysqli_error($lDB->conn), ENT_QUOTES);
	if ($error != "") {
		setProgressReport("Error creating transfer record. (MySQL said: ".$error.")",1);
		return 0;
	}

	# Step 2 - Update the global transferId
	$transferId = $lDB->insert_id;
	if ($transferId == $dbcode || $transferId == "") {
		setProgressReport("Error determining transfer Id",1);
		return 0;
	}

	// Added for Database Upgrade
	if ($_POST['transferDirection'] == "5") {
		$lDB->put("UPDATE rf_system SET rf_sys_locked_yn = 1");
		$sysLocked = true;
	}

	# Step 3 - Update rf_default with the latest transfer time
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = 0;
	$lDB->put("UPDATE rf_default SET rf_date_transfer = '$now', rf_date_transfer_tz = '".date("e")."'");
	$GLOBALS['flagChngs'] = $tmptmp;

	$date = explode(" ",$now);
	$time = $date[1];
	$date = chng_date($date[0],"-");
	updateTimeValue("transferId",$transferId,"innerHTML");
	updateTimeValue("startdate",$date." ".$time,"innerHTML");

	# Step 5 - Create folder
	if($DTremotePrincipalOverride !== false) {
		$final_principal_id = $DTremotePrincipalOverride;
	} else {
		$final_principal_id = $principal_id;
	}
	$transferName = $final_principal_id."_".$transferId."_".str_replace(" ","_",str_replace(":","-",$now))."_".$dbcode."_".$GLOBALS['userid'];
	$transferDir = getTransferDirDT37($transferName);
	$TDfolderName = $transferName."/";
	$TDfilePath = $transferDir.$TDfolderName;

	mkdir($TDfilePath,0777);
	if (!is_dir($TDfilePath)) {
		setProgressReport("Unable to create transfer folder: ".$TDfilePath,1);
		return 0;
	}

	return 1;
}

function processRecieveTransferDT23($recoverStep=1) {

	global $lDB;
	global $dbcode;
	global $transferId;
	global $transferName;
	global $transferDir;
	global $principal_id;
	global $DTremotePrincipalOverride;
	global $sysLocked;

	global $webroot;
	global $logFile;
	global $transferState;

	global $DTSERVERIP;
	global $DTremoteHostOverride;
	global $context;

	# Set the global transferState
	$transferState = "receive";

	if ($recoverStep <= 1) {
		# Step 1 - Create recieve transfer
		setProgressReport("Creating transfer record..");
		$now = date("Y-m-d H:i:s");
		$now2 = str_replace(" ","_",str_replace(":","-",$now));
		$lDB->put("
			INSERT INTO tc_transfer (
				tc_transfer_db,
				tc_trf_source,
				tc_trf_time_start,
				tc_trf_time_start_tz,
				tc_user_id
			) VALUES (
				'$dbcode',
				'$GLOBALS[remoteDbCode]',
				'$now',
				'".date("e")."',
				'$GLOBALS[userid]'
			)
		");
		$transferId = $lDB->insert_id;
		if($DTremotePrincipalOverride !== false) {
			$final_principal_id = $DTremotePrincipalOverride;
		} else {
			$final_principal_id = $principal_id;
		}
		$transferName = $final_principal_id."_".$transferId."_".$now2."_".$GLOBALS['remoteDbCode']."_".$GLOBALS['userid'];
		if (!$sysLocked && $_POST['transferDirection'] == "5") {
			$lDB->put("UPDATE rf_system SET rf_sys_locked_yn = 1");
			$sysLocked = true;
		}
	}

	$transferDir = getTransferDirDT37($transferName);

	if ($recoverStep <= 2) {
		# Step 2 - Test Online connectivity
		if (!testOnlineDT27()) {
			callException(1035);
			enableButtonTD("continueTransfer");
			return 0;
		}
		# Step 2a - Test system version
		if (!testVersionDT34()) {
			if($recoverStep < 2) {
				callException(1062);
				closeTransferFailDT18();
				setProgressReport("Transfer undone",1);
				return 0;
			} else {
				setProgressReport("Version difference ignored due to receive transfer recovery");
			}
		}
	}

	if ($recoverStep <= 3) {
		# Step 3 - Initiate remote export
		setProgressReport("Initiating remote export..");
		$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
		$client = $_SESSION['principal_name_short'];
		$web_server = $client.".".$DTSERVERIP;
		if($DTremoteHostOverride !== false) {
			$web_server = $DTremoteHostOverride;
		}
		$lDB->select();

		$dbStatus = "1";
		if (!isMasterDB("1")) {
			$dbStatus = "0";
		}

		$now = $lDB->get("SELECT tc_trf_time_start FROM tc_transfer WHERE tc_transfer.tc_transfer_ix = '$transferId'",4);
		$now2 = str_replace(" ","_",str_replace(":","-",$now));

		$userId = $lDB->get("SELECT tc_user_id FROM tc_transfer WHERE tc_transfer.tc_transfer_ix = '".$transferId."'",4);

		$exportURL = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$userId+1+$transferId+$now2+$dbStatus+$sysLocked+$GLOBALS[dbcode]";
		setProgressReport("Connecting to $web_server..");
		setProgressReport($exportURL);
		$exportConn = fopen($exportURL,"rb",false,$context);
		if ($exportConn == false) {
			setProgressReport("Error connecting to ResRequest server",1);
			callException(1038);
			return 0;
		}
	}

	callException(1039);

	if ($recoverStep <= 4) {
		# Step 4 - Read result
		$result = "";
		while (!@feof ($exportConn)) {
			$line = @fgets($exportConn, 4096);
			$result .= $line;
			if (preg_match("/!START!/",$line)) {
				setProgressReport("Web starting export...");
			}
		}
		if (preg_match("/!START!/",$result)) {
			$tempa = explode("!START!",$result);
			$result = "!START!".$tempa[1];
		}
		if (preg_match("/!TRUE!/",$result)) {
			$tempa = explode("!TRUE!",$result);
			$result = $tempa[0]."!TRUE!";
		}
		if ($logFile != true) {
			$logDir = getTransferDirDT37($transferName,TRANSFER_DIR_LOG);
			$logFile = fopen($logDir.$transferName.".log","a+");
		}
		$temp = explode("<br>",$result);
		$amax = sizeof($temp);
		@fwrite($logFile,"\r\nStarting Web Output...\r\n");
		for($a=0;$a<$amax;$a++) {
			@fwrite($logFile,$temp[$a]."\r\n");
		}
		@fwrite($logFile,"Closing Web Output...\r\n\r\n");
		if ($GLOBALS['trdDestEcho'] == "1") {
			echo $result."<br>";
		}
		@fclose ($exportConn);
		# Verify export was successful, otherwise #echo error message
		if (!preg_match("/!TRUE!/",$result)) {
			if (preg_match("/!FALSE!/",$result)) {
				setProgressReport("Web failed exporting package",1);
				$temp = explode("!FALSE!",$result);
				$error = $temp[1];
				$tmp = explode("[",$error);
				$imax = sizeof($tmp);
				$exception = "1044";
				for ($i=1;$i<$imax;$i++) {
					if (preg_match("/]/",$tmp[$i])) {
						$tmp2 = explode("]",$tmp[$i]);
						if (!preg_match("/[A-z]/",trim($tmp2[0]))) {
							$exception = trim($tmp2[0]);
							break;
						}
					}
				}
				setProgressReport("<i>!FALSE!".$error."</i>");
				callException($exception);
				return 0;
			} else {
				setProgressReport("Connection to ResRequest server lost",1);
				return 0;
			}
		} else {
			$sendtime = date("Y-m-d H:i:s");
			$lDB->put("UPDATE tc_transfer SET tc_trf_time_extract = '$sendtime' WHERE tc_transfer.tc_transfer_ix = '$transferId'");
			setProgressReport("Web exported package..");
		}
	}
	if ($recoverStep <= 5) {
		# Step 5 - Download import package
		setProgressReport("Downloading export package..");
		$exportZipFile = $transferName.".zip";
		$exportDir = getTransferDirDT37($transferName,TRANSFER_DIR_RECEIVE);
		$localExportZipFile = $exportDir.$exportZipFile;

		$client = $_SESSION['principal_name_short'];
		$web_server = $client.".".$DTSERVERIP;
		if($DTremoteHostOverride !== false) {
			$web_server = $DTremoteHostOverride;
		}
		$userId = $lDB->get("SELECT tc_user_id FROM tc_transfer WHERE tc_transfer.tc_transfer_ix = '".$transferId."'",4);
		$sourceExportZipFile = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$userId+9+".TRANSFER_DIR_RECEIVE."+$exportZipFile";

		setProgressReport("File: ".$sourceExportZipFile);
		$local = fopen($localExportZipFile,"wb");
		$url = $sourceExportZipFile;
		flush();
		ob_start();
		if (readfile($url, false, $context)) {
			$file = ob_get_contents();
			ob_end_clean();
			$size = strlen($file);
			@fwrite($local,$file);
			@fflush($local);
			@fclose($local);
			clearstatcache();
			unset($file);
			if (!is_file($localExportZipFile)) {
				setProgressReport("Unable to download export package..");
				callException(1047);
				return 0;
			}
			$sendtime = date("Y-m-d H:i:s");
			$filesize = filesize($localExportZipFile);
			$lDB->put("UPDATE tc_transfer SET tc_trf_time_send = '$sendtime', tc_trf_file_size = '$filesize' WHERE tc_transfer.tc_transfer_ix = '$transferId'");
			setProgressReport("Downloaded export package..");
		} else {
			ob_end_clean();
			setProgressReport("Failed downloading export package",1);
			callException(1047);
			return 0;
		}
	}
	if ($recoverStep <= 6) {
		# Step 6 - extract zipfile
		$exportDir = getTransferDirDT37($transferName,TRANSFER_DIR_RECEIVE);
		$exportZipFile = $exportDir.$transferName.".zip";
		$exportFolder = $exportDir.$transferName."/";
		if (extractZipFileDT13($exportZipFile,$exportFolder)) {
			setProgressReport("Export package opened..");
		} else {
			callException(1048);
			enableButtonTD("continueTransfer");
			return 0;
		}
	}

	if ($recoverStep <= 7) {
		# Step 7 -  sqldump database
		//URGENT! - backup db
		#$mysql = 'mysqldump --add-drop-table cn_live_0011 > ras.sql';
		$exportDir = getTransferDirDT37($transferName,TRANSFER_DIR_RECEIVE);
		$exportFolder = $exportDir.$transferName."/";
		if (importTransferFilesDT22($exportFolder,true,false)){
			setProgressReport("Export imported..");
		} else {
			setProgressReport("Export corrupted",1);
			// Restore sql database
			callException(1051);
			closeTransferFailDT18();
			setProgressReport("Transfer closed",1);
			return 0;
		}
	}

	if ($recoverStep <= 8) {
		# Step 8 - Close Transfer (Success)
		closeTransferTrueDT15();
		setProgressReport("Receive transfer completed successfully",1);
		callException(1054);
		$lDB->put("UPDATE tc_transfer SET tc_transfer_trf_yn = 0 WHERE tc_transfer.tc_transfer_ix = '$transferId'");
		$lDB->put("UPDATE tc_transfer_table SET tc_transfer_table_trf_yn = 0 WHERE tc_transfer_id = '$transferId'");
		if ($sysLocked) {
			enableButtonTD("continueTransfer");
			setProgressReport("Transfer successful. Please wait for ResRequest before continuing",1);
		}
		return 1;
	}
}

function recoverSendTransferDT25() {

	global $transferName;
	global $transferDir;
	global $tdSendTime;
	global $transferState;

	# Set the global transferState
	$transferState = "send";

	# Have we sent the export package?
	if ($tdSendTime != "0000-00-00 00:00:00" && trim($tdSendTime) != "") {

		setProgressReport("Export package already sent..");

		# Step 1 - Test report zipfile
		$reportZip = $transferName."_report.zip";
		$reportDir = getTransferDirDT37($transferName,TRANSFER_DIR_REPORT);
		$reportZipFile = $reportDir.$reportZip;
		if (testZipFileDT11($reportZipFile)) {
			if (!processSendTransferDT6(6)) {
				setProgressReport("Failed recovering report import.");
				enableButtonTD("continueTransfer");
				return 0;
			}
			return 1;
		} else {
			if (testRemoteFileDT26($reportZip)) {
				if (connectOfflineToWebDT12(6)) {
					if (!processSendTransferDT6(6)) {
						setProgressReport("Failed recovering report import",1);
						enableButtonTD("continueTransfer");
						return 0;
					}
					return 1;
				} else {
						setProgressReport ("Failed recovering report package",1);
						enableButtonTD("continueTransfer");
						return 0;
				}
			} else {
				if (connectOfflineToWebDT12(5)) {
					if (!processSendTransferDT6(6)) {
						setProgressReport("Failed recovering report import",1);
						enableButtonTD("continueTransfer");
						return 0;
					}
					return 1;
				} else {
					setProgressReport("Failed recovering report package",1);
					enableButtonTD("continueTransfer");
					return 0;
				}
			}
		}
	} else {
		setProgressReport("Export package not yet sent..");

		# Step 2 - Test export zipfile
		$exportZip = $transferName.".zip";
		$exportZipFile = $transferDir.$exportZip;
		if (testZipFileDT11($exportZipFile)) {
			setProgressReport("Export package intact, sending..");
			if (!processSendTransferDT6(5)) {
				return 0;
			}
			return 1;
		} else {
			setProgressReport("Export package incomplete",1);
			abortTransferDT8();
			setProgressReport("Transfer undone",1);
		}
	}
}

function testRemoteFileDT26($remoteFile) {
	global $context;

	# Step 1 - Test online connectivity
	if (!testOnlineDT27()) {
		return 0;
	}

	# Step 2 - Test remote file
	if ($GLOBALS['DTprotocol'] == 'https://') {
		$remote = fopen($remoteFile,"rb",false,$context);
	} else {
		$remote = fopen($remoteFile,"rb");
	}
	if ($remote != false) {
		setProgressReport("Unable to find the remote file: ".$remoteFile,1);
		return 0;
	}
	@fclose($remoteFile);

	return 1;
}

function testOnlineDT27() {

	global $DTSERVERIP;
	global $DTremoteHostOverride;
	global $principal_id;
	global $lDB;
	global $context;

	if (!$GLOBALS['DTrequireOnline']) {
		return 1;
	}

	$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
	$client = $cDB->get("SELECT cn_prn_name_short FROM cn_principal WHERE cn_principal_id = '$principal_id'",4);
	$web_server = $client.".".$DTSERVERIP;
	if($DTremoteHostOverride !== false) {
		$web_server = $DTremoteHostOverride;
	}
	$lDB->select();

	# Connect to www.resrequest.com
	$resrequest = null;
	if ($GLOBALS['DTprotocol'] == 'https://') {
		$resrequest = fopen($GLOBALS['DTprotocol'].$web_server,"rb",false,$context);
	} else {
		$resrequest = fopen($GLOBALS['DTprotocol'].$web_server,"rb");
	}
	if ($resrequest != false) {
		@fclose($resrequest);
		return 1;
	} else {
		# Connect to www.google.com
		$google = fopen($GLOBALS['DTprotocol']."www.google.com","rb");
		if ($google != false) {
			fclose($google);
			setProgressReport("Unable to connect to ResRequest at this time",1);
			return 0;
		} else {
			setProgressReport("Please connect to the internet to continue",1);
			return 0;
		}
	}
}

function testVersionDT34() {
	global $DTSERVERIP;
	global $DTremoteHostOverride;
	global $principal_id;
	global $lDB;
	global $context;

	$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
	$client = $cDB->get("SELECT cn_prn_name_short FROM cn_principal WHERE cn_principal_id = '$principal_id'",4);
	$web_server = $client.".".$DTSERVERIP;
	if($DTremoteHostOverride !== false) {
		$web_server = $DTremoteHostOverride;
	}
	$lDB->select();

	$dbStatus = "1";
	if (!isMasterDB("1")) {
		$dbStatus = "0";
	}


	# Request version test
	$versionURL = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$GLOBALS[userid]+6+".$_SESSION['systemVersion']."+".$dbStatus."+".$GLOBALS['dbcode'];
	#echo $databaseURL."<br>";

	setProgressReport("Performing web system version check..");
	$geturl = null;
	if ($GLOBALS['DTprotocol'] == 'https://') {
		$geturl = fopen($versionURL, "r", false, $context);
	} else {
		$geturl = fopen($versionURL, "r");
	}
	if ($geturl == false) {
		setProgressReport("Unable to check web system version",1);
		return 0;
	}

	setProgressReport("Reading version check results..");
	# Step 2 - Find file location
	$result = "";
	while (!feof ($geturl)) {
		$line = fgets($geturl, 4096);
		$result .= $line;
	}
	fclose($geturl);

	$resultList = explode("\n",$result);

	if (preg_match("/!FALSE!/",$result)) {
		setProgressReport("The web is running version $resultList[1] and your server ($GLOBALS[dbcode]) is running version $_SESSION[systemVersion]",1);
		setProgressReport("Please contact your system administrator to perform an upgrade",1);
		return 0;
	}

	setProgressReport("Versions match.",1);
	setProgressReport("The web is running $resultList[1] and your server ($GLOBALS[dbcode]) is running $_SESSION[systemVersion]");
	return 1;

}

function recoverRecieveTransferDT28() {

	global $transferName;
	global $transferDir;
	global $TDfilePath;
	global $transferState;

	# Set the global transferState
	$transferState = "receive";

	# Step 1 - Test zipfile (local import package)
	$localImportPackage = $transferDir.$transferName.".zip";
	#echo $localImportPackage."<br>";
	if (!testZipFileDT11($localImportPackage)) {
		#setProgressReport("Import zipfile corrupted..");
		if (!processRecieveTransferDT23(2)) {
			setProgressReport("Failed recovering receive transfer",1);
			enableButtonTD("continueTransfer");
			return 0;
		}
	} else {
		if (!processRecieveTransferDT23(6)) {
			setProgressReport("Failed recovering receive transfer",1);
			enableButtonTD("continueTransfer");
			return 0;
		}
	}

	return 1;
}

function recoverTransferInfoDT32() {

	global $lDB;
	global $transferId;
	global $transferName;
	global $folderName;
	global $TDfilePath;
	global $transferDir;
	global $dbcode;
	global $tdSendTime;
	global $webroot;
	global $principal_id;
	global $DTremotePrincipalOverride;

	$data = $lDB->get("SELECT tc_trf_time_start, tc_trf_time_send, tc_user_id, tc_trf_source FROM tc_transfer where tc_transfer.tc_transfer_ix = '$transferId'",1);
	$tdSendTime = $data[1];

	if($DTremotePrincipalOverride !== false) {
		$final_principal_id = $DTremotePrincipalOverride;
	} else {
		$final_principal_id = $principal_id;
	}
	$transferName = $final_principal_id."_".$transferId."_".str_replace(" ","_",str_replace(":","-",$data[0]))."_".$data[3]."_".$data[2];
	$transferDir = getTransferDirDT37($transferName);
	$folderName = $transferName."/";

	$trFolder = "trdata_".$dbcode."/";
	$TDfilePath = $transferDir.$folderName;

}

function downloadDBFromWebDT33() {

	global $lDB;
	global $sysLocked;
	global $principal_id;
	global $transferId;
	global $DTSERVERIP;
	global $DTremoteHostOverride;
	global $dbDataFolder;
	global $context;

	if ($transferId == "") {
		# Step 1 - Trigger database export
		$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
		$client = $cDB->get("SELECT cn_prn_name_short FROM cn_principal WHERE cn_principal_id = '$principal_id'",4);
		$web_server = $client.".".$DTSERVERIP;
		if($DTremoteHostOverride !== false) {
			$web_server = $DTremoteHostOverride;
		}
		$lDB->select();

		$transferId = $lDB->get("SELECT tc_transfer.tc_transfer_ix FROM tc_transfer WHERE tc_trf_source != 'RS' ORDER BY tc_transfer.tc_transfer_ix DESC LIMIT 1",4);

		$dbStatus = "1";
		if (!isMasterDB("1")) {
			$dbStatus = "0";
		}
		$databaseURL = $GLOBALS['DTprotocol']."$web_server/reservation.php?127+$GLOBALS[userid]+5+$transferId+$dbStatus";
		#echo $databaseURL."<br>";

		setProgressReport("Triggering web database export..");
		$geturl = fopen($databaseURL, "r");
		if ($geturl == false) {
			setProgressReport("Unable to trigger web database export",1);
			enableButtonTD("continueTransfer");
			return 0;
		}

		setProgressReport("Reading export results..");
		# Step 2 - Find file location
		$result = "";
		while (!@feof ($geturl)) {
			$line = @fgets($geturl, 4096);
			$result .= $line;
		}

		if (preg_match("/!FALSE!/",$result)) {
			setProgressReport($result);
			return 0;
		}

		$fileURL = "";
		if (strpos($result,"File") !== false) {
			$temp = explode("[",$result);
			$temp = explode("]",$temp[1]);
			$fileURL = $temp[0];
			#echo $fileURL;
		}

		if ($fileURL == "") {
			setProgressReport("Unable to extract file location from web",1);
			return 0;
		}

		# Step 3 - Download file
		$temp = explode("/",$fileURL);
		$databaseZipFile = $temp[(sizeof($temp)-1)];
		$localDatabaseZipFile = $dbDataFolder.$databaseZipFile;
		#echo $localDatabaseZipFile."<br>";
		if (is_file($localDatabaseZipFile)) {
			unlink($localDatabaseZipFile);
		}

		$sourceDatabaseZipFile = $fileURL;

		$local = fopen($localDatabaseZipFile,"a");

		setProgressReport("Downloading database file..");
		$url = $sourceDatabaseZipFile;
		flush();
		ob_start();
		if (readfile($url, false, $context)) {
			$file = ob_get_contents();
			ob_end_clean();
			$size = strlen($file);
			@fwrite($local,$file);
			@fclose($local);
			unset($file);
			if (!is_file($localDatabaseZipFile)) {
				setProgressReport("Unable to download web database zipfile",1);
				return 0;
			}
			setProgressReport("Downloaded web database zipfile..");
		} else {
			setProgressReport("Failed downloading web database zipfile",1);
			return 0;
		}

		$file = substr($databaseZipFile,0,-4);
		#echo $file;

		# Step 4 - Unzip file
		setProgressReport("Extracting database file..");
		#echo $localDatabaseZipFile."<br>";
		$zipFileObj = new PclZip($localDatabaseZipFile);
		if (!is_object($zipFileObj)) {
			setProgressReport("Unable to open zipfile",1);
			return 0;
		}

		$zipFolder = $dbDataFolder;
		if (preg_match("/:/",$dbDataFolder)) {
			$temp = explode(":",$dbDataFolder);
			$zipFolder = $temp[1];
		}

		$result = $zipFileObj->extract($zipFolder);

		$amax = sizeof($result);
		if ($result != false && $amax != 0) {
			for($a=0;$a<$amax;$a++){
				$fileResult = $result[$a];
				if ($fileResult['status'] != "ok") {
					setProgressReport("Failed extracting: $fileResult[stored_filename] ($fileResult[status])",1);
					return 0;
				} else {
					if (!is_file($fileResult['filename'])) {
						setProgressReport("File ".$fileResult['stored_filename']." not created",1);
						return 0;
					}
				}
			}
		} else {
			setProgressReport("Error extracting zipfile",1);
			return 0;
		}

		setProgressReport("Zipfile extracted OK");

		# Step 5 - store latest transfer table data
		setProgressReport("Caching transfer control table..");
		$result = $lDB->get("
			SELECT
				tc_transfer_db,
				tc_transfer_id,
				tc_trf_source,
				tc_trf_file_size,
				tc_trf_time_start,
				tc_trf_time_extract,
				tc_trf_time_send,
				tc_trf_time_imp_start,
				tc_trf_time_imp_end,
				tc_trf_time_close,
				tc_user_id,
				sc_transfer_id,
				tc_transfer_trf_yn
			FROM
				tc_transfer
			WHERE
				tc_transfer_trf_yn = 0
		",2);

		# Step 6 - load database
		$exec = "/mysql/bin/mysql cn_live_".$principal_id." < ".$dbDataFolder.$file;
		#echo $exec."<br>";
		system($exec);
		setProgressReport("MySQL DB imported");
		unlink($dbDataFolder.$file);

		# Step 7 - Restore cached transfer control data
		$temp = $lDB->get("describe tc_transfer",2);
		$imax = sizeof($result);
		$jmax = sizeof($temp);
		$trfArray = array();
		for ($i=0;$i<$imax;$i++) {
			$sql = "";
			$keys = array_keys($result[$i]);
			for ($j=0;$j<$jmax;$j++) {
				$field = $temp[$j][0];
				if (in_array($field,$keys) && $field != "tc_transfer_id" && $field != "tc_transfer_db") {
					if ($sql == "") {
						$sql = "UPDATE tc_transfer SET ";
					} else {
						$sql .= ", ";
					}
					$sql .= $field." = '".$result[$i][$field]."'";
				}
			}
			if ($sql != "") {
				$sql .= " WHERE tc_transfer.tc_transfer_ix = '".$result[$i]['tc_transfer_db'].$result[$i]['tc_transfer_id']."'";
				$lDB->put($sql);
			}
		}

		# Step 8 - Usystem
		$lDB->put("UPDATE rf_system SET rf_sys_locked_yn = 0");
		setProgressReport("Database upgrade successful. System unlocked",1);
		endProcessTD();
	}
}

function endProcessTD($showStatus=false) {

	global $logFile;
	global $lDB;
	global $transferId;

	if ($logFile) {
		@fwrite($logFile,"Process Terminated.|||. \r\n");
		@fclose($logFile);
	}

	# Step 1 - Echo closing HTML tags;
	echo "</body>\n</html>";

	if($showStatus) {
		$status = $lDB->get("
			SELECT
				sc_transfer.sc_trf_message,
				sc_transfer.sc_trf_status
			FROM
				tc_transfer
				LEFT JOIN sc_transfer ON sc_transfer.sc_transfer_id = tc_transfer.sc_transfer_id
			WHERE
				tc_transfer.tc_transfer_ix = '$transferId'
		",1);
		echo "\n";
		if(trim($status['sc_trf_status']) == "") { // Invalid status
			echo "\n40|Invalid transfer end status";
		} else {
			echo "\n" . $status['sc_trf_status'] . "|" . $status['sc_trf_message'];
		}
	}

	# Step 2 - Die process;
	die();
}

function enableButtonTD($buttonName) {

	switch ($buttonName) {
	case "continueTransfer":
		setProgressReport("Press the continue button to recover this transfer");
		break;
	case "abortTransfer":
		setProgressReport("Press the undo button to undo and exit this transfer");
		break;
	}

	echo "<script>document.getElementById('$buttonName').className = 'button masterButton';</script>\n";
	flush();
}

function updateTimeValue($variable,$time,$mode="value") {
	echo "<script>document.getElementById('$variable').$mode = '$time';</script>\n";
	flush();
}

function hideSendTransferDetails() {
	echo "<script>hideSendTransferDetails()</script>\n";
}
