<?php

require_once(__DIR__ . '/class.lock.php');

function importTransferWebDT21($importFile) {
	global $transferId;
	global $TDfilePath;
	global $webroot;
	global $principal_id;
	global $lDB;
	global $remoteTransferDB;

	$transferDir = getTransferDirDT37($importFile);

	$reportStash = getTransferDirDT37($importFile,TRANSFER_DIR_REPORT);

	# Step 0 - Lock transfer
	$lock = new Lock("data_transfer_$principal_id"."_"."$remoteTransferDB");
	if(!$lock->Acquire()) {
		setProgressReport("!FALSE!, Unable to import changes as this transfer is locked by another process. This is usually caused by two processes attempting the send and/or recieve transfer at the same time. [1016]",1);
		callException(1016);
		return 0;
	}

	echo "ReportStash: ".$reportStash."<br>";

	# Step 1 - Test zipfile
	$importZipFile = $transferDir.$importFile;
	if (!testZipFileDT11($importZipFile)) {
		setProgressReport("!FALSE!, Zipfile corrupted [1014].");
		callException(1014);
		die();
	}
	echo "<!--";
	for($a=0;$a<(212);$a++){
		echo "0";
	}
	echo "-->";

	# Step 2 - Unzip File
	$importZipFile = $transferDir.$importFile;
	$importFolder = $transferDir.str_replace(".zip","",$importFile)."/";
	if (is_dir($importFolder)) {
		deleteRecursiveDT31($importFolder);
	} else {
		mkdir($importFolder,0777);
	}

	if (!extractZipFileDT13($importZipFile,$importFolder)) {
		setProgressReport("!FALSE!, Error extracting package [1016].");
		callException(1016);
		die();
	}
	echo "!START!, Extracted transfer package...<br>";
	flush();

	# Step 3 - Import Transfer files
	if (!importTransferFilesDT22($importFolder,true)) {
		// Restore sqldump!
		setProgressReport("!FALSE!, Error importing data [1019].");
		callException(1019);
		die();
	}

	echo "Imported transfer files...<br>";
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";
	$tc_transfer_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer'",4);
	$tc_transfer_table_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer_table'",4);

	db_tc_property_trf_delete($remoteTransferDB,$tc_transfer_key,$transferId);
	$delList = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id = '$transferId'",3);
	foreach($delList as $item) {
		db_tc_property_trf_delete($remoteTransferDB,$tc_transfer_table_key,$item);
	}

	db_tc_property_trf_insert($remoteTransferDB,$tc_transfer_key,$transferId);
	$list = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id = '$transferId'",3);
	foreach($list as $item) {
		db_tc_property_trf_insert($remoteTransferDB,$tc_transfer_table_key,$item);
	}
	$GLOBALS['flagChngs'] = $tmptmp;

	flush();

	# Step 4 - Export control records
	$reportFolder = $transferDir.str_replace(".zip","",$importFile)."_report/";
	if (is_dir($reportFolder)) {
		deleteRecursiveDT31($reportFolder);
		@mkdir($reportFolder,0777);
	} else {
		@mkdir($reportFolder,0777);
	}
	$TDfilePath = $reportFolder;

	if (!exportControlTablesDT9()) {
		setProgressReport("!FALSE!, Error exporting control records [1022].");
		callException(1022);
		die();
	}
	echo "Exported control records...<br>";
	flush();

	# Step 5 - Zip transfer files
	$reportFolder = $transferDir.str_replace(".zip","",$importFile)."_report/";
	$reportZipFile = $reportStash.str_replace(".zip","",$importFile)."_report.zip";
	echo "folder: ".$reportFolder."<br>";
	echo "zipfile: ".$reportZipFile."<br>";
	if (createZipFileFromFolderDT10($reportZipFile,$reportFolder)) {
		if (!testZipFileDT11($reportZipFile)) {
			echo "Packaging failed.<br>";
			echo "Repackaging files...<br>";
			createZipFileFromFolderDT10($reportZipFile,$reportFolder);
		}
	}

	// Update time transfered
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = 0;
	$now = date("Y-m-d H:i:s");
	$lDB->put("UPDATE rf_default SET rf_date_transfer = '$now', rf_date_transfer_tz = '".date("e")."'");
	$GLOBALS['flagChngs'] = $tmptmp;

	# Step 7 - Test zipfile
	$reportFolder = $transferDir.str_replace(".zip","",$importFile)."_report/";
	$importFolder = $transferDir.str_replace(".zip","",$importFile)."/";
	$reportZipFile = $reportStash.str_replace(".zip","",$importFile)."_report.zip";
	if (testZipFileDT11($reportZipFile)) {
		echo "!TRUE!";
		callException(1026);
		deleteRecursiveDT31($reportFolder);
		deleteRecursiveDT31($importFolder);
		// move transfer package to archive;
		require_once(__DIR__ . "/functions.mail.php");
		webSendmail();
		die();
	} else {
		// Restore sqldump!
		setProgressReport("!FALSE!, Error packaging files [1023].");
		callException(1023);
		die();
	}
}

function exportRecieveTransferDT24($recoverStep=1) {

	global $transferId;
	global $transferName;
	global $TDfilePath;
	global $webroot;
	global $lDB;
	global $dbcode;
	global $principal_id;
	global $DTremotePrincipalOverride;
	global $remoteTransferDB;
	global $exportStash;

	global $sysLocked;

	if($DTremotePrincipalOverride !== false) {
		$final_principal_id = $DTremotePrincipalOverride;
	} else {
		$final_principal_id = $principal_id;
	}
	$tcUserId = $_SERVER['argv'][1];
	$transferId = $_SERVER['argv'][3];
	$transferStart = $_SERVER['argv'][4];
	$transferStartTz = date("e");
	$transferName = $final_principal_id."_".$transferId."_".$transferStart."_".$dbcode."_".$tcUserId;
	$transferDir = getTransferDirDT37($transferName);
	$TDfilePath = $transferDir.$transferName."/";

	$exportStash = getTransferDirDT37($transferName,TRANSFER_DIR_RECEIVE);

	# Step 0 - Lock transfer
	$lock = new Lock("data_transfer_$transferId");
	if(!$lock->Acquire()) {
		setProgressReport("!FALSE!, Unable to extract changes as this transfer is locked by another process. This is usually caused by two processes attempting the receive transfer at the same time. [1041]",1);
		callException(1041);
		return 0;
	}

	# Step 1 - Verify transfer
	if ($recoverStep <= 1) {
		echo "!START!, Extracted transfer package...<br>";
		echo $transferName."<br>";
		flush();

		$count = $lDB->get("SELECT COUNT(*) FROM tc_transfer WHERE tc_transfer.tc_transfer_ix = '$transferId'",4);
		echo $count."<br>";
		if ($count > 0) {
			return recoverRecieveTransferWebDT29();
		}
	}

	# Step 2 - create transfer record
	if ($recoverStep <= 2) {
		$transferDb = substr($transferId,0,2);
		$transferIdInt = str_replace($transferDb,"",$transferId);
		$tmpdbcode = $GLOBALS['dbcode'];
		$GLOBALS['dbcode'] = $transferDb;
		$sql = "
			INSERT INTO tc_transfer (
				tc_transfer_db,
				tc_user_id,
				tc_trf_time_start,
				tc_trf_time_start_tz,
				tc_trf_source
			) VALUES (
				'$transferDb',
				'$tcUserId',
				'$transferStart',
				'$transferStartTz',
				'$GLOBALS[remoteDbCode]'
			)
		";
		$transferRecord = $lDB->get("SELECT COUNT(*) FROM tc_transfer WHERE tc_trf_time_close = '0000-00-00 00:00:00' AND tc_transfer_ix = '$transferId'",4); // Check if this recovery transfer record exists already
		if(empty($transferRecord)) {
			$lDB->put($sql);
		} else {
			setProgressReport("Record already exists! Updating existing transfer",1);
			$sql = "UPDATE tc_transfer SET tc_user_id = '$tcUserId', tc_trf_time_start = '$transferStart', tc_trf_source = 'WB' WHERE tc_transfer.tc_transfer_ix = '$transferId'";
			if (!$lDB->put($sql)) {
				$GLOBALS['dbcode'] = $tmpdbcode;
				setProgressReport("Critical failure. Unable to update transfer record",1);
				setProgressReport("!FALSE!, Unable to create transfer [1040]",1);
				callException(1040);
				return 0;
			}
		}
		$GLOBALS['dbcode'] = $tmpdbcode;

		$tmptmp = $GLOBALS['flagChngs'];
		$GLOBALS['flagChngs'] = "0";
		$tc_transfer_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer'",4);
		$tc_transfer_table_key = $lDB->get("SELECT tc_table_id FROM tc_table WHERE tc_table_name = 'tc_transfer_table'",4);

		db_tc_property_trf_delete($remoteTransferDB,$tc_transfer_key,$transferId);
		db_tc_property_trf_prc_delete($remoteTransferDB,$tc_transfer_key,$transferId);
		$delList = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id = '$transferId'",3);
		foreach($delList as $item) {
			db_tc_property_trf_delete($remoteTransferDB,$tc_transfer_table_key,$item);
			db_tc_property_trf_prc_delete($remoteTransferDB,$tc_transfer_table_key,$item);
		}

		db_tc_property_trf_insert($remoteTransferDB,$tc_transfer_key,$transferId);
		$list = $lDB->get("SELECT tc_transfer_table_ix FROM tc_transfer_table WHERE tc_transfer_id = '$transferId'",3);
		foreach($list as $item) {
			db_tc_property_trf_insert($remoteTransferDB,$tc_transfer_table_key,$item);
		}

		$GLOBALS['flagChngs'] = $tmptmp;
	}

	# Step 3 - Extract changes
	if ($recoverStep <= 3) {
		if (!extractChangesDT7()) {
			setProgressReport("!FALSE!, Unable to extract changes [1041]",1);
			callException(1041);
			abortTransferDT8();
			return 0;
		} else {
			if (!is_dir($exportStash.$transferName.".zip")) {
				//setProgressReport("!NOCHANGES!, There are no changes to export!");
			}
		}
	}

	# Step 4 - Export tc_transfer records
	if ($recoverStep <= 4) {
		if (!exportControlTablesDT9()) {
			setProgressReport("!FALSE!, An error occured while extracting control records [1041]",1);
			callException(1041);
			abortTransferDT8();
			return 0;
		}
		setProgressReport("Extracted control records..");
	}

	# Step 5 - Update control times
	if ($recoverStep <= 5) {
		$now = date("Y-m-d H:i:s");
		$lDB->put("UPDATE tc_transfer SET tc_trf_time_extract = '$now' WHERE tc_transfer.tc_transfer_ix = '$transferId'");
	}

	# Step 6 - Zip transfer files
	if ($recoverStep <= 6) {
		$zipFilePath = $exportStash.$transferName.".zip";
		if (!createZipFileFromFolderDT10($zipFilePath,$TDfilePath)) {
			if (!testZipFileDT11($zipFilePath)) {
				setProgressReport("Packaging failed",1);
				setProgressReport("Repackaging files..");
				createZipFileFromFolderDT10($zipFilePath,$TDfilePath);
			}
		}
		if (!testZipFileDT11($zipFilePath)) {
			setProgressReport("!FALSE!,An error occured while packaging files",1);
			callException(1043);
			return 0;
		}
	}

	// Update time transfered
	$tmptmp = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = 0;
	$now = date("Y-m-d H:i:s");
	$lDB->put("UPDATE rf_default SET rf_date_transfer = '$now', rf_date_transfer_tz = '".date("e")."'");
	$GLOBALS['flagChngs'] = $tmptmp;

	# Step 7 - write true
	if ($recoverStep <= 7) {
		setProgressReport("Location: ".$zipFilePath);
		setProgressReport("!TRUE!, Packaged files..");
		callException(1045);
		deleteRecursiveDT31($TDfilePath);

		if ($sysLocked) {
			# Delete any files that could conflict.
			$exec = "rm -r -f /var/www/html/db_upgrades/".$principal_id."_".$transferId."_upgrade_*.zip";
			system($exec);

			# Produce sqldump of db
			$file = $principal_id."_".$transferId."_".date("Y-m-d_H-i-s")."_dbupgrade.sql";
			$path = "/var/www/html/db_upgrades/";
			$exec = "mysqldump -u censysad -pcnsadDB --add-drop-table cn_live_".$principal_id." > ".$path.$file;
			system($exec);
			if (is_file($path.$file)) {
				echo "Backup success! (".filesize($path.$file).")<br>";
				$exec = "tar cjf ".$path.$file.".bz2 ".$path.$file;
				system($exec);
			}
			echo "NOTIFYING CENSYS of resrequest.com/db_upgrades/".$file.".bz2 !<br>";
		}
	}

	return true;
}

function recoverRecieveTransferWebDT29() {

	global $transferName;
	global $TDfilePath;
	global $exportStash;

	# Step 1 - Test zipfile (local export package)
	$localExportPackage = $exportStash.$transferName.".zip";
	echo $localExportPackage."<br>";
	if (testZipFileDT11($localExportPackage)) {
		echo "!TRUE!, package ready for download!<br>";
		return 1;
	}

	if (is_dir($TDfilePath) && $TDfilePath != "") {
		setProgressReport("Recovering existing extract folder",1);
		if(!exportRecieveTransferDT24(4)) {
			echo "!FALSE!, failed exporting transfer.<br>";
			return 0;
		}
		return 1;
	}

	# Step 2 - Extract changes
	if (!exportRecieveTransferDT24(2)){
		echo "!FALSE!, failed exporting transfer.<br>";
		return 0;
	}

	return 1;
}

function storeUploadedFilesDT35() {
	global $principal_id;
	global $DTremotePrincipalOverride;

	if(sizeof($_FILES) != 1) {
		echo "!FALSE!|Uploaded file missing.";
		return 0;
	}

	$tmp_file = $_FILES[0]['tmp_name'];
	$filename = $_FILES[0]['name'];
	$detail = splitTransferFileDT36($filename);

	if($DTremotePrincipalOverride !== false) {
		$final_principal_id = $DTremotePrincipalOverride;
	} else {
		$final_principal_id = $principal_id;
	}
	if($detail['principal'] != $final_principal_id || $detail['userid'] != $GLOBALS['userid'] || $detail['ext'] != "zip") {
		echo "!FALSE!|Invalid file uploaded.";
		return 0;
	}

	$transferDir = getTransferDirDT37($filename);
	if(!$transferDir) {
		echo "!FALSE!|Unable to access transfer upload directory.";
		return 0;
	}

	$result = move_uploaded_file($_FILES[0]['tmp_name'], "$transferDir$filename");
	if(!$result) {
		echo "!FALSE!|Error saving uploaded file.";
		return 0;
	}

	echo "!TRUE!|File successfully uploaded.";
	return 1;
}

function downloadFileDT38($type,$name) {
	global $principal_id;
	global $DTremotePrincipalOverride;

	if($type != TRANSFER_DIR_SEND && $type != TRANSFER_DIR_RECEIVE && $type != TRANSFER_DIR_REPORT && $type != TRANSFER_DIR_LOG) {
		fileNotFoundDT39();
	}

	if($DTremotePrincipalOverride !== false) {
		$final_principal_id = $DTremotePrincipalOverride;
	} else {
		$final_principal_id = $principal_id;
	}
	$check = splitTransferFileDT36($name);
	if(preg_match("/\.\.|[\\\\\/]+/",$name) || $check['principal'] != $final_principal_id || strlen($check['transfer_db']) != 2 || strlen($check['date']) != 10) {
		fileNotFoundDT39();
	}

	$fileDir = getTransferDirDT37($name,$type);
	$fileName = $fileDir.$name;
	if(is_file($fileName)) {
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename($fileName));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Content-Length: ' . filesize($fileName));
		readfile($fileName);
	} else {
		fileNotFoundDT39();
	}
}

function fileNotFoundDT39() {
	header($_SERVER["SERVER_PROTOCOL"]." 404 Not Found");
	echo "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
<html><head>
<title>404 Not Found</title>
</head><body>
<h1>Not Found</h1>
<p>The requested URL was not found on this server.</p>
<hr>
</body></html>";
	die();
}

/*function restoreBackup($file) {
	global $principal_id;

	if (is_file($GLOBALS['DTdir']."td_sqldump/".$file)) {
		$exec = "mysql -u censysad -pcnsadDB cn_live_".$principal_id." < $GLOBALS[DTdir]td_sqldump/".$file;
	}
}*/
