<?php

/**
 * System-wide constant definitions
 */

/**
 * Debug toggles
 */
$echoDB = 0;             // Set to 1 to see which database you are accessing
$hardDB = 0;             // Set to DB name to force a specific DB
$GLOBALS['debugEcho'] = true;
$GLOBALS['debugDomain'] = array("wa.blackmax","pa.blackmax","blackmax","whisper","molten-iron","rr","reloaded","ether","android","meister","subarch","linuxvm","pleph","pleph.2","vagrant","2.vagrant","rrdev");

/**
 * Database connection parameters
 */
global $dbHost, $db, $user, $pass;
$dbHost="";
$db="censys";
$user="root";
$pass="";

/**
 * Hard coded client / database naming (if hardDB is set)
 */
$hardClient = "test";
$hardPrincipal_id = "0001";
$hardDatabase = "cn_live_0001";

/**
 * Various system toggles
 */

$GLOBALS['DTrequireOnline'] = true; // True = requires net access to do data transfer - False overrides.

$GLOBALS['remoteDbCode'] = "WB";   // Current default server to transfer to.
$GLOBALS['DTremoteHostWA'] = "blackmax";  // DONT CHANGE - US server - DB code WA.
$GLOBALS['DTremoteHostWB'] = "resrequest.com";  // ZA server (current default - DB code WB
//$GLOBALS['DTremoteHostWB'] = "online";  // ZA server (current default - DB code WB

$GLOBALS['DTdir'] =  __DIR__ . "/../../../../../../../transfer/"; // Directory where transfer sub-directories and files are kept
$GLOBALS['DTprotocol'] =  "https://"; // Protocol used for DTs
global $context, $curlSettingsDT;
$context = stream_context_create(['ssl' => [
		  'ssl' => array(
				'verify_peer' => false,
				'verify_peer_name' => false
			)
		]]);
stream_context_set_option($context, 'ssl', 'verify_peer', false);

$curlSettingsDT = array( // cURL settings for outgoing DTs
	CURLOPT_SSL_VERIFYPEER => true, // Disable to allow self signed certificates
	CURLOPT_SSL_VERIFYHOST => 2, // Set to 0 to disable
	CURLOPT_CAINFO => __DIR__ . "/cacert.pem" // Fixes cURL error 60 for Windows offlines
);

$GLOBALS['context'] = $context;

$GLOBALS['DTremoteHostOverride'] = false; // Override the host used for data transfer
//$GLOBALS['DTremoteHostOverride'] = "dt.resrequest";
$GLOBALS['DTremotePrincipalOverride'] = false; // Override the (web) principal used for data transfer
//$GLOBALS['DTremotePrincipalOverride'] = "1000";

$scriptTimeout = 300;              // Maximum script execution time (in seconds)
$precision = 16;                   // Floating point precision

$debug = 0;       // Set the debug flag
$menuDebug = 0;         // Set the menu debug flag
$GLOBALS['popupDebug'] = 1;   // Turns PHP debug to popup window on or off
$tempCPC = 0;        // this hides the change password on the web system, and does other cool stuff too! ;-)
$GLOBALS['tempCPC'] = $tempCPC;
            // (like not popping up the change password screen if there is a dup username password login)
$GLOBALS['flagChngs'] = 1;         // Set the tr_flag to 0 on each row that is edited?
$GLOBALS['enableIXfields'] = 1;    // Activate the ix field patch
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
// include the ix table list - maintained outside of inc.setup.php so the utils can include it on demand
require_once(__DIR__ . "/inc.ixfields.php");

$flagDels = 1;       // Create a td_deletions record for each row that is deleted?
$GLOBALS['flagDels'] = $flagDels;
global $trdDestEcho;
$trdDestEcho = 0;    // echo the output the destination server gives in a data transfer
$GLOBALS['trdDestEcho'] = $trdDestEcho;

$GLOBALS['trdStayConnected'] = 1;   // should data transfer continue waiting online for the report
            // and NOT prompt you to disconnect after phase 1?

$showScriptSpeed = false;  # boolean, true / false
$GLOBALS['showScriptSpeed'] = $showScriptSpeed;
$showScriptSpeedLoc = "source";  # screen or source
$GLOBALS['showScriptSpeedLoc'] = $showScriptSpeedLoc;


// -====================-
//  Setup Default Values
// -====================-
$defaultJob = "999";
$addSessionID = true;         # This will switch whether .js and .css files have ?SESSIONID appended or not
$GLOBALS['dbUpgradeInProcess'] = false;

$GLOBALS['support'] = array();
$GLOBALS['support']['email'] = "support@resrequest.com";
$GLOBALS['support']['telephone'] = "+27 31 762 2729";
$GLOBALS['support']['fax'] = "+27 35 772-5778";
$GLOBALS['support']['company'] = "ResRequest";

$GLOBALS['checkLicence'] = false;
