<?php

require(__DIR__ . '/inc.config.php');     // System configuration constants
require_once(__DIR__ . '/functions.php');

global $domain;
global $client;
global $system;
global $server;
global $archive;
global $sessionServer;
global $envWebOverride;
global $primaryEnvironmentIsWeb;

$serverConfig = [
	'prefixes' => ['www'], // Prefixes will be removed
	'suffixes' => ['com', 'co.za', 'net'],	// Suffixes are retained but must be
											// ignored when detecting URL format
	'local' =>['live', 'upgrade', 'demo', 'test', 'training']
		// Local client names are an alias for the first entry in
		// censys.cn_principal but use a database with the local name instead
		// of live. Eg. training.resrequest would use cn_training_xxxx
];

$domain = "";			// Full domain as specified by client
						// eg. mala.resrequest.com or 
						// www.archive-1.pa.mala.za.resrequest.com
$client = "";			// Client short name eg. mala or local for first item
						// in censys.cn_principal
$system = "";			// Set to live for normal systems, otherwise to the 
						// special type eg. training or demo.
						// Used in the database name eg. cn_live_0001 or
						// cn_training_0002
$server = "";			// Base server name eg. resrequest.com or za.resrequest.com
						// (used for images)
$sessionServer = "";	// Server name used for cookie domain without prefixes
						// and then prefixed with a full stop (.)
						// eg. wwww.mala.resrequst.com -> .mala.resrequest.com
$tld = "";				// Top level domain. May be empty for local systems.
						// Otherwise global tlds (.com) or country code (co.za)
$country = "";			// Country requested (optional)
$archive = false;		// Archive system eg. archive-01.mala.resrequest.com
$dbCodeOverride = false; 	// Override the environment from the URL 
							// eg. pa.mala.resrequest.com
$envWebOverride = false;	// Set to true if dbCodeOverride succeeds


// Get the full hostname
$domain = $_SERVER['SERVER_NAME'] ?? "";

// Remove common prefixes and suffixes
$serverName = $domain;
foreach($serverConfig['prefixes'] as $prefix) {
	$serverName = preg_replace("/^$prefix\\./","",$serverName);
}

$sessionServer = "." . $serverName;

foreach($serverConfig['suffixes'] as $suffix) {
	if(preg_match("/\\.$suffix$/",$serverName)) {
		$serverName = preg_replace("/\\.$suffix/","",$serverName);
		$tld = $suffix;
		break;
	}
}

// Split into components
$serverName = explode(".",$serverName);

// Store and remove any archive component
$archive = false;
if(preg_match("/archive-\d{2}/",$serverName[0])) {
	$archive = explode("-", array_shift($serverName));
	$archive = ltrim($archive[1],"0");
}

// Remove base domain and store along with suffix
$dotcom = ($tld == "") ? "" : ".";
$server = array_pop($serverName) .$dotcom. $tld;

// Connect to the censys database
$cDB = new MySQLDB($db,$user,$pass,$dbHost);

# Check to see if we are local or remote
# And get server, client (and system - live/demo/upgrade) if local
switch(sizeof($serverName)) {
case 1: // Client name only
	if($tld == "" && in_array($serverName[0], $serverConfig['local'])) {
		# This is a client's local system
		$client = "local";
		$system = $serverName[0];
	} else {
		$client = $serverName[0];
		$system = "live";
	}
	break;

case 2: // Client name and either environment or country code: pa.mala or mala.za
	if($cDB->get("SELECT COUNT(*) FROM cn_principal WHERE cn_prn_name_short = '".$cDB->escape($serverName[1])."'",4) > 0) {
		$dbCodeOverride = $serverName[0];
		$client = $serverName[1];
		$system = "live";
	} elseif($cDB->get("SELECT COUNT(*) FROM cn_principal WHERE cn_prn_name_short = '".$cDB->escape($serverName[0])."'",4) > 0) {
		$client = $serverName[0];
		$country = $serverName[1];
		$system = "live";
	}
	break;

case 3: // Environment code, client name and country code: pa.mala.za
	$dbCodeOverride = $serverName[0];
	$client = $serverName[1];
	$country = $serverName[2];
	$system = "live";
	break;
}

// Determine is HTTPS is in use
$GLOBALS['https_enabled'] = (isset($_SERVER['HTTPS']) && !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off');

// Enabled debugging based on defined debug domains
$GLOBALS['debugEnabled'] = in_array($server,$GLOBALS['debugDomain']) && $GLOBALS['debugEcho'];

// Prefix server with country code if available
if(!empty($country)) {
	$server = $country . "." . $server;
}

/**
 * Local server not specifying system (live/upgrade/demo) e.g. http:/localhost/cn_1.4.3
 * or other unknown URL scheme.
 * We will reject this type of URL to prevent users accidently accessing the wrong system.
 */
if(empty($client) || empty($system) || empty($server)) {
	echo "Please do not use this type of URL. This can be dangerous and result in editing in the wrong system/directory.<br><br>";
	echo "Instead use URLs of the form:<br><br>";
	echo "<strong>".($GLOBALS['https_enabled'] ? "https://" : "http://")."live.".$baseDomain."<br>";
	echo "<strong>".($GLOBALS['https_enabled'] ? "https://" : "http://")."demo.".$baseDomain."<br>";
	die;
}

$GLOBALS['server'] = $server;
$GLOBALS['system'] = $system;

session_init();

// -====================================-
//  Script timeout as per inc.config.php
// -====================================-
set_time_limit($scriptTimeout);     // Limit the script runtime

// -============================================-
//  Developer settings when debugging is enabled
// -============================================-
if(isset($GLOBALS['debugEnabled']) && $GLOBALS['debugEnabled']) {
	ini_set("display_errors","On");
	ini_set("display_startup_errors","On");
	ini_set("error_reporting",E_ALL);
	ini_set("session.bug_compat_42","On");
	ini_set("session.bug_compat_warn","On");
	ini_set("track_errors","On");
}

// -======================================-
//  Emulate register_argc_argv if disabled
// -======================================-
if(!ini_get("register_argc_argv")) {
	$_SERVER['argv'] = explode("+",$_SERVER['QUERY_STRING']);
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	ini_set("register_argc_argv","1");
}

// -==================================-
//  Precision as set in inc.config.php
// -==================================-
ini_set('precision',$precision);

// -===================-
//  Enable utf8 support
// -===================-
ini_set('default_charset',"UTF-8");


global $versionDir;

if($versionDir == "") {
	$versionDir = __DIR__;
}
$GLOBALS['versionDir'] = $versionDir;
$systemVersion = getSystemVersion();//substr($ver,0,strrpos($ver,"."));
/**
 * Get the system update date from the .ver version file.
 * This is so we can view source on the index page to see
 * when the system was last updated/uploaded.
 */
$fp = fopen($versionDir."/".$systemVersion.".ver", "rb");
$updateDateTime = fgets($fp,1024);
fclose ($fp);
unset($fp);

# If we are local then there is only one entry in the Censys database
# table cn_principal
$sql = "SELECT cn_principal_id, cn_prn_name_short, cn_prn_custom_yn, cn_prn_data_synch_mthd FROM cn_principal";
if($client != "local") {
   $sql .= " WHERE cn_prn_name_short = '".$cDB->escape($client)."'";
}
$temp = $cDB->get($sql,1);
$principal_name_short = (string)$temp['cn_prn_name_short'];
$GLOBALS['principal_name_short'] = $principal_name_short;
$custom_yn = $temp['cn_prn_custom_yn'];
$data_synch_mthd = $temp['cn_prn_data_synch_mthd'];

# Get this client's database name
$principal_id = (string)$temp['cn_principal_id'];
$principal_id = str_pad($principal_id,4,"0",STR_PAD_LEFT);
$GLOBALS['principal_id'] = $principal_id;
$db2 = "cn_".$system."_".$principal_id;
if($archive !== false) {
	$db2 = "cn_archive_".$principal_id."_".str_pad($archive,2,"0",STR_PAD_LEFT);
}

# debug code (set in inc.config.php!!!)
# use a specific hard coded database (set at top of file!!!)
if($hardDB) {
	$client = $hardClient;
	$principal_id = $hardPrincipal_id;
	$db2 = $hardDatabase;
	echo "<font color='#FFFFFF'>WARNING! The database is hard coded</font>";
}

# echo the database selected if $echoDB = 1;
if($echoDB) {
	echo "<font color='#FFFFFF'>DB: ".$db2."</font><br>";
}
# Create the URL's for the two hosted servers
$SAServer = $principal_name_short.".za.resrequest.com";
$USServer = $principal_name_short.".us.resrequest.com";
$EUServer = $principal_name_short.".eu.resrequest.com";
$GLOBALS['SAServer'] = $SAServer;
$GLOBALS['USServer'] = $USServer;
$GLOBALS['EUServer'] = $EUServer;


$rf_sys_db_me_id = $cDB->get("select cn_prn_db_me_id from cn_principal where cn_prn_name_short = '".$cDB->escape($client)."'",4);
if ($rf_sys_db_me_id == "" || $rf_sys_db_me_id == "0" || $rf_sys_db_me_id == 0)
{
	$rf_sys_db_me_id = $cDB->get("select cn_sys_db_me_id from cn_system",4);
}

// Close the connection the the censys (config) database and free the object memory
$cDB->close();
unset($cDB);

# Create link to client database
global $lDB;
$lDB = new MySQLDB($db2,$user,$pass,$dbHost);

// Apply dbcode override
$primaryEnvironmentIsWeb = $lDB->get("
	SELECT rf_db_code FROM rf_database WHERE rf_database_id = '" . $lDB->escape($rf_sys_db_me_id) . "'
",4)[0] == "W";
if($dbCodeOverride !== false) {
	if(!$primaryEnvironmentIsWeb) {
		die("Environment may not be overridden on an offline server. Contact your system administrator for more information.");
	}
	$override_db_me_id = $lDB->get("
		SELECT
			rf_database_id
		FROM
			rf_database
		WHERE
			rf_db_code = '".$lDB->escape(strtoupper($dbCodeOverride)) . "'
			AND rf_db_env_type_web_yn = '1'
	",4);
	if(!empty($override_db_me_id)) {
		$rf_sys_db_me_id = $override_db_me_id;
		$envWebOverride = true;
	} else {
		die("This environment is not marked for online use and may not be used online. Contact your system administrator for more information.");
	}
}

# Get the resrequest.com email address
$censys_email = $lDB->get("select rf_sys_censys_email from rf_system where rf_system_id = 1",4);

# Get the ID of the Principal and Reservations Office ID
$temp = $lDB->get("select rf_principal_id, rf_res_office_id from rf_default where rf_default_id = '1'",1);
$principal = $temp['rf_principal_id'];
$rf_res_office_id = $temp['rf_res_office_id'];

# Get the Principal name
$principal_name = $lDB->get("select pr_name_last from pr_persona where pr_persona_ix = '$principal'",4);
$GLOBALS['principal_name'] = $GLOBALS['princName'] = $principal_name;

# Get Contact (user) details
if(!isset($_SESSION['userid'])) {
    $userid = "";
    $firstname = "";
    $lastname = "";
} else {
    $userid = $_SESSION['userid'];
    $temp = $lDB->get("select pr_name_first, pr_name_last from pr_persona where pr_persona_ix = '$userid'",1);
    $firstname = $temp['pr_name_first'];
    $lastname = $temp['pr_name_last'];
}

# Get email address of reservations office
$principal_email = $lDB->get("select pr_email from pr_persona where pr_persona_ix = '$rf_res_office_id'",4);

# Register all session variables
$_SESSION['domain'] = $domain;            // e.g. blackmax, mala.za.resrequest.com, mala.resrequest.com, live.resrequest
$_SESSION['server'] = $server;            // e.g. blackmax, resrequest.com, resrequest
$_SESSION['system'] = $system;            // e.g. live, upgrade, demo
$_SESSION['db'] = $db2;
$_SESSION['dbHost'] = $dbHost;
$_SESSION['censys_email'] = $censys_email;
$_SESSION['principal_id'] = $principal_id;
$_SESSION['custom_yn'] = $custom_yn;
$_SESSION['principal_name'] = $principal_name;
$_SESSION['firstname'] = $firstname;
$_SESSION['lastname'] = $lastname;
$_SESSION['principal_email'] = $principal_email;
$_SESSION['systemVersion'] = $systemVersion;
$_SESSION['principal_name_short'] = $principal_name_short;

# Locations
$GLOBALS['http'] = ($GLOBALS['https_enabled'] ? "https://" : "http://");
$GLOBALS['images_dir'] = ($client == "local" ? $server."/images" : $domain."/client_images");
$GLOBALS['images_dir_on_disk'] = __DIR__ . "/../../../../../../../images";
$GLOBALS['online_images_dir'] = $domain.'/client_images';
$GLOBALS['html_dir'] = "/resource/Resrequest/Application/public/html/";
$GLOBALS['html_dir_on_disk'] = __DIR__ . "/../../../public/html/";
$GLOBALS['help_dir'] = "/resource/Resrequest/Application/public/html/help/";
$GLOBALS['help_dir_on_disk'] = __DIR__ . "/../../../public/html/help/";
$GLOBALS['info_dir'] = "/resource/Resrequest/Application/public/html/info/";
$GLOBALS['info_dir_on_disk'] = __DIR__ . "/../../../public/html/info/";
$GLOBALS['cacheRoot'] = __DIR__ . "/../../../../../../../cache";

list($dbcode,$timezone,$allowWebEnvironmentOverrideYn) = $lDB->get("
	SELECT
		rf_db_code,
		rf_db_time_zone,
		rf_db_env_type_web_yn
	FROM
		rf_database
	WHERE
		rf_database_id = '$rf_sys_db_me_id'
",1);
if(!$primaryEnvironmentIsWeb && $allowWebEnvironmentOverrideYn == '1') {
	die("This environment is marked for online use and may not be used offline. Contact your system administrator for more information.");
}

$GLOBALS['isWebServer'] = false;
$GLOBALS['dbcode'] = $dbcode;
if ($dbcode[0] == "W") {
	$GLOBALS['isWebServer'] = true;
}

$_SESSION['dbVersion'] = $GLOBALS['dbVersion'] = $lDB->get("
		SELECT
			rf_db_version_db
		FROM
			rf_database
		WHERE
			rf_db_code = '$dbcode'
	",4);

// -==================-
//  Configure timezone
// -==================-
set_timezone($timezone);

/**
 * Get the current system version from the Document Root path
 * and get the demo expiry date if demo system
 */
function getSystemVersion() {
	$dir = $GLOBALS['versionDir'];
	if (is_dir($dir)) {
		if ($dh = opendir($dir)) {
			while (($file = readdir($dh)) !== false) {
				if(strpos($file,".ver")) {
					$ver = $file;
					break;
				}
			}
			closedir($dh);
		}
	}
	return substr($ver,0,strrpos($ver,"."));
}

require_once(__DIR__ . "/functions.archive.php");
if($archive !== false) {
	if(
		!isset($_SESSION['archive_access'])
		|| !isset($_SESSION['archive_access'][$archive])
		|| !$_SESSION['archive_access'][$archive]
	) {
		die("Access denied");
	}

	archiveAccess();
}
