<?php

/**
 * init.form0.php -  Reservation details tab
 * Job: 0, 1, 2, 3, 4, 30
 * Function: 52 (Reservation: Maintenance)
 */

require_once "class.template.php";

$GLOBALS['DONTFORMPARSE'] = true;

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/reservation_details.htm");
	$fields = array(
		"rv_reservation_id",
		"rt_rate_type_id",
		"rv_date_recorded",
		"rv_date_changed",
		"rv_res_name",
		"rf_source_ix",
		"rv_invoice_date",
		"rv_agent_id",
		"rv_prov_date",
		"rv_provision_expiry_date",
		"rv_origin_agent_id",
		"rv_wait_list_date",
		"rv_corr_persona_id",
		"rv_confirmation_date",
		"rv_invoice_currency_id",
		"rv_commission_deduct_yn",
		"rv_commission_perc",
		"rv_cancel_reason",
		"rv_cancel_date",
		"pr_reservation_user_id",
		"rf_reservation_status_id",
		"rv_consultant_id",
		"rv_date_consultant",
		"rv_agent_ref",
		"bl_block_period_id"
	);
	$ident = array("rv_res_name");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'], "rv_reservation", $fields, "rv_reservation_ix = '$record'", "", "", $ident);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

// Define scrollset -----------------------------------------------------------
if($_SERVER['argv'][2] != "" && substr($_SERVER['argv'][2], 0, 13) == "resScrollSet:") {
	session_set("resScrollSet",array_values(explode(":", substr($_SERVER['argv'][2],13))));
}

$resScrollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:array();
if ( !is_array($resScrollSet) ) {
	$resScrollSet = array();
}

// Setup the record scrolling -------------------------------------------------
$rPrev = $record;
$rNext = $record;

if ( !in_array($record, $resScrollSet) && $record != "0" && $record != "" ) {
	array_push($resScrollSet, $record);
}

if ( is_array($resScrollSet) ) {
	for ( $q = 0; $q < sizeof($resScrollSet); $q++ ) {
		$key = isset($resScrollSet[$q]) ? $resScrollSet[$q] : "";

		if ( $key == $record ) {

			if ( $q > "0" ) {
				$rPrev = $resScrollSet[$q-1];
			}

			if ( $q + 1 < sizeof($resScrollSet) ) {
				$rNext = $resScrollSet[$q+1];
			}
		}
	}
}
addLastRes($record);

// Variables to initialise ----------------------------------------------------
$GLOBALS['autovar'] = "1";
$GLOBALS['record']	= (string) $_SERVER['argv'][1];
$record				= $GLOBALS['record'];

nozero($GLOBALS['tagList']['invCurrSym'], $GLOBALS['lDB']->get("select rf_currency_symbol from rf_currency where rf_currency_ix = '".getInvCurr($record)."'", 4));

if ( $GLOBALS['record'] == "0" ) {
	$GLOBALS['record'] == "";
}

if ( $record != "" ) {
	$table = $GLOBALS[$form]->TableList[0];
	$GLOBALS[$table]->Refresh($record, $action);
}

// Initialise the form --------------------------------------------------------
$GLOBALS[$form]->Get($action);


if($_SERVER['argv'][2] == "recalc") {
	ammendReservation($record,"Recalculate Totals");
	recalcTotals($record);
	redirectTo(" reservation.php?" . $_SERVER['argv'][0] . "+" . $record);
	die();
}

if($_SERVER['argv'][2] == "regen") {
	regenReservation($record);
	ammendReservation($record,"Regenerate All Itineraries");
	getSpecialIndicationText($record,1);
	redirectTo(" reservation.php?" . $_SERVER['argv'][0] . "+" . $record);
	die();
}

if($_SERVER['argv'][2] == "checkPropSpecExtras" && !empty($_SERVER['argv'][3])) {
	// Extras property-specific orphan check. If an itinerary is being deleted, and any extras remain that
	// are specific to the property, without any itineraries left on that property, it should not be allowed.
	// This code is called via Ajax every time an itinerary is deleted
	$itemId = $_SERVER['argv'][3];
	$return = array(
		'paymentBalance' => false,
		'orphanedExtras' => ''
	);
	
	$thisItinProp = $GLOBALS['lDB']->get("
		SELECT
			pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $itemId . "'
	",4);

	$itinProps = $GLOBALS['lDB']->get("
		SELECT
			pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $record . "'
			AND rv_reservation_item.rv_reservation_item_ix != '" . $itemId . "'
	",3);

	$extras = $GLOBALS['lDB']->get("
		SELECT
			rv_extra.rv_extra_ix,
			ac_extra.ac_ext_desc as description,
			rv_extra.pr_business_id as prop
		FROM
			rv_extra
			LEFT JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
		WHERE
			rv_extra.rv_reservation_id = '" . $record . "' 
			AND rv_extra.pr_business_id = '" . $thisItinProp . "' 
			AND rv_extra.rv_extra_void_ind = 0
	",2);

	$orphanedExtraList = array();
	foreach ($extras as $extra) {
		if (!empty($extra['prop']) && $extra['prop'] != "0" && !in_array($extra['prop'], $itinProps)) {
			$orphanedExtraList[] = $extra['description'];
		}
	}
	if(!empty($orphanedExtraList)) {
		$return['orphanedExtras'] = join(',', $orphanedExtraList);
	}

	$thisItinFolio = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.fn_folio_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $itemId . "'
	",4);
	$numItinsOnFolio = intval($GLOBALS['lDB']->get("
		SELECT
			count(rv_reservation_item.rv_reservation_item_ix)
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.fn_folio_id = '" . $thisItinFolio . "'
	",4));
	$paymentBalance = $GLOBALS['lDB']->get("
		SELECT 
			fn_folio_amt_paid 
		FROM 
			fn_folio
		WHERE 
			fn_folio_ix = '" . $thisItinFolio . "'
	",4);
	$chargeableExtras = $GLOBALS['lDB']->get("
		SELECT
			count(rv_extra.rv_extra_ix)
		FROM
			rv_extra
		WHERE
			rv_extra.fn_folio_id = '" . $thisItinFolio . "' 
			AND rv_extra.rv_extra_void_ind != 3 
			AND rv_extra.rv_extra_amt_payable != 0
	",4);
	if($numItinsOnFolio == 1 && $paymentBalance != 0 && $chargeableExtras == 0) {
		$return['paymentBalance'] = true;
	} 
	echo json_encode($return);
	die();
}

if($_SERVER['argv'][2] == "blocktemplateunlink") {
	ammendReservation($record,"Unlinking from block template");

	// Find the first itinerary which has a drawdown from a block allocation reservation
	$firstItineraryId = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item AS allocation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
			INNER JOIN rv_reservation AS allocation ON allocation.rv_reservation_ix = allocation_item.rv_reservation_id AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = allocation.bl_block_period_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
		LIMIT 1
	",4);
	if(!empty($firstItineraryId)) {
		clearAllocations($firstItineraryId,true);
	}
	redirectTo(" reservation.php?" . $_SERVER['argv'][0] . "+" . $record);
	die();
}

$wetu = new Wetu($record, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

$GLOBALS['temp']['commissionLabel'] = commissionLabel();

$GLOBALS['temp']['waitlistContainerDisplay'] = "display: none;";
$GLOBALS['temp']['waitlistCenterDivYN'] = "0";

$specialActionLog = isset($_SESSION["specialActionLog"]) && !empty($_SESSION["specialActionLog"]) ? $_SESSION["specialActionLog"] : "";
if (!empty($specialActionLog)) {
	$GLOBALS['temp']['specialActionLogButtonDisplay'] = "";
	$GLOBALS['temp']['specialActionLogData'] = $specialActionLog;
} else {
	$GLOBALS['temp']['specialActionLogButtonDisplay'] = "display: none;";
	$GLOBALS['temp']['specialActionLogData'] = "";
}

if($_SERVER['argv'][2] == "waitlist") {
	$resdetails = array();
	$dates = array();
	$accommTypes = array();
	$accommTypeList = "";
	$matchedWaitlistedReservations = array();
	$allProperties = array();
	$waitlistRows = "";
	$currencies = array();
	$newResScrollSet = array();

	$itemsdetails = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_accomm_count,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.ac_accomm_type_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",2);

	foreach ($itemsdetails as $detail) {
		$date = $detail['rv_item_date_arrive'];
		$accommTypes[] = $detail['ac_accomm_type_id'];
		while ($date < $detail['rv_item_date_depart']) {
			$resdetails[$date][$detail['ac_accomm_type_id']] = $detail['rv_item_accomm_count'];
			$dates[] = $date;
			$date = date('Y-m-d', strtotime($date . ' + 1 day'));
		}
	}
	$dates = array_unique($dates);
	$accommTypeList = "'" . implode("','", array_unique($accommTypes)) . "'";

	// Search for suitable waitlisted reservations

	$waitlistedReservations = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_amt_accomm_gross,
			CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last) AS agent_desc,
			rv_reservation.rv_res_name,
			rf_reservation_status.rf_reservation_status_desc
		FROM
			rv_reservation
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation.rf_reservation_status_id = '10'
			AND rv_reservation.rv_date_arrive IN ('".implode("','", $dates)."')
			AND DATE_SUB(rv_reservation.rv_date_depart, INTERVAL 1 day) IN ('".implode("','", $dates)."')
			AND rv_reservation.rv_reservation_ix != '$record'
	",2);

	if (!empty($waitlistedReservations)) {
		foreach ($waitlistedReservations as $waitlistedReservation) {
			$pass = true;
			$itemsdetails = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.pr_business_id,
					pr_persona.pr_name_last,
					rf_currency.rf_currency_symbol
				FROM
					rv_reservation_item
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
					LEFT JOIN fn_folio ON fn_folio.rv_reservation_id = '".$waitlistedReservation['rv_reservation_ix']."'
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				WHERE
					rv_reservation_item.rv_reservation_id = '".$waitlistedReservation['rv_reservation_ix']."'
					AND rv_reservation_item.ac_accomm_type_id IN ($accommTypeList)
			",2);

			$properties = array();

			foreach ($itemsdetails as $detail) {
				$properties[] = $detail['pr_name_last'];
				$date = $detail['rv_item_date_arrive'];
				while ($date < $detail['rv_item_date_depart']) {
					if (isset($resdetails[$date][$detail['ac_accomm_type_id']]) && $detail['rv_item_accomm_count'] > $resdetails[$date][$detail['ac_accomm_type_id']]) {
						$pass = false;
					}
					$date = date('Y-m-d', strtotime($date . ' + 1 day'));
				}
				$currencies[$waitlistedReservation['rv_reservation_ix']] = $detail['rf_currency_symbol'];
			}
			if ($pass) {
				$properties = array_unique($properties);
				foreach ($properties as $property) {
					$allProperties[] = $property;
					$matchedWaitlistedReservations[$property][] = $waitlistedReservation;
				}
			}
		}
	}

	// Search for suitable waitlisted itineraries

	$waitlistedReservations = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_amt_accomm_gross,
			rv_reservation.rv_res_name,
			pr_persona.pr_persona_ix,
			CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last) AS agent_desc,
			rt_component.rt_component_desc,
			rf_reservation_status.rf_reservation_status_desc
		FROM
			rv_reservation
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rt_component.rt_component_desc LIKE '%wait%'
			AND rv_reservation.rv_date_arrive IN ('".implode("','", $dates)."')
			AND DATE_SUB(rv_reservation.rv_date_depart, INTERVAL 1 day) IN ('".implode("','", $dates)."')
	",2);

	if (!empty($waitlistedReservations)) {
		foreach ($waitlistedReservations as $waitlistedReservation) {
			$pass = true;
			$itemsdetails = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.pr_business_id,
					pr_persona.pr_name_last,
					rf_currency.rf_currency_symbol
				FROM
					rv_reservation_item
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
					LEFT JOIN fn_folio ON fn_folio.rv_reservation_id = '".$waitlistedReservation['rv_reservation_ix']."'
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				WHERE
					rv_reservation_item.rv_reservation_id = '".$waitlistedReservation['rv_reservation_ix']."'
					AND rv_reservation_item.ac_accomm_type_id IN ($accommTypeList)
			",2);

			$properties = array();

			foreach ($itemsdetails as $detail) {
				$properties[] = $detail['pr_name_last'];
				$date = $detail['rv_item_date_arrive'];
				while ($date < $detail['rv_item_date_depart']) {
					if (isset($resdetails[$date][$detail['ac_accomm_type_id']]) && $detail['rv_item_accomm_count'] > $resdetails[$date][$detail['ac_accomm_type_id']]) {
						$pass = false;
					}
					$date = date('Y-m-d', strtotime($date . ' + 1 day'));
				}
				$currencies[$waitlistedReservation['rv_reservation_ix']] = $detail['rf_currency_symbol'];
			}
			if ($pass) {
				$properties = array_unique($properties);
				foreach ($properties as $property) {
					$allProperties[] = $property;
					$waitlistedReservation['rf_reservation_status_desc'] .= " (itin)";
					$matchedWaitlistedReservations[$property][] = $waitlistedReservation;
				}
			}
		}
	}

	// Search for suitable requests received

	$reqReceivedReservations = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rf_reservation_status_id,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,
			rv_reservation.rv_agent_id,
			rv_reservation.rv_amt_accomm_gross,
			CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last) AS agent_desc,
			rv_reservation.rv_res_name,
			rf_reservation_status.rf_reservation_status_desc
		FROM
			rv_reservation
			LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
		WHERE
			rv_reservation.rf_reservation_status_id != '25' 
			AND rv_reservation.rf_reservation_status_id != '15' 
			AND (
				rv_reservation.rf_reservation_status_id < '40'
				OR rv_reservation.rf_reservation_status_id = '95'
			)
			AND rv_reservation.rv_date_arrive IN ('".implode("','", $dates)."')
			AND DATE_SUB(rv_reservation.rv_date_depart, INTERVAL 1 day) IN ('".implode("','", $dates)."')
			AND rv_reservation.rv_consultant_id = '0'
	",2);

	if (!empty($reqReceivedReservations)) {
		foreach ($reqReceivedReservations as $reqReceivedReservation) {
			$pass = true;
			$itemsdetails = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.rv_item_accomm_count,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.pr_business_id,
					pr_persona.pr_name_last,
					rf_currency.rf_currency_symbol
				FROM
					rv_reservation_item
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
					LEFT JOIN fn_folio ON fn_folio.rv_reservation_id = '".$reqReceivedReservation['rv_reservation_ix']."'
					LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				WHERE
					rv_reservation_item.rv_reservation_id = '".$reqReceivedReservation['rv_reservation_ix']."'
					AND rv_reservation_item.ac_accomm_type_id IN ($accommTypeList)
			",2);

			$properties = array();

			foreach ($itemsdetails as $detail) {
				$properties[] = $detail['pr_name_last'];
				$date = $detail['rv_item_date_arrive'];
				while ($date < $detail['rv_item_date_depart']) {
					if (isset($resdetails[$date][$detail['ac_accomm_type_id']]) && $detail['rv_item_accomm_count'] > $resdetails[$date][$detail['ac_accomm_type_id']]) {
						$pass = false;
					}
					$date = date('Y-m-d', strtotime($date . ' + 1 day'));
				}
				$currencies[$reqReceivedReservation['rv_reservation_ix']] = $detail['rf_currency_symbol'];
			}
			if ($pass) {
				$properties = array_unique($properties);
				foreach ($properties as $property) {
					$allProperties[] = $property;
					$reqReceivedReservation['rf_reservation_status_desc'] = "Req Received";
					$matchedWaitlistedReservations[$property][] = $reqReceivedReservation;
				}
			}

		}
	}

	$allProperties = array_unique($allProperties);

	foreach ($allProperties as $property) {
		if (isset($matchedWaitlistedReservations[$property])) {
			$resIDListed = array();
			foreach ($matchedWaitlistedReservations[$property] as $key => $res) {
				if (!in_array($res['rv_reservation_ix'], $resIDListed)) {
					$newResScrollSet[] = $resIDListed[] = $res['rv_reservation_ix'];
				} else {
					unset($matchedWaitlistedReservations[$property][$key]);
				}
			}
		}
	}

	$newResScrollSet = array_unique($newResScrollSet);

	foreach ($allProperties as $property) {
		if (isset($matchedWaitlistedReservations[$property])) {
			$waitlistRows .= '
				<tr style="height: 20px;" valign="top">
					<td colspan="8" class="bb bt" style="font-weight:bold;">'.$property.'</td>
				</tr>
			';
			foreach ($matchedWaitlistedReservations[$property] as $res) {
				$waitlistRows .= '
					<tr class="imgLink" style="height: 20px;" onmouseover="this.style.backgroundColor = \'#cfc\';"  onmouseout="this.style.backgroundColor = \'\';" onclick="window.location = \'reservation.php?2+'.$res['rv_reservation_ix'].'+resScrollSet:'.implode(":", $newResScrollSet).'\';" valign="top">
						<td class="br">'.$res['rv_reservation_ix'].'</td>
						<td class="br">'.$res['rv_res_name'].'</td>
						<td class="br ">'.$res['rf_reservation_status_desc'].'</td>
						<td class="br">'.$res['agent_desc'].'</td>
						<td class="br">'.$res['rv_date_arrive'].'</td>
						<td class="br">'.$res['rv_date_depart'].'</td>
						<td align="right">'.$res['rv_amt_accomm_gross'].'</td>
						<td align="right" width="10">'.($res['rv_amt_accomm_gross'] != "" ? $currencies[$res['rv_reservation_ix']] : "").'</td>
					</tr>
				';
			}
		}
	}

	if (!empty($waitlistRows)) {
		$GLOBALS['temp']['waitlistRows'] = $waitlistRows;
		$GLOBALS['temp']['waitlistContainerDisplay'] = "";
		$GLOBALS['temp']['waitlistCenterDivYN'] = "1";
	}
}

$GLOBALS['temp']['overbookingContainerDisplay'] = "display: none;";
$GLOBALS['temp']['overbookingCenterDivYN'] = "0";

if($_SERVER['argv'][2] == "overbookingError") {
	$GLOBALS['temp']['overbookingContainer'] = "";
	$GLOBALS['temp']['overbookingCenterDivYN'] = "1";
}
	


if($GLOBALS['jobLevelArray'][0] < 15 || $GLOBALS['lDB']->isMaster != "1" || $GLOBALS['isPropServer']) {
	$GLOBALS['temp']['recalcClass'] = "collapse";
} else {
	$GLOBALS['temp']['recalcClass'] = "";
}

// Verify that the user can edit, or delete for this reservation. Redirect if
// invalid
$canEditReservation = canEditReservation($record);
$canDeleteReservation = canDeleteReservation($record);

if ( $action == "3" && !$canEditReservation ) {
	redirectTo(" ./reservation.php?0+".$_SERVER['argv'][1]."+".$_SERVER['argv'][2]);
}

// Validate the status. Only allow edit on confirmed reservations if you are
// management user
if ( !canEditReservation($record) || $GLOBALS['jobLevelArray'][2] < "10" ) {
	if ( $GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value == "30" ) {
		if ( $action == "3" ) {
			redirectTo(" ./reservation.php?0+" . $_SERVER['argv'][1] . "+" . $_SERVER['argv'][2]);
		}
	}
}

// Setup the values -----------------------------------------------------------
$GLOBALS['temp']['rate_type_id'] = $GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Value;
$rateCurrencyList = array();

// Reservation Currency -------------------------------------------------------
$sql="
	SELECT
		rf_currency_ix,
		rf_currency_name
	FROM
		rf_currency
	WHERE
		rf_currency_ix NOT IN ('" . join("','", $rateCurrencyList) . "')
	ORDER BY
		rf_currency.rf_currency_name
";

$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Select(combolist($GLOBALS['lDB'], $sql));
$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->StyleType = "txt";
$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Width = "110";
$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->ShowInput = "1";

if ($action == "2") {
	if ($pmode == "0") {
		$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->Value = $GLOBALS['lDB']->get("
			SELECT
				rt_rate_type.rf_currency_id
			FROM
				rf_default
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default.rt_rate_type_id
		", 4);
	} else {
		$GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id']->SetValue($GLOBALS['lDB']->get("
			SELECT
				rf_currency_id
			FROM
				rt_rate_type
			WHERE
				rt_rate_type_ix = '" . $_POST['rt_rate_type_id'] . "'
		", 4));
	}
}

// Consultant Id and Name -----------------------------------------------------
$consultantSql = "
	SELECT
		sc_user.pr_user_id,
		IF(pr_persona.pr_persona_inactive_yn<>0,CONCAT('* ',pr_persona.pr_name_last),pr_persona.pr_name_last) as pr_name_last,
		pr_persona.pr_name_first
	FROM
		sc_group
		INNER JOIN sc_user ON sc_group.sc_group_id = sc_user.sc_group_id
		INNER JOIN pr_persona ON sc_user.pr_user_id = pr_persona.pr_persona_ix
	WHERE
		sc_group.sc_grp_consultant_yn=1
		AND (
			pr_persona.pr_persona_inactive_yn=0
			OR (
				pr_persona.pr_persona_inactive_yn<>0
				AND pr_persona.pr_persona_ix = '".$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->Value."'
			)
		)
	ORDER BY
		pr_persona.pr_name_first,
		pr_persona.pr_name_last
";
$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->Select(combolist($GLOBALS['lDB'], $consultantSql, "0-"));
$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->StyleType = "txt";
$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->Width = "206";
$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->Size = "50";
if ($action == "1") {
	$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->IsDisabled = "1";
}

// Commission Deduct YN
$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->Select(array("0" => "0:|:No", "1" => "1:|:Yes"));
$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->Width = "110";
$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->ShowInput = "1";
$GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn']->StyleType = "txt";

// Commission Percentage
$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Size = "5";
$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->StyleType = "txtR";
$GLOBALS[$form.'_rv_reservation_rv_commission_perc']->Width = "82";

// Reservation Name
$GLOBALS[$form.'_rv_reservation_rv_res_name']->Class = "0";
$GLOBALS[$form.'_rv_reservation_rv_res_name']->StyleType = "txt";
$GLOBALS[$form.'_rv_reservation_rv_res_name']->Tabindex = "1";
$GLOBALS[$form.'_rv_reservation_rv_res_name']->Size = "35";
$GLOBALS[$form.'_rv_reservation_rv_res_name']->Width = "206";
if ($action == "1") {
	$GLOBALS[$form.'_rv_reservation_rv_res_name']->IsDisabled = "1";
}

// Reservation Name
$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->Class = "0";
$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->StyleType = "txt";
$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->Tabindex = "1";
$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->Size = "255";
$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->Width = "206";

if ($action == "1") {
	$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->IsDisabled = "1";
}

// Rate type
$tmpsql = "
	SELECT
		rt_rate_type_ix,
		rt_rate_type_desc
	FROM
		rt_rate_type
	WHERE
		rt_rate_type_inactive_yn = 'N'
		OR rt_rate_type_ix = '".$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Value."'
	ORDER BY
		rt_rate_type_desc asc
";
$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Select = combolist($db, $tmpsql);
$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Class = "3";
$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Width = "110";
$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->ShowInput = 1;
$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->StyleType = "txt";
if ($action == "2" && $pmode == "0") {
	$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->Value = $GLOBALS['lDB']->get("select rt_rate_type_id from rf_default", 4);
}

if ($pmode == "0") {
	$agentName = getPersona("pr_name_last, pr_name_first", $GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value, 1);
	$agentName = trim($agentName['pr_name_first']." ".$agentName['pr_name_last']);
	$GLOBALS[$form]->AddField("agent_name", "agent_name", $agentName, 0);
	$GLOBALS['agent_name']->Width = "180";
	if ($GLOBALS['agent_name']->Value == "0" || $GLOBALS['agent_name']->Value == "") {
		$GLOBALS['agent_name']->Value = "Direct";
	}
	$GLOBALS['agent_name']->TabIndex = "2";
	$GLOBALS['agent_name']->StyleType = "txt";

	$contactName = getPersona("pr_name_last, pr_name_first", $GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value, 1);
	$contactName = trim($contactName['pr_name_first']." ".$contactName['pr_name_last']);
	$GLOBALS[$form]->AddField("contact_name", "contact_name", $contactName, 0);
	$GLOBALS['contact_name']->Width = "180";
	if ($GLOBALS['contact_name']->Value == "0" || $GLOBALS['contact_name']->Value == "") {
		$GLOBALS['contact_name']->Value = "No Contact";
	}
	$GLOBALS['contact_name']->TabIndex = "3";
	$GLOBALS['contact_name']->StyleType = "txt";

	$GLOBALS[$form]->AddField("originator", "originator", "", 0);
	$GLOBALS['originator']->Width = "180";
	if($GLOBALS[$form.'_rv_reservation_rv_origin_agent_id']->Value != "0" && trim($GLOBALS[$form.'_rv_reservation_rv_origin_agent_id']->Value) != "") {
		$originatorName = getPersona("pr_name_last, pr_name_first", $GLOBALS[$form.'_rv_reservation_rv_origin_agent_id']->Value, 1);
		$GLOBALS['originator']->Value = trim($originatorName['pr_name_first']." ".$originatorName['pr_name_last']);
		if ($GLOBALS['originator']->Value == "0" || $GLOBALS['originator']->Value == "") {
			$GLOBALS['originator']->Value = "";
		}
	} else {
		$GLOBALS['originator']->Value = "";
	}
	$GLOBALS['originator']->TabIndex = "4";
	$GLOBALS['originator']->StyleType = "txt";

	$srcId = $GLOBALS[$form.'_rv_reservation_rf_source_ix']->Value;
	$srcName = $GLOBALS['lDB']->get("select rf_source_desc from rf_source where rf_source_ix = '".$srcId."'", 4);
	$GLOBALS[$form]->AddField("src_name", "src_name", $srcName, 0);
	if ($GLOBALS['src_name']->Value == "0" || $GLOBALS['src_name']->Value == "") {
		$GLOBALS['src_name']->Value = "";
	}
	$GLOBALS['src_name']->TabIndex = "2";
	$GLOBALS['src_name']->StyleType = "txt";

	$allocCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
	",4);
	$showLabels = new tpParseObject();
	$showLabels->setParam("style","display:none");
	$GLOBALS['tagList']['showLabel1'] = $showLabels;
	$GLOBALS['tagList']['showLabel2'] = $showLabels;
	$GLOBALS['tagList']['showLabel3'] = $showLabels;
	$GLOBALS['tagList']['showLabel4'] = $showLabels;
	$hideSearchButtons = new tpParseObject();
	$hideSearchButtons->setParam("style","");
	$GLOBALS['tagList']['hideSearchButton1'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton2'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton3'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton4'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton5'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton6'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton7'] = $hideSearchButtons;

	if($allocCount > 0) {
		$disableAgentCell = new tpParseObject();
		$disableAgentCell->setParam("style","display:block; padding-bottom: 5px;");
		$disableAgentCell->setParam("onmouseover","overlib('The agent cannot be changed as there are allocation draw downs on this reservation.');");
		$disableAgentCell->setParam("onmouseout","nd();");
		$disableAgentCell->setParam("onclick","cancelBubble = true;");
		$GLOBALS['tagList']['hideSearchButton2'] = $disableAgentCell;
		$disableAgentCell->setParam("style","");
		$GLOBALS['tagList']['agentOverlib'] = $disableAgentCell;
		$disableAgentButton = new tpParseObject();
		$disableAgentButton->setParam("style","display:none");
		$GLOBALS['tagList']['agent_button'] = $disableAgentButton;
		$showLabels = new tpParseObject();
		$showLabels->setParam("style","");
		$GLOBALS['tagList']['showLabel2'] = $showLabels;
	}

	if ($action == "1") {
		$hideSearchButtons = new tpParseObject();
		$hideSearchButtons->setParam("style","display:none");
		$GLOBALS['tagList']['hideSearchButton1'] = $hideSearchButtons;
		$GLOBALS['tagList']['hideSearchButton2'] = $hideSearchButtons;
		$GLOBALS['tagList']['hideSearchButton3'] = $hideSearchButtons;
		$GLOBALS['tagList']['hideSearchButton4'] = $hideSearchButtons;
		$GLOBALS['tagList']['hideSearchButton6'] = $hideSearchButtons;
		$showLabels = new tpParseObject();
		$showLabels->setParam("style","");
		$GLOBALS['tagList']['showLabel1'] = $showLabels;
		$GLOBALS['tagList']['showLabel2'] = $showLabels;
		$GLOBALS['tagList']['showLabel3'] = $showLabels;
		$GLOBALS['tagList']['showLabel4'] = $showLabels;

		$GLOBALS['agent_name']->Width = "206";
		$GLOBALS['src_name']->Width = "206";
	}
}

if (!canEditReservationDetails()) {
	$hideSearchButtons = new tpParseObject();
	$hideSearchButtons->setParam("style","display:none");
	$GLOBALS['tagList']['hideSearchButton1'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton2'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton3'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton4'] = $hideSearchButtons;
	$GLOBALS['tagList']['hideSearchButton6'] = $hideSearchButtons;
	$showLabels = new tpParseObject();
	$showLabels->setParam("style","");
	$GLOBALS['tagList']['showLabel1'] = $showLabels;
	$GLOBALS['tagList']['showLabel2'] = $showLabels;
	$GLOBALS['tagList']['showLabel3'] = $showLabels;
	$GLOBALS['tagList']['showLabel4'] = $showLabels;

	$GLOBALS['agent_name']->Width = "206";
	$GLOBALS['src_name']->Width = "206";
	$GLOBALS[$form.'_rv_reservation_rv_res_name']->IsDisabled = "1";
	$GLOBALS[$form.'_rv_reservation_rv_consultant_id']->IsDisabled = "1";
	$GLOBALS[$form.'_rv_reservation_rv_agent_ref']->IsDisabled = "1";
}

if (!canEditReservation($record) && (canEditReservationDetails() || canEditItineraries())) {
	$GLOBALS['temp']['showModReqButton'] = '';
} else {
	$GLOBALS['temp']['showModReqButton'] = 'collapse';
}

$GLOBALS[$form.'_rv_reservation_rt_rate_type_id']->TabIndex = "7";
$GLOBALS[$form]->AddField($form."_rv_reservation_textfield3", $form."_rv_reservation_textfield3", "",0);
$GLOBALS[$form.'_rv_reservation_textfield3']->TabIndex = "8";
if ($action == "2") {
	if ($GLOBALS['is_an_agent'] == "True") {
		$agentsql = "
			SELECT DISTINCT
				pr_persona.pr_persona_db,pr_persona.pr_persona_id,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				pr_persona
			WHERE
				pr_persona.pr_persona_ix='$GLOBALS[userid]'
				AND pr_persona.pr_sys_code < '6'
			ORDER BY
				pr_persona.pr_name_last
		";
		if ($pmode == "0" && $action == "2") {
			$GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value = $GLOBALS['userid'];
		}
	} elseif ($GLOBALS['pr_business_link'] != "0") {
		$agentsql = "
			SELECT DISTINCT
				pr_persona.pr_persona_db,pr_persona.pr_persona_id,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				pr_agent
				INNER JOIN pr_persona ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
			WHERE
				pr_agent.pr_agent_inactive_yn = 0
				AND pr_persona.pr_sys_code < '6'
			ORDER BY
				pr_persona.pr_name_last
		";
		if ($pmode == "0" && $action == "2") {
			$GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value = $GLOBALS['pr_business_link'];
		}
	} elseif ($GLOBALS['pr_agent_link'] != "0") {
		$agentsql = "
			SELECT DISTINCT
				pr_persona.pr_persona_db,pr_persona.pr_persona_id,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				pr_persona
				INNER JOIN pr_link ON pr_link.pr_link_to = pr_persona.pr_persona_ix
			WHERE
				pr_link.pr_link_from = '$GLOBALS[userid]'
				AND pr_link.rf_link_type_id = 'RS2'
				AND pr_persona.pr_sys_code < '6'
			ORDER BY
				pr_persona.pr_name_last
		";
		if ($pmode == "0" && $action == "2") {
			$GLOBALS[$form.'_rv_reservation_rv_agent_id']->Value = $GLOBALS['pr_agent_link'];
		}
	} else {
		$agentsql = "
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_last,
				pr_persona.pr_name_first
			FROM
				pr_persona
			WHERE
				pr_persona_id < '0'
				AND pr_persona.pr_sys_code < '6'
			ORDER BY
				pr_persona.pr_name_last
		";
	}
}
if ($GLOBALS['pr_agent_link'] != "0") {
	$contactsql = "
		SELECT DISTINCT
			pr_persona.pr_persona_db,pr_persona.pr_persona_id,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			pr_persona
			INNER JOIN pr_link ON pr_link.pr_link_to = pr_persona.pr_persona_ix
		WHERE
			pr_persona.pr_persona_inactive_yn = 0
			AND pr_link.pr_link_to = '$GLOBALS[pr_agent_link]'
			AND pr_link.rf_link_type_id = 'RS2'
			AND pr_persona.pr_sys_code < '6'
		ORDER BY
			pr_persona.pr_name_last
	";
	if ($pmode == "0" && $action == "2") {
		$GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value = $GLOBALS['userid'];
	}
}
if ($GLOBALS['pr_business_link'] != "0") {
	$contactsql = "
		SELECT
			pr_persona.pr_persona_db,pr_persona.pr_persona_id,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			pr_business
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
		WHERE
			pr_persona.pr_persona_inactive_yn=0
			AND pr_business.pr_business_id Is Null
			AND pr_persona.pr_sys_code < '6'
		ORDER BY
			pr_persona.pr_name_last
	";
	if ($pmode == "0" && $action == "2") {
		$GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value = $GLOBALS['userid'];
	}
}

$GLOBALS['temp']['link_name'] = "";
if ($GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value != "") {
	$link_id = idBusLink($GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value);
	if ($link_id == "0") {
		$link_id = idAgentLink($GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value);
	}
	if ($link_id != "0") {
		$sql = "select pr_name_last, pr_name_first from pr_persona where pr_persona_ix = '$link_id'";
		$temp = $GLOBALS['lDB']->get($sql, 1);
		$name = $temp[0];
		if ($temp[1] != "") {
			$name .= ", ".$temp[1];
		}
		$GLOBALS['temp']['link_name'] = $name;
	}
}

$GLOBALS['temp']['hideBlockDetails'] = "display:none;";
$GLOBALS['temp']['hidebtnBlockUnlink'] = "display:none;";
$GLOBALS['temp']['bl_block_ix'] = "";
$GLOBALS['temp']['bl_block_name'] = "";
$blockDetails = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_ix,
		bl_block.bl_block_name
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
		LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
		LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
	WHERE
		draw_down_item.rv_reservation_id = '$record'
",1);
if (!empty($blockDetails)) {
	$GLOBALS['temp']['hideBlockDetails'] = "display:block;";
	$GLOBALS['temp']['bl_block_ix'] = $blockDetails['bl_block_ix'];
	$GLOBALS['temp']['bl_block_name'] = $blockDetails['bl_block_name'];

	// If blocks are shown, and user have access to override Blocks, show the Unlink button
	if (db_sc_group_get_user_setting("sc_grp_res_ovr_alloc_yn") == 1) {
		$GLOBALS['temp']['hidebtnBlockUnlink'] = "display:block;";
	}
}

// Date Consultant
$GLOBALS[$form.'_rv_reservation_rv_date_consultant']->StyleType = "txt";
$GLOBALS[$form.'_rv_reservation_rv_date_consultant']->Size = "35";


$GLOBALS[$form.'_rv_reservation_rv_invoice_date']->Size = "12";
$GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val'] = $GLOBALS[$form.'_rv_reservation_rv_invoice_date']->Value;

$GLOBALS[$form.'_rv_reservation_rv_cancel_date']->Size = "7";
$GLOBALS['tagList']['rv_cancel_date_val'] = $GLOBALS[$form.'_rv_reservation_rv_cancel_date']->Value;

$GLOBALS[$form.'_rv_reservation_rv_provision_expiry_date']->Size = "7";
$GLOBALS['tagList']['rv_provision_expiry_date_val'] = $GLOBALS[$form.'_rv_reservation_rv_provision_expiry_date']->Value;
$GLOBALS[$form.'_rv_reservation_rv_prov_date']->Size = "7";
$GLOBALS['tagList']['rv_prov_date_val'] = chng_date($GLOBALS[$form.'_rv_reservation_rv_prov_date']->Value, "-");

$GLOBALS[$form.'_rv_reservation_rv_wait_list_date']->Size = "7";
$waitlistdate_notime = explode(" ", $GLOBALS[$form.'_rv_reservation_rv_wait_list_date']->Value);
$GLOBALS['tagList']['rv_wait_list_date_val'] = $waitlistdate_notime[0];

$GLOBALS[$form.'_rv_reservation_rv_confirmation_date']->Size = "7";
$GLOBALS['tagList']['rv_confirmation_date_val'] = $GLOBALS[$form.'_rv_reservation_rv_confirmation_date']->Value;

$GLOBALS['temp'][$form.'_rv_reservation_rv_date_recorded_val'] = $GLOBALS[$form.'_rv_reservation_rv_date_recorded']->Value;
$GLOBALS['temp'][$form.'_rv_reservation_rv_date_changed_val'] = $GLOBALS[$form.'_rv_reservation_rv_date_changed']->Value;

if ($GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val'] != "0000-00-00" && $GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val'] != "") {
	$temp = explode("-", $GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val']);
	$nicename = date("d M Y", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val'] = $nicename;
	$GLOBALS[$form.'_rv_reservation_rv_invoice_date']->Value = $nicename;
} else {
	$GLOBALS['temp'][$form.'_rv_reservation_rv_invoice_date_val'] = "-";
	$GLOBALS[$form.'_rv_reservation_rv_invoice_date']->Value = "-";
}

$GLOBALS['tagList']['notesicon'] = "";
if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value == "90") {
	$temp = explode("-", $GLOBALS['tagList']['rv_cancel_date_val']);
	$nicename = date("d M Y", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$GLOBALS['tagList']['rv_cancel_date_val'] = "<a>".$nicename."</a>";
	$cancel_reason = str_replace("<br>", "", $GLOBALS[$form.'_rv_reservation_rv_cancel_reason']->Value);
	$GLOBALS['tagList']['notesicon'] = "<a href=\"#\"><img name=\"notes1\" border=\"0\" src=\"/resource/Resrequest/Application/public/img/notes_std.gif\" width=\"15\" height=\"15\" onMouseOver=\"overlib('".t_encodeOverlib($cancel_reason)."',WIDTH,160);\" onMouseOut=\"nd()\"></a>";
	foreach ($GLOBALS[$form.'']->FieldList as $field1) {
		if ($field1 != $form.'_rv_reservation_rf_source_ix') {
			array_push($GLOBALS[$table]->Keys, $field1);
			$GLOBALS[$field1]->IsDisabled = "1";
		}
	}
} else {
	$GLOBALS['tagList']['rv_cancel_date_val'] = "-";
}
if ($GLOBALS['tagList']['rv_provision_expiry_date_val'] != "0000-00-00" && $GLOBALS['tagList']['rv_provision_expiry_date_val'] != "") {
	$now = date("U", mktime (0, 0, 0, date("m"), date("d"), date("Y")));
	$temp = explode("-", $GLOBALS['tagList']['rv_provision_expiry_date_val']);
	$provdate = date("U", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$nicename = date("d M Y", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$GLOBALS['tagList']['rv_provision_expiry_date_val'] = "<a class=\"txts\">".$nicename."</a>";
} else {
	$GLOBALS['tagList']['rv_provision_expiry_date_val'] = "-";
}
if ($GLOBALS['tagList']['rv_wait_list_date_val'] != "0000-00-00" && $GLOBALS['tagList']['rv_wait_list_date_val'] != "") {
	$temp = explode("-", $GLOBALS['tagList']['rv_wait_list_date_val']);
	$nicename = date("d M Y", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$GLOBALS['tagList']['rv_wait_list_date_val'] = "<a>".$nicename."</a>";
} else {
	$GLOBALS['tagList']['rv_wait_list_date_val'] = "-";
}
if ($GLOBALS['tagList']['rv_confirmation_date_val'] != "0000-00-00" && $GLOBALS['tagList']['rv_confirmation_date_val'] != "") {
	$temp = explode("-", $GLOBALS['tagList']['rv_confirmation_date_val']);
	$nicename = date("d M Y", mktime (0, 0, 0, $temp[1], $temp[2], $temp[0]));
	$GLOBALS['tagList']['rv_confirmation_date_val'] = "<a>".$nicename."</a>";
} else {
	$GLOBALS['tagList']['rv_confirmation_date_val'] = "-";
}
// Status Date displays for new reservation status ID setup!
if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value == "20") {
	$today = date("Y-m-d"); // 2003-04-24
	if ($today == $GLOBALS[$form.'_rv_reservation_rv_provision_expiry_date']->Value) {
		$GLOBALS['temp']['provColor'] = "#F1C55D";
		$GLOBALS['temp']['changeClass'] = "txtb";
		$GLOBALS['tagList']['expireWord'] = "Expiry:";
		$GLOBALS['tagList']['dateClass'] = setNewParam("class","txts");
	} elseif($today > $GLOBALS[$form.'_rv_reservation_rv_provision_expiry_date']->Value) {
		$GLOBALS['temp']['provColor'] = "#DB4242";
		$GLOBALS['temp']['changeClass'] = "txtb";
		$GLOBALS['tagList']['expireWord'] = "Expiry:";
	} else {
		$GLOBALS['temp']['provColor'] = "";
		$GLOBALS['temp']['changeClass'] = "txt";
		$GLOBALS['tagList']['expireWord'] = "Expires:";
		$GLOBALS['tagList']['dateClass'] = setNewParam("class","txts");
	}
}

$GLOBALS['tagList']['statQuotStyle'] = blankObject();
$GLOBALS['tagList']['statConfStyle'] = blankObject();
$GLOBALS['tagList']['statWaitStyle'] = blankObject();
$GLOBALS['tagList']['statProvStyle1'] = blankObject();
$GLOBALS['tagList']['statProvStyle2'] = blankObject();
$GLOBALS['tagList']['statCancStyle'] = blankObject();
$GLOBALS['tagList']['statDeleteStyle'] = blankObject();
$statusNames = array("0" => "Quotation", "10" => "Waitlist", "20" => "Provisional", "30" => "Confirmed");
$statusNamesB = array("0" => "Quote (Req)", "10" => "Wait (Req)", "20" => "Prov (Req)", "30" => "Confirm (Req)");

$consultant = $GLOBALS[$form.'_rv_reservation_rv_consultant_id']->Value;
switch ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value) {
case 0:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statQuotStyle'] = $temp;
	if ($consultant != "0") {
		$GLOBALS['tagList']['statName0'] = $statusNames[0];
	} else {
		$GLOBALS['tagList']['statName0'] = $statusNamesB[0].":";
	}
	break;
case 10:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statWaitStyle'] = $temp;
	if ($consultant != "0") {
		$GLOBALS['tagList']['statName10'] = $statusNames[10];
	} else {
		$GLOBALS['tagList']['statName10'] = $statusNamesB[10].":";
	}
	break;
case 20:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statProvStyle1'] = $temp;
	$GLOBALS['tagList']['statProvStyle2'] = $temp;

	$temp = new tpParseObject();
	$temp->setParam("class",$GLOBALS['temp']['changeClass']);
	if ($consultant != "0") {
		$temp->setContent($statusNames[20]);
	} else {
		$temp->setContent($statusNamesB[20]);
	}
	$GLOBALS['tagList']['statName20'] = $temp;

	$provColor = new tpParseObject();
	$provColor = setNewParam("bgcolor",$GLOBALS['temp']['provColor']);
	$GLOBALS['tagList']['provColor'] = $provColor;
	break;
case 30:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statConfStyle'] = $temp;
	if ($consultant != "0") {
		$GLOBALS['tagList']['statName30'] = $statusNames[30];
	} else {
		$GLOBALS['tagList']['statName30'] = $statusNamesB[30].":";
	}
	break;
case 40: // Invoiced
	break;
case 50: // Blocked
	break;
case 90:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statCancStyle'] = $temp;
	break;
case 95:
	$temp = new tpParseObject();
	$GLOBALS['tagList']['statDeleteStyle'] = $temp;
	break;
}

// End status date displays
$table = $GLOBALS[$form]->TableList[0];
$disableray = array($form."_rv_reservation_rv_cancel_reason", $form."_rv_reservation_rv_cancel_date", $form."_rv_reservation_rv_invoice_date", $form."_rv_reservation_rv_confirmation_date", $form."_rv_reservation_rv_date_recorded", $form."_rv_reservation_rv_provision_expiry_date", $form."_rv_reservation_rv_prov_date", $form."_rv_reservation_rv_wait_list_date", "src_name", "agent_name", "contact_name", "originator");
$GLOBALS['temp']['origin_agent_style'] = "";
if ($GLOBALS['pr_business_link'] == "0") {
	array_push($disableray, $form."_rv_reservation_rv_origin_agent_id");
}
array_push($disableray, $form."_rv_reservation_rv_invoice_currency_id");
if ($action != "2") {
	array_push($disableray, $form."_rv_reservation_rv_commission_perc");
	array_push($disableray, $form."_rv_reservation_rv_commission_deduct_yn");
	array_push($disableray, $form."_rv_reservation_rt_rate_type_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_invoice_currency_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rt_rate_type_id");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_commission_perc");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_commission_deduct_yn");
}
$isConsultant = $GLOBALS['lDB']->get("select sc_group.sc_grp_consultant_yn from sc_group, sc_user where sc_group.sc_group_id = sc_user.sc_group_id and pr_user_id = '".$GLOBALS['userid']."'", 4);
array_push($disableray, $form."_rv_reservation_rv_date_consultant");
if ($isConsultant == "0" || $GLOBALS['pr_business_link'] == "0" || !canEditReservation($record) || $GLOBALS['jobLevelArray'][2] < 15) {
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_consultant_id");
	array_push($disableray, $form."_rv_reservation_rv_consultant_id");
}

$GLOBALS[$form]->Disable($disableray);

// always disable status id
array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rf_reservation_status_id");
$GLOBALS['tagList']['date_ammend'] = chng_date($GLOBALS[$form.'_rv_reservation_rv_date_changed']->Value, "-");
$GLOBALS['tagList']['date_create'] = chng_date($GLOBALS[$form.'_rv_reservation_rv_date_recorded']->Value, "-");
$temp = $lDB->get("SELECT pr_name_first, pr_name_last FROM pr_persona WHERE pr_persona_ix = '".$GLOBALS[$form.'_rv_reservation_pr_reservation_user_id']->Value."'", 1);
$GLOBALS['tagList']['user_created'] = trim($temp['pr_name_first']." ".$temp['pr_name_last']);
if ($GLOBALS['tagList']['user_created'] == "") {
	$GLOBALS['tagList']['user_created'] = "N/A";
}
$statusId = $GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value;
$statusName = $lDB->get("
	SELECT
		rf_reservation_status_desc
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id = '$statusId'
",4);
$GLOBALS['tagList']['res_status'] = $statusName;
$GLOBALS['temp']['statusClass'] = "txt";
if($statusId == "90") {
	$GLOBALS['temp']['statusClass'] = "txtb";
}
if($statusId == "20") {
	$expDate = $lDB->get("SELECT rv_provision_expiry_date FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);

	$today = date("Y-m-d");
	if ($today == $expDate) {
		$GLOBALS['temp']['provBg'] = "#F1C55D";
		$GLOBALS['tagList']['res_status'] .= " (Expires: ".chng_date($expDate, "-").")";
	} elseif ($today > $expDate) {
		$GLOBALS['temp']['provBg'] = "#DB4242";
		$GLOBALS['tagList']['res_status'] .= " (Expires: ".chng_date($expDate, "-").")";
	}
}
$GLOBALS['tagList']['quoteDate'] = $GLOBALS['tagList']['date_create'];
if (trim($GLOBALS['tagList']['date_ammend']) != "") {
	$GLOBALS['tagList']['quoteDate'] = $GLOBALS['tagList']['date_ammend'];
}
$GLOBALS['temp']['resnotejob'] = "";
$GLOBALS['temp']['resRoomJob'] = "";
$GLOBALS['temp']['sumjob'] = "";

$GLOBALS['temp']['notesTabClass'] = "";
$GLOBALS['temp']['notesDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][138])) {
	$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['notesDisabled'] = "disabled";
}

$GLOBALS['temp']['roomingTabClass'] = "";
$GLOBALS['temp']['roomingDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['roomingDisabled'] = "disabled";
}

$GLOBALS['temp']['financialTabClass'] = "";
$GLOBALS['temp']['financialDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['financialDisabled'] = "disabled";
}


if (
	array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5 &&	// Reservation Notes Add Note
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resnotejob'] = "/reservation.php?137+".$record;
} else {
	$GLOBALS['temp']['resnotejob'] = "/reservation.php?138+".$record;
}
if (
	array_key_exists(216,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][216] > 5 &&	// Edit rooming tab
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?216+".$record;
} else {
	$GLOBALS['temp']['resRoomJob'] = "/reservation.php?215+".$record;
}

if (
	array_key_exists(647,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][647] > 5 &&	// Reservation Billings Edit
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['sumjob'] = "647+".$record;
} else {
	$GLOBALS['temp']['sumjob'] = "646+".$record;
}

// Start Access Control Toolbar Setup
$newr = 1;
$edit = 2;
$view = 0;
$dele = 30;
$sedit = 4;
$snewr = 3;
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if ($canEditReservation && $GLOBALS['jobLevelArray'][2] > 5) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if ($canDeleteReservation) {
		$pgJOBS['del'] = "1";
	}
}
$GLOBALS['tagList']['pgJobNew'] = setNewParam("value",$pgJOBS['add']);
$GLOBALS['tagList']['pgJobEdit'] = setNewParam("value",$pgJOBS['edit']);
$GLOBALS['tagList']['pgJobDelete'] = setNewParam("value",$pgJOBS['del']);
$GLOBALS['tagList']['pgJobSave'] = setNewParam("value",$pgJOBS['save']);
// End Access Control Toolbar Setup

$GLOBALS['temp']['canStatus'] = "0";
$GLOBALS['temp']['resjob'] = "";
$GLOBALS['temp']['resitemjob'] = "";
$GLOBALS['tagList']['manageFolios'] = blankObject();
$GLOBALS['tagList']['itemlink'] = blankObject();
$GLOBALS['tagList']['statusbuttons'] = blankObject();

$isPublicOrExternal = $userStatusId < 2;		// 0 - Public, 1 - External
$canViewReqReceived = checkJob(650);
$hasModification = $lDB->get("
	SELECT
		rv_reservation.rv_mod_yn
	FROM
		rv_reservation
	WHERE
		rv_reservation.rv_reservation_ix = '$record'
",4);

if (!$isPublicOrExternal && $canViewReqReceived && $hasModification && $canEditReservation) {
	$GLOBALS['temp']['showModAsSeenButton'] = '';
} else {
	$GLOBALS['temp']['showModAsSeenButton'] = 'collapse';
}

if ($isPublicOrExternal) {
	$GLOBALS['temp']['internalOnly'] = 'collapse';
} else {
	$GLOBALS['temp']['internalOnly'] = '';
}

switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['temp']['resjob'] = "0";
	$GLOBALS['temp']['resitemjob'] = "5";
	$GLOBALS['temp']['notifyJob'] = "openPopup('reservation.php?642+".$record."+email',500,400)";
	$GLOBALS['mode'] = "display";
	break;
case (2) : // Add Record
	$GLOBALS[$form.'_rv_reservation_rv_reservation_db']->SetValue($dbcode);
	if ($pmode == "1") {
		$tempv0 = $GLOBALS[$form.'_rv_reservation_rv_agent_id']->Varname;
		$val0 = $_POST[$tempv0];
	} else {
		$GLOBALS[$form.'_rv_reservation_rv_corr_persona_id']->Value = $GLOBALS['userid'];
	}
	$GLOBALS['mode'] = "new";
	$GLOBALS['record'] = "0";
	$record = "";
	$_SERVER['argv'][1] = "0";

	$GLOBALS[$form.'_rv_reservation_rv_date_recorded']->SetValue(date('Y-m-d'));
	$GLOBALS[$form]->Arguments = "3";

	$temp1 = blankObject();
	$temp1->setContent("<input type=\"button\" id=\"manFolio\" name=\"manFolio\" onclick=\"openPopup('reservation.php?231+" . $record . "',850,600);\" class=\"button\" style=\"width: 80px; height: 20px;\" value=\"Manage Folios\" />");
	if($userStatusId > 1) {
		$GLOBALS['tagList']['manageFolios'] = $temp1;
	}

	$temp = blankObject();
	$temp->setContent("<input type=\"button\" id=\"address\" name=\"address\" onclick=\"newItemLink()\" class=\"button masterButton\"style=\"width: 100px; height: 20px;\" value=\"Add Itinerary Item\" />");
	$GLOBALS['tagList']['itemlink'] = $temp;
	if ($pmode == "0") {
		$GLOBALS['temp']['resnotejob'] = "#";
		$GLOBALS['temp']['resRoomJob'] = "#";
		$GLOBALS['temp']['sumjob'] = $GLOBALS['job']."#";
		$GLOBALS['temp']['notifyJob'] = "";
	} else {
		$GLOBALS['temp']['notifyJob'] = "openPopup('reservation.php?642+".$record."+email',500,400)";
	}
	break;
case (3) : // Edit Record
	if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $record, 0)) {
		if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value != "90" || (canEditReservation($record) && $GLOBALS['jobLevelArray'][2] == "15")) {
			$GLOBALS['temp']['canStatus'] = "1";
		}
	}
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_date_recorded");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_invoice_date");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_cancel_reason");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_cancel_date");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_wait_list_date");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_provision_expiry_date");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_invoice_date");
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_confirmation_date");
	$GLOBALS['temp']['resjob'] = "2";
	$GLOBALS['temp']['resitemjob'] = "7";
	$GLOBALS['temp']['notifyJob'] = "openPopup('reservation.php?642+".$record."',500,400)";
	$GLOBALS['mode'] = "edit";
	$GLOBALS[$form.'_rv_reservation_rv_date_changed']->SetValue(date('Y-m-d'));
	if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value != "90" || (canEditReservation($record) && $GLOBALS['jobLevelArray'][2] == "15")) {
		if (!$GLOBALS['lDB']->count("rv_reservation_item", "rv_reservation_id", $record, "0")) {
			# set the statusbuttons
			$temp = blankObject();
			$temp->setContent("<input type=\"button\" id=\"statusButton\" onclick=\"buttonPress('Status')\" class=\"button masterButton\" value=\"Change Status\" onmouseover=\"overlib('This area shows the current status of the reservation.<br />The status can be changed in edit-mode by clicking the <b>Change Status</b> button.',BELOW,OFFSETY,10,WIDTH,170)\" onmouseout=\"nd()\" />");
			$GLOBALS['tagList']['statusbuttons'] = $temp;
		}
	}
	$GLOBALS[$form]->Arguments = "4+".$GLOBALS['record'];
	$temp1 = blankObject();
	$temp1->setContent("<input type=\"button\" id=\"manFolios\" name=\"manFolios\" onclick=\"openPopup('reservation.php?231+" . $record . "',850,600);\" class=\"button \" style=\"width: 80px; height: 20px;\" value=\"Manage Folios\" />");
	if($userStatusId > 1) {
		$GLOBALS['tagList']['manageFolios'] = $temp1;
	}

	$temp = blankObject();
	$temp->setContent("<input type=\"button\" id=\"address\" name=\"addres\" onclick=\"newItemLink()\" class=\"button masterButton\" style=\"width: 100px; height: 20px;\" value=\"Add Itinerary Item\" />");
	$GLOBALS['tagList']['itemlink'] = $temp;
	break;
case (4) : // Delete Record
	$GLOBALS['initrecord'] = $GLOBALS['record'];
	$GLOBALS['delrecord'] = $_SERVER['argv'][1];
	break;
case (6) : // Delete only specific type of reservations
	if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value == "0" && $record != "" && strlen($record) > 2) {
		db_rv_reservation_set_status($record,DB_RF_RESERVATION_STATUS_DELETED, false, false, false);
	}
	redirectTo("reservation.php?2+$record");
	break;
	if ($GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value == "0" && $record != "" && strlen($record) > 2) {
		$GLOBALS['lDB']->put("delete from rv_reservation where rv_reservation_ix = '$record'");
		$list = $GLOBALS['lDB']->get("select rv_reservation_item_ix from rv_reservation_item where rv_reservation_id = '".$record."'",3);
		$reservationId = $record;
		$GLOBALS['calendarPage'] = true;
		foreach ($list as $res_item) {
			calDeleteItem($res_item,$reservationId); // This will delete extras / payments / audit trail / folios
		}
	}
	redirectTo("reservation.php?20");
	break;
}

if($userStatusId > 1 && $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5) {
	$temp = blankObject();
	$temp->setContent("<input type=\"button\" id=\"address\" name=\"address\" onclick=\"newItemLink()\" class=\"button masterButton\" style=\"width: 100px; height: 20px;\" value=\"Add Itinerary Item\" />");
	$GLOBALS['tagList']['itemlink'] = $temp;
}

$pluscount = substr_count($GLOBALS[$form]->Arguments, "+");
if ($pluscount < 3) {
	for ($z = $pluscount; $z < 3; $z++) {
		$GLOBALS[$form]->Arguments .= "+";
	}
}
if(!isset($naviset_str)) {
	$naviset_str = "";
}
$GLOBALS[$form]->Arguments .= "naviset=".$naviset_str;
# set the form start tag containing the submit action
$GLOBALS['temp']['formstart'] = "<form name=\"".$form."\" action=\"".$GLOBALS[$form]->TargetPage."?" .$GLOBALS[$form]->Arguments."\" method=\"".$GLOBALS[$form]->Method."\" enctype=\"".$GLOBALS[$form]->Enctype."\">\n";
$value = $GLOBALS['record'];
if ($value == "0") {
	$value = "";
}
$recordnext = $rNext;
$recordprev = $rPrev;
if ($action != "2") {
	$items_count = $db->get("select count(*) from rv_reservation_item where rv_reservation_id = '$record'", "1");
	$itemcount = $items_count[0];
} else {
	$itemcount = "0";
}
$status = $GLOBALS[$form.'_rv_reservation_rf_reservation_status_id']->Value;

$GLOBALS['temp']['nflag'] = "noNotes";
$nflag = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$iflag = $GLOBALS['lDB']->get("SELECT rv_note_internal FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);
$gflag = $GLOBALS['lDB']->get("SELECT rv_note_guests FROM rv_reservation WHERE rv_reservation_ix = '$record'",4);

if ($_SESSION['userStatusId'] > 1) {
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($iflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
} else {
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($gflag)) > 0)) && $action != "2") {
		$GLOBALS['temp']['nflag'] = "notes";
	}
}

$GLOBALS['temp']['eflag'] = "noExtras";
$eflag = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_extra WHERE rv_reservation_id = '$record'",1);
if ($eflag['0'] > 0) {
	$GLOBALS['temp']['eflag'] = "extras";
}

$GLOBALS['temp']['rtabflag'] = "";
$rtabflag = getReservationRooming($record);
if(sizeof($rtabflag['guests']) > 0 || sizeof($rtabflag['rooms']) > 0){
	$GLOBALS['temp']['rtabflag'] = "signal_cellular_4_bar";
}
$userSQL = "";
if ($_SESSION['userStatusId'] <= 1) {
	$userSQL = " AND em_mail_log.pr_user_id = '$GLOBALS[userid]'";
}
$commsql = "SELECT COUNT(*) FROM em_mail INNER JOIN em_mail_log ON em_mail.em_mail_ix = em_mail_log.em_mail_id WHERE em_action = '-1' AND rv_reservation_id LIKE '$record'".$userSQL;
$ctabflag = $GLOBALS['lDB']->get($commsql,4);
$commProvCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ad_reservation WHERE ad_reservation.rv_reservation_id LIKE '$record' AND ad_reservation.ad_res_form = 'Sent Prov Notification'",4);
$GLOBALS['temp']['ctabflag'] = "";
if($ctabflag > 0 || $commProvCheck > 0){
	$GLOBALS['temp']['ctabflag'] = "bEmail";
}

$remSQL = "SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id  = '{$record}'";
$GLOBALS['temp']['retabflag'] = ($GLOBALS['lDB']->get($remSQL,4) > 0 ) ? "show" : "";

$roomCheckIn = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '5'
",4);
$roomCheckOut = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '8'
",4);

$GLOBALS['temp']['rflag'] = "bRoomNone";
if($roomCheckIn > 0 || $roomCheckOut > 0) {
	$roomCheckTime = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_grp_status_time
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$record'
			AND (
				rv_res_item_group.rv_grp_status_ind = '5'
				OR rv_res_item_group.rv_grp_status_ind = '8'
			)
		ORDER BY
			rv_res_item_group.rv_grp_status_time DESC
	",4);
}
if($roomCheckIn > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomIn";
}
if($roomCheckOut > 0) {
	$GLOBALS['temp']['rflag'] = "bRoomOut";
}

$GLOBALS['temp']['resExtraJob'] = "609";
if (canEditReservation($record) && $GLOBALS['jobLevelArray'][2] > 5) {
	$GLOBALS['temp']['resExtraJob'] = "610";
}

# set the reservation number
$GLOBALS['temp']['rnum'] = $record;
$GLOBALS['tagList']['rnum'] = $record;

# set the reservation name
$GLOBALS['tagList']['rname'] = $GLOBALS[$form.'_rv_reservation_rv_res_name']->Value;
if (strlen($GLOBALS['tagList']['rname']) >= 28) {
	$GLOBALS['tagList']['rname'] = substr($GLOBALS['tagList']['rname'], "0", 25)."...";
}
# set imagemap links for this page
$GLOBALS['map'] = "
	<map name=\"Map\">
		<area shape=\"rect\" coords=\"84,2,156,25\" href=\"javascript:openMessage('This function has not been implemented yet')\">
		<area shape=\"rect\" coords=\"159,2,223,23\" href=\"javascript:openMessage('This function has not been implemented yet')\">
		<area shape=\"rect\" coords=\"224,1,295,29\" href=\"javascript:openMessage('This function has not been implemented yet')\">
		<area shape=\"rect\" coords=\"295,2,374,33\" href=\"javascript:openMessage('This function has not been implemented yet')\">
		<area shape=\"rect\" coords=\"373,1,449,29\" href=\"javascript:openMessage('This function has not been implemented yet')\">
	</map>
";

if ($action == "3" && $pmode == "1" && $isConsultant != "0" && $GLOBALS['pr_business_link'] != "0" && canEditReservation($record) && $GLOBALS['jobLevelArray'][2] == "15") {
	if (isset($_POST['rv_consultant_id']) && $_POST['rv_consultant_id'] != "0") {
		$GLOBALS[$form.'_rv_reservation_rv_date_consultant']->SetValue(date("Y-m-d"));
	} else {
		$GLOBALS[$form.'_rv_reservation_rv_date_consultant']->SetValue("0000-00-00");
	}
} else {
	array_push($GLOBALS[$table]->Keys, $form."_rv_reservation_rv_date_consultant");
}
if ($GLOBALS[$form.'_rv_reservation_rv_date_consultant']->Value != "" && $GLOBALS[$form.'_rv_reservation_rv_date_consultant']->Value != "0000-00-00" && $GLOBALS[$form.'_rv_reservation_rv_date_consultant']->Value != "0") {
	$GLOBALS['tagList']['date_allocated'] = setNewParam("value",chng_date($GLOBALS[$form.'_rv_reservation_rv_date_consultant']->Value, "-"));
}

if ($pmode == "0") {
	$form0 = new tpParseObject();
	$form0->setParam("action","reservation.php?".$GLOBALS[$form]->Arguments);
	# set the form submit tag and required hidden fields
	if(!array_key_exists('action',$GLOBALS)) {
		$GLOBALS['action'] = "";
	}
	$form0->setEnd("<input type=\"hidden\" name=\"action\" value=\"".$GLOBALS['action']."\">\n" . "<input type=\"hidden\" id=\"mode\" name=\"mode\" value=\"".$GLOBALS['mode']."\">\n" . "<input type=\"hidden\" name=\"jobid\" value=\"\">\n" . "<input type=\"hidden\" name=\"record\" value=\"$value\" disabled>\n" . "<input type=\"hidden\" name=\"recordnext\" value=\"$recordnext\" disabled>\n" . "<input type=\"hidden\" name=\"recordprev\" value=\"$recordprev\" disabled>\n" . "<input type=\"hidden\" name=\"itemcount\" value=\"$itemcount\">\n" . "<input type=\"hidden\" name=\"naviset\" value=\"$naviset_str\">\n" . "<input type=\"hidden\" id=\"status\" name=\"status\" value=\"$status\">\n</form>\n");

	$GLOBALS['tagList'][$form.''] = $form0;
}

$GLOBALS['tagList'][$form.'_rv_reservation_rv_invoice_currency_id'] = $GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id'];
$GLOBALS['tagList']['rv_consultant_id'] = $GLOBALS[$form.'_rv_reservation_rv_consultant_id'];
$GLOBALS['tagList']['rv_res_name'] = $GLOBALS[$form.'_rv_reservation_rv_res_name'];
$GLOBALS['tagList']['rv_agent_ref'] = $GLOBALS[$form.'_rv_reservation_rv_agent_ref'];
$GLOBALS['tagList']['rt_rate_type_id'] = $GLOBALS[$form.'_rv_reservation_rt_rate_type_id'];
$GLOBALS['tagList']['rv_invoice_currency_id'] = $GLOBALS[$form.'_rv_reservation_rv_invoice_currency_id'];
$GLOBALS['tagList']['rv_commission_deduct_yn'] = $GLOBALS[$form.'_rv_reservation_rv_commission_deduct_yn'];
$GLOBALS['tagList']['rv_commission_perc'] = $GLOBALS[$form.'_rv_reservation_rv_commission_perc'];

if($pmode == "0") {
	$GLOBALS['tagList']['agent_name'] = $GLOBALS['agent_name'];
	$GLOBALS['tagList']['contact_name'] = $GLOBALS['contact_name'];
	$GLOBALS['tagList']['originator'] = $GLOBALS['originator'];
	$GLOBALS['tagList']['src_name'] = $GLOBALS['src_name'];
}

$GLOBALS['tagList']['pr_reservation_user_id'] = $GLOBALS[$form.'_rv_reservation_pr_reservation_user_id'];
$GLOBALS['tagList']['rv_agent_id'] = $GLOBALS[$form.'_rv_reservation_rv_agent_id'];
$GLOBALS['tagList']['rv_corr_persona_id'] = $GLOBALS[$form.'_rv_reservation_rv_corr_persona_id'];
$GLOBALS['tagList']['rv_origin_agent_id'] = $GLOBALS[$form.'_rv_reservation_rv_origin_agent_id'];
$GLOBALS['tagList']['rf_source_ix'] = $GLOBALS[$form.'_rv_reservation_rf_source_ix'];

$GLOBALS['temp']['jobId'] = "700";

if ($pmode == "1") {
	// Reservation being added or edited
	// Audit trails
	$reservationAuditTrail = new AuditTrail($record,TYPE_RESERVATION);
	$moduleFieldValues = array();
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_res_name");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rf_source_ix");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_agent_id");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_origin_agent_id");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_corr_persona_id");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.pr_reservation_user_id");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_consultant_id");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_agent_ref");
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rf_reservation_status_id");
		
	foreach ($moduleFieldValues as $moduleFieldValue) {
		$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
		if (isset($GLOBALS['tagList'][$moduleFieldName]) && isset($_POST[$moduleFieldName])) {
			$reservationAuditTrail->addDetail(
				$GLOBALS['tagList'][$moduleFieldName]->Value,
				$_POST[$moduleFieldName],
				Null,
				Null,
				DB_AD_RES_DETAIL_ACTION_EDIT,
				"resdetail",
				$moduleFieldValue['ad_module_field_name']
			);
		}
	}
	$reservationAuditTrail->save("Reservation Details");

	if ($GLOBALS['userStatusId'] == 1) {
		// Flag modifications made by external users
		$reservationAuditTrail->flagReservationModification();	
	}
}

$GLOBALS['temp']['userStatusId'] = $userStatusId;
$GLOBALS['temp']['userGroupLevel'] = $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]];
$GLOBALS['temp']['sc_grp_res_ovr_overbooking_yn'] = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn");

if (isset($_SESSION["specialActionLog"]) && !empty($_SESSION["specialActionLog"])) {
	session_set("specialActionLog");
}