<?php

/**
 * init.form1000.php - Debtors Report
 * Job: 1000
 * Function: 100 (Financial: GL Account detail - Invoicing Unit List)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$pf_object_id = db_pf_object_by_name("debtor_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Debtor Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if(!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_debtor.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],19,"");

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));


$billingUnitId = $_SERVER['argv'][1];
$propertyACL = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pr_business.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		sc_accomm.sc_group_id= '" . $GLOBALS['sc_group_id'] . "'
		AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
",3);
$billingUnitIds = array();
foreach($propertyACL as $property) {
	$currId = $property;
	$businessId = "";
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn, pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",1);
		if($billingYN['pr_bus_billing_yn'] == "1" || $billingYN['pr_bus_billing_prop_yn'] == "1") {
			$businessId = $currId;
		} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
		}
	}
	array_push($billingUnitIds,$businessId);
}
$billingUnitIds = array_unique($billingUnitIds);
$billingUnitList = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last
	FROM
		pr_persona
	WHERE
		pr_persona.pr_persona_ix IN ('".join("','",$billingUnitIds)."')
",2);

$billingUnitOptions = "";
foreach($billingUnitList as $item) {
	$selected = "";
	if($billingUnitId == $item['pr_persona_ix']) {
		$selected = "selected";
	}
	$billingUnitOptions .= "<option value=\"$item[pr_persona_ix]\" $selected>$item[pr_name_last]</option>";
}
$GLOBALS['temp']['billingUnitOptions'] = $billingUnitOptions;

if($_SERVER['argc'] < 3) {
	$_SERVER['argv'][2] = "0";
}
$batchACL = $GLOBALS['lDB']->get("SELECT fn_batch_ix FROM fn_batch WHERE fn_batch_closed_yn = '0'",3);
array_unshift($batchACL,"0");
$batchFilter = useFilter("batch",$_SERVER['argv'][2], "SELECT fn_batch.fn_batch_name FROM fn_batch WHERE fn_batch.fn_batch_ix =", "fn_batch.fn_batch_ix",$batchACL,"Unallocated","0",true);
if(in_array("0", explode(":",$batchFilter['ids']))) {
	$hasUnallocated = true;
} else {
	$hasUnallocated = false;
}

$serverFilter = useFilter("server",$_SERVER['argv'][3],"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_tran.fn_tran_db",false,"Reservation Office","Res");
$resList = $GLOBALS['lDB']->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter['where'] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter['where']);

$dateRange = $_SERVER['argv'][4];
$GLOBALS['temp']['dateRangeCreationChecked'] = "checked";
$GLOBALS['temp']['dateRangeLedgerChecked'] = "";
if($dateRange == "2") {
	$GLOBALS['temp']['dateRangeCreationChecked'] = "";
	$GLOBALS['temp']['dateRangeLedgerChecked'] = "checked";
}
if($_SERVER['argv'][5] == "") {
	$_SERVER['argv'][5] = date("Y-m-01");
	$_SERVER['argv'][6] = date("Y-m-t");
}
$fromDate = useDate("from", $_SERVER['argv'][5]);
$toDate = useDate("to", $_SERVER['argv'][6]);

if($_SERVER['argv'][7] == "") {
	$_SERVER['argv'][7] = date("Y-m-01");
	$_SERVER['argv'][8] = date("Y-m-t");
}
$fromLedgerDate = useDate("fromLedger", $_SERVER['argv'][7]);
$toLedgerDate = useDate("toLedger", $_SERVER['argv'][8]);

$invoiceRange = $_SERVER['argv'][9];
$GLOBALS['temp']['invoiceRangeChecked'] = "";
if($invoiceRange == "1") {
	$GLOBALS['temp']['invoiceRangeChecked'] = "checked";
}
$invoiceDB = $_SERVER['argv'][10];
$invoicePrefix = $_SERVER['argv'][11];

$invoiceDBArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		fn_folio_db
	FROM
		fn_folio
	ORDER BY
		fn_folio_db
",3);
$invoiceDBList = "";
foreach($invoiceDBArray as $item) {
	if($item == $invoiceDB) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoiceDBList .= "<option $selected value=\"$item\">$item</option>";
}
if($invoiceDB == "") {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoiceDBAllSelected'] = "";
}
$GLOBALS['temp']['invoiceDBList'] = $invoiceDBList;
$invoicePrefixArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		fn_invoice_prefix
	FROM
		fn_invoice
	WHERE
		trim(fn_invoice_prefix) <> ''
	ORDER BY
		fn_invoice_prefix
",3);
$invoicePrefixList = "";
foreach($invoicePrefixArray as $item) {
	if($item == $invoicePrefix) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$invoicePrefixList .= "<option $selected value=\"$item\">$item</option>";	
}
if($invoicePrefix == "") {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['invoicePrefixAllSelected'] = "";
}
$GLOBALS['temp']['invoicePrefixList'] = $invoicePrefixList;

$invoiceFrom = $_SERVER['argv'][12];
$GLOBALS['temp']['invoiceFrom'] = $invoiceFrom;
$invoiceTo = $_SERVER['argv'][13];
$GLOBALS['temp']['invoiceTo'] = $invoiceTo;

$paymentRange = $_SERVER['argv'][14];
$GLOBALS['temp']['paymentRangeChecked'] = "";
if($paymentRange == "1") {
	$GLOBALS['temp']['paymentRangeChecked'] = "checked";
}

$paymentDB = $_SERVER['argv'][15];

$paymentDBArray = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		rv_payment_db
	FROM
		rv_payment
	ORDER BY
		rv_payment_db
",3);
$paymentDBList = "";
foreach($paymentDBArray as $item) {
	if($item == $paymentDB) {
		$selected = " selected ";
	} else {
		$selected = "";
	}
	$paymentDBList .= "<option $selected value=\"$item\">$item</option>";
}
if($paymentDB == "") {
	$GLOBALS['temp']['paymentDBAllSelected'] = "selected";
} else {
	$GLOBALS['temp']['paymentDBAllSelected'] = "";
}
$GLOBALS['temp']['paymentDBList'] = $paymentDBList;


$paymentFrom = $_SERVER['argv'][16];
$GLOBALS['temp']['paymentFrom'] = $paymentFrom;
$paymentTo = $_SERVER['argv'][17];
$GLOBALS['temp']['paymentTo'] = $paymentTo;

$options = $_SERVER['argv'][18];

switch ( $options & 7 ) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "";
}

if($renderMode == "pdf" && $renderType == "email") {
	$pdfName = "Debtors report";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></td>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName.pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,18))."+".$newOptions;

	$GLOBALS[$form]->FormHTML =
		str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))
	))))));
	// get principal
	$principalId = $GLOBALS['lDB']->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $GLOBALS['lDB']->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $GLOBALS['lDB']->get("SELECT pr_persona.pr_email FROM pr_persona WHERE pr_persona.pr_persona_ix = '$userId'", 4);
	$GLOBALS['temp']['emailTo'] = "";
}


if(isset($_POST['debtorCodes']) && trim($_POST['debtorCodes']) != "") {
	$debtorCodes = unserialize(str_replace("\\","",$_POST['debtorCodes']));
	$transactionSQL = "
		SELECT
			fn_tran_item.fn_tran_item_ix
		FROM
			fn_tran_item
			INNER JOIN fn_tran on fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_tran.pr_persona_id
		WHERE
			fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			AND fn_tran.pr_business_id = '$billingUnitId'
			!tranWhere!
			!personaWhere!			
			AND (
				fn_batch.fn_batch_ix IS NULL
				OR fn_batch.fn_batch_closed_yn = '0'
			)
	";
	foreach($debtorCodes as $pr_persona_id=>$item) {
		$fn_debtor_code = $item['debtorCode'];
		$rf_currency_id = $item['currencyId'];
		$transactions = explode(":",$item['transactions']);
		if($fn_debtor_code == "") {
			$fn_debtor_id = "";
		} elseif(!db_fn_debtor_exists_by_code($billingUnitId,$fn_debtor_code)) {
			$contactInfo = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
				FROM
					pr_persona
				WHERE
					pr_persona.pr_persona_ix = '$pr_persona_id'
			",1);
			$fn_debtor_desc = trim($contactInfo['pr_name_first'] . " " . $contactInfo['pr_name_last']);
			$fn_debtor_id = db_fn_debtor_insert($fn_debtor_code, $fn_debtor_desc,$rf_currency_id,$billingUnitId);
		} else {
            $fn_debtor_code_esc = $GLOBALS['lDB']->escape($fn_debtor_code);

			$fn_debtor_id = $GLOBALS['lDB']->get("SELECT fn_debtor_ix FROM fn_debtor WHERE pr_business_id = '{$billingUnitId}' AND fn_debtor_code = '{$fn_debtor_code_esc}'",4);
			db_fn_debtor_set_currency($fn_debtor_id,$rf_currency_id);
		}

		if(!empty($pr_persona_id)) { // not a cash debtor
			$pr_persona_inv_id = db_pr_persona_inv_exists($pr_persona_id,$billingUnitId);
			if($pr_persona_inv_id) {
				db_pr_persona_inv_update($pr_persona_inv_id, $fn_debtor_id, $billingUnitId);
			} else {
				db_pr_persona_inv_insert($fn_debtor_id, $billingUnitId, $pr_persona_id);
			}
		} else { // cash debtor
			db_pr_business_set_cash_debtor($billingUnitId, $fn_debtor_id);
		}

		// Leave unassigned debtors set to the default
		if($fn_debtor_id != "") {
			if(!empty($pr_persona_id)) { // not a cash debtor	
				$personaWhere = "AND pr_persona.pr_persona_ix = '$pr_persona_id'";
			} else {
				$personaWhere = "AND pr_persona.pr_persona_ix IS NULL";
			}
			$transactions = $GLOBALS['lDB']->get(
				str_replace("!personaWhere!",$personaWhere,
				str_replace("!tranWhere!","AND fn_tran.fn_tran_ix IN ('".join("','",$transactions)."')",
			$transactionSQL)),3);
			foreach($transactions as $fn_tran_item_id) {
				db_fn_tran_item_set_debtor($fn_tran_item_id,$fn_debtor_id);
			}
		}
	}
}

$debtors = $GLOBALS['lDB']->get("
	SELECT
		fn_debtor.fn_debtor_ix,
		fn_debtor.fn_debtor_code,
		fn_debtor.fn_debtor_desc
	FROM
		fn_debtor
	WHERE
		fn_debtor.pr_business_id = '$billingUnitId'
	ORDER BY
		fn_debtor.fn_debtor_desc
",2);
$debtorRows = "";
$debtorHTML = "
	<tr onclick=\"debtorSearchSelect('!fn_debtor_code!');\" class='linkrow' onmouseover=\"this.style.backgroundColor = '#CCFFCC';\"  onmouseout=\"this.style.backgroundColor = ''\">
		<td>!fn_debtor!</td>
	</tr>
";
foreach($debtors as $debtor) {
	$debtor['fn_debtor'] = trim($debtor['fn_debtor_desc'] . ": ". $debtor['fn_debtor_code']);

    $debtor['fn_debtor_desc'] = $GLOBALS['lDB']->escape($debtor['fn_debtor_desc']);
    $debtor['fn_debtor_code'] = $GLOBALS['lDB']->escape($debtor['fn_debtor_code']);

	$debtorRows .= showpage($debtor, $debtorHTML);
}
$GLOBALS['temp']['debtorRows'] = $debtorRows;

$currencies = $GLOBALS['lDB']->get("
	SELECT
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		rf_currency.rf_currency_name
	FROM
		rf_currency
	WHERE
		rf_currency_inactive_yn = '0'
",2);
$currencyRows = "";
$currencyHTML = "
	<tr onclick=\"currencySearchSelect('!rf_currency_ix!','!rf_currency!');\" class='linkrow' onmouseover=\"this.style.backgroundColor = '#CCFFCC';\"  onmouseout=\"this.style.backgroundColor = ''\">
		<td>!rf_currency!</td>
	</tr>
";
foreach($currencies as $currency) {
	$currency['rf_currency'] = trim($currency['rf_currency_symbol'] . ": " . $currency['rf_currency_name']);
	$currencyRows .= showpage($currency, $currencyHTML);
}
$GLOBALS['temp']['currencyRows'] = $currencyRows;

$GLOBALS['temp']['makeReport'] = "collapse printCollapse";
$GLOBALS['temp']['filterDivClass'] = "expand";
$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters"; 
if($_SERVER['argc'] > 2) {
	$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Show Filters"; 

	$dateSQL = "";
	if($hasUnallocated) {
		if($dateRange == "1") {
			$dateSQL = "
				AND fn_tran.ad_create_date >= '$fromDate[jsDate] 00:00:00'
				AND fn_tran.ad_create_date <= '$toDate[jsDate] 23:59:59'
			";
		} else {
			$dateSQL = "
				AND fn_tran.fn_tran_date_ledger >= '$fromLedgerDate[jsDate] 00:00:00'
				AND fn_tran.fn_tran_date_ledger <= '$toLedgerDate[jsDate] 23:59:59'
			";
		}
	}

	$rangeSQL = "";
	if($invoiceRange == "1" && $paymentRange != "1") {
		$rangeSQL = "
			AND fn_invoice.fn_invoice_id >= '$invoiceFrom'
			AND fn_invoice.fn_invoice_id <= '$invoiceTo'
			";
		if($invoiceDB != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_db = '$invoiceDB'
			";
		}
		if($invoicePrefix != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_prefix = '$invoicePrefix'
			";
		}
	} elseif ($invoiceRange != "1" && $paymentRange == "1") {
		$rangeSQL = "
			AND rv_payment.rv_payment_id >= '$paymentFrom'
			AND rv_payment.rv_payment_id <= '$paymentTo'
		";
		if($paymentDB != "") {
			$rangeSQL .= "
				AND rv_payment.rv_payment_db = '$paymentDB'
			";
		}
	} elseif ($invoiceRange == "1" && $paymentRange == "1") {
		$rangeSQL = "
			AND (
				(
					fn_invoice.fn_invoice_id >= '$invoiceFrom'
					AND fn_invoice.fn_invoice_id <= '$invoiceTo'
		";
		if($invoiceDB != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_db = '$invoiceDB'
			";
		}
		if($invoicePrefix != "") {
			$rangeSQL .= "
				AND fn_invoice.fn_invoice_prefix = '$invoicePrefix'
			";
		}
		$rangeSQL .= "
				) OR (					
					rv_payment.rv_payment_id >= '$paymentFrom'
					AND rv_payment.rv_payment_id <= '$paymentTo'
		";
		if($paymentDB != "") {
			$rangeSQL .= "
					AND rv_payment.rv_payment_db = '$paymentDB'
			";
		}
		$rangeSQL .= "
				)
			)
		";
	}
	// ensure the GROUP_CONCAT() can handle enough entries
	$GLOBALS['lDB']->group_concat_max_len(1000000);
	$list = $GLOBALS['lDB']->get("
		SELECT
			tran_persona.pr_persona_ix AS tran_persona_id,
			tran_persona.pr_name_last AS tran_name_last,
			tran_persona.pr_name_first AS tran_name_first,
			fn_debtor.fn_debtor_ix,
			fn_debtor.fn_debtor_code,
			fn_debtor.fn_debtor_desc,
			rf_currency.rf_currency_ix AS rf_currency_id,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name,
			COUNT(fn_tran.fn_tran_ix) AS tran_count,
			GROUP_CONCAT(fn_tran.fn_tran_ix SEPARATOR ':') AS transactions
		FROM
			fn_tran
			INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
			LEFT JOIN pr_persona AS tran_persona ON tran_persona.pr_persona_ix = fn_tran.pr_persona_id

			LEFT JOIN pr_persona_inv ON pr_persona_inv.pr_persona_id = fn_tran.pr_persona_id AND pr_persona_inv.pr_business_id = '$billingUnitId'
			LEFT JOIN fn_debtor ON fn_debtor.fn_debtor_ix = pr_persona_inv.fn_debtor_id
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id

			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id

			LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id AND fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."' 
			LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id AND fn_tran.fn_tran_link_ind != '".DB_FN_TRAN_LINK_INVOICE."'
			LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id

		WHERE
			fn_tran.pr_business_id = '$billingUnitId'
			$dateSQL
			$rangeSQL
			$batchFilter[where]
			$serverFilter[where]
		GROUP BY
			tran_persona.pr_persona_ix
		ORDER BY
			tran_persona.pr_name_first,
			tran_persona.pr_name_last
	",2);

	$fn_debtor_cash = $GLOBALS['lDB']->get("
		SELECT
			pr_business.fn_debtor_id_cash,
			fn_debtor.fn_debtor_code,
			fn_debtor.fn_debtor_desc,
			rf_currency.rf_currency_ix AS rf_currency_id,
			rf_currency.rf_currency_symbol,
			rf_currency.rf_currency_name
		FROM
			pr_business
			INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = pr_business.fn_debtor_id_cash
			LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_debtor.rf_currency_id
		WHERE
			pr_business.pr_business_id = '$billingUnitId'
	",1);
	foreach($list as $key=>$item) {
		if(empty($item['tran_persona_id'])) {
			$list[$key]['tran_name_last'] = "Cash";
			$list[$key]['tran_name_first'] = "";
			$list[$key]['fn_debtor_ix'] = $fn_debtor_cash['fn_debtor_id_cash'];
			$list[$key]['fn_debtor_code'] = $fn_debtor_cash['fn_debtor_code'];
			$list[$key]['fn_debtor_desc'] = $fn_debtor_cash['fn_debtor_desc'];
			$list[$key]['rf_currency_id'] = $fn_debtor_cash['rf_currency_id'];
			$list[$key]['rf_currency_symbol'] = $fn_debtor_cash['rf_currency_symbol'];
			$list[$key]['rf_currency_name'] = $fn_debtor_cash['rf_currency_name'];
			$item = $list[$key];
		}
		if(empty($item['rf_currency_id'])) {
			$agentRate = $lDB->get("
				SELECT
					rf_currency.rf_currency_ix,
					rf_currency.rf_currency_symbol,
					rf_currency.rf_currency_name
				FROM
					pr_agent_rate
					INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
					INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
				WHERE
					pr_agent_rate.pr_agent_id = '$item[tran_persona_id]'
				ORDER BY
					pr_agent_rate_default_yn DESC
			",1);
			if(empty($agentRate['rf_currency_ix'])) {
				$list[$key]['rf_currency'] = "None";
			} else {
				$list[$key]['rf_currency_id'] = $agentRate['rf_currency_ix'];
				$list[$key]['rf_currency'] = trim($agentRate['rf_currency_symbol'] . ": " .$agentRate['rf_currency_name']);
			}
		} else {
			$list[$key]['rf_currency'] = trim($item['rf_currency_symbol'] . ": " .$item['rf_currency_name']);
		}
		$cashCheck = $GLOBALS['lDB']->get("
			SELECT
				fn_tran_item.fn_debtor_id
			FROM
				fn_tran
				INNER JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix AND fn_tran_item.fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'
				LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
				LEFT JOIN pr_persona_inv ON pr_persona_inv.pr_persona_id = fn_tran.pr_persona_id AND pr_persona_inv.pr_business_id = '$billingUnitId'
			WHERE
				fn_tran.pr_business_id = '$billingUnitId'
				AND fn_tran.pr_persona_id = '$item[tran_persona_id]'
				AND pr_persona_inv.pr_persona_inv_ix IS NULL
				$dateSQL
				$rangeSQL
				$batchFilter[where]
				$serverFilter[where]				
		",3);
		if(sizeof($cashCheck) == 1 && $cashCheck[0] == $fn_debtor_cash['fn_debtor_id_cash']) {
			//$list[$key]['fn_debtor'
			$list[$key]['fn_debtor_code_new'] = $fn_debtor_cash['fn_debtor_code'];
		} else {
			$list[$key]['fn_debtor_code_new'] = $item['fn_debtor_code'];
		}
	}

	if($renderMode == "html") {		
		$GLOBALS['temp']['makeReport'] = "";
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));

		$GLOBALS['temp']['cashDebtorCode'] = trim($GLOBALS['lDB']->get("
			SELECT
				fn_debtor.fn_debtor_code
			FROM
				pr_business
				INNER JOIN fn_debtor ON fn_debtor.fn_debtor_ix = pr_business.fn_debtor_id_cash AND fn_debtor.pr_business_id = pr_business.pr_business_id
			WHERE
				pr_business.pr_business_id = '$billingUnitId'
		",4));
		$rows = "";
		$rowHTML = join("",file(__DIR__ . "/../../../public/html/rep_debtor_row.htm"));
		foreach($list as $item) {
			$item['tran_persona_name'] = trim($item['tran_name_first'] . " " . $item['tran_name_last']);
			if(trim($item['fn_debtor_code']) != "") {
				$item['fn_debtor'] = $item['fn_debtor_code'] . ": ". $item['fn_debtor_desc'];
			} else {
				$item['fn_debtor'] = "<span class=\"txti\">None</span>";
			}
			$rows .= showpage($item,$rowHTML);
		}
		if($rows == "") {
			$rows = "<tr><td colspan=\"2\" class=\"txti\">No records found</td></tr>";
		}

		$GLOBALS['temp']['rows'] = $rows;

	}
}
