<?php

/**
 * init.form1001.php - Payment gateway code table details
 * Job: 1001,1002,1003,1004,1005,1006
 * Function: 126 (Code Tables: Payment Gateway)
*/

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");
 
if(!array_key_exists($form,$GLOBALS) || !isset($GLOBALS[$form])) {	
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_payment_gateway.htm");
}

if($action != 2) {
	$pg_account_id = $_SERVER['argv'][1];
} else {
	$pg_account_id = "";
}
$GLOBALS['temp']['pg_account_id'] = $pg_account_id;

$rf_currency = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		rf_currency.rf_currency_inactive_yn
	FROM
		rf_currency
		LEFT JOIN pg_acc_currency ON
			pg_acc_currency.rf_currency_id = rf_currency.rf_currency_ix
			AND pg_acc_currency.pg_account_id = '$pg_account_id'
	WHERE
		rf_currency_inactive_yn != '1'
		OR pg_acc_currency.pg_acc_currency_ix IS NOT NULL			
	ORDER BY
		rf_currency.rf_currency_symbol
",2);

if($action != 2 && db_pg_account_exists($pg_account_id)) {
	list(
		$pg_acc_name,
		$pg_acc_external_yn,
		$pg_acc_internal_yn,
		$pg_acc_public_yn,
		$pg_type_id,
		$rf_mthd_pmnt_id,
		$pg_account_inactive_yn,
		$pg_account_sys_code
	) = $GLOBALS['lDB']->get("
		SELECT
			pg_account.pg_acc_name,
			pg_account.pg_acc_external_yn,
			pg_account.pg_acc_internal_yn,
			pg_account.pg_acc_public_yn,
			pg_account.pg_type_id,
			pg_account.rf_mthd_pmnt_id,
			pg_account.pg_account_inactive_yn,
			pg_account.pg_account_sys_code
		FROM
			pg_account
		WHERE
			pg_account.pg_account_ix = '$pg_account_id'
	",1);

	$pg_acc_method = $GLOBALS['lDB']->get("SELECT pg_acc_method.pg_method_id FROM pg_acc_method WHERE pg_acc_method.pg_account_id = '$pg_account_id'",3);
	$pg_acc_business = $GLOBALS['lDB']->get("SELECT pg_acc_business.pr_business_id FROM pg_acc_business WHERE pg_acc_business.pg_account_id = '$pg_account_id'",3);

	foreach($rf_currency as $key=>$item) {
		if(db_pg_acc_currency_exists_by_all($pg_account_id,$item['rf_currency_ix'])) {
			$pg_acc_currency = $GLOBALS['lDB']->get("
				SELECT
					pg_acc_currency.pg_acc_currency_ix,
					pg_acc_currency.rf_bank_id,
					pg_acc_currency.pg_acc_currency_code,
					pg_acc_currency.pg_acc_currency_inactive_yn
				FROM
					pg_acc_currency
				WHERE				
					pg_acc_currency.pg_account_id = '$pg_account_id'
					AND pg_acc_currency.rf_currency_id = '$item[rf_currency_ix]'
			",1);
			$rf_currency[$key]['pg_acc_currency_ix'] = $pg_acc_currency['pg_acc_currency_ix'];
			$rf_currency[$key]['rf_bank_id'] = $pg_acc_currency['rf_bank_id'];
			$rf_currency[$key]['pg_acc_currency_code'] = $pg_acc_currency['pg_acc_currency_code'];
			$rf_currency[$key]['pg_acc_currency_inactive_yn'] = $pg_acc_currency['pg_acc_currency_inactive_yn'];
		}
	}
} else {
	$pg_acc_name = "";
	$pg_acc_external_yn = "0";
	$pg_acc_internal_yn = "0";
	$pg_acc_public_yn = "0";
	$pg_type_id = "";
	$rf_mthd_pmnt_id = "";
	$pg_account_inactive_yn = "1";
	$pg_account_sys_code = "0";
	$pg_acc_method = array();
	$pg_acc_business = array();
}

$GLOBALS['temp']['enabledChecked'] = "";
$GLOBALS['temp']['disabledChecked'] = "";
if($pg_account_inactive_yn == "1") {
	$GLOBALS['temp']['disabledChecked'] = "checked";
} else {
	$GLOBALS['temp']['enabledChecked'] = "checked";
}

$GLOBALS['temp']['pg_acc_name'] = $pg_acc_name;

$pg_type = $GLOBALS['lDB']->get("
	SELECT
		pg_type.pg_type_ix,
		pg_type.pg_type_label,
		pg_type.pg_type_inactive_yn
	FROM
		pg_type
	WHERE
		pg_type.pg_type_inactive_yn = '0'
		OR (
			pg_type.pg_type_ix = '$pg_type_id'
			AND pg_type.pg_type_inactive_yn = '1'
		)
	ORDER BY
		pg_type.pg_type_label
",2);
$pg_type_options = "<option value=\"\"></option>\n";
foreach($pg_type as $item) {
	$selected = "";
	if($item['pg_type_ix'] == $pg_type_id) {
		$selected = "selected";
	}
	$label = $item['pg_type_label'];
	if($item['pg_type_inactive_yn'] == "1") {
		$label = "* " . $label;
	}
	$pg_type_options .= "<option value=\"$item[pg_type_ix]\" $selected>$label</option>\n";
}
$GLOBALS['temp']['pg_type_options'] = $pg_type_options;


$pg_method = $GLOBALS['lDB']->get("
	SELECT
		pg_method.pg_method_ix,
		pg_method.pg_method_name,
		pg_method.pg_method_note,
		pg_method.pg_method_image,
		pg_method.pg_method_inactive_yn
	FROM
		pg_method
	ORDER BY
		pg_method.pg_method_name
",2);
$pg_method_html = "
	<tr>
		<td><input id=\"pg_method_!pg_method_ix!\" name=\"pg_method_!pg_method_ix!\" type=\"checkbox\" !checked! !disabled!></td>
		<td><label for=\"pg_method_!pg_method_ix!\">!image!</label></td>
		<td style=\"line-height:32px;\"><label for=\"pg_method_!pg_method_ix!\">!pg_method_name!</label></td>
	</tr>
";	
$pg_method_rows = "";
foreach($pg_method as $item) {
	$item['disabled'] = "disabled";
	if($action == 3) {
		$item['disabled'] = "";
	}
	$item['checked'] = "";
	if(db_pg_acc_method_exists_by_all($pg_account_id,$item['pg_method_ix'])) {
		$item['checked'] = "checked";
	}
	$image = "images/payment_gateway/$item[pg_method_image]";
	$item['image'] = "&nbsp;";
	if(file_exists($image)) {
		$item['image'] = "<img src=\"$image\" />";
	}
	$pg_method_rows .= showpage($item,$pg_method_html);
}
if(sizeof($pg_method) < 1) {
	$pg_method_rows = "
		<tr>
			<td colspan=\"2\" class=\"txti\" align=\"center\">No payment symbols available</td>
		</tr>
	";
}
$GLOBALS['temp']['pg_method_rows'] = $pg_method_rows;

$rf_mthd_pmnt = $GLOBALS['lDB']->get("
	SELECT
		rf_mthd_pmnt.rf_mthd_pmnt_ix,
		rf_mthd_pmnt.rf_mthd_pmnt_desc,
		rf_mthd_pmnt.rf_mthd_pmnt_inactive_yn
	FROM
		rf_mthd_pmnt
	WHERE
		rf_mthd_pmnt.rf_mthd_pmnt_inactive_yn = '0'
		OR (
			rf_mthd_pmnt.rf_mthd_pmnt_ix = '$rf_mthd_pmnt_id'
			AND rf_mthd_pmnt.rf_mthd_pmnt_inactive_yn = '1'
		)
	ORDER BY
		rf_mthd_pmnt.rf_mthd_pmnt_desc
",2);
$rf_mthd_pmnt_options = "<option value=\"\"></option>\n";
foreach($rf_mthd_pmnt as $item) {
	$selected = "";
	if($item['rf_mthd_pmnt_ix'] == $rf_mthd_pmnt_id) {
		$selected = "selected";
	}
	$label = $item['rf_mthd_pmnt_desc'];
	if($item['rf_mthd_pmnt_inactive_yn'] == "1") {
		$label = "* " . $label;
	}
	$rf_mthd_pmnt_options .= "<option value=\"$item[rf_mthd_pmnt_ix]\" $selected>$label</option>\n";
}
$GLOBALS['temp']['rf_mthd_pmnt_options'] = $rf_mthd_pmnt_options;

$GLOBALS['temp']['externalChecked'] = "";
if($pg_acc_external_yn == "1") {
	$GLOBALS['temp']['externalChecked'] = "checked";
}
	
$GLOBALS['temp']['internalChecked'] = "";
if($pg_acc_internal_yn == "1") {
	$GLOBALS['temp']['internalChecked'] = "checked";
}

$GLOBALS['temp']['publicChecked'] = "";
if($pg_acc_public_yn == "1") {
	$GLOBALS['temp']['publicChecked'] = "checked";
}

$GLOBALS['temp']['apiChecked'] = "";
if($pg_account_sys_code == "1") {
	$GLOBALS['temp']['apiChecked'] = "checked";
}

$api_payment_gateways = $lDB->get("
	SELECT
		rf_mthd_pmnt_id
	FROM
		pg_account
	WHERE
		pg_account_sys_code = '1'
		AND pg_account_ix != '$pg_account_id'
",5);
if(count($api_payment_gateways) > 0) { // If there is only one valid gateway
	$GLOBALS['temp']['pg_account_sys_code_available'] = 0;
} else {
	$GLOBALS['temp']['pg_account_sys_code_available'] = 1;
}

$pr_business = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last
	FROM
		pr_persona
	WHERE
		pr_persona.pr_persona_ix IN ('".join("','",getBillingUnits())."')
	ORDER BY
		pr_persona.pr_name_last
",2);
array_unshift($pr_business,array("pr_persona_ix"=>"0","pr_name_last"=>"Multiple Billing Units"));
$pr_business_html = "
	<tr>
		<td><input id=\"pr_business_!pr_persona_ix!\" name=\"pr_business_!pr_persona_ix!\" type=\"checkbox\" !checked! !disabled!></td>
		<td><label for=\"pr_business_!pr_persona_ix!\">!pr_name_last!</label></td>
	</tr>
";	
$pr_business_rows = "";
foreach($pr_business as $item) {
	$item['disabled'] = "disabled";
	if($action == 3) {
		$item['disabled'] = "";
	}
	$item['checked'] = "";
	if(db_pg_acc_business_exists_by_all($pg_account_id,$item['pr_persona_ix'])) {
		$item['checked'] = "checked";
	}
	$pr_business_rows .= showpage($item,$pr_business_html);
}
if(sizeof($pr_business) < 1) {
	$pr_business_rows = "
		<tr>
			<td colspan=\"2\" class=\"txti\" align=\"center\">No billing units available</td>
		</tr>
	";
}
$GLOBALS['temp']['pr_business_rows'] = $pr_business_rows;


$rf_currency_html = "
		<tr >
			<td height=\"25\"><input id=\"rf_currency_!rf_currency_ix!\" name=\"rf_currency_!rf_currency_ix!\" type=\"checkbox\" !checked! !disabled! class=\"!class!\" /></td>
			<td><label for=\"rf_currency_!rf_currency_ix!\" class=\"!class!\">&nbsp;!rf_currency_symbol!</label></td>
			<td><select id=\"rf_currency_!rf_currency_ix!_rf_bank\" name=\"rf_currency_!rf_currency_ix!_rf_bank\" style=\"width: 266px;\" !disabled! class=\"!class!\">!rf_bank_options!</select></td>
			<td><input id=\"rf_currency_!rf_currency_ix!_pg_acc_currency_code\" name=\"rf_currency_!rf_currency_ix!_pg_acc_currency_code\" type=\"text\" style=\"width:208px;\" value=\"!pg_acc_currency_code!\" !disabled! class=\"!class!\"/></td>
		</tr>
";
$rf_currency_rows = "";
foreach($rf_currency as $item) {
	$item['checked'] = "";
	if(isset($item['pg_acc_currency_inactive_yn']) && $item['pg_acc_currency_inactive_yn'] == "0") {
		$item['checked'] = "checked";
	}
	$item['disabled'] = "disabled";
	if($action == 3) {
		$item['disabled'] = "";
	}
	$item['class'] = "";

	if($item['rf_currency_inactive_yn'] == 1) {
		$item['rf_currency_symbol'] = "<span class=\"txti\" onmouseout=\"nd();\" onmouseover=\"overlib('This currency is inactive.',WIDTH,130);\">$item[rf_currency_symbol]*</span>";
	}

	$rf_bank = $GLOBALS['lDB']->get("
		SELECT
			rf_bank.rf_bank_ix,
			rf_bank.rf_bank_acc_name
		FROM
			rf_bank
		WHERE
			rf_bank.rf_currency_id = '$item[rf_currency_ix]'
			AND rf_bank_ind = '0'
		ORDER BY
			rf_bank.rf_bank_acc_name
	",2);
	if(sizeof($rf_bank) > 0) {
		$rf_bank_options = "<option value=\"\">Select a bank</option>\n";
	} else {
		$rf_bank_options = "<option value=\"\">No banks defined for this currency</option>\n";
		$item['class'] = "txtg";
		$item['disabled'] = "disabled";
	}
	foreach($rf_bank as $bankItem) {
		$selected = "";
		if(isset($item['rf_bank_id']) && $item['rf_bank_id'] == $bankItem['rf_bank_ix']) {
			$selected = "selected";
		}
		$label = $bankItem['rf_bank_acc_name'];
		$rf_bank_options .= "<option value=\"$bankItem[rf_bank_ix]\" $selected >$label</option>\n";
	}
	$item['rf_bank_options'] = $rf_bank_options;
	if(empty($item['pg_acc_currency_code'])) {
		$item['pg_acc_currency_code'] = "";
	}
	$rf_currency_rows .= showpage($item,$rf_currency_html);
}

$GLOBALS['temp']['rf_currency_rows'] = $rf_currency_rows;

$pg_type_obj = $GLOBALS['lDB']->get("
	SELECT
		pg_type_obj.pg_type_obj_ix,
		pg_type_obj.pg_type_obj_label,
		pg_type_obj.pg_type_obj_type_ind,
		pg_type_obj.pg_type_obj_mandatory_yn
	FROM
		pg_type_obj
	WHERE
		pg_type_obj.pg_type_id = '$pg_type_id'
		AND pg_type_obj.pg_type_obj_inactive_yn = '0'
	ORDER BY
		pg_type_obj.pg_type_obj_sort_seq,
		pg_type_obj.pg_type_obj_label
",2);
foreach($pg_type_obj as $key=>$item) {
	if(db_pg_acc_obj_data_exists_by_all($pg_account_id,$item['pg_type_obj_ix'])) {
		$pg_acc_obj_data = $GLOBALS['lDB']->get("
			SELECT
				pg_acc_obj_data.pg_acc_obj_data,
				pg_acc_obj_data.pg_type_obj_data_id
			FROM
				pg_acc_obj_data
			WHERE
				pg_acc_obj_data.pg_account_id = '$pg_account_id'
				AND pg_acc_obj_data.pg_type_obj_id = '$item[pg_type_obj_ix]'
		",1);
		$pg_type_obj[$key]['pg_acc_obj_data'] = $pg_acc_obj_data['pg_acc_obj_data'];
		$pg_type_obj[$key]['pg_type_obj_data_id'] = $pg_acc_obj_data['pg_type_obj_data_id'];
	} else {
		$pg_type_obj[$key]['pg_acc_obj_data'] = "";
		$pg_type_obj[$key]['pg_type_obj_data_id'] = "";
	}
}

$pg_type_obj_html = "
	<tr>
		<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>					
		<td height=\"30\"><label for=\"pg_type_obj_!pg_type_obj_ix!\">!pg_type_obj_label!:</label></td>
		<td>!field!</td>
	</tr>	
	";
$pg_type_obj_rows = "";
foreach($pg_type_obj as $item) {
	$item['disabled'] = "disabled";
	if($action == 3) {
		$item['disabled'] = "";
	}
	switch($item['pg_type_obj_type_ind']) {
	case 1:
		$field = "<input type=\"text\" style=\"width:164px;\" id=\"pg_type_obj_!pg_type_obj_ix!\" name=\"pg_type_obj_!pg_type_obj_ix!\" value=\"!pg_acc_obj_data!\" !disabled! />";
		break;
	case 6:
		$field = "<input type=\"password\" style=\"width:164px;\" id=\"pg_type_obj_!pg_type_obj_ix!\" name=\"pg_type_obj_!pg_type_obj_ix!\" value=\"********\" !disabled! />";
		break;
	}
	$html = str_replace("!field!",$field,$pg_type_obj_html);
	$pg_type_obj_rows .= showpage($item,$html);
}
if($action == "2") {
	$GLOBALS['temp']['pg_type_obj_rows'] = "
		<tr>
			<td colspan=\"3\" align=\"center\" class=\"txti\">A new account must have the type set and be saved before details may be changed</td>
		</tr>
	";
} else {
	$GLOBALS['temp']['pg_type_obj_rows'] = $pg_type_obj_rows;
}

// Start Access Control Toolbar Setup
$newr = 1002;
$edit = 1003;
$view = 1001;
$dele = 1006;
$sedit = 1004;
$snewr = 1005;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if(checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if(checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if(checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if(checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}


$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";

// End Access Control Toolbar Setup
$GLOBALS['temp']['pg_type_disabled'] = "";
$GLOBALS['temp']['disabled'] = "";
switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "reservation.php?$edit+".$record;
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	#$GLOBALS['temp']['def_check'] .= " disabled";
	$GLOBALS['temp']['disabled'] = "disabled";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = $snewr;
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['mode'] = "new";
	if($pmode == 1) {
		if (!isset($_POST['pg_acc_external_yn'])){
			$_POST['pg_acc_external_yn'] = "0";
		}

		if (!isset($_POST['pg_acc_internal_yn'])){
			$_POST['pg_acc_internal_yn'] = "0";
		}

		if (!isset($_POST['pg_acc_public_yn'])){
			$_POST['pg_acc_public_yn'] = "0";
		}

		if (!isset($_POST['pg_account_sys_code'])){
			$_POST['pg_account_sys_code'] = "0";
		}

		$_POST['pg_type_id'] = isset($_POST['pg_type_id']) ? $_POST['pg_type_id'] : "";
		$_POST['pg_acc_name'] = isset($_POST['pg_acc_name']) ? $_POST['pg_acc_name'] : "";
		$_POST['rf_mthd_pmnt_id'] = isset($_POST['rf_mthd_pmnt_id']) ? $_POST['rf_mthd_pmnt_id'] : "";
		$_POST['pg_account_inactive_yn'] = isset($_POST['pg_account_inactive_yn']) ? $_POST['pg_account_inactive_yn'] : "";

		$pg_account_id = db_pg_account_insert($_POST['pg_type_id'],$_POST['pg_acc_name'],$_POST['pg_acc_external_yn'],$_POST['pg_acc_internal_yn'],$_POST['pg_acc_public_yn'],$_POST['rf_mthd_pmnt_id'],$_POST['pg_account_inactive_yn'],$_POST['pg_account_sys_code']);
		foreach($pg_method as $item) {
			$enabled = false;
			if(!empty($_POST["pg_method_$item[pg_method_ix]"])) {
				$enabled = true;
			}
			db_pg_acc_method_set($pg_account_id,$item['pg_method_ix'],$enabled);
		}
		foreach($pr_business as $item) {
			$enabled = false;
			if(!empty($_POST["pr_business_$item[pr_persona_ix]"])) {
				$enabled = true;
			}
			db_pg_acc_business_set($pg_account_id,$item['pr_persona_ix'],$enabled);
		}
		foreach($rf_currency as $item) {
			$inactive = "1";
			if(!empty($_POST["rf_currency_$item[rf_currency_ix]"])) {
				$inactive = "0";
			}
			if(!isset($_POST["rf_currency_$item[rf_currency_ix]_rf_bank"])) {
				$bank = "";
			}
			if(!isset($_POST["rf_currency_$item[rf_currency_ix]_pg_acc_currency_code"])) {
				$curr_code = "";
			}
			db_pg_acc_currency_set($pg_account_id,$item['rf_currency_ix'],$bank,$curr_code,$inactive);
		}
		foreach($pg_type_obj as $item) {
			db_pg_acc_obj_data_set($pg_account_id,$item['pg_type_obj_ix'],$_POST["pg_type_obj_$item[pg_type_obj_ix]"],"");
		}
	}
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = $sedit."+".$record;
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "reservation.php?$view+".$record;
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?$dele+".$record;
	$GLOBALS['temp']['pg_type_disabled'] = "disabled";
	if($pmode == 1) {

		if (!isset($_POST['pg_acc_external_yn'])){
			$_POST['pg_acc_external_yn'] = "0";
		}

		if (!isset($_POST['pg_acc_internal_yn'])){
			$_POST['pg_acc_internal_yn'] = "0";
		}

		if (!isset($_POST['pg_acc_public_yn'])){
			$_POST['pg_acc_public_yn'] = "0";
		}

		if (!isset($_POST['pg_account_sys_code'])){
			$_POST['pg_account_sys_code'] = "0";
		}

		db_pg_account_update($pg_account_id,$_POST['pg_acc_name'],$_POST['pg_acc_external_yn'],$_POST['pg_acc_internal_yn'],$_POST['pg_acc_public_yn'],$_POST['rf_mthd_pmnt_id'],$_POST['pg_account_inactive_yn'],$_POST['pg_account_sys_code']);
		foreach($pg_method as $item) {
			$enabled = false;
			if(!empty($_POST["pg_method_$item[pg_method_ix]"])) {
				$enabled = true;
			}
			db_pg_acc_method_set($pg_account_id,$item['pg_method_ix'],$enabled);
		}
		foreach($pr_business as $item) {
			$enabled = false;
			if(!empty($_POST["pr_business_$item[pr_persona_ix]"])) {
				$enabled = true;
			}
			db_pg_acc_business_set($pg_account_id,$item['pr_persona_ix'],$enabled);
		}
		foreach($rf_currency as $item) {
			$inactive = "1";
			if(!empty($_POST["rf_currency_$item[rf_currency_ix]"])) {
				$inactive = "0";
			}
			if (isset($_POST["rf_currency_$item[rf_currency_ix]_rf_bank"]) && isset($_POST["rf_currency_$item[rf_currency_ix]_pg_acc_currency_code"])){
				db_pg_acc_currency_set($pg_account_id,$item['rf_currency_ix'],$_POST["rf_currency_$item[rf_currency_ix]_rf_bank"],$_POST["rf_currency_$item[rf_currency_ix]_pg_acc_currency_code"],$inactive);
			}
			
		}
		foreach($pg_type_obj as $item) {
			db_pg_acc_obj_data_set($pg_account_id,$item['pg_type_obj_ix'],$_POST["pg_type_obj_$item[pg_type_obj_ix]"],"");
		}
	}
	break;
case (4) : // Delete Record
	db_pg_account_delete($pg_account_id);
	break;
}

