<?php

/*
 * $Id: init.form1002.php,v 1.2 2011-05-17 14:08:24 light Exp $
 *
 * $Log: init.form1002.php,v $
 * Revision 1.2  2011-05-17 14:08:24  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.1  2011-03-31 16:45:25  light
 * Bug #4355 - Credit card interface
 *
 * 
 */

/**
 * init.form1002.php - Payment gateway code table listing
 * Job: 1001,1002,1003,1004,1005,1006
 * Function: 126 (Code Tables: Payment Gateway)
*/

if(!array_key_exists($form,$GLOBALS) || !is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_payment_gateway_list.htm");
}

$list = $GLOBALS['lDB']->get("
	SELECT
		pg_account.pg_account_db,
		pg_account.pg_account_ix,
		pg_account.pg_acc_name,
		pg_account.pg_acc_external_yn,
		pg_account.pg_acc_internal_yn,
		pg_account.pg_acc_public_yn,
		pg_account.pg_account_inactive_yn,
		pg_type.pg_type_label,
		rf_mthd_pmnt.rf_mthd_pmnt_desc		
	FROM
		pg_account
		INNER JOIN pg_type ON pg_type.pg_type_ix = pg_account.pg_type_id
		LEFT JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = pg_account.rf_mthd_pmnt_id
	ORDER BY
		pg_account.pg_acc_name,
		pg_type.pg_type_label
",2);

$rowHTML = join("",file(__DIR__ . "/../../../public/html/code_payment_gateway_rows.htm"));
$rows = "";
foreach($list as $item) {
	if(canEditDB($item['pg_account_db'])) {
		$item['rowClass'] = "linkrow";
		$item['itemClass'] = "";
		$item['canEdit'] = "";
	} else {
		$item['rowClass'] = "";
		$item['itemClass'] = "txtg";
		$item['canEdit'] = "return;";
	}

	$item['pg_acc_method'] = join(", ",$GLOBALS['lDB']->get("
		SELECT
			pg_method.pg_method_name
		FROM
			pg_acc_method
			INNER JOIN pg_method ON pg_method.pg_method_ix = pg_acc_method.pg_method_id
		WHERE
			pg_acc_method.pg_account_id = '$item[pg_account_ix]'
		ORDER BY
			pg_method.pg_method_name
	",3));
		
	$item['pg_acc_external_yn_fmt'] = '&nbsp;';
	if($item['pg_acc_external_yn'] == "1") {
		$item['pg_acc_external_yn_fmt'] = 'x';
	}
	$item['pg_acc_internal_yn_fmt'] = '&nbsp;';
	if($item['pg_acc_internal_yn'] == "1") {
		$item['pg_acc_internal_yn_fmt'] = 'x';
	}
	$item['pg_acc_public_yn_fmt'] = '&nbsp;';
	if($item['pg_acc_public_yn'] == "1") {
		$item['pg_acc_public_yn_fmt'] = 'x';
	}
	$item['pg_account_inactive_yn_fmt'] = '&nbsp;';
	if($item['pg_account_inactive_yn'] == "1") {
		$item['pg_account_inactive_yn_fmt'] = 'x';
	}

	$pg_acc_business = $GLOBALS['lDB']->get("
		SELECT
			pr_business.pr_bus_name_short
		FROM
			pg_acc_business
			INNER JOIN pr_business ON pr_business.pr_business_id = pg_acc_business.pr_business_id
		WHERE
			pg_acc_business.pg_account_id = '$item[pg_account_ix]'
			ORDER BY
				pr_bus_name_short
	",3);
	$multi_business_check = $GLOBALS['lDB']->get("
		SELECT COUNT(*) FROM pg_acc_business WHERE pg_account_id = '$item[pg_account_ix]' AND pr_business_id = '0'
	",4);
	if($multi_business_check > 0) {
		array_unshift($pg_acc_business,"Multi");
	}
	$item['pg_acc_business'] = join(", ",$pg_acc_business);

	$item['pg_acc_currency'] = join(", ",$GLOBALS['lDB']->get("
		SELECT
			rf_currency.rf_currency_symbol
		FROM
			pg_acc_currency
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = pg_acc_currency.rf_currency_id
		WHERE
			pg_acc_currency.pg_account_id = '$item[pg_account_ix]'
			AND pg_acc_currency.pg_acc_currency_inactive_yn = '0'
		ORDER BY
			rf_currency.rf_currency_symbol
	",3));

	$rows .= showpage($item,$rowHTML);
}
if(sizeof($list) < 1) {
	$rows = "
		<tr>
			<td height=\"20\" class=\"txti\" colspan=\"10\" align=\"center\">There are no existing payment gateway accounts.</td>
		</tr>
	";
} else {
	$rows .= "
		<tr>
			<td class=\"bt\" colspan=\"10\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
	";
}
$GLOBALS['temp']['rows'] = $rows;

$edit = 1003;
$view = 1001;
if(checkjob($edit) == true) {
	$selectjob = $edit;
} else {
	$selectjob = $view;
}
$GLOBALS['temp']['selectjob'] = $selectjob;
