<?php

/**
 * init.form1003.php - Payment Gateway Reply form
 * Job: 1007
 * Function: 50 (Availability calendar)
 */

global $principal_id;

$GLOBALS['temp']['v3ResetPage'] = "0";
if (isV3Imageset($principal_id) && !isset($_SESSION['rv_payment_gateway_type'])) {
	// Transaction got cancelled from a V3 imageset Pay Now page,
	// and payment session is not available (in the case of DPO)
	// Redirect to Pay Now page to reload/reset parent page
	$GLOBALS['temp']['v3ResetPage'] = "1";
}

if(isset($_SESSION['rv_payment_gateway_type']) && $_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_WIZARD) {
	$wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";

	global $wizResId;

	if(empty($wizResId)) {
		redirectTo(" ./reservation.php?20");
		die();
	}
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/payment_gatewayEXT.htm");
}

if ($_SESSION['userStatusId'] > 1) {
	$internal = 1;
} else {
	$internal = 0;
}

if ($internal == "1") {
//	$GLOBALS[$form]->FormHTML = Join("",file(__DIR__ . "/../../../public/html/payment_gatewayINT.htm"));
//	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/payment_gatewayINT.htm";
}

$GLOBALS['temp']['title'] = "Pay Now";
$GLOBALS['temp']['on_startup'] = "";
$GLOBALS['temp']['payment_gateway_popup'] = "";
$GLOBALS['temp']['status'] = "";

if(!empty($_POST['paymentAction'])) {
	if($_POST['paymentAction'] == "payNow") {
		$pg_accounts = loadPaymentGateway();
		initPaymentGateway($pg_accounts);
	}

	if($_POST['paymentAction'] == "cancel") {
		db_rv_reservation_set_status($wizResId,95, false, false, false);
		$GLOBALS['temp']['status'] = "
			<center>
				<div style=\"width:770px\">
					<div class=\"outLt txtb\" style=\"padding:20px\">
						Reservation $wizResId has been cancelled.<br />
						<br />
						<a href=\"reservation.php?20\" class=\"link txt\">Click here</a> to return to calender.
					</div>
				</div>
			</center>
		";
		unsetWizResId($wizResId);
	}
} else {
	$payment = processPaymentGateway();

	$processingMessage = "
		<center>
			<div style=\"width:770px\">
				<div class=\"outLt txtb\" style=\"padding:20px\">
					Processing payment, please wait...
				</div>
			</div>
		</center>
	";

	$processingMessageV3Imageset = "
		<style>
			#processingContainer {
				text-align: center;
				padding-top: 50px;
				padding-bottom: 300px;
			}

			#processingContainer,
			.dot1,
			.dot2,
			.dot3 {
				font-size: 14px;
				font-family: Arial, Helvetica, sans-serif;
			}

			.dot1 {
				animation: visibility 3s linear infinite;
			}

			@keyframes visibility {
				0% { opacity: 1; }
				65% { opacity: 1; }
				66% { opacity: 0; }
				100% { opacity: 0; }
			}

			.dot2 {
				animation: visibility2 3s linear infinite;
			}

			@keyframes visibility2 {
				0% { opacity: 0; }
				21% { opacity: 0; }
				22% { opacity: 1; }
				65% { opacity: 1; }
				66% { opacity: 0; }
				100% { opacity: 0; }
			}

			.dot3 {
				animation: visibility3 3s linear infinite;
			}

			@keyframes visibility3 {
				0% { opacity: 0; }
				43% { opacity: 0; }
				44% { opacity: 1; }
				65% { opacity: 1; }
				66% { opacity: 0; }
				100% { opacity: 0; }
			}
		</style>
		<div id=\"processingContainer\">
			Processing payment, please wait <span class=\"dot dot1\">.</span><span class=\"dot dot2\">.</span><span class=\"dot dot3\">.</span>
		</div>
	";

	$GLOBALS['temp']['customDefaultCSS'] = isV3Imageset($principal_id) ? "" : $GLOBALS['temp']['customDefaultCss'];
	$GLOBALS['temp']['hideTitleBar'] = isV3Imageset($principal_id) ? "display: none; " : "";

	if(isset($_SESSION['rv_payment_gateway_type']) && $_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_WIZARD) {
		if($payment['status'] == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
			$GLOBALS['temp']['on_startup'] = "processPayment(\"success\", \"\", 640);";
			$GLOBALS['temp']['status'] = isV3Imageset($principal_id) ? $processingMessageV3Imageset : $processingMessage;
		} else {
			$pg_accounts = loadPaymentGateway();
			$GLOBALS['temp']['payment_gateway_popup'] = createPaymentGatewayPopup($pg_accounts,770,false,false);
			switch($payment['status']) {
			case DB_RV_PAYMENT_GATEWAY_DECLINED:
				$title = "Payment declined";
				$id = (!empty($payment['id'])?", reference $payment[id],":"");
				$message = "Your payment$id has been declined with the following error:<br /><br />$payment[message]";
				$GLOBALS['temp']['v3_decline_message'] = "Your payment$id has been declined with the following error:";
				$GLOBALS['temp']['v3_decline_reason'] = $payment['message'];
				break;
			case DB_RV_PAYMENT_GATEWAY_ERROR:
				$title = "Payment error";
				$id = (!empty($payment['id'])?", reference $payment[id]":"");
				$message = "There has been an error while proccessing your payment$id:<br /><br />$payment[message]";
				$GLOBALS['temp']['v3_decline_message'] = "There has been an error while proccessing your payment$id:";
				$GLOBALS['temp']['v3_decline_reason'] = $payment['message'];
				break;
			}
			$GLOBALS['temp']['on_startup'] = "showMessage('".t_encodeOverlib($message)."','".t_encodeOverlib($title)."');";
			$GLOBALS['temp']['v3_decline_title'] = $title;
			$GLOBALS['temp']['v3_decline_payment_id'] = $payment['id'];
		}
	}
	if(
		isset($_SESSION['rv_payment_gateway_type']) && 
		(
			$_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_RECORD_PAYMENT
			|| $_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_DEPOSIT
		)
	) {
		if($_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_RECORD_PAYMENT) {
			$job = 299;
		} elseif($_SESSION['rv_payment_gateway_type'] == PAYMENT_GATEWAY_TYPE_DEPOSIT) {
			$job = 1021;
		}
		session_set('rv_payment_gateway_result',$payment);
		$GLOBALS['temp']['on_startup'] = "processPayment(\"session\", \"\", $job);";
		$GLOBALS['temp']['status'] = isV3Imageset($principal_id) ? $processingMessageV3Imageset : $processingMessage;
	}
}

$GLOBALS['temp']['SAServer'] = $GLOBALS['SAServer'];
$GLOBALS['temp']['USServer'] = $GLOBALS['USServer'];

global $domain;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/payment_gatewayEXT.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/payment_gatewayEXT.htm")));
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/payment_gatewayEXT.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/payment_gatewayEXT.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/payment_gatewayEXT.css\" type=\"text/css\" />";
	}
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
		$indexCSS
	";

	if (isV3Imageset($principal_id)) {
		// Do not include imageset CSS if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "";

		if(isset($GLOBALS['temp']['v3_decline_message'])) {
			// Payment error from public Availability Calendar on V3 imageset, redirect to imageset with data
			$GLOBALS['temp']['resId'] = $wizResId;
			redirectTo("/public/reservation_calendar_pay_confirmation.php", $GLOBALS['temp']);
			die;
		}
	}
}

