<?php

/*
 * $Id: init.form1004.php,v 1.1 2011-03-31 16:45:25 light Exp $
 *
 * $Log: init.form1004.php,v $
 * Revision 1.1  2011-03-31 16:45:25  light
 * Bug #4355 - Credit card interface
 *
 *
 */

/**
 * init.form1004.php - Reservation Payment Gateway Popup
 * Job: 1008
 * Function: 66 (General)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/payment_gateway_list.htm");
}
$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

$rv_reservation_id = $_SERVER['argv'][1];

$GLOBALS['temp']['title'] = "Reservation Payment Gateway Listing: $rv_reservation_id";

$list = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		pg_account.pg_acc_name,
		pg_type.pg_type_label,
		pg_type.pg_type_site_url,
		rv_payment_gateway.rv_payment_gateway_ind,
		rv_payment_gateway.rv_payment_gateway_ref,
		rv_payment_gateway.rv_payment_gateway_amt_req,
		rv_payment_gateway.rv_payment_gateway_amt_paid,
		rf_currency.rf_currency_symbol,
		rv_payment_gateway.rv_payment_gateway_log,
		rv_payment_gateway.ad_create_date,
		rv_payment_gateway.ad_modify_date
	FROM
		rv_payment_gateway
		INNER JOIN rv_payment_gateway_folio ON rv_payment_gateway_folio.rv_payment_gateway_id = rv_payment_gateway.rv_payment_gateway_ix
		INNER JOIN pg_account ON pg_account.pg_account_ix = rv_payment_gateway.pg_account_id
		INNER JOIN pg_type ON pg_type.pg_type_ix = pg_account.pg_type_id
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_gateway.rf_currency_id
	WHERE
		rv_payment_gateway_folio.rv_reservation_id = '$rv_reservation_id'
	ORDER BY
		rv_payment_gateway.ad_modify_date DESC
",2);
$rowHTML = "
	<tr>
		<td class=\"br\">!pg_acc_name!</td>
		<td class=\"br\">!pg_type_label!</td>
		<td class=\"br\" align=\"center\">!status!</td>
		<td class=\"br\">!rv_payment_gateway_ref!</td>
		<td class=\"br\" align=\"right\">!rv_payment_gateway_amt_req! !rf_currency_symbol!</td>
		<td class=\"br\" align=\"right\">!rv_payment_gateway_amt_paid! !rf_currency_symbol!</td>
		<td class=\"br\" align=\"center\">!log!</td>
		<td class=\"br\">!ad_create_date!</td>
		<td class=\"br\">!ad_modify_date!</td>
		<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
	</tr>
";
$rows = "";
foreach($list as $item) {
	if(!empty($item['pg_type_site_url'])) {
		$item['pg_type_label'] = "<span class=\"link\" onclick=\"openPopup('$item[pg_type_site_url]',640,480);\">$item[pg_type_label]</span>";
	}
	$item['status'] = "<img onmouseout=\"nd();\" onmouseover=\"overlib('Payment ".db_rv_payment_gateway_ind_desc($item['rv_payment_gateway_ind'],$item['ad_modify_date'])."',WIDTH,0);\" src=\"" .db_rv_payment_gateway_ind_image($item['rv_payment_gateway_ind'], $item['ad_modify_date']) . "\" />";

	if(empty($item['rv_payment_gateway_ref'])) {
		$item['rv_payment_gateway_ref'] = "&nbsp;";
	}

	if(!empty($item['rv_payment_gateway_log'])) {
		$item['log'] = "<img onmouseout=\"nd();\" onmouseover=\"overlib('".t_encodeOverlib($item['rv_payment_gateway_log'])."');\" src=\"/resource/Resrequest/Application/public/img/info_std_16.gif\" />";
	} else {
		$item['log'] = "&nbsp;";
	}
	

	list($date,$time) = explode(" ",$item['ad_create_date']);
	$item['ad_create_date'] = chng_date($date,"-") . " " . $time;

	list($date,$time) = explode(" ",$item['ad_modify_date']);
	$item['ad_modify_date'] = chng_date($date,"-") . " " . $time;

	$rows .= showpage($item,$rowHTML);
}

$GLOBALS['temp']['rows'] = $rows;



