<?php

/**
 * init.form1005.php - Requests revieved status popup
 * Job: 1009
 * Function: 70 (Reservation: Web requests received)
 */

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/received_res_statuspop.htm");
}

$list = explode(":",$_SERVER['argv'][1]);

$GLOBALS['temp']['allowProv'] = true;
$GLOBALS['temp']['allowConf'] = true;
$GLOBALS['temp']['allowQuot'] = true;
$GLOBALS['temp']['allowWait'] = true;
$GLOBALS['temp']['allowCanc'] = true;

$GLOBALS['temp']['provOverlib'] = "";
$GLOBALS['temp']['confOverlib'] = "";
$GLOBALS['temp']['quotOverlib'] = "";
$GLOBALS['temp']['waitOverlib'] = "";
$GLOBALS['temp']['cancOverlib'] = "";

$provText = "";
$confText = "";
$quotText = "";
$waitText = "";
$cancText = "";

foreach($list as $key => $rv_reservation_id) {
	$list[$key] = $lDB->escape($rv_reservation_id);
}

$hasRooms = $lDB->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_item.rv_reservation_id IN ('" . join("','", $list) . "')
",4);

$GLOBALS['temp']['acceptStatusClass'] = "expand";

$allowOverbooking = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1";
foreach($list as $rv_reservation_id) {
	$hasOverbooking = !(check_availability($rv_reservation_id)===true);

	if(!$allowOverbooking && $hasOverbooking) {
		$GLOBALS['temp']['allowProv'] = "disabled";
		$provText .= " You have an overbooking on this reservation and your access permissions do not permit you to change to this status. Change the booking status to Waitlist or Quotation";

		$GLOBALS['temp']['allowConf'] = "disabled";
		$confText .= " You have an overbooking on this reservation and your access permissions do not permit you to change to this status. Change the booking status to Waitlist or Quotation";

		$GLOBALS['temp']['acceptStatusClass'] = "collapse printCollapse";
	}

	if(!canChangeStatus($rv_reservation_id,20)) {
		$GLOBALS['temp']['allowProv'] = "disabled";
		$provText .= " You do not have the required access to change to this status.";
	}
	if(!canChangeStatus($rv_reservation_id,30)) {
		$GLOBALS['temp']['allowConf'] = "disabled";
		$confText .= " You do not have the required access to change to this status.";
	}
	if(!canChangeStatus($rv_reservation_id, 0)) {
		$GLOBALS['temp']['allowQuot'] = "disabled";
		$quotText .= " You do not have the required access to change to this status.";
	}
	if(!canChangeStatus($rv_reservation_id,10)) {
		$GLOBALS['temp']['allowWait'] = "disabled";
		$waitText .= " You do not have the required access to change to this status.";
	}
	if(!canChangeStatus($rv_reservation_id,90)) {
		$GLOBALS['temp']['allowCanc'] = "disabled";
		$cancText .= " You do not have the required access to change to this status.";
	}
}

if(!empty($provText)) {
	$GLOBALS['temp']['provOverlib'] = "onmouseover=\"overlib('".t_encodeOverlib($provText)."');\" onmouseout=\"nd();\"";
}

if(!empty($confText)) {
	$GLOBALS['temp']['confOverlib'] = "onmouseover=\"overlib('".t_encodeOverlib($confText)."');\" onmouseout=\"nd();\"";
}

if(!empty($quotText)) {
	$GLOBALS['temp']['quotOverlib'] = "onmouseover=\"overlib('".t_encodeOverlib($quotText)."');\" onmouseout=\"nd();\"";
}

if(!empty($waitText)) {
	$GLOBALS['temp']['waitOverlib'] = "onmouseover=\"overlib('".t_encodeOverlib($waitText)."');\" onmouseout=\"nd();\"";
}

if(!empty($cancText)) {
	$GLOBALS['temp']['cancOverlib'] = "onmouseover=\"overlib('".t_encodeOverlib($cancText)."');\" onmouseout=\"nd();\"";
}



