<?php

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/init.form215.func.php');

function getInvoicePDF($invoices) {
	global $lDB;

	if(is_array($invoices)) {
		$invoices = join("|",$invoices);
	}

	$_SERVER['argv'] = array(
		/* 00 */ "reservation.php?642",
		/* 01 */ "", // Reservation Ids
		/* 02 */ "1", // Options (view PDF)
		/* 03 */ "", // Folio Ids
		/* 04 */ $invoices,
		/* 05 */ "",
		/* 06 */ "",
		/* 07 */ "",
		/* 08 */ "",
		/* 09 */ "",
		/* 10 */ "",
		/* 11 */ "",
		/* 12 */ "",
		/* 13 */ "",
		/* 14 */ "1" // Use invoice defaults
	);
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['pdfEcho'] = true;
	ob_start();
	include(__DIR__ ."/init.form215.php");
	$pdf = ob_get_contents();
	ob_end_clean();
	return $pdf;	
}

function generateSummary($pr_persona_id,$invoiceIds) {
	global $lDB;

	$pdf = new PDF("");
	$pdfFontSize = 8;
	$pdf->SetFont('Arial', '', $pdfFontSize);

	$invoices = $lDB->get("
		SELECT
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_date,
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_amount,
			fn_folio.fn_folio_amt_paid,
			rf_currency.rf_currency_symbol,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name,
			rf_reservation_status.rf_reservation_status_desc
		FROM
			fn_invoice
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_invoice.rv_reservation_id
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		WHERE
			fn_invoice.fn_invoice_ix IN ('".join("','",$invoiceIds)."')
		ORDER BY
			fn_invoice.fn_inv_date,
			rv_reservation.rv_reservation_ix,
			fn_invoice.fn_invoice_ix
	",2);

	$principal_id = $_SESSION['principal_id'];
	$logoFilename = "top_client_fin.jpg";
	$currId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio_ix = '".$invoices[0]['fn_folio_ix']."'",4);
	$logoId = $currId;
	while($currId != "0" && trim($currId) != "" && $logoFilename == "top_client_fin.jpg") {
		$prefix = strtolower($GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
		if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/".$prefix."_fin.jpg")) {
			$logoFilename = $prefix."_fin.jpg";
			$logoId = $currId;
		}
		$parentId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		$currId = $parentId;
	}

	$address = getContactCorrAddress($logoId);

	$addresseeTelephone = getContactTelephone($logoId);
	$addresseeFax = getContactFax($logoId);

	if($addresseeTelephone == "") {
		$addresseeTelephone = "None";
	}
	
	if($addresseeFax == "") {
		$addresseeFax = str_pad("None",16," ",STR_PAD_LEFT);
	} else {
		$addresseeFax = str_pad($addresseeFax,(strlen($addresseeFax)+12)," ",STR_PAD_LEFT);
	}
	
	$result['resOffTel'] = $addresseeTelephone;
	$address .= "Telephone: " . $addresseeTelephone . "\n";
	$result['fax'] = $addresseeFax;
	$address .= "Fax: " . $addresseeFax . "\n";
	
	$addresseeEmail = getContactEmail($logoId);
	if($addresseeEmail != "") {
		$address .= "Email: " . $addresseeEmail . "\n";
	}

	$addresseeURL = getContactURL($logoId);
	if($addresseeURL != "") {
		$address .= "URL: " . $addresseeURL . "\n";
	}

	// Get contact
	$address .= "Res-URL: " . $_SESSION['principal_name_short'] . ".resrequest.com\n";
	
	
	$logoY = $pdf->y;

	$pdf->SetFont('Arial', 'B', 11);
	$pdf->MultiCell($pdf->GetPageWidth()/3-10, $pdf->FontSize+1, "", '', 'L', 0, 1);
	$pdf->MultiCell($pdf->GetPageWidth()/3+20, $pdf->FontSize+1, "", '', 0, '', 1);
	$pdf->MultiCell($pdf->GetPageWidth()/3, $pdf->FontSize+1, "Invoice Summary: ". chng_date(date("Y-m-d"),"-"), '', 'L', 0, 1);
	$pdf->Ln(0, 4);
	$pdf->SetFont('Arial', 'B', $pdfFontSize);
	$pdf->Ln(2);

	$pdf->MultiCell($pdf->GetPageWidth()/3-10, $pdf->FontSize+1, "", '', 'L', 0, 1);
	$pdf->MultiCell($pdf->GetPageWidth()/3+20, $pdf->FontSize+1, "", '', 0, '', 1);
	$pdf->MultiCell($pdf->GetPageWidth()/3, $pdf->FontSize+1, $address, '', 'L', 0, 1);
	$pdf->Ln(0, 4);
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
		$pic = $pdf->_parsejpg("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename");
		if ($pic['w'] > $pdf->GetPageWidth(1)/4) {
			$pic['w'] = $pdf->GetPageWidth(1)/4;
		}
		$res_logo = explode(".",$logoFilename);
		if(substr($res_logo[0],-3,3) != "pdf") {
			$pdf_logo = $res_logo[0] . '_pdf.' . $res_logo[1];
			if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$pdf_logo")) {
				$logoFilename = $pdf_logo;
			}
		}
		if($GLOBALS['system'] != "training") {
			require_once(__DIR__ . '/functions.imageset.php');
			$logoWidth = imagesetLogoSizeOverride("invoiceReportBulkEmailPdfLogoWidthOverride", $pic['w']);
			$finalH = $pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename", 10, $logoY, $logoWidth);
		}
		if (($logoY + $finalH) > $pdf->y) {
			$pdf->y = $logoY + $finalH;
		}
	}

	$pdf->Ln(4);
	$pdf->Row(array(array('width'=>"100%",'border'=>"T")));
	$pdf->Ln(2);

	$address = getContactName($pr_persona_id) . "\n";

	$address .= getContactCorrAddress($pr_persona_id);

	$addresseeTelephone = getContactTelephone($pr_persona_id);
	$addresseeFax = getContactFax($pr_persona_id);

	if($addresseeTelephone == "") {
		$addresseeTelephone = "None";
	}
	
	if($addresseeFax == "") {
		$addresseeFax = str_pad("None",16," ",STR_PAD_LEFT);
	} else {
		$addresseeFax = str_pad($addresseeFax,(strlen($addresseeFax)+12)," ",STR_PAD_LEFT);
	}
	
	$result['resOffTel'] = $addresseeTelephone;
	$address .= "Telephone: " . $addresseeTelephone . "\n";
	$result['fax'] = $addresseeFax;
	$address .= "Fax: " . $addresseeFax . "\n";
	
	$addresseeEmail = getContactEmail($pr_persona_id);
	if($addresseeEmail != "") {
		$address .= "Email: " . $addresseeEmail . "\n";
	}
	
	$pdf->Row(array(array('width'=>"100%",'data'=>$address)));

	$pdf->Ln(4);

	$pdf->Row(array(
		array('width'=>"10%",'data'=>"Invoice Date",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"9%",'data'=>"Res #",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"25%",'data'=>"Res Name",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Invoice #",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"10%",'data'=>"Status",'border'=>"LRTB",'fill'=>"1"),
		array('width'=>"8%",'data'=>"Currency",'border'=>"LRTB",'fill'=>"1",'align'=>"C"),
		array('width'=>"14%",'data'=>"Total Amount",'border'=>"LRTB",'fill'=>"1",'align'=>"R"),
		array('width'=>"14%",'data'=>"Amount Still Due",'border'=>"LRTB",'fill'=>"1",'align'=>"R"),
	));

	$totalAmount = 0;
	$totalOutstanding = 0;
	$text = "Invoice Summary\n";
	$reservations = array();
	foreach($invoices as $invoice) {
		$reservations[] = $invoice['rv_reservation_ix'];
		$outstanding = round($invoice['fn_folio_amount'] - $invoice['fn_folio_amt_paid'],2);
		$totalAmount += $invoice['fn_folio_amount'];
		$totalOutstanding += $outstanding;
		fixAmtDisplay($invoice['fn_folio_amount'],2);
		fixAmtDisplay($invoice['fn_folio_amt_paid'],2);
		fixAmtDisplay($outstanding);

		$pdf->Row(array(
			array('width'=>"10%",'data'=>chng_date($invoice['fn_inv_date'],"-"),'border'=>"LR"),
			array('width'=>"9%",'data'=>$invoice['rv_reservation_ix'],'border'=>"LR"),
			array('width'=>"25%",'data'=>$invoice['rv_res_name'],'border'=>"LR"),
			array('width'=>"10%",'data'=>$invoice['fn_invoice_ix'],'border'=>"LR"),
			array('width'=>"10%",'data'=>$invoice['rf_reservation_status_desc'],'border'=>"LR"),
			array('width'=>"8%",'data'=>$invoice['rf_currency_symbol'],'border'=>"LR",'align'=>"C"),
			array('width'=>"14%",'data'=>$invoice['fn_folio_amount'],'border'=>"LR",'align'=>"R"),
			array('width'=>"14%",'data'=>$outstanding,'border'=>"LR",'align'=>"R"),
		));

		$text .= chng_date($invoice['fn_inv_date'],"-").": ($invoice[rv_reservation_ix]) $invoice[rv_res_name] Inv# $invoice[fn_invoice_ix] ($invoice[rf_reservation_status_desc]) Total: $invoice[fn_folio_amount] $invoice[rf_currency_symbol] / Due: $outstanding $invoice[rf_currency_symbol]\n";
	}
	$pdf->Row(array(array('width'=>"100%",'border'=>"T")));

	ob_start();
	$pdf->OutPut('',false,true);
	$data = ob_get_contents();
	ob_end_clean();

	return array('pdf'=>$data,'text'=>$text,'reservations'=>array_unique($reservations));
}

