<?php

/**
 * init.form1006.php - Invoice Report Bulk Email Popup
 * Job: 1010 
 * Function: 76 (Reports Financials: Rev, Comp, Folio/Inv)
 */

if ( isset($_POST['url']) && $_POST['url'] != "" ) {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}
$GLOBALS['temp']['url'] = $_POST['url'];
$_POST['url'] = ""; // Clear to avoid having the invoice document code (form 215) use it.

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

$invoices = explode(":",$_SERVER['argv'][1]);

if(isset($_POST['action']) && $_POST['action'] == "send") {
	if (!isset($GLOBALS[$form])) {
	   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_invoice_email_pop_submit.htm");
	}
	
	$cc = $_POST['email_cc'];
	$from = $_POST['email_from'];
	$subject = $_POST['email_subject'];
	$body = $_POST['email_body'];
	$summary_yn = $_POST['email_summary_yn'];
	$invoice_yn = $_POST['email_invoice_yn'];
	$attachment_ind = $_POST['email_attachment_ind'];
	$items = unserialize(stripslashes($_POST['items']));

	$fileDate = date("Ymd");

	//$GLOBALS['temp']['princName'] = $principalName;
	$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

	$results = array();	
	foreach($items as $personaItem) {
		$attachments = array();
		$invoices = explode(":",$personaItem['invoices']);

		$summary = generateSummary($personaItem['pr_persona_id'],$invoices);
		foreach($summary['reservations'] as $rv_reservation_id) {
			ammendReservation($rv_reservation_id,"Bulk invoice email");
		}
		// DISABLED FOR NOW $body .= $summary['text'];

		if($summary_yn == "1") {
			$attachments[] = array(
				'filename'=>"summary_".$fileDate.".pdf",
				'data'=>$summary['pdf']
			);
		}

		if($invoice_yn == "1") {
			if($attachment_ind == "2") {
				foreach($invoices as $invoice) {
					$attachments[] = array(
						'filename'=>$invoice.".pdf",
						'data'=>getInvoicePDF($invoice)
					);
				}
			} else {
				$attachments[] = array(
					'filename'=>"invoices_".$fileDate.".pdf",
					'data'=>getInvoicePDF($invoices)
				);
			}
		}
		
		$to = $personaItem['pr_email'];
		if(!empty($cc)) {
			$to .= "," . $cc;
		}

		$error = email($from, $to, $subject, $headers, $body, 0, 0, "", $GLOBALS['princName'], $attachments, "",false);

		$results[] = array(
			'error'=>($error?"1":"0"),
			'from'=>$from,
			'to'=>$personaItem['pr_email'],
			'cc'=>$cc,
			'subject'=>$subject,
			'attachments'=>sizeof($attachments),
			'invoices'=>sizeof($invoices)
		);
	}
	$GLOBALS['temp']['data'] = serialize($results);
} elseif(isset($_POST['action']) && $_POST['action'] == "result") {
	if (!isset($GLOBALS[$form])) {
	   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_invoice_email_pop_result.htm");
	}

	$resultRowHTML = "
		<tr>
			<td class=\"colWh br\" style=\"width:25px; text-align:center;\"><img src=\"images/!image!\" /></td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!from!</td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!to!</td>
			<td class=\"colWh br\" style=\"width:94px; overflow: hidden;\">!cc!</td>
			<td class=\"colWh br\" style=\"width:115px; overflow: hidden;\">!subject!</td>
			<td class=\"colWh br\" style=\"width:45px; text-align: right;\">!attachments!</td>
			<td class=\"colWh\" style=\"width:40px; text-align: right;\">!invoices!</td>
			<td class=\"colWh\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>		
	";
	$results = unserialize(stripslashes($_POST['data']));
	$rows = "";
	foreach($results as $result) {
		if($result['error'] == "1") {
			$result['image'] = "icon_close_16.gif";
		} else {
			$result['image'] = "icon_select_16.gif";
		}
		if(empty($result['cc'])) {
			$result['cc'] = "&nbsp;";
		}
		$rows .= showpage($result,$resultRowHTML);
	}
	$GLOBALS['temp']['rows'] = $rows;

	$GLOBALS['temp']['dateTime'] = chng_date(date("Y-m-d"),"-") . " " . date("H:i:s");
	
} else {
	if (!isset($GLOBALS[$form])) {
	   $GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_invoice_email_pop.htm");
	}

	$GLOBALS['temp']['emailFrom'] = $lDB->get("
		SELECT
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$GLOBALS[userid]'
	",4);

	$GLOBALS['temp']['emailSubject'] = "Invoices " . chng_date(date("Y-m-d"),"-");

	$list = $lDB->get("
		SELECT
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_date,
			fn_folio.fn_folio_amount,
			fn_folio.fn_folio_amt_paid,
			rf_currency.rf_currency_symbol,
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_email,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name
		FROM
			fn_invoice
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_invoice.rv_reservation_id
		WHERE
			fn_invoice_ix IN ('".join("','",$invoices)."')
		ORDER BY
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			fn_invoice.fn_inv_date,
			rv_reservation.rv_reservation_ix,
			fn_invoice.fn_invoice_ix
	",2);

	$debtors = array();
	foreach($list as $item) {
		$key = $item['pr_persona_ix'];
		if(!array_key_exists($key,$debtors)) {
			$debtors[$key] = array(
				'pr_persona_id'=>$key,
				'pr_name'=>trim($item['pr_name_first'] . " " . $item['pr_name_last']),
				'pr_email'=>$item['pr_email'],
				'invoices'=>array()
			);
		}

		$outstanding = round($item['fn_folio_amount'] - $item['fn_folio_amt_paid'],2);
		fixAmtDisplay($item['fn_folio_amount'],2);
		fixAmtDisplay($item['fn_folio_amt_paid'],2);
		fixAmtDisplay($outstanding);
		$debtors[$key]['invoices'][$item['fn_invoice_ix']] = array(
			'fn_inv_date'=>$item['fn_inv_date'],
			'fn_inv_date_fmt'=>chng_date($item['fn_inv_date'],"-"),
			'rv_reservation_id'=>$item['rv_reservation_ix'],
			'rv_res_name'=>$item['rv_res_name'],
			'fn_invoice_id'=>$item['fn_invoice_ix'],
			'rf_currency_symbol'=>$item['rf_currency_symbol'],
			'fn_folio_amount'=>$item['fn_folio_amount'],
			'fn_folio_amt_paid'=>$item['fn_folio_amt_paid'],
			'fn_folio_amt_outstanding'=>$outstanding
		);
	}
	$list = null;

	foreach($debtors as $key=>$debtor) {
		$debtors[$key]['invoiceIds'] = join(":",array_keys($debtor['invoices']));
	}

	$debtorRowHTML = "
		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout: fixed; border-collapse: collapse;\">
		<tr>
			<td class=\"colLt\" style=\"width:27px;\"><input type=\"checkbox\" checked name=\"pr_persona_id\" id=\"chk!pr_persona_id!\" /></td>
			<td class=\"colLt\" style=\"width:260px; overflow: hidden;\">!pr_name!</td>
			<td class=\"colLt\" style=\"width:191px;\">
				<button type=\"button\" class=\"button\" style=\"width:20px; height: 20px;\" onclick=\"contact_popup('email!pr_persona_id!');\"><img src=\"/resource/Resrequest/Application/public/img/button_prop_filter.gif\" /></button>
				<input type=\"text\" value=\"!pr_email!\" id=\"email!pr_persona_id!\" />
			</td>
			<td class=\"colLt\" style=\"width:80px;\" align=\"right\">
				<table border=\"0\" cellspacing=\"0\" style=\"visibility: hidden;\">
				<tr>
					<td>
						<input type=\"checkbox\" />
					</td>
					<td>
						<button type=\"button\" class=\"button\" style=\"width:24px; height: 20px;\"><img src=\"/resource/Resrequest/Application/public/img/button_email_edit.png\" /></button>
					</td>
				</tr>
				</table>
			</td>
			<td class=\"colLt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
		</table>
		<input type=\"hidden\" id=\"invoices!pr_persona_id!\" value=\"!invoiceIds!\" /> 
	";

	$invoiceRowHTML = "
		<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"2\" style=\"table-layout: fixed; border-collapse: collapse;\" id=\"invoiceTable!fn_invoice_id!\">
		<tr>
		<td style=\"width:52px;\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /><input type=\"hidden\" id=\"input!fn_invoice_id!\" name=\"invoiceTable\" /></td>
			<td style=\"width:71px;\">!fn_inv_date_fmt!</td>
			<td style=\"width:61px;\">!rv_reservation_id!</td>
			<td style=\"width:95px; overflow: hidden;\">!rv_res_name!</td>
			<td style=\"width:71px;\">!fn_invoice_id!</td>
			<td style=\"width:31px;\" align=\"center\">!rf_currency_symbol!</td>
			<td style=\"width:81px;\" align=\"right\">!fn_folio_amount!</td>
			<td style=\"width:81px;\" align=\"right\">!fn_folio_amt_outstanding!</td>
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>
		</table>	
	";

	$rows = "";
	foreach($debtors as $debtor) {
		if (is_array($debtor['invoices'])) {
			$tempInvoices = $debtor['invoices'];
			$debtor['invoices'] = "";
		}

		$rows .= showpage($debtor,$debtorRowHTML);

		if (isset($tempInvoices)) {
			$debtor['invoices'] = $tempInvoices;
			unset($tempInvoices);
		}
		foreach($debtor['invoices'] as $invoice) {
			$rows .= showpage($invoice,$invoiceRowHTML);
		}
	}

	$GLOBALS['temp']['rows'] = $rows;
}
