<?php

/**
 * init.form1007.func.php - Room Discrepancy Report
 * Job: 1011 
 * Function: 1000 (Report: Room Discrepancy)
 */

require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.csv.php');

$profileFields = array(
	/*  1 */ "dateType",
	/*  2 */ "dateTypeDays",
	/*  3 */ "",//"dateFrom",
	/*  4 */ "",//"dateTo",
	/*  5 */ "statusFilter",
	/*  6 */ "accommFilter",
	/*  7 */ "displayUpgrade",
	/*  8 */ "displayNoShow",
	/*  9 */ "displayCheckOut",
	/* 10 */ "cols",
	/* 11 */ "displayMissingGuestNames"
);

function getCol($id, $zeroIndex = true) { 
	global $cols;

	foreach($cols as $key => $item) {
		if($item['id'] == $id) {
			$returnVal = $zeroIndex ? $item : $key;
			return $returnVal;
		}
	}
	return false;
}

function getFieldArray($field) {
	$fieldList = preg_split("/ as /i",$field);
	$alias = isset($fieldList[1]) ? trim($fieldList[1]) : "";
	$fieldList = explode(".",$fieldList[0]);
	$table = trim($fieldList[0]);
	$field = trim($fieldList[1]);
	return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
}

function getFieldName($field) {
	$fieldArray = getFieldArray($field);
	if($fieldArray['alias'] != "") {
		return $fieldArray['alias'];
	} else {
		return $fieldArray['field'];
	}
}

function getFieldTable($field) {
	$fieldArray = getFieldArray($field);
	return $fieldArray['table'];
}

function inJoin($alias,$joins) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || (isset($join['table']) && $join['table'] == $alias) ) {
			return true;
		}
	}
	return false;
}

function buildSQL($cols,$colArray,$colSort,$joins) {
	if(isset($chartName) && $chartName != "") {
		$showIds = $chartIds[$chartName];
		$colourIds = $chartIds['colour'];
	} else {
		$showIds = isset($chartIds) ? $chartIds : "";
		$colourIds = array();
	}
	$select = array();
	$from = array();
	foreach($cols as $key=>$item) {		
		$id = $item['id'];
		if($colArray[$id]['active'] == "1" && $item['type'] != "external") {
			$fields = array();
			if(is_array($item['fields'])) {
				$fields = $item['fields'];
			}
			foreach($fields as $field) {
				if(inJoin(getFieldTable($field),$joins) && !in_array($field,$select)) {
					array_push($select,$field);
					$fieldArray = explode(".",$field);
					$from = array_merge($from,getJoins($fieldArray[0],$joins));
				}
			}	
		}
	}
	$select = array_unique($select);
	$from = array_unique($from);

	$sort = array();
	foreach($colSort as $key=>$item) {
		if($colArray[$key]['active'] == "1" && $item != "" && $cols[getCol($key, false)]['type'] != "external") {
			$colItem = getCol($key);
			if(is_array($colItem['fields'])) {
				$fields = $colItem['fields'];
			}
			if($colArray[$key]['direction'] == "a") {
				$direction = "asc";
			} else {
				$direction = "desc";
			}
			foreach($fields as $fieldKey=>$field) {
				$fields[$fieldKey] = $field . " " . $direction;
			}
			$sort = array_merge($sort,$fields);
		}
	}
	return array('select'=>$select, 'from'=>$from,'sort'=>$sort);
}

function getJoins($alias,$joins) {
	foreach($joins as $join) {
		if( (isset($join['alias']) && $join['alias'] == $alias) || ( (!isset($join['alias']) || $join['alias'] == "") && (isset($join['table']) && $join['table'] == $alias) )) {
			if(!array_key_exists("type",$join)) {
				return array($join['table']);
			} else {
				if(!isset($join['alias']) || $join['alias'] == "") {
					$result = array("$join[type] JOIN $join[table] ON $join[on]");
				} else {
					$result = array("$join[type] JOIN $join[table] AS $join[alias] ON $join[on]");
				}
				if($join['requires'] != "") {
					$require = getJoins($join['requires'],$joins);
					return array_merge($require,$result);
				} else {
					return $result;
				}
			}
		}
	}
}

function getAgentName($pr_name_last = "") {
	if(trim($pr_name_last) == "") {
		return "Direct";
	} else {
		return $pr_name_last;
	}
}

function getConsultantName($pr_name_first = "",$pr_name_last = "") {
	$name = trim($pr_name_first . " " . $pr_name_last);
	if(empty($name)) {
		return "No consultant";
	} else {
		return $name;
	}
}

function getPaymentStatus($payable,$paid=0.00) {
	$outstanding = round($payable - $paid,2);
	if($outstanding > 0) {
		return "Unpaid";
	} elseif($outstanding < 0) {
		return "Over paid";
	} else {
		return "Paid";
	}
}

function getSource($source = "") {
	if(empty($source)) {
		return "No source";
	} else {
		return $source;
	}
}

function getOptionalComponents($resItemId) {
	$compArray = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rt_component.rt_component_abbrv
		FROM
			rv_res_item_comp
		INNER JOIN rt_component ON
			rv_res_item_comp.rt_component_id = rt_component.rt_component_ix
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '$resItemId'
		AND 
			rv_item_comp_option_yn = '1'
		ORDER BY rt_component.rt_component_abbrv
			
	",2);

	$compList = "";
	
	if(is_array($compArray) && !empty($compArray)) {
		foreach ( $compArray as $item ) {
			if ( $compList != "" ) {
				$compList .= ", ";
			}
			$compList .= $item['rt_component_abbrv'];
		}
	}

	return $compList;
}

