<?php

/**
 * init.form1007.php - Room Discrepancy Report
 * Job: 1011 
 * Function: 1000 (Report: Room Discrepancy)
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}
$GLOBALS['temp']['url'] = isset($_POST['url']) ? $_POST['url'] : "";

global $resScrollSet;
$resScrollSet = array();

$_SERVER['argv'] = array_pad($_SERVER['argv'],13,"");

$jobId = $_SERVER['argv'][0];
$GLOBALS['temp']['jobId'] = $jobId;

$pf_object_id = db_pf_object_by_name("discrepancy_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Room Discrepancy Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_discrepancy.htm");
}

$dateType = $_SERVER['argv'][1];
if(empty($dateType)) {
	$dateType = "today";
}
$dateTypeDays = $_SERVER['argv'][2];
if(empty($dateTypeDays)) {
	$dateTypeDays = "7";
}
$GLOBALS['temp']['dateTypeDays'] = $dateTypeDays;

$GLOBALS['temp']['dateTypeTodayChecked'] = "";
$GLOBALS['temp']['dateTypeTodayDaysChecked'] = "";
$GLOBALS['temp']['dateTypeYesterdayChecked'] = "";
$GLOBALS['temp']['dateTypeCustomChecked'] = "";
switch($dateType) {
case "today":
	$dateFromRaw = date("Y-m-d");
	$dateToRaw = date("Y-m-d");
	$GLOBALS['temp']['dateTypeTodayChecked'] = "checked";
	break;
case "today_days":
	$today_array = explode("-",date("Y-m-d"));
	$dateFromRaw = date("Y-m-d",mktime(0,0,0,$today_array[1],$today_array[2]-$dateTypeDays,$today_array[0]));
	$dateToRaw = date("Y-m-d");
	$GLOBALS['temp']['dateTypeTodayDaysChecked'] = "checked";
	break;
case "yesterday":
	$today_array = explode("-",date("Y-m-d"));
	$dateFromRaw = date("Y-m-d",mktime(0,0,0,$today_array[1],$today_array[2]-1,$today_array[0]));
	$dateToRaw = $dateFromRaw;	
	$GLOBALS['temp']['dateTypeYesterdayChecked'] = "checked";
	break;
case "custom":
	$dateFromRaw = $_SERVER['argv'][3];
	$dateToRaw = $_SERVER['argv'][4];
	$GLOBALS['temp']['dateTypeCustomChecked'] = "checked";
	break;
}
$dateFrom = useDate("from", $dateFromRaw);
$dateTo = useDate("to", $dateToRaw);


$statusACL= $lDB->get("
	SELECT DISTINCT
		rf_reservation_status_id
	FROM
		rf_reservation_status
	WHERE
		rf_reservation_status_id NOT IN ('15','25','40','50','97')
",3);
//Excluding status 15 (Allocation), 25 (In Progress), 40 (Invoiced), 50 (Blocked), 97 (Deleted allocation)
if(empty($_SERVER['argv'][5]) && empty($_SERVER['argv'][1]) && empty($pf_option_id)) {
	$_SERVER['argv'][5] = "30";
}
$statusFilter = useFilter("status",$_SERVER['argv'][5],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",$statusACL,false,false);

$accommACL= $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '$GLOBALS[sc_group_id]'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][6],"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","rv_reservation_item.ac_accomm_type_id",$accommACL,false,false);

$displayUpgrade = $_SERVER['argv'][7];
$displayNoShow = $_SERVER['argv'][8];
$displayCheckOut = $_SERVER['argv'][9];
$displayMissingGuestNames = $_SERVER['argv'][11];
if(empty($displayUpgrade) && empty($displayNoShow) && empty($displayCheckOut) && empty($displayMissingGuestNames)) {
	$displayUpgrade = $displayNoShow = $displayCheckOut = $displayMissingGuestNames = "1";
}
$GLOBALS['temp']['displayUpgradeChecked'] = "";
if($displayUpgrade == "1") {
	$GLOBALS['temp']['displayUpgradeChecked'] = "checked";
}
$GLOBALS['temp']['displayNoShowChecked'] = "";
if($displayNoShow == "1") {
	$GLOBALS['temp']['displayNoShowChecked'] = "checked";
}
$GLOBALS['temp']['displayCheckOutChecked'] = "";
if($displayCheckOut == "1") {
	$GLOBALS['temp']['displayCheckOutChecked'] = "checked";
}
$GLOBALS['temp']['displayMissingGuestNamesChecked'] = "";
if($displayMissingGuestNames == "1") {
	$GLOBALS['temp']['displayMissingGuestNamesChecked'] = "checked";
}

global $cols;
$cols = array(
	array('id'=>1,'label'=>"Date of arrival",'type'=>"date",'fields'=>array("rv_reservation_item.rv_item_date_arrive"),'width'=>"75"),
	array('id'=>2,'label'=>"Date of departure",'type'=>"date",'fields'=>array("rv_reservation_item.rv_item_date_depart"),'width'=>"75"),
	array('id'=>3,'label'=>"Discrepancy",'type'=>"external",'fields'=>array("discrepancy.discrepancy_name"),'width'=>"70"),
	array('id'=>4,'label'=>"Discrepancy details",'type'=>"external",'fields'=>array("discrepancy.discrepancy_detail"),'width'=>"270"),
	array('id'=>5,'label'=>"Itinerary accommodation",'type'=>"string",'fields'=>array("ac_accomm_type.ac_accomm_desc"),'width'=>"180"),
	array('id'=>6,'label'=>"Itinerary adult",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_adult_count"),'width'=>"50"),
	array('id'=>7,'label'=>"Itinerary child",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_child_count"),'width'=>"50"),
	array('id'=>8,'label'=>"Itinerary nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_nights"),'width'=>"50"),
	array('id'=>9,'label'=>"Itinerary optionals",'type'=>"complex",'fields'=>array("rv_reservation_item.rv_reservation_item_ix"),'width'=>"100",'function'=>"getOptionalComponents"),
	array('id'=>10,'label'=>"Itinerary property",'type'=>"string",'fields'=>array("property_persona.pr_name_last AS property_name_last"),'width'=>"100"),
	array('id'=>11,'label'=>"Itinerary rate type",'type'=>"string",'fields'=>array("itinerary_rate_type.rt_rate_type_desc"),'width'=>"100"),
	array('id'=>12,'label'=>"Res agent",'type'=>"complex",'fields'=>array("agent_persona.pr_name_last AS agent_name_last"),'width'=>"150",'function'=>"getAgentName"),
	array('id'=>13,'label'=>"Res consultant",'type'=>"complex",'fields'=>array("consultant_persona.pr_name_first AS consultant_name_first","consultant_persona.pr_name_last AS consultant_name_last"),'width'=>"100",'function'=>"getConsultantName"),
	array('id'=>14,'label'=>"Res name",'type'=>"string",'fields'=>array("rv_reservation.rv_res_name"),'width'=>"200"),
	array('id'=>15,'label'=>"Res number",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix"),'width'=>"70"),
	array('id'=>16,'label'=>"Res payment status",'type'=>"complex",'fields'=>array("rv_reservation.rv_amt_accomm_payable","rv_reservation.rv_amt_paid"),'width'=>"50",'function'=>"getPaymentStatus"),
	array('id'=>17,'label'=>"Res source",'type'=>"complex",'fields'=>array("rf_source.rf_source_desc"),'width'=>"100",'function'=>"getSource"),
	array('id'=>18,'label'=>"Res status",'type'=>"string",'fields'=>array("rf_reservation_status.rf_reservation_status_desc"),'width'=>"80"),
	array('id'=>19,'label'=>"Res voucher",'type'=>"string",'fields'=>array("rv_reservation.rv_agent_ref"),'width'=>"70"),
	array('id'=>20,'label'=>"Room guest names",'type'=>"external",'fields'=>array("rv_res_item_guest.pr_guest_names"),'width'=>"240"),
	array('id'=>21,'label'=>"Room number",'type'=>"external",'fields'=>array("ac_accomm_room.ac_desc"),'width'=>"50")
);

function colCompare($a, $b)
{
    if ($a['label'] == $b['label']) {
        return 0;
    }
    return ($a['label'] < $b['label']) ? -1 : 1;
}
usort($cols, "colCompare");

$joins = array(
	array('table'=>"rv_reservation_item"),
	array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",'requires'=>"rv_reservation_item"),
	array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"property_persona",'type'=>"INNER",'on'=>"property_persona.pr_persona_ix = rv_reservation_item.pr_business_id",'requires'=>"rv_reservation_item"),
	array('table'=>"rt_rate_type",'alias'=>"itinerary_rate_type",'type'=>"INNER",'on'=>"itinerary_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation_item"),
	array('table'=>"pr_persona",'alias'=>"agent_persona",'type'=>"LEFT",'on'=>"agent_persona.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
	array('table'=>"pr_persona",'alias'=>"consultant_persona",'type'=>"LEFT",'on'=>"consultant_persona.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
	array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
	array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation")
);

$colArg = $_SERVER['argv'][10];
$colArray = array();
$colOrder = array();
$colSort = array();
$colHeader = false;
if(trim($colArg) != "") {
	$count = 0;
	foreach(explode(":",$colArg) as $item) {
		$col = explode(",",$item);
		if($col[8] != "") {
			$id = $col[8];
		} else {
			$id = $count+1;
		}
		$colItem = getCol($id);
		$colActive[$id] = $col[0];
		$colOrder[$id] = $col[1];
		$colSort[$id] = $col[2];
		$width = $col[4];
		if(!is_numeric($width)) {
			$width = $colItem['width'];
		}
		$label = trim($col[5]);
		if($label == "") {
			$label = $colItem['label'];
		}
		$header = trim($col[6]);
		if($header != "") {
			$colHeader = true;
		}
		$align = trim($col[7]);
		if($align == "") {
			$align = isset($colItem['align']) ? $colItem['align'] : "";
		}
		$colArray[$id] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"align"=>$align
		);
		$count++;
	}
}
asort($colOrder);
asort($colSort);

$colData = array();

foreach($cols as $colKey=>$colItem) {
	$width = $colItem['width'];
	$sort = "";
	$direction = "";
	$label = $colItem['label'];
	$active = "";
	$order = "";
	$header = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$id = $colItem['id'];

	if(isset($colArray[$id]['active']) && $colArray[$id]['active'] == "1") {
		$width = $colArray[$id]['width'];
		$sort = $colArray[$id]['sort'];
		$direction = $colArray[$id]['direction'];		
		$label = $colArray[$id]['label'];
		$active = "1";
		$order = $colArray[$id]['order'];
		$header = $colArray[$id]['header'];
		$align = $colArray[$id]['align'];
	}
	$colDataItem = array(
		'"id":"'.$colItem['id'].'"',
		'"name":"'.$colItem['label'].'"',
		'"width":"'.$width.'"',
		'"sort":"'.$sort.'"',
		'"direction":"'.$direction.'"',
		'"label":"'.$label.'"',
		'"active":"'.$active.'"',
		'"order":"'.$order.'"',
		'"header":"'.$header.'"',
		'"align":"'.$align.'"'
	);
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}
$colData = '['.join(",",$colData).']';
$GLOBALS['temp']['colData'] = $colData;

$renderOption = $_SERVER['argv'][12];

switch ($renderOption) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_CSV:
	$renderMode = "csv";
	$renderType = "email";
	break;
case REP_SEND_CSV:
	$renderMode = "csv";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "oofice";
	$renderType = "view";
	break;
}


if($_SERVER['argc'] > 1) {
	$sql = buildSQL($cols,$colArray,$colSort,$joins);

	$select = array(
		"rv_reservation_item.rv_reservation_item_ix",
		"rv_reservation_item.rv_item_accomm_count",
		"rv_reservation_item.ac_accomm_type_id",
		"ac_accomm_type.ac_accomm_desc",
		"rv_reservation_item.rv_item_date_arrive",
		"rv_reservation_item.rv_item_date_depart",
		"rv_reservation.rv_reservation_ix",
		"(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax"
	);
	$select = array_unique(array_merge($sql['select'],$select));	

	$from = array(
		"rv_reservation_item",
		"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",
		"INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id"
	);
	$from = array_unique(array_merge($sql['from'],$from));
	
	$order = trim(join(",",$sql['sort']));
	if($order != "") {
		$order = " ORDER BY $order ";
	}

	$finalSQL = "
		SELECT
			".join(",\n",$select)."
		FROM
			".join("\n",$from)."
		WHERE
			1
			AND (
				(
					rv_reservation_item.rv_item_date_arrive >= '$dateFrom[jsDate]' 
					AND 
					rv_reservation_item.rv_item_date_arrive <= '$dateTo[jsDate]'
				)
				OR 
				(
					rv_reservation_item.rv_item_date_depart >= '$dateFrom[jsDate]' 
					AND 
					rv_reservation_item.rv_item_date_depart <= '$dateTo[jsDate]'
				)
				OR 
				(
					rv_reservation_item.rv_item_date_arrive < '$dateFrom[jsDate]' 
					AND 
					rv_reservation_item.rv_item_date_depart > '$dateTo[jsDate]'
				)
			)	
			$statusFilter[where]
			$accommFilter[where]
		$order
	";

	$list = $lDB->get($finalSQL,2);

	$newList = array();
	foreach($list as $item) {
		$groups = $lDB->get("
			SELECT
				rv_res_item_group.rv_res_item_group_ix,
				rv_res_item_group.ac_accomm_room_id,
				ac_accomm_room.ac_desc,
				ac_accomm_room.ac_accomm_type_id AS room_accomm_type_id,
				ac_accomm_type.ac_accomm_desc AS room_accomm_desc,
				rv_res_item_group.rv_grp_status_ind,
				rv_res_item_group.rv_grp_status_time
			FROM
				rv_res_item_group
				LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				rv_res_item_group.rv_reservation_item_id = '$item[rv_reservation_item_ix]'
		",2);
		foreach($groups as $groupKey=>$group) {
			$guests = $lDB->get("
				SELECT
					pr_persona.pr_name_first,
					pr_persona.pr_name_last
				FROM
					rv_res_item_guest
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				WHERE
					rv_res_item_guest.rv_res_item_group_id = '$group[rv_res_item_group_ix]'
			",2);
			$guestNames = array();
			foreach($guests as $guest) {
				$name = trim($guest['pr_name_first'] . " " . $guest['pr_name_last']);
				if(!empty($name)) {
					$guestNames[] = $name;
				}
			}
			$groups[$groupKey]['pr_guest_names'] = join(", ",$guestNames);
		}
		if(sizeof($groups) < $item['rv_item_accomm_count']) {
			$extra = $item['rv_item_accomm_count'] - sizeof($groups); // eg 3 needs - 1 allocated = 2 extra
			for($count=0;$count < $extra;$count++) {
				$groups[] = array(
					'rv_res_item_group_ix'=>"",
					'ac_accomm_room_id'=>"",
					'room_accomm_type_id'=>"",
					'ac_desc'=>"",
					'rv_grp_status_ind'=>"2",
					'rv_grp_status_time'=>"0000-00-00 00:00:00"
				);
			}
		}
		$newItem = array();
		foreach($item as $key=>$data) {
			if(!is_numeric($key)) {
				$newItem[$key] = $data;
			}
		}
		foreach($groups as $group) {
			$newGroup = array();
			foreach($group as $key=>$data) {
				if(!is_numeric($key)) {
					$newGroup[$key] = $data;
				}
			}
			$newList[] = array_merge($newItem,$newGroup);
		}
	}
	$list = $newList;
	$newList = null;

	$newList = array();
	$today = date("Y-m-d");
	foreach($list as $item) {
		$rv_grp_status_time_array = explode(" ",$item['rv_grp_status_time']);
		if(!empty($item['rv_res_item_group_ix'])) {
			$first_checkin_array = explode(" ",$lDB->get("
				SELECT
					rv_res_item_grp_status.rv_grp_status_time
				FROM
					rv_res_item_grp_status
				WHERE
					rv_res_item_grp_status.rv_res_item_group_id = '$item[rv_res_item_group_ix]'
					AND rv_res_item_grp_status.rv_grp_status_ind = '5'
				ORDER BY
					rv_res_item_grp_status.rv_grp_status_time
			",4));
		} else {
			$first_checkin_array = array("","");
		}

		if($displayUpgrade == "1" && !empty($item['room_accomm_type_id']) && $item['room_accomm_type_id'] != $item['ac_accomm_type_id']) {
			$newItem = array(
				'discrepancy_type'=>"upgrade",
				'discrepancy_name'=>"Upgrade",
				'discrepancy_detail'=>"$item[ac_accomm_desc] to $item[room_accomm_desc] ($item[ac_desc])"
			);
			$newList[] = array_merge($item,$newItem);
		}
		if($displayNoShow == "1" && $item['rv_item_date_arrive'] <= $today) {
			$found = false;
			$detail = "";

			if(empty($first_checkin_array[0]) || ($item['rv_grp_status_ind'] == 8 && $rv_grp_status_time_array[0] == $first_checkin_array[0])) {
				$found = true;
				$detail = "Expected " . chng_date($item['rv_item_date_arrive'],"-");
			}

			if(!empty($first_checkin_array[0]) && $first_checkin_array[0] != $item['rv_item_date_arrive']) {
				$found = true;
				$detail = "Late. Expected " . chng_date($item['rv_item_date_arrive'],"-") . ". Actual " . chng_date($first_checkin_array[0],"-");
			}

			if($found) {
				$newItem = array(
					'discrepancy_type'=>"noshow",
					'discrepancy_name'=>"No show",
					'discrepancy_detail'=>$detail
				);
				$newList[] = array_merge($item,$newItem);
			}
		}
		if($displayCheckOut == "1") {
			$found = false;
			$detail = "";

			if($item['rv_grp_status_ind'] == 8 && $rv_grp_status_time_array[0] != $first_checkin_array[0]) {
				if($rv_grp_status_time_array[0] < $item['rv_item_date_depart']) {
					$found = true;
					$detail = "Early. Expected ". chng_date($item['rv_item_date_depart'],"-") . ". Actual " . chng_date($rv_grp_status_time_array[0],"-");
				}

				if($rv_grp_status_time_array[0] > $item['rv_item_date_depart']) {
					$found = true;
					$detail = "Late. Expected ". chng_date($item['rv_item_date_depart'],"-") . ". Actual " . chng_date($rv_grp_status_time_array[0],"-");
				}
			}

			if($item['rv_grp_status_ind'] == 5 && $item['rv_item_date_depart'] < $today) {
				$found = true;
				$detail = "Late. Expected ". chng_date($item['rv_item_date_depart'],"-") . ". Actual unknown";
			}

			if($found) {
				$newItem = array(
					'discrepancy_type'=>"checkout",
					'discrepancy_name'=>"Checkout",
					'discrepancy_detail'=>$detail
				);
				$newList[] = array_merge($item,$newItem);
			}
		}
		if($displayMissingGuestNames == "1") {
			$found = false;
			$detail = "";
			if (!isset($item['pr_guest_names']) && $item['pax'] == 0) {
				// No guest names, and PAX is zero. Acceptable scenario, do nothing.
			} else if (!isset($item['pr_guest_names']) && $item['pax'] != 0) {
				// No guest names, and PAX is not zero, not acceptable
				$found = true;
				$detail = "No guest names";
			} else if (isset($item['pr_guest_names']) && $item['pax'] == 0) {
				// We have guests, but PAX is zero, not acceptable
				$found = true;
				$detail = "More guest names then pax";
			} else {
				// We have guests, but not corresponding to number of PAX, not acceptable
				$guest_names = explode(',', $item['pr_guest_names']);
				if (count($guest_names) < $item['pax']) {
					$found = true;
					$detail = "Less guest names then pax";
				} else if (count($guest_names) > $item['pax']) {
					$found = true;
					$detail = "More guest names then pax";
				}
			}

			if($found) {
				$newItem = array(
					'discrepancy_type'=>"guestnames",
					'discrepancy_name'=>"Guest names",
					'discrepancy_detail'=>$detail
				);
				$newList[] = array_merge($item,$newItem);
			}
		}		
	}
	$list = $newList;
	$newList = null;

	$newList = array();
	$resList = array();
	$colourList = array();
	foreach($list as $item) {
		$newItem = array();
		$itemColour = "";

		foreach($colOrder as $key=>$colItem) {
			if($colArray[$key]['active'] == "1") {
				$values = array();
				$colItem = getCol($key);

				foreach($colItem['fields'] as $field) {
					$fieldName = getFieldName($field);
					array_push($values,(isset($item[$fieldName]) ? $item[$fieldName] : ""));
				}
				if($fieldName == "discrepancy_name" || $fieldName == "discrepancy_detail") {
					switch($item['discrepancy_type']) {
					case "upgrade":
						$itemColour = "#ff8";
						break;
					case "noshow":
						$itemColour = "#fd8";
						break;
					case "checkout":
						$itemColour = "#8f8";
						break;
					case "guestnames":
						$itemColour = "#d88380";
						break;
					}
				}
				switch($colItem['type']) {
				default:
				case "external":
				case "string":
					$value = trim(str_replace("\r","",join(" ",$values)));
					break;
				case "date":
					$value = "";
					if($values[0] != "0000-00-00") {
						$value = chng_date($values[0],"-");
					}
					break;
				case "complex":
					if(function_exists($colItem['function'])) {
						$value = call_user_func_array($colItem['function'],$values);
					} else {
						$value = "NOT IMPLEMENTED";
					}
					break;
				}
				$newItem[$key] = $value;
			}
		}		
		if(sizeof($newItem) > 0) {
			array_push($newList,$newItem);
			array_push($resList,$item['rv_reservation_ix']);
			array_push($colourList,$itemColour);
		}
	}
	$list = $newList;
	$newList = null;

	foreach($list as $item) {
		$keep = false;
		if($displayUpgrade == "1") {
		}
		if($displayNoShow == "1") {
		}
		if($displayCheckOut == "1") {
		}
		if($displayMissingGuestNames == "1") {
		}
	}
	if($renderMode == "html") {
		$GLOBALS['temp']['reportGenerated'] = "";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

		$GLOBALS['temp']['makeReport'] = "";
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		if(sizeof($list) > 0) {
			$dataCol = "";
			$dataHeader1 = "";
			$dataHeader2 = "";
			$dataColCount = 0;
			$dataWidth = 0;
			$lastHeader = "";
			$lastHeaderCount = 0;
			foreach($colOrder as $key=>$item) {
				if($colArray[$key]['active'] == "1") {
					$dataCol .= "<col width=\"".$colArray[$key]['width']."\" />";
					$align = "";
					if($colArray[$key]['align'] == "c") {
						$align = "align=\"center\"";
					}
					if($colArray[$key]['align'] == "r") {
						$align = "align=\"right\"";
					}
					if($colHeader) {
						if($lastHeader != "" && $lastHeader != $colArray[$key]['header']) {
							$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
							$lastHeader = "";
							$lastHeaderCount = 0;
						}
						if($colArray[$key]['header'] != "") {
							$dataHeader2 .= "<td class=\"outLt\" $align>".$colArray[$key]['label']."</td>";
							$lastHeader = $colArray[$key]['header'];
							$lastHeaderCount++;
						} else {
							$dataHeader1 .= "<td class=\"outLt\" rowspan=\"2\" $align>".$colArray[$key]['label']."</td>";
						}
					} else {
						$dataHeader1 .= "<td class=\"outLt\" $align>".$colArray[$key]['label']."</td>";
					}
					$dataColCount++;
					$dataWidth += $colArray[$key]['width'];
				}
			}
			$GLOBALS['temp']['dataCol'] = $dataCol;
			if($lastHeader != "") {
				$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
			}
			$dataHeader = "<tr>$dataHeader1</tr>";
			if($colHeader) {
				$dataHeader .= "<tr>$dataHeader2</tr>";
			}
			$GLOBALS['temp']['dataHeader'] = $dataHeader;
			$GLOBALS['temp']['dataColCount'] = $dataColCount;
			$GLOBALS['temp']['dataWidth'] = $dataWidth;

			$rows = "";
			$lastId = false;
			$lastData = false;
			foreach($list as $listKey=>$item) {
				$resId = $resList[$listKey];
				array_push($resScrollSet,$resId);
				$rows .= "<tr class='linkrow' onclick=\"window.location='/reservation.php?216+$resId';\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\">";
				foreach($item as $key=>$cell) {
					$align = "";
					if($colArray[$key]['align'] == "c") {
						$align = "align=\"center\"";
					}
					if($colArray[$key]['align'] == "r") {
						$align = "align=\"right\"";
					}
					if($cell == "") {
						$cell = "&nbsp;";
					} else {
						$cell = str_replace("\n","<br />",$cell);
					}
					$colour = "";
					// If discrepancy or discrepancy detail, add applicable background colour
					if($key == "3" || $key == "4") {
						$colour = $colourList[$listKey];
					}
					$rows .= "<td class=\"br\" $align style=\"overflow: hidden; background-color: $colour\">$cell</td>";
				}
				$rows .= "</tr>";
				$last = $item;
			}
			$GLOBALS['temp']['dataRows'] = $rows;		
			setRecordScroll(array_unique($resScrollSet));
		} else {
			$GLOBALS['temp']['dataHeader'] = "";
			$GLOBALS['temp']['dataCol'] = "<col />";
			$GLOBALS['temp']['dataColCount'] = "1";
			$GLOBALS['temp']['dataWidth'] = "770";
			$GLOBALS['temp']['dataRows'] = "<tr><td class=\"txti\">No data matched your filter criteria.</td></tr>";		
		}
	}
	if ( $renderMode == "csv" ) {
		$csv = array();
		array_push($csv,array($title));
		array_push($csv,array());
		array_push($csv,array("Date range",$dateFrom['htmlDate'] . " to " . $dateTo['htmlDate']));
		array_push($csv,array("Status",$statusFilter['names']));
		array_push($csv,array("Property / Accomm",$accommFilter['names']));
		array_push($csv,array("Display upgraded room discrepancies",($displayUpgrade == "1"?"Yes":"No")));
		array_push($csv,array("Display no show discrepancies",($displayNoShow == "1"?"Yes":"No")));
		array_push($csv,array("Display check out discrepancies",($displayCheckOut == "1"?"Yes":"No")));
		array_push($csv,array("Display missing guest names",($displayMissingGuestNames == "1"?"Yes":"No")));
		array_push($csv,array());

		$header1 = array();
		$header2 = array();
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1") {
				if($colHeader) {
					array_push($header1,$colArray[$key]['header']);
					array_push($header2,$colArray[$key]['label']);
				} else {
					array_push($header1,$colArray[$key]['label']);
				}
			}
		}
		if($colHeader) {
			array_push($csv,$header1,$header2);
		} else {
			array_push($csv,$header1);
		}
		$csv = array_merge($csv,$list);
				
		
		csv_output("room_discrepancy_report_".$dateFrom['jsDate']."_to_".$dateTo['jsDate'],$csv);
	}	
} else {
	$GLOBALS['temp']['reportGenerated'] = " class=\"collapse printCollapse\" ";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";			
	$GLOBALS['temp']['dataWidth'] = "0";	
}
