<?php

class FinancialAnalysisDrillDown {
	var $Type;
	var $ItemIds;
	var $Items;


	function __construct($job,$itemIds) {
		$this->Type = ($job==FINANCIAL_ANALYSIS_DAY?"res":"folio");
		$this->ItemIds = $itemIds;
		$this->Items = array();
	}

	function Render() {
		$this->Build();
		$html = $this->HTML();
		echo $html;
		die();
	}
}

class FinancialAnalysisDrillDownFolio extends FinancialAnalysisDrillDown {

	function Build() {
		global $lDB;

		$this->Items = $lDB->get("
			SELECT DISTINCT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				agent_persona.pr_name_last AS agent_name_last,
				agent_persona.pr_name_first AS agent_name_first,
				rf_reservation_status.rf_reservation_status_desc
			FROM
				fn_folio
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
				LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			WHERE
				fn_folio.fn_folio_ix IN ('".join("','",$this->ItemIds)."')
		",2);

		$reservations = array();
		foreach($this->Items as $item) {
			$reservations[] = $item['rv_reservation_ix'];
		}
		setRecordScroll($reservations);
	}
	
	function HTML() {
		$divHTML = join("",file(__DIR__ . "/../../../public/html/rep_financial_analysis_drilldown_res.htm"));
		$rowHTML = join("",file(__DIR__ . "/../../../public/html/rep_financial_analysis_drilldown_res_row.htm"));

		$rows = "";

		if(sizeof($this->Items) > 0) {
			foreach($this->Items as $item) {
				$item['agent_name'] = trim($item['agent_name_first'] . " " . $item['agent_name_last']);
				if(empty($item['agent_name'])) {
					$item['agent_name'] = "Direct";
				}

				$item['job'] = "0";
				if(canEditReservation($item['rv_reservation_ix'])) {
					$item['job'] = "2";
				}

				$rows .= showpage($item,$rowHTML);
			}
		} else {
			$rows .= "
				<tr>
					<td class=\"txti\" colspan=\"5\" align=\"center\">No items exist for this grouping</td>
				</tr>
			";
		}

		return showpage(array('rows'=>$rows),$divHTML);
	}
}

class FinancialAnalysisDrillDownRes extends FinancialAnalysisDrillDown {
	function Build() {
		global $lDB;

		$this->Items = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				agent_persona.pr_name_last AS agent_name_last,
				agent_persona.pr_name_first AS agent_name_first,
				rf_reservation_status.rf_reservation_status_desc
			FROM
				rv_reservation
				LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
			WHERE
				rv_reservation.rv_reservation_ix IN ('".join("','",$this->ItemIds)."')
		",2);

		$reservations = array();
		foreach($this->Items as $item) {
			$reservations[] = $item['rv_reservation_ix'];
		}
		setRecordScroll($reservations);
	}

	function HTML() {
		$divHTML = join("",file(__DIR__ . "/../../../public/html/rep_financial_analysis_drilldown_res.htm"));
		$rowHTML = join("",file(__DIR__ . "/../../../public/html/rep_financial_analysis_drilldown_res_row.htm"));

		$rows = "";

		if(sizeof($this->Items) > 0) {
			foreach($this->Items as $item) {
				$item['agent_name'] = trim($item['agent_name_first'] . " " . $item['agent_name_last']);
				if(empty($item['agent_name'])) {
					$item['agent_name'] = "Direct";
				}

				$item['job'] = "0";
				if(canEditReservation($item['rv_reservation_ix'])) {
					$item['job'] = "2";
				}

				$rows .= showpage($item,$rowHTML);
			}
		} else {
			$rows .= "
				<tr>
					<td class=\"txti\" colspan=\"5\" align=\"center\">No items exist for this grouping</td>
				</tr>
			";
		}

		return showpage(array('rows'=>$rows),$divHTML);
	}
}

