<?php

/*
 * $Id: init.form1008.func.php,v 1.3 2013-02-12 12:49:32 light Exp $
 *
 * $Log: init.form1008.func.php,v $
 * Revision 1.3  2013-02-12 12:49:32  light
 * Bug #8153 - HOTFIX Financial analysis with accommodation extras
 *
 * Revision 1.2  2012-12-04 14:50:26  light
 * Bug #8060 - Financial analysis fixes and enchancements
 *
 * Revision 1.1  2012-08-06 15:37:25  light
 * Bug #7824 - Financial Analysis
 *
 */

/**
 * init.form1008.func.php - Financial Analysis (Folio)
 * Job: 1012
 * Function: 105 (Reports Financials: Financial Analysis)
 */

require_once(__DIR__ . '/db.rf_country.php');
require_once(__DIR__ . '/db.rf_reservation_status.php');
require_once(__DIR__ . '/db.ac_extra_category.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/class.stock.php');
require_once(__DIR__ . '/class.report.php');
require_once(__DIR__ . "/init.form1008.func.report.php");

define("FINANCIAL_ANALYSIS_DAY",1014);
define("FINANCIAL_ANALYSIS_FOLIO",1015);

define("FINANCIAL_ANALYSIS_ROW_PER_GROUP",1);
define("FINANCIAL_ANALYSIS_ROW_PER_PERIOD",2);

define("FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_WEEK",1);
define("FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_MONTH",2);
define("FINANCIAL_ANALYSIS_PER_DAY_DAY_AND_MONTH",3);
define("FINANCIAL_ANALYSIS_PER_DAY_FULL",4);

$job = $_SERVER['argv'][0];

switch($job) {
case FINANCIAL_ANALYSIS_DAY:
	require_once(__DIR__ . '/init.form1008.func.report.day.php');
	require_once(__DIR__ . '/init.form1008.func.drilldown.php');
	break;
case FINANCIAL_ANALYSIS_FOLIO:
	require_once(__DIR__ . '/init.form1008.func.report.folio.php');
	require_once(__DIR__ . '/init.form1008.func.drilldown.php');
	break;
}


function formatAgentName($name) {
	$name = trim($name);

	if(empty($name)) { return "Direct"; }
	
	return $name;
}

function getAgentEmail($email) {
	$email = trim($email);
	
	return $email;
}

function getDebtor($firstName,$lastName) {
	$name = trim($firstName . " " . $lastName);

	if(empty($name)) { return "Cash"; }
	
	return $name;
}

function getDebtorEmail($email) {
	$email = trim($email);
	return $email;
}

function getDrawdown($rv_reservation_item_id) {
	global $lDB;

	$drawdown = $lDB->get("
		SELECT
			COUNT(allocation_item.rv_reservation_item_ix) AS allocation_count
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation_item AS allocation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $lDB->escape($rv_reservation_item_id) . "'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",4);
	if($drawdown > 0) {
		return "Drawn down";
	} else {
		return "Not drawn down";
	}
}

function getDrawdownKey($rv_reservation_item_id) {
	global $lDB;

	$drawdown = $lDB->get("
		SELECT
			COUNT(allocation_item.rv_reservation_item_ix) AS allocation_count
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation_item AS allocation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '" . $lDB->escape($rv_reservation_item_id) . "'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",4);
	if($drawdown > 0) {
		return true;
	} else {
		return false;
	}
}

function getAllocationFirst($items, $suffix="id") {
	global $lDB;

	$reservations = array_unique(array_map(function($item) { return $item['rv_reservation_id']; }, $items));

	$allocation = $lDB->get("
		SELECT
			allocation.rv_reservation_ix AS allocation_id,
			allocation.rv_res_name AS allocation_name
		FROM
			rv_reservation allocation
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			draw_down_item.rv_reservation_id IN ('".join("','",$reservations)."')
	",1);
	return $allocation["allocation_$suffix"];
}

function getBlockFirst($items, $suffix="id") {
	global $lDB;

	$reservations = array_unique(array_map(function($item) { return $item['rv_reservation_id']; }, $items));

	$block = $lDB->get("
		SELECT
			bl_block.bl_block_ix AS bl_block_id,
			bl_block.bl_block_name
		FROM
			bl_block
			INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
			LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
			LEFT JOIN rv_reservation_item allocation_item ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
			LEFT JOIN rv_reservation_item draw_down_item ON draw_down_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
		WHERE
			draw_down_item.rv_reservation_id IN ('".join("','",$reservations)."')
	",1);
	return $block["bl_block_$suffix"];
}

function getSpecialNoteFirst($items) {
	foreach($items as $item) {
		if (count($item['specials']) > 0) {
			return empty($item['specials'][0]['sp_special_note']) ? " " : $item['specials'][0]['sp_special_note'];
		}
	}
	return "";
}

function getSpecialOverrideUserFirst($items) {
	foreach($items as $item) {
		if (count($item['specials']) > 0) {
			if($item['specials'][0]['rv_sp_override_yn'] == "1") {
				return trim($item['specials'][0]['special_override_name_first'] . " " . $item['specials'][0]['special_override_name_last']);
			}
		}
	}
	return "";
}

function getSpecialOverrideDateFirst($items) {
	foreach($items as $item) {
		if (count($item['specials']) > 0) {
			if($item['specials'][0]['rv_sp_override_yn'] == "1") {
				return empty($item['specials'][0]['rv_sp_override_date']) ? " " : chng_date($item['specials'][0]['rv_sp_override_date'], "-", 5);
			}
		}
	}
	return "";
}

function getSpecialApplicationDateFirst($items) {
	foreach($items as $item) {
		if (count($item['specials']) > 0) {
			return empty($item['specials'][0]['ad_create_date']) ? " " : chng_date($item['specials'][0]['ad_create_date'], "-", 5);
		}
	}
	return "";
}

function getSpecialDiscountTotal($items) {
	$totalDiscount = 0;
	foreach($items as $item) {
		foreach($item['specials'] as $special) {
			$totalDiscount += $special['rv_sp_amt_discount'];
		}
	}
	return $totalDiscount;
}

function getSpecialCount($items) {

	$specialIds = [];
	foreach($items as $item) {
		foreach($item['specials'] as $special) {
			$specialIds[] = $special['rv_special_ix'];
		}
	}
	$specialCount = sizeof(array_unique($specialIds));
	if($specialCount > 0) {
		return $specialCount;
	}
	return "";
}

function groupCount($items,$field) {
	return sizeof($items);
}

function getKeys($item) {
	return array_map("getSubKey",$item['key_items']);
}

function getSubKey($item) {
	return $item['id'];
}

function folioArray($items,$field) {
	$folios = array();
	foreach($items as $item) {
		$fn_date = $item['fn_folio.fn_folio_date'];
		if(!empty($item['fn_invoice.fn_invoice_ix'])) {
			$fn_date = $item['fn_invoice.fn_inv_date'];
		}
		$folios[$item[$field]] = array(
			'id'=>$item[$field],
			'fn_date'=>$fn_date,
			'fn_folio_date'=>$item['fn_folio.fn_folio_date'],
			'fn_folio_amount'=>$item['fn_folio.fn_folio_amount'],
			'fn_folio_amt_paid'=>$item['fn_folio.fn_folio_amt_paid'],			
			'fn_invoice_ix'=>$item['fn_invoice.fn_invoice_ix'],
			'fn_inv_date'=>$item['fn_invoice.fn_inv_date'],
			'rv_reservation_id'=>$item['rv_reservation.rv_reservation_ix'],
			'itineraries'=>array(),
			'extras'=>array(),
			'payments'=>array(),
			'specials'=>array()
		);
	}
	return $folios;
}

function resArray($items,$field) {
	$res = array();
	foreach($items as $item) {
		$res[$item[$field]] = array(
			'id'=>$item[$field],
			'rv_reservation_id'=>$item['rv_reservation.rv_reservation_ix'],
			'itineraries'=>array(),
			'extras'=>array(),
			'payments'=>array()
		);
	}
	return $res;
}

function getCountry($rf_country_id) {
	global $lDB;

	if(db_rf_country_exists($rf_country_id)) {
		return $lDB->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '$rf_country_id'",4);
	} else {
		return "No country";
	}
}

function getCountryKey($key,$field) {
	if($key == '') {
		return '0';
	}
	else {
		return $key;
	}
}

function formatCommPerc($pr_agent_commission_perc) {
	return $pr_agent_commission_perc;
}

function getConsultantName($pr_name_first,$pr_name_last) {
	$name = trim($pr_name_first . " " . $pr_name_last);

	if($name != "") {
		return $name;
	} else {
		return "No consultant";
	}
}

function getContactName($pr_name_first,$pr_name_last) {
	$name = trim($pr_name_first . " " . $pr_name_last);

	if($name != "") {
		return $name;
	} else {
		return "No contact";
	}
}

function getContactEmail($pr_email) {
	$email = trim($pr_email);

	return $email;
}

function getOriginatorName($pr_name_first,$pr_name_last) {
	$name = trim($pr_name_first . " " . $pr_name_last);

	if($name != "") {
		return $name;
	} else {
		return "No originator";
	}
}

function getOriginatorEmail($pr_email) {
	$email = trim($pr_email);

	return $email;
}


function getMonth($date) {
	$date = explode(" ",$date);
	$date = $date[0];
	if($date == "0000-00-00") {
		return array('value'=>"None",'sort'=>"0");
	}
	list($year,$month,$day) = explode("-",$date);
	return array('value'=>date("M",mktime(0,0,0,$month,$day,$year)), 'sort'=>$month);
}

function getMonthKey($date) {
	$date = explode(" ",$date);
	$date = $date[0];
	if($date == "0000-00-00") {
		return "0";
	}
	list($year,$month,$day) = explode("-",$date);
	return $month;
}

function getYear($date) {
	$date = explode(" ",$date);
	$date = $date[0];
	if($date == "0000-00-00") {
		return array('value'=>"None",'sort'=>"0000");
	}
	list($year,$month,$day) = explode("-",$date);
	return $year;
}

function getYearKey($date) {
	$date = explode(" ",$date);
	$date = $date[0];
	if($date == "0000-00-00") {
		return "0000";
	}
	list($year,$month,$day) = explode("-",$date);
	return $year;
}

function getTravelDays($arrive, $depart) {
	$current = strtotime($arrive);
	$depart = strtotime($depart);
	$days = [];
	$sortDays = [];
	while($current < $depart) {
		$days[date("Y-m-d",$current)] = date("d",$current);
		$sortDays[date("Y-m-d",$current)] = date("j",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 day");
	}
	return array('value'=>$days, 'sort'=>$sortDays);
}

function getTravelDayKeys($dates) {
	list($arrive, $depart) = explode("_", $dates);
	$current = strtotime($arrive);
	$depart = strtotime($depart);
	$days = [];
	while($current < $depart) {
		$days[] = date("Y-m-d",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 day");
	}
	return $days;
}

function getTravelMonths($arrive, $depart) {
	$current = strtotime(substr($arrive,0,-2) . "01");
	$depart = strtotime(substr($depart,0,-2) . "01" . " +1 month");
	$months = [];
	$sortMonths = [];
	while($current < $depart) {
		$months[date("Y-m",$current)] = date("M",$current);
		$sortMonths[date("Y-m",$current)] = date("n",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 month");
	}
	return array('value'=>$months, 'sort'=>$sortMonths);
}

function getTravelMonthKeys($dates) {
	list($arrive, $depart) = explode("_", $dates);
	$current = strtotime(substr($arrive,0,-2) . "01");
	$depart = strtotime(substr($depart,0,-2) . "01" . " +1 month");
	$months = [];
	while($current < $depart) {
		$months[] = date("Y-m",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 month");
	}
	return $months;
}

function getTravelYears($arrive, $depart) {
	$current = strtotime(substr($arrive,0,-2) . "01");
	$depart = strtotime(substr($depart,0,-2) . "01" . " +1 month");
	$years = [];
	while($current < $depart) {
		$years[date("Y",$current)] = date("Y",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 month");
	}
	$years = array_unique($years);
	return array('value'=>$years);
}

function getTravelYearKeys($dates) {
	list($arrive, $depart) = explode("_", $dates);
	$current = strtotime(substr($arrive,0,-2) . "01");
	$depart = strtotime(substr($depart,0,-2) . "01" . " +1 month");
	$years = [];
	while($current < $depart) {
		$years[] = date("Y",$current);
		$current = strtotime(date("Y-m-d",$current) . " +1 month");
	}
	$years = array_unique($years);
	return $years;
}


function getSourceName($rf_source_desc) {
	$rf_source_desc = trim($rf_source_desc);
	if($rf_source_desc == "") {
		return "No source";
	} else {
		return $rf_source_desc;
	}
}

function getFolioDB($fn_folio_db) {
	global $lDB;
	$rf_db_env_type_ind = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$fn_folio_db'",4);
	if($rf_db_env_type_ind == "2") {
		return "Reservation office";
	} else {
		return $fn_folio_db;
	}
}

function getFolioDBKey($fn_folio_db) {
	global $lDB;
	$rf_db_env_type_ind = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$fn_folio_db'",4);
	if($rf_db_env_type_ind == "2") {
		return "Res";
	} else {
		return $fn_folio_db;
	}
}

function formatDate($dateValue) {
	return chng_date($dateValue,"-");
}

function getArriveDate($items,$startDate,$endDate) {
	$date = "9999-99-99";
	foreach($items as $item) {
		foreach($item['itineraries'] as $itinerary) {
			if($itinerary['rv_item_date_arrive'] < $date && $itinerary['rv_item_date_arrive'] >= $startDate && $itinerary['rv_item_date_arrive'] <= $endDate) {
				$date = $itinerary['rv_item_date_arrive'];
			}
		}
	}
	if($date != "9999-99-99") {
		return $date;
	} else {
		return "0000-00-00";
	}
}

function getDepartDate($items,$startDate,$endDate) {
	$date = "0000-00-00";
	foreach($items as $item) {
		foreach($item['itineraries'] as $itinerary) {
			if($itinerary['rv_item_date_depart'] > $date && $itinerary['rv_item_date_depart'] >= $startDate && $itinerary['rv_item_date_depart'] <= $endDate) {
				$date = $itinerary['rv_item_date_depart'];
			}
		}
	}
	return $date;
}

function getStatusDate($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted) {
	switch($rf_reservation_status_id) {
	case DB_RF_RESERVATION_STATUS_DELETED:
		$statusDate = $rv_date_deleted;
		break;
	case DB_RF_RESERVATION_STATUS_CANCELLED:
		$statusDate = $rv_cancel_date;
		break;
	case DB_RF_RESERVATION_STATUS_CONFIRMED:
		$statusDate = $rv_confirmation_date;
		break;
	case DB_RF_RESERVATION_STATUS_PROVISIONAL:
		$statusDate = $rv_prov_date;
		break;
	case DB_RF_RESERVATION_STATUS_WAITLIST:
		list($statusDate,$statusTime)  = array_pad( explode(" ",$rv_wait_list_date), 2, '' );
		break;
	case DB_RF_RESERVATION_STATUS_QUOTATION:
		$statusDate = $rv_date_quote;
		break;
	}

	if(empty($statusDate)) {
		return "Unknown";
	} else {
		return array('value'=>chng_date($statusDate,"-"), 'sort'=>$statusDate);
	}
}

function getStatusMonth($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted) {
	$statusDate = getStatusDate($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted);
	if (!is_array($statusDate) && $statusDate == "Unknown") {
		return "Unknown";
	} else {
		list($year,$month,$day) = explode("-",$statusDate['sort']);
		return array('value'=>date("M",mktime(0,0,0,$month,$day,$year)), 'sort'=>$month);
	}
}

function getStatusMonthKey($keys,$field) {
	list($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted) = array_pad( explode("_",$keys), 5, '' );
	$month = getStatusMonth($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted);
	if (!is_array($month)) {
		return "";
	} else {
		return $month['sort'];
	}
}

function getStatusYear($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted) {
	$statusDate = getStatusDate($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted);
	if (!is_array($statusDate) && $statusDate == "Unknown") {
		return "Unknown";
	} else {
		list($year,$month,$day) = explode("-",$statusDate['sort']);
		return $year;
	}
}

function getStatusYearKey($keys,$field) {
	list($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted) = array_pad( explode("_",$keys), 5, '' );
	$year = getStatusYear($rf_reservation_status_id,$rv_cancel_date,$rv_confirmation_date,$rv_prov_date,$rv_wait_list_date,$rv_date_quote,$rv_date_deleted);
	if (!is_array($year)) {
		return "";
	} else {
		return $year['sort'];
	}
}

function getRooms($folios) {
	$rooms = 0;
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			$rooms += $itinerary['rv_item_accomm_count'];
		}
	}
	return $rooms;
}

function getPAX($folios,$rt_rate_group_id=false) {
	$PAX = 0;
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			$rateGroupCount = 0;
			foreach($itinerary['rv_res_item_rate_grp'] as $rateGroup) {
				if($rt_rate_group_id !== false && $rt_rate_group_id != $rateGroup['rt_rate_group_id']) {
					continue;
				}
				$rateGroupCount += $rateGroup['rv_res_item_rate_grp_count'];
			}
			$PAX += ($itinerary['rv_item_accomm_count'] * $rateGroupCount);
		}
	}
	return $PAX;	
}

function getRoomNights($folios) {
	$roomNights = 0;
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			$roomNights += ($itinerary['rv_item_accomm_count'] * $itinerary['rv_item_nights']);
		}
	}
	return $roomNights;
}

function getBedNights($folios,$rt_rate_group_id=false) {
	$bedNights = 0;
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			$rateGroupCount = 0;
			foreach($itinerary['rv_res_item_rate_grp'] as $rateGroup) {
				if($rt_rate_group_id !== false && $rt_rate_group_id != $rateGroup['rt_rate_group_id']) {
					continue;
				}
				$rateGroupCount += $rateGroup['rv_res_item_rate_grp_count'];
			}
			$bedNights += ($itinerary['rv_item_accomm_count'] * $itinerary['rv_item_nights'] * $rateGroupCount);
		}
	}
	return $bedNights;	
}

function getReservationCount($items,$type) {
	$reservations = array();
	foreach($items as $item) {
		if(
			sizeof($item['itineraries']) > 0
			|| sizeof($item['extras']) > 0
			|| sizeof($item['payments']) > 0
			|| $type == "reservation"
		) {
			$reservations[] = $item['rv_reservation_id'];
		}
	}
	$reservations = array_unique($reservations);
	return sizeof($reservations);
}

/**
 * getPropertyCount() - The number of properties
 * @param array $items
 *
 **/
function getPropertyCount($items) {
	$propertyIds = array();
	foreach($items as $item) {
		foreach($item['itineraries'] as $itinerary) {
			$propertyIds[] = $itinerary['pr_business_id'];
		}
	}
	$propertyIds = array_unique($propertyIds);
	return sizeof($propertyIds);
}

/**
 * getNightsCount() - The number of nights inhouse (excluding skipped nights)
 * 	(not bed nights or room nights)
 * @param array $items
 *
 **/
function getNightsCount($items) {
	$nights = array();
	foreach($items as $item) {
		foreach($item['itineraries'] as $itinerary) {
			$dateSpan = new DatePeriod(
				 new DateTime($itinerary['rv_item_date_arrive']),
				 new DateInterval('P1D'),
				 new DateTime($itinerary['rv_item_date_depart'])
			);
			foreach ($dateSpan as $date) {
				$nights[] = $date->format("Y-m-d");
			}
		}
	}
	$nights = array_unique($nights);
	return sizeof($nights);
}

function getRoomNightsPerc($folios,$roomNights) {
	if($roomNights > 0) {
		return getRoomNights($folios) / $roomNights;
	} else {
		return "";
	}	
}

function getBedNightsPerc($folios,$bedNights,$rt_rate_group_id=false) {
	if($bedNights > 0) {
		return getBedNights($folios,$rt_rate_group_id) / $bedNights;
	} else {
		return "";
	}	
}


function getReservationCountPerc($folios,$type,$reservations) {
	if($reservations > 0) {
		return getReservationCount($folios,$type) / $reservations;
	} else {
		return "";
	}
}

function getAvgLOS($folios) {
	$bedNights = 0;
	$roomNights = 0;
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			//Calculation of average length of stay is not correct. Should be  (Nights * Rooms * Pax) / (Rooms * Pax)
			$bedNights += ($itinerary['rv_item_nights'] * $itinerary['rv_item_accomm_count'] * ($itinerary['rv_item_adult_count'] + $itinerary['rv_item_child_count']));
			$roomNights += ($itinerary['rv_item_accomm_count'] * ($itinerary['rv_item_adult_count'] + $itinerary['rv_item_child_count']));
		}
	}

	if($roomNights != 0) {
		return $bedNights / $roomNights;
	} else {
		return "";
	}
}

function getAvgRoomNightsPerRes($folios,$type) {
	$roomNights = getRoomNights($folios);
	$reservations = getReservationCount($folios,$type);

	if($reservations > 0) {
		return $roomNights / $reservations;
	} else {
		return "";
	}
}

function getAvgBedNightsPerRes($folios,$type,$rt_rate_group_id=false) {
	$bedNights = getBedNights($folios,$rt_rate_group_id);
	$reservations = getReservationCount($folios,$type);

	if($reservations > 0) {
		return $bedNights / $reservations;
	} else {
		return "";
	}
}

function getPotential($type,$items,$level,$potential,$startDate,$endDate) {
	$days = dateSubtract($endDate,$startDate)+1;

	$startArray = explode("-",$startDate);
	$total = 0;
	for($count=0;$count<$days;$count++) {
		$date = date("Y-m-d",mktime(0,0,0,$startArray[1],$startArray[2]+$count,$startArray[0]));
		foreach($potential as $item) {
			if(
				(
					$level == "res"
				) || (
					$level == "property"
					&& $item['pr_business_id'] == $items['rv_reservation_item.pr_business_name_key']
				) || (
					$level == "accomm"
					&& $item['ac_accomm_type_id'] == $items['rv_reservation_item.ac_accomm_type_name_key']
				)
			) {
				if($type == "room") {
					$total += (isset($item['stock'][$date]) ? $item['stock'][$date] : 0);
				} else {
					$total += (isset($item['stock'][$date]) ? $item['stock'][$date] : 0) * $item['ac_accomm_capacity'];
				}
			}
		}
	}
	return $total;
//	debug($days);
}

function getAccommodationTotal($folios,$amountType,$tax,$type=false,$id=false) {
	$total = 0;
	$key = "";
	if($id !== false) {
		$key = explode("_",$id);
	}
	foreach($folios as $folio) {
		foreach($folio['itineraries'] as $itinerary) {
			foreach($itinerary['rv_res_item_comp'] as $component) {
				foreach($component['rv_res_item_comp_rate_grp'] as $rateGroup) {					
					if($type == "component" && $key[0] != $component['rt_component_id']) {
						continue;
					}
					if($type == "rateGroup" && $key[0] != $rateGroup['rt_rate_group_id']) {
						continue;
					}
					if($type == "componentRateGroup" && ($key[0] != $component['rt_component_id'] || $key[1] != $rateGroup['rt_rate_group_id']) ) {
						continue;
					}
					if($type == "rateGroupComponent" && ($key[0] != $rateGroup['rt_rate_group_id'] || $key[1] != $component['rt_component_id']) ) {
						continue;
					}
					if($type == "property" && $key[0] != $itinerary['pr_business_id']) {
						continue;
					}
					$total += $rateGroup['rv_item_comp_rate_grp_amt_'.$amountType];
					if($tax != "1") {
						$total -= $rateGroup['rv_item_comp_rate_grp_amt_tax'];
					}
				}
			}
		}
	}

	return $total;
}

function getExtrasTotal($folios,$amountType,$tax,$ac_extra_ix=false,$ac_extra_category_ix=false,$type=false) {
	$total = 0;
	foreach($folios as $folio) {
		foreach($folio['extras'] as $extra) {
			if($ac_extra_ix !== false && $ac_extra_ix != $extra['ac_extra_ix']) {
				continue;
			}
			if($ac_extra_category_ix !== false && $ac_extra_category_ix != $extra['ac_extra_category_ix']) {
				continue;
			}
			if(
				$type !== false
				&& (
					($type == "extra" && $extra['ac_extra_cat_ind'] != DB_AC_EXTRA_CAT_GENERAL)
					|| ($type == "activity" && $extra['ac_extra_cat_ind'] != DB_AC_EXTRA_CAT_ACTIVITY)
					|| ($type == "travel" && $extra['ac_extra_cat_ind'] != DB_AC_EXTRA_CAT_TRAVEL)
					|| ($type == "accomm-extra" && $extra['ac_extra_cat_ind'] != DB_AC_EXTRA_CAT_ACCOMMODATION)
				)
			) {
				continue;
			}
			$total += $extra['rv_extra_amt_'.$amountType];
			if($tax != "1") {
				$total -= $extra['rv_extra_amt_tax'];
			}
		}
	}
	return $total;
}

function getTaxTotal($folios,$rf_tax_rate_id=false,$rf_tax_rate_type=false) {
	$total = 0;
	foreach($folios as $folio) {
		if($rf_tax_rate_type === false || $rf_tax_rate_type == "itinerary") {
			foreach($folio['itineraries'] as $itinerary) {
				foreach($itinerary['rv_res_item_comp'] as $component) {
					foreach($component['rv_res_item_comp_tax'] as $tax) {					
						if($rf_tax_rate_id === false || $rf_tax_rate_id == $tax['rf_tax_rate_id']) {
							$total += $tax['rv_res_item_comp_tax_amt'];
						}
					}
				}
			}
		}
		if($rf_tax_rate_type === false || $rf_tax_rate_type != "itinerary") {
			foreach($folio['extras'] as $extra) {
				if(
					(
						$rf_tax_rate_id === false
						|| $rf_tax_rate_id == $extra['rf_tax_id']
					) && (
						$rf_tax_rate_type === false
						|| ($rf_tax_rate_type == "extra" && $extra['ac_extra_cat_ind'] == DB_AC_EXTRA_CAT_GENERAL)
						|| ($rf_tax_rate_type == "activity" && $extra['ac_extra_cat_ind'] == DB_AC_EXTRA_CAT_ACTIVITY)
						|| ($rf_tax_rate_type == "travel" && $extra['ac_extra_cat_ind'] == DB_AC_EXTRA_CAT_TRAVEL)
						|| ($rf_tax_rate_type == "accomm-extra" && $extra['ac_extra_cat_ind'] == DB_AC_EXTRA_CAT_ACCOMMODATION)
					)
				) {
					$total += $extra['rv_extra_amt_tax'];
				}
			}
		}
	}
	return $total;
}

function getCommRecTotal($folios) {
	$total = 0;
	foreach($folios as $folio) {
		foreach($folio['extras'] as $extra) {
			$total += round($extra['rv_extra_amt_gross'] * $extra['rv_extra_comm_rec'] / 100,2);
		}
	}
	fixAmtDisplay($total,2);
	return $total;
}


function getCommPayTotal($folios,$type=false) {
	$total = 0;
	foreach($folios as $folio) {
		if($type === false || $type == "itinerary") {
			foreach($folio['itineraries'] as $itinerary) {
				$total += $itinerary['rv_item_amt_comm'];
			}
		}
		if($type === false || $type != "itinerary") {
			foreach($folio['extras'] as $extra) {
				$total += $extra['rv_extra_amt_comm'];
			}
		}
	}
	return $total;
}

function getPaymentTotal($folios,$rf_bank_id=false) {
	$total = 0;
	foreach($folios as $folio) {
		foreach($folio['payments'] as $payment) {
			if($rf_bank_id === false || $rf_bank_id == $payment['rf_bank_ix']) {
				$total += $payment['rv_payment_item_amt'];
			}
		}
	}
	return $total;
}

function getFolioOutstanding($folios) {
	$total = 0;
	foreach($folios as $folio) {
		$total += $folio['fn_folio_amount'] - $folio['fn_folio_amt_paid'];
	}
	return $total;
}

function getReservationOutstanding($items,$rf_currency_id) {
	global $lDB;

	$currencyWhere = "";
	if(!empty($rf_currency_id)) {
		$currencyWhere = " AND fn_folio.rf_currency_id = '$rf_currency_id' ";
	}

	return $lDB->get("
		SELECT
			SUM(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid)			
		FROM
			fn_folio
		WHERE
			fn_folio.rv_reservation_id IN ('".join("','",array_keys($items))."')
			$currencyWhere
	",4);
}

function getSpecials($resId = "") {
	global $lDB;

	if (empty($resId)) {
		return "";
	}

	$specials = $lDB->get("
		SELECT
			sp_special.sp_special_desc
		FROM
			rv_special
			LEFT JOIN sp_special ON sp_special.sp_special_ix = rv_special.sp_special_id
		WHERE
			rv_special.rv_reservation_id = '" . $resId . "'
	",3);

	return join(', ', $specials);	
}

function compareSort($a,$b) {
	if($a['sort'] == $b['sort']) {
		return 0;
	}

	return ($a['sort'] < $b['sort']) ? -1 : 1;
}

function compareData($a,$b) {
	global $report;

	foreach($report->Sort as $field=>$sort) {
		$fieldA = $a[$field];
		$fieldB = $b[$field];
		if(array_key_exists($field . '_sort',$a)) {
			$fieldA = $a[$field . '_sort'];
		}
		if(array_key_exists($field . '_sort',$b)) {
			$fieldB = $b[$field . '_sort'];
		}
		switch($sort['sortType']) {
		case "ix":
			$ixSplitA = preg_split('/(?<!\d)(?=\d+)/', $fieldA);
			$dbCodeA = $ixSplitA[0];
			$idA = $ixSplitA[1];
			$ixSplitB = preg_split('/(?<!\d)(?=\d+)/', $fieldB);
			$dbCodeB = $ixSplitB[0];
			$idB = $ixSplitB[1];
			if($dbCodeA == $dbCodeB) {
				if(
					($sort['direction'] == "a" && ($idA < $idB))
					|| ($sort['direction'] == "d" && ($idA > $idB))
				) {
					return -1;
				}
				if(
					($sort['direction'] == "a" && ($idA > $idB))
					|| ($sort['direction'] == "d" && ($idA < $idB))
				) {
					return 1;
				}
			}
		default:
			if(
				($sort['direction'] == "a" && $fieldA < $fieldB)
				|| ($sort['direction'] == "d" && $fieldA > $fieldB)
			) {
				return -1;
			}
			if(
				($sort['direction'] == "a" && $fieldA > $fieldB)
				|| ($sort['direction'] == "d" && $fieldA < $fieldB)
			) {
				return 1;
			}
			break;
		}
	}
	return 0;
}

function headerSort($a,$b) {
	if(is_array($a)) {
		foreach($a as $key=>$item) {
			if($a[$key] < $b[$key]) {
				return -1;
			}
			if($a[$key] > $b[$key]) {
				return 1;
			}
		}
		return 0;
	} else {
		if($a == $b) { return 0; }
		return ($a < $b) ? -1 : 1;
	}
}

function getOperatorFilterText($operator) {
	switch($operator) {
	case "<":
		$text = "is less than";
		break;
	case "<=":
		$text = "is less than or equal to";
		break;
	case "=":
		$text = "is equal to";
		break;
	case ">=":
		$text = "is more than or equal to";
		break;
	case ">":
		$text = "is more than";
	}
	return $text;
}

function getOperatorComparison($operator,$value,$value2) {
	switch($operator) {
	case "<":
		$result = $value < $value2;
		break;
	case "<=":
		$result = $value <= $value2;
		break;
	case "=":
		$result = $value == $value2;
		break;
	case ">=":
		$result = $value >= $value2;
		break;
	case ">":
		$result = $value > $value2;
		break;
	}
	return $result;
}
