<?php

class FinancialAnalysisDayReport extends FinancialAnalysisReport {

	function Config() {
		parent::Config();

		$commissionLabel = commissionLabel();
		$this->Fields = array(
			/* BEGIN - Group Fields */
			array('name'=>"key_items",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix AS key_item_id"),'group'=>"complex",'group_function'=>"resArray"),
			//array('name'=>"fn_folio.fn_folio_ix",'type'=>"string",'fields'=>array("fn_folio.fn_folio_ix"),'group'=>"complex",'group_function'=>"folioArray"),
			array('name'=>"rv_reservation_item.ac_accomm_type_name",'type'=>"string",'fields'=>array("ac_accomm_type.ac_accomm_desc"),'key'=>"ac_accomm_type.ac_accomm_type_ix AS ac_accomm_type_name_key"),
			array('name'=>"rv_reservation.rv_agent_name",'type'=>"complex",'fields'=>"agent_persona.pr_name_last AS agent_name_last",'key'=>"agent_persona.pr_persona_ix AS rv_agent_name_key",'function'=>"formatAgentName"),
			array('name'=>"rv_reservation.rv_agent_email",'type'=>"complex",'fields'=>"agent_persona.pr_email AS agent_email",'key'=>"agent_persona.pr_persona_ix AS rv_agent_email_key",'function'=>"getAgentEmail"),
			array('name'=>"agent_persona.pr_postal_country",'type'=>"complex",'fields'=>array("IFNULL(agent_linked_persona.pr_corr_country_id, agent_persona.pr_corr_country_id) AS agent_corr_country"),'function'=>"getCountry",'key'=>"IFNULL(agent_linked_persona.pr_corr_country_id, agent_persona.pr_corr_country_id) AS agent_corr_country", 'key_function'=>'getCountryKey'),
			array('name'=>"agent_persona.pr_physical_country",'type'=>"complex",'fields'=>array("IFNULL(agent_linked_persona.pr_phys_country_id, agent_persona.pr_phys_country_id) AS agent_phys_country"),'function'=>"getCountry",'key'=>"IFNULL(agent_linked_persona.pr_phys_country_id, agent_persona.pr_phys_country_id) AS agent_phys_country", 'key_function'=>'getCountryKey'),
			array('name'=>"pr_agent.pr_agent_commission_perc",'type'=>"complex",'fields'=>array("pr_agent.pr_agent_commission_perc"),'function'=>"formatCommPerc",'key'=>"pr_agent.pr_agent_commission_perc"),
			array('name'=>"rv_reservation.rv_consultant_name",'type'=>"complex",'fields'=>array("consultant_persona.pr_name_first AS consultant_name_first","consultant_persona.pr_name_last AS consultant_name_last"),'function'=>"getConsultantName",'key'=>"rv_reservation.rv_consultant_id"),
			array('name'=>"rv_reservation.rv_corr_persona_name",'type'=>"complex",'fields'=>array("contact_persona.pr_name_first AS contact_name_first","contact_persona.pr_name_last AS contact_name_last"),'function'=>"getContactName",'key'=>"rv_reservation.rv_corr_persona_id"),
			array('name'=>"rv_reservation.rv_corr_persona_email",'type'=>"complex",'fields'=>array("contact_persona.pr_email"),'function'=>"getContactEmail",'key'=>"rv_reservation.rv_corr_persona_id"),
			array('name'=>"rv_reservation.rv_date_recorded",'type'=>"date",'fields'=>array("rv_reservation.rv_date_recorded"),'key'=>"rv_reservation.rv_date_recorded"),
			array('name'=>"rv_reservation.rv_date_recorded_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_recorded"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_recorded",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rv_date_recorded_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_recorded"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_recorded",'key_function'=>"getYearKey"),
			array('name'=>"fn_folio.fn_folio_db",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_db"),'function'=>"getFolioDB",'key'=>"fn_folio.fn_folio_db",'key_function'=>"getFolioDBKey"),
			array('name'=>"fn_folio.fn_folio_date_month",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_date"),'function'=>"getMonth",'key'=>"fn_folio.fn_folio_date",'key_function'=>"getMonthKey"),
			array('name'=>"fn_folio.fn_folio_date_year",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_date"),'function'=>"getYear",'key'=>"fn_folio.fn_folio_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_country_name",'type'=>"complex",'fields'=>array("rv_reservation.rf_country_id"),'function'=>"getCountry",'key'=>"rv_reservation.rf_country_id", 'key_function'=>'getCountryKey'),
			array('name'=>"rv_reservation.rv_origin_agent_name",'type'=>"complex",'fields'=>array("originator_persona.pr_name_first AS originator_name_first","originator_persona.pr_name_last AS originator_name_last"),'function'=>"getOriginatorName",'key'=>"CASE WHEN rv_reservation.rv_origin_agent_id = '' or rv_reservation.rv_origin_agent_id = '0' THEN '' ELSE rv_reservation.rv_origin_agent_id END AS rv_origin_agent_id"),
			array('name'=>"rv_reservation.rv_origin_agent_email",'type'=>"complex",'fields'=>array("originator_persona.pr_email AS originator_email"),'function'=>"getOriginatorEmail",'key'=>"CASE WHEN rv_reservation.rv_origin_agent_id = '' or rv_reservation.rv_origin_agent_id = '0' THEN '' ELSE rv_reservation.rv_origin_agent_id END AS rv_origin_agent_id"),
			array('name'=>"originator_persona.pr_postal_country",'type'=>"complex",'fields'=>array("IFNULL(originator_linked_persona.pr_corr_country_id, originator_persona.pr_corr_country_id) AS originator_corr_country"),'function'=>"getCountry",'key'=>"IFNULL(originator_linked_persona.pr_corr_country_id, originator_persona.pr_corr_country_id) AS originator_corr_country", 'key_function'=>'getCountryKey'),
			array('name'=>"originator_persona.pr_physical_country",'type'=>"complex",'fields'=>array("IFNULL(originator_linked_persona.pr_phys_country_id, originator_persona.pr_phys_country_id) AS originator_phys_country"),'function'=>"getCountry",'key'=>"IFNULL(originator_linked_persona.pr_phys_country_id, originator_persona.pr_phys_country_id) AS originator_phys_country", 'key_function'=>'getCountryKey'),
			array('name'=>"rv_reservation_item.pr_business_name",'type'=>"string",'fields'=>array("property_persona.pr_name_last AS property_name_last"),'key'=>"property_persona.pr_persona_ix"),
			array('name'=>"rv_reservation.rt_rate_type_name",'type'=>"string",'fields'=>array("rt_rate_type.rt_rate_type_desc"),'key'=>"rv_reservation.rt_rate_type_id"),
			array('name'=>"rv_reservation_item.rt_rate_type_name",'type'=>"string",'fields'=>array("rt_rate_type_item.rt_rate_type_desc AS rt_rate_type_desc_item"),'key'=>"rv_reservation_item.rt_rate_type_id"),
			array('name'=>"rv_reservation.rf_source_name",'type'=>"complex",'fields'=>array("rf_source.rf_source_desc"),'function'=>"getSourceName",'key'=>"rv_reservation.rf_source_ix"),
			array('name'=>"rv_reservation.rf_reservation_status_name",'type'=>"string",'fields'=>array("rf_reservation_status.rf_reservation_status_desc"),'key'=>"rv_reservation.rf_reservation_status_id"),
			array('name'=>"rv_reservation.rv_res_name",'type'=>"string",'fields'=>array("rv_reservation.rv_res_name"),'key'=>"rv_reservation.rv_reservation_ix AS rv_res_name_key"),
			array('name'=>"rv_reservation.rv_reservation_ix",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix"),'key'=>"rv_reservation.rv_reservation_ix AS rv_reservation_ix_key"),
			array('name'=>"rv_reservation.rv_agent_ref",'type'=>"string",'fields'=>array("rv_reservation.rv_agent_ref"),'key'=>"rv_reservation.rv_reservation_ix"),
			array('name'=>"rv_reservation.rf_reservation_status_date",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusDate",'key'=>"rv_reservation.rv_reservation_ix","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),
			array('name'=>"rv_reservation.rf_reservation_status_month",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusMonth",'key'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'key_function'=>"getStatusMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_year",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusYear",'key'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'key_function'=>"getStatusYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_date",'type'=>"date",'fields'=>array("rv_reservation.rv_cancel_date"),'key'=>"rv_reservation.rv_cancel_date"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_cancel_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_cancel_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_cancel_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_cancel_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_date",'type'=>"date",'fields'=>array("rv_reservation.rv_confirmation_date"),'key'=>"rv_reservation.rv_confirmation_date"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_confirmation_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_confirmation_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_confirmation_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_confirmation_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_date",'type'=>"date",'fields'=>array("rv_reservation.rv_date_deleted"),'key'=>"rv_reservation.rv_date_deleted"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_deleted"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_deleted",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_deleted"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_deleted",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_date",'type'=>"date",'fields'=>array("rv_reservation.rv_prov_date"),'key'=>"rv_reservation.rv_prov_date"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_prov_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_prov_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_prov_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_prov_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_date",'type'=>"date",'fields'=>array("rv_reservation.rv_date_quote"),'key'=>"rv_reservation.rv_date_quote"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_quote"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_quote",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_quote"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_quote",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_date",'type'=>"date",'fields'=>array("rv_reservation.rv_wait_list_date"),'key'=>"rv_reservation.rv_wait_list_date"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_wait_list_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_wait_list_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_wait_list_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_wait_list_date",'key_function'=>"getYearKey"),			
			array('name'=>"fn_folio.rf_currency_symbol",'type'=>"string",'fields'=>array("rf_currency.rf_currency_symbol"),'key'=>"fn_folio.rf_currency_id"),
			array('name'=>"rv_reservation.ac_pay_plan_desc",'type'=>"string",'fields'=>array("ac_pay_plan.ac_pay_plan_desc"),'key'=>"rv_reservation.ac_pay_plan_id"),
			array('name'=>"rv_reservation_item.rv_item_date_arrive",'type'=>"data",'fields'=>array("rv_reservation_item.rv_item_date_arrive"),'key'=>"rv_reservation_item.rv_item_date_arrive"),
			array('name'=>"rv_reservation_item.rv_item_date_depart",'type'=>"data",'fields'=>array("rv_reservation_item.rv_item_date_depart"),'key'=>"rv_reservation_item.rv_item_date_depart"),
			array('name'=>"rv_reservation.rv_date_day",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'function'=>"getTravelDays",'key'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'key_function'=>"getTravelDayKeys"),
			array('name'=>"rv_reservation.rv_date_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'function'=>"getTravelMonths",'key'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'key_function'=>"getTravelMonthKeys"),
			array('name'=>"rv_reservation.rv_date_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'function'=>"getTravelYears",'key'=>array("rv_reservation.rv_date_arrive","rv_reservation.rv_date_depart"),'key_function'=>"getTravelYearKeys"),
            array('name'=>"rv_reservation.rv_cancel_reason",'type'=>"string",'fields'=>array("rv_reservation.rv_cancel_reason"),'key'=>"rv_reservation.rv_reservation_ix"),
			array('name'=>"rv_reservation_item.allocation_drawdown",'type'=>"complex",'fields'=>array("rv_reservation_item.rv_reservation_item_ix"),'function'=>"getDrawdown",'key'=>"rv_reservation_item.rv_reservation_item_ix",'key_function'=>"getDrawdownKey"),
			/* END - Group Fields */

			/* START - Detail Fields */
			array('name'=>"rv_reservation_item.rv_item_accomm_count",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count")),
			array('name'=>"rv_reservation_item.pax",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")),
			array('name'=>"rv_reservation_item.room_nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights")),
			array('name'=>"rv_reservation_item.bed_nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")),
			array('name'=>"rv_reservation.count",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix")),
			array('name'=>"rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix",'type'=>"string",'fields'=>array("rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix")),
			array('name'=>"rv_res_item_comp.rv_res_item_comp_ix",'type'=>"string",'fields'=>array("rv_res_item_comp.rv_res_item_comp_ix")),
			array('name'=>"rv_reservation_item.rv_reservation_item_ix",'type'=>"string",'fields'=>array("rv_reservation_item.rv_reservation_item_ix")),
			array('name'=>"rv_reservation_item.pr_business_id",'type'=>"string",'fields'=>array("rv_reservation_item.pr_business_id")),
			array('name'=>"rv_reservation_item.ac_accomm_type_id",'type'=>"string",'fields'=>array("rv_reservation_item.ac_accomm_type_id")),
			/* END - Detail Fields */
		);		

		$this->Joins['res'] = array(
			array('table'=>"rv_reservation"),
			array('table'=>"rv_reservation_item",'type'=>"INNER",'on'=>"rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id",'requires'=>"rv_reservation_item"),
			array('table'=>"pr_persona",'alias'=>"agent_linked_persona",'type'=>"LEFT",'on'=>"agent_linked_persona.pr_persona_ix = agent_persona.pr_persona_link_id",'requires'=>'agent_persona'),
			array('table'=>"pr_persona",'alias'=>"agent_persona",'type'=>"LEFT",'on'=>"agent_persona.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation", 'includes'=>'agent_linked_persona'),
			array('table'=>"pr_agent",'type'=>"LEFT",'on'=>"pr_agent.pr_agent_id = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"consultant_persona",'type'=>"LEFT",'on'=>"consultant_persona.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"contact_persona",'type'=>"LEFT",'on'=>"contact_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"originator_linked_persona",'type'=>"LEFT",'on'=>"originator_linked_persona.pr_persona_ix = originator_persona.pr_persona_link_id", 'requires'=>'originator_persona'),
			array('table'=>"pr_persona",'alias'=>"originator_persona",'type'=>"LEFT",'on'=>"originator_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation", 'includes' => 'originator_linked_persona'),
			array('table'=>"pr_persona",'alias'=>"property_persona",'type'=>"INNER",'on'=>"property_persona.pr_persona_ix = rv_reservation_item.pr_business_id",'requires'=>"rv_reservation_item"),
			array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation"),
			array('table'=>"rt_rate_type",'alias'=>"rt_rate_type_item",'type'=>"INNER",'on'=>"rt_rate_type_item.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation_item"),
			array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
			array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
			array('table'=>"fn_folio",'type'=>"LEFT",'on'=>"fn_folio.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"rf_currency",'type'=>"LEFT",'on'=>"rf_currency.rf_currency_ix = fn_folio.rf_currency_id",'requires'=>"fn_folio"),
			array('table'=>"ac_pay_plan",'type'=>"LEFT",'on'=>"ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id",'requires'=>"rv_reservation"),
		);

		$this->AddParams(array(
			new ReportParamHeading("Filter options"),
			new ReportParamFilterDateRange("travelDateRange","Travel date range"),
			new ReportParamFilter("accomm"),
			new ReportParamFilterCheckArea("extraDateCheck","Extras service date range",array(
				new ReportParamFilterDateRange("extraDateRange",false)
			)),
			new ReportParamFilterCheckArea("paymentDateCheck","Payment date range",array(
				new ReportParamFilterDateRange("paymentDateRange",false)
			)),
			new ReportParamSection("reservation","Res filters",array(
				new ReportParamFilterCheckArea("createDateCheck","Create date range",array(
					new ReportParamFilterDateRange("createDateRange",false)
				)),
				new ReportParamFilterCheckArea("statusDateCheck","Status date range",array(
					new ReportParamFilterDateRangeStatus("statusDateRange",false)
				)),
				new ReportParamFilter("status",false,"30"),
				new ReportParamFilterCheck("excludeExpiredProv","Exclude expired provisionals"),
				new ReportParamFilterText("resNameNumberVoucher", "Keyword filter", false, array('placeholderText'=>"Reservation Name, Reservation Number, Voucher Reference or Cancel Reason",'width'=>"585px",'overlib'=>"Filter results by keywords found in Reservation Name, Reservation Number, Voucher Reference or Cancel Reason")),
				new ReportParamHeading("Set Agent filters"),
				new ReportParamFilter("agent"),
				new ReportParamFilter("agentPostCountry"),
				new ReportParamFilter("agentPhysCountry"),
				new ReportParamEmpty(),
				new ReportParamHeading("Set Originator filters"),
				new ReportParamFilter("originator"),
				new ReportParamFilter("originatorPostCountry"),
				new ReportParamFilter("originatorPhysCountry"),
				new ReportParamEmpty(),
				new ReportParamFilter("createdBy"),
				new ReportParamFilter("consultant"),
				new ReportParamFilter("nationality"),			
				new ReportParamFilter("source"),
				new ReportParamFilter("paymentPlan"),
				new ReportParamFilter("rate"),
				new ReportParamFilterCheckArea("balanceCheck","Filter by amount owing",array(
					new ReportParamFilterCheck("balanceTBACheck","TBA"),
					new ReportParamFilterCheck("balanceUnpaidCheck","Unpaid"),
					new ReportParamFilterCheck("balancePartPaidCheck","Part paid"),
					new ReportParamFilterCheck("balancePaidCheck","Fully paid"),
					new ReportParamFilterCheck("balanceOverpaidCheck","Overpaid"),
					new ReportParamEmpty(),
					new ReportParamFilterCheckDiffersBy("balanceOwingByCheck","Owing"),
					new ReportParamFilterCheckDiffersBy("balanceOverpaidByCheck","Overpaid by")
				)),
				new ReportParamFilterCheckArea("allocationCheck","Allocation drawdown",array(
					new ReportParamHeading("Include itineraries with:"),
					new ReportParamFilterCheck("allocationDrawdownCheck","Allocation drawdown"),
					new ReportParamFilterCheck("allocationBlockDrawdownCheck","Block allocation drawdown"),
					new ReportParamFilterCheck("allocationNoDrawdownCheck","No drawdown")
				)),
				new ReportParamFilterText("allocationFilter", "Allocation filter", false, array('placeholderText'=>"Allocation name or number",'width'=>"585px",'overlib'=>"Filter results by keywords found in drawn down allocation name or number")),
			)),

			new ReportParamSection("revenue","Revenue filters",array(
				new ReportParamFilter("currencies"),
				new ReportParamFilter("rate","rateAccomm",false,array('label'=>"Rate type acc")),
				new ReportParamFilter("rateGroupSplit"),
				new ReportParamFilter("rateComponent"),
				new ReportParamFilter("extraCategory"),
				new ReportParamFilterExtra(),
				new ReportParamFilterCheckArea("extraPropertyCheck","Filter extras by property",array(
					new ReportParamFilterCheck("extraNonPropertyCheck","Include non-property-specific extras")
				))
			)),
			new ReportParamEmpty(),
			new ReportParamHeading("Output options"),
			new ReportParamSection("dataOptions","Select data",array(
				new ReportParamBuilder("grouping","Group",array(
					array('name'=>"rv_reservation_item.ac_accomm_type_name", 'label'=>"Accommodation type",'width'=>"100"),
					array('name'=>"rv_reservation.rv_agent_name", 'label'=>"Agent",'width'=>"100"),
					array('name'=>"rv_reservation.rv_agent_email", 'label'=>"Agent email",'width'=>"100"),
					array('name'=>"pr_agent.pr_agent_commission_perc", 'label'=>"Agent " . $commissionLabel . " %",'width'=>"100"),
					array('name'=>"agent_persona.pr_postal_country", 'label'=>"Agent postal country",'width'=>"100"),
					array('name'=>"agent_persona.pr_physical_country", 'label'=>"Agent physical country",'width'=>"100"),
					array('name'=>"rv_reservation_item.allocation_drawdown", 'label'=>"Allocation drawdown", 'width'=>"70"),
					array('name'=>"rv_reservation_item.rv_item_date_arrive", 'label'=>"Arrival date",'format'=>'date','exclude_zero_check'=>true,'width'=>"70"),
					array('name'=>"rv_reservation.rv_consultant_name", 'label'=>"Consultant",'width'=>"100"),
					array('name'=>"rv_reservation.rv_corr_persona_name", 'label'=>"Contact",'width'=>"100"),
					array('name'=>"rv_reservation.rv_corr_persona_email", 'label'=>"Contact email",'width'=>"100"),
					array('name'=>"rv_reservation.rv_date_recorded", 'label'=>"Create date",'width'=>"70"),
					array('name'=>"rv_reservation.rv_date_recorded_month", 'label'=>"Create month",'width'=>"70"),
					array('name'=>"rv_reservation.rv_date_recorded_year", 'label'=>"Create year",'width'=>"70"),
					array('name'=>"rv_reservation_item.rv_item_date_depart", 'label'=>"Departure date",'format'=>'date','exclude_zero_check'=>true,'width'=>"70"),
					/*array('name'=>"fn_folio.fn_folio_db", 'label'=>"Environment (Folio)",'width'=>"100"),*/
					array('name'=>"fn_folio.rf_currency_symbol", 'label'=>"Folio currency",'width'=>"50"),
					/* Disabled due to user confusion */
					//array('name'=>"fn_folio.fn_folio_date_month", 'label'=>"Folio month",'width'=>"50"),
					//array('name'=>"fn_folio.fn_folio_date_year", 'label'=>"Folio year",'width'=>"50"),
					array('name'=>"rv_reservation.rf_country_name", 'label'=>"Nationality",'width'=>"100"),
					array('name'=>"rv_reservation.rv_origin_agent_name", 'label'=>"Originator",'width'=>"100"),
					array('name'=>"rv_reservation.rv_origin_agent_email", 'label'=>"Originator email",'width'=>"100"),
					array('name'=>"originator_persona.pr_postal_country", 'label'=>"Originator postal country",'width'=>"100"),
					array('name'=>"originator_persona.pr_physical_country", 'label'=>"Originator physical country",'width'=>"100"),
					array('name'=>"rv_reservation.ac_pay_plan_desc", 'label'=>"Payment plan",'width'=>"100"),
					array('name'=>"rv_reservation_item.pr_business_name", 'label'=>"Property",'width'=>"100"),
					array('name'=>"rv_reservation.rt_rate_type_name", 'label'=>"Rate type (Reservation)",'width'=>"100"),
					array('name'=>"rv_reservation_item.rt_rate_type_name", 'label'=>"Rate type (Itinerary)",'width'=>"100"),
					array('name'=>"rv_reservation.rv_res_name", 'label'=>"Reservation name",'width'=>"100"),
					array('name'=>"rv_reservation.rv_reservation_ix", 'label'=>"Reservation #",'width'=>"100",'sortType'=>"ix"),
					array('name'=>"rv_reservation.rf_source_name", 'label'=>"Source",'width'=>"100"),
					array('name'=>"rv_reservation.rf_reservation_status_name", 'label'=>"Status",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_date", 'label'=>"Status date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_month", 'label'=>"Status month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_year", 'label'=>"Status year",'width'=>"70"),					
					array('name'=>"rv_reservation.rf_reservation_status_cancel_date", 'label'=>"Status cancel date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_cancel_month", 'label'=>"Status cancel month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_cancel_year", 'label'=>"Status cancel year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_date", 'label'=>"Status confirm date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_month", 'label'=>"Status confirm month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_year", 'label'=>"Status confirm year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_date", 'label'=>"Status delete date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_month", 'label'=>"Status delete month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_year", 'label'=>"Status delete year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_date", 'label'=>"Status provisional date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_month", 'label'=>"Status provisional month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_year", 'label'=>"Status provisional year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_date", 'label'=>"Status quote date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_month", 'label'=>"Status quote month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_year", 'label'=>"Status quote year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_date", 'label'=>"Status wait list date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_month", 'label'=>"Status wait list month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_year", 'label'=>"Status wait list year",'width'=>"70"),
					/* Travel day does work but is disabled due to possible confusion caused by missing days.
					 * Days go missing due to the days being generated based on actual days used.
					 * This means that days without any data are left out.
					 */
					//array('name'=>"rv_reservation.rv_date_day", 'label'=>"Travel day", 'width'=>"50"),
					array('name'=>"rv_reservation.rv_date_month", 'label'=>"Travel month", 'width'=>"50"),
					array('name'=>"rv_reservation.rv_date_year", 'label'=>"Travel year", 'width'=>"50"),
					array('name'=>"rv_reservation.rv_agent_ref", 'label'=>"Voucher reference",'width'=>"100"),
                    array('name'=>"rv_reservation.rv_cancel_reason",'label'=>"Cancellation reason",'width'=>"70"),
				),false,false,array('availableWidth'=>"175")),
				new ReportParamBuilder("display","Fields",array(
					array('name'=>"rv_reservation_item.allocation_id", 'label'=>"Allocation #", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.allocation_name", 'label'=>"Allocation name", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.rv_item_date_arrive",'label'=>"Arrival date",'format'=>"date",'width'=>"70",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_bed_nights_per_res", 'label'=>"Average bed nights per reservation",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_length_of_stay", 'label'=>"Average length of stay",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_room_nights_per_res", 'label'=>"Average room nights per reservation",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.bed_nights", 'label'=>"Bed nights",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.bed_nights_perc_total", 'label'=>"BN % of actual / report total",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.bed_nights_perc_row_potential", 'label'=>"BN % of potential / group / period",'format'=>"percent",'total'=>"hidden",'width'=>"50",'align'=>"r",'buildPotential'=>true, 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.bed_nights_perc_total_potential", 'label'=>"BN % of potential / period total",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden",'buildPotential'=>true, 'buildPotentialTotal'=>true, 'requirements'=>array('itineraries')),
					array('name'=>"bl_block.bl_block_id", 'label'=>"Block #", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"bl_block.bl_block_name", 'label'=>"Block name", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"commission_rec_extra",'label'=>$commissionLabel . " receivable extras",'format'=>"amount",'width'=>"80",'align'=>"r",'requirements'=>array('extras')),
					array('name'=>"commission_pay_accomm",'label'=>$commissionLabel . " payable accommodation",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"commission_pay_extra",'label'=>$commissionLabel . " payable extras",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('extras')),
					array('name'=>"commission_pay",'label'=>$commissionLabel . " payable total",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.rv_item_date_depart",'label'=>"Departure date",'format'=>"date",'width'=>"70",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.pax", 'label'=>"PAX",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"payments",'label'=>"Payments",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('payments')),
					array('name'=>"potential_room_nights", 'label'=>"Potential room nights",'format'=>"integer",'width'=>"50",'align'=>"r",'buildPotential'=>true, 'requirements'=>array()),
					array('name'=>"potential_bed_nights", 'label'=>"Potential bed nights",'format'=>"integer",'width'=>"50",'align'=>"r",'buildPotential'=>true, 'requirements'=>array()),
					array('name'=>"balance_report",'label'=>"Report balance",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itinerary')),
					array('name'=>"rv_reservation.count", 'label'=>"Reservation count",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"accommodation", 'label'=>"Revenue Accommodation",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"extras",'label'=>"Revenue Extras",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('extras')),
					array('name'=>"tax",'label'=>"Revenue Tax",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"total",'label'=>"Revenue Total",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"revpar_on_accomm",'label'=>"RevPAR on accomm",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden",'buildPotential'=>true,'requirements'=>array('itineraries')),
					array('name'=>"revpar_on_total",'label'=>"RevPAR on accomm and extras",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden",'buildPotential'=>true,'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.rv_item_accomm_count", 'label'=>"Rooms",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.room_nights", 'label'=>"Room nights",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.room_nights_perc_total", 'label'=>"RN % of actual / report total",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.room_nights_perc_row_potential", 'label'=>"RN % of potential / group / period",'format'=>"percent",'total'=>"hidden",'width'=>"50",'align'=>"r",'buildPotential'=>true, 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.room_nights_perc_total_potential", 'label'=>"RN % of potential / period total",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden",'buildPotential'=>true,'buildPotentialTotal'=>true, 'requirements'=>array('itineraries')),
					array('name'=>"balance_res",'label'=>"Total amount outstanding",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('folios')),
					array('name'=>"yield_on_total_per_bed_night",'label'=>"Yield on accomm and extras per bed night",'format'=>"amount",'width'=>"80",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_total_per_room_night",'label'=>"Yield on accomm and extras per room night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_accomm_per_bed_night",'label'=>"Yield on accomm per bed night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_accomm_per_room_night",'label'=>"Yield on accomm per room night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"rv_reservation.count_perc", 'label'=>"% of reservation count",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('reservation')),
					array('name'=>"rv_reservation_item.room_nights_perc", 'label'=>"% of room nights",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"specials", 'label'=>"Specials",'format'=>"",'width'=>"150",'align'=>"l",'buildPotential'=>true, 'requirements'=>array())
				),false,false,array('availableWidth'=>"175")),				
			),false,array('filterLabelWidth'=>"40")),
			new ReportParamSection("revenueOptions","Financial details",array(
				new ReportParamFilterSelect("commission",$commissionLabel,array(
					'nett'=>"Nett",
					'gross'=>"Gross",
					'payable'=>"Payable"
				),"payable",array('width'=>"150px")),
				new ReportParamFilterCheck("includeTax","Include tax in revenue"),
				new ReportParamFilterCheck("splitRateGroup","Split rate groups for occupancy"),
				new ReportParamFilterSelect("splitAccomm","Split accommodation",array(
					'total'=>"Total",
					'property'=>"Property",
					'component'=>"Component",
					'rateGroup'=>"Rate group",
					'componentRateGroup'=>"Component then rate group",
					'rateGroupComponent'=>"Rate group then component"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitExtra","Split extras",array(
					'total'=>"Total",
					'category'=>"Categories",
					'extra'=>"Extras",
					'categoryExtra'=>"Category then extra",
					'type'=>"Type",
					'typeCategory'=>"Type then category",
					'typeExtra'=>"Type then extra"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitTax","Split taxes",array(
					'total'=>"Total",
					'tax'=>"Tax rate",
					'revenueType'=>"Revenue type",
					'taxRevenueType'=>"Tax rate then revenue type"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitPayment","Split payments",array(
					'total'=>"Total",
					'bank'=>"Bank and cash point"
				),false,array('width'=>"150px")),

			),false,array('filterLabelWidth'=>"100")),
			new ReportParamSection("outputOptions","Display options",array(				
				new ReportParamFilterRadioGroup("outputAxis","Orientation",array(
					FINANCIAL_ANALYSIS_ROW_PER_GROUP=>"Groups as rows (horizontal)",
					FINANCIAL_ANALYSIS_ROW_PER_PERIOD=>"Groups as columns (vertical)"
				),FINANCIAL_ANALYSIS_ROW_PER_GROUP,array('width'=>"560px")),
				new ReportParamFilterCheckArea("dayTotal","Include totals per day", array(
					new ReportParamFilterSelect("dayTotalFormat","Format",array(
						FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_WEEK=>"DD (eg. Mo)",
						FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_MONTH=>"dd (eg. 28)",
						FINANCIAL_ANALYSIS_PER_DAY_DAY_AND_MONTH=>"dd mmm (eg. 28 Sep)",
						FINANCIAL_ANALYSIS_PER_DAY_FULL=>"dd mmm yyyy (eg. 28 Sep 2015)"
					),FINANCIAL_ANALYSIS_PER_DAY_FULL,array('width'=>"180px")),
				)),
				new ReportParamFilterCheck("monthTotal","Include totals per month"),
				new ReportParamFilterCheck("yearTotal","Include totals per year"),
				new ReportParamFilterCheck("grandTotal","Include group totals",true),
				new ReportParamFilterCheck("includeTotalRows","Include period totals"),
				new ReportParamFilterCheck("includeZeroColumns","Include periods with zero value"),
				new ReportParamFilterCheck("includeZeroRows","Include groups with zero value")
			))
		));

		$this->AddScript("rep_financial_analysis.js");

		$this->AddValidation("checkDateRange(\"PerDay\")");
	}

	function BuildGrouping() {
		$grouping = $this->GetParamValue("grouping");

		// Get fields to group by
		$active = array();
		foreach($grouping as $group) {
			$name = $group['name'];
			if($group['active'] == "1") {
				$active[$name] = $group;
			}
		}
		$groupings = array_keys($active);
		unset($active);

		$this->Level = "res";
		if(in_array("rv_reservation_item.pr_business_name",$groupings)) {
			$this->Level = "property";
		}
		if(in_array("rv_reservation_item.ac_accomm_type_name",$groupings)) {
			$this->Level = "accomm";
		}

		$this->DateGrouping = "none";
		if(in_array("rv_reservation.rv_date_year",$groupings)) {
			$this->DateGrouping = "year";
		}
		if(in_array("rv_reservation.rv_date_month",$groupings)) {
			$this->DateGrouping = "month";
		}
		if(in_array("rv_reservation.rv_date_day",$groupings)) {
			$this->DateGrouping = "day";
		}

		$this->SpecialGrouping = false;

		$this->AllocGrouping = false;
		if(in_array("rv_reservation_item.allocation_drawdown",$groupings)) {
			$this->AllocGrouping = true;
		}

		$defaultFields = array("key_items");

		if($grouping['rv_reservation.rv_reservation_ix']['active'] != 1) {
			$defaultFields[] = "rv_reservation.rv_reservation_ix";
		}

		if($this->Level == "res" || ($this->Level == "accomm" && $grouping['rv_reservation_item.pr_business_name']['active'] != 1)) {
			$defaultFields[] = "rv_reservation_item.pr_business_name";
		}
		
		$sqlBuilder = new ReportSQLBuilder(
			$grouping,
			$this->Fields,
			$this->Joins['res'],
			$defaultFields
		);

		$sql = new ReportSQL();
		$sql->AddFrom("rv_reservation");
		$sql->AddFrom("LEFT JOIN fn_folio ON fn_folio.rv_reservation_id = rv_reservation.rv_reservation_ix");
		$sql->Merge($sqlBuilder->SQL());
        $sql->AddFrom("LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id");
        $sql->AddFrom("LEFT JOIN pr_persona AS originator_persona ON originator_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id");
        $sql->AddFrom("LEFT JOIN pr_persona AS originator_linked_persona ON originator_linked_persona.pr_persona_ix = originator_persona.pr_persona_link_id");
		$sql->AddSelect("rv_reservation.rv_reservation_ix");

		$sql->AddWhere($this->ConcatParamSQL(array(
			"accomm",
			"status",
			"agent",
			"createdBy",
			"consultant",
			"nationality",
			"originator",
			"source",
			"paymentPlan",
			"rate",
			"currencies",
			"agentPhysCountry",
			"agentPostCountry",
			"originatorPhysCountry",
			"originatorPostCountry"
		)));
		
		if($this->GetParamValue("excludeExpiredProv") == "1") {
			$sql->AddWhere("
				AND (
					(
						rv_reservation.rf_reservation_status_id != 20
					) OR (
						rv_reservation.rf_reservation_status_id = 20
						AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
					)
				)
			");
		}

		$travelDateRange = $this->GetParam("travelDateRange");
		$sql->AddWhere($travelDateRange->SQL());
		unset($travelDateRange);

		if($this->GetParamValue("createDateCheck") == "1") {
			$createDateRange = $this->GetParam("createDateRange");
			$sql->AddWhere($createDateRange->SQL("
				AND rv_reservation.rv_date_recorded BETWEEN '!fromDate!' AND '!toDate!'
			"));
			unset($createDateRange);
		}

		$param = $this->GetParam("statusDateCheck");
		if($this->GetParamValue("statusDateCheck") == "1") {
			$statusDateRange = $this->GetParam("statusDateRange");
			$sql->AddWhere($statusDateRange->SQL());
			unset($statusDateRange);
		}

		if($this->GetParamValue("balanceCheck") == "1") {
			$where = array();

			if($this->GetParamValue("balanceTBACheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_accomm_payable IS NULL
					)
				";
			}

			if($this->GetParamValue("balanceUnpaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid = 0
					)
				";
			}

			if($this->GetParamValue("balancePartPaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid != 0
						AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > 0
					)
				";
			}

			if($this->GetParamValue("balancePaidCheck") == "1") {
				$where[] = "
					(
						(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) = 0
					)
				";
			}

			if($this->GetParamValue("balanceOverpaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid != 0
						AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < 0
					)
				";
			}

			list($balanceOwingByCheck,$balanceOwingByType,$balanceOwingByAmount) = array_pad( explode(":",$this->GetParamValue("balanceOwingByCheck")), 3, '' );
			if($balanceOwingByCheck == "1") {
				if(preg_match("/%\s*$/",$balanceOwingByAmount)) {
					$amountSQL = "(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable) * " . str_replace("%","",$balanceOwingByAmount) / 100;
				} else {
					$amountSQL = $balanceOwingByAmount;
				}
				if($balanceOwingByType == "more") {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > $amountSQL
						)		
					";
				} else {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > 0
							AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < $amountSQL
						)
					";
				}
			}

			list($balanceOverpaidByCheck,$balanceOverpaidByType,$balanceOverpaidByAmount) = array_pad( explode(":",$this->GetParamValue("balanceOverpaidByCheck")), 3, '' );
			if($balanceOverpaidByCheck == "1") {
				$balanceOverpaidByAmount *= -1;
				if($balanceOverpaidByType == "more") {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < $balanceOverpaidByAmount
						)		

					";
				} else {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < 0
							AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > $balanceOverpaidByAmount
						)
					";
				}
			}
			
			if(sizeof($where) > 0) {
				$sql->AddWhere(" AND (" . join(" OR ",$where) . ")");
			}
			unset($where);
		}

		if (trim($this->GetParamValue("resNameNumberVoucher")) != "") {
			$sql->AddWhere("
				AND (
					rv_reservation.rv_res_name LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
					OR rv_reservation.rv_reservation_ix LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
					OR rv_reservation.rv_agent_ref LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
					OR rv_reservation.rv_cancel_reason LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
				)
			");
		}

		$data = $sql->Run();

		$sqlBuilder->Render($data,$groupings);

		foreach($data as $key=>$item) {
			if(is_array($item['rv_reservation_item.pr_business_name_key'])) {
				$data[$key]['rv_reservation_item.pr_business_name_key'] = $item['rv_reservation_item.pr_business_name_key'][0];
			}
		}

		/* Remove travel date group overlaps and constrain to the date range */
		if($this->DateGrouping != "none") {
			$travelDateRange = $this->GetParam("travelDateRange");
			$from = $travelDateRange->Filter['fromDate'];
			$fromArray = explode("-",$from);
			$to = $travelDateRange->Filter['toDate'];
			$toArray = explode("-",$to);
			unset($travelDateRange);

			$newData = array();
			foreach($data as $key=>$item) {
				$year = false;
				if(in_array("rv_reservation.rv_date_year",$groupings)) {
					$year = $item['rv_reservation.rv_date_year_key'];
				}

				$month = false;
				if(in_array("rv_reservation.rv_date_month",$groupings)) {
					$month = explode("-",$item['rv_reservation.rv_date_month_key']);
				}

				$day = false;
				if(in_array("rv_reservation.rv_date_day",$groupings)) {
					$day = explode("-",$item['rv_reservation.rv_date_day_key']);
				}

				if(
					$this->DateGrouping == "year"
					&& (
						(
							$year < $fromArray[0]
						) || (
							$year > $toArray[0]
						)
					)
				) {
					continue;
				}

				if(
					$this->DateGrouping == "month"
					&& (
						(
							$year !== false
							&& $year != $month[0]
						) || (
							$item['rv_reservation.rv_date_month_key'] < ($fromArray[0] . "-" . $fromArray[1])
						) || (
							$item['rv_reservation.rv_date_month_key'] > ($toArray[0] . "-" . $toArray[1])
						)
					)
				) {
					continue;
				}

				if(
					$this->DateGrouping == "day"
					&& (
						(
							$year !== false
							&& $year != $day[0]
						) || (
							$month !== false
							&& (
								$month[0] != $day[0]
								|| $month[1] != $day[1]
							)
						) || (
							$item['rv_reservation.rv_date_day_key'] < $from
						) || (
							$item['rv_reservation.rv_date_day_key'] > $to
						)
					)
				) {
					continue;
				}

				$newData[$key] = $item;
			}
			$data = $newData;
			unset($newData);
		}

		$this->GroupColumns = $sqlBuilder->getFields();

		if(
			$this->GetParamValue("extraPropertyCheck") == "1"
			&& $this->GetParamValue("extraNonPropertyCheck") == "1"
			&& ($this->Level == "property" || $this->Level == "accomm")
		) {
			$newData = array();
			$keys = array();
			foreach($data as $key=>$item) {
				$newData[$key] = $item;

				$item['non_property_specific'] = true;
				if(isset($item['rv_reservation_item.pr_business_name_key'])) {
					$item['rv_reservation_item.pr_business_name_key'] = "0";
					$item['rv_reservation_item.pr_business_name'] = "None";
					$item['rv_reservation_item.pr_business_name_sort'] = "";
				}
				if(isset($item['rv_reservation_item.ac_accomm_type_name_key'])) {
					$item['rv_reservation_item.ac_accomm_type_name_key'] = "0";
					$item['rv_reservation_item.ac_accomm_type_name'] = "None";
					$item['rv_reservation_item.ac_accomm_type_name_sort'] = "";
				}
				$keyArray = explode("_",$key);
				$count=0;
				foreach($groupings as $group) {
					if(
						$group == "rv_reservation_item.pr_business_name"
						|| $group == "rv_reservation_item.ac_accomm_type_name"
					) {
						$keyArray[$count] = "0";
					}
					$count++;
				}

				$key = join("_",$keyArray);
				if(!in_array($key,$keys)) {
					$newData[$key] = $item;
					$keys[] = $key;
				} else {
					$newData[$key]['key_items'] = array_merge($newData[$key]['key_items'],$item['key_items']);
				}
			}
			$data = $newData;
			unset($newData);
		}

		$found = false;
		foreach($this->GroupColumns as $col) {
			if(!isset($col['active']) || $col['active'] != "1") { continue; }
			$found = true;
			$this->AddColumn($col['name'],"Grouping",$col,"outLt");
		}
		if(!$found) {
			$this->AddColumn("all","Grouping",array(
				'format'=>"",
				'cols'=>array(
					'label'=>array('value'=>"All"),
					'width'=>array('value'=>"60")
				),
			),"outLt");
			foreach($data as $key=>$item) {
				$data[$key]['all'] = "All";
			}
		}
		$this->Data = $data;

	}

	function ItineraryPerDay($item,$days) {
		$new = $item;
		$new['rv_item_nights'] = $days;
		$new['rv_item_amt'] = $item['rv_item_amt'] / $item['rv_item_nights'] * $days;
		$new['rv_res_item_comp'] = array();
		foreach($item['rv_res_item_comp'] as $id=>$comp) {
			$newComp = $comp;
			foreach($comp['rv_res_item_comp_rate_grp'] as $compRateGrpId=>$compRateGrpItem) {
				$newCompGroup =& $newComp['rv_res_item_comp_rate_grp'][$compRateGrpId];
				$newCompGroup['rv_item_comp_rate_grp_amt_comm'] = $newCompGroup['rv_item_comp_rate_grp_amt_comm'] / $item['rv_item_nights'] * $days;
				$newCompGroup['rv_item_comp_rate_grp_amt_gross'] = $newCompGroup['rv_item_comp_rate_grp_amt_gross'] / $item['rv_item_nights'] * $days;
				$newCompGroup['rv_item_comp_rate_grp_amt_nett'] = $newCompGroup['rv_item_comp_rate_grp_amt_nett'] / $item['rv_item_nights'] * $days;
				$newCompGroup['rv_item_comp_rate_grp_amt_payable'] = $newCompGroup['rv_item_comp_rate_grp_amt_payable'] / $item['rv_item_nights'] * $days;
				$newCompGroup['rv_item_comp_rate_grp_amt_tax'] = $newCompGroup['rv_item_comp_rate_grp_amt_tax'] / $item['rv_item_nights'] * $days;
				unset($newCompGroup);
			}
			foreach($comp['rv_res_item_comp_tax'] as $compTaxId=>$compTaxItem) {
				$newCompTax =& $newComp['rv_res_item_comp_tax'][$compTaxId];
				$newCompTax['rv_res_item_comp_tax_amt'] = $newCompTax['rv_res_item_comp_tax_amt'] / $item['rv_item_nights'] * $days;
				unset($newCompTax);
			}
			$new['rv_res_item_comp'][$id] = $newComp;
		}

		return $new;
	}

	function FilterPerDay($items,$startDate,$endDate,$dateGroup=false) {
		if($dateGroup !== false) {
			$dateGroupArray = explode("-",$dateGroup);
			if(sizeof($dateGroupArray) == 1) { // Year
				$startDateGroup = $dateGroupArray[0] . "-01-01";
				$endDateGroup = $dateGroupArray[0] . "-12-31";
			} elseif(sizeof($dateGroupArray) == 2) { // Month
				$startDateGroup = $dateGroupArray[0] . "-" . $dateGroupArray[1] . "-01";
				$endDateGroup = date("Y-m-d",mktime(0,0,0,$dateGroupArray[1]+1,0,$dateGroupArray[0]));
			} else { // Day
				$startDateGroup = $dateGroup;
				$endDateGroup = $dateGroup;
			}

			if(
				$startDateGroup > $endDate
				|| $endDateGroup < $startDate
			) { // Completely outside the date group range so no need to continue
				return array();
			}

			if($startDate < $startDateGroup) {
				$startDate = $startDateGroup;
			}

			if($endDate > $endDateGroup) {
				$endDate = $endDateGroup;
			}
		}

		$new = array();

		$travelDateRange = $this->GetParam("travelDateRange");
		$travelFromDate = $travelDateRange->Filter['fromDate'];
		$travelToDate = $travelDateRange->Filter['toDate'];
		unset($travelDateRange);

		foreach($items as $id=>$res) {
			$newRes = array(
				'id'=>$id,
				'rv_reservation_id'=>$res['rv_reservation_id'],
				'itineraries'=>array(),
				'extras'=>array(),
				'payments'=>array()
			);
			if(
				(
					$startDate >= $travelFromDate
					&& $startDate <= $travelToDate
				) || (
					$endDate >= $travelFromDate
					&& $endDate <= $travelToDate
				) || (
					$startDate < $travelFromDate
					&& $endDate > $travelToDate
				)		
			) {
				foreach($res['itineraries'] as $itinId=>$itinItem) {
					list($itemEndYear, $itemEndMonth, $itemEndDay) = array_pad( explode("-",$itinItem['rv_item_date_depart']), 3, '' );
					$itemEnd = date("Y-m-d",mktime(0,0,0,$itemEndMonth,$itemEndDay-1,$itemEndYear));
					
					if(
						(
							$itinItem['rv_item_date_arrive'] >= $startDate
							&& $itinItem['rv_item_date_arrive'] <= $endDate
						) || (
							$itinItem['rv_item_date_depart'] >= $startDate
							&& $itinItem['rv_item_date_depart'] <= $endDate
						) || (
							$itinItem['rv_item_date_arrive'] < $startDate
							&& $itinItem['rv_item_date_depart'] > $endDate
						)
					) {
						if($startDate > $itinItem['rv_item_date_arrive']) {
							$finalStart = $startDate;
						} else {
							$finalStart = $itinItem['rv_item_date_arrive'];
						}
						if($endDate < $itinItem['rv_item_date_depart']) {
							$finalEnd = $endDate;
						} else {
							$finalEnd = $itemEnd;
						}
						if($finalStart < $travelFromDate) {
							$finalStart = $travelFromDate;
						}
						if($finalEnd > $travelToDate) {
							$finalEnd = $travelToDate;
						}
						$days = dateSubtract($finalEnd,$finalStart)+1;
						if($itinItem['rv_item_nights'] != 0 && $days != 0) {
							if($days != $itinItem['rv_item_nights']) {
								$itinItem = $this->ItineraryPerDay($itinItem,$days);
								//debug("Was $itinItem[rv_item_nights] but now $days");
							}
							$newRes['itineraries'][] = $itinItem;
							//$revenue = $baseRevenue / $item['rv_item_nights'] * $days;
						}
					}
				}
			}
			foreach($res['extras'] as $extraId=>$extraItem) {
				if($extraItem['rv_extra_date_serv'] >= $startDate && $extraItem['rv_extra_date_serv'] <= $endDate) {
					$newRes['extras'][] = $extraItem;
				}
			}
			foreach($res['payments'] as $paymentId=>$paymentItem) {
				if($paymentItem['rv_pmnt_date'] >= $startDate && $paymentItem['rv_pmnt_date'] <= $endDate) {
					$newRes['payments'][] = $paymentItem;
				}
			}
			if(sizeof($newRes['itineraries']) > 0 || sizeof($newRes['extras']) > 0 || sizeof($newRes['payments']) > 0) {
				$new[$id] = $newRes;
			}
		}

		return $new;
	}

	function BuildPotential() {
		global $lDB;
		$accommFilter = $this->GetParam("accomm");
		$accommList = $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_type.pr_business_id,
				ac_accomm_type.ac_accomm_capacity
			FROM
				ac_accomm_type
			WHERE
				1
				".$accommFilter->SQL("AND ac_accomm_type.ac_accomm_type_ix IN !whereIds!")."
		",6);
		unset($accommFilter);

		$travelDateRange = $this->GetParam("travelDateRange");
		$fromDate = $travelDateRange->Filter['fromDate'];
		$toDate = $travelDateRange->Filter['toDate'];
		unset($travelDateRange);		

		$this->Potential = array();
		foreach($accommList as $item) {
			$ac_accomm_type_id = $item['ac_accomm_type_ix'];
			$this->Potential[$ac_accomm_type_id] = array(
				'ac_accomm_type_id'=>$item['ac_accomm_type_ix'],
				'pr_business_id'=>$item['pr_business_id'],
				'ac_accomm_capacity'=>$item['ac_accomm_capacity'],
				'stock'=>array()
			);
			$stock = new Stock($ac_accomm_type_id,$fromDate,$toDate);
			$rooms = $stock->ToAccomm();
			$blocks = $stock->ToBlock();
			foreach($rooms as $date=>$room) {
				$this->Potential[$ac_accomm_type_id]['stock'][$date] = $room - $blocks[$date];
			}
		}
	}

	function Build() {
		$this->ReservationCountType = "revenue";
		if(
			(
				$this->GetParam("display")->FieldIsActive('rv_reservation.count')
				|| $this->GetParam("display")->FieldIsActive('rv_reservation.count_perc')
			) && !$this->GetParam("display")->FieldHasPropertyValue("requirements", "itineraries")
			&& !$this->GetParam("display")->FieldHasPropertyValue("requirements", "extras")
			&& !$this->GetParam("display")->FieldHasPropertyValue("requirements", "payments")
		) {
			$this->GetParam("display")->FieldSetValue("rv_reservation.count","requirements",array("itineraries", "extras", "payments"));
			$this->GetParam("display")->FieldSetValue("rv_reservation.count_perc","requirements",array("itineraries", "extras", "payments"));
		}

		$this->KeyField = "rv_reservation_id";
		$this->DisplayFilter = "FilterPerDay";
		$this->AmountType = $this->GetParamValue("commission");

		$this->CSVFilters = array(
			"travelDateRange",
		);

		$param = $this->GetParam("extraDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("extraDateRange",$param->Filter['label']);
		}
		unset($param);

		$param = $this->GetParam("paymentDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("paymentDateRange",$param->Filter['label']);
		}
		unset($param);

		$param = $this->GetParam("createDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("createDateRange",$param->Filter['label']);
		}
		unset($param);

		$param = $this->GetParam("statusDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("statusDateRange",$param->Filter['label']);
		}
		unset($param);

		$this->CSVFilters = array_merge($this->CSVFilters,array(
			"status",
			"excludeExpiredProv",
			"agent",
			"createdBy",
			"consultant",
			"nationality",
			"originator",
			"source",
			"paymentPlan",
			"rate",
			"agentPhysCountry",
			"agentPostCountry",
			"originatorPhysCountry",
			"originatorPostCountry"
		));

		$param = $this->GetParam("balanceCheck");
		if($param->Value == "1") {
			$label = $param->Filter['label'];
			$value = array();
			$items = array("balanceTBACheck","balancePaidCheck","balanceOwingByCheck","balanceOverpaidByCheck");
			foreach($items as $item) {
				$param = $this->GetParam($item);
				list($paramValue,$paramDirection,$paramAmount) = array_pad( explode(":",$param->Value), 3, '' );

				if($paramValue == "1") {
					$paramLabel = $param->Filter['label'];
					if(!empty($paramDirection)) {
						$paramLabel .= " $paramDirection than $paramAmount";
					}
					$value[] = $paramLabel;
				}
			}
			$this->CSVFilters[] = array(false,$label,join(", ",$value));
		}
		unset($param);

		$this->CSVFilters = array_merge($this->CSVFilters,array(
			"accomm",
			"extraPropertyCheck",
			"extraNonPropertyCheck",
			"rateGroupSplit",
			"rateComponent",
			"extraCategory",
			"currencies"
		));

		$this->BuildGrouping();
		$this->BuildKeys();
		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "extras")) {
			$this->BuildExtras();
		}
		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "payments")) {
			$this->BuildPayments();
		}


		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "itineraries")) {
			$travelDateRange = $this->GetParam("travelDateRange");
			$this->BuildItineraries($travelDateRange->SQL("
				AND (
					(
						rv_reservation_item.rv_item_date_arrive >= '!fromDate!'
						AND rv_reservation_item.rv_item_date_arrive <= '!toDate!'
					) OR (
						rv_reservation_item.rv_item_date_depart >= '!fromDate!' 
						AND rv_reservation_item.rv_item_date_depart <= '!toDate!'
					) OR (
						rv_reservation_item.rv_item_date_arrive < '!fromDate!' 
						AND rv_reservation_item.rv_item_date_depart > '!toDate!'
					)
				)				
			"));
			unset($travelDateRange);
		}


		$monthFilters = array("travelDateRange");
		if($this->GetParamValue("extraDateCheck") == "1") {
			$monthFilters[] = "extraDateRange";
		}
		if($this->GetParamValue("paymentDateCheck") == "1") {
			$monthFilters[] = "paymentDateRange";
		}
		$this->BuildMonths($monthFilters);

		$display = $this->GetParamValue("display");
		foreach($display as $key=>$item) {
			if($item['active'] == "1" && isset($item['buildPotential']) && $item['buildPotential']) {
				$this->BuildPotential();
				break;
			}
		}
		unset($display);

		$this->BuildReference();

		$monthTotalClass = "txtb";
		if($this->GetParamValue("dayTotal") != 1) {
			$monthTotalClass = "";
		}
		$yearTotalClass = "txtb";
		if($this->GetParamValue("dayTotal") != 1 && $this->GetParamValue("monthTotal") != 1) {
			$yearTotalClass = "";
		}


		$lastYear = $this->Dates[0]['year'];
		$lastYearStart = $this->Dates[0]['start'];
		$lastYearEnd = $this->findYearEnd($lastYear);
		foreach($this->Dates as $date) {
			if($lastYear != $date['year'] && $this->GetParamValue("yearTotal") == 1) {
				$this->BuildDisplay($lastYear,$lastYear . " Totals",$lastYearStart,$lastYearEnd);
				$lastYear = $date['year'];
				$lastYearStart = $date['start'];
				$lastYearEnd = $this->findYearEnd($lastYear);
			}

			if($this->GetParamValue("dayTotal") == 1) {
				foreach($date['days'] as $day) {
					$prefix = str_replace(" ","_",strtolower($day['name']));
					$this->BuildDisplay($prefix,$day['label'],$day['start'],$day['end']);
				}
			}

			if($this->GetParamValue("monthTotal") == 1) {
				$prefix = str_replace(" ","_",strtolower($date['name']));
				$this->BuildDisplay($prefix,$date['name'],$date['start'],$date['end'],$monthTotalClass);
			}
		}
		if($lastYear !== false && $this->GetParamValue("yearTotal") == 1) {
			$this->BuildDisplay($lastYear,$lastYear . " Totals",$lastYearStart,$lastYearEnd,$yearTotalClass);
		}


		$this->BuildDisplay("total","Group Totals",$this->Dates[0]['start'],$this->Dates[sizeof($this->Dates)-1]['end'],"txtb");

		$this->BuildTotals();

		if($this->GetParamValue("includeZeroRows") != "1") {
			$this->RemoveZeroRows();
		}

		if($this->GetParamValue("includeZeroColumns") != "1") {
			$this->RemoveZeroColumns();
		}		

		$this->SortData();

		if($this->GetParamValue("grandTotal") != 1) {
			$this->RemoveGrandTotals();
		}

		$this->BuildFormat();
		//debug($this->Columns);
		//debug($this->Data);
		//debug($this->Totals);
		//debug($this->Reference);
	}	
}
