<?php
// overrides
define("WITH_OVERRIDES",1);
define("WITHOUT_OVERRIDES",2);
define("WITH_SPECIALS",1);
define("WITHOUT_SPECIALS",2);

class FinancialAnalysisFolioReport extends FinancialAnalysisReport {

	function Config() {
		global $lDB;

		parent::Config();
		$commissionLabel = commissionLabel();

		$countriesRaw = $lDB->get("SELECT * FROM rf_country",6);
		$countries = array();
		foreach($countriesRaw as $country) {
			$countries[$country['rf_country_ix']] = $country['rf_country_name'];
		}

		$this->Fields = array(
			/* BEGIN - Group Fields */
			array('name'=>"key_items",'type'=>"string",'fields'=>array("fn_folio.fn_folio_ix AS key_item_id"),'group'=>"complex",'group_function'=>"folioArray"),
			array('name'=>"rv_reservation_item.ac_accomm_type_name",'type'=>"string",'fields'=>array("ac_accomm_type.ac_accomm_desc"),'key'=>"ac_accomm_type.ac_accomm_type_ix AS ac_accomm_type_name_key"),
			array('name'=>"rv_reservation.rv_agent_name",'type'=>"complex",'fields'=>"agent_persona.pr_name_last AS agent_name_last",'key'=>"agent_persona.pr_persona_ix AS rv_agent_name_key",'function'=>"formatAgentName"),
			array('name'=>"rv_reservation.rv_agent_email",'type'=>"complex",'fields'=>"agent_persona.pr_email AS agent_email",'key'=>"agent_persona.pr_persona_ix AS rv_agent_email_key",'function'=>"getAgentEmail"),
			array('name'=>"agent_persona.pr_postal_country",'type'=>"complex",'fields'=>array("IFNULL(agent_linked_persona.pr_corr_country_id, agent_persona.pr_corr_country_id) AS agent_corr_country"),'function'=>"getCountry",'key'=>"IFNULL(agent_linked_persona.pr_corr_country_id, agent_persona.pr_corr_country_id) AS agent_corr_country", 'key_function'=>'getCountryKey'),
			array('name'=>"agent_persona.pr_physical_country",'type'=>"complex",'fields'=>array("IFNULL(agent_linked_persona.pr_phys_country_id, agent_persona.pr_phys_country_id) AS agent_phys_country"),'function'=>"getCountry",'key'=>"IFNULL(agent_linked_persona.pr_phys_country_id, agent_persona.pr_phys_country_id) AS agent_phys_country", 'key_function'=>'getCountryKey'),
			array('name'=>"pr_agent.pr_agent_commission_perc",'type'=>"complex",'fields'=>array("pr_agent.pr_agent_commission_perc"),'function'=>"formatCommPerc",'key'=>"pr_agent.pr_agent_commission_perc"),
			array('name'=>"rv_reservation.rv_consultant_name",'type'=>"complex",'fields'=>array("consultant_persona.pr_name_first AS consultant_name_first","consultant_persona.pr_name_last AS consultant_name_last"),'function'=>"getConsultantName",'key'=>"rv_reservation.rv_consultant_id"),
			array('name'=>"rv_reservation.rv_corr_persona_name",'type'=>"complex",'fields'=>array("contact_persona.pr_name_first AS contact_name_first","contact_persona.pr_name_last","contact_persona.pr_email"),'function'=>"getContactName",'key'=>"rv_reservation.rv_corr_persona_id"),
			array('name'=>"rv_reservation.rv_corr_persona_email",'type'=>"complex",'fields'=>array("contact_persona.pr_email"),'function'=>"getContactEmail",'key'=>"rv_reservation.rv_corr_persona_id"),
			array('name'=>"rv_reservation.rv_date_recorded",'type'=>"date",'fields'=>array("rv_reservation.rv_date_recorded"),'key'=>"rv_reservation.rv_date_recorded"),
			array('name'=>"rv_reservation.rv_date_recorded_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_recorded"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_recorded",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rv_date_recorded_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_recorded"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_recorded",'key_function'=>"getYearKey"),
			array('name'=>"fn_folio.fn_folio_db",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_db"),'function'=>"getFolioDB",'key'=>"fn_folio.fn_folio_db",'key_function'=>"getFolioDBKey"),
			array('name'=>"fn_folio.fn_folio_date_month",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_date"),'function'=>"getMonth",'key'=>"fn_folio.fn_folio_date",'key_function'=>"getMonthKey"),
			array('name'=>"fn_folio.fn_folio_date_year",'type'=>"complex",'fields'=>array("fn_folio.fn_folio_date"),'function'=>"getYear",'key'=>"fn_folio.fn_folio_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_country_name",'type'=>"complex",'fields'=>array("rv_reservation.rf_country_id"),'function'=>"getCountry",'key'=>"rv_reservation.rf_country_id"),
			array('name'=>"rv_reservation.rv_origin_agent_name",'type'=>"complex",'fields'=>array("originator_persona.pr_name_first AS originator_name_first","originator_persona.pr_name_last AS originator_name_last"),'function'=>"getOriginatorName",'key'=>"CASE WHEN rv_reservation.rv_origin_agent_id = '' or rv_reservation.rv_origin_agent_id = '0' THEN '' ELSE rv_reservation.rv_origin_agent_id END AS rv_origin_agent_id"),
			array('name'=>"rv_reservation.rv_origin_agent_email",'type'=>"complex",'fields'=>array("originator_persona.pr_email AS originator_email"),'function'=>"getOriginatorEmail",'key'=>"CASE WHEN rv_reservation.rv_origin_agent_id = '' or rv_reservation.rv_origin_agent_id = '0' THEN '' ELSE rv_reservation.rv_origin_agent_id END AS rv_origin_agent_id"),
			array('name'=>"originator_persona.pr_postal_country",'type'=>"complex",'fields'=>array("IFNULL(originator_linked_persona.pr_corr_country_id, originator_persona.pr_corr_country_id) AS originator_corr_country"),'function'=>"getCountry",'key'=>"IFNULL(originator_linked_persona.pr_corr_country_id, originator_persona.pr_corr_country_id) AS originator_corr_country", 'key_function'=>'getCountryKey'),
			array('name'=>"originator_persona.pr_physical_country",'type'=>"complex",'fields'=>array("IFNULL(originator_linked_persona.pr_phys_country_id, originator_persona.pr_phys_country_id) AS originator_phys_country"),'function'=>"getCountry",'key'=>"IFNULL(originator_linked_persona.pr_phys_country_id, originator_persona.pr_phys_country_id) AS originator_phys_country", 'key_function'=>'getCountryKey'),
			array('name'=>"rv_reservation_item.pr_business_name",'type'=>"string",'fields'=>array("property_persona.pr_name_last AS property_name_last"),'key'=>"property_persona.pr_persona_ix"),
			array('name'=>"rv_reservation.rt_rate_type_name",'type'=>"string",'fields'=>array("rt_rate_type.rt_rate_type_desc"),'key'=>"rv_reservation.rt_rate_type_id"),
			array('name'=>"rv_reservation_item.rt_rate_type_name",'type'=>"string",'fields'=>array("rt_rate_type_item.rt_rate_type_desc AS rt_rate_type_desc_item"),'key'=>"rv_reservation_item.rt_rate_type_id"),
			array('name'=>"rv_reservation.rf_source_name",'type'=>"complex",'fields'=>array("rf_source.rf_source_desc"),'function'=>"getSourceName",'key'=>"rv_reservation.rf_source_ix"),
			array('name'=>"rv_reservation.rf_reservation_status_name",'type'=>"string",'fields'=>array("rf_reservation_status.rf_reservation_status_desc"),'key'=>"rv_reservation.rf_reservation_status_id"),
			array('name'=>"rv_reservation.rv_res_name",'type'=>"string",'fields'=>array("rv_reservation.rv_res_name"),'key'=>"rv_reservation.rv_reservation_ix AS rv_res_name_key"),
			array('name'=>"rv_reservation.rv_reservation_ix",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix"),'key'=>"rv_reservation.rv_reservation_ix AS rv_reservation_ix_key"),
			array('name'=>"rv_reservation.rv_agent_ref",'type'=>"string",'fields'=>array("rv_reservation.rv_agent_ref"),'key'=>"rv_reservation.rv_reservation_ix"),
			array('name'=>"rv_reservation.rf_reservation_status_date",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusDate",'key'=>"rv_reservation.rv_reservation_ix","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),
			array('name'=>"rv_reservation.rf_reservation_status_month",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusMonth",'key'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'key_function'=>"getStatusMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_year",'type'=>"complex",'fields'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'function'=>"getStatusYear",'key'=>array("rv_reservation.rf_reservation_status_id","rv_reservation.rv_cancel_date","rv_reservation.rv_confirmation_date","rv_reservation.rv_prov_date","rv_reservation.rv_wait_list_date","rv_reservation.rv_date_quote","rv_reservation.rv_date_deleted"),'key_function'=>"getStatusYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_date",'type'=>"date",'fields'=>array("rv_reservation.rv_cancel_date"),'key'=>"rv_reservation.rv_cancel_date"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_cancel_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_cancel_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_cancel_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_cancel_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_cancel_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_date",'type'=>"date",'fields'=>array("rv_reservation.rv_confirmation_date"),'key'=>"rv_reservation.rv_confirmation_date"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_confirmation_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_confirmation_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_confirm_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_confirmation_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_confirmation_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_date",'type'=>"date",'fields'=>array("rv_reservation.rv_date_deleted"),'key'=>"rv_reservation.rv_date_deleted"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_deleted"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_deleted",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_delete_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_deleted"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_deleted",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_date",'type'=>"date",'fields'=>array("rv_reservation.rv_prov_date"),'key'=>"rv_reservation.rv_prov_date"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_prov_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_prov_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_prov_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_prov_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_prov_date",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_date",'type'=>"date",'fields'=>array("rv_reservation.rv_date_quote"),'key'=>"rv_reservation.rv_date_quote"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_quote"),'function'=>"getMonth",'key'=>"rv_reservation.rv_date_quote",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_quote_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_date_quote"),'function'=>"getYear",'key'=>"rv_reservation.rv_date_quote",'key_function'=>"getYearKey"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_date",'type'=>"date",'fields'=>array("rv_reservation.rv_wait_list_date"),'key'=>"rv_reservation.rv_wait_list_date"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_month",'type'=>"complex",'fields'=>array("rv_reservation.rv_wait_list_date"),'function'=>"getMonth",'key'=>"rv_reservation.rv_wait_list_date",'key_function'=>"getMonthKey"),
			array('name'=>"rv_reservation.rf_reservation_status_waitlist_year",'type'=>"complex",'fields'=>array("rv_reservation.rv_wait_list_date"),'function'=>"getYear",'key'=>"rv_reservation.rv_wait_list_date",'key_function'=>"getYearKey"),
			array('name'=>"fn_folio.rf_currency_symbol",'type'=>"string",'fields'=>array("rf_currency.rf_currency_symbol"),'key'=>"fn_folio.rf_currency_id"),
			array('name'=>"fn_folio.fn_folio_to",'type'=>"complex",'fields'=>array("debtor_persona.pr_name_first AS debtor_name_first","debtor_persona.pr_name_last AS debtor_name_last"),'key'=>"debtor_persona.pr_persona_ix AS fn_folio_to_key",'function'=>"getDebtor"),
			array('name'=>"fn_folio.fn_folio_to_email",'type'=>"complex",'fields'=>array("debtor_persona.pr_email AS debtor_email"),'key'=>"debtor_persona.pr_persona_ix AS fn_folio_to_email_key",'function'=>"getDebtorEmail"),
			array('name'=>"fn_folio.pr_business",'type'=>"string",'fields'=>array("invoicing_persona.pr_name_last AS invoicing_name_last"),'key'=>"invoicing_persona.pr_persona_ix AS pr_business_key"),
			array('name'=>"folio_id",'type'=>"string",'fields'=>array("fn_folio.fn_folio_folio_num"),'key'=>"fn_folio.fn_folio_ix"),
			array('name'=>"rv_reservation.ac_pay_plan_desc",'type'=>"string",'fields'=>array("ac_pay_plan.ac_pay_plan_desc"),'key'=>"rv_reservation.ac_pay_plan_id"),
			array('name'=>"sp_special.sp_special_desc",'type'=>"string",'fields'=>array("sp_special.sp_special_desc"),'key'=>"sp_special.sp_special_ix AS sp_special_ix_key"),
			array('name'=>"rv_reservation_item.rv_item_date_arrive",'type'=>"data",'fields'=>array("rv_reservation_item.rv_item_date_arrive"),'key'=>"rv_reservation_item.rv_item_date_arrive"),
			array('name'=>"rv_reservation_item.rv_item_date_depart",'type'=>"data",'fields'=>array("rv_reservation_item.rv_item_date_depart"),'key'=>"rv_reservation_item.rv_item_date_depart"),
            array('name'=>"rv_reservation.rv_cancel_reason",'type'=>"string",'fields'=>array("rv_reservation.rv_cancel_reason"),'key'=>"rv_reservation.rv_reservation_ix"),
			array('name'=>"rv_reservation_item.allocation_drawdown",'type'=>"complex",'fields'=>array("rv_reservation_item.rv_reservation_item_ix"),'function'=>"getDrawdown",'key'=>"rv_reservation_item.rv_reservation_item_ix",'key_function'=>"getDrawdownKey"),
			/* END - Group Fields */

			/* START - Detail Fields */
			array('name'=>"rv_reservation_item.rv_item_accomm_count",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count")),
			array('name'=>"rv_reservation_item.pax",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")),
			array('name'=>"rv_reservation_item.room_nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights")),
			array('name'=>"rv_reservation_item.bed_nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")),
			array('name'=>"rv_reservation.count",'type'=>"string",'fields'=>array("rv_reservation.rv_reservation_ix")),
			array('name'=>"rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix",'type'=>"string",'fields'=>array("rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix")),
			array('name'=>"rv_res_item_comp.rv_res_item_comp_ix",'type'=>"string",'fields'=>array("rv_res_item_comp.rv_res_item_comp_ix")),
			array('name'=>"rv_reservation_item.rv_reservation_item_ix",'type'=>"string",'fields'=>array("rv_reservation_item.rv_reservation_item_ix")),
			array('name'=>"rv_reservation_item.pr_business_id",'type'=>"string",'fields'=>array("rv_reservation_item.pr_business_id")),
			array('name'=>"rv_reservation_item.ac_accomm_type_id",'type'=>"string",'fields'=>array("rv_reservation_item.ac_accomm_type_id")),
			array('name'=>"rv_reservation_item_prop_count.number_properties",'type'=>"string",'fields'=>array("rv_reservation_item_prop_count.number_properties")),
			array('name'=>"rv_reservation_item.number_properties",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_accomm_count","rv_reservation_item.rv_item_nights","rv_reservation_item.rv_item_adult_count","rv_reservation_item.rv_item_child_count")),
			array('name'=>"rv_reservation_item.number_nights",'type'=>"string",'fields'=>array("rv_reservation_item.rv_item_date_arrive","rv_reservation_item.rv_item_date_depart")),
			array('name'=>"sp_special.sp_special_note",'type'=>"string",'fields'=>array("sp_special.sp_special_note")),
			array('name'=>"rv_special.special_override_user",'type'=>"complex",'fields'=>array("special_override_persona.pr_name_first AS special_override_name_first","special_override_persona.pr_name_last AS special_override_name_last"),'function'=>"getSpecialOverrideUser"),
			array('name'=>"rv_special.special_override_date",'type'=>"string",'fields'=>array("rv_reservation.rv_sp_override_date")),
			array('name'=>"rv_special.special_application_date",'type'=>"string",'fields'=>array("rv_special.ad_create_date")),
			/* END - Detail Fields */
		);

		$this->Joins['folio'] = array(
			array('table'=>"fn_folio"),
			array('table'=>"fn_invoice",'type'=>"LEFT",'on'=>"fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8",'requires'=>"fn_folio"),
			array('table'=>"pr_business",'alias'=>"folio_business",'type'=>"INNER",'on'=>"folio_business.pr_business_id = fn_folio.pr_business_id",'requires'=>"fn_folio"),
			array('table'=>"rf_currency",'alias'=>"gl_currency",'type'=>"INNER",'on'=>"gl_currency.rf_currency_ix = folio_business.pr_bus_home_curr_id",'requires'=>"folio_business"),
			array('table'=>"rv_reservation",'type'=>"INNER",'on'=>"rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id",'requires'=>"fn_folio"),
			array('table'=>"rv_reservation_item",'type'=>"INNER",'on'=>"rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id",'requires'=>"rv_reservation_item"),
			array('table'=>"pr_persona",'alias'=>"agent_linked_persona",'type'=>"LEFT",'on'=>"agent_linked_persona.pr_persona_ix = agent_persona.pr_persona_link_id",'requires'=>'agent_persona'),
			array('table'=>"pr_persona",'alias'=>"agent_persona",'type'=>"LEFT",'on'=>"agent_persona.pr_persona_ix = rv_reservation.rv_agent_id",'requires'=>"rv_reservation", 'includes'=>'agent_linked_persona'),
			array('table'=>"pr_agent",'type'=>"LEFT",'on'=>"pr_agent.pr_agent_id = rv_reservation.rv_agent_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"consultant_persona",'type'=>"LEFT",'on'=>"consultant_persona.pr_persona_ix = rv_reservation.rv_consultant_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"contact_persona",'type'=>"LEFT",'on'=>"contact_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id",'requires'=>"rv_reservation"),
			array('table'=>"pr_persona",'alias'=>"originator_linked_persona",'type'=>"LEFT",'on'=>"originator_linked_persona.pr_persona_ix = originator_persona.pr_persona_link_id", 'requires'=>'originator_persona'),
			array('table'=>"pr_persona",'alias'=>"originator_persona",'type'=>"LEFT",'on'=>"originator_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id",'requires'=>"rv_reservation", 'includes' => 'originator_linked_persona'),
			array('table'=>"pr_persona",'alias'=>"property_persona",'type'=>"INNER",'on'=>"property_persona.pr_persona_ix = rv_reservation_item.pr_business_id",'requires'=>"rv_reservation_item"),
			array('table'=>"rt_rate_type",'type'=>"INNER",'on'=>"rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id",'requires'=>"rv_reservation"),
			array('table'=>"rt_rate_type",'alias'=>"rt_rate_type_item",'type'=>"INNER",'on'=>"rt_rate_type_item.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id",'requires'=>"rv_reservation_item"),
			array('table'=>"rf_source",'type'=>"LEFT",'on'=>"rf_source.rf_source_ix = rv_reservation.rf_source_ix",'requires'=>"rv_reservation"),
			array('table'=>"rf_reservation_status",'type'=>"INNER",'on'=>"rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id",'requires'=>"rv_reservation"),
			array('table'=>"rf_currency",'type'=>"INNER",'on'=>"rf_currency.rf_currency_ix = fn_folio.rf_currency_id",'requires'=>"fn_folio"),
			array('table'=>"pr_persona",'alias'=>"debtor_persona",'type'=>"LEFT",'on'=>"debtor_persona.pr_persona_ix = fn_folio.fn_folio_to_id",'requires'=>"fn_folio"),
			array('table'=>"pr_persona",'alias'=>"invoicing_persona",'type'=>"INNER",'on'=>"invoicing_persona.pr_persona_ix = fn_folio.pr_business_id",'requires'=>"fn_folio"),
			array('table'=>"ac_pay_plan",'type'=>"LEFT",'on'=>"ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id",'requires'=>"rv_reservation"),
			array('table'=>"rv_special",'type'=>"LEFT",'on'=>"rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix",'requires'=>"rv_reservation"),
			array('table'=>"sp_special",'type'=>"LEFT",'on'=>"sp_special.sp_special_ix = rv_special.sp_special_id",'requires'=>"rv_special"),
			array('table'=>"pr_persona",'alias'=>"special_override_persona",'type'=>"LEFT",'on'=>"special_override_persona.pr_persona_ix = rv_reservation.rv_sp_override_user_id",'requires'=>"rv_reservation"),
		);

		$this->AddParams(array(
			new ReportParamHeading("Filter options"),
			new ReportParamFilterDateRange("invoiceDateRange","Folio date range"),
			new ReportParamFilter("accomm"),
			new ReportParamFilterCheckArea("travelDateCheck","Travel date range",array(
				new ReportParamFilterDateRangeTravel("travelDateRange",false)
			)),
			new ReportParamSection("reservation","Res filters",array(
				new ReportParamFilterCheckArea("createDateCheck","Create date range",array(
					new ReportParamFilterDateRange("createDateRange",false)
				)),
				new ReportParamFilterCheckArea("statusDateCheck","Status date range",array(
					new ReportParamFilterDateRangeStatus("statusDateRange",false)
				)),
				new ReportParamFilter("status",false,"30"),
				new ReportParamFilterCheck("excludeExpiredProv","Exclude expired provisionals"),
				new ReportParamFilterText("resNameNumberVoucher", "Keyword filter", false, array('placeholderText'=>"Reservation Name, Reservation Number, Voucher Reference or Cancel Reason",'width'=>"585px",'overlib'=>"Filter results by keywords found in Reservation Name, Reservation Number, Voucher Reference or Cancel Reason")),
				new ReportParamHeading("Set Agent filters"),
				new ReportParamFilter("agent"),
				new ReportParamFilter("agentPostCountry"),
				new ReportParamFilter("agentPhysCountry"),
				new ReportParamEmpty(),
				new ReportParamHeading("Set Originator filters"),
				new ReportParamFilter("originator"),
				new ReportParamFilter("originatorPostCountry"),
				new ReportParamFilter("originatorPhysCountry"),
				new ReportParamEmpty(),
				new ReportParamFilter("createdBy"),
				new ReportParamFilter("consultant"),
				new ReportParamFilter("nationality"),
				new ReportParamFilter("source"),
				new ReportParamFilter("paymentPlan"),
				new ReportParamFilter("rate"),
				new ReportParamFilterCheckArea("reservationOverrideAmountCheck","Filter rate amount override",array(
					new ReportParamFilterRadioGroup("reservationOverrideAmount","",array(
						WITH_OVERRIDES=>"Only include reservations with overrides",
						WITHOUT_OVERRIDES=>"Only include reservations without overrides"
					),WITH_OVERRIDES,array('width'=>"560px")),
				)),
				new ReportParamFilterCheckArea("reservationOverrideRateTypeCheck","Filter rate type override",array(
					new ReportParamFilterRadioGroup("reservationOverrideRateType","",array(
						WITH_OVERRIDES=>"Only include reservations with overrides",
						WITHOUT_OVERRIDES=>"Only include reservations without overrides"
					),WITH_OVERRIDES,array('width'=>"560px")),
					new ReportParamFilterCheck("reservationAuthorisedForAgent","Authorised for agent"),
					new ReportParamFilterCheck("reservationNotAuthorisedForAgent","Not authorised for agent")
				)),
				new ReportParamFilterCheckArea("reservationOverrideVarianceCheck","Filter component override",array(
					new ReportParamFilterRadioGroup("reservationOverrideVariance","",array(
						WITH_OVERRIDES=>"Only include reservations with overrides",
						WITHOUT_OVERRIDES=>"Only include reservations without overrides"
					),WITH_OVERRIDES,array('width'=>"560px")),
				)),
				new ReportParamFilterCheckArea("reservationOverrideCommissionCheck","Filter " . $commissionLabel . " override",array(
					new ReportParamFilterRadioGroup("reservationOverrideCommission","",array(
						WITH_OVERRIDES=>"Only include reservations with overrides",
						WITHOUT_OVERRIDES=>"Only include reservations without overrides"
					),WITH_OVERRIDES,array('width'=>"560px")),
				)),
				new ReportParamFilterCheckArea("balanceCheck","Filter by amount owing",array(
					new ReportParamFilterCheck("balanceTBACheck","TBA"),
					new ReportParamFilterCheck("balanceUnpaidCheck","Unpaid"),
					new ReportParamFilterCheck("balancePartPaidCheck","Part paid"),
					new ReportParamFilterCheck("balancePaidCheck","Fully paid"),
					new ReportParamFilterCheck("balanceOverpaidCheck","Overpaid"),
					new ReportParamEmpty(),
					new ReportParamFilterCheckDiffersBy("balanceOwingByCheck","Owing"),
					new ReportParamFilterCheckDiffersBy("balanceOverpaidByCheck","Overpaid by")
				)),
				new ReportParamFilterNumber("numberProperties", "Number of properties", false, array('placeholderText'=>"E.g. 3")),
				new ReportParamFilterNumber("numberNights", "Number of nights", false, array('placeholderText'=>"E.g. 3")),
				new ReportParamFilterNumber("numberPax", "Number of pax", false, array('placeholderText'=>"E.g. 3")),
				new ReportParamFilterCheckArea("reservationSpecialCheck","Filter specials",array(
					new ReportParamFilter("specials"),
					new ReportParamFilterCheckArea("reservationSpecialIncludeCheck","Filter special reservations",array(
						new ReportParamFilterRadioGroup("reservationSpecialInclude","",array(
							WITH_SPECIALS=>"Only include reservations with specials",
							WITHOUT_SPECIALS=>"Only include reservations without specials"
						),false,array('width'=>"300px")),
					)),
					new ReportParamFilterCheck("specialsDiscountCheck","Has special discount"),
				)),
				new ReportParamFilterCheckArea("allocationCheck","Allocation drawdown",array(
					new ReportParamHeading("Include itineraries with:"),
					new ReportParamFilterCheck("allocationDrawdownCheck","Allocation drawdown"),
					new ReportParamFilterCheck("allocationBlockDrawdownCheck","Block allocation drawdown"),
					new ReportParamFilterCheck("allocationNoDrawdownCheck","No drawdown")
				)),
				new ReportParamFilterText("allocationFilter", "Allocation filter", false, array('placeholderText'=>"Allocation name or number",'width'=>"585px",'overlib'=>"Filter results by keywords found in drawn down allocation name or number")),
			)),
			new ReportParamSection("folio","Folio filters",array(
				new ReportParamFilter("folioContact"),
				new ReportParamFilterServer(),
				new ReportParamFilterCheck("invoicedCheck","Invoiced",false,array('onclick'=>"invoiceStatusToggle();")),
				new ReportParamFilterCheck("uninvoicedCheck","Uninvoiced",false,array('onclick'=>"invoiceStatusToggle();")),
				new ReportParamFilterCheckArea("folioBalanceCheck","Filter by amount owing",array(
					new ReportParamFilterCheck("folioBalanceTBACheck","TBA"),
					new ReportParamFilterCheck("folioBalanceUnpaidCheck","Unpaid"),
					new ReportParamFilterCheck("folioBalancePartPaidCheck","Part paid"),
					new ReportParamFilterCheck("folioBalancePaidCheck","Fully paid"),
					new ReportParamFilterCheck("folioBalanceOverpaidCheck","Overpaid"),
					new ReportParamEmpty(),
					new ReportParamFilterCheckDiffersBy("folioBalanceOwingByCheck","Owing"),
					new ReportParamFilterCheckDiffersBy("folioBalanceOverpaidByCheck","Overpaid by")
				)),
			)),
			new ReportParamSection("revenue","Revenue filters",array(
				new ReportParamFilter("currencies"),
				new ReportParamFilter("rate","rateAccomm",false,array('label'=>"Rate type acc")),
				new ReportParamFilter("rateGroupSplit"),
				new ReportParamFilterCheck("specialsDiscountAccCheck","Has special discount (for selected rate groups)"),
				new ReportParamFilter("rateComponent"),
				new ReportParamFilterCheckArea("revenueOverrideAmountCheck","Filter rate amount override",array(
					new ReportParamFilterRadioGroup("revenueOverrideAmount","",array(
						WITH_OVERRIDES=>"Only include itinerary items with overrides",
						WITHOUT_OVERRIDES=>"Only include itinerary items without overrides"
					),false,array('width'=>"560px")),
				)),
				new ReportParamFilterCheckArea("revenueOverrideRateTypeCheck","Filter rate type override",array(
					new ReportParamFilterRadioGroup("revenueOverrideRateType","",array(
						WITH_OVERRIDES=>"Only include itinerary items with overrides",
						WITHOUT_OVERRIDES=>"Only include itinerary items without overrides"
					),false,array('width'=>"560px")),
					new ReportParamFilterCheck("revenueAuthorisedForAgent","Authorised for agent"),
					new ReportParamFilterCheck("revenueNotAuthorisedForAgent","Not authorised for agent")
				)),
				new ReportParamFilterCheckArea("revenueOverrideVarianceCheck","Filter component override",array(
					new ReportParamFilterRadioGroup("revenueOverrideVariance","",array(
						WITH_OVERRIDES=>"Only include itinerary items with overrides",
						WITHOUT_OVERRIDES=>"Only include itinerary items without overrides"
					),false,array('width'=>"560px")),
				)),
				new ReportParamFilter("extraCategory"),
				new ReportParamFilterExtra(),
				new ReportParamFilterCheckArea("extraPropertyCheck","Filter extras by property",array(
					new ReportParamFilterCheck("extraNonPropertyCheck","Include non-property-specific extras")
				))
			)),
			new ReportParamEmpty(),
			new ReportParamHeading("Output options"),
			new ReportParamSection("dataOptions","Select data",array(
				new ReportParamBuilder("grouping","Group",array(
					array('name'=>"rv_reservation_item.ac_accomm_type_name", 'label'=>"Accommodation type",'width'=>"100"),
					array('name'=>"rv_reservation.rv_agent_name", 'label'=>"Agent",'width'=>"100"),
					array('name'=>"rv_reservation.rv_agent_email", 'label'=>"Agent email",'width'=>"100"),
					array('name'=>"pr_agent.pr_agent_commission_perc", 'label'=>"Agent " . $commissionLabel . " %",'width'=>"100"),
					array('name'=>"agent_persona.pr_postal_country", 'label'=>"Agent postal country",'width'=>"100"),
					array('name'=>"agent_persona.pr_physical_country", 'label'=>"Agent physical country",'width'=>"100"),
					array('name'=>"rv_reservation_item.allocation_drawdown", 'label'=>"Allocation drawdown", 'width'=>"70"),
					array('name'=>"rv_reservation_item.rv_item_date_arrive", 'label'=>"Arrival date",'format'=>'date','exclude_zero_check'=>true,'width'=>"70"),
					array('name'=>"rv_reservation.rv_consultant_name", 'label'=>"Consultant",'width'=>"100"),
					array('name'=>"rv_reservation.rv_corr_persona_name", 'label'=>"Contact",'width'=>"100"),
					array('name'=>"rv_reservation.rv_corr_persona_email", 'label'=>"Contact email",'width'=>"100"),
					array('name'=>"rv_reservation.rv_date_recorded", 'label'=>"Create date",'width'=>"70"),
					array('name'=>"rv_reservation.rv_date_recorded_month", 'label'=>"Create month",'width'=>"70"),
					array('name'=>"rv_reservation.rv_date_recorded_year", 'label'=>"Create year",'width'=>"70"),
					array('name'=>"fn_folio.fn_folio_to", 'label'=>"Debtor", 'width'=>"100"),
					array('name'=>"fn_folio.fn_folio_to_email", 'label'=>"Debtor email", 'width'=>"100"),
					array('name'=>"rv_reservation_item.rv_item_date_depart", 'label'=>"Departure date",'format'=>'date','exclude_zero_check'=>true,'width'=>"70"),
					array('name'=>"fn_folio.fn_folio_db", 'label'=>"Environment (Folio)",'width'=>"100"),
					array('name'=>"fn_folio.rf_currency_symbol", 'label'=>"Folio currency",'width'=>"50"),
					array('name'=>"folio_id", 'label'=>"Folio id", 'width'=>"100"),
					array('name'=>"fn_folio.fn_folio_date_month", 'label'=>"Folio month",'width'=>"50"),
					array('name'=>"fn_folio.fn_folio_date_year", 'label'=>"Folio year",'width'=>"50"),
					array('name'=>"fn_folio.pr_business", 'label'=>"Invoice unit", 'width'=>"100"),
					array('name'=>"rv_reservation.rf_country_name", 'label'=>"Nationality",'width'=>"100"),
					array('name'=>"rv_reservation.rv_origin_agent_name", 'label'=>"Originator",'width'=>"100"),
					array('name'=>"rv_reservation.rv_origin_agent_email", 'label'=>"Originator email",'width'=>"100"),
					array('name'=>"originator_persona.pr_postal_country", 'label'=>"Originator postal country",'width'=>"100"),
					array('name'=>"originator_persona.pr_physical_country", 'label'=>"Originator physical country",'width'=>"100"),
					array('name'=>"rv_reservation.ac_pay_plan_desc", 'label'=>"Payment plan",'width'=>"100"),
					array('name'=>"rv_reservation_item.pr_business_name", 'label'=>"Property",'width'=>"100"),
					array('name'=>"rv_reservation.rt_rate_type_name", 'label'=>"Rate type (Reservation)",'width'=>"100"),
					array('name'=>"rv_reservation_item.rt_rate_type_name", 'label'=>"Rate type (Itinerary)",'width'=>"100"),
					array('name'=>"rv_reservation.rv_res_name", 'label'=>"Reservation name",'width'=>"100"),
					array('name'=>"rv_reservation.rv_reservation_ix", 'label'=>"Reservation #",'width'=>"100",'sortType'=>"ix"),
					array('name'=>"rv_reservation.rf_source_name", 'label'=>"Source",'width'=>"100"),
					array('name'=>"sp_special.sp_special_desc", 'label'=>"Special",'width'=>"100"),
					array('name'=>"rv_reservation.rf_reservation_status_name", 'label'=>"Status",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_date", 'label'=>"Status date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_month", 'label'=>"Status month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_year", 'label'=>"Status year",'width'=>"70"),					
					array('name'=>"rv_reservation.rf_reservation_status_cancel_date", 'label'=>"Status cancel date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_cancel_month", 'label'=>"Status cancel month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_cancel_year", 'label'=>"Status cancel year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_date", 'label'=>"Status confirm date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_month", 'label'=>"Status confirm month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_confirm_year", 'label'=>"Status confirm year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_date", 'label'=>"Status delete date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_month", 'label'=>"Status delete month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_delete_year", 'label'=>"Status delete year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_date", 'label'=>"Status provisional date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_month", 'label'=>"Status provisional month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_prov_year", 'label'=>"Status provisional year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_date", 'label'=>"Status quote date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_month", 'label'=>"Status quote month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_quote_year", 'label'=>"Status quote year",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_date", 'label'=>"Status wait list date",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_month", 'label'=>"Status wait list month",'width'=>"70"),
					array('name'=>"rv_reservation.rf_reservation_status_waitlist_year", 'label'=>"Status wait list year",'width'=>"70"),
					array('name'=>"rv_reservation.rv_agent_ref", 'label'=>"Voucher reference",'width'=>"100"),
                    array('name'=>"rv_reservation.rv_cancel_reason",'label'=>"Cancellation reason",'width'=>"70"),
				),false,false,array('availableWidth'=>"175")),
				new ReportParamBuilder("display","Fields",array(
					array('name'=>"rv_reservation_item.allocation_id", 'label'=>"Allocation #", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.allocation_name", 'label'=>"Allocation name", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.rv_item_date_arrive",'label'=>"Arrival date",'format'=>"date",'width'=>"70",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_bed_nights_per_res", 'label'=>"Average bed nights per reservation",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_length_of_stay", 'label'=>"Average length of stay",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.average_room_nights_per_res", 'label'=>"Average room nights per reservation",'format'=>"average",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.bed_nights", 'label'=>"Bed nights",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"bl_block.bl_block_id", 'label'=>"Block #", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"bl_block.bl_block_name", 'label'=>"Block name", 'format'=>"string", 'width'=>"50", 'requirements'=>array('itineraries')),
					array('name'=>"commission_rec_extra",'label'=>$commissionLabel . " receivable extras",'format'=>"amount",'width'=>"80",'align'=>"r",'requirements'=>array('extras')),	
					array('name'=>"commission_pay_accomm",'label'=>$commissionLabel . " payable accommodation",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"commission_pay_extra",'label'=>$commissionLabel . " payable extras",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('extras')),
					array('name'=>"commission_pay",'label'=>$commissionLabel . " payable total",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.rv_item_date_depart",'label'=>"Departure date",'format'=>"date",'width'=>"70",'total'=>"hidden", 'requirements'=>array('itineraries')),
					array('name'=>"fn_invoice.fn_inv_date",'label'=>"Invoice date",'format'=>"date",'width'=>"70", 'requirements'=>array()),
					array('name'=>"fn_invoice.fn_invoice_ix",'label'=>"Invoice number",'format'=>"string",'width'=>"100", 'requirements'=>array()),
					array('name'=>"rv_reservation_item.number_nights", 'label'=>"Number of nights",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.number_properties", 'label'=>"Number of properties",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_special.count", 'label'=>"Number of specials", 'format'=>"string", 'width'=>"50", 'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"rv_reservation_item.pax", 'label'=>"PAX",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"payments",'label'=>"Payments",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('payments')),
					array('name'=>"balance_report",'label'=>"Report balance",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries', 'payments')),
					array('name'=>"rv_reservation.count", 'label'=>"Reservation count",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"accommodation", 'label'=>"Revenue Accommodation",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"extras",'label'=>"Revenue Extras",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('extras')),
					array('name'=>"tax",'label'=>"Revenue Tax",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"total",'label'=>"Revenue Total",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"rv_reservation_item.rv_item_accomm_count", 'label'=>"Rooms",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_reservation_item.room_nights", 'label'=>"Room nights",'format'=>"integer",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"rv_special.special_application_date", 'label'=>"Special application date",'format'=>"string",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"rv_item_comp_rate_grp_amt_sp_discount", 'label'=>"Special discount amount",'format'=>"amount",'width'=>"50",'align'=>"r", 'requirements'=>array('itineraries')),
					array('name'=>"sp_special.sp_special_note", 'label'=>"Special note",'format'=>"string",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"rv_special.special_override_date", 'label'=>"Special override date",'format'=>"string",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"rv_special.special_override_user", 'label'=>"Special override user",'format'=>"string",'width'=>"50",'align'=>"r", 'requirements'=>array('reservation')),
					array('name'=>"balance_folio",'label'=>"Total amount outstanding",'format'=>"amount",'width'=>"80",'align'=>"r", 'requirements'=>array('folios')),
					array('name'=>"yield_on_total_per_bed_night",'label'=>"Yield on accomm and extras per bed night",'format'=>"amount",'width'=>"80",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_total_per_room_night",'label'=>"Yield on accomm and extras per room night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_accomm_per_bed_night",'label'=>"Yield on accomm per bed night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"yield_on_accomm_per_room_night",'label'=>"Yield on accomm per room night",'format'=>"amount",'width'=>"80",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries', 'extras')),
					array('name'=>"rv_reservation_item.bed_nights_perc", 'label'=>"% of bed nights",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('folios')),
					array('name'=>"rv_reservation.count_perc", 'label'=>"% of reservation count",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('reservation')),
					array('name'=>"rv_reservation_item.room_nights_perc", 'label'=>"% of room nights",'format'=>"percent",'width'=>"50",'align'=>"r",'total'=>"hidden", 'requirements'=>array('itineraries')),
				),false,false,array('availableWidth'=>"175")),
			),false,array('filterLabelWidth'=>"40")),
			new ReportParamSection("revenueOptions","Financial details",array(
				new ReportParamFilterSelect("commission",$commissionLabel,array(
					'nett'=>"Nett",
					'gross'=>"Gross",
					'payable'=>"Payable"
				),"payable",array('width'=>"150px")),
				new ReportParamFilterSelect("displayCurrency","Folio currency",array(
					'invoice'=>"Invoice",
					'gl'=>"GL"
				),"invoice",array('width'=>"150px",'overlib'=>"This option specifies which currency to show folio amounts in. If GL currency is chosen then all uninvoiced folios must be excluded as they do not have an exchange rate to GL currency available.")),
				new ReportParamFilterCheck("includeTax","Include tax in revenue"),
				new ReportParamFilterCheck("splitRateGroup","Split rate groups for occupancy"),
				new ReportParamFilterSelect("splitAccomm","Split accommodation",array(
					'total'=>"Total",
					'property'=>"Property",
					'component'=>"Component",
					'rateGroup'=>"Rate group",
					'componentRateGroup'=>"Component then rate group",
					'rateGroupComponent'=>"Rate group then component"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitExtra","Split extras",array(
					'total'=>"Total",
					'category'=>"Categories",
					'extra'=>"Extras",
					'categoryExtra'=>"Category then extra",
					'type'=>"Type",
					'typeCategory'=>"Type then category",
					'typeExtra'=>"Type then extra"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitTax","Split taxes",array(
					'total'=>"Total",
					'tax'=>"Tax rate",
					'revenueType'=>"Revenue type",
					'taxRevenueType'=>"Tax rate then revenue type"
				),false,array('width'=>"150px")),
				new ReportParamFilterSelect("splitPayment","Split payments",array(
					'total'=>"Total",
					'bank'=>"Bank and cash point"
				),false,array('width'=>"150px")),
			)),
			new ReportParamSection("outputOptions","Display options",array(				
				new ReportParamFilterRadioGroup("outputAxis","Orientation",array(
					FINANCIAL_ANALYSIS_ROW_PER_GROUP=>"Groups as rows (horizontal)",
					FINANCIAL_ANALYSIS_ROW_PER_PERIOD=>"Groups as columns (vertical)"
				),FINANCIAL_ANALYSIS_ROW_PER_GROUP,array('width'=>"560px")),
				new ReportParamFilterCheckArea("dayTotal","Include totals per day", array(
					new ReportParamFilterSelect("dayTotalFormat","Format",array(
						FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_WEEK=>"DD (eg. Mo)",
						FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_MONTH=>"dd (eg. 28)",
						FINANCIAL_ANALYSIS_PER_DAY_DAY_AND_MONTH=>"dd mmm (eg. 28 Sep)",
						FINANCIAL_ANALYSIS_PER_DAY_FULL=>"dd mmm yyyy (eg. 28 Sep 2015)"
					),FINANCIAL_ANALYSIS_PER_DAY_FULL,array('width'=>"180px")),
				)),
				new ReportParamFilterCheck("monthTotal","Include totals per month"),
				new ReportParamFilterCheck("yearTotal","Include totals per year"),
				new ReportParamFilterCheck("grandTotal","Include group totals",true),
				new ReportParamFilterCheck("includeTotalRows","Include period totals"),
				new ReportParamFilterCheck("includeZeroColumns","Include periods with zero value"),
				new ReportParamFilterCheck("includeZeroRows","Include groups with zero value")
			))
		));

		$this->AddScript("rep_financial_analysis.js");

		$this->AddValidation("checkDateRange(\"PerFolio\")");
	}

	function BuildGrouping() {
		$grouping = $this->GetParamValue("grouping");

		// Get fields to group by
		$active = array();
		foreach($grouping as $group) {
			$name = $group['name'];
			if($group['active'] == "1") {
				$active[$name] = $group;
			}
		}
		$groupings = array_keys($active);
		unset($active);

		$this->Level = "res";
		if(in_array("rv_reservation_item.pr_business_name",$groupings)) {
			$this->Level = "property";
		}
		if(in_array("rv_reservation_item.ac_accomm_type_name",$groupings)) {
			$this->Level = "accomm";
		}

		$this->DateGrouping = "none";

		$this->SpecialGrouping = false;
		if(in_array("sp_special.sp_special_desc",$groupings)) {
			$this->SpecialGrouping = array_search("sp_special.sp_special_desc",$groupings);
		}

		$this->AllocGrouping = false;
		if(in_array("rv_reservation_item.allocation_drawdown",$groupings)) {
			$this->AllocGrouping = true;
		}


		$defaultFields = array(
			"key_items",
			"fn_folio.fn_folio_ix",
			"fn_folio.fn_folio_date",
			"fn_folio.fn_folio_amount",
			"fn_folio.fn_folio_amt_paid",
			"fn_invoice.fn_invoice_ix",
			"fn_invoice.fn_inv_date"
		);

		if($grouping['rv_reservation.rv_reservation_ix']['active'] != 1) {
			$defaultFields[] = "rv_reservation.rv_reservation_ix";
		}

		if($this->Level == "res" || ($this->Level == "accomm" && $grouping['rv_reservation_item.pr_business_name']['active'] != 1)) {
			$defaultFields[] = "rv_reservation_item.pr_business_name";
		}

		if($this->GetParamValue("displayCurrency") == "gl") {
			$defaultFields[] = "fn_invoice.fn_inv_exch_rate_balance";
		}	
		$display = $this->GetParamValue("display");
		if ($display['sp_special.sp_special_note']['active'] == 1) {
			$defaultFields[] = "sp_special.sp_special_note";
		}
		if ($display['rv_special.special_override_user']['active'] == 1) {
			$defaultFields[] = "rv_special.special_override_user";
		}
		if ($display['rv_special.special_application_date']['active'] == 1) {
			$defaultFields[] = "rv_special.ad_create_date";
		}

		$sqlBuilder = new ReportSQLBuilder(
			$grouping,
			$this->Fields,
			$this->Joins['folio'],
			$defaultFields
		);

		$sql = new ReportSQL();
		$sql->AddFrom("fn_folio");
		$sql->AddFrom("LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8");
		$sql->Merge($sqlBuilder->SQL());
        $sql->AddFrom("LEFT JOIN pr_persona AS agent_persona ON agent_persona.pr_persona_ix = rv_reservation.rv_agent_id");		
        $sql->AddFrom("LEFT JOIN pr_persona AS originator_persona ON originator_persona.pr_persona_ix = rv_reservation.rv_origin_agent_id");
        $sql->AddFrom("LEFT JOIN pr_persona AS originator_linked_persona ON originator_linked_persona.pr_persona_ix = originator_persona.pr_persona_link_id");

        if($this->GetParamValue("displayCurrency") == "gl") {
			$sql->AddFrom("INNER JOIN fn_invoice AS gl_invoice ON gl_invoice.fn_folio_id = fn_folio.fn_folio_ix AND gl_invoice.fn_inv_status_ind <> 8");
		}

		$sql->AddWhere($this->ConcatParamSQL(array(
			"accomm",
			"status",
			"agent",
			"createdBy",
			"consultant",
			"nationality",
			"originator",
			"source",
			"paymentPlan",
			"rate",
			"folioContact",
			"server",
			"currencies",
			"agentPhysCountry",
			"agentPostCountry",
			"originatorPhysCountry",
			"originatorPostCountry"
		)));

		if($this->GetParamValue("excludeExpiredProv") == "1") {
			$sql->AddWhere("
				AND (
					(
						rv_reservation.rf_reservation_status_id != 20
					) OR (
						rv_reservation.rf_reservation_status_id = 20
						AND rv_reservation.rv_provision_expiry_date >= '".date("Y-m-d")."'
					)
				)
			");
		}

		$invoiceDateRange = $this->GetParam("invoiceDateRange");
		$sql->AddWhere($invoiceDateRange->SQL("
			AND (
				(
					fn_invoice.fn_invoice_ix IS NULL
					AND fn_folio.fn_folio_date BETWEEN '!fromDate!' AND '!toDate!'
				) OR (
					fn_invoice.fn_invoice_ix IS NOT NULL
					AND fn_invoice.fn_inv_date BETWEEN '!fromDate!' AND '!toDate!'
				)
			)
		"));
		unset($invoiceDateRange);

		if($this->GetParamValue("travelDateCheck") == "1") {
			$travelDateRange = $this->GetParam("travelDateRange");
			$sql->AddWhere($travelDateRange->SQL());
			unset($travelDateRange);
		}

		if($this->GetParamValue("createDateCheck") == "1") {
			$createDateRange = $this->GetParam("createDateRange");
			$sql->AddWhere($createDateRange->SQL("
				AND rv_reservation.rv_date_recorded BETWEEN '!fromDate!' AND '!toDate!'
			"));
			unset($createDateRange);
		}

		$param = $this->GetParam("statusDateCheck");
		if($this->GetParamValue("statusDateCheck") == "1") {
			$statusDateRange = $this->GetParam("statusDateRange");
			$sql->AddWhere($statusDateRange->SQL());
			unset($statusDateRange);
		}		

		if($this->GetParamValue("balanceCheck") == "1") {
			$where = array();

			if($this->GetParamValue("balanceTBACheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_accomm_payable IS NULL
					)
				";
			}

			if($this->GetParamValue("balanceUnpaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid = 0
					)
				";
			}

			if($this->GetParamValue("balancePartPaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid != 0
						AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > 0
					)
				";
			}

			if($this->GetParamValue("balancePaidCheck") == "1") {
				$where[] = "
					(
						(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) = 0
					)
				";
			}

			if($this->GetParamValue("balanceOverpaidCheck") == "1") {
				$where[] = "
					(
						rv_reservation.rv_amt_paid != 0
						AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < 0
					)
				";
			}

			list($balanceOwingByCheck,$balanceOwingByType,$balanceOwingByAmount) = explode(":",$this->GetParamValue("balanceOwingByCheck"));
			if($balanceOwingByCheck == "1") {
				if(preg_match("/%\s*$/",$balanceOwingByAmount)) {
					$amountSQL = "(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable) * " . str_replace("%","",$balanceOwingByAmount) / 100;
				} else {
					$amountSQL = $balanceOwingByAmount;
				}
				if($balanceOwingByType == "more") {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > $amountSQL
						)		
					";
				} else {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > 0
							AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < $amountSQL
						)
					";
				}
			}

			list($balanceOverpaidByCheck,$balanceOverpaidByType,$balanceOverpaidByAmount) = explode(":",$this->GetParamValue("balanceOverpaidByCheck"));
			if($balanceOverpaidByCheck == "1") {
				$balanceOverpaidByAmount *= -1;
				if($balanceOverpaidByType == "more") {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < $balanceOverpaidByAmount
						)		

					";
				} else {
					$where[] = "
						(
							(rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) < 0
							AND (rv_reservation.rv_amt_accomm_payable + rv_reservation.rv_amt_extra_payable + rv_reservation.rv_amt_travel_payable - rv_reservation.rv_amt_paid) > $balanceOverpaidByAmount
						)
					";
				}
			}
			
			if(sizeof($where) > 0) {
				$sql->AddWhere(" AND (" . join(" OR ",$where) . ")");
			}
			unset($where);
		}

		$invoicedCheck = $this->GetParamValue("invoicedCheck");
		$uninvoicedCheck = $this->GetParamValue("uninvoicedCheck");
		if($invoicedCheck || $uninvoicedCheck) {
			$where = array();
			if($invoicedCheck) {
				$where[] = "
					(
						fn_invoice.fn_invoice_ix IS NOT NULL
					)
				";
			}
			if($uninvoicedCheck) {
				$where[] = "
					(
						fn_invoice.fn_invoice_ix IS NULL
					)
				";
			}
			if(sizeof($where) > 0) {
				$sql->AddWhere(" AND (". join(" OR ",$where) . ")");
			}
			unset($where);
		}
		unset($invoicedCheck);
		unset($uninvoicedCheck);

		if($this->GetParamValue("folioBalanceCheck") == "1") {
			$where = array();

			if($this->GetParamValue("folioBalanceTBACheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn = '1'
					)
				";
			}

			if($this->GetParamValue("folioBalanceUnpaidCheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn <> '1'
						AND fn_folio.fn_folio_amt_paid = 0
					)
				";
			}

			if($this->GetParamValue("folioBalancePartPaidCheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn <> '1'
						AND fn_folio.fn_folio_amt_paid != 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
					)
				";
			}

			if($this->GetParamValue("folioBalancePaidCheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn <> '1'
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) = 0
					)
				";
			}

			if($this->GetParamValue("folioBalanceOverpaidCheck") == "1") {
				$where[] = "
					(
						fn_folio.fn_folio_amt_tba_yn <> '1'
						AND fn_folio.fn_folio_amt_paid != 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
					)
				";
			}

			list($folioBalanceOwingByCheck,$folioBalanceOwingByType,$folioBalanceOwingByValue) = explode(":",$this->GetParamValue("folioBalanceOwingByCheck"));
			if($folioBalanceOwingByCheck == "1") {
				if(preg_match("/%\s*$/",$folioBalanceOwingByValue)) {
					$amountSQL = "fn_folio.fn_folio_amount * " . str_replace("%","",$folioBalanceOwingByValue) / 100;
				} else {
					$amountSQL = $folioBalanceOwingByValue;
				}
				if($folioBalanceOwingByType == "more") {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $amountSQL
						)
					";
				} else {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $amountSQL
						)
					";
				}
			}
			list($folioBalanceOverpaidByCheck,$folioBalanceOverpaidByType,$folioOverpaidByValue) = explode(":",$this->GetParamValue("folioBalanceOverpaidByCheck"));
			if($folioBalanceOverpaidByCheck == "1") {
				$folioOverpaidByValue *= -1;
				if($folioBalanceOverpaidByType == "more") {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $folioOverpaidByValue
						)
					";
				} else {
					$where[] = "
						(
							fn_folio.fn_folio_amt_tba_yn <> '1'
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
							AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $folioOverpaidByValue
						)
					";
				}
			}

			if(sizeof($where) > 0) {
				$sql->AddWhere(" AND (". join(" OR ",$where) . ")");
			}
		}

		$from = array();
		$where = array();
		$itineraryJoin = "INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix";
		if($this->GetParamValue("reservationOverrideAmountCheck") == "1") {
			$reservationOverrideAmount = $this->GetParamValue("reservationOverrideAmount");
			if (in_array($reservationOverrideAmount, array(WITH_OVERRIDES, WITHOUT_OVERRIDES))) {
				if (in_array($itineraryJoin, $sql->Where) !==false) {
					$from[] = $itineraryJoin;
				}
				$from[] = "INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix";
				$from[] = "INNER JOIN rv_res_item_rate_grp ON rv_res_item_rate_grp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix";
			}
			switch ($reservationOverrideAmount) {
				case WITH_OVERRIDES:
					$where[] = "
						AND (
							rv_res_item_comp.rv_item_comp_var <> 0
							OR rv_reservation_item.rv_item_overide_amt IS NOT NULL
							OR rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NOT NULL
						)
					";
					break;
				case WITHOUT_OVERRIDES:
					$where[] = "
						AND (
							rv_res_item_comp.rv_item_comp_var = 0
							AND rv_reservation_item.rv_item_overide_amt IS NULL
							AND rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NULL
						)
					";
					break;
				default:
					break;
			}
		}
		if($this->GetParamValue("reservationOverrideRateTypeCheck") == "1") {
			$reservationOverrideRateType = $this->GetParamValue("reservationOverrideRateType");
			if (in_array($reservationOverrideRateType, array(WITH_OVERRIDES, WITHOUT_OVERRIDES)) || $this->GetParamValue("reservationAuthorisedForAgent") == "1" || $this->GetParamValue("reservationNotAuthorisedForAgent") == "1") {
				if (in_array($itineraryJoin, $sql->Where) !==false) {
					$from[] = $itineraryJoin;
				}
			}
			switch ($reservationOverrideRateType) {
				case WITH_OVERRIDES:
					$where[] = "AND (rv_reservation.rt_rate_type_id != rv_reservation_item.rt_rate_type_id)";
					break;
				case WITHOUT_OVERRIDES:
					$where[] = "AND (rv_reservation.rt_rate_type_id = rv_reservation_item.rt_rate_type_id)";
					break;
				default:
					break;
			}
			if($this->GetParamValue("reservationAuthorisedForAgent") == "1") {
				$sql->Distinct = true;
				$from[] = "LEFT JOIN pr_agent_rate ON pr_agent_rate.pr_agent_id = rv_reservation.rv_agent_id AND pr_agent_rate.rt_rate_type_id = rv_reservation_item.rt_rate_type_id";
				$where[] = "AND pr_agent_rate.pr_agent_rate_ix IS NOT NULL";
			}
			if($this->GetParamValue("reservationNotAuthorisedForAgent") == "1") {
				$sql->Distinct = true;
				$from[] = "LEFT JOIN pr_agent_rate ON pr_agent_rate.pr_agent_id = rv_reservation.rv_agent_id AND pr_agent_rate.rt_rate_type_id = rv_reservation_item.rt_rate_type_id AND rv_reservation.rv_agent_id != '0'";
				$where[] = "AND pr_agent_rate.pr_agent_rate_ix IS NULL";
			}
		}
		if($this->GetParamValue("reservationOverrideVarianceCheck") == "1") {
			$reservationOverrideVariance = $this->GetParamValue("reservationOverrideVariance");
			if (in_array($reservationOverrideVariance, array(WITH_OVERRIDES, WITHOUT_OVERRIDES))) {
				if (in_array($itineraryJoin, $sql->Where) !==false) {
					$from[] = $itineraryJoin;
				}
				$from[] = "INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix";
			}
			switch ($reservationOverrideVariance) {
				case WITH_OVERRIDES:
					$where[] = "AND (rv_res_item_comp.rv_item_comp_var <> 0 AND rv_res_item_comp.rv_item_comp_var IS NOT NULL)";
					break;
				case WITHOUT_OVERRIDES:
					$where[] = "AND (rv_res_item_comp.rv_item_comp_var = 0 OR rv_res_item_comp.rv_item_comp_var IS NULL)";
					break;
				default:
					break;
			}
		}
		if($this->GetParamValue("reservationOverrideCommissionCheck") == "1") {
			$reservationOverrideCommission = $this->GetParamValue("reservationOverrideCommission");
			if (in_array($reservationOverrideCommission, array(WITH_OVERRIDES, WITHOUT_OVERRIDES))) {
				$from[] = "LEFT JOIN pr_agent ON pr_agent.pr_agent_id = rv_reservation.rv_agent_id";
				switch ($reservationOverrideCommission) {
					case WITH_OVERRIDES:
						$where[] = "
							AND (
								(
									pr_agent.pr_agent_id IS NULL
									AND rv_reservation.rv_commission_perc != 0
								) OR (
									pr_agent.pr_agent_id IS NOT NULL
									AND rv_reservation.rv_commission_perc != pr_agent.pr_agent_commission_perc
								)
							)
						";
						break;
					case WITHOUT_OVERRIDES:
						$where[] = "
							AND (
								(
									pr_agent.pr_agent_id IS NULL
									AND rv_reservation.rv_commission_perc = 0
								) OR (
									pr_agent.pr_agent_id IS NOT NULL
									AND rv_reservation.rv_commission_perc = pr_agent.pr_agent_commission_perc
								)
							)
						";
						break;

				}
			}
		}
		if($this->GetParamValue("specialsDiscountCheck") == "1") {
			$where[] = "
				AND (
					rv_reservation_item.rv_item_amt_sp_discount != 0
				)		
			";
		}
		if($this->GetParamValue("reservationSpecialIncludeCheck") == "1") {
			if ($grouping['sp_special.sp_special_desc']['active'] != 1) {
				$from[] = "LEFT JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix";
			}
			$reservationSpecialInclude = $this->GetParamValue("reservationSpecialInclude");
			switch ($reservationSpecialInclude) {
				case WITH_SPECIALS:
					$where[] = "AND (rv_special.sp_special_id IS NOT NULL AND rv_special.sp_special_id != '')";
					break;
				case WITHOUT_SPECIALS:
					$where[] = "AND (rv_special.sp_special_id IS NULL OR rv_special.sp_special_id = '')";
					break;
				default:
					break;
			}
		}

        if (trim($this->GetParamValue("resNameNumberVoucher")) != "") {
            $where[] = "
                AND (
                    rv_reservation.rv_res_name LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
                    OR rv_reservation.rv_reservation_ix LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
                    OR rv_reservation.rv_agent_ref LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
                    OR rv_reservation.rv_cancel_reason LIKE '%" . $GLOBALS['lDB']->escape(trim($this->GetParamValue("resNameNumberVoucher"))) . "%'
                )
            ";
        }

		if($this->GetParamValue("allocationCheck") == "1") {
				if (in_array($itineraryJoin, $sql->Where) !==false) {
					$from[] = $itineraryJoin;
				}
		}


		$sql->AddWhere($this->ConcatParamSQL(array(
			"specials"
		)));
		if($this->GetParamValue("specials") != null && $grouping['sp_special.sp_special_desc']['active'] != 1) {
			$from[] = "LEFT JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix";
			$from[] = "LEFT JOIN sp_special ON sp_special.sp_special_ix = rv_special.sp_special_id";
		}
		if(sizeof($from) > 0) {
			$sql->AddFrom(array_unique($from));
		}
		unset($from);
		if(sizeof($where) > 0) {
			$sql->AddWhere(array_unique($where));
		}
		unset($where);

		$data = $sql->Run();

		$sqlBuilder->Render($data,$groupings);

		// TODO: Add a feature to the renderer to remove this
		foreach($data as $key=>$item) {
			if(is_array($item['rv_reservation_item.pr_business_name_key'])) {
				$data[$key]['rv_reservation_item.pr_business_name_key'] = $item['rv_reservation_item.pr_business_name_key'][0];
			}
			foreach($defaultFields as $field) {
				if($field != "key_items" && $field != "rv_reservation_item.pr_business_name") {
					unset($data[$key][$field]);
				}
			}
		}

		$this->GroupColumns = $sqlBuilder->getFields();

		if(
			$this->GetParamValue("extraPropertyCheck") == "1"
			&& $this->GetParamValue("extraNonPropertyCheck") == "1"
			&& ($this->Level == "property" || $this->Level == "accomm")
		) {
			$newData = array();
			$keys = array();
			foreach($data as $key=>$item) {
				$newData[$key] = $item;

				$item['non_property_specific'] = true;
				if(isset($item['rv_reservation_item.pr_business_name_key'])) {
					$item['rv_reservation_item.pr_business_name_key'] = "0";
					$item['rv_reservation_item.pr_business_name'] = "None";
					$item['rv_reservation_item.pr_business_name_sort'] = "";
				}
				if(isset($item['rv_reservation_item.ac_accomm_type_name_key'])) {
					$item['rv_reservation_item.ac_accomm_type_name_key'] = "0";
					$item['rv_reservation_item.ac_accomm_type_name'] = "None";
					$item['rv_reservation_item.ac_accomm_type_name_sort'] = "";
				}
				$keyArray = explode("_",$key);
				$count=0;
				foreach($groupings as $group) {
					if(
						$group == "rv_reservation_item.pr_business_name"
						|| $group == "rv_reservation_item.ac_accomm_type_name"
					) {
						$keyArray[$count] = "0";
					}
					$count++;
				}

				$key = join("_",$keyArray);
				if(!in_array($key,$keys)) {
					$newData[$key] = $item;
					$keys[] = $key;
				} else {
					$newData[$key]['key_items'] = array_merge($newData[$key]['key_items'],$item['key_items']);
				}
			}
			$data = $newData;
			unset($newData);
		}		

		$found = false;
		foreach($this->GroupColumns as $col) {
			if(!isset($col['active']) || $col['active'] != "1") { continue; }
			$found = true;
			$this->AddColumn($col['name'],"Grouping",$col,"outLt");
		}
		if(!$found) {
			$this->AddColumn("all","Grouping",array(
				'format'=>"",
				'cols'=>array(
					'label'=>array('value'=>"All"),
					'width'=>array('value'=>"60")
				),
			),"outLt");
			foreach($data as $key=>$item) {
				$data[$key]['all'] = "All";
			}
		}
		$this->Data = $data;
	}

	function FilterPerFolio($items,$startDate,$endDate,$dateGroup=false) {
		$new = array();
		foreach($items as $id=>$folio) {
			if($folio['fn_date'] >= $startDate && $folio['fn_date'] <= $endDate) {
				$new[$id] = $folio;
			}
		}

		return $new;
	}

	function BuildSpecials() {
		global $lDB;


		foreach($this->Data as $groupKey=>$group) {
			
			$specialSQL = new ReportSQL();
			
			$specialSQL->AddSelect(array(
				"rv_reservation_item.$this->KeyField",
				"rv_special.rv_special_ix",
				"sp_special.sp_special_note",
				"special_override_persona.pr_name_first AS special_override_name_first",
				"special_override_persona.pr_name_last AS special_override_name_last",
				"rv_reservation.rv_sp_override_yn",
				"rv_reservation.rv_sp_override_date",
				"rv_special.ad_create_date",
				"rv_res_item_special.rv_sp_amt_discount"
			));

			$specialSQL->AddFrom(array(
				"rv_reservation_item",
				"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",
				"INNER JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix",
				"INNER JOIN sp_special ON sp_special.sp_special_ix = rv_special.sp_special_id",
				"INNER JOIN rv_res_item_special ON
					rv_res_item_special.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					AND rv_res_item_special.sp_special_id = sp_special.sp_special_ix",
				"LEFT JOIN pr_persona special_override_persona ON special_override_persona.pr_persona_ix = rv_reservation.rv_sp_override_user_id",
			));
			if($this->Level == "property") {
				$specialSQL->AddWhere("AND rv_reservation_item.pr_business_id = '" . $group['rv_reservation_item.pr_business_name_key'] . "'");
			} elseif($this->Level == "accomm") {
				$specialSQL->AddWhere("AND rv_reservation_item.ac_accomm_type_id = '" . $group['rv_reservation_item.ac_accomm_type_name_key'] . "'");
			}

			$specialSQL->AddWhere("AND rv_reservation_item.$this->KeyField IN ('".join("','",$this->Keys)."')");
			if(array_key_exists("sp_special.sp_special_desc_key", $group)) {
				$specialSQL->AddWhere("AND sp_special.sp_special_ix = '" . $group['sp_special.sp_special_desc_key'] . "'");
			}


			$specials = $specialSQL->Run();
			$newSpecials = array();
			foreach($specials as $special) {
				$newSpecials[$special['rv_special_ix']] = $special;
			}
			$specials = $newSpecials;
			unset($newSpecials);
			foreach($specials as $special) {
				$id = $special[$this->KeyField];
				if(array_key_exists($id, $this->Data[$groupKey]['key_items'])) {
					$this->Data[$groupKey]['key_items'][$id]['specials'][] = $special;
				}
			}
		}
	}

	function Build() {
		$this->ReservationCountType = "revenue";
		if(
			!$this->GetParam("display")->FieldHasPropertyValue("requirements", "itineraries")
			&& !$this->GetParam("display")->FieldHasPropertyValue("requirements", "extras")
			&& !$this->GetParam("display")->FieldHasPropertyValue("requirements", "payments")
		) {
			$this->ReservationCountType = "reservation";
		}

		$this->KeyField = "fn_folio_id";
		$this->DisplayFilter = "FilterPerFolio";
		$this->AmountType = $this->GetParamValue("commission");

		$this->CSVFilters = array(
			"invoiceDateRange",
		);

		$param = $this->GetParam("travelDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("travelDateRange",$param->Filter['label']);
		}
		unset($param);

		$param = $this->GetParam("createDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("createDateRange",$param->Filter['label']);
		}
		unset($param);

		$param = $this->GetParam("statusDateCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("statusDateRange",$param->Filter['label']);
		}
		unset($param);
		
		$this->CSVFilters = array_merge($this->CSVFilters,array(
			"status",
			"excludeExpiredProv",
			"agent",
			"createdBy",
			"consultant",
			"nationality",
			"originator",
			"source",
			"paymentPlan",
			"rate",
			"agentPhysCountry",
			"agentPostCountry",
			"originatorPhysCountry",
			"originatorPostCountry"
		));

		$param = $this->GetParam("balanceCheck");
		if($param->Value == "1") {
			$label = $param->Filter['label'];
			$value = array();
			$items = array("balanceTBACheck","balancePaidCheck","balanceOwingByCheck","balanceOverpaidByCheck");
			foreach($items as $item) {
				$param = $this->GetParam($item);
				list($paramValue,$paramDirection,$paramAmount) = array_pad( explode(":",$param->Value), 3, '' );

				if($paramValue == "1") {
					$paramLabel = $param->Filter['label'];
					if(!empty($paramDirection)) {
						$paramLabel .= " $paramDirection than $paramAmount";
					}
					$value[] = $paramLabel;
				}
			}
			$this->CSVFilters[] = array(false,$label,join(", ",$value));
		}
		unset($param);

		$this->CSVFilters = array_merge($this->CSVFilters,array(
			"folioContact",
			"server",
			"invoicedCheck",
			"uninvoicedCheck"
		));

		$param = $this->GetParam("folioBalanceCheck");
		if($param->Value == "1") {
			$label = $param->Filter['label'];
			$value = array();
			$items = array("folioBalanceTBACheck","folioBalancePaidCheck","folioBalanceOwingByCheck","folioBalanceOverpaidByCheck");
			foreach($items as $item) {
				$param = $this->GetParam($item);
				list($paramValue,$paramDirection,$paramAmount) = array_pad( explode(":",$param->Value), 3, '' );

				if($paramValue == "1") {
					$paramLabel = $param->Filter['label'];
					if(!empty($paramDirection)) {
						$paramLabel .= " $paramDirection than $paramAmount";
					}
					$value[] = $paramLabel;
				}
			}
			$this->CSVFilters[] = array(false,$label,join(", ",$value));
		}
		unset($param);		

		$this->CSVFilters = array_merge($this->CSVFilters,array(
			"accomm",
			"extraPropertyCheck",
			"extraNonPropertyCheck",
			"rateGroupSplit",
			"rateComponent",
			"extraCategory",
			"currencies",
			"specials"
		));

		$param = $this->GetParam("numberProperties");
		list($number, $operator) = explode(":",$param->Value);
		if(is_numeric($number)) {
			$text = getOperatorFilterText($operator) . " " . $number;
			$this->CSVFilters[] = array(false, $param->Filter['label'], $text);
		}
		unset($param);

		$param = $this->GetParam("numberNights");
		list($number, $operator) = explode(":",$param->Value);
		if(is_numeric($number)) {
			$text = getOperatorFilterText($operator) . " " . $number;
			$this->CSVFilters[] = array(false, $param->Filter['label'], $text);
		}
		unset($param);

		$param = $this->GetParam("numberPax");
		list($number, $operator) = explode(":",$param->Value);
		if(is_numeric($number)) {
			$text = getOperatorFilterText($operator) . " " . $number;
			$this->CSVFilters[] = array(false, $param->Filter['label'], $text);
		}
		unset($param);

		$param = $this->GetParam("reservationSpecialIncludeCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("reservationSpecialIncludeCheck",$param->Filter['label']);
		}
		unset($param);
		$param = $this->GetParam("specialsDiscountCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("specialsDiscountCheck","Reservation has special discount");
		}
		unset($param);
		$param = $this->GetParam("specialsDiscountAccCheck");
		if($param->Value == "1") {
			$this->CSVFilters[] = array("specialsDiscountAccCheck","Rate groups has special discount");
		}
		unset($param);

		if($this->GetParamValue("displayCurrency") == "gl") {
			foreach($this->Fields as $key=>$field) {
				if($field['name'] == "fn_folio.rf_currency_symbol") {
					$this->Fields[$key] = array('name'=>"fn_folio.rf_currency_symbol",'type'=>"string",'fields'=>array("gl_currency.rf_currency_symbol"),'key'=>"gl_currency.rf_currency_ix");
					break;
				}
			}
		}

		$this->BuildGrouping();
		$this->BuildKeys();
		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "extras")) {
			$this->BuildExtras();
		}
		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "payments")) {
			$this->BuildPayments();
		}
		if ($this->GetParam("display")->FieldHasPropertyValue("requirements", "itineraries")) {
			$this->BuildItineraries();
		}
		$this->BuildSpecials();

		$this->BuildMonths("invoiceDateRange");

		$this->BuildReference();

		$monthTotalClass = "txtb";
		if($this->GetParamValue("dayTotal") != 1) {
			$monthTotalClass = "";
		}
		$yearTotalClass = "txtb";
		if($this->GetParamValue("dayTotal") != 1 && $this->GetParamValue("monthTotal") != 1) {
			$yearTotalClass = "";
		}

		$lastYear = $this->Dates[0]['year'];
		$lastYearStart = $this->Dates[0]['start'];
		$lastYearEnd = $this->findYearEnd($lastYear);
		foreach($this->Dates as $date) {
			if($lastYear != $date['year'] && $this->GetParamValue("yearTotal") == 1) {
				$this->BuildDisplay($lastYear,$lastYear . " Totals",$lastYearStart,$lastYearEnd);
				$lastYear = $date['year'];
				$lastYearStart = $date['start'];
				$lastYearEnd = $this->findYearEnd($lastYear);
			}

			if($this->GetParamValue("dayTotal") == 1) {
				foreach($date['days'] as $day) {
					$prefix = str_replace(" ","_",strtolower($day['name']));
					$this->BuildDisplay($prefix,$day['label'],$day['start'],$day['end']);
				}
			}

			if($this->GetParamValue("monthTotal") == 1) {
				$prefix = str_replace(" ","_",strtolower($date['name']));
				$this->BuildDisplay($prefix,$date['name'],$date['start'],$date['end'],$monthTotalClass);
			}
		}
		if($lastYear !== false && $this->GetParamValue("yearTotal") == 1) {
			$this->BuildDisplay($lastYear,$lastYear . " Totals",$lastYearStart,$lastYearEnd,$yearTotalClass);
		}

		$this->BuildDisplay("total","Group Totals",$this->Dates[0]['start'],$this->Dates[sizeof($this->Dates)-1]['end'],"txtb");

		$this->BuildTotals();

		if($this->GetParamValue("includeZeroRows") != "1") {
			$this->RemoveZeroRows();
		}		

		if($this->GetParamValue("includeZeroColumns") != "1") {
			$this->RemoveZeroColumns();
		}		

		$this->SortData();

		if($this->GetParamValue("grandTotal") != 1) {
			$this->RemoveGrandTotals();
		}
		

		$this->BuildFormat();

		//debug($this->Columns);
		//debug($this->Data);
		//debug($this->Totals);
		//debug($this->Reference);
	}	
}


