<?php

require_once(__DIR__ . "/functions.reservation.php");

class FinancialAnalysisReport extends Report {
	var $Fields;
	var $Joins;
	var $Columns;
	var $Keys;
	var $GroupKeys;
	var $CSVFilters;
	var $GeneralNotification;

	function Config() {
		$this->Fields = array();
		$this->Joins = array();
		$this->Columns = array();
		$this->Keys = array();
		$this->GroupKeys = array();
		$this->CSVFilters = array();
		$this->Potential = false;
		$this->GeneralNotification = array();

		// Set any global Report properties
		$this->FilterWidths['label'] = "150";
		$this->FilterWidths['button'] = "130";
	}

	function BuildExtras() {
		global $lDB;
		// Get extras for all items	

		$extraSQL = new ReportSQL();
		$extraSQL->AddSelect(array(
			"rv_extra.rv_extra_ix",
			"pr_business.pr_business_id",
			"rv_extra.$this->KeyField",
			"rv_extra.rv_extra_date_serv",
			"ac_extra.ac_extra_ix",
			"ac_extra.ac_ext_desc",
			"ac_extra_category.ac_extra_category_ix",
			"ac_extra_category.ac_extra_cat_desc",
			"ac_extra_category.ac_extra_cat_ind",
			"'extra' AS rf_tax_rate_type",
			"rv_extra.rf_tax_id",
			"rv_extra.rv_extra_tax_ind",
			"rf_tax_rate.rf_tax_rate_desc",
			"rv_extra.rv_extra_ix AS extra_id"
		));


		if($this->GetParamValue("displayCurrency") != "gl") {
			$extraSQL->AddSelect(array(
				"rv_extra.rv_extra_amt_comm",
				"rv_extra.rv_extra_amt_gross",
				"rv_extra.rv_extra_amt_nett",
				"rv_extra.rv_extra_amt_payable",
				"(SELECT SUM(rv_extra_tax_amt) FROM rv_extra_tax WHERE rv_extra_tax.rv_extra_id = extra_id) as rv_extra_amt_tax",
				"rv_extra.rv_extra_comm_rec",
				"rv_extra.rv_extra_inv_curr_id"
			));
		} else {
			$extraSQL->AddSelect(array(
				"rv_extra.rv_extra_amt_comm * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_amt_comm",
				"rv_extra.rv_extra_amt_gross * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_amt_gross",
				"rv_extra.rv_extra_amt_nett * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_amt_nett",
				"rv_extra.rv_extra_amt_payable * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_amt_payable",
				"(SELECT SUM(rv_extra_tax_amt) FROM rv_extra_tax WHERE rv_extra_tax.rv_extra_id = extra_id) * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_amt_tax",
				"rv_extra.rv_extra_comm_rec * fn_invoice.fn_inv_exch_rate_balance AS rv_extra_comm_rec",
				"pr_business_folio.pr_bus_home_curr_id AS rv_extra_inv_curr_id",
				"fn_invoice.fn_inv_exch_rate_balance"
			));
		}

		$extraSQL->AddFrom(array(
			"rv_extra",
			"INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id",
			"INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id",
			"INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id",
			"LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id",
			"LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id"
		));
		if($this->GetParamValue("displayCurrency") == "gl") {
			$extraSQL->AddFrom(array(
				"INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8",
				"INNER JOIN pr_business AS pr_business_folio ON pr_business_folio.pr_business_id = fn_folio.pr_business_id"
			));
		}
		$extraSQL->AddWhere("AND rv_extra.$this->KeyField IN ('".join("','",$this->Keys)."')");
		$extraSQL->AddWhere("AND rv_extra.rv_extra_void_ind = '0'");
		$extraSQL->AddWhere($this->GetParamSQL("extraCategory"));
		$extraSQL->AddWhere($this->GetParamSQL("extra"));
		$extraSQL->AddWhere($this->GetParamSQL("currencies"));

		$extraDateRange = false;
		if($this->GetParamValue("extraDateCheck") == "1") {
			$extraDateRange = $this->GetParam("extraDateRange");
		} else {
			if($this->Name == "financial_analysis_day" || $this->GetParamValue("travelDateCheck") == "1") {
				$extraDateRange = $this->GetParam("travelDateRange");
			}
		}
		if($extraDateRange !== false) {
			$extraSQL->AddWhere($extraDateRange->SQL("AND rv_extra.rv_extra_date_serv >= '!fromDate!' AND rv_extra.rv_extra_date_serv <= '!toDate!'"));
			unset($extraDateRange);
		}

		if($this->GetParamValue("extraPropertyCheck") == "1") {
			$where = array();

			$accommFilter = $this->GetParam("accomm");
			$propertyIds = $lDB->get("
				SELECT DISTINCT pr_business_id FROM ac_accomm_type WHERE 1 " .$accommFilter->SQL("AND ac_accomm_type.ac_accomm_type_ix IN !whereIds!")."
			",3);
			if(sizeof($propertyIds) > 0) {
				$where[] = "rv_extra.pr_business_id IN ('".join("','",$propertyIds)."')";
			}
			unset($accommFilter);
			unset($propertyIds);
			
			if($this->GetParamValue("extraNonPropertyCheck") == "1") {
				$where[] = "pr_business.pr_business_id IS NULL";
			}

			if(sizeof($where) > 0) {
				$extraSQL->AddWhere(" AND (". join(" OR ",$where) . ")");
			}
			unset($where);			
		}

		$extras = $extraSQL->Run();
		unset($extraSQL);

		$newExtras = array();
		$count = 0;
		foreach($extras as $key => $extra) {
			$glTaxExhange = $this->GetParamValue("displayCurrency") == "gl" ? $extra['fn_inv_exch_rate_balance'] : 1;
			if ($extra['rv_extra_tax_ind'] == 20) {
				$taxRates = $lDB->get("
					SELECT
						rv_extra_tax.rf_tax_rate_id,
						rv_extra_tax.rv_extra_tax_perc,
						rv_extra_tax.rv_extra_tax_amt * " . $glTaxExhange . " AS rv_extra_tax_amt,
						rf_tax_rate.rf_tax_rate_desc
					FROM
						rv_extra_tax
						LEFT JOIN rf_tax_rate on rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
					WHERE
						rv_extra_tax.rv_extra_id = '".$extra['rv_extra_ix']."'
				",2);
				$firstRate = true;
				foreach ($taxRates as $taxRate) {
					$newExtras[$count] = $extra;
					$newExtras[$count]['rf_tax_id'] = $taxRate['rf_tax_rate_id'];
					$newExtras[$count]['rf_tax_rate_desc'] = $taxRate['rf_tax_rate_desc'];
					$newExtras[$count]['rv_extra_amt_tax'] = $taxRate['rv_extra_tax_amt'];
					if (!$firstRate) {
						$newExtras[$count]['rv_extra_amt_comm'] = 0;
						$newExtras[$count]['rv_extra_amt_gross'] = 0;
						$newExtras[$count]['rv_extra_amt_nett'] = 0;
						$newExtras[$count]['rv_extra_amt_payable'] = 0;
						$newExtras[$count]['rv_extra_comm_rec'] = 0;
					}
					$count++;
					$firstRate = false;
				}
			} else {
				$newExtras[$count] = $extra;
				$count++;
			}
		}
		unset($extras);
		$extras = $newExtras;
		unset($newExtras);

		foreach($extras as $extra) {
			$id = $extra[$this->KeyField];
			$this->GroupKeys[$id] = isset($this->GroupKeys[$id]) ? $this->GroupKeys[$id] : array();
			foreach($this->GroupKeys[$id] as $key) {
				$item = $this->Data[$key];
				if(
					(
						(
							$this->Level == "res"
						) || (
							($this->Level == "property" || $this->Level == "accomm")
							&& (
								$extra['pr_business_id'] == $item['rv_reservation_item.pr_business_name_key']
								|| (
									empty($extra['pr_business_id']) && isset($item['non_property_specific'])
								)
							)
							
						)
					) && (
						(
							!isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
						) || (
							isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
							&& $extra['rv_extra_inv_curr_id'] == $this->Data[$key]['fn_folio.rf_currency_symbol_key']
						)
					)
				) {
					$this->Data[$key]['key_items'][$id]['extras'][] = $extra;
				}
			}
		}
		unset($extras);
	}

	function BuildPayments() {
		// Get payments for all keys (if not property level)
		$paymentSQL = new ReportSQL();
		$paymentSQL->AddSelect(array(
			"rv_payment_item.rv_payment_item_ix",
			"rv_payment.rv_payment_ix",
			"rv_payment.rv_pmnt_date",
			"rv_payment_item.$this->KeyField",
			"rf_bank.rf_bank_ix",
			"rf_bank.rf_bank_acc_name"
		));
		if($this->GetParamValue("displayCurrency") != "gl") {
			$paymentSQL->AddSelect(array(
				"rv_payment_item.rv_payment_item_amt",
				"rv_payment_item.rf_currency_id"
			));
		} else {
			$paymentSQL->AddSelect(array(
				"rv_payment_item.rv_payment_item_amt * fn_invoice.fn_inv_exch_rate_balance AS rv_payment_item_amt",
				"pr_business_folio.pr_bus_home_curr_id AS rf_currency_id"
			));
		}
		$paymentSQL->AddFrom(array(
			"rv_payment_item",
			"INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id",
			"INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id",
			"INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id"
		));
		if($this->GetParamValue("displayCurrency") == "gl") {
			$paymentSQL->AddFrom(array(
				"INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8",
				"INNER JOIN pr_business AS pr_business_folio ON pr_business_folio.pr_business_id = fn_folio.pr_business_id"
			));
		}
		$paymentSQL->AddWhere("AND rv_payment_item.$this->KeyField IN ('".join("','",$this->Keys)."')");
		$paymentSQL->AddWhere($this->GetParamSQL("currencies"));

		$paymentDateRange = false;
		if($this->GetParamValue("paymentDateCheck") == "1") {
			$paymentDateRange = $this->GetParam("paymentDateRange");
		} else {
			if($this->Name == "financial_analysis_day") {
				$paymentDateRange = $this->GetParam("travelDateRange");
			}
		}
		if($paymentDateRange !== false) {
			$paymentSQL->AddWhere($paymentDateRange->SQL("AND rv_payment.rv_pmnt_date >= '!fromDate!' AND rv_payment.rv_pmnt_date <= '!toDate!'"));
			unset($paymentDateRange);
		}
		
		$payments = $paymentSQL->Run();
		unset($paymentSQL);

		foreach($payments as $payment) {
			$id = $payment[$this->KeyField];
			foreach($this->GroupKeys[$id] as $key) {
				if(
					!isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
					|| (
						isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
						&& $payment['rf_currency_id'] == $this->Data[$key]['fn_folio.rf_currency_symbol_key']
					)
				) {
					$this->Data[$key]['key_items'][$id]['payments'][] = $payment;
				}
			}
		}		
		unset($payments);
	}	

	function BuildItineraries($where=false) {
		global $lDB;
		
		// Get itineraries for all items
		$itinerarySQL = new ReportSQL();
		
		$itinerarySQL->AddSelect(array(
			"rv_reservation_item.rv_reservation_id",
			"rv_reservation_item.rv_reservation_item_ix",
			"rv_reservation_item.$this->KeyField",
			"rv_reservation_item.pr_business_id",
			"rv_reservation_item.ac_accomm_type_id",
			"rv_reservation_item.rv_item_date_arrive",
			"rv_reservation_item.rv_item_date_depart",
			"rv_reservation_item.rv_item_nights",
			"rv_reservation_item.rv_item_accomm_count",
			"rv_reservation_item.rv_item_adult_count",
			"rv_reservation_item.rv_item_child_count",
			"rv_reservation_item.rt_rate_type_id",
			"ac_accomm_type.pr_business_id",
			"pr_persona.pr_name_last"
		));
		if($this->GetParamValue("displayCurrency") != "gl") {
			$itinerarySQL->AddSelect(array(
				"fn_folio.rf_currency_id",
				"rv_reservation_item.rv_item_amt_comm",
				"rv_reservation_item.rv_item_amt_" . $this->AmountType . " AS rv_item_amt",
			));
		} else {
			$itinerarySQL->AddSelect(array(
				"pr_business_folio.pr_bus_home_curr_id AS rf_currency_id",
				"rv_reservation_item.rv_item_amt_comm * fn_invoice.fn_inv_exch_rate_balance AS rv_item_amt_comm",
				"rv_reservation_item.rv_item_amt_" . $this->AmountType . " * fn_invoice.fn_inv_exch_rate_balance AS rv_item_amt"
			));
		}

		$itinerarySQL->AddFrom(array(
			"rv_reservation_item",
			"INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id",
			"LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id",
			"INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id",
			"INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id"
		));
		if($this->GetParamValue("displayCurrency") == "gl") {
			$itinerarySQL->AddFrom(array(
				"INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8",
				"INNER JOIN pr_business AS pr_business_folio ON pr_business_folio.pr_business_id = fn_folio.pr_business_id"
			));
		}

		$itinerarySQL->AddWhere("AND rv_reservation_item.$this->KeyField IN ('".join("','",$this->Keys)."')");

		$accommFilter = $this->GetParam("accomm");
		$itinerarySQL->AddWhere($accommFilter->SQL());
		unset($accommFilter);

		$rateAccommFilter = $this->GetParam("rateAccomm");
		$itinerarySQL->AddWhere($rateAccommFilter->SQL("AND rv_reservation_item.rt_rate_type_id IN !whereIds!"));
		unset($rateAccommFilter);

		$currencyFilter = $this->GetParam("currencies");
		$itinerarySQL->AddWhere($currencyFilter->SQL("AND rv_reservation.rv_invoice_currency_id IN !whereIds!"));
		unset($currencyFilter);
		if($this->GetParamValue("specialsDiscountAccCheck") == "1") {
			$itinerarySQL->AddFrom(array(
				"INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix",
				"INNER JOIN rv_res_item_comp_rate_grp ON rv_res_item_comp_rate_grp.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix"
			));
			$itinerarySQL->AddWhere("
				AND (
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount != 0
				)		
			");
		}

		$overrideFrom = array();
		$overrideWhere = array();
		if($this->GetParamValue("revenueOverrideAmountCheck") == "1") {
			$revenueOverrideAmount = $this->GetParamValue("revenueOverrideAmount");
			if (in_array($revenueOverrideAmount, array(1, 2))) {
				$overrideFrom[] = "INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix";
				$overrideFrom[] = "INNER JOIN rv_res_item_rate_grp ON rv_res_item_rate_grp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix";
			}
			switch ($revenueOverrideAmount) {
				case '1':
					$overrideWhere[] = "
						AND (
							rv_res_item_comp.rv_item_comp_var <> 0
							OR rv_reservation_item.rv_item_overide_amt IS NOT NULL
							OR rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NOT NULL
						)
					";
					break;
				case '2':
					$overrideWhere[] = "
						AND (
							rv_res_item_comp.rv_item_comp_var = 0
							AND rv_reservation_item.rv_item_overide_amt IS NULL AND rv_res_item_rate_grp.rv_res_item_rate_grp_overide_amt IS NULL
						)
					";
					break;
				default:
					break;
			}
		}
		if($this->GetParamValue("revenueOverrideRateTypeCheck") == "1") {
			$revenueOverrideRateType = $this->GetParamValue("revenueOverrideRateType");
			switch ($revenueOverrideRateType) {
				case '1':
					$overrideWhere[] = "AND (rv_reservation.rt_rate_type_id != rv_reservation_item.rt_rate_type_id)";
					break;
				case '2':
					$overrideWhere[] = "AND (rv_reservation.rt_rate_type_id = rv_reservation_item.rt_rate_type_id)";
					break;
				default:
					break;
			}
			if($this->GetParamValue("revenueAuthorisedForAgent") == "1") {
				$itinerarySQL->Distinct = true;
				$overrideFrom[] = "LEFT JOIN pr_agent_rate ON pr_agent_rate.pr_agent_id = rv_reservation.rv_agent_id AND pr_agent_rate.rt_rate_type_id = rv_reservation_item.rt_rate_type_id";
				$overrideWhere[] = "AND pr_agent_rate.pr_agent_rate_ix IS NOT NULL";
			}
			if($this->GetParamValue("revenueNotAuthorisedForAgent") == "1") {
				$itinerarySQL->Distinct = true;
				$overrideFrom[] = "LEFT JOIN pr_agent_rate ON pr_agent_rate.pr_agent_id = rv_reservation.rv_agent_id AND pr_agent_rate.rt_rate_type_id = rv_reservation_item.rt_rate_type_id AND rv_reservation.rv_agent_id != '0'";
				$overrideWhere[] = "AND pr_agent_rate.pr_agent_rate_ix IS NULL";
			}
		}
		if($this->GetParamValue("revenueOverrideVarianceCheck") == "1") {
			$revenueOverrideRateType = $this->GetParamValue("revenueOverrideVariance");
			switch ($revenueOverrideRateType) {
				case '1':
					$overrideWhere[] = "AND (rv_reservation.rt_rate_type_id != rv_reservation_item.rt_rate_type_id)";
					break;
				case '2':
					$overrideWhere[] = "AND (rv_reservation.rt_rate_type_id = rv_reservation_item.rt_rate_type_id)";
					break;
				default:
					break;
			}
		}
		if(count($overrideFrom) > 0) {
			array_unique($overrideFrom);
			$itinerarySQL->AddFrom(join(" ", $overrideFrom));
		}
		unset($overrideFrom);
		if(count($overrideWhere) > 0) {
			array_unique($overrideWhere);
			$itinerarySQL->AddWhere(join(" ",$overrideWhere));
		}



		$itinerarySQL->AddWhere($where);
		unset($where);
		
		$itineraries = $itinerarySQL->Run();

		$allocationDrawdownCheck = ($this->GetParamValue("allocationDrawdownCheck") == "1");
		$allocationBlockDrawdownCheck = ($this->GetParamValue("allocationBlockDrawdownCheck") == "1");
		$allocationNoDrawdownCheck = ($this->GetParamValue("allocationNoDrawdownCheck") == "1");

		if($allocationDrawdownCheck && $allocationBlockDrawdownCheck && $allocationNoDrawdownCheck) {
			$allocationDrawdownCheck = false;
			$allocationBlockDrawdownCheck = false;
			$allocationNoDrawdownCheck = false;
		}

		$allocationFilter = $this->GetParamValue("allocationFilter");
		if(empty(trim($allocationFilter))) {
			$allocationFilter = [];
		} else {
			$allocationFilter = array_filter(array_map(function($item) use ($lDB) {
				return $lDB->escape(trim($item));
			},explode(",",$allocationFilter)), function($item) {
				return !empty($item);
			});
		}
		if(sizeof($allocationFilter) > 0) {
			$allocationFilter = "
				AND (
					allocation.rv_reservation_ix IN ('" . join("','", $allocationFilter) . "')
					OR allocation.rv_res_name IN ('" . join("','", $allocationFilter) . "')
				)
			";
		} else {
			$allocationFilter = "";
		}


		$itineraryIds = array();
		$newItineraries = array();
		foreach($itineraries as $itinerary) {
			$itinerary['rv_res_item_comp'] = array();
			$itinerary['rv_res_item_rate_grp'] = array();
			$newItineraries[$itinerary['rv_reservation_item_ix']] = $itinerary;
			$itineraryIds[] = $itinerary['rv_reservation_item_ix'];
		}
		$itineraries = $newItineraries;
		unset($newItineraries);

		if($this->AllocGrouping || $allocationDrawdownCheck || $allocationBlockDrawdownCheck || $allocationNoDrawdownCheck || !empty($allocationFilter)) {
			$drawdowns = $lDB->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					COUNT(allocation_item.rv_reservation_item_ix) AS allocation_count,
					COUNT(bl_block_period.bl_block_period_ix) AS block_count
				FROM
					rv_reservation_item
					LEFT JOIN rv_reservation_item AS allocation_item ON rv_reservation_item.rv_reservation_item_ix = allocation_item.rv_link_res_item_id
					LEFT JOIN rv_reservation AS allocation ON allocation_item.rv_reservation_id = allocation.rv_reservation_ix
					LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = allocation.bl_block_period_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix IN ('".join("','",$itineraryIds)."')
					$allocationFilter
				GROUP BY
					rv_reservation_item.rv_reservation_item_ix
			",6);
			$newDrawdowns = [];
			foreach($drawdowns as $drawdown) {
				$newDrawdowns[$drawdown['rv_reservation_item_ix']] = $drawdown;
			}
			$drawdowns = $newDrawdowns;
			unset($newDrawDowns);

			$applyAllocFilter = $allocationDrawdownCheck || $allocationBlockDrawdownCheck || $allocationNoDrawdownCheck;

			$newItineraryIds = [];
			$newItineraries = [];
			foreach($itineraries as $itinerary) {
				if(array_key_exists($itinerary['rv_reservation_item_ix'], $drawdowns)) {
					$drawdown = $drawdowns[$itinerary['rv_reservation_item_ix']];
				} else {
					continue;
				}
				if(
					(
						$applyAllocFilter && (
							($allocationDrawdownCheck && $drawdown['allocation_count'] > 0)
							|| ($allocationBlockDrawdownCheck && $drawdown['block_count'] > 0)
							|| ($allocationNoDrawdownCheck && $drawdown['allocation_count'] == 0 && $drawdown['block_count'] == 0)
						)
					) || (
						!$applyAllocFilter
						&& $this->AllocGrouping
					)
				) {
					if($this->AllocGrouping) {
						$itinerary['has_drawdown'] = ($drawdown['allocation_count'] > 0 || $drawdown['block_count'] > 0);
					}
					$newItineraries[$itinerary['rv_reservation_item_ix']] = $itinerary;
					$newItineraryIds[] = $itinerary['rv_reservation_item_ix'];
				}
			}

			$itineraries = $newItineraries;
			$itineraryIds = $newItineraryIds;
			unset($newItineraries);
			unset($newItineraryIds);
		}

		$rateComponentFilter = $this->GetParam("rateComponent");
		$components = $lDB->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_reservation_item_id,
				rv_res_item_comp.rt_component_id,
				rt_component.rt_component_desc
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id IN ('".join("','",$itineraryIds)."')
				".$rateComponentFilter->SQL()."
		",6);
		unset($rateComponentFilter);

		$componentIds = array();
		$newComponents = array();
		foreach($components as $component) {
			$component['rv_res_item_comp_rate_grp'] = array();
			$component['rv_res_item_comp_tax'] = array();
			
			$newComponents[$component['rv_res_item_comp_ix']] = $component;
			$componentIds[] = $component['rv_res_item_comp_ix'];
		}
		$components = $newComponents;
		unset($newComponents);


		$rateGroupFilter = $this->GetParam("rateGroupSplit");
		$rateGroups = $lDB->get("
			SELECT
				rv_res_item_rate_grp.rv_reservation_item_id,
				rv_res_item_rate_grp.rv_res_item_rate_grp_ix,
				rv_res_item_rate_grp.rv_res_item_rate_grp_count,
				rv_res_item_rate_grp.rt_rate_group_id,
				rt_rate_group.rt_rate_group_desc
			FROM
				rv_res_item_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
			WHERE
				rt_rate_group.rt_rate_group_class != '0'
				AND rv_res_item_rate_grp.rv_reservation_item_id IN ('".join("','",$itineraryIds)."')
				".$rateGroupFilter->SQL("AND rv_res_item_rate_grp.rt_rate_group_id IN !whereIds!")."				
		",6);

		if($this->GetParamValue("displayCurrency") != "gl") {
			$rateGroupAmountSelect = "
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_comm,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_gross,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_nett,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_payable,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_tax,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount,
			";
			$rateGroupJoin = "";
		} else {
			$rateGroupAmountSelect = "
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_comm * fn_invoice.fn_inv_exch_rate_balance AS rv_item_comp_rate_grp_amt_comm,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_gross * fn_invoice.fn_inv_exch_rate_balance AS rv_item_comp_rate_grp_amt_gross,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_nett * fn_invoice.fn_inv_exch_rate_balance AS rv_item_comp_rate_grp_amt_nett,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_payable * fn_invoice.fn_inv_exch_rate_balance AS rv_item_comp_rate_grp_amt_payable,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_tax * fn_invoice.fn_inv_exch_rate_balance AS rv_item_comp_rate_grp_amt_tax,
				rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_sp_discount,
			";
			$rateGroupJoin = "
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
				INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
			";
		}
		$componentRateGroups = $lDB->get("
			SELECT
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
				rv_res_item_comp_rate_grp.rv_res_item_comp_id,
				$rateGroupAmountSelect
				rv_res_item_comp_rate_grp.rt_rate_group_id,
				rt_rate_group.rt_rate_group_desc
			FROM
				rv_res_item_comp_rate_grp
				INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_comp_rate_grp.rt_rate_group_id
				$rateGroupJoin
				
			WHERE
				rv_res_item_comp_rate_grp.rv_res_item_comp_id IN ('".join("','",$componentIds)."')
				".$rateGroupFilter->SQL("AND rv_res_item_comp_rate_grp.rt_rate_group_id IN !whereIds!")."
		",6);
		unset($rateGroupFilter);


		if($this->GetParamValue("displayCurrency") != "gl") {
			$taxAmountSelect = "rv_res_item_comp_tax.rv_res_item_comp_tax_amt,";
			$taxJoin = "";
		} else {
			$taxAmountSelect = "rv_res_item_comp_tax.rv_res_item_comp_tax_amt * fn_invoice.fn_inv_exch_rate_balance AS rv_res_item_comp_tax_amt,";
			$taxJoin = "
				INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
				INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
			";
		}


		$componentTaxes = $lDB->get("
			SELECT
				rv_res_item_comp_tax.rv_res_item_comp_tax_ix,
				rv_res_item_comp_tax.rv_res_item_comp_id,
				$taxAmountSelect
				'itinerary' AS rf_tax_rate_type,
				rv_res_item_comp_tax.rf_tax_rate_id,
				rf_tax_rate.rf_tax_rate_desc
			FROM
				rv_res_item_comp_tax
				INNER JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_res_item_comp_tax.rf_tax_rate_id
				$taxJoin
			WHERE
				rv_res_item_comp_tax.rv_res_item_comp_id IN ('".join("','",$componentIds)."')
		",6);

		foreach($componentRateGroups as $componentRateGroup) {
			$components[$componentRateGroup['rv_res_item_comp_id']]['rv_res_item_comp_rate_grp'][$componentRateGroup['rv_res_item_comp_rate_grp_ix']] = $componentRateGroup;
		}
		
		foreach($componentTaxes as $componentTax) {
			$components[$componentTax['rv_res_item_comp_id']]['rv_res_item_comp_tax'][$componentTax['rv_res_item_comp_tax_ix']] = $componentTax;
		}

		foreach($components as $component) {
			$itineraries[$component['rv_reservation_item_id']]['rv_res_item_comp'][$component['rv_res_item_comp_ix']] = $component;
		}

		foreach($rateGroups as $rateGroup) {
			$itineraries[$rateGroup['rv_reservation_item_id']]['rv_res_item_rate_grp'][$rateGroup['rv_res_item_rate_grp_ix']] = $rateGroup;
		}

		$itemRateType = false;
		if(array_key_exists("rv_reservation_item.rt_rate_type_name",$this->GroupColumns)) {
			$itemRateType = true;
		}
		$itemArriveDate = false;
		if(array_key_exists("rv_reservation_item.rv_item_date_arrive",$this->GroupColumns)) {
			$itemArriveDate = true;
		}
		$itemDepartDate = false;
		if(array_key_exists("rv_reservation_item.rv_item_date_depart",$this->GroupColumns)) {
			$itemDepartDate = true;
		}
		foreach($itineraries as $itinerary) {
			$id = $itinerary[$this->KeyField];
			foreach($this->GroupKeys[$id] as $key) {
				$item = $this->Data[$key];
				if(
					(
						(
							$this->Level == "res"
						) || (
							$this->Level == "property"
							&& $itinerary['pr_business_id'] == $item['rv_reservation_item.pr_business_name_key']
						) || (
							$this->Level == "accomm"
							&& $itinerary['ac_accomm_type_id'] == $item['rv_reservation_item.ac_accomm_type_name_key']
						)
					) && (
						!$this->AllocGrouping
						|| (
							$this->AllocGrouping
							&& $itinerary['has_drawdown'] == $item['rv_reservation_item.allocation_drawdown_key']
						)
					) && (
						(
							!isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
						) || (
							isset($this->Data[$key]['fn_folio.rf_currency_symbol_key'])
							&& $itinerary['rf_currency_id'] == $this->Data[$key]['fn_folio.rf_currency_symbol_key']
						)
					) && (
						$itemRateType === false
						|| $itinerary['rt_rate_type_id'] == $this->Data[$key]['rv_reservation_item.rt_rate_type_name_key'] 
					) && (
						$itemArriveDate === false
						|| $itinerary['rv_item_date_arrive'] == $this->Data[$key]['rv_reservation_item.rv_item_date_arrive']
					) && (
						$itemDepartDate === false
						|| $itinerary['rv_item_date_depart'] == $this->Data[$key]['rv_reservation_item.rv_item_date_depart']
					)
				) {
					$this->Data[$key]['key_items'][$id]['itineraries'][] = $itinerary;
				}
			}
		}
	}

	function BuildKeys() {
		if(sizeof($this->Data) > 0) {
			$this->Keys = array_unique(call_user_func_array('array_merge',array_map("getKeys",$this->Data)));
		} else {
			$this->Keys = array();
		}


		// Optimisation -- create lookup table to convert all item's ids into a list of appropriate groups to consider
		$groupKeys = array();
		foreach($this->Data as $key=>$item) {
			foreach($item['key_items'] as $id=>$kItem) {
				if(!array_key_exists($id,$groupKeys)) {
					$groupKeys[$id] = array();
				}
				$groupKeys[$id][] = $key;
			}
		}
		$this->GroupKeys = $groupKeys;
	}
	
	function BuildMonths($dateFilters) {
		global $lDB;

		if(!is_array($dateFilters)) {
			$dateFilters = array($dateFilters);
		}

		$smallest = "9999-99-99";
		$largest = "0000-00-00";
		foreach($dateFilters as $filterName) {
			$dateRange = $this->GetParam($filterName);
			if($dateRange->Filter['fromDate'] < $smallest) {
				$smallest = $dateRange->Filter['fromDate'];
			}
			if($dateRange->Filter['toDate'] > $largest) {
				$largest = $dateRange->Filter['toDate'];
			}
			unset($dateRange);
		}

		$currDate = $smallest;
		$dateArray = array();
		while($currDate <= $largest) {
			list($currYear, $currMonth, $currDay) = array_pad( explode("-",$currDate), 3, '' );
			array_push($dateArray,array(
				"start"=>date("Y-m-d",mktime(0,0,0,$currMonth,1,$currYear)),
				"end"=>date("Y-m-d",mktime(0,0,0,$currMonth+1,0,$currYear)),
				"name"=>date("M Y",mktime(0,0,0,$currMonth,1,$currYear)),
				"year"=>date("Y",mktime(0,0,0,$currMonth,1,$currYear))
			));
			$currDate = date("Y-m-d",mktime(0,0,0,$currMonth+1,1,$currYear));
		}
		$dateArray[0]['start'] = $smallest;
		$dateArray[sizeof($dateArray)-1]['end'] = $largest;
		if($this->GetParamValue("dayTotal") == 1) {
			foreach($dateArray as $key=>$month) {
				$currDate = $month['start'];
				$days = array();
				while($currDate <= $month['end']) {
					list($currYear, $currMonth, $currDay) = array_pad( explode("-",$currDate), 3, '' );
					switch($this->GetParamValue("dayTotalFormat")) {
					case FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_WEEK:
						$label = substr(date("D",mktime(0,0,0,$currMonth,$currDay,$currYear)),0,2);
						break;
					case FINANCIAL_ANALYSIS_PER_DAY_DAY_OF_MONTH:
						$label = date("d",mktime(0,0,0,$currMonth,$currDay,$currYear));
						break;
					case FINANCIAL_ANALYSIS_PER_DAY_DAY_AND_MONTH:
						$label = date("d M",mktime(0,0,0,$currMonth,$currDay,$currYear));
						break;
					case FINANCIAL_ANALYSIS_PER_DAY_FULL:
					default:
						$label = date("d M Y",mktime(0,0,0,$currMonth,$currDay,$currYear));
						break;
					}
					array_push($days,array(
						"start"=>date("Y-m-d",mktime(0,0,0,$currMonth,$currDay,$currYear)),
						"end"=>date("Y-m-d",mktime(0,0,0,$currMonth,$currDay,$currYear)),
						"name"=>date("d M Y",mktime(0,0,0,$currMonth,$currDay,$currYear)),
						"label"=>$label,
						"year"=>date("Y",mktime(0,0,0,$currMonth,$currDay,$currYear))
					));
					$currDate = date("Y-m-d",mktime(0,0,0,$currMonth,$currDay+1,$currYear));
				}
				$dateArray[$key]['days'] = $days;
			}
		}

		$this->Dates = $dateArray;
	}

	function findYearEnd($year) {
		$last = "0000-00-00";
		foreach($this->Dates as $date) {
			if($date['year'] == $year && $date['end'] > $last) {
				$last = $date['end'];
			}
		}

        return $last;
	}	
	
	function BuildReference() {
		$this->Reference = array();
		foreach($this->Data as $key=>$data) {
			if(!array_key_exists($key,$this->Reference)) {
				$this->Reference[$key] = array();
			}				
		}
	}	

	function BuildDisplay($prefix,$header,$startDate,$endDate,$class="") {
		$dateGroupKey = false;
		if($this->DateGrouping == "year") {
			$dateGroupKey = "rv_reservation.rv_date_year_key";
		}
		if($this->DateGrouping == "month") {
			$dateGroupKey = "rv_reservation.rv_date_month_key";
		}
		if($this->DateGrouping == "day") {
			$dateGroupKey = "rv_reservation.rv_date_day_key";
		}

		$splitAccomm = $this->GetParamValue("splitAccomm");
		if($splitAccomm != "total") {
			$accommGroups = array();
			foreach($this->Data as $key=>$item) {
				$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
				foreach($items as $item) {
					foreach($item['itineraries'] as $accomm) {
						if($splitAccomm == "property") {
							$key = $accomm['pr_business_id'];
							$value = $accomm['pr_name_last'];
							$accommGroups[$key] = $value;
						} elseif($splitAccomm == "component") {
							foreach($accomm['rv_res_item_comp'] as $comp) {
								$accommGroups[$comp['rt_component_id']] = $comp['rt_component_desc'];
							}
						} elseif($splitAccomm == "rateGroup") {
							foreach($accomm['rv_res_item_comp'] as $comp) {
								foreach($comp['rv_res_item_comp_rate_grp'] as $compRateGroup) {
									$accommGroups[$compRateGroup['rt_rate_group_id']] = $compRateGroup['rt_rate_group_desc'];
								}
							}
						} elseif($splitAccomm == "componentRateGroup") {
							foreach($accomm['rv_res_item_comp'] as $comp) {
								foreach($comp['rv_res_item_comp_rate_grp'] as $compRateGroup) {
									$key = $comp['rt_component_id'] . "_" . $compRateGroup['rt_rate_group_id'];
									$value = array($comp['rt_component_desc'],$compRateGroup['rt_rate_group_desc']);
									$accommGroups[$key] = $value;
								}
							}
						} else { // rateGroupComponent
							foreach($accomm['rv_res_item_comp'] as $comp) {
								foreach($comp['rv_res_item_comp_rate_grp'] as $compRateGroup) {
									$key = $compRateGroup['rt_rate_group_id'] . "_" . $comp['rt_component_id'];
									$value = array($compRateGroup['rt_rate_group_desc'],$comp['rt_component_desc']);
									$accommGroups[$key] = $value;
								}
							}
						}
					}
				}
			}
		}		
		$splitExtra = $this->GetParamValue("splitExtra");
		if($splitExtra != "total") {
			if($splitExtra == 'type') {
				$extraGroups = array(
					'extra'=>"General extra",
					'activity'=>"Activity",
					'travel'=>"Travel",
					'accomm-extra'=>"Accommodation extra"
				);
			} else {
				$extraGroups = array();
				foreach($this->Data as $key=>$item) {
					$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
					foreach($items as $item) {
						foreach($item['extras'] as $extra) {
							if($splitExtra == "extra") {
								$extraGroups[$extra['ac_extra_ix']] = $extra['ac_ext_desc'];
							} elseif($splitExtra == "category") {
								$extraGroups[$extra['ac_extra_category_ix']] = $extra['ac_extra_cat_desc'];
							} elseif($splitExtra == "categoryExtra") {
								$extraGroups[$extra['ac_extra_category_ix'] . "_" . $extra['ac_extra_ix']] = array($extra['ac_extra_cat_desc'],$extra['ac_ext_desc']);
							} elseif($splitExtra == "typeCategory") {
								switch($extra['ac_extra_cat_ind']) {
								case DB_AC_EXTRA_CAT_GENERAL:
									$name = "extra";
									$desc = "General extra";
									break;
								case DB_AC_EXTRA_CAT_ACTIVITY:
									$name = "activity";
									$desc = "Activity";
									break;
								case DB_AC_EXTRA_CAT_TRAVEL:
									$name = "travel";
									$desc = "Travel";
									break;
								case DB_AC_EXTRA_CAT_ACCOMMODATION:
									$name = "accomm-extra";
									$desc = "Accommodation extra";
									break;
								}
								$extraGroups[$name . "_" . $extra['ac_extra_category_ix']] = array($desc,$extra['ac_extra_cat_desc']);
							} elseif($splitExtra == "typeExtra") {
								switch($extra['ac_extra_cat_ind']) {
								case DB_AC_EXTRA_CAT_GENERAL:
									$name = "extra";
									$desc = "General extra";
									break;
								case DB_AC_EXTRA_CAT_ACTIVITY:
									$name = "activity";
									$desc = "Activity";
									break;
								case DB_AC_EXTRA_CAT_TRAVEL:
									$name = "travel";
									$desc = "Travel";
									break;
								case DB_AC_EXTRA_CAT_ACCOMMODATION:
									$name = "accomm-extra";
									$desc = "Accommodation extra";
									break;
								}
								$extraGroups[$name . "_" . $extra['ac_extra_ix']] = array($desc,$extra['ac_ext_desc'],$desc);
							}
						}
					}
				}
				uasort($extraGroups,'headerSort');
			}
		}

		$splitTax = $this->GetParamValue("splitTax");
		if($splitTax != "total") {
			if($splitTax == "revenueType") {
				$taxGroups = array(
					'itinerary'=>"Accommodation",
					'extra'=>"General extra",
					'activity'=>"Activity",
					'travel'=>"Travel",
					'accomm-extra'=>"Accommodation extra"
				);
			} else {
				$taxGroups = array();
				foreach($this->Data as $key=>$item) {
					$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
					foreach($items as $item) {
						foreach($item['itineraries'] as $accomm) {
							foreach($accomm['rv_res_item_comp'] as $comp) {
								foreach($comp['rv_res_item_comp_tax'] as $tax) {
									if($splitTax == "tax") {
										$taxGroups[$tax['rf_tax_rate_id']] = $tax['rf_tax_rate_desc'];
									} else {
										$taxGroups[$tax['rf_tax_rate_id']."_itinerary"] = array($tax['rf_tax_rate_desc'],"Accommodation");
									}
								}
							}
						}
						foreach($item['extras'] as $extra) {
							if(isset($splitTax) && $splitTax == "tax") {
								$taxGroups[$extra['rf_tax_id']] = $extra['rf_tax_rate_desc'];
							} else {
								switch($extra['ac_extra_cat_ind']) {
								case DB_AC_EXTRA_CAT_GENERAL:
									$name = "extra";
									$desc = "General extra";
									break;
								case DB_AC_EXTRA_CAT_ACTIVITY:
									$name = "activity";
									$desc = "Activity";
									break;
								case DB_AC_EXTRA_CAT_TRAVEL:
									$name = "travel";
									$desc = "Travel";
									break;
								case DB_AC_EXTRA_CAT_ACCOMMODATION:
									$name = "accomm-extra";
									$desc = "Accommodation extra";
									break;
								}
								$taxGroups[$extra['rf_tax_id']."_".$name] = array($extra['rf_tax_rate_desc'],$desc);
							}
						}
					}
				}
			}
		}

		$splitPayment = $this->GetParamValue("splitPayment");
		if($splitPayment != "total") {
			$paymentGroups = array();
			foreach($this->Data as $key=>$item) {
				$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
				foreach($items as $item) {
					foreach($item['payments'] as $payment) {
						$paymentGroups[$payment['rf_bank_ix']] = $payment['rf_bank_acc_name'];
					}
				}
			}
		}
		

		$splitRateGroup = $this->GetParamValue("splitRateGroup");
		if($splitRateGroup == "1") {
			$rateGroups = array();
			foreach($this->Data as $key=>$item) {
				$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
				foreach($items as $item) {
					foreach($item['itineraries'] as $accomm) {
						foreach($accomm['rv_res_item_rate_grp'] as $rateGroup) {
							$rateGroups[$rateGroup['rt_rate_group_id']] = $rateGroup['rt_rate_group_desc'];
						}
					}
				}
			}
		}
		
		$display = $this->GetParamValue("display");
		$displayFields = array();
		$buildPotentialTotal = false;
		foreach($display as $key=>$item) {
			if($item['active'] == "1") {
				$displayFields[$key] = $item;
				if(isset($item['buildPotentialTotal']) && $item['buildPotentialTotal']) {
					$buildPotentialTotal = true;
				}
			}
		}
		unset($display);

		uasort($displayFields, "ReportSQLBuilderOrderCompare");				

		foreach($displayFields as $col) {
			if($col['name'] == "extras") {
				switch($splitExtra) {
				case "total":
					$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
					break;
				case "category":
				case "extra":
				case "type":
					foreach($extraGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}					
					break;
				case "categoryExtra":
				case "typeCategory":
				case "typeExtra":
					foreach($extraGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label[0],$label[1]),$col,$class);
					}
					break;
				}
			} elseif($col['name'] == "accommodation") {
				switch($splitAccomm) {
				case "total":
					$this->AddColumn($prefix . "_" . $col['name'],array($header,$col['cols']['label']['value']),$col,$class);
					break;
				case "property":
				case "component":
				case "rateGroup":
					foreach($accommGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}
					break;
				case "componentRateGroup":
				case "rateGroupComponent":
					foreach($accommGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label[0],$label[1]),$col,$class);
					}
					break;
				}
			} elseif($col['name'] == "tax") {
				switch($splitTax) {
				case "total":
					$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
					break;
				case "tax":
				case "revenueType":
					foreach($taxGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}
					break;
				case "taxRevenueType":
					foreach($taxGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label[0],$label[1]),$col,$class);
					}
					break;
				}
			} elseif($col['name'] == "payments") {
				switch($splitPayment) {
				case "total":
					$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
					break;
				case "bank":
					foreach($paymentGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}
				}
			} elseif(
					$col['name'] == "rv_reservation_item.pax"
					|| $col['name'] == "rv_reservation_item.bed_nights"
					|| $col['name'] == "rv_reservation_item.average_bed_nights_per_res"
					|| $col['name'] == "rv_reservation_item.bed_nights_perc_total"
					|| $col['name'] == "rv_reservation_item.bed_nights_perc_row_potential"
					|| $col['name'] == "rv_reservation_item.bed_nights_perc_total_potential"
			) {
				if($splitRateGroup != "1") {
					$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
				} else {
					foreach($rateGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}
				}				
			} elseif($col['name'] == "yield_on_accomm_per_bed_night") {
				if($splitRateGroup != "1") {
					$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
				} else {
					list($unitGroupId,$unitGroupDesc) = array_pad( $GLOBALS['lDB']->get("SELECT rt_rate_group_ix,rt_rate_group_desc FROM rt_rate_group WHERE rt_rate_group_sys_code = '1'",1), 2, '' );
					$yieldRateGroups = array_merge(
						array($unitGroupId=>$unitGroupDesc),
						$rateGroups
					);
					foreach($yieldRateGroups as $id=>$label) {
						$this->AddColumn($prefix . "_" . $id . "_" . $col['name'],array($header,$col['cols']['label']['value'],$label),$col,$class);
					}
				}					
			} else {
				$this->AddColumn($prefix . "_" . $col['name'],$header,$col,$class);
			}
		}

		$this->DisplayColumns = $displayFields;
		unset($displayFields);


		// Get totals required by agregates
		$reservations = 0;
		$roomNights = 0;
		$bedNights = 0;

		if($this->Potential !== false && $buildPotentialTotal) {
			$potentialRoomNights = 0;
			$potentialBedNights = 0;			
		}
		foreach($this->Data as $key=>$item) {
			$items = $this->{$this->DisplayFilter}($item['key_items'],$this->Dates[0]['start'],$this->Dates[sizeof($this->Dates)-1]['end'],$item[$dateGroupKey] ?? false);
			$reservations += getReservationCount($items,$this->ReservationCountType);
			$roomNights += getRoomNights($items);
			$bedNights += getBedNights($items);
			if($this->Potential !== false && $buildPotentialTotal) {
				$potentialRoomNights += getPotential("room",$item,$this->Level,$this->Potential,$startDate,$endDate);
				$potentialBedNights += getPotential("bed",$item,$this->Level,$this->Potential,$startDate,$endDate);
			}
		}

		foreach($this->Data as $key=>$item) {
			$items = $this->{$this->DisplayFilter}($item['key_items'],$startDate,$endDate,$item[$dateGroupKey] ?? false);
			
			$this->Reference[$key][$prefix] = array_unique(array_keys($items));

			$removeItem = false;
			foreach($this->DisplayColumns as $name=>$col) {
				switch($name) {
				case "rv_reservation_item.rv_item_accomm_count":
					$value = getRooms($items);
					break;
				case "rv_reservation_item.pax":
					if($splitRateGroup != "1") {
						$value = getPAX($items);
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getPAX($items,$rt_rate_group_id);
						}
					}
					$paxValue = is_array($value) ? array_sum($value) : $value;
					$numPax = $this->GetParamValue("numberPax");
					if (!empty($numPax)) {
						list($number,$operator) = explode(":",$this->GetParamValue("numberPax"));
						if(is_numeric($number) && !getOperatorComparison($operator,$paxValue,$number)) { $removeItem = true; }
					}
					break;
				case "rv_reservation_item.room_nights":
					$value = getRoomNights($items);
					break;
				case "rv_reservation_item.bed_nights":
					if($splitRateGroup != "1") {
						$value = getBedNights($items);
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getBedNights($items,$rt_rate_group_id);
						}
					}
					break;
				case "rv_reservation.count":
					$value = getReservationCount($items,$this->ReservationCountType);
					break;
				case "rv_reservation_item.room_nights_perc":
					$value = getRoomNightsPerc($items,$roomNights);
					break;
				case "rv_reservation_item.bed_nights_perc":
					$value = getBedNightsPerc($items,$bedNights);
					break;
				case "rv_reservation.count_perc":
					$value = getReservationCountPerc($items,$this->ReservationCountType,$reservations);
					break;
				case "rv_reservation_item.average_length_of_stay":
					$value = getAvgLOS($items);
					break;
				case "rv_reservation_item.average_room_nights_per_res":
					$value = getAvgRoomNightsPerRes($items,$this->ReservationCountType);
					break;
				case "rv_reservation_item.average_bed_nights_per_res":
					if($splitRateGroup != "1") {
						$value = getAvgBedNightsPerRes($items,$this->ReservationCountType);
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getAvgBedNightsPerRes($items,$this->ReservationCountType,$rt_rate_group_id);
						}
					}
					break;
				case "potential_room_nights":
					$value = getPotential("room",$item,$this->Level,$this->Potential,$startDate,$endDate);
					break;
				case "potential_bed_nights":
					$value = getPotential("bed",$item,$this->Level,$this->Potential,$startDate,$endDate);
					break;
				case "rv_reservation_item.bed_nights_perc_total":
					if($splitRateGroup != "1") {
						$value = getBedNightsPerc($items,$bedNights);
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getBedNightsPerc($items,$bedNights,$rt_rate_group_id);
						}
					}
					break;					
				case "rv_reservation_item.bed_nights_perc_row_potential":
					if($splitRateGroup != "1") {
						$value = getBedNightsPerc($items,getPotential("bed",$item,$this->Level,$this->Potential,$startDate,$endDate));
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getBedNightsPerc($items,getPotential("bed",$item,$this->Level,$this->Potential,$startDate,$endDate),$rt_rate_group_id);
						}
					}
					break;
				case "rv_reservation_item.bed_nights_perc_total_potential":
					if($splitRateGroup != "1") {
						$value = getBedNightsPerc($items,$potentialBedNights);
					} else {
						$value = array();
						foreach($rateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getBedNightsPerc($items,$potentialBedNights,$rt_rate_group_id);
						}
					}
					break;
				case "rv_reservation_item.room_nights_perc_total":
					$value = getRoomNightsPerc($items,$roomNights);
					break;					
				case "rv_reservation_item.room_nights_perc_row_potential":
					$value = getRoomNightsPerc($items,getPotential("room",$item,$this->Level,$this->Potential,$startDate,$endDate));
					break;
				case "rv_reservation_item.room_nights_perc_total_potential":
					$value = getRoomNightsPerc($items,$potentialRoomNights);
					break;					
				case "accommodation":
					switch($splitAccomm) {
					case "total":
						$value = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"));
						break;
					case "property":
						$value = array();
						foreach($accommGroups as $pr_business_id=>$pr_name_last) {
							$value[$prefix . "_" . $pr_business_id . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"property",$pr_business_id);
						}
						break;
					case "component":
						$value = array();
						foreach($accommGroups as $rt_component_id=>$rt_component_desc) {
							$value[$prefix . "_" . $rt_component_id . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"component",$rt_component_id);
						}
						break;
					case "rateGroup":
						$value = array();
						foreach($accommGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"rateGroup",$rt_rate_group_id);
						}
						break;
					case "componentRateGroup":
						$value = array();
						foreach($accommGroups as $compound=>$descArray) {
							$value[$prefix . "_" . $compound . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"componentRateGroup",$compound);
						}
						break;
					case "rateGroupComponent":
						$value = array();
						foreach($accommGroups as $compound=>$descArray) {
							$value[$prefix . "_" . $compound . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"rateGroupComponent",$compound);
						}
						break;
					}
					break;
				case "extras":
					switch($splitExtra) {
					case "total":			
						$value = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"));
						break;
					case "extra":
						$value = array();
						foreach($extraGroups as $ac_extra_id=>$ac_ext_desc) {
							$value[$prefix . "_" . $ac_extra_id . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),$ac_extra_id);
						}
						break;
					case "category":
						$value = array();
						foreach($extraGroups as $ac_extra_category_id=>$ac_ext_desc) {
							$value[$prefix . "_" . $ac_extra_category_id . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),false,$ac_extra_category_id);
						}
						break;
					case "type":
						$value = array();
						foreach($extraGroups as $ac_extra_type=>$ac_extra_type_desc) {
							$value[$prefix . "_" . $ac_extra_type . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),false,false,$ac_extra_type);
						}
						break;
					case "categoryExtra":
						$value = array();
						foreach($extraGroups as $compound=>$labels) {
							list($ac_extra_category_id,$ac_extra_id) = array_pad( explode("_",$compound), 2, '' );
							$value[$prefix . "_" . $compound . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),$ac_extra_id,$ac_extra_category_id);
						}
						break;
					case "typeCategory":
						$value = array();
						foreach($extraGroups as $compound=>$labels) {
							list($ac_extra_type,$ac_extra_category_id) = array_pad( explode("_",$compound), 2, '' );
							$value[$prefix . "_" . $compound . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),false,$ac_extra_category_id,$ac_extra_type);
						}
						break;
					case "typeExtra":
						$value = array();
						foreach($extraGroups as $compound=>$labels) {
							list($ac_extra_type,$ac_extra_id) = array_pad( explode("_",$compound), 2, '' );
							$value[$prefix . "_" . $compound . "_" . $name] = getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),$ac_extra_id,false,$ac_extra_type);
						}
						break;
					}
					break;
				case "tax":
					switch($splitTax) {
					case "total":
						$value = getTaxTotal($items);
						break;
					case "tax":
						$value = array();
						foreach($taxGroups as $rf_tax_rate_id=>$rf_tax_rate_desc) {
							$value[$prefix . "_" . $rf_tax_rate_id . "_" . $name] = getTaxTotal($items,$rf_tax_rate_id);
						}
						break;
					case "revenueType":
						$value = array();
						foreach($taxGroups as $rf_tax_rate_type=>$rf_tax_rate_type_desc) {
							$value[$prefix . "_" . $rf_tax_rate_type . "_" . $name] = getTaxTotal($items,false,$rf_tax_rate_type);
						}						
						break;
					case "taxRevenueType":
						$value = array();
						foreach($taxGroups as $compound=>$labels) {
							list($rf_tax_rate_id,$rf_tax_rate_type) = array_pad( explode("_",$compound), 2, '' );
							$value[$prefix . "_" . $compound . "_" . $name] = getTaxTotal($items,$rf_tax_rate_id,$rf_tax_rate_type);
						}
						break;
					}
					break;
				case "commission_rec_extra":
					$value = getCommRecTotal($items);
					break;
				case "commission_pay":
					$value = getCommPayTotal($items);
					break;
				case "commission_pay_accomm":
					$value = getCommPayTotal($items,"itinerary");
					break;
				case "commission_pay_extra":
					$value = getCommPayTotal($items,"extra");
					break;
				case "total":
					$value = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) + getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"));
					break;
				case "revpar_on_accomm":
					$potentialRoomNights = getPotential("room",$item,$this->Level,$this->Potential,$startDate,$endDate);
					if($potentialRoomNights != 0) {
						$value = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) / $potentialRoomNights;
					} else {
						$value = "";
					}
					unset($potentialRoomNights);
					break;
				case "revpar_on_total":
					$potentialRoomNights = getPotential("room",$item,$this->Level,$this->Potential,$startDate,$endDate);
					if($potentialRoomNights != 0) {
						$value = (getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) + getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"))) / $potentialRoomNights;
					} else {
						$value = "";
					}
					unset($potentialRoomNights);
					break;
				case "yield_on_accomm_per_bed_night":
					if($splitRateGroup != "1") {
						$yieldBedNights = getBedNights($items);
						if($yieldBedNights != 0) {
							$value = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) / $yieldBedNights;
						} else {
							$value = "";
						}
					} else {
						$value = array();
						$first = true;
						foreach($yieldRateGroups as $rt_rate_group_id=>$rt_rate_group_desc) {
							$yieldBedNights = getBedNights($items,$rt_rate_group_id);

							// Units
							if($first) { $yieldBedNights = getRoomNights($items); }
							
							if($yieldBedNights != 0) {
								$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax"),"rateGroup",$rt_rate_group_id) / $yieldBedNights;
							} else {
								$value[$prefix . "_" . $rt_rate_group_id . "_" . $name] = "";
							}
							$first = false;
						}
					}
					break;
				case "yield_on_total_per_bed_night":
					$yieldBedNights = getBedNights($items);
					if($yieldBedNights != 0) {
						$value = (getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) + getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"))) / $yieldBedNights;
					} else {
						$value = "";
					}
					break;
				case "yield_on_accomm_per_room_night":
					$yieldRoomNights = getRoomNights($items);
					if($yieldRoomNights != 0) {
						$value = getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) / $yieldRoomNights;
					} else {
						$value = "";
					}
					break;
				case "yield_on_total_per_room_night":
					$yieldRoomNights = getRoomNights($items);
					if($yieldRoomNights != 0) {
						$value = (getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) + getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"))) / $yieldRoomNights;
					} else {
						$value = "";
					}
					break;
				case "payments":
					switch($splitPayment) {
					case "total":					
						$value = getPaymentTotal($items);
						break;
					case "bank":
						$value = array();
						foreach($paymentGroups as $rf_bank_id=>$rf_bank_acc_name) {
							$value[$prefix . "_" . $rf_bank_id . "_" . $name] = getPaymentTotal($items,$rf_bank_id);
						}						
						break;
					}
					break;
				case "balance_report":
					$value = (getAccommodationTotal($items,$this->AmountType,$this->GetParamValue("includeTax")) + getExtrasTotal($items,$this->AmountType,$this->GetParamValue("includeTax"))) - getPaymentTotal($items);
					break;
				case "balance_res":
					$item['fn_folio.rf_currency_symbol_key'] = isset($item['fn_folio.rf_currency_symbol_key']) ? $item['fn_folio.rf_currency_symbol_key'] : "";
					$value = getReservationOutstanding($items,$item['fn_folio.rf_currency_symbol_key']);
					break;
				case "balance_folio":
					$value = getFolioOutstanding($items);
					break;
				case "rv_reservation_item.rv_item_date_arrive":
					$value = getArriveDate($items,$startDate,$endDate);
					if ($value == "0000-00-00") {
						$this->GeneralNotification[] = "Some result items do not contain any itineraries, and therefore no arrival or departure dates. This could be due to grouping options selected.";
					}
					break;
				case "rv_reservation_item.rv_item_date_depart":
					$value = getDepartDate($items,$startDate,$endDate);
					if ($value == "0000-00-00") {
						$this->GeneralNotification[] = "Some result items do not contain any itineraries, and therefore no arrival or departure dates. This could be due to grouping options selected.";
					}
					break;
				case "fn_invoice.fn_invoice_ix":
					$tmpItem = array_values($items);
					$item = array_shift($tmpItem);
					$value = $item['fn_invoice_ix'];
					break;
				case "fn_invoice.fn_inv_date":
					$tmpItem = array_values($items);
					$item = array_shift($tmpItem);
					$value = $item['fn_inv_date'];
					if(empty($value)) {
						$value = $item['fn_folio_date'];
					}
					break;
				case "sp_special.sp_special_note":
					$value = getSpecialNoteFirst($items);
					break;
				case "rv_special.special_override_user":
					$value = getSpecialOverrideUserFirst($items);
					break;
				case "rv_special.special_override_date":
					$value = getSpecialOverrideDateFirst($items);
					break;
				case "rv_special.special_application_date":
					$value = getSpecialApplicationDateFirst($items);
					break;
				case "rv_special.count":
					$value = getSpecialCount($items);
					break;
				case "rv_reservation_item.number_properties":
					$value = getPropertyCount($items);
					list($number,$operator) = explode(":",$this->GetParamValue("numberProperties"));
					if(is_numeric($number) && !getOperatorComparison($operator,$value,$number)) { $removeItem = true; }
					break;
				case "rv_reservation_item.number_nights":
					$value = getNightsCount($items);
					list($number,$operator) = explode(":",$this->GetParamValue("numberNights"));
					if(is_numeric($number) && !getOperatorComparison($operator,$value,$number)) { $removeItem = true; }
					break;
				case "rv_item_comp_rate_grp_amt_sp_discount":
					$value = getSpecialDiscountTotal($items);
					break;
				case "bl_block.bl_block_id":
					$value = getBlockFirst($items);
					break;
				case "bl_block.bl_block_name":
					$value = getBlockFirst($items,"name");
					break;
				case "rv_reservation_item.allocation_id":
					$value = getAllocationFirst($items);
					break;
				case "rv_reservation_item.allocation_name":
					$value = getAllocationFirst($items,"name");
					break;
				case "specials":
					$resId = isset($item["rv_reservation.rv_reservation_ix"]) ? $item["rv_reservation.rv_reservation_ix"] : "";
					$value = getSpecials($resId);
					break;
				default:
					$value = "NOT IMPLEMENTED";
					break;
				}
				if(!is_array($value)) {
					$this->Data[$key][$prefix . "_" . $name] = $value;
				} else {
					foreach($value as $valKey=>$valItem) {
						$this->Data[$key][$valKey] = $valItem;
					}
				}
			}
			if ($removeItem) { 
				unset($this->Data[$key]);
			} 
		}
	}	

	function BuildTotals() {
		$totals = array();

		foreach($this->Data as $key=>$item) {
			$totalKey = "0";
			if(isset($item['fn_folio.rf_currency_symbol'])) {
				$totalKey = $item['fn_folio.rf_currency_symbol'];
			}
			if(!array_key_exists($totalKey,$totals)) {
				$totals[$totalKey] = array();
			}

			foreach($this->Columns as $col) {
				$field = $col['field'];
				if($col['field'] == "fn_folio.rf_currency_symbol") {
					$totals[$totalKey][$field] = $item[$field];					
				} elseif($col['total'] == "hidden") {
					$totals[$totalKey][$field] = "";
				} else {
					if(!empty($col['format']) && $col['format'] != "date") {
						if(!isset($totals[$totalKey][$field])) {
							$totals[$totalKey][$field] = 0;
						}
						$totals[$totalKey][$field] += $item[$field];
					} else {
						$totals[$totalKey][$field] = "";
					}
				}
			}
		}
		$this->Totals = $totals;
	}	

	function RemoveZeroColumns() {
		$newColumns = array();
		foreach($this->Columns as $col) {
			$hasValue = false;
			$field = $col['field'];
			if(!empty($col['format'])) {
				foreach($this->Data as $key=>$item) {
					if(!empty($item[$field]) && ($col['format'] != "date" || $item[$field] != "0000-00-00")) {
						$hasValue = true;
					}							
				}
			} else {
				$hasValue = true;
			}
			if($hasValue) {
				$newColumns[] = $col;
			}
		}
		$this->Columns = $newColumns;
	}

	function RemoveZeroRows() {
		$newData = array();
		foreach($this->Data as $key=>$item) {
			$hasValue = false;
			foreach($this->Columns as $col) {
				if ($col['exclude_zero_check']) {
					// Exclude this column from determining whether a row should be kept or not.
					continue;
				}

				$field = $col['field'];
				if(!empty($col['format']) && !empty($item[$field]) && ($col['format'] != "date" || $item[$field] != "0000-00-00")) {
					$hasValue = true;
				}
			}
			if($hasValue) {
				$newData[$key] = $item;
			}
		}
		$this->Data = $newData;
	}

	function RemoveGrandTotals() {
		$newColumns = array();
		foreach($this->Columns as $col) {
			if(!preg_match("/^total_/",$col['field'])) {
				$newColumns[] = $col;
			}
		}
		$this->Columns = $newColumns;
	}

	function FormatRow(&$item,$section="data") {
        $mode = $this->GetParam("render")->Mode;
		foreach($this->Columns as $col) {
			$field = $col['field'];
			if($item[$field] === "NOT IMPLEMENTED") {
				continue;
			}
			if($section == "total" && $col['total'] == "hidden") {
				continue;
			}
			switch($col['format']) {
			case "percent":
				$item[$field] = sprintf("%.2f",round($item[$field] * 100,2)) . "%";
				break;
			case "integer":
				$item[$field] = sprintf("%d",round($item[$field],0));
				break;
			case "average":
			case "amount":
				$value = round($item[$field],2);
				if($mode == "csv") {
					$item[$field] = sprintf("%.2f",$value);
				} else {
					$item[$field] = number_format($value,2);
				}
				break;
			case "date":
				$item[$field] = formatDate($item[$field]);
				break;
			default:
				break;
			}
		}
	}

	function BuildFormat() {
		foreach($this->Data as $key=>$item) {
			$this->FormatRow($this->Data[$key]);
		}
		foreach($this->Totals as $key=>$item) {
			$this->FormatRow($this->Totals[$key],"total");
		}

		return;
	}

	function SortData() {
		$this->Sort = array();
		foreach($this->Columns as $col) {
			if(!empty($col['sort'])) {
				$this->Sort[$col['field']] = array('sort'=>$col['sort'],'direction'=>$col['direction'],'sortType'=>isset($col['sortType']) ? $col['sortType'] : "");
			}
		}

		if(sizeof($this->Sort) > 0) {
			uasort($this->Sort,'compareSort');
			uasort($this->Data,'compareData');
		}
	}	

	function AddColumn($field,$labels,$col,$class=false,$format=false) {
		if(!is_array($labels)) {
			$labels = array($labels);
			$labels[] = $col['cols']['label']['value'];
		}

		if(!empty($col['cols']['header']['value'])) {
			$header = array_shift($labels);
			array_unshift($labels,$header,$col['cols']['header']['value']);
		}

		if(!empty($col['cols']['width']['value'])) {
			$width = $col['cols']['width']['value'];
		} else {
			$width = 100;
		}

		$col['cols']['align']['value'] = isset($col['cols']['align']['value']) ? $col['cols']['align']['value'] : "l";

		switch($col['cols']['align']['value']) {
		case "l":
			$align = "left";
			break;
		case "r":
			$align = "right";
			break;
		case "c":
			$align ="center";
			break;
		}

		if(empty($class)) {
			$class = "";
		}

		if($format === false && isset($col['format'])) {
			$format = $col['format'];
		}

		if(!isset($col['total'])) {
			$col['total'] = "";
		}

		$this->Columns[] = array(
			'field'=>$field,
			'labels'=>$labels,
			'sort'=>(isset($col['cols']['sort_order']['value']) ? $col['cols']['sort_order']['value'] : ""),
			'sortType'=>(isset($col['sortType']) ? $col['sortType'] : ""),
			'direction'=>(isset($col['cols']['sort_direction']['value']) ? $col['cols']['sort_direction']['value'] : ""),
			'width'=>$width,
			'align'=>$align,
			'class'=>$class,
			'format'=>$format,
			'total'=>$col['total'],
			'exclude_zero_check'=>(isset($col['exclude_zero_check']) ? $col['exclude_zero_check'] : false),
		);
	}	

	function MaxColumnLabels() {
		$max = 0;
		foreach($this->Columns as $col) {
			if(sizeof($col['labels']) > $max) {
				$max = sizeof($col['labels']);
			}
		}

		return $max;
	}

	function TotalColumnWidth() {
		$width = 0;
		foreach($this->Columns as $col) {
			$width += $col['width'] + ($this->Padding * 2);
		}

		return $width;
	}

	function SpanColumnLabels() {
		$last = false;
		$lastKey = false;

		foreach($this->Columns as $key=>$col) {
			if($lastKey === false) {
				$lastKey = array_fill(0,sizeof($col['labels']),$key);
				$last = $col['labels'];
				$this->Columns[$key]['spans'] = array_fill(0,sizeof($col['labels']),1);
			} else {
				$check = false;
				$done = false;
				foreach($col['labels'] as $id=>$label) {
					if($done) { continue; }
					if(isset($last[$id]) && $last[$id] == $label) {
						$this->Columns[$lastKey[$id]]['spans'][$id]++;
						$this->Columns[$key]['spans'][$id] = 0;
					} else {
						for($count = $id; $count < sizeof($col['labels']); $count++) {
							$lastKey[$count] = $key;
							$last[$count] = $col['labels'][$count];
							$this->Columns[$key]['spans'][$count] = 1;
						}
						$done = true;
					}
				}
			}
		}
	}

	function HTMLColumnPeriodHeaders() {
		$this->SpanColumnLabels();
		$html = "";
		$max = $this->MaxColumnLabels();

		foreach($this->Columns as $col) {
			$html .= "<col style=\"width: $col[width]px\" />\n";
		}
		$html .= "<col style=\"width: 20px\" />\n";

		for($count=0;$count<$max;$count++) {
			$html .= "<tr>\n";
			$colNum = 1;
			foreach($this->Columns as $col) {
				if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
					$rowspan = "";
					if($count == (sizeof($col['labels']) - 1) && sizeof($col['labels']) < $max) {
						$rowspan = "rowspan=\"" .($max - sizeof($col['labels']) + 1). "\"";
					}

					$align = $col['align'];
					$colspan = "";
					if($col['spans'][$count] > 1) {
						$colspan = "colspan=\"".$col['spans'][$count]."\"";
						$align = "center";
					}
					$hover = "";
					if(empty($col['class'])) {
						//$hover = "onmouseover=\"colOver(".$colNum.");\" onmouseout=\"colOut(".$colNum.");\"";
					}
					$html .= "<td id=\"column_".$count."_".$colNum."\" $hover class=\"outDk $col[class]\" $colspan $rowspan align=\"$align\" style=\"overflow: hidden;\">" . (!is_array($col['labels'][$count]) ? $col['labels'][$count] : "Array") . "</td>\n";
					// If $col['labels'][$count] is an array, it produces a php5 error. In 5.25.0 the column label
					// is then displayed as "Array", but until this is fixed for php5, we'll show the label as "Array"
				}
				$colNum++;
			}
			$html .= "<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>\n";
			$html .= "</tr>\n";
		}

		return $html;
 	}

	function HTMLColumnGroupHeaders() {
		$this->SpanColumnLabels();
		$max = $this->MaxColumnLabels();
		$first = true;
		$html = "";
		for($count=0;$count<$max;$count++) {
			if($first) {
				$html .= "<col style=\"width: 100px\" />\n";
			} else {
				$html .= "<col style=\"width: 150px\" />\n";
			}
			$first = false;
		}
		$firstGroupingWidth = "";
		foreach($this->Columns as $col) {
			if($col['labels'][0] == "Grouping") {
				$firstGroupingWidth = $col['width'];
				break;
			}
		}
		foreach($this->Data as $key=>$item) {
			$html .= "<col style=\"width: ".$firstGroupingWidth."px\" />\n";
		}

		if($this->GetParamValue("includeTotalRows") == "1") {
			$html .= "<col style=\"width: 40px\" />\n";
			foreach($this->Totals as $item) {
				$html .= "<col style=\"width: " . $firstGroupingWidth . "px\" />\n";
			}
		}
		$html .= "<col style=\"width: 20px\" />\n";

		$reservation_drilldown = false;
		foreach($this->Columns as $col) {
			if($col['field'] == "rv_reservation.rv_reservation_ix") {
				$reservation_drilldown = true;
			}
		}

		$rowNum = 1;
		$first = true;
		foreach($this->Columns as $col) {
			if($col['labels'][0] != "Grouping") {
				continue;
			}


			$html .= "<tr>\n";

			for($count=0;$count<$max;$count++) {
				if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
					$label = $col['labels'][$count];

					$colspan = "";
					if($count == (sizeof($col['labels']) - 1) && sizeof($col['labels']) < $max) {
						$colspan = "colspan=\"" .($max - sizeof($col['labels']) + 1). "\"";
					}

					$rowspan = "";
					if($col['spans'][$count] > 1) {
						$rowspan = "rowspan=\"" . $col['spans'][$count] . "\"";
					}
					$html .= "<td class=\"outDk\" $colspan $rowspan>$label</td>\n";
				}
			}

			$align = "right"; //$col['align'];

			$colNum = 1;
			foreach($this->Data as $key=>$item) {
				$folios = array();
				foreach($this->Reference[$key] as $newFolios) {
						$folios = array_merge($folios,$newFolios);
				}
				$folios = array_unique($folios);
	
				$onclick = "onclick=\"drillDown('".join(":",$folios)."');\"";
				if($reservation_drilldown) {
					$job = "0";
					if(canEditReservation($item['rv_reservation.rv_reservation_ix'])) {
						$job = "2";
					}
					$onclick = "onclick=\"window.location='/reservation.php?$job+" . $item['rv_reservation.rv_reservation_ix'] . "';\"";
				}

				$html .= "<td id=\"data_".$colNum."_".$rowNum."\" class=\"outDk\" align=\"$align\" onmouseover=\"rowOver(".$colNum.");\" onmouseout=\"rowOut(".$colNum.");\" $onclick style=\"overflow: hidden; cursor: pointer;\">" . $item[$col['field']] . "</td>\n";
				$colNum++;
			}
			if($this->GetParamValue("includeTotalRows") == "1") {
				$label = "";
				if($first) {
					$label = "Totals";
				}
				$html .= "<td class=\"outLtt\" align=\"$align\">$label</td>\n";
				foreach($this->Totals as $item) {
					$html .= "<td class=\"outDk\" align=\"$align\">" . $item[$col['field']] . "</td>\n";
				}
			}
			$html .= "<td class=\"outDk\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>\n";
			$html .= "</tr>\n";
			$rowNum++;
			$first = false;
		}

		return $html;
	}

	function HTML() {
		$this->Padding = 2;

		if(sizeof($this->Data) > 0) {
			$html = "
				<script type=\"text/javascript\">
					function rowOver(num) {
						var count = 1;
						while(id(\"data_\" + num.toString() + \"_\" + count.toString())) {
							id(\"data_\" + num.toString() + \"_\" + count.toString()).style.backgroundColor = \"#cfc\";
							count++;
						}
					}

					function rowOut(num) {
						var count = 1;
						while(id(\"data_\" + num.toString() + \"_\" + count.toString())) {
							id(\"data_\" + num.toString() + \"_\" + count.toString()).style.backgroundColor = \"\";
							count++;
						}
					}

					function colOver(num) {
						var count = 0;
						while(id(\"column_\" + count.toString() + \"_\" + num.toString())) {
							id(\"column_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"#cfc\";
							count++;
						}
						
						var count = 1;
						while(id(\"data_\" + count.toString() + \"_\" + num.toString())) {
							id(\"data_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"#cfc\";
							count++;
						}
					}

					function colOut(num) {
						var count = 0;
						while(id(\"column_\" + count.toString() + \"_\" + num.toString())) {
							id(\"column_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"\";
							count++;
						}
						
						var count = 1;
						while(id(\"data_\" + count.toString() + \"_\" + num.toString())) {
							id(\"data_\" + count.toString() + \"_\" + num.toString()).style.backgroundColor = \"\";
							count++;
						}
					}		

					function drillDown(items) {
						aRequestReset();
						aRequestPost(\"reservation.php?$GLOBALS[job]\", drillDownResult, ['action','items'], ['drillDown',items]);
					}

					function drillDownResult(success,data) {
						if(success) {
							applyTrans(1);
							id(\"drillDown\").innerHTML = data;
							centerDivOnPage(\"drillDown\");	
						}
					}
					
					function drillDownClose() {
						id(\"drillDown\").style.display = \"none\";
						applyTrans();
					}

					function drillDownScroll() {
						id(\"drillDownHeader\").scrollLeft = id(\"drillDownData\").scrollLeft;
					}

					function scrollHeader() {
						id(\"data\").scrollLeft = id(\"header\").scrollLeft;
					}

					function scrollData() {
						id(\"header\").scrollLeft = id(\"data\").scrollLeft;
					}					

				</script>

				<div id=\"drillDown\" class=\"colLtt\" style=\"position:absolute; display: none; width:600px; height: 490px; z-index:100\">
				</div>
				<div id=\"header\" class=\"scrollX\" style=\"width: 770px;\" onscroll=\"scrollHeader();\">
					<table align=\"left\" width=\"".($this->TotalColumnWidth()+20)."\" border=\"0\" cellspacing=\"0\" cellpadding=\"".$this->Padding."\" style=\"table-layout: fixed;\">
			";

			if($this->GetParamValue("outputAxis") == FINANCIAL_ANALYSIS_ROW_PER_GROUP) {
				$html .= $this->HTMLColumnPeriodHeaders();
			} else {
				$html .= $this->HTMLColumnGroupHeaders();
			}

			$html .= "
					</table>
				</div>
				<div id=\"data\" class=\"scrollXY\" style=\"width:770px; height: 600px;\" onscroll=\"scrollData();\">
					<table align=\"left\" width=\"".$this->TotalColumnWidth()."\" border=\"0\" cellspacing=\"0\" cellpadding=\"".$this->Padding."\" style=\"table-layout: fixed;\">
					";

			if($this->GetParamValue("outputAxis") == FINANCIAL_ANALYSIS_ROW_PER_GROUP) {
				$reservation_drilldown = false;
				foreach($this->Columns as $col) {
					$html .= "<col style=\"width: $col[width]px\" />\n";
					if($col['field'] == "rv_reservation.rv_reservation_ix") {
						$reservation_drilldown = true;
					}
				}

				if($reservation_drilldown) {
					$reservations = array();
				}
				$rowNum = 1;
				foreach($this->Data as $key=>$item) {
					$folios = array();
					foreach($this->Reference[$key] as $newFolios) {
						$folios = array_merge($folios,$newFolios);
					}
					$folios = array_unique($folios);

					if($reservation_drilldown) {
						$reservations[] = $item['rv_reservation.rv_reservation_ix'];
					}
					
					$html .= "<tr>\n";
					$colNum = 1;
					foreach($this->Columns as $col) {
						$class = "";
						if(isset($col['class']) && !empty($col['class'])) {
							$class = "class=\"". $col['class'] . "\"";
						}
						$value = $item[$col['field']];
						if($value === "") { $value = "&nbsp;"; }
						$onclick = "onclick=\"drillDown('".join(":",$folios)."');\"";
						if($reservation_drilldown) {
							$job = "0";
							if(canEditReservation($item['rv_reservation.rv_reservation_ix'])) {
								$job = "2";
							}
							$onclick = "onclick=\"window.location='/reservation.php?$job+" . $item['rv_reservation.rv_reservation_ix'] . "';\"";
						}

						$html .= "<td id=\"data_".$rowNum."_".$colNum."\" onmouseover=\"rowOver(".$rowNum.");\" onmouseout=\"rowOut(".$rowNum.")\" $class align=\"$col[align]\" $onclick style=\"overflow: hidden; cursor: pointer;\">$value</td>\n";
						$colNum++;
					}
					$html .= "</tr>\n";
					$rowNum++;
				}

				if($reservation_drilldown) {
					$reservations = array_unique($reservations);
					setRecordScroll($reservations);				
				}			

				if($this->GetParamValue("includeTotalRows") == "1") {
					$html .= "<tr><td class=\"outLtt\" colspan=\"".sizeof($this->Columns)."\">Totals</td></tr>\n";
					foreach($this->Totals as $item) {
						$html .= "<tr>\n";
						foreach($this->Columns as $col) {
							$class = "";
							if(isset($col['class']) && !empty($col['class'])) {
								$class = "class=\"". $col['class'] . "\"";
							}
							$value = $item[$col['field']];
							if($value === "") { $value = "&nbsp;"; }
							$html .= "<td $class align=\"$col[align]\">$value</td>\n";
						}
						$html .= "</tr>\n";
					}
				}
			} else {
				$reservation_drilldown = false;
				$firstGrouping = true;
				$firstGroupingWidth = "";
				$groupCount = 1;
				foreach($this->Columns as $col) {
					if($col['field'] == "rv_reservation.rv_reservation_ix") {
						$reservation_drilldown = true;
					}
					if($col['labels'][0] == "Grouping") {
						$groupCount++;
						if($firstGrouping) {
							$firstGrouping = false;
							$firstGroupingWidth = $col['width'];
						}
					}
				}
				$max = $this->MaxColumnLabels();
				$first = true;
				for($count=0;$count<$max;$count++) {
					if($first) {
						$html .= "<col style=\"width: 100px\" />\n";
					} else {
						$html .= "<col style=\"width: 150px\" />\n";
					}
					$first = false;
				}
				foreach($this->Data as $key=>$item) {
					$html .= "<col style=\"width: ".$firstGroupingWidth."px\" />\n";
				}
				if($this->GetParamValue("includeTotalRows") == "1") {
					$html .= "<col style=\"width: 40px\" />\n";
					foreach($this->Totals as $item) {
						$html .= "<col style=\"width: ".$firstGroupingWidth."px\" />\n";
					}
				}
				$rowNum = $groupCount;
				foreach($this->Columns as $col) {
					if($col['labels'][0] == "Grouping") {
						continue;
					}
					$align = "right"; //$col['align'];

					$html .= "<tr>";
					for($count=0;$count<$max;$count++) {
						if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
							$label = $col['labels'][$count];

							$colspan = "";
							if($count == (sizeof($col['labels']) - 1) && sizeof($col['labels']) < $max) {
								$colspan = "colspan=\"" .($max - sizeof($col['labels']) + 1). "\"";
							}

							$rowspan = "";
							if($col['spans'][$count] > 1) {
								$rowspan = "rowspan=\"" . $col['spans'][$count] . "\"";
							}
							$html .= "<td class=\"outLt $col[class]\" $colspan $rowspan>$label</td>\n";
						}
					}
					$class = "";
					if(isset($col['class']) && !empty($col['class'])) {
						$class = "class=\"". $col['class'] . "\"";
					}
					$colNum = 1;
					foreach($this->Data as $key=>$item) {
						$folios = array();
						foreach($this->Reference[$key] as $newFolios) {
							$folios = array_merge($folios,$newFolios);
						}
						$folios = array_unique($folios);
	
						if($reservation_drilldown) {
							$reservations[] = $item['rv_reservation.rv_reservation_ix'];
						}

						$value = $item[$col['field']];
						if($value === "") { $value = "&nbsp;"; }

						$onclick = "onclick=\"drillDown('".join(":",$folios)."');\"";
						if($reservation_drilldown) {
							$job = "0";
							if(canEditReservation($item['rv_reservation.rv_reservation_ix'])) {
								$job = "2";
							}
							$onclick = "onclick=\"window.location='/reservation.php?$job+" . $item['rv_reservation.rv_reservation_ix'] . "';\"";
						}
						$html .= "<td id=\"data_".$colNum."_".$rowNum."\" $class align=\"$align\" onmouseover=\"rowOver(".$colNum.");\" onmouseout=\"rowOut(".$colNum.")\" $onclick style=\"overflow: hidden; cursor: pointer;\">$value</td>\n";

						$colNum++;
					}
					if($this->GetParamValue("includeTotalRows") == "1") {
						$html .= "<td class=\"outLtt\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>\n";
						foreach($this->Totals as $item) {
							$html .= "<td $class align=\"$align\">" . $item[$col['field']] . "</td>\n";
						}
					}
					$html .= "</tr>\n";
					$rowNum++;
				}

				if($reservation_drilldown) {
					$reservations = array_unique($reservations);
					setRecordScroll($reservations);				
				}			
			}

			$html .= "
					</table>
				</div>
			";
		} else {
			$html = "
				<table width=\"770\">
				<tr>
					<td width=\"100%\" align=\"center\" class=\"txti\">No data found based on specified filter criteria.</td>
				</tr>
				</table>
			";
		}

		return $html;

	}

	function CSVFilter($name) {
		$label = false;
		$value = "";
		if(is_array($name)) {
			list($name,$label,$value) = array_pad( $name, 3, '' );
		}

		if ($name !== false) {
			$param = $this->GetParam($name);
			if($label === false) {
				$label = $param->Filter['label'];
			}
			$class = get_class($param);
		} else {
			$class = "";
		}

		$csv = array();
		switch(strtolower($class)) {
		case "reportparamfilter":
			if($param->Value != "") {
				$csv[] = array($label,$param->Filter['names']);
			}
			break;
		case "reportparamfilterdaterange":
			$csv[] = array($label,chng_date($param->Filter['fromDate'],"-") . " to " . chng_date($param->Filter['toDate'],"-"));
			break;
		case "reportparamfilterdaterangestatus":
			$csv[] = array($label,$param->Filter['statusDateType'] . " from " . chng_date($param->Filter['fromDate'],"-") . " to " . chng_date($param->Filter['toDate'],"-"));
			break;
		case "reportparamfilterdaterangetravel":
			$csv[] = array($label,$param->Filter['travelDateType'] . " from " . chng_date($param->Filter['fromDate'],"-") . " to " . chng_date($param->Filter['toDate'],"-"));
			break;
		case "reportparamfiltercheckarea":
		case "reportparamfiltercheck":
			$csv[] = array($label,($param->Value?"Yes":"No"));
			break;
		default:
			$csv[] = array($label,$value);
			break;
		}

		return $csv;
	}	

	function CSVFilters() {
		$csv = array();

		foreach($this->CSVFilters as $filter) {
			$csv = array_merge($csv,$this->CSVFilter($filter));
		}

		return $csv;
	}

	function CSVColumnPeriodHeaders() {
        $this->SpanColumnLabels();
		$max = $this->MaxColumnLabels();

		$csv = array();
		for($count=0;$count<$max;$count++) {
			$row = array();
			foreach($this->Columns as $col) {
				if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
					$row[] = $col['labels'][$count];
				} else {
					$row[] = "";
				}
			}
			$csv[] = $row;
		}

		return $csv;
 	}

	function CSVColumnGroupHeaders() {
		$this->SpanColumnLabels();
		$max = $this->MaxColumnLabels();

		$csv = array();

		foreach($this->Columns as $col) {
			if($col['labels'][0] != "Grouping") {
				continue;
			}
			$row = array();
			for($count=0;$count<$max;$count++) {
				if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
					$row[] = $col['labels'][$count];
				} else {
					$row[] = "";
				}
			}
			foreach($this->Data as $key=>$item) {
				$row[] = $item[$col['field']];
			}
			if($this->GetParamValue("includeTotalRows") == "1") {
				$row[] = "Totals";
				foreach($this->Totals as $item) {
					$row[] = $item[$col['field']];
				}
			}
			$csv[] = $row;
		}

		return $csv;
	}

	function CSV() {
		$csv = array();
		$csv[] = array("Report",$this->Title);

		$csv = array_merge($csv,$this->CSVFilters());

		$csv[] = array();
		if(sizeof($this->Data) > 0) {
			if($this->GetParamValue("outputAxis") == FINANCIAL_ANALYSIS_ROW_PER_GROUP) {
				$csv = array_merge($csv,$this->CSVColumnPeriodHeaders());
				foreach($this->Data as $item) {
					$row = array();
					foreach($this->Columns as $col) {
						$value = $item[$col['field']];
						$row[] = $value;
					}
					$csv[] = $row;
					if (isset($html)) {
						$html .= "</tr>\n";
					} else {
						$html = "</tr>\n";
					}
				}

				if($this->GetParamValue("includeTotalRows") == "1") {
					$csv[] = array("Totals");
					foreach($this->Totals as $item) {
						$row = array();
						foreach($this->Columns as $col) {
							$value = $item[$col['field']];
							$row[] = $value;
						}
						$csv[] = $row;
					}
				}
			} else {
				$max = $this->MaxColumnLabels();
				$csv = array_merge($csv,$this->CSVColumnGroupHeaders());
				foreach($this->Columns as $col) {
					if($col['labels'][0] == "Grouping") {
						continue;
					}
					$row = array();
					for($count=0;$count<$max;$count++) {
						if(isset($col['labels'][$count]) && $col['spans'][$count] != 0) {
							$row[] = $col['labels'][$count];
						} else {
							$row[] = "";
						}
					}
					foreach($this->Data as $key=>$item) {
						$row[] = $item[$col['field']];
					}
					if($this->GetParamValue("includeTotalRows") == "1") {
						$row[] = "";
						foreach($this->Totals as $item) {
							$row[] = $item[$col['field']];
						}
					}
					$csv[] = $row;
				}
			}

		} else {
			$csv = array(
				array("No data found based on specified filter criteria.")
			);
		}

		return $csv;
	}

	function getMemoryUsage($output=false,$label="adhoc") {
		$mem = memory_get_usage();
		if($mem > 1024) {
			$mem = $mem / 1024;
			$unit = "kb";
		}
		if($mem > 1024) {
			$mem = $mem / 1024;
			$unit = "mb";
		}

		$mem = sprintf("%.4f$unit",round($mem,4));

		if($output) {
			debug("[$label] Memory usage is: $mem");
		}
	}
	
}

function showMemUsage($msg=false) {
	$usage = memory_get_usage();
	$peak = memory_get_peak_usage();
	$peakTrue = memory_get_peak_usage(true);
	$limit = ini_get("memory_limit");
	if($msg !== false) {
		echo "$msg: ";
	}
	echo "memory used=".convertBytes($usage)." ($usage), peak=".convertBytes($peak)." ($peak), true peak=$peakTrue, limit=$limit<br/>";
}

function convertBytes($size) {
    $unit=array('b','kb','mb','gb','tb','pb');
    return @round($size/pow(1024,($i=floor(log($size,1024)))),2).''.$unit[$i];
}
