<?php

/**
 * init.form1008.php - Financial Analysis (Folio)
 * Job: 1012
 * Function: 105 (Reports Financials: Financial Analysis)
 */

// Set the time limit to 30 minutes
@set_time_limit(1800);

$_POST['action'] = isset($_POST['action']) ? $_POST['action'] : "";

switch($_POST['action']) {
case "drillDown":
	switch($job) {
	case FINANCIAL_ANALYSIS_DAY:
		$drillDown = new FinancialAnalysisDrillDownRes($job,explode(":",$_POST['items']));
		$drillDown->Render();
		break;
	case FINANCIAL_ANALYSIS_FOLIO:
		$drillDown = new FinancialAnalysisDrillDownFolio($job,explode(":",$_POST['items']));
		$drillDown->Render();
		break;
	}
	break;
default:
	global $report;

	switch($job) {
	case FINANCIAL_ANALYSIS_DAY:
		// Set the internal name of the report (used for profile name, Javascript and custom HTML files)
		$name = "financial_analysis_day";
		// Set the title of the report
		$title = "Financial Analysis Report Per Day";
		$report = new FinancialAnalysisDayReport($form,$name,$title); // Create the Report object
		break;
	case FINANCIAL_ANALYSIS_FOLIO:
		// Set the internal name of the report (used for profile name, Javascript and custom HTML files)
		$name = "financial_analysis_folio";
		// Set the title of the report
		$title = "Financial Analysis Report Per Folio";
		$report = new FinancialAnalysisFolioReport($form,$name,$title); // Create the Report object
		break;
	}
	$report->Render(); // Render the Report, including all parameters and the data section if the report has been generated
	break;
}
