<?php

/**
 * init.form1011.php - Transaction report check codes popup
 * Job: 1020
 * Function: 101 (Financial: GL Batch)
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],1,"");

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_tran_gl_pop.htm");
}

$GLOBALS['temp']['reloadParent'] = "0";
if(isset($_POST['regenTransactions']) && $_POST['regenTransactions'] != "") {
	tran_regenerate(array_unique(explode(":",$_POST['regenTransactions'])));
	$GLOBALS['temp']['reloadParent'] = "1";
}

$GLOBALS['temp']['type'] = (isset($_POST['type'])?$_POST['type']:"");
$GLOBALS['temp']['desc'] = (isset($_POST['desc'])?$_POST['desc']:"");

$transactions = explode(":",(isset($_POST['transactions'])?$_POST['transactions']:""));
$GLOBALS['temp']['transactions'] = join(":",$transactions);

$list = $lDB->get("
	SELECT
		fn_tran.fn_tran_ix,
		fn_tran.fn_tran_date_ledger,
		fn_tran.fn_tran_link_ind,
		fn_tran.fn_tran_link_id,
		fn_tran.rv_reservation_id,
		rv_reservation.rv_res_name,
		fn_folio.rf_currency_id AS folio_currency_id,
		pr_folio.pr_name_last as pr_folio_last,
		pr_folio.pr_name_first as pr_folio_first,
		rv_payment.rv_payment_ix,
		pr_payment.pr_name_last as pr_payment_last,
		pr_payment.pr_name_first as pr_payment_first,
		fn_tran.fn_tran_amt_incl,
		pr_business.pr_bus_name_short,
		fn_tran.fn_batch_id,
		fn_batch.fn_batch_ix,
		fn_batch.fn_batch_name,
		fn_batch.fn_batch_closed_yn,
		fn_year.fn_year_desc,
		fn_year.fn_year_end_date,
		SUM(fn_tran_item.fn_tran_item_amt) as fn_tran_item_amt,
		fn_tran_contra.fn_tran_ix AS fn_tran_contra_id,
		rf_currency.rf_currency_symbol
	FROM
		fn_tran
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
		INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		LEFT JOIN pr_persona AS pr_folio ON pr_folio.pr_persona_ix = fn_folio.fn_folio_to_id
		LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		LEFT JOIN fn_year ON fn_year.fn_year_ix = fn_batch.fn_year_id
		LEFT JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_tran.fn_tran_link_id
		LEFT JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
		LEFT JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
		LEFT JOIN pr_persona AS pr_payment ON pr_payment.pr_persona_ix = rv_payment.pr_persona_id
		LEFT JOIN fn_tran_item ON fn_tran_item.fn_tran_id = fn_tran.fn_tran_ix
		LEFT JOIN fn_tran AS fn_tran_contra ON fn_tran.fn_tran_contra_id = fn_tran_contra.fn_tran_ix
		INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_tran.rf_currency_id
	WHERE
		fn_tran.fn_tran_ix IN ('".join("','",$transactions)."')
	GROUP BY
		fn_tran.fn_tran_ix
",2);

$rowItems = array();
$GLOBALS['temp']['regenerateButton'] = "";
if($GLOBALS['jobLevelArray'][1020] > 5) {
	$GLOBALS['temp']['regenerateButton'] = "
		<td width=\"75\" align=\"center\"><button onclick=\"regenTran();\" type=\"button\" style=\"width:160px;\" class=\"button printCollapse\">Regenerate selected</button></td>
	";
	$rowItems['check'] = "
		<td class=\"bl\" align=\"center\" onclick=\"event.cancelBubble = true;\"><input type=\"checkbox\" id=\"!fn_tran_ix!\" name=\"code_check\" /></td>
	";
} else {
	$rowItems['check'] = "<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
}

$rowHTML = showpage($rowItems,join("",file(__DIR__ . "/../../../public/html/fin_ledger_tran_gl_popup_row.htm")));
$rows = "";
foreach($list as $item) {
	list($fn_tran_date_ledger_date, $fn_tran_date_ledger_time) = explode(" ",$item['fn_tran_date_ledger']);
	$item['fn_tran_date_ledger_fmt'] = chng_date($fn_tran_date_ledger_date,"-");
	$item['fn_tran_link_desc'] =  db_fn_tran_link_desc($item['fn_tran_link_ind']);
	if($item['fn_tran_link_ind'] != DB_FN_TRAN_LINK_INVOICE) {
		$pr_name = trim($item['pr_payment_first'] . " " . $item['pr_payment_last']);
		if($pr_name == "") {
			$pr_name = "Cash";
		}
		$item['fn_tran_link_id'] = $item['rv_payment_ix'];
	} else {
		$pr_name = trim($item['pr_folio_first'] . " " . $item['pr_folio_last']);
		if($pr_name == "") {
			$pr_name = "Cash";
		}
	}
	$item['pr_name'] = $pr_name;

	$item['fn_tran_amt_incl'] = round($item['fn_tran_amt_incl'],2);
	fixAmtDisplay($item['fn_tran_amt_incl'],2);
	$rows .= showpage($item,$rowHTML);
}
$GLOBALS['temp']['rows'] = $rows;


$GLOBALS['temp']['tranItemPopupJob'] = "296";
if(isset($GLOBALS['jobLevelArray'][1018]) && $GLOBALS['jobLevelArray'][1018] > 5) {
	$GLOBALS['temp']['tranItemPopupJob'] = "1018";
}
