<?php

/**
 * init.form1011.php - Payment gateway deposits
 * Job: 1021 (edit), 1022 (save)
 * Function: 1002 (Payments: Deposit)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/payment_gateway_deposit.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'], 6, "");
$reservationId = $_POST['resId'] ?? $_SERVER['argv'][2];
$autoFind = $_POST['autoFind'] ?? $_SERVER['argv'][3];
$email = $_POST['email'] ?? $_SERVER['argv'][4];
$autoLogin = isset($_SERVER['argv'][5]) && $_SERVER['argv'][5] == "1" ? true : false;

$startup = "";

if ($autoLogin) {
	$startup .= '
		<script>
			loginAction();
		</script>
	';
}

$GLOBALS['temp']['userStatusId'] = $userStatusId;
if($userStatusId < 2) {
	$GLOBALS['temp']['hideForInternal'] = "";
	$GLOBALS['temp']['hideForNonInternal'] = "collapse printCollapse";
	$GLOBALS['temp']['reservation_label'] = "Your booking / reservation number";
} else {
	$GLOBALS['temp']['hideForInternal'] = "collapse printCollapse";
	$GLOBALS['temp']['hideForNonInternal'] = "";
	$GLOBALS['temp']['reservation_label'] = "Reservation number";
}


if(isset($_POST['action'])) {
	if($_POST['action'] == "login") {

		// In order to solve an issue of guests not knowing which email is used when creating a reservation,
		// we need to "disable" email validation.
		// When only a reservation number is provided, and no email address, email validation is excluded.
		// When we rebuild this page we need to revisit that we have removed this verification if the display
		// includes itinerary and personal information.

		if($userStatusId < 2 && !empty($_POST['email'])) {
			$emailWhere = "
				AND pr_persona.pr_email = '$_POST[email]'
			";
		} else {
			$emailWhere = "";
		}
		$folios = $lDB->get("
			SELECT
				fn_folio.fn_folio_db,
				fn_folio.fn_folio_ix,
				fn_folio.fn_folio_folio_num,
				fn_folio.fn_folio_amount,
				fn_folio.fn_folio_amt_paid,
				(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) AS fn_folio_amt_outstanding,
				fn_folio.rf_currency_id,
				rf_currency.rf_currency_symbol
			FROM
				fn_folio
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
			WHERE
				(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
				AND fn_folio.rv_reservation_id = '$reservationId'
				$emailWhere
			ORDER BY
				fn_folio.fn_folio_folio_num
		",2);
		if(sizeof($folios) == 0) { // login failue
			echo showpage(array(
				'hideForInternal' => $GLOBALS['temp']['hideForInternal'],
				'hideForNonInternal' => $GLOBALS['temp']['hideForNonInternal']
			),join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_login_error.htm")));
		} else {
			$rows = "";
			$html = join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_folio_row.htm"));
			if($userStatusId < 2) {
				$folio_currency_col_width = "134";
				$folio_span = "7";
				$folio_outstanding_border = "br";
				$folio_popup_button = "";
			} else {
				$folio_currency_col_width = "126";
				$folio_span = "8";
				$folio_outstanding_border = "";
				$folio_popup_button = "
					<td align=\"center\" class=\"bl br\">&nbsp;</td>
				";
			}

			$resEnv= $lDB->get("
				SELECT
					rv_reservation_db
				FROM
					rv_reservation
				WHERE
					rv_reservation_ix= '" . $reservationId . "'
			", 4);

			$onlyFullPaymentRequired = true;	// Do we have any folios that do not require full payment? Let's see...

			foreach($folios as $folio) {
				if($userStatusId < 2) {
					$folio['folio_outstanding_border'] = "br";
					$folio['folio_popup_button'] = "";
				} else {
					$folio['folio_outstanding_border'] = "";
					$folio['folio_popup_button'] = "
						<td align=\"center\" class=\"bl br\">
							<button type=\"button\" class=\"button bFolio\" style=\"width: 20px; height: 20px; background-position: center\" onclick=\"event.cancelBubble = true; showFolio('$folio[fn_folio_ix]');\" onmouseover=\"overlib('View profoma',WIDTH,100);\" onmouseout=\"nd();\"></button>
						</td>
					";
				}

				$folioEnv = $folio['fn_folio_db'];
				$folio['fullPaymentRequired'] = '1';
				if (!in_array($folioEnv[0], array("W", "R")) && $folioEnv == $resEnv) {
					// Not WB or Rx, property matches
					$folio['fullPaymentRequired'] = '0';
					$onlyFullPaymentRequired = false;
				}

				if (in_array($folioEnv[0], array("W", "R")) && in_array($resEnv[0], array("W", "R"))) {
					// Folio and Res environments are either WB or Rx
					$folio['fullPaymentRequired'] = '0';
					$onlyFullPaymentRequired = false;
				}

				$rows .= showpage($folio,$html);
			}
			if($userStatusId < 2) {
				$folio_popup_col = "";
				$folio_popup_header = "";
			} else {
				$folio_popup_col = "<col width=\"40\" />";
				$folio_popup_header = "<th class=\"outLt uk-text-right\"></th>";
			}

			$paymentPlanOptions = "";
			$paymentPlan = getPayItems($reservationId);

			foreach ($paymentPlan['items'] as $item) {
				if ($item['type'] == "total_payable") {
					$paymentPlanOptions .= '<option value="100">Total payable: 100%</option>';
				}
			}

			if (!$onlyFullPaymentRequired) {	// Do we have any folios that do not require full payment? If not, don't offer payment plan options
				foreach ($paymentPlan['items'] as $item) {
					$percentage = ceil((100 / $paymentPlan['payTotal']) * $item['rv_pay_plan_amount']);
					if ($item['type'] == "item") {
						$paymentPlanOptions .= '<option value="' . $percentage . '"> Due ' . $item['pay_date'] . ': ' . $percentage . '%</option>';
					}
				}
			}

			echo showpage(array(
				'rows'=>$rows,
				'rv_reservation_id'=>$reservationId,
				'email'=>t_encodeHTMLField($email),
				'folio_popup_col'=>$folio_popup_col,
				'folio_popup_header'=>$folio_popup_header,
				'folio_span'=>$folio_span,
				'folio_currency_col_width'=>$folio_currency_col_width,
				'folio_outstanding_border'=>$folio_outstanding_border,
				'folio_popup_button'=>$folio_popup_button,
				'exchange_rates'=>t_encodeHTMLField(json_encode(db_rf_exchange_rate_get_all_rates())),
				'paymentPlanOptions'=>$paymentPlanOptions
			),join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_folio.htm")));
		}
	}
	if($_POST['action'] == "find") {
		$resId = $reservationId;
		$resName = $_POST['resName'];
		$voucherRef = $_POST['voucherRef'];
		$invoiceId = $_POST['invoiceId'];
		if($resId == "") { $resId = "*"; }
		if($resName == "") { $resName = "*"; }
		if($voucherRef == "") { $voucherRef = "*"; }
		if($invoiceId == "") { $invoiceId = "*"; }

		$propertyACL= $lDB->get("
			SELECT DISTINCT
				ac_accomm_type.pr_business_id
			FROM
				sc_accomm
				INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
				INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			WHERE
				sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
				AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
				/*AND pr_business.pr_bus_inactive_yn= '0'*/
		",3);

		$accommACL = $lDB->get("
			SELECT
				sc_accomm.ac_accomm_type_id
			FROM
				sc_accomm
				INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id AND sc_user.pr_user_id = '$GLOBALS[userid]'
		",3);

		$agentACL = "";
		if($userStatusId < 2) {
		   $agentACL = " AND rv_reservation.rv_agent_id = '$calAgentId' ";
		}

		$statusACL = $lDB->get("
			SELECT
				rf_reservation_status_id
			FROM
				rf_reservation_status
			WHERE
				rf_reservation_status_id <> 25
				AND rf_reservation_status_id <> 15
				AND rf_reservation_status_id <> 97
		",3);

		$invoiceJoin = "";
		$invoiceWhere = "";
		if(!empty($invoiceId) && $invoiceId != "*") {
			$invoiceJoin = "
				LEFT JOIN fn_invoice ON fn_invoice.rv_reservation_id = rv_reservation.rv_reservation_ix
			";
			$invoiceWhere = "
				AND fn_invoice.fn_invoice_ix LIKE '".$lDB->like($invoiceId)."'
			";
		}

		$resList = $lDB->get("
			SELECT DISTINCT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				pr_persona.pr_name_last,
				rf_reservation_status.rf_reservation_status_desc,
				rv_reservation.rv_date_arrive,
				rv_reservation.rv_date_depart,
				rv_reservation.rv_agent_ref,
				rv_reservation.rf_reservation_status_id,
				rv_reservation.rv_provision_expiry_date
			FROM
				rv_reservation
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
				$invoiceJoin
			WHERE
				rv_reservation.rv_reservation_ix LIKE '".$lDB->like($resId)."'
				AND rv_reservation.rv_res_name LIKE '".$lDB->like($resName)."'
				AND rv_reservation.rv_agent_ref LIKE '".$lDB->like($voucherRef)."'
				$agentACL
				AND rv_reservation_item.pr_business_id IN ('".join("','",$propertyACL)."')
				AND rv_reservation_item.ac_accomm_type_id IN ('".join("','",$accommACL)."')
				AND rv_reservation.rf_reservation_status_id IN ('".join("','",$statusACL)."')
				$invoiceWhere
			ORDER BY rv_reservation.rv_date_arrive desc,
				rv_reservation.rv_date_depart desc,
				rv_reservation.rv_res_name asc
			LIMIT 0,10
		",2);

		$data = array(
			'action' => 'render'
		);
		if(sizeof($resList) > 1) {	
			$rows = "";
			$html = join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_find_row.htm"));
			foreach($resList as $item) {
				$item['rv_date_arrive'] = chng_date($item['rv_date_arrive'],"-");
				$item['rv_date_depart'] = chng_date($item['rv_date_depart'],"-");
				$rows .= showpage($item,$html);
			}
			$data['output'] = showpage(array(
				'rows' => $rows
			),join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_find.htm")));
		} elseif(sizeof($resList) == 1) {
			$data['resId'] = $resList[0]['rv_reservation_ix'];
			$data['action'] = "login";
		} else {
			$data['output'] = "
				<br />
				<p class=\"txti\">Your search did not match any records.</p>
				<div class=\"buttonGroup\">
					<button type=\"button\" class=\"button masterButton\" onclick=\"loginRetry();\">Try again</button>
				</div>
			";
		}
		echo json_encode($data);
	}
	if($_POST['action'] == "payment_gateway_popup") {
		$folios = json_decode($_POST['folios']);
		clearPaymentGateway();
		$amount = isset($_POST['amount']) && !empty($_POST['amount']) ? $_POST['amount'] : true;
		$pg_accounts = loadPaymentGateway(PAYMENT_GATEWAY_TYPE_DEPOSIT,$folios,$_POST['rv_reservation_id'],$amount,$_POST['rf_currency_id']);
		echo createPaymentGatewayPopup($pg_accounts);
	}
	if($_POST['action'] == "pay_now") {
		session_set("rv_payment_gateway_data",$_POST);
		$pg_accounts = loadPaymentGateway();
		initPaymentGateway($pg_accounts);
	}
	die();
}

$GLOBALS['temp']['divLoginClass'] = "";
$GLOBALS['temp']['divReceiptClass'] = "collapse printCollapse";
$GLOBALS['temp']['receipt'] = "";
$GLOBALS['temp']['folios'] = "{}";

if(isset($_POST['paymentAction']) && $_POST['paymentAction'] == "session") {
	$_POST = $_SESSION['rv_payment_gateway_data'];
	if(empty($_POST)) {
		redirectTo(" reservation.php?1021");
		die();
	}
	$payment = $_SESSION['rv_payment_gateway_result'];
	if($payment['status'] == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$folios = json_decode($_POST['folios'],true);

		
		$originalFolioIds = $_SESSION['rv_payment_gateway_folios'];
		$finalFolioIds = array_keys($folios);

		sort($originalFolioIds);
		sort($finalFolioIds);

		$pg_accounts = loadPaymentGateway();
		$pg_account = $pg_accounts[0];

		if($originalFolioIds != $finalFolioIds) {
			$title = "Payment error";
			$id = (!empty($payment['id'])?", reference $payment[id]":"");
			$message = "There has been an error while proccessing your payment$id:<br /><br />$payment[message]";
			$startup .= "
				<script>
					loginAction('".t_encodeOverlib($message)."','".t_encodeOverlib($title)."');
				</script>
			";
			$GLOBALS['temp']['folios'] = $_POST['folios'];
		} else {
			$newFolios = array();
			$exchanges = $_SESSION['rv_payment_gateway_exchanges'];
			foreach($folios as $fn_folio_id=>$fn_folio_amount) {
				$folio_currency_id = $lDB->get("
					SELECT
						fn_folio.rf_currency_id
					FROM
						fn_folio
					WHERE
						fn_folio.fn_folio_ix = '$fn_folio_id'
				",4);
				$folioExchange = false;
				if($folio_currency_id == $pg_account['rf_currency_id']) {
					$folioExchange = 1;
				} else {
					foreach($exchanges as $exchange) {
						if(
							$exchange['rf_exch_curr_to_id'] == $folio_currency_id
							&& $exchange['rf_exch_curr_from_id'] == $pg_account['rf_currency_id']
						) {
							$folioExchange = $exchange['rf_exch_rate'];
							break;
						}
					}
				}
				if($folioExchange === false) {
					// This should never happen under normal circumstances, added for security purposes
					error_log("Missing exchange rate after deposit");
					die();
				}
				//$amount = round($fn_folio_amount * $folioExchange,2);
				//fixAmtDisplay($amount);

				$newFolios[$fn_folio_id] = array(
					'amount'=>$fn_folio_amount / $folioExchange,
					'exchange'=>$folioExchange
				);
			}
			$folios = $newFolios;
			unset($newFolios);

			$rv_payment_gateway_id = $_SESSION['rv_payment_gateway_id'];
			$rv_reservation_id = $reservationId;


			$rv_payment_id = db_rv_payment_insert("",date("Y-m-d"),$pg_account['rf_bank_id'],$pg_account['rf_mthd_pmnt_id'],$payment['id']);


			foreach($folios as $fn_folio_id=>$folio) {
				$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$folio['amount'],$folio['exchange'],false,false,$rv_payment_gateway_id);
			}

			recalcTotals($rv_reservation_id);
			ammendReservation($rv_reservation_id,"Payment");

			if($userStatusId < 2) {
				$rv_res_name = $lDB->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$reservationId'",4);
				$rf_currency_symbol = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$pg_account[rf_currency_id]'",4);
				$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
				list($resOfficeEmail, $resOfficeWebsite) = $lDB->get("
					SELECT
						pr_persona.pr_email,
						pr_persona.pr_web_addr
					FROM
						pr_persona
					WHERE
						pr_persona.pr_persona_ix = '$resOfficeId'
				",1);
				$resOfficeTelephone =  getDefPhoneNumber($resOfficeId);

				$principalNames = $lDB->get("
					SELECT
						pr_persona.pr_name_first,
						pr_persona.pr_name_last
					FROM
						rf_default
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rf_default.rf_principal_id
				",1);
				$principalName = trim($principalNames['pr_name_first'] . " " . $principalNames['pr_name_last']);

				$message = "PAYMENT CONFIRMATION
This is an automated message.

Thank you. Your payment has been processed successfully.

PAYMENT INFORMATION
Reservation number: $reservationId
Reservation name: $rv_res_name
Payment method: Credit card
Payment amount: " . db_round($payment['amount']) . " $rf_currency_symbol
Payment date: " . date("Y-m-d") . "

Please contact our reservation office if you have any queries.

RESERVATION OFFICE
";
				if(!empty($resOfficeTelephone)) {
					$message .= "Telephone: $resOfficeTelephone\n";
				}
				if(!empty($resOfficeEmail)) {
					$message .= "Email: $resOfficeEmail\n";
				}
				if(!empty($resOfficeWebsite)) {
					$message .= "Website: $resOfficeWebsite\n";
				}

				$subject = "Payment confirmation for reservation $reservationId via ResRequest";

				$to = $lDB->get("
					SELECT
						pr_persona.pr_email
					FROM
						fn_folio
						INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
					WHERE
						fn_folio.fn_folio_ix = '".$originalFolioIds[0]."'
				",4);
				$from = $resOfficeEmail;
				$headers = "From: ".$principalName."<$from>\r\n";

				email($from, $to, $subject, $headers, $message, 0, 0, $reservationId, $principalName);

				$v3Response = redirectIfV3Imageset("Payment successful! Your payment has been completed. Please check your email for further details.");
				
				if (!$v3Response) {
					echo "
						<form id=\"receiptForm\" method=\"POST\">
							<input type=\"hidden\" name=\"paymentAction\" value=\"receipt\" />
							<input type=\"hidden\" name=\"resId\" value=\"$reservationId\" />
							<input type=\"hidden\" name=\"email\" value=\"".t_encodeHTMLField($email)."\" />
							<input type=\"hidden\" name=\"paymentId\" value=\"$rv_payment_id\" />
							<input type=\"hidden\" name=\"folios\" value=\"".t_encodeHTMLField($_POST['folios'])."\" />
						</form>
						<script>
							document.getElementById(\"receiptForm\").submit();
						</script>
					";
				}
			} else {
				redirectTo(" reservation.php?298+$rv_payment_id");
			}
			session_set("rv_payment_gateway_data",array());
			die();
		}
	} else {
		switch($payment['status']) {
		case DB_RV_PAYMENT_GATEWAY_DECLINED:
			$title = "Payment declined";
			$id = (!empty($payment['id'])?", reference $payment[id],":"");
			$message = "Your payment$id has been declined with the following error:<br /><br />$payment[message]";
			break;
		case DB_RV_PAYMENT_GATEWAY_ERROR:
			$title = "Payment error";
			$id = (!empty($payment['id'])?", reference $payment[id]":"");
			$message = "There has been an error while proccessing your payment$id:<br /><br />$payment[message]";
			break;
		}
		redirectIfV3Imageset($message);
		$startup .= "
			<script>
				loginAction('".t_encodeOverlib($message)."','".t_encodeOverlib($title)."');
			</script>
		";
		$GLOBALS['temp']['folios'] = $_POST['folios'];
	}
}

if(isset($_POST['paymentAction']) && $_POST['paymentAction'] == "receipt") {
	$GLOBALS['temp']['divLoginClass'] = "collapse printCollapse";
	$GLOBALS['temp']['divReceiptClass'] = "";
	$GLOBALS['temp']['receipt'] = showpage(array(
		'rv_reservation_id' => $reservationId,
		'rv_payment_id' => $_POST['paymentId']
	),join("",file(__DIR__ . "/../../../public/html/payment_gateway_deposit_receipt.htm")));
}

if($autoFind == "1") {
	$startup .= "<script>findAction()</script>";
}

$GLOBALS['temp']['title'] = "Online credit card payment";
$GLOBALS['temp']['startup'] = $startup;

if(isset($reservationId)) {
	$GLOBALS['temp']['resId'] = $reservationId;
} else {
	$GLOBALS['temp']['resId'] = "";
}

if(!empty($email)) {
	$GLOBALS['temp']['email'] = $email;
} else {
	$GLOBALS['temp']['email'] = "";
}

if(isset($_POST['resName'])) {
	$GLOBALS['temp']['resName'] = $_POST['resName'];
} else {
	$GLOBALS['temp']['resName'] = "";
}

if(isset($_POST['voucherRef'])) {
	$GLOBALS['temp']['voucherRef'] = $_POST['voucherRef'];
} else {
	$GLOBALS['temp']['voucherRef'] = "";
}

if(isset($_POST['invoiceId'])) {
	$GLOBALS['temp']['invoiceId'] = $_POST['invoiceId'];
} else {
	$GLOBALS['temp']['invoiceId'] = "";
}

global $principal_id;
global $server;
$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";

if ($userStatusId == "0") {            // Accessed from public imageset
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/payment_gateway_deposit.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file("$GLOBALS[images_dir_on_disk]/$principal_id/payment_gateway_deposit.htm")));
	}

	$indexCSS = "";

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/payment_gateway_deposit.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/payment_gateway_deposit.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "<link rel=\"stylesheet\" href=\"/resource/Resrequest/Application/public/css/payment_gateway_deposit.css\" type=\"text/css\">";
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/global.css")) {
		$indexCSS .= "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />";
	}

	$GLOBALS['temp']['customCSS'] = "
		$indexCSS
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "
			<style>
				body {
					background-color: transparent !important;
				}
			</style>
		";
	}
}

require_once(__DIR__ . '/functions.imageset.php');
$GLOBALS['temp']['hideForV3Imageset'] = isV3Imageset($principal_id) ? "collapse printCollapse" : "";
$GLOBALS['temp']['v3ImagesetPadding'] = isV3Imageset($principal_id) ? "uk-padding" : "";

function redirectIfV3Imageset($message="") {
	// If we have a public V3 imageset user, look up details and redirect

	require_once(__DIR__ . '/functions.imageset.php');

	$guest = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email,
			fn_folio.rv_reservation_id
		FROM
			rv_payment_gateway_folio
			LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_gateway_folio.fn_folio_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		WHERE
			rv_payment_gateway_folio.rv_payment_gateway_id = '" . $_SESSION['rv_payment_gateway_id'] . "'
	", 1);

	if (
		$GLOBALS['userStatusId'] == "0" &&
		$GLOBALS['pr_sys_code'] == "7" &&
		isV3Imageset($GLOBALS['principal_id']) &&
		!empty($guest['rv_reservation_id']) &&
		!empty($guest['pr_email']) &&
		!empty($message)
	) {
		$data = [
			'resId' => $guest['rv_reservation_id'],
			'email' => $guest['pr_email'],
			'v3Response' => $message   // message to be displayed in imageset
		];
		redirectTo("/public/paynow.php", $data);
		die;
	}
	return false;
}