<?php

/**
 * init.form1013.php - Archive selection popup
 * Job: 1023
 * Function: 66 (General access)
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],1,"");

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/archive_pop.htm");
}

if(isset($_POST['action']) && $_POST['action'] == "authenticate") {
	$archive_access = isset($_SESSION['archive_access'])?$_SESSION['archive_access']:array();
	$allow = false;
	$id = "";
	if($GLOBALS['allowArchive']) {
		$idPadded = isset($_POST['archiveId'])?$_POST['archiveId']:"";
		$id = ltrim($idPadded,"0");
		if(!empty($id) && is_numeric($id) && $id > 0) {
			$archive_access[$id] = true;
			db_ad_archive_insert($id);
			$allow = true;
		}
	} else {
		$archive_access = array();
	}
	session_set("archive_access",$archive_access);
	echo json_encode(array('allow'=>$allow,'id'=>$idPadded));
	die();
}

$rows = "";
$rowHTML = join("",file(__DIR__ . "/../../../public/html/archive_pop_row.htm"));

$list = $lDB->get("
	SELECT
		rf_archive.rf_archive_id,
		rf_archive.rf_archive_name,
		rf_archive.rf_archive_note,
		rf_archive.ad_create_date
	FROM
		rf_archive
	ORDER BY
		rf_archive.ad_create_date
",2);
foreach($list as $item) {
	$item['rf_archive_id_fmt'] = str_pad($item['rf_archive_id'],2,"0",STR_PAD_LEFT);
	$item['rf_archive_note_overlib'] = "";
	list($date,$time) = explode(" ",$item['ad_create_date']);
	$item['ad_create_date_fmt'] = chng_date($date,"-");
	if(!empty($item['rf_archive_note'])) {
		$item['rf_archive_note_overlib'] = "overlib('".t_encodeOverlib($item['rf_archive_note'])."');";
	}

	$rows .= showpage($item,$rowHTML);
}

if($rows == "") {
	$rows = "<tr><td colspan=\"3\" class=\"txti\" align=\"center\">No archives found</td></tr>";
}
$GLOBALS['temp']['rows'] = $rows;
