<?php

/*
 * init.form1016.func.php - Open and close out rooms
 */

require_once(__DIR__ . "/class.stock.php");
require_once(__DIR__ . "/db.ac_accomm_block.php");
require_once(__DIR__ . "/db.ac_accomm_room_block.php");
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.report.php');

$profileFields = [
	/*  1 */ '', // from date, not saved
	/*  2 */ 'accommFilter'
];

function getAvailablePerDay($ac_accomm_type_id, $start_date, $end_date) {
	$stock = new Stock($ac_accomm_type_id, $start_date, $end_date);
	return $stock->ToAvailability();
}

function getRoomBlocksOnDay($ac_accomm_type_id, $date) {
	global $lDB;

	$roomsRaw = $lDB->get("
		SELECT
			ac_accomm_room.ac_accomm_room_ix AS ac_accomm_room_id,
			ac_accomm_room.ac_desc
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_type.ac_accomm_type_ix = '" . $lDB->escape($ac_accomm_type_id) . "'
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '".$lDB->escape($date)."'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '".$lDB->escape($date)."'
					AND ac_accomm_room.ac_accomm_room_create_date <= '".$lDB->escape($date)."'
				)
			)
	",6);
	$rooms = [];
	foreach($roomsRaw as $room) {
		$ac_accomm_room_id = $room['ac_accomm_room_id'];
		$rooms[$ac_accomm_room_id] = array_merge($room,[
			'has_static'=>false,
			'has_dynamic'=>false,
			'is_unblocked'=>false,
			'blocks'=>[]
		]);
	}
	unset($roomsRaw);

	$blocks = $lDB->get("
		SELECT
			ac_accomm_room.ac_accomm_room_ix AS ac_accomm_room_id,
			ac_accomm_room.ac_desc,
			ac_accomm_block.ac_accomm_block_ix AS ac_accomm_block_id,
			ac_accomm_block.ac_type_ind,
			ac_accomm_block.ac_start_date,
			ac_accomm_block.ac_end_date,
			ac_accomm_block.ac_reason,
			ac_accomm_room_block.ac_accomm_room_block_ix AS ac_accomm_room_block_id
		FROM
			ac_accomm_room_block
			INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_block.ac_accomm_type_id
		WHERE
			ac_accomm_block.ac_accomm_type_id = '" . $lDB->escape($ac_accomm_type_id) . "' 
			AND ac_accomm_block.ac_start_date <= '" . $lDB->escape($date) . "'
			AND ac_accomm_block.ac_end_date > '" . $lDB->escape($date) . "'
			AND (
				(
					ac_accomm_type.ac_accomm_type_inactive_yn = '0'
				) OR (
					ac_accomm_type.ac_accomm_type_inactive_yn = '1'
					AND ac_accomm_type.ac_accomm_type_inactive_date > '" . $lDB->escape($date) . "'
				)
			) AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '" . $lDB->escape($date) . "'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '" . $lDB->escape($date) . "'
				)
			)
		ORDER BY
			ac_accomm_room.ac_accomm_room_ix,
			ac_accomm_block.ac_start_date,
			ac_accomm_block.ac_accomm_block_ix,
			ac_accomm_room_block.ac_accomm_room_block_ix
	",6);
	foreach($blocks as $block) {
		$ac_accomm_room_id = $block['ac_accomm_room_id'];
		if(!array_key_exists($ac_accomm_room_id,$rooms)) {
			continue; // ignore blocks for invalid rooms (eg. inactive)
		}

		if($block['ac_type_ind'] == DB_AC_ACCOMM_BLOCK_TYPE_STATIC) {
			$rooms[$ac_accomm_room_id]['has_static'] = true;
		}

		if($block['ac_type_ind'] == DB_AC_ACCOMM_BLOCK_TYPE_DYNAMIC) {
			$rooms[$ac_accomm_room_id]['has_dynamic'] = true;
		}

		$ac_accomm_block_id = $block['ac_accomm_block_id'];
		$rooms[$ac_accomm_room_id]['blocks'][$ac_accomm_block_id] = $block;
	}
	unset($blocks);

	$day = [
		'rooms'=>$rooms,
		'unblocked'=>0,
		'static'=>0,
		'dynamic'=>0,
		'both'=>0
	];
	foreach($day['rooms'] as $ac_accomm_room_id=>$room) {
		if(sizeof($room['blocks']) == 0) {
			$day['rooms'][$ac_accomm_room_id]['is_unblocked'] = true;
			$day['unblocked']++;
		}
		if($room['has_static']) {
			$day['static']++;
		}
		if($room['has_dynamic']) {
			$day['dynamic']++;
		}
		if($room['has_static'] && $room['has_dynamic']) {
			$day['both']++;
		}
	}

	return $day;
}
