<?php

/*
 * init.form1016.php - Open And Close Out Rooms
 * Job: 1026
 *
 * Function: 1004 (Business structure: Open and close out rooms)
 */

if(isset($_SERVER['CONTENT_TYPE']) && preg_match("/application\/json/",$_SERVER["CONTENT_TYPE"])) {
	$request = json_decode(file_get_contents('php://input'),true);
	if(empty($request) || !is_array($request) || !array_key_exists("action",$request)) {
		$request = ['action'=>"unknown", 'params'=>[]];
	}
	$params = $request['params'];

	if($request['action'] == "verify") {
		$availablePerDay = getAvailablePerDay($params['ac_accomm_type_id_source'], $params['start_date'], $params['end_date']);
		$allAvailable = true;
		foreach($availablePerDay as $date=>$available) {
			if($available < $params['rooms']) {
				$allAvailable = false;
			}
		}

		$startDateArray = explode("-",$params['start_date']);
		$days = $params['days'];
		for($count=0; $count<$days; $count++) {
			$date = date("Y-m-d",mktime(0,0,0,$startDateArray[1], $startDateArray[2]+$count, $startDateArray[0]));
			$source = getRoomBlocksOnDay($params['ac_accomm_type_id_source'],$date);
			$target = getRoomBlocksOnDay($params['ac_accomm_type_id_target'],$date);
			if($source['both'] > 0 || $target['both'] > 0) {
				http_response_code(400);
				die("On $date both a static and dynamic block are in place. Unable to continue.");
			}
		}

		echo(json_encode($allAvailable));
		die();
	}

	if($request['action'] == "finalise") {
		$startDateArray = explode("-",$params['start_date']);
		$days = $params['days'];
		$rooms = $params['rooms'];
		$sourceAvailablePerDay = getAvailablePerDay($params['ac_accomm_type_id_source'], $params['start_date'], $params['end_date']);
		$changes = false;
		$reason = "Dynamic: " . trim($GLOBALS['firstname'] . " " . $GLOBALS['lastname']) . " at " . date("Y-m-d H:i:s");
		for($count=0; $count<$days; $count++) {
			$date = date("Y-m-d",mktime(0,0,0,$startDateArray[1], $startDateArray[2]+$count, $startDateArray[0]));
			$nextDate = date("Y-m-d",mktime(0,0,0,$startDateArray[1], $startDateArray[2]+$count+1, $startDateArray[0]));

			$available = $sourceAvailablePerDay[$date];
			$source = getRoomBlocksOnDay($params['ac_accomm_type_id_source'],$date);
			$target = getRoomBlocksOnDay($params['ac_accomm_type_id_target'],$date);

			// Determine how many rooms to transfer for this day
			$amount = $rooms; // requested rooms to transfer (maximum)
			if($available < $amount) { // reduce to available if less
				$amount = $available;
			}
			if($source['unblocked'] < $amount) { // reduce to unblocked if less
				$amount = $source['unblocked'];
			}
			if($target['dynamic'] < $amount) { // reduce to dynamic blocks on target if less
				$amount = $target['dynamic'];
			}
			if($amount <= 0) { // ignore days without any available rooms to move
				continue;
			}

			$changes = true;

			// Create room block on the source accommodation type for the required amount of rooms
			$ac_accomm_block_id = db_ac_accomm_block_insert($params['ac_accomm_type_id_source'], $date, $nextDate, $reason, DB_AC_ACCOMM_BLOCK_TYPE_DYNAMIC); 
			$blocked = 0;
			foreach($source['rooms'] as $ac_accomm_room_id=>$room) {
				if($room['is_unblocked']) {
					db_ac_accomm_room_block_insert($ac_accomm_block_id,$ac_accomm_room_id);
					$blocked++;
				}
				if($blocked >= $amount) {
					break; // only block the calculated amount of rooms
				}
			}

			// Determine which room blocks to edit on the target accommodation type
			$roomsToUnblock = [];
			$blocksToEdit = [];
			foreach($target['rooms'] as $ac_accomm_room_id=>$room) {
				if(!$room['has_dynamic']) { // ignore rooms without dynamic blocks
					continue;
				}
				$roomsToUnblock[] = $ac_accomm_room_id;
				foreach($room['blocks'] as $ac_accomm_block_id=>$block) {
					if($block['ac_type_ind'] != DB_AC_ACCOMM_BLOCK_TYPE_DYNAMIC) { // ignore non-dynamic blocks
						continue;
					}
					if(!array_key_exists($ac_accomm_block_id, $blocksToEdit)) {
						if($block['ac_start_date'] < $date && $block['ac_end_date'] == $nextDate) { // only needs end date edit
							$type = "end";
						} elseif($block['ac_start_date'] == $date && $block['ac_end_date'] > $nextDate) { // only needs start date edit
							$type = "start";
						} elseif($block['ac_start_date'] == $date && $block['ac_end_date'] == $nextDate) { // edit existing single day block
							$type = "single";
						} else { // both start date and end date are different, needs clone / split
							$type = "split";
						}
						$blocksToEdit[$ac_accomm_block_id] = [
							'type'=>$type,
							'block'=>$block,
							'rooms'=>[]
						];
					}
					$blocksToEdit[$ac_accomm_block_id]['rooms'][$ac_accomm_room_id] = $room;
				}
				if(sizeof($roomsToUnblock) >= $amount) {
					break; // only unblock the calculated amount of rooms
				}
			}

			foreach($blocksToEdit as $ac_accomm_block_id=>$blockToEdit) {
				$roomsInBlock = db_ac_accomm_room_block_get_room_by_block($ac_accomm_block_id);
				$roomsToKeep = array_diff($roomsInBlock, $roomsToUnblock);

				switch($blockToEdit['type']) {
				case "start":
					db_ac_accomm_block_set_start_date($ac_accomm_block_id, $nextDate);
					break;
				case "end":
					db_ac_accomm_block_set_end_date($ac_accomm_block_id, $date);
					break;
				case "split":
					$clone_accomm_block_id = db_ac_accomm_block_clone($ac_accomm_block_id);
					db_ac_accomm_block_set_end_date($ac_accomm_block_id, $date);
					db_ac_accomm_block_set_start_date($clone_accomm_block_id, $nextDate);
					break;
				case "single":
				default:
					db_ac_accomm_room_block_delete_by_block($ac_accomm_block_id);
					db_ac_accomm_block_delete($ac_accomm_block_id);
					break;
				}

				if(sizeof($roomsToKeep) > 0) {
					$new_accomm_block_id = db_ac_accomm_block_insert($params['ac_accomm_type_id_target'], $date, $nextDate, $reason, DB_AC_ACCOMM_BLOCK_TYPE_DYNAMIC);
					foreach($roomsToKeep as $ac_accomm_room_id) {					
						db_ac_accomm_room_block_insert($new_accomm_block_id,$ac_accomm_room_id);
					}
				}
			}
		}
		echo(json_encode($changes));
		die();
	}

	http_response_code(400);
	die("Invalid request");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/open_and_close_out_rooms.htm");
}

$pf_object_id = db_pf_object_by_name("open_and_close_out_rooms");

processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();


$_SERVER['argv'] = array_pad($_SERVER['argv'],3,"");

$calDateLimit = $GLOBALS['lDB']->get("SELECT rf_date_res_limit FROM rf_default",4);
$fromDateRaw = $_SERVER['argv'][1];
if($fromDateRaw > $calDateLimit) {
	$fromDateRaw = $calDateLimit;
}
$fromDate = useDate("from", $fromDateRaw);

if($_SERVER['argv'][1] == "" && $_SERVER['argv'][2] == "" && $pf_option_id == "") {
	$_SERVER['argv'][2] = join(":",$GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix
		FROM
			ac_accomm_type
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		WHERE
			ac_accomm_type.ac_accomm_type_inactive_yn = '0'
			AND pr_business.pr_bus_inactive_yn = '0'
	",3));
}


$accommACL= $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.ac_accomm_type_ix
	FROM
		sc_accomm, ac_accomm_type
	WHERE
		sc_accomm.sc_group_id= '".$GLOBALS['sc_group_id']."'
		AND sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
",3);
$accommFilter = useFilter("accomm",$_SERVER['argv'][2],"SELECT CONCAT(pr_business.pr_bus_name_short,CONCAT(' - ',ac_accomm_type.ac_accomm_desc)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","ac_accomm_type.ac_accomm_type_ix",$accommACL,false,false);

$calLimitDisplay = $GLOBALS['limit_yn'];
$calMaxDisplay = $GLOBALS['sc_grp_avail_limit'];
$defaultPeriod 			= "21";

// TODO validations
$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit,"-");

$calStartDate = $fromDate['jsDate'];
list($calStartYear, $calStartMonth, $calStartDay) = explode("-", $calStartDate);

// Generate the daylist for the calendar --------------------------------------
$calDateList = array();
$calDateKeyList = array();
for ($k=0;$k<$defaultPeriod;$k++){
	$date = date("Y-m-d",mktime (0,0,0,$calStartMonth,$calStartDay+$k,$calStartYear));
	$calDateList[$k] = $date;
	$calDateKeyList[$date] = "0";
}
$endDateId = $defaultPeriod - 1;
$calEndDate = $calDateList[$endDateId];

# Determine Month(s) and Year(s)
list($calEndYear, $calEndMonth, $calEndDay) = explode("-",$calEndDate);

$startMonthName = date("F",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$startYear = date("Y",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$stopMonthName = date("F",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));
$stopYear = date("Y",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));

# Determine Full Weekend Dates
$weekendList = makeDates($calStartDate,$defaultPeriod,"Y-m-d",1);

# Setup the table heads
$headDateList = makeDates($calStartDate,$defaultPeriod,"d");
$dayNameList = makeDates($calStartDate, $defaultPeriod, "D");

$wmax = sizeof($headDateList);
for ( $w = 0; $w < $wmax; $w++ ) {
	$date = $headDateList[$w];
	$GLOBALS['temp']["cHD".$w] = $date;
	$GLOBALS['temp']['day' . $w] = substr($dayNameList[$w],0,1);

	if(in_array($calDateList[$w],$weekendList)){
		$GLOBALS['temp']["cHC".$w] = "wkEndNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkEndNoBorder";
	} else {
		$GLOBALS['temp']["cHC".$w] = "wkNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkNoBorder";
	}
}
   
$calAccommData = [];
$calAccommList = [];
foreach($GLOBALS['property_id'] as $pr_business_id) {
	$accommList = $lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix, 
			ac_accomm_type.ac_accomm_desc, 
			ac_accomm_type.ac_accomm_name_short,
			COUNT(ac_accomm_room.ac_accomm_room_ix) as ac_accomm_no_of_units,
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last
		FROM 
			ac_accomm_type 
			INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix AND ac_accomm_room.ac_accomm_room_inactive_yn = 0 
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE 
			ac_accomm_type.pr_business_id = '".$lDB->escape($pr_business_id)."'
			$accommFilter[where]
			AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
		GROUP BY
			ac_accomm_type.ac_accomm_type_ix
		ORDER BY
			ac_accomm_type.ac_accomm_sequence
	",6);
	foreach($accommList as $accommItem) {
		$calAccommData[$accommItem['ac_accomm_type_ix']] = $accommItem;
		$calAccommList[] = $accommItem['ac_accomm_type_ix'];
	}
}

// PHASE 3
// Get us some availability data -------------------------------------------------
// ============================================================================
$availability = array();
$stock = new Stock(false, $calStartDate, $calEndDate);
foreach($calAccommData as $item) {
	$accommId = $item['ac_accomm_type_ix'];
	$stock->SetAccommTypeId($accommId);

	$availability[$accommId]['propertyId'] = $item['pr_business_id'];
	$availability[$accommId]['propertyName'] = $item['pr_name_last'];
	$availability[$accommId]['accomm_name'] = $item['ac_accomm_desc'];

	$accommMax = $stock->ToAccommMax();
	$accommMin = $stock->ToAccommMin();

	if ( $accommMax != $accommMin ) {
		$availability[$accommId]['units'] = $accommMin . " - " . $accommMax;
	} else {
		$availability[$accommId]['units'] = $accommMax;
	}
	$availability[$accommId]['availability'] = $stock->ToAvailability();
}

// PHASE 4:
// Output the data ------------------------------------------------------------
// ============================================================================
$html = "";
$currentPropertyId = "";
$accomms = [];
$propertyIds = [];

foreach($availability as $accommId => $v) {
	$accomms[$accommId] = [
		'propertyId' => $v['propertyId'],
		'propertyName' => $v['propertyName'],
		'accommId' => $accommId,
		'accommName' => $v['accomm_name']
	];
	$propertyIds[] = $v['propertyId'];
	if($currentPropertyId != $v['propertyId']) {
		$html .= "<tr style=\"height: 20px;\"><td colspan=\"24\" class=\"colLt noTop\" style=\"padding: 2px;\"><b>" . t_encodeHTMLField($v['propertyName']) . "</b></td></tr>";
		$currentPropertyId  = $v['propertyId'];
	}	

	// Accommodation Name -------------------------------------------------------
	$html .= "<tr style=\"height: 20px;\"><td style=\"text-align: left;\" class=\"bb br bl\">&nbsp;" . t_encodeHTMLField($v['accomm_name']) . "</td>";

	// Units --------------------------------------------------------------------
	$html .= "<td align=\"center\" class=\"bb br\">" . $v['units'] . "</td>";


	// Daily availability ----------------------------------------------------------
	foreach($v['availability'] as $date => $o) {

		$cellClass = "g1C";

		if ( in_array($date,$weekendList) ) {
			$cellClass = "wkEndNoBorder calNoTop";
		}

		if($o == 0) {
			$cellClass = "blockNoBorder";
			$o = "&nbsp;";
		}

		// Organise dates ---------------------------------------------------------
		$thisDate = explode("-",$date);
		$day 		= date("d",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		$month 	= date("m",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		$year 	= date("Y",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));

		$html .= "<td align=\"center\" valign=\"middle\" unselectable=\"on\" class=\"" . $cellClass . "\" defclass=\"" . $cellClass . "\" width=\"27\" id=\"" . $accommId . ":" . $year . "-" . $month . "-" . $day . "\" onmousedown=\"cellMouseDown(event,arguments[0]);\" onmouseup=\"cellMouseUp(event,arguments[0]);\" onmouseover=\"cellMouseOver(event,arguments[0]);\" style=\"user-select: none;\">" . $o . "</td>";
	}
	$html .= "</tr>";
}

$GLOBALS['temp']['rows'] = $html;
$GLOBALS['temp']['accomms'] = json_encode($accomms);
$GLOBALS['temp']['propertyIds'] = json_encode(array_values(array_unique($propertyIds)));
// PHASE 4 : END --------------------------------------------------------------
// ============================================================================

// Phase 5 :
// Echo variables -------------------------------------------------------------
// ============================================================================

# Screen output variables
$GLOBALS['temp']['calLimitDisplay'] = (string) $calLimitDisplay;
$GLOBALS['temp']['calMaxDisplay'] = (string) $calMaxDisplay;

$GLOBALS['temp']['calStartDate']     = (string) $calStartDate;
$GLOBALS['temp']['calEndDate']       = (string) $calEndDate;

$GLOBALS['temp']['mnLeft']           = (string) $startMonthName;
$GLOBALS['temp']['yrLeft']           = (string) $startYear;
$GLOBALS['temp']['mnRight']          = (string) $stopMonthName;
$GLOBALS['temp']['yrRight']          = (string) $stopYear;
$GLOBALS['temp']['weekendList']      = join(", ",$weekendList);

session_set(array(
	'calStartDate'=>$calStartDate,
	'calEndDate'=>$calEndDate,
	'calAccommList'=>$calAccommList,
	'userStatusId'=>$userStatusId
));
