<?php

require_once(__DIR__ . "/class.report.param.php");
require_once(__DIR__ . "/db.sp_combo.php");
require_once(__DIR__ . "/db.sp_combo_item.php");
require_once(__DIR__ . "/db.sp_combo_period.php");

function loadCombo($sp_combo_id) {
	global $lDB;

	if(db_sp_combo_exists($sp_combo_id)) {
		list($sp_combo_name, $sp_combo_limit) = $lDB->get("
			SELECT
				sp_combo.sp_combo_name,
				sp_combo.sp_combo_limit
			FROM
				sp_combo
			WHERE
				sp_combo.sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'
		",1);
	} else {
		$sp_combo_id = "";
		$sp_combo_name = "";
		$sp_combo_limit = "";
	}

	$specials = $lDB->get("
		SELECT
			sp_special.sp_special_ix,
			sp_special.sp_special_desc,
			sp_special.sp_special_priority,
			IF(sp_combo_item.sp_combo_item_ix IS NULL,0,1) AS allocated
		FROM
			sp_special
			LEFT JOIN sp_combo_item ON
				sp_combo_item.sp_special_id = sp_special.sp_special_ix
				AND sp_combo_item.sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
		WHERE
			sp_special.sp_special_inactive_yn = '0'
		ORDER BY
			sp_special.sp_special_priority
	",6);

	$periods = $lDB->get("
		SELECT
			rt_period.rt_period_ix,
			rt_period.rt_period_desc,
			IF(sp_combo_period.sp_combo_period_ix IS NULL,0,1) AS allocated
		FROM
			rt_period
			LEFT JOIN sp_combo_period ON
				sp_combo_period.rt_period_id = rt_period.rt_period_ix
				AND sp_combo_period.sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
		WHERE
			rt_period_inactive_yn = '0'
		ORDER BY
			rt_period.rt_period_desc
	",6);

	return [
		'sp_combo_id' => $sp_combo_id,
		'sp_combo_name' => $sp_combo_name,
		'sp_combo_limit' => $sp_combo_limit,
		'specials' => $specials,
		'periods' => $periods
	];
}

function saveCombo($sp_combo_id, $sp_combo_name, $sp_combo_limit, $specials, $periods) {
	if(checkJob(1027,2) < 10) {
		return false;
	}

	if(empty($periods)) {
		return false;
	}

	if(empty($sp_combo_id)) {
		$sp_combo_id = db_sp_combo_insert($sp_combo_name, $sp_combo_limit);
	} elseif(db_sp_combo_exists($sp_combo_id)) {
		db_sp_combo_update($sp_combo_id, $sp_combo_name, $sp_combo_limit);
	} else {
		return false;
	}

	if(empty($specials) || !is_array($specials)) {
		$specials = [];
	}


	db_sp_combo_item_delete_by_combo($sp_combo_id);
	foreach($specials as $special) {
		if($special['allocated'] != "1") {
			continue;
		}
		db_sp_combo_item_insert($sp_combo_id, $special['sp_special_ix']);
	}

	db_sp_combo_period_delete_by_combo($sp_combo_id);
	foreach($periods as $rt_period_id) {
		db_sp_combo_period_insert($sp_combo_id, $rt_period_id);
	}

	return true;
}

function deleteCombo($sp_combo_id) {
	if(checkJob(1027,2) < 10) {
		return false;
	}

	if(!db_sp_combo_exists($sp_combo_id)) {
		return false;
	}

	db_sp_combo_delete($sp_combo_id);

	return true;
}

function listCombos() {
	global $lDB;

	return $lDB->get("
		SELECT
			sp_combo.sp_combo_ix,
			sp_combo.sp_combo_name
		FROM
			sp_combo
		ORDER BY
			sp_combo.sp_combo_sort_seq
	",6);
}

function moveCombo($sp_combo_id, $direction) {
	if(checkJob(1027,2) < 10) {
		return false;
	}

	if(!db_sp_combo_exists($sp_combo_id)) {
		return false;
	}

	if($direction == "up") {
		$direction = false;
	} else {
		$direction = true;
	}

	db_sp_combo_move($sp_combo_id, $direction);

	return true;
}
