<?php

/**
 * init.form1017.php - Special combos
 * Job: 1027
 * Function: 2001 (Specials)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/special_combos.htm");
}

$jobLevel = checkJob(1027,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "1" : "0";

$action = $_POST['action'] ?? "";

if(!empty($action)) {
	$response = false;

	switch($action) {
	case "list_combos":
		$response = listCombos();
		break;
	case "move_combo":
		$sp_combo_id = $_POST['sp_combo_id'] ?? "";
		$direction = $_POST['direction'] ?? "down";
		$response = moveCombo($sp_combo_id, $direction);
		break;
	case "load_combo":
		$sp_combo_id = $_POST['sp_combo_id'] ?? "";
		$response = loadCombo($sp_combo_id);
		break;
	case "save_combo":
		$sp_combo_id = $_POST['sp_combo_id'] ?? "";
		$sp_combo_name = $_POST['sp_combo_name'] ?? "";
		$sp_combo_limit = $_POST['sp_combo_limit'] ?? "";
		$specials = json_decode($_POST['specials'] ?? "", true);
		$periods = json_decode($_POST['periods'] ?? "", true);
		$response = saveCombo($sp_combo_id, $sp_combo_name, $sp_combo_limit, $specials, $periods);
		break;
	case "delete_combo":
		$sp_combo_id = $_POST['sp_combo_id'] ?? "";
		$response = deleteCombo($sp_combo_id);
	}
	echo json_encode($response);
	die();
}

$ratePeriodFilter = new ReportParamFilter("ratePeriod", false, false, [
	'transAfter'=>"true"
]);
$ratePeriodFilter->Arg = 1;
$ratePeriodFilter->init();
$GLOBALS['temp']['ratePeriodFilter'] = $ratePeriodFilter->Render();
