<?php

require_once(__DIR__ . "/db.ac_extra.php");
require_once(__DIR__ . "/db.ac_pos_stock.php");
require_once(__DIR__ . "/db.pr_business.php");

function listItems($pr_business_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT DISTINCT
			ac_pos_stock.ac_pos_stock_db,
			ac_pos_stock.ac_pos_stock_ix,
			ac_pos_stock.ac_pos_stock_code,
			ac_pos_stock.ac_extra_id,
			ac_extra.ac_ext_desc,
			IF(ac_pos.ac_pos_ix IS NOT NULL OR ac_pos_map.ac_pos_map_ix IS NOT NULL,1,0) AS linked_yn
		FROM
			ac_pos_stock
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = ac_pos_stock.ac_extra_id
			LEFT JOIN ac_pos ON ac_pos.ac_pos_stock_id = ac_pos_stock.ac_pos_stock_ix
			LEFT JOIN ac_pos_map ON ac_pos_map.ac_pos_stock_id = ac_pos_stock.ac_pos_stock_ix
		WHERE
			ac_pos_stock.pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",6);
	foreach($list as &$item) {
		$item['allow_edit'] = canEditDB($item['ac_pos_stock_db']);
		$item['allow_delete'] =$item['allow_edit'] && $item['linked_yn'] == 0;
	}
	unset($item);
	return $list;
}

function saveItems($pr_business_id, $items) {
	if(checkJob(1028,2) < 10) {
		return false;
	}

	if(empty($pr_business_id) || !is_array($items)) {
		return false;
	}

	foreach($items as $item) {
		if(
			!array_key_exists("ac_pos_stock_ix",$item)
			|| (
				!empty($item['ac_pos_stock_ix'])
				&& !db_ac_pos_stock_exists($item['ac_pos_stock_ix'])
			) || !array_key_exists("ac_pos_stock_code",$item)
			|| empty($item['ac_pos_stock_code'])
			|| !array_key_exists("ac_extra_id",$item)
			|| !db_ac_extra_exists($item['ac_extra_id'])
			|| !db_ac_extra_is_pos($item['ac_extra_id'])
		) {
			return false;
		}
	}

	// Ignore items that are not allowed to be edited
	$items = array_filter($items, function($item) {
		global $lDB;

		$ac_pos_stock_db = $lDB->get("
			SELECT ac_pos_stock_db FROM ac_pos_stock WHERE ac_pos_stock_ix = '" . $lDB->escape($item['ac_pos_stock_ix']) . "'
		",4);
		return canEditDB($ac_pos_stock_db);
	});

	db_ac_pos_stock_bulk_update($pr_business_id, $items);
	return true;
}

function listExtras($pr_business_id) {
	global $lDB;

	$list = $lDB->get("
		SELECT DISTINCT
			ac_extra.ac_extra_ix,
			ac_extra.ac_ext_desc,
			ac_extra_category.ac_extra_cat_desc
		FROM
			ac_extra
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			INNER JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
		WHERE
			ac_extra_category.ac_extra_cat_pos_yn = '1'
			AND ac_extra_prop.pr_business_id IN ('" . join("','",db_pr_business_get_properties($pr_business_id,DB_PR_BUSINESS_BILLING_PROPERTY)) ."')
		ORDER BY
			ac_extra_category.ac_extra_cat_desc,
			ac_extra.ac_ext_desc
	",6);

	return $list;	
}
