<?php

/*
 * init.form1018.php - POS sales items
 * Job: 1028 (display), 1029 (edit)
 * Function: 86 (Code Tables: POS)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/code_pos_item.htm");
}

$jobLevel = checkJob(1028,2);
$GLOBALS['temp']['readOnly'] = ($jobLevel < 10) ? "true" : "false";
$GLOBALS['temp']['readOnlyDisabled'] = ($jobLevel < 10) ? "disabled" : "";

$allowedBillingUnitIds = array_unique(array_map(function($pr_business_id) {
	return db_pr_business_get_billing($pr_business_id, DB_PR_BUSINESS_BILLING_PROPERTY);
}, $lDB->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
	WHERE
		sc_accomm.sc_group_id = '" . $lDB->escape($GLOBALS['sc_group_id']) . "'
",3)));

$action = $_POST['action'] ?? "";

if(!empty($action)) {
	$response = false;
	$pr_business_id = $_POST['pr_business_id'] ?? "";
	if(in_array($pr_business_id, $allowedBillingUnitIds)) {
		switch($action) {
		case "list_items":
			$response = listItems($pr_business_id);
			break;
		case "save_items":
			$items = json_decode($_POST['items'] ?? "", true);
			$response = saveItems($pr_business_id, $items);
			break;
		case "list_extras":
			$response = listExtras($pr_business_id);
			break;
		}
	}
	echo json_encode($response);
	die();
}

$billingUnits = $lDB->get("
	SELECT
		pr_business.pr_business_id,
		pr_persona.pr_name_last
	FROM
		pr_business
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
	WHERE
		pr_business.pr_business_id IN ('" . join("','", $allowedBillingUnitIds) . "')
	ORDER BY
		pr_persona.pr_name_last
",6);

$billingUnitOptions = "";
foreach($billingUnits as $billingUnit) {
	$billingUnitOptions .= "
		<option value=\"$billingUnit[pr_business_id]\">$billingUnit[pr_name_last]</option>
	";
}
$GLOBALS['temp']['billingUnitOptions'] = $billingUnitOptions;
