<?php

/**
 * init.form1019.php - General Ledger account detail popup - Meal plan tab
 * Job: 1030
 * Function: 100
 */

// Form setup -----------------------------------------------------------------
if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/fin_ledger_account_detail_popup_meal_plan.htm");
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
	$GLOBALS['temp']['url'] = $_POST['url'];
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

$iUnitID = $_SERVER['argv'][1];
$filterSQL = "";
$sortSQL = "";
$GLOBALS['temp']['isInventory'] = '';
$GLOBALS['temp']['allowInventory'] = '';
if (db_pr_business_is_inventory($iUnitID) == '0') {
	$GLOBALS['temp']['isInventory'] = 'tab-disabled';
	$GLOBALS['temp']['allowInventory'] = 'return false;';
}

$GLOBALS['temp']['lastFilterDBField'] = "";
$GLOBALS['temp']['lastFilterText'] = "";

if ( $_SERVER['argc'] > 2 ) {
	// Process the data to be saved ----------------------------------------------
	switch ( $_SERVER['argv'][2] ) {
	case "edit":
		// Process the data to be saved
		$editedFields = explode("_",$_SERVER['argv'][3]);
		// Knock off the extra empty array
		array_pop($editedFields);
		foreach ( $editedFields as $data ) {
			$thisData = explode(":",$data);
			foreach($thisData as $key=>$item) {
				$thisData[$key] = rawurldecode($item);
			}
			$rt_component_id = $thisData[0];
			$rt_component_inv_meal_code = $thisData[1];
			db_rt_component_set_meal_code($iUnitID, $rt_component_id, $rt_component_inv_meal_code);
		}
		break;
	}
}

// Display the current data --------------------------------------------------
$unitName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '" . $iUnitID . "'",4);

$rateComponents = $GLOBALS['lDB']->get("
	SELECT
		rt_component.rt_component_ix,
		rt_component.rt_component_desc,
		rt_component_inv.rt_component_inv_meal_code
	FROM
		rt_component
		LEFT JOIN rt_component_inv ON
			rt_component_inv.rt_component_id = rt_component.rt_component_ix 
			AND rt_component_inv.pr_business_id = '$iUnitID'
	WHERE
		rt_component.rt_component_inactive_yn = '0'
		AND rt_component.rt_component_type_ind = '" . DB_RT_COMPONENT_TYPE_MEAL_PLAN . "'
	" . $filterSQL . " 
",2);

// Natural sorting ------------------------------------------------------------
if ( $_SERVER['argv'][2] == "sort" ) {
	$sort_field = $sortData[0];
	$sort_order = $sortData[1];
} else {
	$sort_field = "rt_component_desc";
	$sort_order = "ASC";
}

$sort_array = array();
foreach ( $rateComponents as $g ) {
	array_push($sort_array,$g[$sort_field]);
}

natsort($sort_array);

if ( $sort_order == "DESC" ) {
	$sort_array = array_reverse($sort_array,TRUE);
}

$keys = array_keys($sort_array);
// ----------------------------------------------------------------------------

if(db_pr_business_ledger_allow($iUnitID)) {
	$allowEdit = true;
	$GLOBALS['temp']['allowEditStyle'] = "";
} else {
	$allowEdit = false;
	$GLOBALS['temp']['allowEditStyle'] = "style=\"display: none;\"";
}

$rateCompHTML = "";
$hiddenDiv = "";
foreach ( $keys as $k ) {
	if($allowEdit) {
		$mouseOver = "style=\"cursor: pointer;\" onmouseover=\"hover('" . $rateComponents[$k]['rt_component_ix'] . "',1);\" onmouseout=\"hover('" . $rateComponents[$k]['rt_component_ix'] . "',0);\"";
		$onClick = "onclick=\"glEdit('" . $rateComponents[$k]['rt_component_ix'] . "',event);\"";
	} else {
		$mouseOver = "";
		$onClick = "";
	}


	$rateCompHTML .= "
		<tr id=\"" . $rateComponents[$k]['rt_component_ix'] . "\" " . $mouseOver . ">\n
			<td id=\"cell1" . $rateComponents[$k]['rt_component_ix'] . "\" class=\"bl br\" style=\"width:300px;\" " . $onClick . ">" . t_encodeHTMLField($rateComponents[$k]['rt_component_desc']) . "</td>
			<td style=\"width:200px; overflow:hidden;\" id=\"input1" . $rateComponents[$k]['rt_component_ix'] . "\" " . $onClick . ">" . t_encodeHTMLField($rateComponents[$k]['rt_component_inv_meal_code']) . "</td>
			<td class=\"br\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" /></td>
		</tr>\n";
}

$GLOBALS['temp']['rateCompHTML']	= $rateCompHTML;
$GLOBALS['temp']['hiddenDiv']			= $hiddenDiv;
$GLOBALS['temp']['unitName']			= $unitName;
$GLOBALS['temp']['fun_job_id']		= $_SERVER['argv'][0];
$GLOBALS['temp']['iUnitID']				= $iUnitID;
