<?php

/*
 * init.form11.php - Occupancy Calendar
 * Job: 29 - Occupancy Calendar
 *
 * Function: 51
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/bookings_calendar.htm");
}

$pf_object_id = db_pf_object_by_name("occupancy_calendar");

processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
if($pf_option_id == "" && isset($_SERVER['argv'][7]) && $_SERVER['argv'][7] != "" ) {
    $pf_option_id = $_SERVER['argv'][7];
}
$title = db_pf_option_get_title($pf_option_id);

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

// PHASE 1:
// Declare and validate variables ---------------------------------------------
// ============================================================================

// Paramaters for this page ---------------------------------------------------
$calStartDate		= $_SESSION['calStartDate'];
$calEndDate			= $_SESSION['calEndDate'];
$calPropList		= $_SESSION['calPropList'];
$calAccommList	= $_SESSION['calAccommList'];
$calAgentId			= $_SESSION['calAgentId'];
$canCalWizard		= false;

$calendarLevel = $lDB->get("
	SELECT 
		sc_fun_grp_level 
	FROM 
		sc_fun_group 
	WHERE 
		sc_group_id = '$GLOBALS[sc_group_id]' 
		AND sc_function_id = '50'
",4);

if ($calendarLevel > "5") { 
	$canCalWizard = true;
}

$userStatusId = $_SESSION['userStatusId'];
$calStatusList = isset($_SESSION['calStatusList'])? $_SESSION['calStatusList']:"";

global $calStartDate;
global $calEndDate;
global $wizResId;
global $calAccommList;
global $calAgentId;
global $canCalWizard;
global $userStatusId;
global $calStatusList;

$thisSession = array_slice($_SERVER['argv'],1,6);

if(sizeof($_SERVER['argv']) < 2) {
	$thisSession = isset($_SESSION['calendarParms']) && is_array($_SESSION['calendarParms'])?$_SESSION['calendarParms']:array();
	$thisSession = array_pad($thisSession,6,"");
	$_SERVER['argv'][1] = $thisSession[0];
	$_SERVER['argv'][2] = $thisSession[1];
	$_SERVER['argv'][3] = $thisSession[2] != "0" ? $thisSession[2] : "";   // Status can not be Quotation at this point, reset it
	$_SERVER['argv'][4] = $thisSession[3];
	$_SERVER['argv'][5] = $thisSession[4];
	$_SERVER['argv'][6] = $thisSession[5] = "0";
} else {
	session_set("calendarParms",$thisSession);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$GLOBALS['temp']['genDate'] = chng_date(date("Y-m-d"),"-") . " " . date("H:i:s");

$GLOBALS['temp']['alertUser'] = "0";

$calStartDate = $_SERVER['argv'][1];


if (trim($_SERVER['argv'][2]) != "") {
	$calPropList = explode(":",$_SERVER['argv'][2]);
}

if (trim($_SERVER['argv'][3]) != "") {
	$calStatusList = explode(":",$_SERVER['argv'][3]);
}

$wizAgentId = $_SERVER['argv'][4];

if (trim($_SERVER['argv'][6]) != "") {
	session_set("filAgentId",$_SERVER['argv'][6]);
}

if ($calStartDate == "null") { 
	$calStartDate = ""; 
}

if ($calPropList == "null") { 
	$calPropList = ""; 
}

if ($calStatusList == "null") {
	$calStatusList = "";
}
// System variables -----------------------------------------------------------
$userId = $GLOBALS['userid'];
$calLimitDisplay = $GLOBALS['limit_yn'];
$calMaxDisplay = $GLOBALS['sc_grp_avail_limit'];

(isMasterDB()) ? $canCalWizard = "1" : $canCalWizard = "0";

$GLOBALS['temp']['showAgentFilter'] = " style=\"display: none;\"";


// Determine the userStatus ---------------------------------------------------
if ($GLOBALS['pr_sys_code'] == "9") {
	$calAgentId = "0";
	$userStatusId = "3";
	$GLOBALS['temp']['showAgentFilter'] = "";
} else {
	if ($GLOBALS['pr_business_link'] != "0") {
		$calAgentId = "0";
		$userStatusId = "2";
		$GLOBALS['temp']['showAgentFilter'] = "";
	} else {
		if ($GLOBALS['is_an_agent']) {
			$calAgentId = $GLOBALS['userid'];
			$userStatusId = "1";
		} elseif ($GLOBALS['pr_agent_link'] != "0") {
			$calAgentId = $GLOBALS['pr_agent_link'];
			$userStatusId = "1";
		} else {
			$calAgentId = "0";
			$userStatusId = "0";
		}
	}
}
// Hide pax count for external users ------------------------------------------
$GLOBALS['temp']['intPax'] = "";
if($userStatusId < 2) {
	$GLOBALS['temp']['intPax'] = "visibility: hidden;";
}   
   
// For external users, set the filAgentId -------------------------------------
if ($calAgentId != "0") {
	session_set("filAgentId",$calAgentId);
}

$GLOBALS['temp']['agentFilterName'] = "All Agents";

if (isset($_SESSION['filAgentId']) && trim($_SESSION['filAgentId']) != "") {
	if($_SESSION['filAgentId'] != "0") {
		$GLOBALS['temp']['agentFilterName'] = t_encodeOverlib($lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$_SESSION[filAgentId]'",4));
	} else {
		$GLOBALS['temp']['agentFilterName'] = "All";
	}
}

// Variables ------------------------------------------------------------------
$userStatusList = array("0" => "Public", "1" => "Agent", "2" => "Internal");
$userStatusName = $userStatusList[$userStatusId];

(checkJob(29,0) && $userStatusId > 0) ? $calEnableOcc = "1" : $calEnableOcc = "0";

$calAllowProvs = $GLOBALS['showProv'];

($wizResId != "") ? $wizLoadContents = "1": $wizLoadContents = "0";

if ($wizAgentId == "") { 
	$wizAgentId = "0";
}

$calProvStatusId 		= "20";
$defaultStatusList 	= array("15","20","30");
$defaultPeriod 			= "21";

// Change info tag according to access control --------------------------------
$GLOBALS['temp']['infoPop'] = "/resource/Resrequest/Application/public/html/info/info_occ_read.htm";

if (checkjob(20,2) > 5) {
	$GLOBALS['temp']['infoPop'] = "/resource/Resrequest/Application/public/html/info/info_occ_cal.htm";
}

// Start process for default access controlled, correctly sequenced proplist --
$propMaster = $GLOBALS['lDB']->get("
	SELECT 
		pr_business_id 
	FROM 
		pr_business 
	WHERE 
		pr_bus_inactive_yn = '0' 
	ORDER BY 
		pr_business_parent asc 
	LIMIT 1
",4);

calAcRecurse($propMaster);

global $calAcRecurseResult;

// Get access control Property List -------------------------------------------
$tempPropData = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_accomm_type.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_accomm_type
		INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		INNER JOIN sc_accomm ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix		
	WHERE 
		sc_accomm.sc_group_id = '$GLOBALS[sc_group_id]'
		AND pr_business.pr_bus_inactive_yn = '0' 
		AND ac_accomm_type.ac_accomm_type_inactive_yn = 0 
",2);

$acPropList = array();
$calPropData = array();

foreach($tempPropData as $item) {
	array_push($acPropList,$item[0]);
	$calPropData[$item[0]] = $item[1];
}

$defaultPropList = array();

foreach($calAcRecurseResult as $item) {
	if(in_array($item,$acPropList)) {
		array_push($defaultPropList,$item);
	}
}

// Default dates --------------------------------------------------------------
$defaultStartDate = date("Y-m-d");
$defaultStartDateTime = date("Y-m-d H:i:s");
$defaultStartYear = date("Y");
$defaultStartMonth = date("m");
$defaultStartDay = date("d");

// Validate required calendar variables ---------------------------------------
if ($calStartDate == "") {
	$calStartDate 	= $defaultStartDate;
	$calStartYear 	= $defaultStartYear;
	$calStartMonth 	= $defaultStartMonth;
	$calStartDay 		= $defaultStartDay;
} else {
	$tempStartDate = explode("-",$calStartDate);
	if (sizeof($tempStartDate) == "3") {
		
		$calStartYear = $tempStartDate[0];
		if (strlen($calStartYear) != "4") {
			$calStartYear = date("Y");
		}
		
		$calStartMonth = $tempStartDate[1];
		if ($calStartMonth < 1 || $calStartMonth > 12) {
			$calStartMonth = date("m");
		}
		
		if ($calStartYear > "2037") {
			$calStartYear = "2037";
		}
		
		$calStartDay = $tempStartDate[2];
		if ($calStartDay < 1 || $calStartDay > 31) {
			$calStartDay = date("d");
		}
	} else {
		$calStartDate 	= $defaultStartDate;
		$calStartYear 	= $defaultStartYear;
		$calStartMonth 	= $defaultStartMonth;
		$calStartDay 		= $defaultStartDay;
	}
}

if ($calStartYear == "2037" && $calStartMonth = "12") {
	if ($calStartDay > "30") {
		$calStartDay = "30";
	}
}

$calDateLimit = $GLOBALS['lDB']->get("SELECT rf_date_res_limit FROM rf_default",4);
$temp = explode("-",$calDateLimit);
$calDateLimit = date("Y-m-d",mktime(0,0,0,$temp[1],$temp[2]-$defaultPeriod+1,$temp[0]));
$temp = explode("-",$calDateLimit);

$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit,"-");

if ($calStartYear > $temp[0] || ($calStartYear == $temp[0] && $calStartMonth > $temp[1]) || ($calStartYear == $temp[0] && $calStartMonth == $temp[1] && $calStartDay > $temp[2])) {
	$calStartYear 	= $temp[0];
	$calStartMonth 	= $temp[1];
	$calStartDay 		= $temp[2];
	$calStartDate 	= $calDateLimit;
}

$redoStartDate = "0";

if (strlen($calStartDay) == "1") {
	$calStartDay = str_pad($calStartDay,2,"0",STR_PAD_LEFT);
	$redoStartDate = "1";
}

if (strlen($calStartMonth) == "1") {
	$calStartMonth = str_pad($calStartMonth,2,"0",STR_PAD_LEFT);
	$redoStartDate = "1";
}

$calStartDate = $calStartYear . "-" . $calStartMonth . "-" . $calStartDay;

// Validate the statusList ----------------------------------------------------
if (!is_array($calStatusList)) {
	$calStatusList = $defaultStatusList;
} else {
	$allowedStatusList = $GLOBALS['lDB']->get("SELECT rf_reservation_status_id FROM rf_reservation_status WHERE rf_reservation_status_id != '25'",3);
	if($calStatusList[0] == -1) {
		$defaultStatusList = $allowedStatusList;
	}
	
	$tempStatusList = array();
	
	foreach($allowedStatusList as $item) {
		if(in_array($item,$calStatusList)) {
			array_push($tempStatusList,$item);
		}
	}
	
	if (sizeof($tempStatusList) == 0){
  	$calStatusList = $defaultStatusList;
	} else {
		$calStatusList = $tempStatusList;
		unset($tempStatusList);
	}
}

if ( in_array("15",$calStatusList) ) {
	$GLOBALS['temp']["chkShowAlloc"] = "checked=\"checked\"";
}

// Validate the propList ------------------------------------------------------
if ( !is_array($calPropList) ) {
	$calPropList = $defaultPropList;
} else {
	$tempPropList = array();

	foreach($defaultPropList as $item) {
		if(in_array($item,$calPropList)) {
			array_push($tempPropList,$item);
		}
	}
	
	if (sizeof($tempPropList) == 0){
		$calPropList = $defaultPropList;
	} else {
		$calPropList = $tempPropList;
		unset($tempPropList);
	}
}


// Generate the AccommList and the availability data array to be used for 
// availability calculation ---------------------------------------------------
$calAccommList = array();
$calAccommData = array();

$accommList = $GLOBALS['lDB']->get("
	SELECT
		sc_accomm.ac_accomm_type_id
	FROM
		sc_accomm
		INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",3);

foreach($calPropList as $propId) {
	$tempResult = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix, 
			ac_accomm_type.ac_accomm_desc, 
			ac_accomm_type.ac_accomm_name_short,
			COUNT(ac_accomm_room.ac_accomm_room_ix) as ac_accomm_no_of_units,
			ac_accomm_type.pr_business_id,
			pr_persona.pr_name_last
		FROM 
			ac_accomm_type 
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix AND ac_accomm_room.ac_accomm_room_inactive_yn = 0 
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE 
			ac_accomm_type.pr_business_id = '$propId'
			AND ac_accomm_type.ac_accomm_type_inactive_yn = 0
			AND	ac_accomm_type.ac_accomm_type_ix IN ('" . join("','",$accommList) . "')
		GROUP BY
			ac_accomm_type.ac_accomm_type_ix
		ORDER BY
			ac_accomm_type.pr_business_id,
			ac_accomm_type.ac_accomm_sequence
	",2);

	foreach($tempResult as $item) {
		$calAccommData[$item['ac_accomm_type_ix']] = $item;
		array_push($calAccommList,$item['ac_accomm_type_ix']);
	}
}

// Generate the daylist for the calendar --------------------------------------
$calDateList = array();
$calDateKeyList = array();
for ($k=0;$k<$defaultPeriod;$k++){
	$date = date("Y-m-d",mktime (0,0,0,$calStartMonth,$calStartDay+$k,$calStartYear));
	$calDateList[$k] = $date;
	$calDateKeyList[$date] = "0";
}
$endDateId = $defaultPeriod - 1;
$calEndDate = $calDateList[$endDateId];

# get the right periodId
$sql="
	SELECT
		rt_period.rt_period_ix,
		rt_period_date_from,
		rt_period_date_to,
		rt_period_desc
	FROM
		rt_period
	WHERE
		(rt_period.rt_period_date_from >= '$calStartDate' AND rt_period.rt_period_date_from <= '$calEndDate')
		OR (rt_period.rt_period_date_to >= '$calStartDate' AND rt_period.rt_period_date_to <= '$calEndDate')
		OR (rt_period.rt_period_date_from < '$calStartDate' AND rt_period.rt_period_date_to > '$calEndDate')
	ORDER BY
		rt_period_date_from
	LIMIT 1
";

$tempAcPeriod = $GLOBALS['lDB'] ->get($sql,1);
$calAcPeriodId = $tempAcPeriod[0];

# Determine Month(s) and Year(s)
$temp = explode("-",$calEndDate);
$calEndYear = $temp[0];
$calEndMonth = $temp[1];
$calEndDay = $temp[2];

$startMonthName = date("F",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$startYear = date("Y",mktime (0,0,0,$calStartMonth,$calStartDay,$calStartYear));
$stopMonthName = date("F",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));
$stopYear = date("Y",mktime (0,0,0,$calEndMonth,$calEndDay,$calEndYear));

# Determine Full Weekend Dates
$weekendList = makeDates($calStartDate,$defaultPeriod,"Y-m-d",1);

# Setup the table heads
$headDateList = makeDates($calStartDate,$defaultPeriod,"d");
$dayNameList = makeDates($calStartDate, $defaultPeriod, "D");

$wmax = sizeof($headDateList);
for ( $w = 0; $w < $wmax; $w++ ) {
	$date = $headDateList[$w];
	$GLOBALS['temp']["cHD".$w] = $date;
	$GLOBALS['temp']['day' . $w] = substr($dayNameList[$w],0,1);

	if(in_array($calDateList[$w],$weekendList)){
		$GLOBALS['temp']["cHC".$w] = "wkEndNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkEndNoBorder";
	} else {
		$GLOBALS['temp']["cHC".$w] = "wkNoBorder";
		$GLOBALS['temp']['day' . $w . 'style'] = "wkNoBorder";
	}
}

$GLOBALS['temp']['provCheck'] = "";
$GLOBALS['temp']['isProv'] = "0";
$GLOBALS['temp']['provDis'] = "";

if($calAllowProvs == "0") {
	if (!in_array("20",$calStatusList)) {
		// array_push($calStatusList,"20"); # Commented because this means you can never NOT select provisionals if it was flagged on the default table (Tobie - 2003-12-08)
	}
	$GLOBALS['temp']['provCheck'] = " checked";
	$GLOBALS['temp']['provDis'] = " disabled";
	$GLOBALS['temp']['isProv'] = "1";
} else {
	if (in_array("20",$calStatusList)){
		$GLOBALS['temp']['provCheck'] = " checked";
		$GLOBALS['temp']['isProv'] = "1";
	}else{
		$GLOBALS['temp']['isProv'] = "0";
	}
}
// end backwards compatability


if(isset($_SESSION['filAgentId']) && $_SESSION['filAgentId'] != "") {
	$agentCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			pr_agent
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_agent.pr_agent_id
		WHERE
			pr_persona.pr_persona_inactive_yn = 0
			AND pr_agent_inactive_yn = 0 and pr_agent_id = '$_SESSION[filAgentId]'
	",4);
	if ($agentCount == "0") {
		if ($calAgentId == "0" || $calAgentId == "0") {
			session_set("filAgentId","");
		} else {
			session_set("filAgentId",$calAgentId);
		}
	}
}

// PHASE 3
// Get us some Occupancy data -------------------------------------------------
// ============================================================================
$statusFilter = implode(":",$calStatusList);
$occupancy = array();
foreach($calAccommData as $item) {
	$accommId = $item['ac_accomm_type_ix'];
	if(isset($_SESSION['filAgentId']) && $_SESSION['filAgentId'] ) {
		$stock = new Stock($accommId,$calStartDate,$calEndDate,false,$_SESSION['filAgentId'],false);
	} else {
		$stock = new Stock($accommId,$calStartDate,$calEndDate);
	}

	$occupancy[$accommId]['propertyId'] = $item['pr_business_id'];
	$occupancy[$accommId]['propertyName'] = $item['pr_name_last'];
	$occupancy[$accommId]['accomm_name'] = $item['ac_accomm_desc'];

	$accommMax = $stock->ToAccommMax();
	$accommMin = $stock->ToAccommMin();

	if ( $accommMax != $accommMin ) {
		$occupancy[$accommId]['units'] = $accommMin . " - " . $accommMax;
	} else {
		$occupancy[$accommId]['units'] = $accommMax;
	}
	$occupancy[$accommId]['occupancy'] = $stock->ToOccupancy($statusFilter);

	// Blocked Rooms ------------------------------------------------------------
	$occupancy[$accommId]['block'] = $stock->ToBlock();
	$occupancy[$accommId]['roomsForToday'] = $stock->ToAccomm();
	$occupancy[$accommId]['provisionals'] = $stock->ToProvisional();

	// Allocations ---------------------------------------------------------------
	if ( in_array("15",$calStatusList) ) {
		$occupancy[$accommId]['allocations'] = $stock->ToAllocation();
	}
}

// PHASE 4:
// Output the data ------------------------------------------------------------
// ============================================================================
$html = "";
$outputPropertyName = "";
$outputAccommType = "";

foreach($occupancy as $accommId => $v) {
	if($outputPropertyName != $v['propertyName']) {
		$html .= "<tr style=\"height: 20px;\"><td colspan=\"24\" class=\"colLt noTop\" style=\"padding: 2px;\"><b>" . t_encodeHTMLField($v['propertyName']) . "</b></td></tr>";
		$outputPropertyName  = $v['propertyName'];
	}	

	// Accommodation Name -------------------------------------------------------
	$html .= "<tr style=\"height: 20px;\"><td style=\"text-align: left;\" class=\"bb br bl\">&nbsp;" . t_encodeHTMLField($v['accomm_name']) . "</td>";

	// Units --------------------------------------------------------------------
	$html .= "<td align=\"center\" class=\"bb br\">" . $v['units'] . "</td>";


	// Daily occupancy ----------------------------------------------------------
	foreach($v['occupancy'] as $date => $o) {

		$cellClass = "g1C";

		if ( in_array($date,$weekendList) ) {
			$cellClass = "wkEndNoBorder calNoTop";
		}

		if ( $o == $v['roomsForToday'][$date] || ( $v['block'][$date] + $o == $v['roomsForToday'][$date] )) {  
			$cellClass = "full";
		}
		
		if ( $v['block'][$date] == $v['roomsForToday'][$date] ) { 
			$cellClass = "blockNoBorder";
		}

		if ( $o > $v['roomsForToday'][$date] || ( $v['block'][$date] + $o > $v['roomsForToday'][$date] ) ) {
			$cellClass = "overbooking";
		}

		if($o == 0) {
			$o = "&nbsp;";
		}

		if($v['provisionals'][$date] > 0 && in_array("20",$calStatusList)) {
			$o .= "*";
		}

		// Organise dates ---------------------------------------------------------
		$thisDate = explode("-",$date);
		$day 		= date("d",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		$month 	= date("m",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));
		$year 	= date("Y",mktime(0,0,0,$thisDate[1],$thisDate[2],$thisDate[0]));

		// Add the Allocation Indicator ---------------------------------------------
		// TODO: To be implemented in 3.16. Pending a decent spec, of course.
		/*
		if ( $v['allocations'][$date] > 0 ) {
			$cellClass .= " allocationIndicator";
		}
		 */

		$html .= "<td align=\"center\" valign=\"middle\" unselectable=\"on\" class=\"" . $cellClass . "\" defclass=\"" . $cellClass . "\" width=\"25\" name=\"" . $accommId . ":" . t_encodeOverlib($v['propertyName']) . ":" . t_encodeOverlib($v['accomm_name']) . ":" . $o . "::0:1:" . $v['units'] ."\" id=\"" . $accommId . ":" . $month . ":" . $day . ":" . $year . "\" onmousedown=\"mouseDownFunction(event,arguments[0]);\" onmouseup=\"cMouseUp(event,arguments[0]);\" onmouseover=\"mouseOverFunction(event,arguments[0]);\" >" . $o . "</td>";
	}
	$html .= "</tr>";
}

$GLOBALS['temp']['rows'] = $html;
// PHASE 4 : END --------------------------------------------------------------
// ============================================================================

// Phase 5 :
// Echo variables -------------------------------------------------------------
// ============================================================================
$GLOBALS['temp']['calendar_data'] = "var accommnotes = new Array();\n";
$GLOBALS['temp']['calendar_data'] .= "var accommIdList = new Array(\"" . join('","',$calAccommList) . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var middledate = \"" . $calStartDay . "-" . $calStartMonth . "-" . $calStartYear . "\";\n";
$GLOBALS['temp']['calendar_data'] .= "var middledateR = \"" . $calStartDate . "\";\n";
$GLOBALS['temp']['calendar_data'] .= "var days = new Array(" . join(",",makeDates($calStartDate,$defaultPeriod,"j")) . ");\n";
$GLOBALS['temp']['calendar_data'] .= "var weekends = new Array(" . join(",",makeDates($calStartDate,$defaultPeriod,"Ymd",1)) . ");\n";
$GLOBALS['temp']['calendar_data'] .= "var months = new Array(\"" . $calStartMonth . "\",\"" . $calEndMonth . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var years = new Array(\"" . $calStartYear . "\",\"" . $calEndYear . "\");\n";
$GLOBALS['temp']['calendar_data'] .= "var propertylist = new Array(";
	 
$acmax = sizeof($defaultPropList);
for($ac=0;$ac<$acmax;$ac++) {
	if ($ac!=0) {
		$GLOBALS['temp']['calendar_data'] .= ",";
	}
	$key = $defaultPropList[$ac];
	$GLOBALS['temp']['calendar_data'] .= "\"".$key."\",";
	$GLOBALS['temp']['calendar_data'] .= "\"".t_encodeOverlib($calPropData[$key])."\"";
}

$GLOBALS['temp']['calendar_data'] .= ");\n";
$GLOBALS['temp']['calendar_data'] .= "var selectedProperties = '".join(":",$calPropList)."';\n";
$GLOBALS['temp']['calendar_data'] .= "var selectedStatuses = '" . join(":",$calStatusList) . "';\n";
$GLOBALS['temp']['calendar_data'] .= "var propertylistInfo = new Array();\n";
$GLOBALS['temp']['calendar_data'] .= "var agent_id = '".(isset($_SESSION['filAgentId'])?$_SESSION['filAgentId']:"")."';\n";
$GLOBALS['temp']['filterAgentID']  = isset($_SESSION['filAgentId'])?$_SESSION['filAgentId']:"0";

# Screen output variables
$GLOBALS['temp']['wizResId'] = (string) $wizResId;
$GLOBALS['temp']['wizLoadContents'] = (string) $wizLoadContents;
$GLOBALS['temp']['wizAgentId'] = (string) $wizAgentId;
$GLOBALS['temp']['masterdb'] = (string) $canCalWizard;

$GLOBALS['temp']['userStatusId'] = (string) $userStatusId;
$GLOBALS['temp']['HaveBizLink'] = (string) "0";
$GLOBALS['temp']['HaveAgnLink'] = (string) "0";
$GLOBALS['temp']['IsPublic'] = (string) "0";

if ($userStatusId > 1) { $GLOBALS['temp']['HaveBizLink'] = "1"; }
if ($userStatusId == "1") { $GLOBALS['temp']['HaveAgnLink'] = "1"; }
if ($userStatusId == "0") { $GLOBALS['temp']['IsPublic'] = "1"; }

(in_array("20",$calStatusList)) ? $GLOBALS['temp']['isProv'] = "1": $GLOBALS['temp']['isProv'] = "0";

$GLOBALS['temp']['canOcc'] = (string) $calEnableOcc;
$GLOBALS['temp']['allowProvs'] = (string) $calAllowProvs;
$GLOBALS['temp']['AgentID'] = (string) $calAgentId;
$GLOBALS['temp']['calAcPeriodId'] = (string) $calAcPeriodId;
($GLOBALS['userid'] == $calAgentId) ? $GLOBALS['temp']['isAgent'] = "1": $GLOBALS['temp']['isAgent'] = (string) "0";

$GLOBALS['temp']['calLimitDisplay'] = (string) $calLimitDisplay;
$GLOBALS['temp']['calMaxDisplay'] = (string) $calMaxDisplay;

$GLOBALS['temp']['calPropList'] = join(", ",$calPropList);
$GLOBALS['temp']['selPropList'] = t_encodeOverlib(join(", ",$GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix IN ('".join("','",$calPropList)."')",3)));
$GLOBALS['temp']['defaultPropList'] = join(", ",$defaultPropList);
$GLOBALS['temp']['calAccommList'] = join(", ",$calAccommList);
$GLOBALS['temp']['calStatusList'] = join(", ",$calStatusList);
$GLOBALS['temp']['selStatusList'] = join(", ",$GLOBALS['lDB']->get("SELECT rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id IN ('".join("','",$calStatusList)."')",3));

$GLOBALS['temp']['calStartDate']     = (string) $calStartDate;
$GLOBALS['temp']['calEndDate']       = (string) $calEndDate;

$GLOBALS['temp']['mnLeft']           = (string) $startMonthName;
$GLOBALS['temp']['yrLeft']           = (string) $startYear;
$GLOBALS['temp']['mnRight']          = (string) $stopMonthName;
$GLOBALS['temp']['yrRight']          = (string) $stopYear;
$GLOBALS['temp']['weekendList']      = join(", ",$weekendList);

# set the form start tag containing the submit action
$GLOBALS['temp']['formstart'] = '<form id="'.$form.'" name="'.$form.'" style="margin: 0; padding: 0;">';

$prop_tag = Join(":",$calPropList);
# set the form submit tag and required hidden fields
$GLOBALS['temp']['formsubmit'] = '
	<input type="hidden" id="mode" name="mode" value="">
	<input type="hidden" id="jobid" name="jobid" value="" />
	<input type="hidden" id="record" name="record" value="" disabled="disabled" />
	<input type="hidden" id="middledate" name="middledate" value="' . $calStartDate . '" disabled="disabled" />
	<input type="hidden" id="property_select" name="property_select" value="' . $prop_tag . '" disabled="disabled" />
	<input type="hidden" id="status" name="status" value="' . join(":",$calStatusList) . '">
	</form>
';


session_set(array(
	'calStartDate'=>$calStartDate,
	'calEndDate'=>$calEndDate,
	'calPropList'=>$calPropList,
	'calAccommList'=>$calAccommList,
	'calAgentId'=>$calAgentId,
	'canCalWizard'=>$canCalWizard,
	'userStatusId'=>$userStatusId,
	'calStatusList'=>$calStatusList
));
