<?php

/*
 * init.form12.php - Reservation Summary Popup
 * Job: 31 - Booked Calendar Item List Display
 * Function: 51 (Occupancy calendar)
 *
 * Job: 274 - Details Tab Item List Display (for allocation overbooking)
 * Function: 52 (Reservation: Maintenance)
 *
 * Job: 275 - Allocation Popup Item List Display (for overbooking)
 * Function: 83 (Contact Agent Role)
 */

if(!isset($GLOBALS[$form]) ) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/booked_list.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],10,"");

switch($_SERVER['argv'][0]) {
	case 274:
		$GLOBALS['temp']['title'] = "
		<td class=\"colRed printCollapse txtb txtwh\">&nbsp;Saving this allocation will result in an overbooking. The listing below shows where the stock is currently allocated.</td>
		";
		break;
	case 275:
		$GLOBALS['temp']['title'] = "
		<td class=\"colRed printCollapse txtb txtwh\">&nbsp;Saving this block would cause an overbooking. Use the listings below to correct this.</td>
		";
		break;	
	default:	
	case 31:
		$GLOBALS['temp']['title'] = "
		<td width=\"25\" align=\"center\" class=\"outDk printCollapse\"><img name=\"info\" class=\"imgLink\" src=\"/resource/Resrequest/Application/public/img/info_msg.gif\" onmouseover=\"overlib('<div class=\'small\'>This window shows a list of all reservations captured in the system for the the properties, accommodation type, status, agent and date range selected. Select a reservation from the list to view the details.<br><br>When you view the reservation use the <img src=\'images/previous_std.gif\'> previous and <img src=\'images/next_std.gif\'> next icons on the toolbar to scroll through the reservation details in the order they appear in this window.</div>',WIDTH,450)\" onmouseout=\"nd()\"></td>
		<td class=\"outDk printCollapse\">&nbsp;Summary of reservations from selected date range on the occupancy calendar</td>
		";
		break;
}
$GLOBALS['temp']['job'] = $_SERVER['argv'][0];

$resScollSet = isset($_SESSION['resScrollSet'])?$_SESSION['resScrollSet']:array();
$resScollSet = array();

$accommid 		= $_SERVER['argv'][1];
$startdate 		= $_SERVER['argv'][2];
$enddate 		= $_SERVER['argv'][3];
$statusfilter	= $_SERVER['argv'][4];
$agent_id		= $_SERVER['argv'][5];
$sortBy			= $_SERVER['argv'][6];
$showHideOriginator     = $_SERVER['argv'][7];
$showHideSource         = $_SERVER['argv'][8];
$showHidePaymentPlan    = $_SERVER['argv'][9];

$GLOBALS['temp']['originatorColCollapse']   = $showHideOriginator == "1" ? "" : "collapse printCollapse";
$GLOBALS['temp']['sourceColCollapse']       = $showHideSource == "1" ? "" : "collapse printCollapse";
$GLOBALS['temp']['pmtplanColCollapse']      = $showHidePaymentPlan == "1" ? "" : "collapse printCollapse";

if ( trim($sortBy) == "" ) {
	$sortBy = "8";
}

$GLOBALS['temp']['sortBy'] 	= $sortBy;
$GLOBALS['temp']['baseURL'] = "reservation.php?31+" . $accommid . "+" . $startdate . "+" . $enddate . "+" . $statusfilter . "+" . $agent_id;

// Used for allocations calculations ------------------------------------------
$tempAllocStartDate = explode("-",$startdate);
$allocStartDate 		= date("Y-m-d",mktime (0,0,0,$tempAllocStartDate[1],$tempAllocStartDate[2],$tempAllocStartDate[0]));

$tempAllocEndDate 	= explode("-",$enddate);
$allocEndDate 			= date("Y-m-d",mktime (0,0,0,$tempAllocEndDate[1],$tempAllocEndDate[2]-1,$tempAllocEndDate[0]));

if ( $statusfilter == "" ) {
	$statusfilter = "20:25:30";
}

$GLOBALS[$form]->Get($action);

$now 	= date("Y-m-d");
$now2 = date("Y-m-d H:i:s");

$GLOBALS['temp']['rows'] = "";

$SQL = "
	SELECT DISTINCT
		rv_reservation_item.rv_reservation_item_ix as itemId,
		rv_reservation_item.rv_reservation_id as resId,
		rv_reservation_item.rv_item_accomm_count as accommCount,
		rv_reservation_item.rv_item_adult_count as adultCount,
		rv_reservation_item.rv_item_child_count as childCount,
		rv_reservation_item.rv_item_date_arrive as date_arrive,
		rv_reservation_item.rv_item_date_depart as date_depart,
		rv_reservation.rv_res_name as rname,
		rv_reservation.rf_reservation_status_id as statusId,
		rv_reservation.rv_provision_expiry_date as provDate,
		rv_reservation.rv_consultant_id as consultantId,
		rf_reservation_status.rf_reservation_status_desc as statusName,
		rv_reservation.rv_agent_id,
		persona_agent.pr_name_last as agentName,
		rv_reservation.rv_origin_agent_id,
		TRIM(CONCAT(persona_originator.pr_name_first,(CONCAT(' ',persona_originator.pr_name_last)))) as originatorName,
		rv_reservation.rf_source_ix,
		rf_source.rf_source_desc as sourceName,
		rv_reservation.ac_pay_plan_id,
		ac_pay_plan.ac_pay_plan_desc as payplanDesc,
		rt_rate_type.rt_rate_type_desc as resRate,
		rt_rate_type.rt_rate_type_colour as rateColor,
		bl_block.bl_block_name as blockName,
		bl_block.bl_block_ix,
		allocation.rv_res_name as allocationName,
		CASE 
			WHEN allocation.rv_res_name = '' OR allocation.rv_res_name IS NULL THEN ''
			WHEN bl_block.bl_block_name != '' AND bl_block.bl_block_name IS NOT NULL THEN 'Block'
			WHEN (bl_block.bl_block_name = '' OR bl_block.bl_block_name IS NULL) AND (allocation.rv_res_name != '' AND allocation.rv_res_name IS NOT NULL) THEN 'Allocation'
			ELSE ''
		END AS drawDown
	FROM
		rv_reservation_item
	INNER JOIN rv_reservation ON
		rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	LEFT JOIN rv_reservation_item AS allocation_item 
		ON allocation_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
	LEFT JOIN rv_reservation allocation 
		ON allocation.rv_reservation_ix = allocation_item.rv_reservation_id
	LEFT JOIN bl_block_period 
		ON bl_block_period.bl_block_period_ix = allocation.bl_block_period_id
	LEFT JOIN bl_block 
		ON bl_block.bl_block_ix = bl_block_period.bl_block_id
	LEFT JOIN rf_reservation_status ON 
		rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
	LEFT JOIN rt_rate_type ON 
		rt_rate_type.rt_rate_type_ix = rv_reservation_item.rt_rate_type_id
	LEFT JOIN pr_persona persona_agent ON
		persona_agent.pr_persona_ix = rv_reservation.rv_agent_id
	LEFT JOIN pr_persona persona_originator ON
		persona_originator.pr_persona_ix = rv_reservation.rv_origin_agent_id
	LEFT JOIN rf_source ON
		rf_source.rf_source_ix = rv_reservation.rf_source_ix
	LEFT JOIN ac_pay_plan ON
		ac_pay_plan.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
	WHERE
		rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	AND
		rv_reservation_item.ac_accomm_type_id = '" . $accommid . "'
";

$statuslist = explode(":",$statusfilter);
$closingRoundBracket = "";

$level = 0;
if ( in_array(0,$statuslist) ) {
	// Pending ------------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '0'";
	$level = 1;
}

if ( in_array(10,$statuslist) ) {
	// Waitlist - checked -------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '10'";
	$level = 1;
}

if ( in_array(15,$statuslist) ) {
	// Allocation -------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '15'";
	$level = 1;
}

if ( in_array(20,$statuslist) ) {
	// Provisional --------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " ( rv_reservation.rf_reservation_status_id = '20' AND rv_reservation.rv_provision_expiry_date >= '$now' ) ";
	$level = 1;
}

if ( in_array(25,$statuslist) ) {
	// In Progress --------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " ( rv_reservation.rf_reservation_status_id = '25' AND rv_reservation.rv_create_expiry_date >= '$now2' ) ";
	$level = 1;
}

if ( in_array(30,$statuslist) ) {
	// Confirmed ----------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '30'";
	$level = 1;
}

if ( in_array(90,$statuslist) ) {
	// Cancelled ----------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '90'";
	$level = 1;
}

if ( in_array(95,$statuslist) ) {
	// Deleted ----------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '95'";
	$level = 1;
}

if ( in_array(97,$statuslist) ) {
	// Deleted allocation ----------------------------------------------------------------
	if ( $level == 0 ) {
		$SQL .= "AND (";
        $closingRoundBracket = " ) ";
	} else {
		$SQL .= " OR ";
	}
	$SQL .= " rv_reservation.rf_reservation_status_id = '97'";
	$level = 1;
}

$SQL .= $closingRoundBracket;

// Test for agent filter ID ---------------------------------------------------
if ( trim($agent_id) == "" || $agent_id == "0" ) {
	$SQL .= "
		AND 
			rv_reservation_item.rv_item_date_arrive < '" . $enddate . "' 
		AND 
			rv_reservation_item.rv_item_date_depart > '" . $startdate . "'
	";
} else {
	$SQL .= "
		AND 
			rv_reservation.rv_agent_id = '" . $agent_id . "' 
		AND 
			rv_reservation_item.rv_item_date_arrive < '" . $enddate . "' 
		AND 
			rv_reservation_item.rv_item_date_depart > '" . $startdate . "'
	";
}

switch ( $sortBy ) {
case 0: // Reservation Number (asc) -------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation.rv_reservation_ix
	";
	break;
case 1: // Reservation Number (dsc) -------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation.rv_reservation_ix DESC
	";
	break;
case 2: // Reservation Name (asc) ---------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation.rv_res_name
	";
	break;
case 3: // Reservation Name (dsc) ---------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation.rv_res_name DESC
	";
	break;
case 4: // Agent (asc) --------------------------------------------------------
	$sortSQL = "
		ORDER BY
			persona_agent.pr_name_last
	";
	break;
case 5: // Agent (dsc) --------------------------------------------------------
	$sortSQL = "
		ORDER BY
			persona_agent.pr_name_last	DESC
	";
	break;
case 6: // Rooms (asc) --------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_accomm_count
	";
	break;
case 7: // Rooms (dsc) ---------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_accomm_count DESC
	";
	break;
case 8: // Arrive (asc) -------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_date_arrive
	";
	break;
case 9: // Arrive (dsc) -------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_date_arrive DESC
	";
	break;
case 10: // Depart (asc) ------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_date_depart
	";
	break;
case 11: // Depart (dsc) ------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_date_depart DESC
	";
	break;
case 12: // Status (asc) ------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rf_reservation_status.rf_reservation_status_desc
	";
	break;
case 13: // Status (dsc) ------------------------------------------------------
	$sortSQL = "
		ORDER BY
			rf_reservation_status.rf_reservation_status_desc DESC
	";
	break;
case 14: //Number of adults (desc) -------------------------------------------- 
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_adult_count DESC
			";
	break;
case 15: // Number of adults (asc) --------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_adult_count
	";
	break;
case 16: // Number of children (desc) -----------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_child_count DESC
		";
	break;
case 17: // Number of children (asc) ------------------------------------------
	$sortSQL = "
		ORDER BY
			rv_reservation_item.rv_item_child_count
		";
	break;
case 18: 
	$sortSQL = "
		ORDER BY
			rt_rate_type.rt_rate_type_desc DESC
		";
	break;
case 19:
    $sortSQL = "
		ORDER BY
			rt_rate_type.rt_rate_type_desc
		";
    break;
case 20:
    $sortSQL = "
		ORDER BY
			persona_originator.pr_name_last
		";
        break;
case 21:
    $sortSQL = "
		ORDER BY
			persona_originator.pr_name_last DESC
		";
        break;
case 22:
    $sortSQL = "
		ORDER BY
			rf_source.rf_source_desc
		";
        break;
case 23:
    $sortSQL = "
		ORDER BY
			rf_source.rf_source_desc DESC
		";
        break;
case 24:
    $sortSQL = "
		ORDER BY
			persona_agent.pr_name_last
		";
        break;
case 25:
    $sortSQL = "
		ORDER BY
			persona_agent.pr_name_last DESC
		";
        break;
case 26:
    $sortSQL = "
		ORDER BY
			drawDown
		";
        break;
case 27:
    $sortSQL = "
		ORDER BY
			drawDown DESC
		";
		break;
default:
	$sortSQL = "";
}

$SQL .= $sortSQL;

$result = $GLOBALS['lDB']->get($SQL,2);


$HTML = join("",file(__DIR__ . "/../../../public/html/booked_item_rows.htm"));

$rownum 	= sizeof($result);
$rownumb 	= $rownum;

if ( $rownum == "0" ) {
	$rownumb = "1";
}

$GLOBALS['temp']['numrows'] = " var NumRows = " . $rownumb . ";";

for ( $i = 0; $i < $rownum; $i++ ) {
    if (!in_array($result[$i]['statusId'], array("15","97"))) {
        $provColor = "";
        
        if ( !in_array($result[$i]['resId'],$resScollSet) ) {
            array_push($resScollSet,$result[$i]['resId']);
        }
        
        $result[$i]['optionalComps'] = getOptionalComponents($result[$i]['itemId']);

        $overLibWidth = 6*strlen($result[$i]['resRate']);
        $result[$i]['resRateMouseOver'] = "overlib('".t_encodeOverlib($result[$i]['resRate'])."',ABOVE,OFFSETX,2,HEIGHT,-25,WIDTH,$overLibWidth); ";
        if(strlen($result[$i]['resRate']) > 10) {
            $result[$i]['resRate'] = substr($result[$i]['resRate'],0,8)."..";
        }

        // Changing Provisional color -----------------------------------------------
        if ( $result[$i]['statusId'] == "20" ) {
            $today = date("Y-m-d");
            
            if ( $today == $result[$i]['provDate'] ) {
                $provColor = "#f1c55d";
            }

            if ( $today > $result[$i]['provDate'] ) {
                $provColor = "#db4242";
            }
        }
        $result[$i]['provColor'] = $provColor;
        

        // Set a new field with the status to be displayed in list ------------------

        if ( $result[$i]['consultantId'] == "0" || $result[$i]['consultantId'] == "" ) {
            $result[$i]['statusName'] = str_replace("Quotation","Quote",$result[$i]['statusName']);
            $result[$i]['statusName'] = str_replace("Waitlist","Wait",$result[$i]['statusName']);
            $result[$i]['statusName'] = str_replace("Provisional","Prov",$result[$i]['statusName']);
            $result[$i]['statusName'] = str_replace("Confirmed","Confirm",$result[$i]['statusName']);
            $result[$i]['statusName'] = $result[$i]['statusName']." (Req)";
        }

        $result[$i]['provDate'] 		= chng_date($result[$i]['provDate'],"-");
        $result[$i]['date_arrive'] 	= chng_date($result[$i]['date_arrive'],"-");
        $result[$i]['date_depart'] 	= chng_date($result[$i]['date_depart'],"-");

        if ( $result[$i]['statusId'] != "20" ) {
            $result[$i]['provDate'] = "";
        }
        
        $result[$i]['jobNum'] = "0";
        
        if ( canEditReservation($result[$i]['resId']) ) {
            $result[$i]['jobNum'] = "2";
        }

        $resultAgentId	= $result[$i]['rv_agent_id'];
        $agentCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_persona WHERE pr_persona_ix = '" . $resultAgentId . "'",4);
        
        if ( $agentCount > 0 ) {
            $result[$i]['agentName'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '" . $resultAgentId . "'",4);
        } else {
            $result[$i]['agentName'] = "Direct";
        }

        if ( $result[$i]['originatorName'] == "" ) {
            $result[$i]['originatorName'] = "&nbsp;";
        }

        if ( $result[$i]['sourceName'] == "" ) {
            $result[$i]['sourceName'] = "&nbsp;";
        }

        if ( $result[$i]['payplanDesc'] == "" ) {
            $result[$i]['payplanDesc'] = "&nbsp;";
        }

        if ( $result[$i]['drawDown'] == "" ) {
            $result[$i]['drawDown'] = "&nbsp;";
        }
        if ( $result[$i]['drawDown'] == "Block" ) {
            $result[$i]['drawDown'] = "<a class=\"link\" href='#' onclick=\"processPopup('reservation.php?6004+".$result[$i]['bl_block_ix']."'); event.cancelBubble = true;\" onmouseover=\"overlib('<div class=\'small\'>Click to view block template</div>',WIDTH,200)\" onmouseout=\"nd()\">Block</a>";
        }
        $GLOBALS['temp']['rows'] .= showpage($result[$i],$HTML);
    }
}

// Get property id and name ---------------------------------------------------
$propid = $GLOBALS['lDB']->get("SELECT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix = '$accommid'",4);

$GLOBALS['temp']['itemproperty'] = t_encodeHTMLField($GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '" . $propid . "'",4));
$GLOBALS['temp']['accommname'] = t_encodeHTMLFIeld($GLOBALS['lDB']->get("SELECT ac_accomm_desc FROM ac_accomm_type WHERE ac_accomm_type_ix = '$accommid'",4));

$tempdate 	= explode("-",$startdate);
$startdate 	= date("d M Y",mktime (0,0,0,$tempdate[1],$tempdate[2],$tempdate[0]));
$sqlStartDate = date("Y-m-d",mktime (0,0,0,$tempdate[1],$tempdate[2],$tempdate[0]));

$tempdate			= explode("-",$enddate);
$enddate			= date("d M Y",mktime (0,0,0,$tempdate[1],$tempdate[2],$tempdate[0]));
$sqlInitEndDate = date("Y-m-d",mktime (0,0,0,$tempdate[1],$tempdate[2],$tempdate[0]));
$dis_enddate 	= date("d M Y",mktime (0,0,0,$tempdate[1],$tempdate[2]-1,$tempdate[0]));
$sqlEndDate = date("Y-m-d",mktime (0,0,0,$tempdate[1],$tempdate[2]-1,$tempdate[0]));

$GLOBALS['temp']['startdate'] = $startdate;
$GLOBALS['temp']['enddate'] 	= $dis_enddate;

if ( trim($GLOBALS['temp']['rows']) == "" ) {
	$GLOBALS['temp']['rows'] = "
		<tr>\n
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"16\" alt=\"\" /></td>\n
			<td class=\"form\" align=\"center\" colspan=\"13\">There are no reservation items on this accommodation for this date range.</td>\n
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"16\" alt=\"\" /></td>\n
		</tr>\n
	";
	$reservationExists = false;
} else {
	$reservationExists = true;
}

setRecordScroll($resScollSet);

$blocks = $lDB->get("
	SELECT
		count(*)
	FROM
		ac_accomm_block
	WHERE
		ac_accomm_type_id = '$accommid'
		AND (
			(
				ac_accomm_block.ac_start_date >= '$sqlStartDate'
				AND ac_accomm_block.ac_start_date <= '$sqlEndDate'
			) OR (
				ac_accomm_block.ac_end_date > '$sqlStartDate'
				AND ac_accomm_block.ac_end_date <= '$sqlEndDate'
			) OR (
				ac_accomm_block.ac_start_date < '$sqlStartDate'
				AND ac_accomm_block.ac_end_date > '$sqlEndDate'
			)
			
		)
",4);

if ( $blocks > 0 ) {
	$blockHTML = join("",file(__DIR__ . "/../../../public/html/booked_blocked_rows.htm"));
	$blocked = $lDB->get("
		SELECT
			ac_accomm_block_ix as ac_accomm_block_id,
			ac_start_date,
			ac_end_date,
			ac_reason
		FROM
			ac_accomm_block
		WHERE
			ac_accomm_type_id = '$accommid'
			AND (
				(
					ac_accomm_block.ac_start_date >= '$sqlStartDate'
					AND ac_accomm_block.ac_start_date <= '$sqlEndDate'
				) OR (
					ac_accomm_block.ac_end_date > '$sqlStartDate'
					AND ac_accomm_block.ac_end_date <= '$sqlEndDate'
				) OR (
					ac_accomm_block.ac_start_date < '$sqlStartDate'
					AND ac_accomm_block.ac_end_date > '$sqlEndDate'
				)
				
			)
	",2);
	
	$nmmax = sizeof($blocked);
	
	$GLOBALS['temp']['brows'] = "";
	for ( $nm = 0; $nm < $nmmax; $nm++ ) {
		$blockId = $blocked[$nm]['ac_accomm_block_id'];
		$sql = "
			SELECT
				ac_accomm_room.ac_desc
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
			WHERE
				ac_accomm_room_block.ac_accomm_block_id = '".$blockId."'
			ORDER BY
				ac_accomm_room.ac_desc
		";
		$blockRooms = join(", ",$lDB->get($sql,3));
		$blockStart = chng_date($blocked[$nm]['ac_start_date'],"-");
		$blockEnd = chng_date($blocked[$nm]['ac_end_date'],"-");
		$blockReason = $blocked[$nm]['ac_reason'];

		$blockArray = array("date" => $blockStart." - ".$blockEnd, "rooms" => $blockRooms, "reason" => $blockReason);
		$GLOBALS['temp']['brows'] .= showpage($blockArray,$blockHTML);
	}
	$blockExists = true;
} else {
	$GLOBALS['temp']['brows'] = "
		<tr>
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"16\" alt=\"\" /></td>
			<td class=\"form\" align=\"center\">There are no blocked rooms on this accommodation for this date range.</td>
			<td><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\" width=\"1\" height=\"16\" alt=\"\" /></td>
		</tr>
	";
	$blockExists = false;
}

/* Allocations ------------------------------------------------------------- */

$agentSQL = "";

if ( trim($agent_id) != "" ) {
	$agentSQL = " AND rv_reservation.rv_agent_id = '" . $agent_id . "'";
	$stock = new Stock($accommid,$sqlStartDate,$sqlEndDate,false,$_SESSION['filAgentId'],false);
} else {
	$stock = new Stock($accommid,$sqlStartDate,$sqlEndDate);
}

$occupancyAlloc = $stock->ToOccupancyAllocation();

$allocRows = "";
$allocationJob = $lDB->isMaster == 0 ? "267" : "270";

foreach($occupancyAlloc as $res) {
	$allocType = "Allocation";
	foreach($res as $item) {
		if ($item['count'] > 0) {
			if($item['rv_alloc_expiry_date'] == "0000-00-00") {
				$expiry = $item['rv_alloc_expiry_days'] . " day lead time";
			} else {
				$expiry = chng_date($item['rv_alloc_expiry_date'],"-");
			}
			$allocationName = $item['rv_res_name'];
			$popupOnClick = "openPopup('reservation.php?" . $allocationJob . "+$item[rv_agent_id]+$item[rv_reservation_ix]++',700,600)";
			if (!empty($item['bl_block_ix'])) {
				$allocType = "Block";
				$popupOnClick = "processPopup('reservation.php?6004+$item[bl_block_ix]')";
				if (!empty($item['bl_block_abbrev'])) {
					$allocationName = $item['bl_block_name'] . " (" . $item['bl_block_abbrev'] . ")";
				} else {
					$allocationName = $item['bl_block_name'];
				}
			}
			$allocRows .= "
				<tr>
					<td valign=\"top\" class=\"bb br\">$item[rv_reservation_ix]</td>
					<td valign=\"top\" class=\"bb br\">$allocationName</td>
					<td valign=\"top\" class=\"bb br\">$item[pr_name_last]</td>
					<td valign=\"top\" class=\"bb br\">$item[count]</td>
					<td align=\"center\" valign=\"top\" class=\"bb br\">" . chng_date($item['start'],"-") . "</td>
					<td align=\"center\" valign=\"top\" class=\"bb br\">" . chng_date($item['end'],"-") . "</td>
					<td align=\"center\" valign=\"top\" class=\"bb br\">$expiry</td>
					<td align=\"center\" valign=\"top\" class=\"bb br\"><a class=\"link\" href='#' onclick=\"$popupOnClick;\" onmouseover=\"overlib('<div class=\'small\'>Click to view Allocation / Block template</div>',WIDTH,200)\" onmouseout=\"nd()\">$allocType</a></td>
				</tr>
			";
		}
	}
}

$GLOBALS['temp']['allocOutput'] = "
	<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">
	<col />
	<col />
	<col />
	<col align=\"center\" />
	<col />
	<col />
	<col />
	<col />
	<thead>
	<tr>
		<th class=\"outDk\">Number</th>
		<th class=\"outDk\">Name</th>
		<th class=\"outDk\">Agent</th>
		<th class=\"outDk\">Rooms</th>
		<th class=\"outDk\">Start</th>
		<th class=\"outDk\">End</th>
		<th class=\"outDk\">Expiry</th>
		<th class=\"outDk\">Type</th>
	</tr>
	</thead>
";

if ( $allocRows ) {
	$GLOBALS['temp']['allocOutput'] .= $allocRows;
	$allocExists = true;
} else {
	$GLOBALS['temp']['allocOutput'] .= "<tr><td colspan=\"7\" align=\"center\">There are no allocations on this accommodation for this date range</td></tr>";
	$allocExists = false;
}

$GLOBALS['temp']['allocOutput'] .= "</table>";

// Show icons on the tabs if there is information present ---------------------
$GLOBALS['temp']['rOccupancy'] = "";
$GLOBALS['temp']['bOccupancy'] = "";
$GLOBALS['temp']['aOccupancy'] = "";


if ( $reservationExists ) {
	$GLOBALS['temp']['rOccupancy'] = "rOccupancy";
}

if ( $blockExists ) {
	$GLOBALS['temp']['bOccupancy'] = "bOccupancy";
}

if ( $allocExists ) {
	$GLOBALS['temp']['aOccupancy'] = "aOccupancy";
}
