<?php

/**
 * init.form160.php - Overbooking Popup
 * Job: 525
 * Function: 52 (Reservation: Maintenance)
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/overbooking_details.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],10,"");

$record = $_SERVER['argv'][1];
$itemId = $_SERVER['argv'][2];
$Date_Arrive = $_SERVER['argv'][3];
$Date_Depart = $_SERVER['argv'][4];
$today = date("Y-m-d");
$Accomm_Type_ID = $_SERVER['argv'][5];
$Unit_Count = $_SERVER['argv'][6];

$switch = $_SERVER['argv'][7]; # Show or Hide the allow save functions.
$GLOBALS['temp']['cansave'] = "";
$GLOBALS['temp']['cansave_style'] = "display:none";
if ($switch == "1") {
	$GLOBALS['temp']['cansave'] = "1";
	$GLOBALS['temp']['cansave_style'] = "";
}

$GLOBALS['temp']['js_focus'] = "";
if ($_SERVER['argv'][8] == "1") {
	$GLOBALS['temp']['js_focus'] = "opener.document.forms[0].rv_item_accomm_count.focus();\n";
}
$tempz = $GLOBALS['lDB']->get("
	SELECT 
		rv_res_name 
	FROM 
		rv_reservation 
	WHERE 
		rv_reservation_ix = '$record'
",4);
$blockAbbreviation = $GLOBALS['lDB']->get("
	SELECT
		bl_block.bl_block_abbrev
	FROM
		bl_block
		INNER JOIN bl_block_period ON bl_block_period.bl_block_id = bl_block.bl_block_ix
		LEFT JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15'
	WHERE
		allocation.rv_reservation_ix = '$record'
",4);
$GLOBALS['temp']['resname'] = "None";
$GLOBALS['temp']['resnum'] = "N/A";
if ($tempz != "" && $tempz != "0") { 
	if (!empty($blockAbbreviation)) {
		$GLOBALS['temp']['resname'] = $blockAbbreviation . ": ". $tempz; 
	} else { 
		$GLOBALS['temp']['resname'] = $tempz; 
	}
}
if ($record != "" && $record != "0" ) { $GLOBALS['temp']['resnum'] = $record; }

$tempstatus = $GLOBALS['lDB']->get("
	SELECT
		rv_provision_expiry_date,
		rv_wait_list_date,
		rv_confirmation_date,
		rv_cancel_date,
		rv_invoice_date,
		rv_agent_id
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$record'
",1);

$statuslist = array(0 => "Provisional",1 => "Wait Listed",2 => "Confirmed",3 => "Cancelled",4 => "Invoiced",5 => "No Status");
$high = "5";
$default = date("U",mktime (0,0,0,01,01,1980));

for ($z = 0; $z < 5; $z++) {
	if ($tempstatus[$z] != "") {
		$date = $tempstatus[$z];
	} else {
		$date = "0000-00-00";
	}
	$t8x = explode("-",$date);
	$year = (integer) $t8x[0];
	$month = (integer) $t8x[1];
	$day = (integer) $t8x[2];
	if ($year <= "1980") { $year = "1980"; }
	if ($month == "00") { $month = "01"; }
	if ($day == "00") { $day = "01"; }
	$date = date("U",mktime (0,0,0,$month,$day,$year));

	if ($date != $default) {
		$high = $z;
		if ($z == "0") {
			$now = date("U");
			if ($date <= $now) {
				$high = "5";
			} else {
				$tempdate = explode("-",$tempstatus[$z]);
				$provdate = date("d M Y",mktime (0,0,0,$tempdate[1],$tempdate[2],$tempdate[0]));
			}
		}
	}
}

$GLOBALS['temp']['status'] = $statuslist[$high];

$counter = 1;

$myresultset = array(array_fill(0,5,""));
if ($itemId == "" && $_SERVER['argv'][3] == "") {
	$counter = 0;
	$temp = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_reservation_item WHERE rv_reservation_id = '$record'",1);
	$counter = $temp[0];
	if ($counter != "0") {
		$myresultset = $GLOBALS['lDB']->get("
			SELECT
				rv_reservation_item_ix,
				rv_item_date_arrive,
				rv_item_date_depart,
				ac_accomm_type_id,
				rv_item_accomm_count
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_id = '$record'
			ORDER BY
				rv_item_date_arrive
		",2);
	}
}

$GLOBALS['temp']['rows'] = "";
for($w=0;$w<$counter;$w++) {
	$row = array();
	$row['rows2'] = "";
	$row['resname'] = $GLOBALS['temp']['resname'];
	$row['resnum'] = $GLOBALS['temp']['resnum'];
	$row['status'] = $GLOBALS['temp']['status'];

	if ($myresultset[$w][0] != "" && $myresultset[$w][0] != "0") {
		$itemId = $myresultset[$w][0];          # Item ID
		$Date_Arrive = $myresultset[$w][1];    # Arrival Date
		$Date_Depart = $myresultset[$w][2];    # Departure Date
		$Accomm_Type_ID = $myresultset[$w][3]; # Accommodation
		$Unit_Count = $myresultset[$w][4];        # Amount of Rooms
	}

	unset($error);
	$error = check_item_availability($Date_Arrive,$Date_Depart,$Accomm_Type_ID,$Unit_Count,$itemId);

	$row['thedate'] = chng_date($Date_Arrive,"-")." to ".chng_date($Date_Depart,"-");
	$row['property'] = $error['property_name'];
	$row['accomm'] = $error['accomm_name'];
	$row['rooms'] = $Unit_Count;

	# Get the Accomm_Capacity
	$temp = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_accomm_room WHERE ac_accomm_type_id = '$Accomm_Type_ID' AND ac_accomm_room_inactive_yn = 0",1);
	$Accomm_Capacity = $temp[0];
	if ($Unit_Count > $Accomm_Capacity) {
		$theHTML2 = Join("",File(__DIR__ . "/../../../public/html/overbook_rows3.htm"));
		$over = $Unit_Count-$Accomm_Capacity;
		$capMsg = "<b class=\"txtbred\">Warning</b>: This item requires ".$Unit_Count." units, <b>exceeding</b> this accommodation type's limit by <b>".$over."</b> units!";
		$row['rows2'] .= str_replace("!capMsg!",$capMsg,$theHTML2);
	}

	if ($error !== true) {
		for ($s=0;$s<sizeof($error['days']);$s++) {
			if ($error['days'][$s] != "") {
				$now = date("Y-m-d");
				$now2 = date("Y-m-d H:i:s");
				$day = $error['days'][$s];
				$sql =  "
					SELECT
						rv_reservation.rv_res_name,
                        rv_reservation.rv_reservation_ix,
						rv_reservation.rv_confirmation_date,
						rv_reservation.rv_provision_expiry_date,
						rv_reservation_item.rv_item_accomm_count,
						rf_reservation_status.rf_reservation_status_desc as status
					FROM
						rv_reservation_item
						INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
						LEFT JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
					WHERE
						rv_reservation_item.rv_item_date_arrive <= '$day'
						AND rv_reservation_item.rv_item_date_depart > '$day'
						AND (
							rv_reservation.rf_reservation_status_id = '30'
							OR (
								rv_reservation.rf_reservation_status_id = '20'
								AND rv_reservation.rv_provision_expiry_date >= '$now'
							) OR (
								rv_reservation.rf_reservation_status_id = '25'
								AND rv_reservation.rv_create_expiry_date >= '$now2'
							)
						)
						AND rv_reservation_item.ac_accomm_type_id = '$Accomm_Type_ID'
				";
				if ($itemId != "") {
					$sql .= " AND rv_reservation_item.rv_reservation_item_ix != '$itemId' ";
				}
				$resultset = $GLOBALS['lDB']->get($sql,2);

				$blocks = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						ac_accomm_block
					WHERE
						(
							(
								ac_accomm_block.ac_start_date <= '$Date_Arrive'
								AND ac_accomm_block.ac_end_date >= '$Date_Arrive'
							) OR (
								ac_accomm_block.ac_start_date <= '$Date_Depart'
								AND ac_accomm_block.ac_end_date >= '$Date_Depart'
							) OR (
								ac_accomm_block.ac_start_date <= '$Date_Arrive'
								AND ac_accomm_block.ac_end_date >= '$Date_Depart'
							)
						) AND ac_accomm_type_id = '$Accomm_Type_ID'
				",4);

				if ($blocks > 0) {
					$blocked = $lDB->get("
						SELECT
							ac_accomm_block_ix as ac_accomm_block_id,
							ac_start_date,
							ac_end_date,
							ac_reason
						FROM
							ac_accomm_block
						WHERE
							(
								(
									ac_accomm_block.ac_start_date <= '$Date_Arrive'
									AND ac_accomm_block.ac_end_date >= '$Date_Arrive'
								) OR (
									ac_accomm_block.ac_start_date <= '$Date_Depart'
									AND ac_accomm_block.ac_end_date >= '$Date_Depart'
								) OR (
									ac_accomm_block.ac_start_date <= '$Date_Arrive'
									AND ac_accomm_block.ac_end_date >= '$Date_Depart'
								)
							) AND ac_accomm_block.ac_accomm_type_id = '$Accomm_Type_ID'
					",2);
					$nmmax = sizeof($blocked);
					for ($nm=0;$nm<$nmmax;$nm++) {
						$blockId = $blocked[$nm]['ac_accomm_block_id'];
						$blockCount = $lDB->get("
							SELECT
								COUNT(*)
							FROM
								ac_accomm_room_block
								INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
							WHERE
								ac_accomm_room_inactive_yn = 0 where ac_accomm_block_id = '$blockId'
						",4);
						$blockStart = $blocked[$nm]['ac_start_date'];
						$blockEnd = $blocked[$nm]['ac_end_date'];

						$blockArray = array(
							"0" => $blocked[$nm]['ac_reason'],
							"1" => "",
							"2" => "",
							"3" => "",
							"4" => $blockCount,
							"status" => "Blocked"
						);
						if ($resultset == array("0") || $resultset == array()) {
							$resultset = array($blockArray);
						} else {
							array_push($resultset,$blockArray);
						}
					}
				}

				$specialthingy = chng_date($day,"-");

				for ($j=0;$j<sizeof($resultset);$j++) {
					if ($j==0) {
						$rows['rolldate'] = $specialthingy;
					} else {
						$rows['rolldate'] = "";
					}

					$rows['resname'] = $resultset[$j][0];
					if (strlen($rows['resname']) > 13) {
						$rows['resname'] = substr($resultset[$j][0],"0",13)."...";
					}
					$rows['resnum'] = $resultset[$j][1];
					$confirmed = $resultset[$j][2];
					$provision = $resultset[$j][3];
					$rows['numrooms'] = $resultset[$j][4];

					$rows['status'] = $resultset[$j]['status'];

					$theHTML = Join("",File(__DIR__ . "/../../../public/html/overbook_rows2.htm"));
					$row['rows2'] .= showpage($rows,$theHTML);
				}
			}
		}
	}
	if ($row['rows2'] != "") {
		$theHTML2 = Join("",File(__DIR__ . "/../../../public/html/overbook_rows.htm"));
		$GLOBALS['temp']['rows'] .= showpage($row,$theHTML2);
	}
}

if (trim($GLOBALS['temp']['rows']) == "") {
	if ($switch) {
		$out = "
			<script language='javascript'>
			function processForm(var1) {
				if (var1 == 1) {
					parent.document.forms[0].cansave.value = \"1\";
					parent.document.forms[0].submit();
				}
				window.close();
			}
			</script>
		";
		$out .= "<body onload=\"processForm(1);\"></body>";
		echo $out;
		die;
	}
	$GLOBALS['temp']['rows'] = "";
} else {
	if ($_SERVER['argv'][9] == "1") {
		$_SERVER['argv'][9] = "0";
		echo "<script>parent.overbookPopup2();</script>";
		exit();
	}
}
