<?php

/**
 * init.form161.php - The Change Password Screen
 * Job: 527
 * Function: 66 (General Access)
*/

use MaglLegacyApplication\Application\MaglLegacy;

// Do not allow anonymous user to change the password
$anon_user_id = $lDB->get("
	SELECT
		pr_persona.pr_persona_ix
	FROM
		pr_persona
	WHERE
		pr_sys_code = 7
",4);
if($GLOBALS['userid'] == $anon_user_id) {
	header("Location: reservation.php?999");
	die();
}

$rules = $lDB->get("
	SELECT
		rf_auth_https_yn,
		rf_auth_previous_password_yn,
		rf_auth_previous_password_limit,
		rf_auth_minimum_length_yn,
		rf_auth_minimum_length_limit,
		rf_auth_uppercase_yn,
		rf_auth_lowercase_yn,
		rf_auth_numeric_yn,
		rf_auth_special_yn
	FROM
		rf_default
",1);

// Override to master on slave environments
$wasMaster = false;
if($lDB->isMaster == "0") {
	$lDB->isMaster = "1";
	$wasMaster = true;
}

if(isset($_SERVER['CONTENT_TYPE']) && preg_match("/application\/json/",$_SERVER["CONTENT_TYPE"])) {
	$request = json_decode(file_get_contents('php://input'),true);
	if(empty($request)) {
		fail("Invalid request");
	}

	if($request['action'] == "save") {
		if(!empty($rules['rf_auth_https_yn']) && !$GLOBALS['https_enabled']) {
			fail("HTTPS required to set password");
		}

		$password_current = $request['password_current']??"";
		$password_new = $request['password_new']??"";
		$username_new = $request['username_new']??"";

		if(
			empty($password_current)
			|| empty($password_new)
			|| empty($username_new)
			|| $password_current == $password_new
			|| $password_new == $username_new
		) {
			fail("Invalid request data");
		}

		$application = MaglLegacy::getInstance()->getApplication();
		$passwordService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Password');
    $authenticateService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Authenticate');
		$username_current = $lDB->get("
			SELECT
				pr_user_name
			FROM
				pr_user
			WHERE
				pr_user.pr_user_id = '".$lDB->escape($GLOBALS['userid'])."'
		",4);

		// Verify old password
		$passwordService->setupContext($password_current, $GLOBALS['userid']);
		if(!$passwordService->verify()) {
			fail("Current password incorrect");
		}

		// Validate new password
		$passwordService->setupContext($password_new, $GLOBALS['userid']);
		$invalid = $passwordService->invalid();
		if($invalid) {
			fail(join("<br>",$invalid));
		}

		// Check for duplicate username
		$check = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				pr_user
			WHERE
				pr_user.pr_user_id != '".$lDB->escape($GLOBALS['userid'])."'
				AND pr_user.pr_user_name = '".$lDB->escape($username_new)."'
		",4);
		if($check > 0) {
			fail("Username already in use");
		}

		// Attempt to update user details
		if(!db_pr_user_set_password($GLOBALS['userid'], $password_new, $username_new)) {
			fail("Unknown error when updating user details");
		}

		$audit = new AuditTrail($lDB->escape($GLOBALS['userid']),TYPE_PERSONA);
		$audit->save('User password change');
		
		session_set('require_password_change', false);
    	$authenticateService->login($username_new, $password_new);

		succeed();
	}
	fail();
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/logon_password.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],2,"");

$isForced = ($_SERVER['argv'][1] == "1"?true:false);
$GLOBALS['temp']['isForced'] = ($isForced?"1":"0");

$ruleItems = [];
if(!empty($rules['rf_auth_minimum_length_yn'])) {
	$ruleItems[] = "The password must have a minimum length of $rules[rf_auth_minimum_length_limit] characters.";
}
$ruleTypes = [];
if(!empty($rules['rf_auth_uppercase_yn'])) {
	$ruleTypes[] = "upper case letter";
}
if(!empty($rules['rf_auth_lowercase_yn'])) {
	$ruleTypes[] = "lower case letter";
}
if(!empty($rules['rf_auth_numeric_yn'])) {
	$ruleTypes[] = "number";
}
if(!empty($rules['rf_auth_special_yn'])) {
	$ruleTypes[] = "special character";
}
if(!empty($ruleTypes)) {
	$last = array_pop($ruleTypes);
	$item = "The password must contain";

	if(!empty($ruleTypes)) {
		$item .= " " . join(", ",array_map(function($type) {
			return $type . "s";
		},$ruleTypes)) . " and";
	}

	$item .= " at least one $last.";

	$ruleItems[] = $item;
}

if(!empty($rules['rf_auth_previous_password_yn'])) {
	$ruleItems[] = "When changing the password none of the last $rules[rf_auth_previous_password_limit] passwords can be used.";
}

$GLOBALS['temp']['rulesCollapse'] = "collapse";
$GLOBALS['temp']['rules'] = "";
if(!empty($ruleItems)) {
	$GLOBALS['temp']['rulesCollapse'] = "";
	$GLOBALS['temp']['rules'] = join("\n",array_map(function($rule) {
		return "<li>$rule</li>";
	},$ruleItems));
}


$GLOBALS['temp']['requireHttps'] = "0";
if(!empty($rules['rf_auth_https_yn']) && !$GLOBALS['https_enabled']) {
	$GLOBALS['temp']['requireHttps'] = "1";
}

$user = $lDB->get("
	SELECT
		pr_user.pr_user_name,
		pr_user.pr_user_password,
		pr_user.pr_auth_password_type_ind AS user_auth_password_type_ind
	FROM
		pr_user
		INNER JOIN rf_default
	WHERE
		pr_user.pr_user_id = '".$lDB->escape($GLOBALS['userid'])."'
",1);

$title = "Change password and username";
$reason = "Fill in the form below to update your password and optionally your username";
$required = false;

// If user has lower security password than the system default, require a password change
if($_SESSION['require_password_change'] == "invalid") {
	$reason = "The system administrator has changed the password policy and your password no longer complies.";
	$required = true;
}

// If the user has a non-hashed password that matches their username or
// if the user has a hashed password that matches their username, require a password change
if($_SESSION['require_password_change'] == "new") {
	$reason = "Your username and password are the same.";
	$required = true;
}

if($required) {
	$title = "Password change required";
	$reason .= " You must choose a new password.";
}
$GLOBALS['temp']['title'] = $title;
$GLOBALS['temp']['reason'] = $reason;


$defaultHomepages = db_pf_option_get_defaults(db_pf_object_by_name("user_preferences"));
		
$job = "";
if(sizeof($defaultHomepages) > 0) {
	db_pf_field_load_by_name($defaultHomepages[0],'sc_job_id',$job);
}
$GLOBALS['temp']['homeJob'] = $job;

// Set back to slave if required
if($wasMaster) {
	$lDB->isMaster = "0";
}
