<?php
/*
 * $Id: init.form168.php,v 1.9 2011-05-17 14:08:24 light Exp $
 *
 * $Log: init.form168.php,v $
 * Revision 1.9  2011-05-17 14:08:24  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.8  2006-11-23 15:49:25  light
 * Removal of HTTP* globals and code clean up (PHP 5+ fix)
 *
 *
 */

/**
 * init.form168.php - Reservation Summary Email PopUp
 * Job: 535
 * Function: 52 (Reservation: Maintenance)
*/

if (!is_object($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form("form168","",__DIR__ . "/../../../public/html/email_form2.htm");
}

session_register('userid');  # User ID (includes DBCode) to reference user information

// Second argument is the reservation ID
$GLOBALS['temp']['rnum'] = $_SERVER['argv'][1];

$record = $_SERVER['argv'][1];
$noteFlags = $_SERVER['argv'][2];
if ($noteFlags == "") {
	$noteFlags = "100";
}
#$noteFlags[2] = "0";

# Get Contact (user) email address
$temp3 = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$GLOBALS[userid]'",1);
$contactEmail = $temp3[0];

$temp = $GLOBALS['lDB']->get("SELECT rf_principal_id, rf_res_office_id FROM rf_default",1);
$princID = $temp[0];
$resOffID = $temp[1];

$GLOBALS['temp']['princURL'] = "$_SESSION[principal_name_short].resrequest.com";

$temp = $GLOBALS['lDB']->get("SELECT pr_name_last, pr_email FROM pr_persona WHERE pr_persona_ix = '$princID'",1);

$GLOBALS['temp']['princName'] = $temp[0];
$GLOBALS['temp']['princEmail'] = $temp[1];

$temp = $GLOBALS['lDB']->get("
	SELECT
		pr_corr_addr_line1,
		pr_corr_addr_line2,
		pr_corr_addr_line3,
		pr_corr_city,
		pr_corr_post_code,
		pr_corr_country_id
	FROM
		pr_persona
	WHERE
		pr_persona_ix = '$resOffID'
",1);
$GLOBALS['temp']['resOffPost'] = $temp[0];
if ($temp[1] != "") {
	$GLOBALS['temp']['resOffPost'] .= "\n".$temp[1];
}
if ($temp[2] != "") {
	$GLOBALS['temp']['resOffPost'] .= "\n".$temp[2];
}
$GLOBALS['temp']['resOffCity'] = $temp[3];
$GLOBALS['temp']['resOffCode'] = $temp[4];

$temp = $GLOBALS['lDB']->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '$temp[5]'",1);

$GLOBALS['temp']['resOffCountry'] = $temp[0];

$temp = $GLOBALS['lDB']->get("SELECT pr_phone_number FROM pr_phone WHERE pr_default_yn = '1' and pr_persona_id = '$resOffID'",1);

$GLOBALS['temp']['resOffTel'] = $temp[0];
if ($GLOBALS['temp']['resOffTel'] == "0") {
	$GLOBALS['temp']['resOffTel'] = "None";
}

$temp = $GLOBALS['lDB']->get("
	SELECT
		pr_phone.pr_phone_number
	FROM
		pr_phone
		INNER JOIN rf_phone_type ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
	WHERE
		pr_phone.pr_persona_id = '$resOffID'
		AND rf_phone_type.rf_phone_type_sys_code = '1'
",1);

$GLOBALS['temp']['fax'] = $temp[0];

if($_POST['submit1'] != "1") {
	$temp = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_email
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
		WHERE			
			rv_reservation.rv_reservation_ix = '$record'
	",1);

	$GLOBALS['temp']['emailTo'] = $temp[0];
	if(strlen($GLOBALS['temp']['emailTo']) <= 3){$GLOBALS['temp']['emailTo'] = "";}
	$sql = "SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$resOffID'";
	$temp = $GLOBALS['lDB']->get($sql,1);

	$GLOBALS['temp']['emailFrom'] = $contactEmail;

	$sql = "SELECT pr_persona_id FROM rf_sys_admin WHERE rf_sys_admin_primary = 1 LIMIT 1";
	$temp = $GLOBALS['lDB']->get($sql,1);

	$sql = "SELECT pr_name_last, pr_name_first, pr_email FROM pr_persona WHERE pr_persona_ix = '$temp[0]'";
	$temp = $GLOBALS['lDB']->get($sql,1);

	$GLOBALS['temp']['sysAdmin'] = $temp[1]." ".$temp[0];
	$GLOBALS['temp']['sysAdminEmail'] = $temp[2];

	$GLOBALS['temp']['resDetails'] = "";
	$GLOBALS['temp']['resItemDetails'] = "";
	if ($record) {
		# Get reservation item details
		$itemArray = $GLOBALS['lDB']->get ("
			SELECT DISTINCT
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				pr_persona.pr_name_last,
				ac_accomm_type.ac_accomm_desc,
				rv_reservation_item.rv_item_accomm_count,
				(TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive)) AS nights
			FROM
				pr_persona
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				INNER JOIN rv_reservation_item ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
			WHERE
				rv_reservation_item.rv_reservation_id='$record'
		",2);
		$itemRows = sizeof($itemArray);

		# Move res item details to output array

		$resItemDetails = array();
		for ($i = 0; $i < $itemRows; $i++) {
			$resItemDetails[$i]['rv_item_arrive_date'] = $itemArray[$i][0];
			$resItemDetails[$i]['rv_item_date_depart'] = $itemArray[$i][1];
			$resItemDetails[$i]['propertyName'] = $itemArray[$i][2];
			$resItemDetails[$i]['ac_accomm_desc'] = $itemArray[$i][3];
			$resItemDetails[$i]['rv_item_accomm_count'] = $itemArray[$i][4];
			$resItemDetails[$i]['nights'] = $itemArray[$i][5];
		}
	}
	#---------------------------------------------------------------------#
	# Start of Data access code                                           #
	#---------------------------------------------------------------------#

	###############################################################
	# Get reservation header details
	###############################################################
	$resArray = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_db,
			rv_reservation_id,
			rv_res_name,
			rv_provision_expiry_date,
			rv_date_recorded,
			rv_date_changed,
			rv_agent_id,
			rv_corr_persona_id,
			rv_cancel_date,
			rv_confirmation_date,
			rv_invoice_date,
			rv_wait_list_date,
			rv_note_general
		FROM
			rv_reservation
		WHERE
		rv_reservation_ix = '$record'
	",1);
	$resRows  = sizeof($resArray);

	$resStatusDates = array();
	$resStatusDates['rv_provision_expiry_date'] = $resArray[3];
	$resStatusDates['rv_cancel_date'] = $resArray[8];
	$resStatusDates['rv_confirmation_date'] = $resArray[9];
	$resStatusDates['rv_invoice_date'] = $resArray[10];
	$resStatusDates['rv_wait_list_date'] = $resArray[11];
	$resStatus = resStatus($resStatusDates);

	# Move reservation details to output array

	$resDetails = array();
	$resDetails['resNumber'] = $resArray[0].$resArray[1];
	$resDetails['rv_res_name'] = $resArray[2];
	$resDetails['resStatus'] = $resStatus;
	$resDetails['rv_provision_expiry_date'] = $resArray[3];
	$resDetails['rv_date_recorded'] = $resArray[4];
	$resDetails['rv_date_changed'] = $resArray[5];
	$resDetails['rv_note_general'] = $resArray[12];

	###############################################################
	# Get reservation contact details
	###############################################################

	$rv_agent_id = $resArray[6];
	$rv_corr_persona_id = $resArray[7];

	#
	# Check for contact forwarding
	#

	$contactIdArray = array();
	$contactIdArray['pr_persona_fwd_id']  = '99';
	$contactIdArray['rv_corr_persona_id'] = $rv_corr_persona_id;

	while ($contactIdArray['pr_persona_fwd_id'] > '0') {
		$contactIdArray = fwdContact($contactIdArray);
	}

	#
	# Set up contact identity details
	#

	$rv_corr_persona_id = $contactIdArray['rv_corr_persona_id'];

	$directConArray = $GLOBALS['lDB']->get("
		SELECT
			rf_title.rf_title_desc,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			rf_name_suffix.rf_suffix_desc,
			pr_persona.pr_persona_link_id
		FROM
			pr_persona
			LEFT JOIN rf_title ON pr_persona.pr_title_id = rf_title.rf_title_ix
			LEFT JOIN rf_name_suffix ON pr_persona.pr_name_suffix_id = rf_name_suffix.rf_name_suffix_ix
		WHERE
		pr_persona.pr_persona_ix ='$rv_corr_persona_id'
	",1);
	$resRows = sizeof($directConArray);

	# Concatenate first name and last name

	if ($directConArray[3] != null) {
		$directConArray[3] = ", ".$directConArray[3];
	}

	# Move direct contact details to output array
	# Concatenate all name fields

	$resDetails['fullName'] = $directConArray[0]." ".$directConArray[1].$directConArray[2].$directConArray[3];
	$pr_persona_link_id = $directConArray[4];

	#
	# Get phone numbers
	#

	$pr_persona_id = $contactIdArray['rv_corr_persona_id'];
	$phoneArray = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_default_yn,
			rf_phone_type.rf_phone_type_sys_code,
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
		WHERE
			pr_phone.pr_persona_id='$pr_persona_id'
			AND (
				pr_phone.pr_default_yn=1
				OR  rf_phone_type.rf_phone_type_sys_code='1'
			)
	",2);
	$phoneRows = sizeof($phoneArray);

	# Move selected phone data to output array

	for ($i = 0; $i < $phoneRows; $i++){
		$pr_default_yn = $phoneArray[$i][0];
		$rf_phone_type_sys_code = $phoneArray[$i][1];
		$pr_phone_number = $phoneArray[$i][2];
		if ($pr_default_yn) {
			$resDetails['pr_phone_number'] = $pr_phone_number;
		}
		if ($rf_phone_type_sys_code) {
			$resDetails['pr_fax'] = $pr_phone_number;
		}
	}

	#
	# Check for linked address
	#

	$linkIdArray = array();
	$linkIdArray['pr_persona_link_id'] = $persona_link_id;
	$linkIdArray['rv_corr_persona_id'] = $rv_corr_persona_id;

	while ($contactIdArray['pr_persona_link_id'] > '0') {
		$contactIdArray = linkContact($contactIdArray);
	}

	#
	# Get address details
	#

	$prAddressId = $contactIdArray['rv_corr_persona_id'];
	$addressArray = getAddress($prAddressId);

	# Move address details to output array

	$resDetails['pr_corr_addr_line1'] = $addressArray[0];
	$resDetails['pr_corr_addr_line2'] = $addressArray[1];
	$resDetails['pr_corr_addr_line3'] = $addressArray[2];
	$resDetails['pr_corr_city'] = $addressArray[3];
	$resDetails['countryAndCode'] = $addressArray[8];
	$resDetails['pr_email'] = $addressArray[6];

	#
	# Set up agency name
	#

	if ($rv_corr__persona_id <> $rv_agent_id) {
		$agentName = agentName($rv_agent_id);
	} else {
		$agentName = $resDetails['fullName'];
	}
	if(strlen($agentName) <= 2) $agentName="";

	# Move agency name to output array

	$resDetails[linkedAgency] = $agentName;

	#
	# Get reservation item details
	#

	$itemArray = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			pr_persona.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			rv_reservation_item.rv_item_accomm_count,
			(TO_DAYS(rv_reservation_item.rv_item_date_depart) - TO_DAYS(rv_reservation_item.rv_item_date_arrive)) AS nights,
		FROM
			pr_persona
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			INNER JOIN rv_reservation_item ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
		WHERE
			rv_reservation_item.rv_reservation_id='$record'
	",2);
	$itemRows = sizeof($itemArray);

	# Move res item details to output array

	$resItemDetails = array();
	for ($i = 0; $i < $itemRows; $i++){
		$resItemDetails[$i]['rv_item_arrive_date'] = $itemArray[$i][0];
		$resItemDetails[$i]['rv_item_date_depart'] = $itemArray[$i][1];
		$resItemDetails[$i]['propertyName'] = $itemArray[$i][2];
		$resItemDetails[$i]['ac_accomm_desc'] = $itemArray[$i][3];
		$resItemDetails[$i]['rv_item_accomm_count'] = $itemArray[$i][4];
		$resItemDetails[$i]['nights'] = $itemArray[$i][5];
	}

	#
	# Get all notes applicable to the reservation
	#

	# Process property notes

	$propNotesTemp = getPropNotes($record);

	# Move to output array

	$propNotes = array();
	$propNote = "";
	$itemRows = count($propNotesTemp);
	for ($i = 0; $i < $itemRows; $i++){
		$propNotes[$i]['propName'] = $propNotesTemp[$i][0];
		$propNotes[$i]['propNote'] = $propNotesTemp[$i][1];
		$propNote .= $propNotes[$i]['propName'].": ".$propNotes[$i]['propNote']."\n";
	}


	# Process accommodation notes

	$accommNotesTemp = getAccommNotes($record);

	# Move to output array

	$itemRows = count($accommNotesTemp);
	for ($i = 0; $i < $itemRows; $i++){
		$accommNotes[$i]['propName'] = $accommNotesTemp[$i][0];
		$accommNotes[$i]['accommDesc'] = $accommNotesTemp[$i][1];
		$accommNotes[$i]['accommNote'] = $accommNotesTemp[$i][2];
		$propNote .= $accommNotes[$i]['propName']." (".$accommNotes[$i]['accommDesc']."): ".$accommNotes[$i]['accommNote']."\n";
	}

	$bookNote = getBookNote();

	#
	#---------------------------------------------------------------------#
	# End of Data access code                                             #
	#---------------------------------------------------------------------#

	$GLOBALS['temp']['linkedAgency'] = $resDetails['linkedAgency'];
	$GLOBALS['temp']['addrLine1'] = $resDetails['pr_corr_addr_line1'];
	$GLOBALS['temp']['addrLine2'] = $resDetails['pr_corr_addr_line2'];
	$GLOBALS['temp']['addrLine3'] = $resDetails['pr_corr_addr_line3'];
	$GLOBALS['temp']['addrCity'] = $resDetails['pr_corr_city'];
	$GLOBALS['temp']['addrCnC'] = $resDetails['countryAndCode'];

	$GLOBALS['temp']['contactName'] = $resDetails['fullName'];
	$telnum = $GLOBALS['lDB']->get("SELECT pr_phone_number FROM pr_phone WHERE pr_default_yn = '1' AND pr_persona_id = '$rv_corr_persona_id'",1);
	$GLOBALS['temp']['contactTel'] = "None";
	if ($telnum[0] != "0") {
		$GLOBALS['temp']['contactTel'] = $telnum[0];
	}
	$GLOBALS['temp']['resNumber'] = $resDetails['resNumber'];
	$GLOBALS['temp']['resName'] = $resDetails['rv_res_name'];
	$GLOBALS['temp']['resStatus'] = $resDetails['resStatus'];
	if ($resDetails['rv_provision_expiry_date'] != "0000-00-00") {
		$GLOBALS['temp']['resStatus'] .= " (exp: ".chng_date($resDetails['rv_provision_expiry_date'],"-").")";
	}
	$GLOBALS['temp']['resCreated'] = $resDetails['rv_date_recorded'];
	$GLOBALS['temp']['resAmended'] = $resDetails['rv_date_changed'];
	$GLOBALS['temp']['numPhone'] = $resDetails['pr_phone_number'];
	$GLOBALS['temp']['numFax'] = $resDetails['pr_fax'];
	$GLOBALS['temp']['addrEmail'] = $resDetails['pr_email'];

	$html = Join("",File(__DIR__ . "/../../../public/html/reservation_summary_email_row.htm"));
	$GLOBALS['temp']['rowItem'] = "";
	for ($i = 0; $i < sizeof($resItemDetails); $i++) {
		$item['dateArrive'] = chng_date($resItemDetails[$i]['rv_item_arrive_date'],"-");
		$item['dateDepart'] = chng_date($resItemDetails[$i]['rv_item_date_depart'],"-");
		$item['nameProp'] = $resItemDetails[$i]['propertyName'];
		$item['nameAccomm'] = $resItemDetails[$i]['ac_accomm_desc'];
		$item['numUnit'] = $resItemDetails[$i]['rv_item_accomm_count'];
		$item['numNight'] = $resItemDetails[$i]['nights'];

		$GLOBALS['temp']['rowItem'] .= showpage($item,$html);
	}
	$GLOBALS['temp']['noteReservation'] = nl2br($resDetails['rv_note_general']);

	$sql = "SELECT pr_email FROM pr_persona where pr_persona.pr_persona_ix = '$resOffID'";
	$tempe = $GLOBALS['lDB']->get($sql,1);
	$GLOBALS['temp']['resOffEmail'] = "None\n-----------------------------------------\n";
	if ($tempe[0] != "0" && $tempe[0] != "") {
		$GLOBALS['temp']['resOffEmail'] = $tempe[0];
	}

	$GLOBALS['temp']['res_note_clean'] = "";
	$GLOBALS['temp']['prop_note_clean'] = "";
	$GLOBALS['temp']['book_note_clean'] = "";

	if ($noteFlags[0] == "1") {
		$GLOBALS['temp']['res_note_clean'] = "";
		$temp = $GLOBALS['lDB']->get("SELECT rv_note_general FROM rv_reservation WHERE rv_reservation_ix = '$record'",1);
		if ($temp[0] != "") {
			$text = urldecode($temp[0]);
			$GLOBALS['temp']['res_note_clean'] =
"RESERVATION NOTES:
-----------------------------------------
".stripslashes($text)."
-----------------------------------------
";
		}
	}

	if ($noteFlags[1] == "1") {
		$GLOBALS['temp']['prop_note_clean'] = "";
		if ($propNote != "") {
			$GLOBALS['temp']['prop_note_clean'] =
"PROPERTY NOTES:
-----------------------------------------
".stripslashes($propNote)."
-----------------------------------------
";
		}
	}

	if ($noteFlags[2] == "1") {
		$GLOBALS['temp']['book_note_clean'] = "";
		if ($bookNote != "") {
			$GLOBALS['temp']['book_note_clean'] =
"BOOKING NOTES:
-----------------------------------------
".stripslashes(urldecode($bookNote))."
-----------------------------------------
";
			$tmpStr = $GLOBALS['temp']['book_note_clean'];
			$GLOBALS['temp']['book_note_clean'] = strip_tags($tmpStr);
		}
	}
} else {
	# Send the email
	$to = $_POST['mail_to'];
	$from = $_POST['mail_from'];
	$subject = stripslashes($_POST['mail_subj']);
	$message = stripslashes($_POST['mail_body']);

	/* additional headers */
	$headers = "From: ".$GLOBALS['temp']['princName']."<$from>\r\n";

	/* and now mail it */
	email($from, $to, $subject, $headers, $message, 0, 0, $record);     // (from, to, subject, headers, message, action, emailID, resID)
}
