<?php

/**
 * init.form170.php - Report Contact Result
 * Job: 537
 * Function: 53 (Reports: Std, Prov, Contact, Mail, Pay received)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}


if (!isset($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form,"","");
}
global $pr_agent_link;
$myAgnLink = $pr_agent_link;
global $pr_business_link;

# Define system variables
$_SERVER['argv'] = array_pad($_SERVER['argv'],14,"");

$dbFields = array();
$dbOrder = "";
$options = $_SERVER['argv'][6];

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

$pr_name_last = str_replace("*","%",rawurldecode($_SERVER['argv'][1]));
$pr_name_first = str_replace("*","%",rawurldecode($_SERVER['argv'][2]));
$pr_name_user = str_replace("*","%","");

$inactive = "1";
$GLOBALS['temp']['inAct'] = $inactive;
$select = "all";
if ($_SERVER['argv'][3] != "" && $_SERVER['argv'][3] != "all") {
	$select = $_SERVER['argv'][3];
}

$agentLink = "0";
if ($_SERVER['argv'][4] != "" && $_SERVER['argv'][4] != "0" && $pr_agent_link == "0") {
	$pr_agent_link = $_SERVER['argv'][4];
	$agentLink = $_SERVER['argv'][4];
}

$sortBy = "0";
$page = "1";
$printString = "";
$pString = "";
if ($_SERVER['argv'][5] > "1") {
	$page = $_SERVER['argv'][5];
}

$postCountry = $_SERVER['argv'][7];
if($_SERVER['argv'][8] == "none") {
	$postCountryFilter['names'] = 'None';
	$postCountryFilter['where'] = "
		AND (
			pr_persona.pr_corr_country_id IS NULL
			OR pr_persona.pr_corr_country_id = ''
			OR pr_persona.pr_corr_country_id = '0'
		)
	";  
	$GLOBALS['temp']['postCountryIds'] = "<input type=hidden id='postCountryIds' value='none'>";
	$GLOBALS['temp']['postCountryNames'] = "None";
} else {
	$postCountryFilter = useFilter("postCountry",$_SERVER['argv'][8],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_persona.pr_corr_country_id",false,false,false);
}
if($_SERVER['argv'][9] == "none") {
	$physCountryFilter['names'] = 'None';
	$physCountryFilter['where'] = "
		AND (
			pr_persona.pr_phys_country_id IS NULL
			OR pr_persona.pr_phys_country_id = ''
			OR pr_persona.pr_phys_country_id = '0'
		)
	";
	$GLOBALS['temp']['physCountryIds'] = "<input type=hidden id='physCountryIds' value='none'>";
	$GLOBALS['temp']['physCountryNames'] = "None";
} else {
	$physCountryFilter = useFilter("physCountry",$_SERVER['argv'][9],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_persona.pr_phys_country_id",false,false,false);
}
if($postCountry == "1"){
	$physCountryFilter['where'] = "";
}else{
	$postCountryFilter['where'] = "";
}  

$postal = explode(":",$_SERVER['argv'][8]);
$countryList = Join("','",$postal);
$physical = explode(":",$_SERVER['argv'][9]);
$physCountryList = Join("','",$physical);

// BUG #5484 : START ----------------------------------------------------------
// Reports to hide filters by default
$filterStatus = $_SERVER['argv'][10];
$showHideButtonText = $_SERVER['argv'][13];

$GLOBALS['temp']['filterStatus'] = rawurldecode($filterStatus);
$GLOBALS['temp']['showHideButtonText'] = $showHideButtonText;

if($filterStatus == "") {
	$GLOBALS['temp']['filterStatus'] = "";
}

if($showHideButtonText == "") {
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
}

if($_SERVER['argc'] > 1) {
	if($filterStatus == "") {
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";
		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
	}
}
// BUG #5484: END -------------------------------------------------------------

function getContactFax($personaId) {
	$faxNumber = $GLOBALS['lDB']->get("
		SELECT
			pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type_id = 'RS1'
	", 4);
	if (trim($faxNumber) == "" || $faxNumber == "0") {
		return "None";
	} else {
		return $faxNumber;
	}
}

function getContactTelephone($personaId) {
	$telephoneNumber = $GLOBALS['lDB']->get("
		SELECT
			pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '".$personaId."'
			AND pr_default_yn = 1
	",4);
	if (trim($telephoneNumber) == "" || $telephoneNumber == "0") {
		return "None";
	} else {
		return $telephoneNumber;
	}
}

function getContactName($personaId) {
	global $lDB;
	$nameArray = $lDB->get("
		SELECT
			pr_name_first,
			pr_name_second,
			pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$personaId'
	", 1);
	$name = $nameArray['pr_name_last'];
	if (trim($nameArray['pr_name_second']) != "" && $nameArray['pr_name_second'] != "0") {
		$name = $nameArray['pr_name_second'] . " " . $name;
	}
	if (trim($nameArray['pr_name_first']) != "" && $nameArray['pr_name_first'] != "0") {
		$name = $nameArray['pr_name_first'] . " " . $name;
	}
	return $name;
}

$sql = "";
$limit = "";
$getsql = "";
$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

if($renderMode == "pdf" && $renderType == "email") {

} else {
	$GLOBALS['temp']['pgNum'] = (string) $page;

	$GLOBALS['temp']['hideAll'] = "0";
	if ($_SERVER['argv'][1] == "") {
		$GLOBALS['temp']['hideAll'] = "1";
	} else {
		if($renderMode == "html") {
			setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		}
	}

	$pLimit = "10";
	$limit = "16";

	$GLOBALS['temp']['srch_vis'] = "";
	$GLOBALS['temp']['agnName'] = "All";
	$GLOBALS['temp']['agentId'] = "0";
	if (isAgent($GLOBALS['userid'])) {
		$GLOBALS['temp']['srch_vis'] = " style=\"display:none\"";
		$GLOBALS['temp']['agnName'] = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$GLOBALS[userid]'",4);
		$GLOBALS['temp']['agentId'] = $GLOBALS['userid'];
	}
	if ($myAgnLink != "0") {
		$GLOBALS['temp']['srch_vis'] = " style=\"display:none\"";
		$temp = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$myAgnLink'",1);
		$GLOBALS['temp']['agnName'] = $temp[0];
		$GLOBALS['temp']['agentId'] = $myAgnLink;
	}

	if ($agentLink != "0") {
		$temp = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$agentLink'",1);
		$GLOBALS['temp']['agnName'] = $temp[0];
		$GLOBALS['temp']['agentId'] = $agentLink;
	}
	$pdfAgentProp = $GLOBALS['temp']['agnName'];
	$GLOBALS['temp']['check_all'] = " checked";
	$GLOBALS['temp']['check_age'] = "";
	$GLOBALS['temp']['check_use'] = "";
	$GLOBALS['temp']['check_gen'] = "";
	$GLOBALS['temp']['check_gst'] = "";

	# Build up the SQL
	//agent/prop is set to ALL
	$agentLinkSQL = "";
	$more = "";
	if ($agentLink != "0") {
		$agentLinkSQL = "
			AND pr_link.pr_link_to='$pr_agent_link'
		";
	}
	if ($pr_name_first != "%") {
		$more = " AND pr_persona.pr_name_first LIKE \"$pr_name_first\"";
	}

	switch($select) {
	case "all":
		$getsql="
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_persona.pr_persona_inactive_yn,
				pr_user_id,
				pr_user_inactive_yn,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
		";
		$sql="
			FROM
				pr_persona
				LEFT JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				LEFT JOIN pr_user ON pr_user_id = pr_persona.pr_persona_ix
				LEFT JOIN pr_persona as pr_address ON pr_address.pr_persona_ix = pr_persona.pr_persona_link_id
			WHERE
				(pr_persona.pr_name_last LIKE \"$pr_name_last\"$more)
				$agentLinkSQL
		";
		if ($inactive == "1") {
			$sql .= "
				AND pr_persona.pr_persona_inactive_yn = 0
			";
		}
		$GLOBALS['temp']['check_all'] = " checked";
		break;
	case "agent":
		$getsql="
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_agent.pr_agent_inactive_yn,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
		";
		$sql="
			FROM
				pr_persona
				LEFT JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				INNER JOIN pr_agent ON pr_persona.pr_persona_ix  = pr_agent.pr_agent_id
				LEFT JOIN pr_persona as pr_address ON pr_address.pr_persona_ix = pr_persona.pr_persona_link_id
			WHERE
				(pr_persona.pr_name_last LIKE \"$pr_name_last\"$more)
				$agentLinkSQL
		";
		if ($inactive == "1") {
			$sql .= "
				AND pr_agent.pr_agent_inactive_yn=0
			";
		}
		$GLOBALS['temp']['check_all'] = "";
		$GLOBALS['temp']['check_age'] = " checked";
		break;
	case "user":
		if ($pr_name_first != "%") {
			$more = "
				AND pr_persona.pr_name_first LIKE \"$pr_name_first\"
			";
		}
		$getsql="
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_user.pr_user_inactive_yn,
				pr_user_id,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
		";
		$sql="
			FROM
				pr_persona
				LEFT JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				INNER JOIN pr_user ON pr_persona.pr_persona_ix  = pr_user.pr_user_id
				LEFT JOIN pr_persona as pr_address ON pr_address.pr_persona_ix = pr_persona.pr_persona_link_id
			WHERE
				((pr_persona.pr_name_last LIKE \"$pr_name_last\"$more) OR pr_user_name LIKE '$pr_name_user')
				$agentLinkSQL
		";
		if ($inactive == "1") {
			$sql .= "
				AND pr_user.pr_user_inactive_yn=0
			";
		}
		$GLOBALS['temp']['check_all'] = "";
		$GLOBALS['temp']['check_use'] = " checked";
		break;
	case "general":
		if ($pr_name_first != "%") {
			$more = " AND pr_persona.pr_name_first LIKE \"$pr_name_first\"";
		}
		$getsql="
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_persona.pr_persona_inactive_yn,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
		";
		$sql="
			FROM
				pr_persona
				LEFT JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				LEFT JOIN pr_agent ON pr_persona.pr_persona_ix  = pr_agent.pr_agent_id
				LEFT JOIN pr_user ON pr_persona.pr_persona_ix  = pr_user.pr_user_id
				LEFT JOIN pr_guest ON pr_persona.pr_persona_ix  = pr_guest.pr_guest_id
				LEFT JOIN pr_persona as pr_address ON pr_address.pr_persona_ix = pr_persona.pr_persona_link_id
			WHERE
				(pr_persona.pr_name_last LIKE \"$pr_name_last\"$more)
				$agentLinkSQL
				AND pr_agent.pr_agent_id Is Null
				AND pr_user.pr_user_id Is Null
				AND pr_guest.pr_guest_id Is Null
		";
		if ($inactive == "1") {
			$sql .= "
				AND pr_persona.pr_persona_inactive_yn = 0
			";
		}
		$GLOBALS['temp']['check_all'] = "";
		$GLOBALS['temp']['check_gen'] = " checked";
		break;
	case "guest":
		if ($pr_name_first != "%") {
			$more = "
				AND pr_persona.pr_name_first LIKE \"$pr_name_first\"
			";
		}
		$agentFilter['where'] = isset($agentFilter['where']) ? $agentFilter['where'] : "";
		$getsql="
			SELECT DISTINCT
				pr_persona.pr_persona_ix,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_guest.pr_guest_inactive_yn,
				pr_guest_id,
				pr_persona.pr_statutory_1,
				pr_persona.pr_statutory_2,
				pr_persona.pr_statutory_3
		";
		$sql="
			FROM
				pr_persona
				LEFT JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_from
				INNER JOIN pr_guest ON pr_persona.pr_persona_ix = pr_guest.pr_guest_id
				LEFT JOIN pr_persona as pr_address ON pr_address.pr_persona_ix = pr_persona.pr_persona_link_id
			WHERE
				(pr_persona.pr_name_last LIKE \"$pr_name_last\" $more )
				$agentLinkSQL
				$agentFilter[where]
		";
		if ($inactive == "1") {
			$sql .= " AND pr_guest.pr_guest_inactive_yn = 0";
		}
		$GLOBALS['temp']['check_all'] = "";
		$GLOBALS['temp']['check_gst'] = " checked";
		break;
	}
}


$GLOBALS['temp']['advancedClass'] = "collapse printCollapse";
$GLOBALS['temp']['advVal'] = ">> More";

$advStatus = rawurldecode($_SERVER['argv'][11]);
if($advStatus == "expand"){
	$GLOBALS['temp']['advancedClass'] = "expand";
	$GLOBALS['temp']['advVal'] = "<< More";
}

$sql .= "
	AND pr_persona.pr_sys_code = '0'
";

if ($postCountry == "1" && $advStatus == "expand" && $countryList != "") {
	if($countryList == "0"){
		$countryList .= "','";
	}
	$GLOBALS['temp']['check_post'] = " checked";
	$GLOBALS['temp']['advancedClass'] = "expand";
}
if ($postCountry == "0" && $advStatus == "expand" && $physCountryList != "") {
	$GLOBALS['temp']['check_phys'] = " checked";
	$GLOBALS['temp']['advancedClass'] = "expand";
}

$sql .= "
	$postCountryFilter[where] $physCountryFilter[where]
";

# Continue setting limits
$listsql = "SELECT DISTINCT COUNT(*) ".$sql;
$count = $lDB->get($listsql,1);
$total = $count[0];
if ($pr_agent_link != "0") {
	$total++;
}

$realCount = isset($realCount) ? $realCount : "";
$pLimit = isset($pLimit) ? $pLimit : 0;

if(isset($limit) && $limit != 0){
	$realCount = (string) $total / $limit;
}
$erg = explode(".",$realCount);
$pCount = (int) $realCount;
if (isset($erg[1]) && $erg[1] != "") {
	$pCount += "1";
}
if ($pLimit > $pCount) {
	$pLimit = $pCount;
}

$pStart = $page - (int) ($pLimit/2);
--$page;
if ($pStart < "1") {
	$pStart = "1";
}
if ($pStart > $pCount) {
	$pStart = $pCount;
}
$pEnd = $pStart+$pLimit;
if ($pEnd > $pCount) {
	$pEnd = $pCount+1;
}
if ($page > $pEnd) {
	$page = $pEnd-1;
}
$start = $page * $limit;
if ($pr_agent_link != "0") {
	if ($page < "1") {
		$limit--;
	} else {
		$start--;
		#$limit++;
	}
}

# Continue building the SQL
$dbLimit = "";
$dbOrder = "ORDER BY ";
switch ($sortBy) {
case 0:
	$dbOrder .= "pr_name_last, pr_name_first";
	break;
case 1:
	$dbOrder .= "pr_persona.pr_name_last desc";
	break;
case 2:
	$dbOrder .= "pr_persona.pr_name_first";
	break;
case 3:
	$dbOrder .= "pr_persona.pr_name_first desc";
	break;
}
if($renderMode != "pdf" && $renderMode != "csv") {
	$dbLimit = "LIMIT ".$start.", ".$limit;
}

# Generate the page breaks
$printString .= "<a class=txt> of ".$pCount." page(s)</a>";
$pString .= "<a class=txtbr>Pages:</a> ";
if ($pStart > "1") {
	$pString .= "<a href=\"javascript:ShowFrom(1);\" class=txtbr>First</a>, ";
}
for($i=$pStart;$i<$pEnd;$i++) {
	if ($i != $pStart) {
		$pString .= ", ";
	}
	$pString .= "<a class=txtbr";
	if ($i != $page+1) {
		$pString .= " href=\"javascript:ShowFrom($i);\"";
	}
	$pString .= ">".$i."</a>";
}
if ($pEnd < $pCount) {
	$pString .= "<a class=txtbr>...</a> <a href=\"javascript:ShowFrom(".$pCount.");\" class=txtbr>Last</a>";
}
$pString .= "<a class=txtbr> of ".$pCount." page(s)</a>";

$GLOBALS['temp']['hideNext'] = "";
$GLOBALS['temp']['hidePrev'] = "";
$pNext = $page+2;
$pPrev = $page;
$GLOBALS['temp']['pNext'] = (string) $pNext;
$GLOBALS['temp']['pPrev'] = (string) $pPrev;
if ($page+2 > $pCount) {
	$GLOBALS['temp']['hideNext'] = " style=\"visibility:hidden;\"";
}
if ($page < "1") {
	$GLOBALS['temp']['hidePrev'] = " style=\"visibility:hidden;\"";
}

$getsql .= $sql." ".$dbOrder." ".$dbLimit;

$resultSet = $lDB->get($getsql,2);

//data prep
if ($pr_agent_link != "0" && $advStatus != "expand") {
	$sql="
		SELECT DISTINCT
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last,
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$pr_agent_link'
	";
	$result = $lDB->get($sql,1);
	$contact['pr_persona_ix'] = $result['pr_persona_ix'];
	$contact['id'] = $result['pr_persona_ix'];
	$contact['pr_name_first'] = $result['pr_name_first'];
	$contact['pr_name_last'] = $result['pr_name_last'];
	if (isset($item['pr_name_first']) && $item['pr_name_first'] != "" && isset($item['pr_name_last']) && $item['pr_name_last'] != "") {
		$item['pr_name_last'].= ", ";
	}
	$contact['inactive'] = "0";
	$contact['color'] = "";
	$contact['ital1'] = "";
	$contact['ital2'] = "";
	$contact['user'] = "";
	$contact['agent'] = "";
	$contact['relationship'] = "";
	$contact['pr_statutory_1'] = $result['pr_statutory_1'];
	$contact['pr_statutory_2'] = $result['pr_statutory_2'];
	$contact['pr_statutory_3'] = $result['pr_statutory_3'];

	$contact['hideAccess'] = "";
	$contact['accessgroup'] = $lDB->get("
		SELECT
			sc_grp_desc
		FROM
			sc_user
			INNER JOIN sc_group on sc_group.sc_group_id = sc_user.sc_group_id
		WHERE
			sc_user.pr_user_id = '$contact[id]'
	",4);
	if ($contact['accessgroup'] == "0" || $contact['accessgroup'] == "") {
		$contact['hideAccess'] = " style=\"display:none\"";
	}

	$contact['relationship'] = "None";
	$temp = $lDB->get("SELECT pr_link_to FROM pr_link WHERE pr_link_from = '$contact[id]' ORDER BY rf_link_type_id ASC LIMIT 1",1);
	$relationship_id = $temp[0];
	if ($relationship_id != "0") {
		$temp = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$relationship_id'",1);
		if ($temp[0] != "") {
			$contact['relationship'] = $temp[0];
		}
	}

	$tempa = $lDB->get("SELECT pr_email, pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$contact[id]'",1);
	$contact['email'] = "None";
	$contact['web'] = "None";
	if ($tempa[0] != "") {
		$contact['email'] = $tempa[0]." <img src=\"/resource/Resrequest/Application/public/img/email_std.gif\" class=\"imgLink printCollapse\" onclick=\"openPopup('email_form.php?email_address=".$tempa[0]."',578,342);\">";
		$contact['emailAddr'] = $tempa[0];
	}
	if ($tempa[1] != "") {
		$contact['web'] = $tempa[1]." <img src=\"/resource/Resrequest/Application/public/img/internet.gif\" class=\"imgLink printCollapse\" onclick=\"webClick('".$tempa[1]."');\">";
		$contact['webText'] = $tempa[1];
	}

	$addrLink = linkContact(array("rv_corr_persona_id" => "$contact[id]"));
	$address = getAddress($addrLink['rv_corr_persona_id']);
	$address = array_pad($address,10,"");
	$post = nl2br($address[9]);
	$city = $address[3]."<br>";
	$cnc = $address[8]."<br>";
	$contact['postal'] = $post.$city.$cnc;
	$contact['postalText'] = $address[9].$address[3]."\n".$address[8]."\n";

	$contact['role'] = "";
	$show_inactive = isset($show_inactive) ? $show_inactive : "";
	$sql = "SELECT COUNT(*) FROM pr_agent WHERE pr_agent_id = '$contact[id]'";
	if ($show_inactive != "1") { $sql .= " AND pr_agent_inactive_yn = '0'"; }
	$temp = $lDB->get($sql,1);
	if ($temp[0] == "1") {
		$contact['role'] = "Agent";
	}

	$sql = "SELECT COUNT(*) FROM pr_user WHERE pr_user_id = '$contact[id]'";
	if ($show_inactive != "1") { $sql .= " AND pr_user_inactive_yn = '0'"; }
	$temp = $lDB->get($sql,1);
	if ($temp[0] == "1") {
		if ($contact['role'] != "") {
			$contact['role'] .= ", ";
		}
		$contact['role'] .= "User";
	}

	$sql = "SELECT COUNT(*) FROM pr_guest WHERE pr_guest_id = '$contact[id]'";
	if ($show_inactive != "1") { $sql .= " and pr_guest_inactive_yn = '0'"; }
	$temp = $lDB->get($sql,1);
	if ($temp[0] == "1") {
		if ($contact['role'] != "") {
			$contact['role'] .= ", ";
		}
		$contact['role'] .= "Guest";
	}
	if ($contact['role'] == "") {
		$contact['role'] = "General";
	}

	$temp = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$addrLink[rv_corr_persona_id]' and pr_default_yn = '1'",1);
	$contact['tel'] = "None";
	if ($temp[0] != "" && $temp[0] != "0") {
		$contact['tel'] = $temp[0];
	}
	array_unshift($resultSet,$contact);
}

if($renderType != "email"){
	foreach($resultSet as $key=>$item){
		$relationship_id = $lDB->get("select pr_link_to from pr_link where pr_link_from = '$item[pr_persona_ix]' order by rf_link_type_id asc LIMIT 1",4);
		if ($relationship_id != "0") {
			$resultSet[$key]['relationship'] = $lDB->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix = '$relationship_id'",4);
		}
		if(!isset($resultSet[$key]['relationship']) || $resultSet[$key]['relationship'] == "") {
			$resultSet[$key]['relationship'] = "None";
		}

		$resultSet[$key]['rateTypes'] = $lDB->get("
			SELECT DISTINCT
				rt_rate_type.rt_rate_type_desc as rate,
				rf_currency.rf_currency_symbol as rateCurr
			FROM
				pr_agent_rate
				INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_rate.rt_rate_type_id
				INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
			WHERE
				pr_agent_rate.pr_agent_id = '$item[pr_persona_ix]'
		",2);

		$resultSet[$key]['emailWeb'] = $lDB->get("SELECT pr_persona.pr_email as email, pr_persona.pr_web_addr as web FROM pr_persona WHERE pr_persona_ix = '$item[pr_persona_ix]'",1);

		$linkAddId = $lDB->get("SELECT pr_persona.pr_persona_link_id FROM pr_persona WHERE pr_persona.pr_persona_ix = '$item[pr_persona_ix]'",4);
		if($linkAddId == "" || $linkAddId == "0") {
			$linkId = $item['pr_persona_ix'];
		} else {
			$linkId = $linkAddId;
		}
		$resultSet[$key]['physCountry'] = $lDB->get("SELECT rf_country.rf_country_name FROM rf_country INNER JOIN pr_persona ON pr_persona.pr_phys_country_id = rf_country.rf_country_ix WHERE pr_persona.pr_persona_ix = '$linkId'",4);
		$resultSet[$key]['address'] = getAddress($linkId);
		$resultSet[$key]['physaddress'] = getPhysAddress($linkId);

		$resultSet[$key]['address'] = array_pad($resultSet[$key]['address'],10,"");
		$resultSet[$key]['physaddress'] = array_pad($resultSet[$key]['physaddress'],10,"");
    
		$roleCount = $lDB->get("SELECT count(*) FROM pr_agent WHERE pr_agent_id = '$item[pr_persona_ix]'",4);
		if($roleCount > 0) {
			$resultSet[$key]['agentRole'] = true;
		} else {
			$resultSet[$key]['agentRole'] = false;
		}
		$roleCount = $lDB->get("SELECT count(*) FROM pr_user WHERE pr_user_id = '$item[pr_persona_ix]'",4);
		if($roleCount > 0) {
			$resultSet[$key]['userRole'] = true;
		} else {
			$resultSet[$key]['userRole'] = false;
		}
		$roleCount = $lDB->get("SELECT count(*) FROM pr_guest WHERE pr_guest_id = '$item[pr_persona_ix]'",4);
		if($roleCount > 0) {
			$resultSet[$key]['guestRole'] = true;
		} else {
			$resultSet[$key]['guestRole'] = false;
		}

		$resultSet[$key]['tel'] = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$item[pr_persona_ix]' and pr_default_yn = '1'",4);
		$resultSet[$key]['commission'] = $lDB->get("SELECT pr_agent.pr_agent_commission_perc FROM pr_agent WHERE pr_agent.pr_agent_id = '$item[pr_persona_ix]'",4);
		$resultSet[$key]['payplan'] = $lDB->get("SELECT ac_pay_plan.ac_pay_plan_desc FROM pr_agent LEFT JOIN ac_pay_plan ON ac_pay_plan.ac_pay_plan_ix = pr_agent.ac_pay_plan_id WHERE pr_agent.pr_agent_id = '$item[pr_persona_ix]'",4);
		$resultSet[$key]['agentNotes'] = $lDB->get("SELECT pr_agent.pr_agent_note_open FROM pr_agent WHERE pr_agent.pr_agent_id = '$item[pr_persona_ix]'",4);

		$resultSet[$key]['rf_statutory_label_1'] = $default_statutory_labels['rf_statutory_label_1'];
		$resultSet[$key]['rf_statutory_label_2'] = $default_statutory_labels['rf_statutory_label_2'];
		$resultSet[$key]['rf_statutory_label_3'] = $default_statutory_labels['rf_statutory_label_3'];

	}
}

$accessJob = "47"; // view job
if (checkJob("45")) {
	$accessJob = "45";
}

if($renderMode == "html") {
	$GLOBALS['temp']['rows'] = "";
	foreach($resultSet as $item) {
		if ($item['pr_name_first'] != "" && $item['pr_name_last'] != "") {
			$item['pr_name_last'].= ", ";
		}
		$item['inactive'] = "0";
		$item['user'] = "";
		$item['agent'] = "";
		$item['hideAccess'] = "";
		$item['accessgroup'] = $lDB->get("
			SELECT
				sc_grp_desc
			FROM
				sc_user
				INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
			WHERE
				sc_user.pr_user_id = '$item[pr_persona_ix]'
		",4);
		if ($item['accessgroup'] == "0" || $item['accessgroup'] == "") {
			$item['hideAccess'] = " style=\"display:none\"";
		}

		foreach($item['rateTypes'] as $rate) {
			if (isset($item['agentRates'])) {
				$item['agentRates'] .= $rate['rate']." (".$rate['rateCurr']."), ";
			} else {
				$item['agentRates'] = $rate['rate']." (".$rate['rateCurr']."), ";
			}
		}
		if(!isset($item['agentRates']) || $item['agentRates'] == "" || $item['agentRates'] == "0") {
			$item['agentRates'] = "None";
		}
		$item['email'] = $item['emailWeb'][0]." <img src=\"/resource/Resrequest/Application/public/img/email_std.gif\" class=\"imgLink printCollapse\" onclick=\"openPopup('email_form.php?email_address=".$item['emailWeb'][0]."',578,342);\">";
		$item['web'] = $item['emailWeb'][1]." <img src=\"/resource/Resrequest/Application/public/img/internet.gif\" class=\"imgLink printCollapse\" onclick=\"webClick('".$item['emailWeb'][1]."');\">";
		if (trim($item['emailWeb'][0]) == "") {
			$item['email'] = "None";
		}
		if (trim($item['emailWeb'][1]) == "") {
			$item['web'] = "None";
		}

		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		$post = nl2br($item['address'][9]);
		$city = $item['address'][3]."<br>";
		$cnc = $item['address'][8]."<br>";
		$item['postal'] = $post.$city.$cnc;
		if($item['address'][0] == "" && $item['address'][1] == "" && $item['address'][2] == "" && $item['address'][3] == "" && $item['address'][4] == ""){
			$item['postal'] = "None";
		}
    	
		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		//$address = getAddress($linkId);
		$ppost = nl2br($item['physaddress'][9]);
		$pcity = $item['physaddress'][3]."<br>";
		$pcnc = $item['physaddress'][8]."<br>";
		$item['physical'] = $ppost.$pcity.$pcnc;
		if($item['physaddress'][0] == "" && $item['physaddress'][1] == "" && $item['physaddress'][2] == "" && $item['physaddress'][3] == "" && $item['physaddress'][4] == "") {
			$item['physical'] = "None";
		}    
    
		if ($item['physCountry'] == "" || $item['physCountry'] == "0") {
			$item['physCountry'] = "None";
		}
      
		$item['role'] = "";
		$item['showAgent'] = " style=\" display:none;\"";
		if ($item['agentRole'] == true) {
			$item['role'] = "Agent";
			$item['showAgent'] = " style=\" display:visible;\"";
		}
		if ($item['userRole'] == true) {
			if ($item['role'] != "") {
				$item['role'] .= ", ";
			}
			$item['role'] .= "User";
		}
		if ($item['guestRole'] == true) {
			if ($item['role'] != "") {
            	$item['role'] .= ", ";
			}
			$item['role'] .= "Guest";
		}
		if ($item['role'] == "") {
			$item['role'] = "General";
		}
		if ($item['tel'] == "" || $item['tel'] == "0") {
			$item['tel'] = "None";
		}

		if ($item['commission'] == "" || $item['commission'] == "0") {
			$item['commission'] = "None";
		} else {
			$item['commission'] .= " %";
		}

		if ($item['payplan'] == "" || $item['payplan'] == "0") {
			$item['payplan'] = "None";
		}

		if ($item['agentNotes'] == "" || $item['agentNotes'] == "0") {
			$item['agentNotes'] = "None";
		}

		$item['showStatutory1'] = $item['pr_statutory_1'] == "" ? " class=\"collapse\"" : "";
		$item['showStatutory2'] = $item['pr_statutory_2'] == "" ? " class=\"collapse\"" : "";
		$item['showStatutory3'] = $item['pr_statutory_3'] == "" ? " class=\"collapse\"" : "";
		
		$item['jobId'] = $accessJob;

		$temphtml = Join("\n",File(__DIR__ . "/../../../public/html/report_contact_rows.htm"));

		// Temporarily remove sub-arrays, otherwise it'll break showpage()
		if (is_array($item['rateTypes'])) {
			$tempSubs['rateTypes'] = $item['rateTypes'];
			$item['rateTypes'] = "";
		}
		if (is_array($item['emailWeb'])) {
			$tempSubs['emailWeb'] = $item['emailWeb'];
			$item['emailWeb'] = "";
		}
		if (is_array($item['address'])) {
			$tempSubs['address'] = $item['address'];
			$item['address'] = "";
		}
		if (is_array($item['physaddress'])) {
			$tempSubs['physaddress'] = $item['physaddress'];
			$item['physaddress'] = "";
		}
		// End of temporary removal of sub-arrays

		$out = showpage($item,$temphtml);
		$GLOBALS['temp']['rows'] .= $out;

		// Reinstate temporary sub-arrays
		if (isset($tempSubs['rateTypes']) && is_array($tempSubs['rateTypes'])) {
			$item['rateTypes'] = $tempSubs['rateTypes'];
		}

		if (isset($tempSubs['emailWeb']) && is_array($tempSubs['emailWeb'])) {
			$item['emailWeb'] = $tempSubs['emailWeb'];
		}

		if (isset($tempSubs['address']) && is_array($tempSubs['address'])) {
			$item['address'] = $tempSubs['address'];
		}

		if (isset($tempSubs['physaddress']) && is_array($tempSubs['physaddress'])) {
			$item['physaddress'] = $tempSubs['physaddress'];
		}
		if (isset($tempSubs)) { unset($tempSubs); }
		// End of reinstatement of temporary sub-arrays

		if ($_SERVER['argv'][5] == "1") {
			$GLOBALS['temp']['submitval'] = "1";
		} else {
			$GLOBALS['temp']['submitval'] = "0";
		}
		$GLOBALS['temp']['ofnum'] = $printString;
		$GLOBALS['temp']['nextprev'] = $pString;
		$GLOBALS['temp']['limited'] = (string) $total;
		$GLOBALS['temp']['sortby'] = $sortBy;
	}
	$srch = rawurldecode($_SERVER['argv'][1]);
	if ($srch == "" || $srch == "*") { $srch = rawurldecode($_SERVER['argv'][2]); }
	if ($srch == "" || $srch == "*") { $srch = rawurldecode($_SERVER['argv'][3]); }
	$noresult = "<div>&nbsp;&nbsp;Your search - <span class=\"txtbbr\">".$srch."</span> - did not match any records.<br><br>&nbsp;&nbsp;<b>Suggestions:</b><br>&nbsp;&nbsp;- Use wildcards to assist in your search<br>&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)<br>&nbsp;&nbsp;- Use a different keyword.</div>";
	$defout = "<table width=\"770\"><tr><td class=\"bAll\">$noresult</td></tr>";

	$GLOBALS['temp']['hideRec'] = "expand";
	if ($GLOBALS['temp']['rows'] == "") {
		$GLOBALS['temp']['rows'] = $defout;
		$GLOBALS['temp']['hideRec'] = "collapse printCollapse";
	}
}
//End of html
if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
	$pdf = new PDF("Contact Report");

	$pr_name_last = str_replace("%","*",rawurldecode($_SERVER['argv'][1]));
	$pr_name_first = str_replace("%","*",rawurldecode($_SERVER['argv'][2]));
	if(!isset($server) || $server == 0) {
		$server = "All";
	}
	$agentLink = $_SERVER['argv'][3];
	// Main PDF header
	if($postCountry == "1"){
		$countryHead = "Postal";
	} else {
		$countryHead = "Physical";
	}
	$pdf->ReportHeader("Contact Report",array(
		array('name'=>"Last Name",'value'=>$pr_name_last),
		array('name'=>"First Name",'value'=>$pr_name_first),
		array('name'=>"Agent/Property",'value'=>$pdfAgentProp),
		array('name'=>"Contact Type",'value'=>$agentLink),
		array('name'=>"Country",'value'=>$countryHead)
	));

	foreach($resultSet as $item) {
		if ($item['pr_name_first'] != "" && $item['pr_name_last'] != "") {
			$item['pr_name_last'].= ", ";
		}
		if(!isset($item['agentRates']) || $item['agentRates'] == "" || $item['agentRates'] == "0") {
			$item['agentRates'] = "None";
		}
		foreach($item['rateTypes'] as $rate) {
			$item['agentRates'] .= $rate['rate']." (".$rate['rateCurr']."), ";
		}

		$item['email'] = $item['emailWeb'][0];
		$item['web'] = $item['emailWeb'][1];
		if (trim($item['emailWeb'][0]) == "") {
			$item['email'] = "None";
		}
		if (trim($item['emailWeb'][1]) == "") {
			$item['web'] = "None";
		}

		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		$address = getAddress($addrLink['rv_corr_persona_id']);
		$address = array_pad($address,10,"");
		$post = $address[9];
		$city = $address[3];
		$cnc = $address[8];
		$item['postal'] = $post.$city.$cnc;
		if($address[0] == "" && $address[1] == "" && $address[2] == "" && $address[3] == "" && $address[4] == ""){
			$item['postal'] = "None";
		}
    
		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		$physaddress = getPhysAddress($addrLink['rv_corr_persona_id']);
		$physaddress = array_pad($physaddress,10,"");
		$ppost = $physaddress[9];
		$pcity = $physaddress[3];
		$pcnc = $physaddress[8];
		$item['physical'] = $ppost.$pcity.$pcnc;
		if($physaddress[0] == "" && $physaddress[1] == "" && $physaddress[2] == "" && $physaddress[3] == "" && $physaddress[4] == ""){
			$item['physical'] = "None";
		}    
    
		if ($item['physCountry'] == "" || $item['physCountry'] == "0") {
			$item['physCountry'] = "None";
		}
		$item['role'] = "";
		$item['showAgent'] = " style=\" display:none;\"";
		if ($item['agentRole'] == true) {
			$item['role'] = "Agent";
			$item['showAgent'] = " style=\" display:visible;\"";
		}
		if ($item['userRole'] == true) {
			if ($item['role'] != "") {
				$item['role'] .= ", ";
			}
			$item['role'] .= "User";
		}
		if ($item['guestRole'] == true) {
			if ($item['role'] != "") {
				$item['role'] .= ", ";
			}
			$item['role'] .= "Guest";
		}
		if ($item['role'] == "") {
			$item['role'] = "General";
		}
		if ($item['tel'] == "" || $item['tel'] == "0") {
			$item['tel'] = "None";
		}
		$item['accessgroup'] = $lDB->get("
			SELECT
				sc_grp_desc
			FROM
				sc_user
				INNER JOIN sc_group on sc_group.sc_group_id = sc_user.sc_group_id
			WHERE
				sc_user.pr_user_id = '$item[pr_persona_ix]'
		",4);
		if ($item['commission'] == "" || $item['commission'] == "0") {
			$item['commission'] = "None";
		} else {
			$item['commission'] .= " %";
		}
		if ($item['payplan'] == "" || $item['payplan'] == "0") {
			$item['payplan'] = "None";
		}
		if ($item['agentNotes'] == "" || $item['agentNotes'] == "0") {
			$item['agentNotes'] = "None";
		}
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Contact Name:", 'border'=>"LTBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['pr_name_first']." ".$item['pr_name_last'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Linked to:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['relationship'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Role:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['role'])
		));
		if ($item['accessgroup'] != "0" && $item['accessgroup'] != "") {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>"Access Group:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['accessgroup'])
			));
		}
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Telephone:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['tel'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"E-mail:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['email'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Web address:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['web'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Postal:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['postal'])
		));
		$pdf->Row(array(
			array('width'=>"15%", 'data'=>"Physical Address:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
			array('width'=>"85%", 'data'=>$item['physical'])
		));
		if ($item['agentRole'] == true) {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>"Commission:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['commission'])
			));
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>"Payment Plan:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['payplan'])
			));
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>"Rates:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['agentRates'])
			));
		}

		if ($item['pr_statutory_1'] != "") {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>$item['rf_statutory_label_1'].":", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['pr_statutory_1'])
			));
		}

		if ($item['pr_statutory_2'] != "") {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>$item['rf_statutory_label_2'].":", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['pr_statutory_2'])
			));
		}

		if ($item['pr_statutory_3'] != "") {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>$item['rf_statutory_label_3'].":", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['pr_statutory_3'])
			));
		}

		if ($item['agentRole'] == true) {
			$pdf->Row(array(
				array('width'=>"15%", 'data'=>"Notes:", 'border'=>"LBR", 'fill'=>1, 'align'=>"R",'style'=>"B"),
				array('width'=>"85%", 'data'=>$item['agentNotes'])
			));
		}

		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"")
		));
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"", 'border'=>"B")
		));
		$pdf->Row(array(
			array('width'=>"100%", 'data'=>"")
		));
	}// end of for loop

	//go at end
	if($renderType == "save") {
		$pdf->OutPut('./PDF/current/contact.pdf');
		echo "PDF created";
	} elseif ($renderType == "view") {
		$pdf->OutPut();
		die();
	} elseif ($renderType == "send") {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";

		// close the pdf
		if($pdf->state<3) $pdf->Close();

		/* and now mail it */
		//echo "ATTACHMENTNAME: $attachmentName<BR>";
		if($attachmentName != "!attachmentName!") {
			$pdfName = $attachmentName;
		} else {
			$pdfName = "Contact report.pdf";
		}

		//echo "NAME: $pdfName<BR>";
		$error = email($from, $to, $subject, $headers, $message, 0, 0, $_SERVER['argv'][1], $GLOBALS['princName'],$pdf->buffer,$pdfName);
		if(!$error) {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
		}
		die();
	}
}

if($renderMode == "csv") {
	$countryHead = "None";
	if($postCountry == "1" && $advStatus == "expand") {
		$countryHead = "Postal";
	} elseif ($postCountry == "0" && $advStatus == "expand") {
		$countryHead = "Physical";
	}
	$csvFile = array();
	array_push($csvFile,array("Contact Report"));
	array_push($csvFile,array());
	array_push($csvFile,array("Last Name",$_SERVER['argv'][1]));
	array_push($csvFile,array("First Name",$_SERVER['argv'][2]));
	array_push($csvFile,array("Agent/Property",$pdfAgentProp));
	array_push($csvFile,array("Contact Type",$_SERVER['argv'][3]));
	array_push($csvFile,array("Country",$countryHead));
	array_push($csvFile,array());
	array_push($csvFile,array("Last Name","First Name","Linked to","Role","Access Group","Telephone","Email","Web address","Postal Address","Postal Country","Physical Address","Physical Country","Commission","Payment Plan","Rates",$default_statutory_labels['rf_statutory_label_1'],$default_statutory_labels['rf_statutory_label_2'],$default_statutory_labels['rf_statutory_label_3'],"Notes"));

	foreach($resultSet as $item) {
		foreach($item['rateTypes'] as $rate) {
			if (isset($item['agentRates'])) {
				$item['agentRates'] .= $rate['rate']." (".$rate['rateCurr']."),\n ";
			} else {
				$item['agentRates'] = $rate['rate']." (".$rate['rateCurr']."),\n ";
			}
		}
		if(!isset($item['agentRates']) || $item['agentRates'] == "" || $item['agentRates'] == "0") {
			$item['agentRates'] = "None";
		}

		$item['email'] = $item['emailWeb'][0];
		$item['web'] = $item['emailWeb'][1];
		if (trim($item['emailWeb'][0]) == "") {
			$item['email'] = "None";
		}
		if (trim($item['emailWeb'][1]) == "") {
			$item['web'] = "None";
		}

		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		$address = getAddress($addrLink['rv_corr_persona_id']);
		$address = array_pad($address,10,"");
		$post = $address[9];
		$city = $address[3];
		$cnc = $address[8];
		$item['postal'] = $post.$city;
		$item['postCount'] = $cnc;
      
		$addrLink = linkContact(array("rv_corr_persona_id" => "$item[pr_persona_ix]"));
		$physaddress = getPhysAddress($addrLink['rv_corr_persona_id']);
		$physaddress = array_pad($physaddress,10,"");
		$ppost = $physaddress[9];
		$pcity = $physaddress[3];
		$pcnc = $physaddress[8];
		$item['physical'] = $ppost.$pcity;
		$item['physCount'] = $pcnc;
		if($physaddress[0] == "" && $physaddress[1] == "" && $physaddress[2] == "" && $physaddress[3] == "" && $physaddress[4] == ""){
			$item['physical'] = "None";
    	} 
      
		if ($item['physCountry'] == "" || $item['physCountry'] == "0") {
			$item['physCountry'] = "None";
		}
		$item['role'] = "";
		$item['showAgent'] = " style=\" display:none;\"";
		if ($item['agentRole'] == true) {
			$item['role'] = "Agent";
			$item['showAgent'] = " style=\" display:visible;\"";
		}
		if ($item['userRole'] == true) {
			if ($item['role'] != "") {
				$item['role'] .= ", ";
			}
			$item['role'] .= "User";
		}
		if ($item['guestRole'] == true) {
			if ($item['role'] != "") {
				$item['role'] .= ", ";
			}
			$item['role'] .= "Guest";
		}
		if ($item['role'] == "") {
			$item['role'] = "General";
		}
		if ($item['tel'] == "" || $item['tel'] == "0") {
			$item['tel'] = "None";
		}
		if ($item['commission'] == "" || $item['commission'] == "0") {
			$item['commission'] = "None";
		} else {
			$item['commission'] .= " %";
		}
		if ($item['payplan'] == "" || $item['payplan'] == "0") {
			$item['payplan'] = "None";
		}
		if ($item['agentNotes'] == "" || $item['agentNotes'] == "0") {
			$item['agentNotes'] = "None";
		}
		$item['accessgroup'] = $lDB->get("
			SELECT
				sc_grp_desc
			FROM
				sc_user
				INNER JOIN sc_group on sc_group.sc_group_id = sc_user.sc_group_id
			WHERE
				sc_user.pr_user_id = '$item[pr_persona_ix]'
		",4);
		$item['agentNotes'] = str_replace("\r","",$item['agentNotes']);
		array_push($csvFile,array($item['pr_name_last'],$item['pr_name_first'],$item['relationship'],$item['role'],$item['accessgroup'],$item['tel'],$item['email'],$item['web'],trim($item['postal']),$item['postCount'],$item['physical'],$item['physCount'],$item['commission'],$item['payplan'],$item['agentRates'],$item['pr_statutory_1'],$item['pr_statutory_2'],$item['pr_statutory_3'],$item['agentNotes']));
	}

	$csvText = "";
	foreach($csvFile as $csvLine) {
		$first = true;
		foreach($csvLine as $csvItem) {
			if(!$first) {
				$csvText .= ",";
			} else {
				$first = false;
			}
			$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
		}
		$csvText .= "\n";
	}
	header('Content-Type: text/csv');
	header("Cache-control: private");
	header('Content-Length: '.strlen($csvText));
	header("Content-Disposition: inline; filename=contact_".date("Y-m-d").".csv");
	echo $csvText;
	flush();
	die();
}

$GLOBALS['temp']['randomId'] = md5(uniqid(rand(),1));
