<?php

/**
 * init.form171.php - Report Contact Input
 * Job: 537
 * Function: 53 (Reports: Std, Prov, Contact, Mail, Pay received)
*/


function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone, rf_phone_type
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	",4);
	if(trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if(trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$personaId."'
	",2);
	$detail = $detail[0];
	$name = "";
	if(trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if(trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if(trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if(trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

if(isset($_POST['url']) && $_POST['url'] != "") {
	$_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")+1));
	$_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],8,"");

$options = $_SERVER['argv'][6];

switch($options & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "export";
	break;
}

if(isset($renderMode) && $renderMode == "pdf" && isset($renderType) && $renderType == "email") {
	if (!isset($GLOBALS[$form])) {
		$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/report_contact.htm");
	}

	$pdfName = "Contact report.pdf";
	$attachmentTable = "
		<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\"></TD>
			<td id=\"attachmentLabel\" width=\"100%\">$pdfName</TD>
		</tr>
		</table>
	";
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,6))."+3+".join("+",array_slice($_SERVER['argv'],7,6));
	$GLOBALS[$form]->FormHTML = str_replace("!formAction!",$formAction,
		str_replace("!attachmentInfo!",$attachmentTable,
		str_replace("!attachmentName!",$pdfName.".pdf",
		str_replace("!hasAttachment!","expand",
		str_replace("!emailBody!","",
		str_replace("!emailSubject!",$pdfName,
		join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	$GLOBALS['temp']['princName'] = $principalInfo['name'];
	$GLOBALS['temp']['fax'] = $resOfficeInfo['fax'];
	$GLOBALS['temp']['resOffTel'] = $resOfficeInfo['telephone'];
	$userId = $_SESSION['userid'];
	$GLOBALS['temp']['emailFrom'] = $lDB->get("SELECT pr_persona.pr_email FROM pr_persona WHERE pr_persona.pr_persona_ix = '$userId'", 4);
	$GLOBALS['temp']['emailTo'] = "";
} else {

	if($_SERVER['argv'][7] != "email"){
		if (!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/report_contact.htm");
		}

		$GLOBALS[$form]->Get($action);

		if ($_SERVER['argv'][1] != "" || $_SERVER['argv'][2] != "") {
			$_POST['submitval'] = "submitted";
		}

		$temp2 = explode(":",$_SERVER['argv'][2]);
		$_POST['search_persona_name_first'] = rawurldecode($_SERVER['argv'][2]);
		$_POST['search_persona_name_last'] = rawurldecode($_SERVER['argv'][1]);

		if (rawurldecode($_SERVER['argv'][1]) == "" && rawurldecode($_SERVER['argv'][2]) == "") {
			$_POST['search_persona_name_first'] = "*";
			$_POST['search_persona_name_last'] = "*";
		}

		$GLOBALS[$form]->AddField("search_persona_name_last","search_persona_name_last",$_POST['search_persona_name_last'],"0");
		$GLOBALS[$form]->AddField("search_persona_name_first","search_persona_name_first",$_POST['search_persona_name_first'],"0");
		$GLOBALS['search_persona_name_last']->Size = "50";
		$GLOBALS['search_persona_name_last']->TabIndex = "1";
		$GLOBALS['search_persona_name_last']->StyleType = "txt";
		$GLOBALS['search_persona_name_first']->Size = "50";
		$GLOBALS['search_persona_name_first']->TabIndex = "2";
		$GLOBALS['search_persona_name_first']->StyleType = "txt";

		switch ($action) {
		case (0) : // List Records
			break;
		case (1) : // Display Record
			break;
		case (2) : // Add Record
			$GLOBALS[$form]->Arguments = "537";
			break;
		case (3) : // Edit Record
			break;
		}
	} else {
		if (!isset($GLOBALS[$form])) {
			$GLOBALS[$form] = new Form($form,"","");
		}
	}
}
