<?php

/**
 * init.form18.php - The property contact form
 * Job: 43, 44, 45, 46, 47, 54, 526
 * Function: 54 (Contacts)
 */

$GLOBALS['temp']['replaceContactMessage'] = "";
$GLOBALS['temp']['replaceContactTitle'] = "";

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");
$record 			= $_SERVER['argv'][1];
$persona_type 		= $_SERVER['argv'][2];  // This is used to designate the org / ind switch
$disablefocusArgv 	= $_SERVER['argv'][3];

if(isset($_POST['action'])) {
	if($_POST['action'] == "replace") {
		$result = replaceContact($_POST['from'],$_POST['to']);
		if($result[0]) { // success
			echo "
				<form method=\"POST\" id=\"redirect\" action=\"reservation.php?45+" . $_POST['to'] . "\">
					<input type=\"hidden\" name=\"action\" value=\"replace_success\">
					<input type=\"hidden\" name=\"from_id\" value=\"" . $_POST['from'] . "\">
				</form>
				<script>
					document.getElementById(\"redirect\").submit();
				</script>
			";
			die();
		} else { // error
			$GLOBALS['temp']['replaceContactMessage'] = $result[1];
			$GLOBALS['temp']['replaceContactTitle'] = "Error";
		}
	}
	if($_POST['action'] == "replace_success") {
		$GLOBALS['temp']['replaceContactMessage'] = "Replace contact complete.";
	}
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/contact_main_form_ind.htm");
	$GLOBALS['personaFields'] = $fields = array(
		"pr_persona_ix",
		"pr_name_last",
		"pr_name_first",
		"pr_title_id",
		"pr_name_suffix_id",
		"pr_email",
		"pr_persona_link_id",
		"pr_persona_fwd_id",
		"pr_corr_addr_line1",
		"pr_corr_addr_line2",
		"pr_corr_addr_line3",
		"pr_corr_post_office_id",
		"pr_corr_country_id",
		"pr_corr_post_code",
		"pr_corr_city",
		"pr_phys_addr_line1",
		"pr_phys_addr_line2",
		"pr_phys_addr_line3",
		"pr_phys_post_office_id",
		"pr_phys_country_id",
		"pr_phys_post_code",
		"pr_phys_city",
		"pr_org_yn",
		"pr_web_addr",
		"pr_persona_inactive_yn",
		"rf_comms_preference_id",
		"pr_statutory_1",
		"pr_statutory_2",
		"pr_statutory_3"
	);
	$ident = array("pr_name_last");
	$GLOBALS[$form]->AddTable($lDB,"pr_persona",$fields,"pr_persona_ix = '$record'","","",$ident);
}

$conScrollSet = isset($_SESSION['conScrollSet']) ? $_SESSION['conScrollSet'] : '';

if (!is_array($conScrollSet)) {
	$conScrollSet = array();
}
global $pr_agent_link;

$GLOBALS['temp']['disableFocus'] = "false";
if($disablefocusArgv == "1") {
	$GLOBALS['temp']['disableFocus'] = "true";
}
$GLOBALS['autovar'] = "1";   # argv index that will be updated with the autoincrement ID after an insert
$GLOBALS[$form]->Get($action);

if ($record != "") {
	$GLOBALS['temp']['record'] = (string) $record;
	addLastContact($record);
	$GLOBALS['temp']['auditTrailDisabled'] = "";
	$GLOBALS['temp']['auditTrailDisabledClass'] = "";
} else {
	$GLOBALS['temp']['record'] = "null";
	$GLOBALS['temp']['auditTrailDisabled'] = "disabled";
	$GLOBALS['temp']['auditTrailDisabledClass'] = "buttonDisabled";
}

$table = $GLOBALS[$form]->TableList[0];
array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_post_office_id");
array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_post_office_id");

if ($GLOBALS[$form.'_pr_persona_pr_name_last']->Value == "" && $action != "2") {
	if ($lDB->get("SELECT COUNT(*) FROM pr_persona WHERE pr_persona_ix = '".$record."'",4) == "0") {
		redirectTo("reservation.php?43++0");
	}
}

$GLOBALS['temp']['contactName'] = "";
if($record) {
	$cont = $lDB->get("
		SELECT 
			pr_name_first, pr_name_last, 
			rf_name_suffix.rf_suffix_desc, 
			rf_title.rf_title_desc 
		FROM 
			pr_persona 
			LEFT JOIN rf_name_suffix ON pr_persona.pr_name_suffix_id = rf_name_suffix.rf_name_suffix_ix 
			LEFT JOIN rf_title ON pr_persona.pr_title_id = rf_title.rf_title_ix 
		WHERE 
			pr_persona_ix = '".$record."'
	", 1);
	$contactName = 	(isset($cont['rf_title_desc']) ? $cont['rf_title_desc'] : ""). " ".
					(isset($cont['pr_name_first']) ? $cont['pr_name_first'] : "")." ".
					(isset($cont['pr_name_last']) ? $cont['pr_name_last'] : "")." ".
					(isset($cont['rf_name_suffix']) ? $cont['rf_name_suffix'] : "");
	$GLOBALS['temp']['contactName'] = t_encodeHTMLField(trim($contactName));
}


$GLOBALS['temp']['canAgentPopup'] = "false";
$GLOBALS['temp']['canUserPopup'] = "false";
$GLOBALS['temp']['canGuestPopup'] = "false";

if (checkJob(57)) $GLOBALS['temp']['canAgentPopup'] = "true";
if (checkJob(48)) $GLOBALS['temp']['canUserPopup'] = "true";
if (checkJob(209)) $GLOBALS['temp']['canGuestPopup'] = "true";

$GLOBALS['temp']['agentPopEdit'] = "false";
$GLOBALS['temp']['userPopEdit'] = "false";
$GLOBALS['temp']['guestPopEdit'] = "false";

if (checkJob(60)) $GLOBALS['temp']['agentPopEdit'] = "true";
if (checkJob(48)) $GLOBALS['temp']['userPopEdit'] = "true";
if (checkJob(209)) $GLOBALS['temp']['guestPopEdit'] = "true";

$rPrev = $record;
$rNext = $record;
if (!in_array($record,$conScrollSet) && $record != "0" && $record != "") {
	array_push($conScrollSet,$record);
}
if (is_array($conScrollSet)) {
	for ($q=0;$q<sizeof($conScrollSet);$q++) {
		$key = $conScrollSet[$q];
		if ($key == $record) {
			if ($q > "0") {
				$rPrev = $conScrollSet[$q-1];
			}
			if ($q+1 < sizeof($conScrollSet)) {
				$rNext = $conScrollSet[$q+1];
			}
		}
	}
}

$GLOBALS['temp']['scrollSet'] = '
	<input type="hidden" id="record" value="' . $record . '" disabled="disabled" />
	<input type="hidden" id="recordnext" value="' . $rNext . '" disabled="disabled" />
	<input type="hidden" id="recordprev" value="' . $rPrev . '" disabled="disabled" />
';

if ($action != 2) {
	$temp = $lDB->get("SELECT pr_org_yn FROM pr_persona WHERE pr_persona_ix = '$record'",1);
	if ($temp[0] == "1") {
		$checked_record = "1";
	}
} else {
	$GLOBALS[$form.'_pr_persona_pr_persona_db']->SetValue($dbcode);
	$GLOBALS[$form.'_pr_persona_pr_persona_fwd_id']->SetValue("0");
	$GLOBALS[$form.'_pr_persona_pr_persona_link_id']->SetValue("0");
}

if ((isset($_POST['persona_type']) && $_POST['persona_type'] == "1") || $persona_type == "1") {
	$checked_record = "1";
}

$GLOBALS['temp']['salesClass'] = "";
$GLOBALS['temp']['crmClass'] = "";
$GLOBALS['temp']['remindersClass'] = "";
if($record != "") {
	$sales =  $lDB->get("SELECT COUNT(pr_sales_obj_data_ix) FROM pr_sales_obj_data WHERE pr_persona_id = '$record'",4);
	if($sales>0) {
		// $GLOBALS['temp']['salesClass'] = "bSales"; // Disable sales profile icon in tab as it's bugged
	}

	$crm =  $lDB->get("SELECT COUNT(pr_event_persona_ix) FROM pr_event_persona WHERE pr_persona_id = '$record' AND pr_event_rep_ind = '0'", 4);
	if($crm>0) {
		// $GLOBALS['temp']['crmClass'] = "bCrm"; // Disable events icon in tab as it's bugged
	} 
}

if (isset($checked_record) && $checked_record == "1") {
	$GLOBALS[$form]->FormHTML = Join("\n",File(__DIR__ . "/../../../public/html/contact_main_form_org.htm"));
	$GLOBALS[$form]->HTML = __DIR__ . "/../../../public/html/contact_main_form_org.htm";
	$GLOBALS[$form.'_pr_persona_pr_name_first']->IsKey = "1";
	$GLOBALS[$form.'_pr_persona_pr_name_first']->IsDisabled = "1";
	$GLOBALS[$form.'_pr_persona_pr_org_yn']->SetValue("1");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_name_first");
} else {
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_web_addr");
}

if ($record != "" || $action == "3" && $action != "1") {
	$table = $GLOBALS[$form]->TableList[0];
	$GLOBALS[$table]->Refresh($record,$action);
}

// Added for inactive contact
$GLOBALS['can_delete'] = "1";
$GLOBALS['temp']['del_error'] = "";

$tempz = $lDB->get("SELECT pr_persona_id FROM rf_sys_admin WHERE pr_persona_id = '$record'",1);
$admin_id = $tempz[0];
$GLOBALS['temp']['reqEmail'] = "";
if ($record == $admin_id && $admin_id != "" && $admin_id != 0) {
	$GLOBALS['temp']['del_error'] = "Unable to delete a system administrator.<br>";
	$GLOBALS['temp']['reqEmail'] = "1";
	$GLOBALS['can_delete'] = "0";
}

$tempz = $lDB->get("SELECT rf_default.rf_principal_id FROM rf_default WHERE rf_default.rf_principal_id = '$record'",1);
$princ_id = $tempz[0];
if ($record == $princ_id) {
	$GLOBALS['temp']['del_error'] = "Unable to delete the principal.<br>";
	$GLOBALS['can_delete'] = "0";
}

$tempz = $lDB->get("
	SELECT 
		COUNT(pr_link.pr_link_from)
	FROM 
		pr_link 
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_link.pr_link_from
	WHERE 
		pr_link.pr_link_to = '$record'
		AND pr_persona.pr_persona_inactive_yn = '0'
",1);
if ($tempz[0] > 0) {
	$GLOBALS['temp']['del_error'] = "This record cannot be deleted whilst there are still active contacts linked to it.";
	$GLOBALS['can_delete'] = "0";
}

$tempz = $lDB->get("SELECT COUNT(rv_consultant_id) FROM rv_reservation WHERE rv_consultant_id = '$record'",4);
if ($tempz > 0) {
	$GLOBALS['temp']['del_error'] = "Unable to delete. Contact allocated as consultant to existing reservations.<br>";
	$GLOBALS['can_delete'] = "0";
}

$tempz = $lDB->get("SELECT COUNT(*) FROM pr_business WHERE pr_business_id = '$record'",1);
if ($tempz[0] != "0") {
	$GLOBALS['temp']['del_error'] = "This contact cannot be removed as it is linked to the Business Structure.";
	$GLOBALS['can_delete'] = "0";
}

if ($GLOBALS['userid'] == $record) {
	$GLOBALS['temp']['del_error'] = "a";
	$GLOBALS['can_delete'] = "0";
}

$GLOBALS['temp']['can_delete'] = $GLOBALS['can_delete'];
if ($GLOBALS['temp']['del_error'] == "") {
	$GLOBALS['temp']['del_error'] = "This record can not be deleted.<br>";
}

$actVal = "0";
$inActVal = "1";
$actFlag = $form."_pr_persona_pr_persona_inactive_yn";
if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
	$GLOBALS[$actFlag]->Value = $actVal;
	$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
} else {
	if ($record == "" && $action == "1" || $GLOBALS[$actFlag]->Value == "") {
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
	} else {
		$GLOBALS[$actFlag]->Value = $inActVal;
		$GLOBALS['temp']['actInd'] = "";
	}
}
$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
$GLOBALS[$actFlag]->StyleType = "txts";

// End add for inactive contact


// Added for contact relationships
# Selecting a contact's links to businesses (spec slightly wrong here)
$GLOBALS['temp']['bizlinkrows'] = "";
$GLOBALS['temp']['agntlinkrows'] = "";

$pr_persona_id = $record;
$bizlinks = $lDB->get("
	SELECT
		pr_link.pr_link_to,
		pr_persona.pr_name_last
	FROM
		pr_persona
		INNER JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_to
	WHERE         
		pr_link_from = '$pr_persona_id'
		AND rf_link_type_id = 'RS1'
",2);

if ($action == "1") {
	$linkJob = "47";
} else {
	$linkJob = "45";
}

for ($i=0;$i<sizeof($bizlinks);$i++) {
	$bizname = $bizlinks[$i][1];
	$blink_to = $bizlinks[$i][0];
	if ($action == 3 && !$GLOBALS['isPropServer']) {
		$thingy1 = '
			<button type="button" class="button printCollapse" onclick="removebizlink(\'' . $blink_to . '\',\'' . $pr_persona_id . '\');" tabindex="23">
				<span>Remove Link</span>
			</button>
		';
	} else {
		$thingy1 = "";
	}
	$outline = '
		<tr onmouseover="this.style.backgroundColor=\'#cfc\';" onmouseout="this.style.backgroundColor=\'\';" style="cursor: pointer;">
			<td>&nbsp;&nbsp;<a class="link" href="reservation.php?' . $linkJob . '+' . $blink_to . '">' . $bizname . '</a></td>
			<td align="left">' . $thingy1 . '</td>
		</tr>
	';
	$GLOBALS['temp']['bizlinkrows'] .= $outline;
}

$GLOBALS['temp']['bizlinkstyle'] = '';
if ( $GLOBALS['temp']['bizlinkrows'] != "" || $action == 1 && $GLOBALS['job'] != 44 ) {
	$GLOBALS['temp']['bizlinkstyle'] = 'style="display: none;"';
}

if ($GLOBALS['temp']['bizlinkrows'] == "" && $action == 1) {
	$outline = '
		<tr>
			<td>&nbsp;&nbsp;None</td>
			<td>&nbsp;</td>
		</tr>
	';
	$GLOBALS['temp']['bizlinkrows'] .= $outline;
}

$agntlinks = $lDB->get("
	SELECT
		pr_link.pr_link_to,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
	FROM
		pr_persona
		INNER JOIN pr_link ON pr_persona.pr_persona_ix = pr_link.pr_link_to
	WHERE		
		pr_link_from = '$pr_persona_id'
		AND rf_link_type_id = 'RS2'
",2);

for ($i=0;$i<sizeof($agntlinks);$i++) {
	$agntname = $agntlinks[$i][1];
	if ($agntlinks[$i][2] != "") {
		$agntname .= ", ".$agntlinks[$i][2];
	}
	$alink_to = $agntlinks[$i][0];
	if ($action == 3 && !$GLOBALS['isPropServer']) {
		//$thingy1 = "<input onclick=\"removeuserlink('$alink_to','$pr_persona_id')\" type=\"button\" style=\"width:90;\" class=\"button bRemLink\" value=\"    Remove Link\" tabindex=\"23\">";
		$thingy1 = '
			<button type="button" class="button printCollapse" onclick="removeuserlink(\'' . $alink_to . '\',\'' . $pr_persona_id . '\');" tabindex="23">
				<span>Remove Link</span>
			</button>
		';
	} else {
		$thingy1 = '';
	}
	$outline = '
		<tr onmouseover="this.style.backgroundColor=\'#cfc\';" onmouseout="this.style.backgroundColor=\'\';" style="cursor: pointer;">
			<td>&nbsp;&nbsp;<a class=\'link\' href="reservation.php?' . $linkJob . '+' . $alink_to . '">' . $agntname . '</a></td>
			<td align="left">' . $thingy1 . '</td>
		</tr>
	';
	$GLOBALS['temp']['agntlinkrows'] .= $outline;
}
$GLOBALS['temp']['agntlinkstyle'] = "";
if ($GLOBALS['temp']['agntlinkrows'] != "" || $action == 1 && $GLOBALS['job'] != 44) {
	$GLOBALS['temp']['agntlinkstyle'] = " style=\"display:none\"";
}
$GLOBALS['temp']['bizhide'] = "";
if (in_array($record,$GLOBALS['property_tree']) && $record != "") {
	$GLOBALS['temp']['bizhide'] = " style=\"display:none\" ";
}
if($GLOBALS['isPropServer']) {
	$GLOBALS['temp']['agntlinkstyle'] = " style=\"display:none\"";
	$GLOBALS['temp']['bizlinkstyle'] = " style=\"display:none\" ";
}

$GLOBALS['temp']['agnthide'] = "";
$GLOBALS['temp']['agnthide2'] = "";
$GLOBALS['temp']['overViewTab'] = "";
$GLOBALS['temp']['overViewColumn'] = "";
if (isAgent($record)) {
	$GLOBALS['temp']['agntlinkstyle'] = " style=\"display:none\"";
	$GLOBALS['temp']['agnthide2'] = " style=\"display:none\"";
	$GLOBALS['temp']['overViewTab'] = '<td id="overViewTab" class="tab tabInactive tabLink !overviewClass! redUnderline" onclick="buttonPress(\'openOverview\');">Agent Overview</td>';
	$GLOBALS['temp']['overViewColumn'] = '<col width="97" />';
}
if ($GLOBALS['temp']['agntlinkrows'] == "" && $action == 1 && $GLOBALS['temp']['agnthide2'] == "") {
	$outline = "
		<tr>
			<td width=\"220\" class=\"txt\" height=\"15\">&nbsp;&nbsp;None</td>
			<td width=\"70\" align=\"right\"></td>
			<td width=\"10\" align=\"right\" class=\"txts\"></td>
			</tr>
	";
	$GLOBALS['temp']['agntlinkrows'] .= $outline;
}
if (!isAgent($record)) {
	if (idAgentLink($record) != "0") {
		$GLOBALS['temp']['agnthide'] = " style=\"visibility:hidden\"";
	}
}

$GLOBALS['temp']['hide_tel'] = " style=\"display:none\"";
$GLOBALS['temp']['srlink'] = "Link Address";
$GLOBALS['temp']['linkClass'] = "add";
if ($GLOBALS[$form.'_pr_persona_pr_persona_link_id']->Value != "0" && $action != "2") {
	$GLOBALS['temp']['srlink'] = "Remove Link";
	$GLOBALS['temp']['linkClass'] = "remove";

	$linked_record = $GLOBALS[$form.'_pr_persona_pr_persona_link_id']->Value;
	$temp = $lDB->get("
		SELECT
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_addr_line3,
			pr_corr_post_office_id,
			pr_corr_country_id,
			pr_corr_post_code,
			pr_phys_addr_line1,
			pr_phys_addr_line2,
			pr_phys_addr_line3,
			pr_phys_post_office_id,
			pr_phys_country_id,
			pr_phys_post_code,
			pr_corr_city,
			pr_phys_city
		FROM
			pr_persona
		WHERE
		pr_persona_ix = '$linked_record'
	",1);

	$GLOBALS[$form.'_pr_persona_pr_corr_addr_line1']->Value = $temp[0];
	$GLOBALS[$form.'_pr_persona_pr_corr_addr_line2']->Value = $temp[1];
	$GLOBALS[$form.'_pr_persona_pr_corr_addr_line3']->Value = $temp[2];
	$GLOBALS[$form.'_pr_persona_pr_corr_post_office_id']->Value = $temp[3];
	$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Value = $temp[4];
	if ($temp[4] == "" || $temp[4] == "0") {
		$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Value = "0";
	}
	$GLOBALS[$form.'_pr_persona_pr_corr_post_code']->Value = $temp[5];
	$GLOBALS[$form.'_pr_persona_pr_phys_addr_line1']->Value = $temp[6];
	$GLOBALS[$form.'_pr_persona_pr_phys_addr_line2']->Value = $temp[7];
	$GLOBALS[$form.'_pr_persona_pr_phys_addr_line3']->Value = $temp[8];
	$GLOBALS[$form.'_pr_persona_pr_phys_post_office_id']->Value = $temp[9];
	$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Value = $temp[10];
	$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Value = $temp[11];
	$GLOBALS[$form.'_pr_persona_pr_corr_city']->Value = $temp[12];
	$GLOBALS[$form.'_pr_persona_pr_phys_city']->Value = $temp[13];

	$temp1 = $lDB->Get("SELECT pr_phone_number FROM pr_phone WHERE pr_default_yn = '1' AND pr_persona_id = '$linked_record'",1);
	if ($temp1[0] == "0") {
		$valuenum = "";
	} else {
		$valuenum = $temp1[0];
	}

	$GLOBALS[$form]->AddField("link_tel","link_tel",$valuenum,"0");
	$GLOBALS['link_tel']->Size = "25";
	$GLOBALS['link_tel']->Width = "184";
	$GLOBALS['link_tel']->StyleType = "txt";
	$GLOBALS['link_tel']->IsDisabled = "1";
	$GLOBALS['temp']['hide_tel'] = "";

	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_addr_line1");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_addr_line2");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_addr_line3");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_post_office_id");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_country_id");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_post_code");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_addr_line1");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_addr_line2");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_addr_line3");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_post_office_id");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_country_id");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_post_code");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_corr_city");
	array_push($GLOBALS[$table]->Keys,$form."_pr_persona_pr_phys_city");
	array_push($GLOBALS[$table]->Keys,"hide_tel");


	$disablelist = array(
		$form."_pr_persona_pr_corr_addr_line1",
		$form."_pr_persona_pr_corr_addr_line2",
		$form."_pr_persona_pr_corr_addr_line3",
		$form."_pr_persona_pr_corr_post_office_id",
		$form."_pr_persona_pr_corr_country_id",
		$form."_pr_persona_pr_corr_city",
		$form."_pr_persona_pr_corr_post_code",
		$form."_pr_persona_pr_phys_addr_line1",
		$form."_pr_persona_pr_phys_addr_line2",
		$form."_pr_persona_pr_phys_addr_line3",
		$form."_pr_persona_pr_phys_post_office_id",
		$form."_pr_persona_pr_phys_country_id",
		$form."_pr_persona_pr_phys_post_code",
		$form."_pr_persona_pr_phys_city",
		"hide_tel"
	);
	$GLOBALS[$form]->Disable($disablelist);
}
if(trim($GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Value) == "" || $GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Value == "0") {
	$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Value = "";
}

// End add for contact relationships

$sql = "
	SELECT
		rf_country_ix,
		IF(rf_country_inactive <> '0',CONCAT('* ',rf_country_name),rf_country_name) as rf_country_name,
		rf_country_code
	FROM
		rf_country
	WHERE
		rf_country_inactive = '0'
		OR rf_country_ix = '".$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Value."'
	ORDER BY
		rf_country_name
";
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Class = 3;
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Select = combolist($lDB,$sql,"0:|:");
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Width = "176.5";

$sql = "
	SELECT
		rf_country_ix,
		IF(rf_country_inactive <> '0',CONCAT('* ',rf_country_name),rf_country_name) as rf_country_name,
		rf_country_code
	FROM
		rf_country
	WHERE
		rf_country_inactive = '0'
		OR rf_country_ix = '".$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Value."'
	ORDER BY
		rf_country_name
";
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Class = 3;
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Select = combolist($lDB,$sql,"0:|:");
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Width = "176.5";

$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Class = 3;
$sql = "
	SELECT
		rf_name_suffix_ix,
		IF(rf_suffix_inactive_yn <> '0',CONCAT('* ',rf_suffix_desc),rf_suffix_desc) as rf_suffix_desc
	FROM
		rf_name_suffix
	WHERE
		rf_suffix_inactive_yn = '0'
		OR rf_name_suffix.rf_name_suffix_ix = '".$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Value."'
	ORDER BY
		rf_suffix_desc
";
$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Select = combolist($lDB,$sql,"RR0-");
$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Width = "181";

$GLOBALS[$form.'_pr_persona_pr_title_id']->Class = 3;
$sql = "
	SELECT
		rf_title_ix,
		IF(rf_title_inactive_yn <> '0',CONCAT('* ',rf_title_desc),rf_title_desc) as rf_title_desc
	FROM
		rf_title
	WHERE
		rf_title_inactive_yn = '0'
		OR rf_title.rf_title_ix = '".$GLOBALS[$form.'_pr_persona_pr_title_id']->Value."'
	ORDER BY
		rf_title_id
";
$GLOBALS[$form.'_pr_persona_pr_title_id']->Select = combolist($lDB,$sql,"RR0-");
$GLOBALS[$form.'_pr_persona_pr_title_id']->Width = "181";

$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->Class = 3;
$sql = "
	SELECT
		rf_comms_preference_db,
		rf_comms_preference_ix,
		IF(rf_comms_inactive_yn <> '0',CONCAT('* ',rf_comms_desc),rf_comms_desc) as rf_comms_desc
	FROM
		rf_comms_preference
	WHERE
		rf_comms_inactive_yn = '0'
		OR rf_comms_preference_ix = '".$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->Value."'
	ORDER BY
		rf_comms_desc
";
$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->Select = combolist($lDB,$sql,"0:|: ");
$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->Width = "181";

$GLOBALS[$form.'_pr_persona_pr_persona_ix']->Class = 8;

$fwd_name = "";
$null = $dbcode."0";
$GLOBALS['temp']['fwd_alt'] = "Select a forward contact";
if ($GLOBALS[$form.'_pr_persona_pr_persona_fwd_id']->Value != "0" && $GLOBALS[$form.'_pr_persona_pr_persona_fwd_id']->Value != "") {
	$GLOBALS['temp']['fwd_alt'] = "Remove the forward contact";
	$persona = $GLOBALS[$form.'_pr_persona_pr_persona_fwd_id']->Value;
	$temp = $lDB->get("SELECT pr_name_last,pr_name_first FROM pr_persona WHERE pr_persona_ix = '$persona'",1);
	$fwd_name = trim($temp['pr_name_last'] . " " . $temp['pr_name_first']);
}
$GLOBALS[$form]->AddField("fwd_id","fwd_id",$fwd_name,"0");

$GLOBALS['temp']['link_alt'] = "Select a linked address";
$link_name = "";
if ($GLOBALS[$form.'_pr_persona_pr_persona_link_id']->Value != "0" && $GLOBALS[$form.'_pr_persona_pr_persona_link_id']->Value != "") {
	$GLOBALS['temp']['link_alt'] = "Remove the linked address";
	$persona = $GLOBALS[$form.'_pr_persona_pr_persona_link_id']->Value;
	$temp = $lDB->get("SELECT pr_name_last, pr_name_first FROM pr_persona WHERE pr_persona_ix = '$persona'",1);
	$link_name = $temp[0];
	if ($temp[1] != "") {
		$link_name .= ", ".$temp[1];
	}
}
$GLOBALS[$form]->AddField("link_id","link_id",$link_name,"0");

global $telephoneAudit;
if(!isset($telephoneAudit) || !is_array($telephoneAudit)) {
	$telephoneAudit = [];
}
if ($pmode == "0") {
	if ($action != 2 && $action != 4) {
		$temp2 = $lDB->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '$record' AND pr_phone_number != ''",4);
		$GLOBALS['temp']['morenums'] = $temp2-1;
	} else {
		$GLOBALS['temp']['morenums'] = "0";
	}

	$telcount = $GLOBALS['temp']['morenums'];
	if ($telcount > 5) {
		$telcount = 6;
	}
	if ($telcount < 0) {
		$telcount = 0;
	}
	$GLOBALS['temp']['opentelephone'] = '
		<button type="button" id="tels" name="tels" class="button" style="width: 24px; height: 20px; text-align: center; padding: 0px;" onclick="buttonPress(\'openTelephone\')">
		<i class="material-icons" style="vertical-align: middle;">local_phone</i>
		</button>
	';
	$GLOBALS['temp']['defnum'] = "";
	$GLOBALS['temp']['defnum2'] = "0";
	if ($action != "1") {
		$GLOBALS['temp']['telmode'] = "68";
	} else {
		$GLOBALS['temp']['telmode'] = "67";
	}
	$phone = "";
	if ($record != "") {
		$temp = $lDB->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '$record' AND pr_default_yn = '1'",1);
		if ($temp[0] != "0") {
			$temp1 = $lDB->get("SELECT pr_phone_number, pr_phone_ix FROM pr_phone WHERE pr_persona_id = '$record' and pr_default_yn = '1'",1);
			$phone = $temp1[0];
			$phone_id = $temp1[1];
			$GLOBALS['temp']['defnum'] = "reservation.php?".$GLOBALS['temp']['telmode']."+".$record."+".$phone_id;
			$GLOBALS['temp']['defnum2'] = $phone_id;
		}
	}
	if ($action != 2 && $action != 4) {
		$GLOBALS[$form]->AddField("phone_default","phone_default",$phone,0);
	} else {
		$GLOBALS[$form]->AddField("phone_default","phone_default","",0);
	}
	$GLOBALS['phone_default']->Size = "30";
	$GLOBALS['phone_default']->StyleType = "txt";
	$GLOBALS['phone_default']->Width = "184";
} else {
	$newphone = isset($_POST['phone_default']) ? $_POST['phone_default'] : "";
    if ($record != "") {
    	$pr_phone_id = $lDB->get("SELECT pr_phone_ix FROM pr_phone WHERE pr_persona_id = '".$lDB->escape($record)."' AND pr_default_yn = '1'",4);
    } else {
        $pr_phone_id = "";
    }
	if (!empty($pr_phone_id)) {
		$oldphone = $lDB->get("SELECT pr_phone_number FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
		if ($newphone != $oldphone) {
			$lDB->put("UPDATE pr_phone SET pr_phone_number = '".$lDB->escape($newphone)."' WHERE pr_persona_id = '$record' and pr_default_yn = '1'");
			$telephoneAudit[] = [$oldphone, $newphone, $pr_phone_id, $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "phone", "pr_phone.pr_phone_number"];
		}
	} else {
		if ($newphone != "") {
			$rf_phone_type_id = $lDB->Get("SELECT rf_phone_type_id FROM rf_default",4);
			$rf_phone_type_id = !empty($rf_phone_type_id) ? $rf_phone_type_id : "RS3";
			$lDB->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_phone_number,
					pr_persona_id,
					pr_default_yn,
					rf_phone_type_id
				) VALUES (
					'".$lDB->escape($dbcode)."',
					'".$lDB->escape($newphone)."',
					'".$lDB->escape($record)."',
					'1',
					'$rf_phone_type_id'
				)
			");
			$pr_phone_id = $lDB->insert_id;
			$telephoneAudit[] = ["", 1, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn"];
			$telephoneAudit[] = ["", $newphone, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number"];
			$telephoneAudit[] = ["", "RS3", "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id"];
		}
	}
}

$GLOBALS['temp']['aStyle'] = "button masterButton";
$GLOBALS['temp']['uStyle'] = "button masterButton";
$GLOBALS['temp']['gStyle'] = "button masterButton";

$agent = "";
$agentmode = "";
$salesmode = "";

if (!$lDB->count("pr_agent","pr_agent_id",$record,0) && $action != "2" && $action != "4") {
	$agent = " checked disabled";
	$agentmode = "1";
	$temp = $lDB->get("SELECT pr_agent_inactive_yn FROM pr_agent WHERE pr_agent_id = '$record'",1);
	if ($temp[0] != "0") {
		$GLOBALS['temp']['aStyle'] = "linkI";
	}
}
if ($action == "1") { $agent .= " disabled"; }
$GLOBALS[$form]->AddField("is_agent","is_agent",$agent,"8");

$user = "";
$usermode = "0";
if (!$lDB->count("pr_user","pr_user_id",$record,0)) {
	$user = " checked disabled";
	$usermode = "1";
	$temp = $lDB->get("SELECT pr_user_inactive_yn FROM pr_user WHERE pr_user_id = '$record'",1);
	if ($temp[0] != "0") {
		$GLOBALS['temp']['uStyle'] = "linkI";
	}
}
if ($action == "1") { $user .= " disabled"; }
$GLOBALS[$form]->AddField("is_user","is_user",$user,"8");

$guest = "";
$guestmode = "0";
if (!$lDB->count("pr_guest","pr_guest_id",$record,0)) {
	$guest = " checked disabled";
	$guestmode = "1";
	$temp = $lDB->get("SELECT pr_guest_inactive_yn FROM pr_guest WHERE pr_guest_id = '$record'",1);
	if($temp[0] != "0") {
		$GLOBALS['temp']['gStyle'] = "linkI";
	}
}
if ($action == "1") { $guest .= " disabled"; }
$GLOBALS[$form]->AddField("is_guest","is_guest",$guest,"8");

if ($usermode == "1" && $action != "2") {
	if ($action == "1") { $job = "48"; } else { $job = "51"; }
	$urla = "<a href=\"javascript:openUser('reservation.php?$job+$record')\" class=link>";
	$urlb = "</a>";
} else {
	if ($action == "1") { $job = "#"; } else { $job = "49";}
	$urla = "";
	$urlb = "";
}

if ($agentmode == "1" && $action != "2") {
	if ($action == "1") { $job2 = "57"; } else { $job2 = "60"; }
	$url2a = "<a href=\"javascript:openUser('reservation.php?$job2+$record')\" class=link>";
	$url2b = "</a>";
} else {
	if ($action == "1") { $job2 = "#"; } else { $job2 = "58"; }
	$url2a = "";
	$url2b = "";
}

if($guestmode == "1" && $action != "2") {
	if($action == "1") { $jobGuest = "209"; } else { $jobGuest = "212"; }
} else {
	if($action == "1") { $jobGuest = "#"; } else { $jobGuest = "210"; }
}

if($salesmode == "1" && $action != "2") {
	if($action == "1") { $jobSales = "382"; } else { $jobSales = "385"; }
} else {
	if($action == "1") { $jobSales = "382"; } else {
		if($record) {$jobSales = "385"; } else { $jobSales = "383"; } 
	}
}

$jobCRM = "388";
$jobOverview = "9001";
$jobReminder = "3012";

$GLOBALS['temp']['url2a'] = $urla;
$GLOBALS['temp']['url2b'] = $urlb;
$GLOBALS['temp']['url4a'] = $url2a;
$GLOBALS['temp']['url4b'] = $url2b;

$GLOBALS['temp']['current'] = "reservation.php?47+$record";
if ($action == "3") {
	$GLOBALS['temp']['current'] = "reservation.php?45+$record";
}

if ($action == "3" || $pmode == "1") {
	$GLOBALS[$form]->AddField("edit_view","edit_view","47","8");
	$GLOBALS['temp']['url'] = "reservation.php?$job+$record";
	$GLOBALS['temp']['url3'] = "reservation.php?$job2+$record";
	$GLOBALS['temp']['urlGuest'] = "reservation.php?$jobGuest+$record++Z";
	$GLOBALS['temp']['urlSales'] = "reservation.php?$jobSales+$record";
	$GLOBALS['temp']['urlCRM'] = "reservation.php?$jobCRM+$record";
	$GLOBALS['temp']['urlOverview'] = "reservation.php?$jobOverview+$record";
	$GLOBALS['temp']['urlContactReminder'] = "reservation.php?{$jobReminder}+{$record}";
} else {
	if ($action == "2") {
		$GLOBALS[$form]->AddField("edit_view","edit_view","43","8");
		$GLOBALS['temp']['url'] = "reservation.php?$job";
		$GLOBALS['temp']['url3'] = "reservation.php?$job2";
		$GLOBALS['temp']['urlGuest'] = "reservation.php?$jobGuest++Z";
		$GLOBALS['temp']['urlSales'] = "reservation.php?$jobSales";
		$GLOBALS['temp']['urlCRM'] = "reservation.php?$jobCRM";
		$GLOBALS['temp']['urlOverview'] = "reservation.php?$jobOverview";
        $GLOBALS['temp']['urlContactReminder'] = "reservation.php?{$jobReminder}";
	} else {
		$GLOBALS[$form]->AddField("edit_view","edit_view","45","8");
		$GLOBALS['temp']['url'] = "reservation.php?$job+$record";
		$GLOBALS['temp']['url3'] = "reservation.php?$job2+$record";
		$GLOBALS['temp']['urlGuest'] = "reservation.php?$jobGuest+$record++Z";
		$GLOBALS['temp']['urlSales'] = "reservation.php?$jobSales+$record";
		$GLOBALS['temp']['urlCRM'] = "reservation.php?$jobCRM+$record";
		$GLOBALS['temp']['urlOverview'] = "reservation.php?$jobOverview+$record";
        $GLOBALS['temp']['urlContactReminder'] = "reservation.php?{$jobReminder}+{$record}";
	}
}

if ($action == "2" || $action == "3") {
	$GLOBALS[$form]->AddField("save_link","save_link","javascript:document.forms.".$form.".submit();","8");
	$GLOBALS['temp']['url'] = "reservation.php?$job+$record";
	$GLOBALS['temp']['url3'] = "reservation.php?$job2+$record";
	$GLOBALS['temp']['urlGuest'] = "reservation.php?$jobGuest+$record++Z";
	$GLOBALS['temp']['urlSales'] = "reservation.php?$jobSales+$record";
	$GLOBALS['temp']['urlCRM'] = "reservation.php?$jobCRM+$record";
	$GLOBALS['temp']['urlOverview'] = "reservation.php?$jobOverview+$record";
    $GLOBALS['temp']['urlContactReminder'] = "reservation.php?{$jobReminder}+{$record}";
} else {
	$GLOBALS[$form]->AddField("save_link","save_link","#","8");
	$GLOBALS['temp']['url'] = "reservation.php?$job+$record";
	$GLOBALS['temp']['url3'] = "reservation.php?$job2+$record";
	$GLOBALS['temp']['urlGuest'] = "reservation.php?$jobGuest+$record++Z";
	$GLOBALS['temp']['urlSales'] = "reservation.php?$jobSales+$record";
	$GLOBALS['temp']['urlCRM'] = "reservation.php?$jobCRM+$record";
	$GLOBALS['temp']['urlOverview'] = "reservation.php?$jobOverview+$record";
    $GLOBALS['temp']['urlContactReminder'] = "reservation.php?{$jobReminder}+{$record}";
}

if ($action == "3") {
	$GLOBALS[$form]->AddField("delete_link","delete_link","reservation.php?54+$record","8");
} else {
	$GLOBALS[$form]->AddField("delete_link","delete_link","reservation.php?47+$record#","8");
}

$hidelist = array($form."_pr_persona_pr_persona_link_id",$form."_pr_persona_pr_persona_fwd_id",$form."_pr_persona_pr_org_yn");
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array("link_id","fwd_id");
$GLOBALS[$form]->Disable($disablelist);

$GLOBALS[$form.'_pr_persona_pr_name_first']->Size = "30";
$GLOBALS[$form.'_pr_persona_pr_name_first']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_name_first']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_name_last']->Size = "30";
$GLOBALS[$form.'_pr_persona_pr_name_last']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_name_last']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_web_addr']->Size = "30";
$GLOBALS[$form.'_pr_persona_pr_web_addr']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_web_addr']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_title_id']->Size = "14";
$GLOBALS[$form.'_pr_persona_pr_title_id']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Size = "6";
$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_email']->Size = "30";
$GLOBALS[$form.'_pr_persona_pr_email']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_email']->Width = "184";
$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->Size = "9";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line1']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line2']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line3']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_city']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_post_code']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line1']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line2']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line3']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_city']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->Width = "184";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line1']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line2']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line3']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_corr_city']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_corr_post_code']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line1']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line2']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line3']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_city']->StyleType = "txt";
$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->StyleType = "txt";
$GLOBALS['edit_view']->Size = "";
$GLOBALS['fwd_id']->Size = "25";
$GLOBALS['fwd_id']->StyleType = "txt";
$GLOBALS['link_id']->Size = "30";
$GLOBALS['link_id']->StyleType = "txt";
$GLOBALS['link_id']->Width = "184";

$tabindex = "1";
$GLOBALS[$form.'_pr_persona_pr_name_last']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_name_first']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_title_id']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_name_suffix_id']->TabIndex = $tabindex++;
if ($pmode == 0) {
	$GLOBALS['phone_default']->TabIndex = $tabindex++;
}
$GLOBALS[$form.'_pr_persona_pr_email']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_web_addr']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_rf_comms_preference_id']->TabIndex = $tabindex++;

$GLOBALS[$form.'_pr_persona_pr_statutory_1']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_statutory_2']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_statutory_3']->TabIndex = $tabindex++;

$GLOBALS[$form.'_pr_persona_pr_persona_fwd_id']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_persona_link_id']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line1']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line2']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_addr_line3']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_country_id']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_city']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_post_code']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line1']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line2']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_addr_line3']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_country_id']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_city']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_phys_post_code']->TabIndex = $tabindex++;
$GLOBALS[$form.'_pr_persona_pr_corr_post_office_id']->TabIndex = "";
$GLOBALS[$form.'_pr_persona_pr_phys_post_office_id']->TabIndex = "";
$GLOBALS['edit_view']->TabIndex = "";
$GLOBALS['fwd_id']->TabIndex = $tabindex++;
$GLOBALS['link_id']->TabIndex = $tabindex++;

$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);
for ($x = 1; $x < 4; $x++) {
	if ($default_statutory_labels['rf_statutory_label_'.$x] != "") {
		$GLOBALS['temp']['rf_statutory_label_'.$x] = $default_statutory_labels['rf_statutory_label_'.$x];
		$GLOBALS['temp']['statutory_'.$x.'_display'] = "";
	} else {
		$GLOBALS['temp']['statutory_'.$x.'_display'] = "collapse";
	}
}


// Start Access Control Toolbar Setup
$newr = 43;
$edit = 45;
$view = 47;
$dele = 54;
$sedit = 46;
$snewr = 44;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele) && isset($GLOBALS[$actFlag]->Value) && $GLOBALS[$actFlag]->Value == 0) {
		$pgJOBS['del'] = "1";
	}
}

$isBus = !$lDB->count("pr_business","pr_business_id",$record,0);
if ($isBus) {
	if (!$lDB->count("pr_user","pr_user_id",$record,0," WHERE pr_user_id = '" . $record . "' AND pr_user_inactive_yn = 0") ||
		!$lDB->count("pr_agent","pr_agent_id",$record,0," WHERE pr_agent_id = '" . $record . "' AND pr_agent_inactive_yn = 0")) {
		// If this is a business entity, but have existing active user or agent roles, then allow editing
		$isBus = false;
	}
}

$GLOBALS['temp']['isBusiness'] = $isBus;
if ($isBus && $action == "3") {
	// Edit mode on a business structure entity is not allowed, redirect to view mode
	redirectTo("reservation.php?47+" . $record);
}

$GLOBALS['temp']['pgJobs'] = "
	<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">
	<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">
	<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">
	<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">
";
// End Access Control Toolbar Setup
$GLOBALS['temp']['popuphide'] = "";
switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['popuphide'] = " style=\"visibility:hidden\"";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "44";
	if ($pmode == "0") {
		$_SERVER['argv'][1] = "";
		$record = "";
	}
	else {
		$importantFields = ['pr_name_last', 'pr_name_first', 'pr_email', 'phone_default'];
		foreach($importantFields as $field) {
			if(isset($_POST[$field])) {
				$_POST[$field] = trim($_POST[$field]);
			}
		}
		$isBlankContact = (isset($_POST['pr_name_last'])?empty($_POST['pr_name_last']):true) && (isset($_POST['pr_name_first'])?empty($_POST['pr_name_first']):true);
		if($isBlankContact) {
			// Prevent creation of the blank contact by showing the white screen of death
			redirectTo("reservation.php?999");
		}
	}
	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "46+".$record;
	$GLOBALS['mode'] = "edit";
	break;
case (4) : // Delete Record
	$isUser = false;
	$isAgent = false;
	$isGuest = false;
	if (!$lDB->count("pr_user","pr_user_id",$record,0)){
		$isUser = true;
	}
	if (!$lDB->count("pr_agent","pr_agent_id",$record,0)){
		$isAgent = true;
	}
	if (canDeleteContact($record)) {
		$GLOBALS['initrecord'] = $record;
		$GLOBALS['delrecord'] = $record;
		$_SERVER['argv'][1] = "";
	}
	removeContact($record);
	redirectTo("reservation.php?47+$record");
	die();
	break;
}

if ($action == "1") {
	$GLOBALS[$form.'_pr_persona_pr_statutory_1']->IsDisabled = "1";
	$GLOBALS[$form.'_pr_persona_pr_statutory_2']->IsDisabled = "1";
	$GLOBALS[$form.'_pr_persona_pr_statutory_3']->IsDisabled = "1";
}

$GLOBALS['tagList']['pr_statutory_1'] = $GLOBALS[$form.'_pr_persona_pr_statutory_1'];
$GLOBALS['tagList']['pr_statutory_2'] = $GLOBALS[$form.'_pr_persona_pr_statutory_2'];
$GLOBALS['tagList']['pr_statutory_3'] = $GLOBALS[$form.'_pr_persona_pr_statutory_3'];



if(
	($action == "3" && $pmode == "1")
	|| (isset($GLOBALS['personaNew']) && $GLOBALS['personaNew'])
) {
	// Audit trail
	$auditMode = DB_AD_PERSONA_DETAIL_ACTION_ADD;
	$auditType = "Add";
	if($action == "3" && $pmode == "1") {
		$auditMode = DB_AD_PERSONA_DETAIL_ACTION_EDIT;
		$auditType = "Edit";
	}

	$current = $GLOBALS['lDB']->get("
		SELECT
			*
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$lDB->escape($record)."'
	",1);

	$audit = new AuditTrail($record,TYPE_PERSONA);
	$changes = false;
	
	$oldId = $record;
	$newId = $record;
	if($auditMode == DB_AD_PERSONA_DETAIL_ACTION_ADD) {
		$oldId = "";
	}


	foreach($GLOBALS['personaFields'] as $field) {
		// Ignore disabled/unused fields
		if($field == "pr_persona_ix" || $field == "pr_persona_fwd_id" || $field == "rf_comms_preference_id") {
			continue;
		}
		if(
			($auditMode == DB_AD_PERSONA_DETAIL_ACTION_EDIT && isset($_POST[$field]) && $_POST[$field] != $current[$field])
			|| $auditMode == DB_AD_PERSONA_DETAIL_ACTION_ADD
		) {
			$changes = true;
			if($auditMode == DB_AD_PERSONA_DETAIL_ACTION_EDIT) {
				$oldValue = $current[$field];
				$newValue = $_POST[$field];
			} else {
				$oldValue = "";
				$newValue = $current[$field];
			}
			$audit->addDetail(
				$oldValue,
				$newValue,
				$oldId,
				$newId,
				$auditMode,
				"persona",
				"pr_persona.".$field
			);
		}
	}		
	foreach($telephoneAudit as $detail) {
		call_user_func_array([$audit,"addDetail"], $detail);
		$changes = true;
	}
	if ($changes) {
		$audit->save("Contact details ($auditType)");
	}
}

// Enable audit trail in edit-view(action=3,pmode=0) call when a new record has been saved. 
// This code *must* go after any check for this variable to work correctly.
if($action == "2" && $pmode == "1") {
	$GLOBALS['personaNew'] = true;
}
