<?php

/*
 * $Id: init.form183.php,v 1.31 2009-08-20 21:02:31 light Exp $
 *
 * $Log: init.form183.php,v $
 * Revision 1.31  2009-08-20 21:02:31  light
 * Bug #6909 - Extras Code Table - Export
 *
 * Revision 1.30  2009-05-04 12:31:59  light
 * Bug #6712 - Extend extras to cater for accommodation-type extras
 *
 * Revision 1.29  2009-04-14 12:18:36  light
 * Bug #6712 - Extend extras to cater for accommodation-type extras
 *
 * Revision 1.28  2009-04-14 08:12:35  light
 * Bug #4284 - [DB] Extend extras: ETA / Reference / Supplier
 *
 * Revision 1.27  2008-05-07 09:25:46  light
 * Fix to extras code table
 *
 * Revision 1.26  2008-02-29 12:38:12  light
 * Bug #5871 - Financial Interface
 *
 *
 */

/**
 * init.form183.php - Extras code table (list)
 * Job: 564,565,566,567,568,569
 * Function: 80 (Code Tables: Extras)
*/

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

$GLOBALS['temp']['imgSort1'] = "";
$GLOBALS['temp']['imgSort2'] = "";
$GLOBALS['temp']['imgSort3'] = "";
$GLOBALS['temp']['imgSort4'] = "";
$GLOBALS['temp']['imgSort5'] = "";
$GLOBALS['temp']['imgSort6'] = "";

$GLOBALS['temp']['imgSort1Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort2Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort3Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort4Mode'] = "std"; #(desc, desc)
$GLOBALS['temp']['imgSort5Mode'] = "std"; #(desc, asc)
$GLOBALS['temp']['imgSort6Mode'] = "std"; #(desc, desc)

$order = " asc";
if ($_SERVER['argv'][3] == "1") {
	$order = " desc";
}
$GLOBALS['temp']['sortType'] = $_SERVER['argv'][2];
$GLOBALS['temp']['sortOrder'] = $_SERVER['argv'][3];
$searchExtra = urldecode($_SERVER['argv'][5]);
switch ($_SERVER['argv'][2]) {
case 0:
	$orderbyfield = "ac_ext_desc";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort1Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort2Mode'] = "down"; #(desc, desc)
	}
	break;
case 1:
	$orderbyfield = "ac_extra_category_id";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort3Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort4Mode'] = "down"; #(desc, desc)
	}
	break;   
case 2:
	$orderbyfield = "ac_inactive_yn";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort5Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort6Mode'] = "down"; #(desc, desc)
	}      
	break;
case 3:
	$orderbyfield = "pr_name_first";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort7Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort8Mode'] = "down"; #(desc, desc)
	}      
	break;
case 4:
	$orderbyfield = "ac_ext_travel_eta";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort7Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort8Mode'] = "down"; #(desc, desc)
	}      
	break;
case 5:
	$orderbyfield = "ac_ext_travel_etd";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort9Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort10Mode'] = "down"; #(desc, desc)
	}      
	break;
case 6:
	$orderbyfield = "ac_extra_xref";
	if ($order == " asc") {
		$GLOBALS['temp']['imgSort11Mode'] = "down"; #(desc, asc)
	} else {
		$GLOBALS['temp']['imgSort12Mode'] = "down"; #(desc, desc)
	}      
	break;
}

$ac_extra_category_id = $_SERVER['argv'][4];
if($ac_extra_category_id == ""){
	$ac_extra_category_id = $GLOBALS['lDB']->get("SELECT ac_extra_category_ix FROM ac_extra_category LIMIT 1",4);
}
$GLOBALS['temp']['catId'] = $ac_extra_category_id;

if(checkjob("567") == true) {
	$selectjob = $sortjob = "567";
	if($record == "") {
		$sortjob = "565";
	}
} else {
	$selectjob = $sortjob = "564";
}

$GLOBALS['temp']['sortjob'] = $sortjob;

$tabHTML = Join("",File(__DIR__ . "/../../../public/html/code_extras_tabs.htm"));
$rowHtml = Join("",File(__DIR__ . "/../../../public/html/code_extras_rows.htm"));

$tabList = $GLOBALS['lDB']->get("
	SELECT 
		ac_extra_category.ac_extra_category_ix,
		ac_extra_category.ac_extra_cat_desc,
		ac_extra_category.ac_extra_category_inactive_yn,
		ac_extra_category.ac_extra_cat_ind
	FROM
		ac_extra_category
	ORDER BY
		ac_extra_category.ac_extra_cat_desc
",2);

$categoryDropDown = "";
$categoryDropDownHTML = "<tr><td class=\"imgLink\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"window.location='/reservation.php?!sortjob!+!record!+!sortType!+!sortOrder!+!ac_extra_category_ix!'\">!travelPic!&nbsp;!ac_extra_cat_desc!</td></tr>";

  
$cols = "";  
foreach($tabList as $item) {
	$item['record'] = $record;
	$item['sortjob'] = $sortjob;
	$item['sortType'] = $_SERVER['argv'][2];
	$item['sortOrder'] = $_SERVER['argv'][3];
	if($item['ac_extra_category_inactive_yn'] != 0) {
		$item['textClass'] = "txtg txti";
	} else {
		$item['textClass'] = "";
	}
	$item['travelPic'] = "";
	$ac_extra_cat_img = '';
	
	switch($item['ac_extra_cat_ind']) {
	case 1:
		$ac_extra_cat_img = "photo_camera";
		$item['travelClass'] = "bActivity";
		break;
	case 2:
		$ac_extra_cat_img = "flight";
		$item['travelClass'] = "bTravelNew";
		break;
	case 3:
		$ac_extra_cat_img = "pin_drop";
		$item['travelClass'] = "bAccomm";
		break;
	default:
		$ac_extra_cat_img = "collections";
		$item['travelClass'] = "bGeneral";
		break;
	}
	
	$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
	if($item['ac_extra_category_ix'] == $ac_extra_category_id) {
		if($item['textClass'] == "") {
			$item['textClass'] = "txtb";
		}
		$item['class'] = "collapse printCollapse";
		$GLOBALS['temp']['catName'] = $item['ac_extra_cat_desc'];
		$item['cursor'] = "default";
		$item['allowClick'] = "false";
		$item['activeTabId'] = "id='activeTab'";
		$GLOBALS['temp']['travelPic'] = "<i class='material-icons'>".$ac_extra_cat_img."</i>";
	} else {
		$item['class'] = "buttonLttTab $item[textClass] printCollapse";
		$itemp['cursor'] = "";    
		$item['allowClick'] = "true";
		$item['activeTabId'] = "";
	}
	
	$item['travelPic'] = "<i class='material-icons'>".$ac_extra_cat_img."</i>";
	$cols .= showpage($item,$tabHTML);

	if($item['ac_extra_category_ix'] != $ac_extra_category_id) {
		$categoryDropDown .= showpage($item,$categoryDropDownHTML);
	}
}
$GLOBALS['temp']['catTabs'] = $cols;
$GLOBALS['temp']['categoryDropDownList'] = $categoryDropDown;
$GLOBALS['temp']['clearSearch'] = "hidden";  
$GLOBALS['temp']['searchExtra'] = "*";
if($searchExtra == "") {
	$sqlWhere = "ac_extra.ac_extra_category_id = '$ac_extra_category_id'";
	$GLOBALS['temp']['hideTabs'] = "";
	$GLOBALS['temp']['searchExtra'] = "*";
} else {
	$GLOBALS['temp']['searchExtra'] = t_encodeHTMLField($searchExtra);
	$GLOBALS['temp']['checked'] = "checked";
	$GLOBALS['temp']['searchField'] = "visible";
	$GLOBALS['temp']['clearSearch'] = "visible";     
	$sqlWhere = "ac_extra.ac_ext_desc LIKE '".$lDB->like($searchExtra)."'";
	$GLOBALS['temp']['hideTabs'] = "style='display:none;'";     
}

if($_SERVER['argv'][6] != "") {
	$sqlWhere = " 1=1 ";
	$orderbyfield = "ac_extra_category.ac_extra_cat_desc";
	$order = "";
}

if($_SERVER['argv'][7] != "") {
	$sqlWhere = " ac_extra_category.ac_extra_category_inactive_yn = 0 ";
}

$list = $GLOBALS['lDB']->get("
	SELECT
		ac_extra.ac_extra_db,
		ac_extra.ac_extra_ix,
		ac_extra.ac_ext_amount,
		ac_extra.ac_ext_comm_pay,
		ac_extra.ac_ext_comm_rec,
		ac_extra.ac_ext_desc,
		ac_extra.ac_ext_travel_eta,
		ac_extra.ac_ext_travel_etd,
		ac_extra.ac_extra_xref,
		ac_extra.ac_ext_supplier_conf_yn,
		ac_extra.pr_supplier_id,
		ac_extra.ac_extra_category_id,
		ac_extra_category.ac_extra_cat_desc,
		ac_extra_category.ac_extra_category_inactive_yn,
		CONCAT_WS(' ',pr_persona.pr_name_first,pr_persona.pr_name_last) AS supplier_name,
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		rf_currency.rf_currency_inactive_yn,
		rf_tax_rate.rf_tax_rate_ix,
		rf_tax_rate.rf_tax_rate_perc,
		ac_extra.rf_tax_ind,
		rf_tax_rate.rf_tax_rate_inactive_yn,
		ac_extra.ac_inactive_yn,
		ac_extra.ac_ext_note,
		ac_extra.ac_ext_note_internal,
		ac_extra.ac_extra_external_yn,
		ac_extra.ac_extra_db,
		ac_extra.ac_ext_colour,
		ac_extra.rf_tax_id
	FROM
		ac_extra
		INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = ac_extra.rf_currency_id
		LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra.pr_supplier_id
	WHERE
		$sqlWhere
	ORDER BY 
		$orderbyfield $order
",2);

foreach($list as $key => $item) {
	if ($item['rf_tax_ind'] == 20) {
		$taxPercent = $lDB->get("
			SELECT
				SUM(rf_tax_rate.rf_tax_rate_perc)
			FROM
				ac_extra
				LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = ac_extra.rf_tax_id
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
			WHERE
				ac_extra_ix = '".$item['ac_extra_ix']."'
		",4);
		$list[$key]['rf_tax_rate_perc'] = $taxPercent;
		$taxGroupStatus = $lDB->get("
			SELECT 
				`rt_tax_group_inactive_yn` 
			FROM `rt_tax_group` 
			WHERE 
				`rt_tax_group_ix` = '".$item['rf_tax_id']."'
		",4);
		$list[$key]['rf_tax_rate_inactive_yn'] = $taxGroupStatus;
	}
}

if($_SERVER['argv'][6] != "") {
    $XLSX = false;
	if($_SERVER['argv'][6] == 2) {
		$reportName = "extras_code_table.xml"; 
		$repType = "xml";
	} else {
		$reportName = "extras_code_table.xlsx"; 
		$repType = "xls";
        $XLSX = true;
	}
	$newList = array();
	foreach($list as $item) {
		if(!isset($newList[$item['ac_extra_category_id']])) {
			$newList[$item['ac_extra_category_id']] = array();
		}
		array_push($newList[$item['ac_extra_category_id']], $item);
	}
	
	$catCount = 1;
	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

	$defaultStyle = array( 
					'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
					'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT, $borderB),
					'font' => array('Size' => '8')
					);
	$xls = new XLS($defaultStyle);

    $XLSXWriter = new XLSXWriter();
    $XLSXWriter->setAuthor('ResRequest');

	$headerStyle = array( 
					'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
					'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT, $borderB),
					'font' => array('Size' => '8', 'Bold' => '1')
					);
	$headerStyleId = $xls->addStyle($headerStyle);

	$inactiveStyle = array( 
					'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
					'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
					'border' => array($borderL, $borderR, $borderT, $borderB),
					'font' => array('Size' => '8', 'Color' => '#999999', 'Italic' =>'1')
					);
	$inactiveStyleId = $xls->addStyle($inactiveStyle);

    $XLSXDefaultStyle = array(
        'halign'=>'left',
        'valign'=>'top',
        'wrap_text'=>1,
        'font-size'=>8
    );

    $XLSXHeaderStyle = array(
        'halign'=>'left',
        'valign'=>'top',
        'wrap_text'=>1,
        'fill'=>'#ffffff',
        'border'=>'left,right,top,bottom',
        'font-size'=>8,
        'font-style'=>'bold'
    );

    $XLSXInactiveStyle = array(
        'halign'=>'left',
        'valign'=>'top',
        'wrap_text'=>1,
        'font-size'=>8,
        'color'=>'#999999',
        'font-style'=>'italic'
    );

	foreach($newList as $listArr) {
        $worksheetXLSX = array();
		$cells = array();
		$rows = array();
		$tables = array();
		$tempCell = array();
		$xls->Column(120, $catCount);
		$xls->Column(100, $catCount);
		$xls->Column(70, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(80, $catCount);
		$xls->Column(80, $catCount);
		$xls->Column(130, $catCount);
		$xls->Column(130, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		$xls->Column(40, $catCount);
		
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Description'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Category'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Service By'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'ETA'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'ETD'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Reference'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Property'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Note'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Internal Memo'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Comm. rec'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Comm. pay'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Amount'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Curr'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Tax rate'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Ext'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'POS'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Colour'),$headerStyleId);
		array_push($cells, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data'=>'Inactive'),$headerStyleId);
		array_push($cells, $cell);
		
		$row = $xls->Row($cells);
		array_push($rows,$row);
		$cells = array();

        // XLSX
        $headerXLSX = array(
            'Description'=>'string',
            'Category'=>'string',
            'Service By'=>'string',
            'ETA'=>'string',
            'ETD'=>'string',
            'Reference'=>'string',
            'Property'=>'string',
            'Note'=>'string',
            'Internal Memo'=>'string',
            'Comm. rec'=>'string',
            'Comm. pay'=>'string',
            'Amount'=>'string',
            'Curr'=>'string',
            'Tax rate'=>'string',
            'Ext'=>'string',
            'POS'=>'string',
            'Colour'=>'string',
            'Inactive'=>'string');

		foreach($listArr as $item) {
			$propertyList = $GLOBALS['lDB']->get("
				SELECT
					pr_persona.pr_name_last as name                      
				FROM
					ac_extra_prop
					LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra_prop.pr_business_id 
				WHERE
					ac_extra_prop.ac_extra_id = '$item[ac_extra_ix]'
			",3);
			foreach($propertyList as $propertyKey=>$propertyItem) {
				if(trim($propertyItem) == "") {
					$propertyList[$propertyKey] = "Not property specific";
				}
			}
			$item['ac_ext_property'] = join("&#10;",$propertyList);

			if(empty($item['supplier_name'])) {
				$item['supplier_name'] = "";
			}

			$POSCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_pos_stock WHERE ac_extra_id = '$item[ac_extra_ix]'",4);
			if($POSCount > 0) {
				$item['ac_extra_pos_yn'] = "Yes";
			} else {
				$item['ac_extra_pos_yn'] = "";
			}

			if($item['ac_extra_category_inactive_yn'] != "0"){
				$styleId = $inactiveStyleId;
			} else {
				$styleId = "";
			}
			
			$currStyleId = "";
			if($item['rf_currency_inactive_yn'] != "0") {
				$currStyleId = $inactiveStyleId;
			}

			$taxStyleId = "";
			if($item['rf_tax_rate_inactive_yn'] != "0") {
				$taxStyleId = $inactiveStyleId;
			}

			if($item['rf_currency_ix'] == "") {
				$item['ac_ext_amount'] = "No Charge";
				$item['rf_tax_rate_perc'] = "";
			} else {
				$item['rf_tax_rate_perc'] = $item['rf_tax_rate_perc'] . "%";
			}

			if($item['ac_extra_external_yn'] == "1") {
				$item['ac_extra_external_yn'] = "Yes";
			} else {
				$item['ac_extra_external_yn'] = "";
			}
			
			if($item['ac_inactive_yn'] != "0") {
				$item['ac_inactive_yn'] = "yes";
			} else {
				$item['ac_inactive_yn'] = "";
			}

			$colorStyleId = "";
			if($item['ac_ext_colour'] != "") {
				$colorStyle = array( 
						'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
						'interior' => array('Color' => $item['ac_ext_colour'], 'Pattern'=>'Solid'),
						'border' => array($borderL, $borderR, $borderT, $borderB),
						'font' => array('Size' => '8', 'Color' => '#999999')
						);
				$colorStyleId = $xls->addStyle($colorStyle);
			}

			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_desc']), $styleId);
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_extra_cat_desc']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['supplier_name']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_travel_eta']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_travel_etd']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_extra_xref']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_property']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_note']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_note_internal']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_comm_rec']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_comm_pay']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_ext_amount']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['rf_currency_symbol']), $currStyleId);
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['rf_tax_rate_perc']), $taxStyleId);
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_extra_external_yn']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_extra_pos_yn']));
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>""), $colorStyleId);
			array_push($cells, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data'=>$item['ac_inactive_yn']));
			array_push($cells, $cell);
		
			$row = $xls->Row($cells);
			array_push($rows,$row);
			$cells = array();

            // XLSX
            $worksheetXLSX[] = array(
                $item['ac_ext_desc'],
                $item['ac_extra_cat_desc'],
                $item['supplier_name'],
                $item['ac_ext_travel_eta'],
                $item['ac_ext_travel_etd'],
                $item['ac_extra_xref'],
                $item['ac_ext_property'],
                $item['ac_ext_note'],
                $item['ac_ext_note_internal'],
                $item['ac_ext_comm_rec'],
                $item['ac_ext_comm_pay'],
                $item['ac_ext_amount'],
                $item['rf_currency_symbol'],
                $item['rf_tax_rate_perc'],
                $item['ac_extra_external_yn'],
                $item['ac_extra_pos_yn'],
                "",
                $item['ac_inactive_yn']
            );
		}

		$table = $xls->Table($rows);
		array_push($tables, $table);

		$xls->Worksheet($tables,$catCount, $item['ac_extra_cat_desc']);
		$catCount++;

        if ($XLSX) {
            $XLSXWriter->writeSheetHeader($item['ac_extra_cat_desc'], $headerXLSX, $XLSXHeaderStyle);
            foreach($worksheetXLSX as $row) {
                $row = str_replace("&#10;", "\n", $row);
                $style = $row[17] == "yes" ? $XLSXInactiveStyle : $XLSXDefaultStyle; // Inactive
                $XLSXWriter->writeSheetRow($item['ac_extra_cat_desc'], $row, $style);
            }
        }
	}

    if ($XLSX) {
        header('Content-Disposition: attachment; filename='.$reportName);
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Transfer-Encoding: binary');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Description: File Transfer');
        header('Expires: 0');
        $XLSXWriter->writeToStdOut();
        exit();
    } else {
        $xls->genrateWorkbook($reportName, $repType);
    }
}


$GLOBALS['temp']['rowCount'] = sizeof($list);
$GLOBALS['temp']['hideCollapse'] = "txtbbr imgLink";
if(sizeof($list) > 0) {
	$rows = "";
	$count = 0;
	foreach($list as $item) {
		if(canEditDB($item['ac_extra_db'])) {
			$item['canEdit'] = "";
			$item['rowClass'] = "linkrow";
			$item['itemClass'] = "";
		} else {
			$item['canEdit'] = "return;";
			$item['rowClass'] = "";
			$item['itemClass'] = "txtg";
		}
		$item['selectjob'] = $selectjob;
		$item['sortType'] = $_SERVER['argv'][2];
		$item['sortOrder'] = $_SERVER['argv'][3];
		$item['searchExtra'] = $searchExtra;            
		
		$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
		$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
		$item['ac_extra_xref'] = t_encodeHTMLField($item['ac_extra_xref']);
		if ($item['ac_extra_ix'] != $record ) {
			if(canEditDB($item['ac_extra_db'])) {
				$item['ac_ext_desc'] = "<span id='extra$count'>$item[ac_ext_desc]</span>";
			} else {
				$item['ac_ext_desc'] = "<span class='txtg' id='extra$count'>$item[ac_ext_desc]</span>";
			}
		}
		$item['inactiveCat'] = "";
		if($item['ac_extra_category_inactive_yn'] != "0"){
			$item['inactiveCat'] = "txtg txti";
			$GLOBALS['temp']['inactiveCat'] = "txtg txti";
		}
		$propertyList = $GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_name_last as name                      
			FROM
				ac_extra_prop
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra_prop.pr_business_id 
			WHERE
				ac_extra_prop.ac_extra_id = '$item[ac_extra_ix]'
		",3);
		foreach($propertyList as $propertyKey=>$propertyItem) {
			if(trim($propertyItem) == "") {
				$propertyList[$propertyKey] = "Not property specific";
			} else {
				$propertyList[$propertyKey] = t_encodeHTMLField($propertyItem);
			}
		}
		$item['ac_ext_property'] = join("<br />",$propertyList);

		$item['showNote'] = "";
		if(trim($item['ac_ext_note']) == "") {
			$item['showNote'] = "style=\"display:none\"";
		}
		$item['showIntNote'] = "";
		if(trim($item['ac_ext_note_internal']) == "") {
			$item['showIntNote'] = "style=\"display:none\"";
		}
		
		$item['ac_ext_note'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['ac_ext_note'])));
		$item['ac_ext_note_internal'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['ac_ext_note_internal'])));
		$item['rf_currency_symbol'] = t_encodeHTMLField($item['rf_currency_symbol']);

		if(empty($item['supplier_name'])) {
			$item['supplier_name'] = "";
		} else {
			$item['supplier_name'] = t_encodeHTMLField($item['supplier_name']);
		}

		$item['inactiveCurr'] = "";
		if($item['rf_currency_inactive_yn'] != "0") {
			$item['inactiveCurr'] = "txtg txti";
		}
		$item['inactiveTax'] = "";
		if($item['rf_tax_rate_inactive_yn'] != "0") {
			$item['inactiveTax'] = "txtg txti";
		}

		if($item['rf_currency_ix'] == "") {
			$item['ac_ext_amount'] = "No Charge";
			$item['rf_tax_rate_perc'] = "";
		} else {
			$item['rf_tax_rate_perc'] = $item['rf_tax_rate_perc'] . "%";
		}

		if($item['ac_extra_external_yn'] == "1") {
			$item['ac_extra_external_yn'] = "<img src=\"/resource/Resrequest/Application/public/img/tick.gif\">";
		} else {
			$item['ac_extra_external_yn'] = "";
		}
		
		$POSCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ac_pos_stock WHERE ac_extra_id = '$item[ac_extra_ix]'",4);
		if($POSCount > 0) {
			$item['ac_extra_pos_yn'] = "<img src=\"/resource/Resrequest/Application/public/img/tick.gif\">";
		} else {
			$item['ac_extra_pos_yn'] = "";
		}
		
		if($item['ac_inactive_yn'] != "0") {
			$item['ac_inactive_yn'] = "<img src=\"/resource/Resrequest/Application/public/img/tick.gif\">";
		} else {
			$item['ac_inactive_yn'] = "";
		}

		$rows .= showpage($item,$rowHtml);
		$count++;
	}
	$GLOBALS['temp']['rows'] = $rows;
} else {
	if($searchExtra != "") {
		$GLOBALS['temp']['rows'] = '
			<tr style="height: 25px;">
				<td colspan="19" class="colWh br bl" align="center">
					There are no records that match your search
				</td>
			</tr>
		';
	} else {
		$GLOBALS['temp']['rows'] = '
			<tr style="height: 25px;">
				<td colspan="19" class="colWh br bl" align="center">
					There are no records for this category
				</td>
			</tr>
		';
	}
	$GLOBALS['temp']['hideCollapse'] = "collapse";
}

?>
