<?php

/**
 * Form 196 - The Extras Maintainance Form
 */

if (isset($_POST['action']) && $_POST['action'] == "checkExtraTimestamp") {
    if (!isset($_POST['rv_extra_id']) || $_POST['rv_extra_id'] == "") {
        die;
    }
    $response = array();
    $extra = $GLOBALS['lDB']->get("
        SELECT
            rv_extra_timestamp,
            rv_extra.ad_modify_user_id AS modifyUser,
            fn_folio.fn_folio_status_ind AS invoiced
        FROM
            rv_extra
            LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
        WHERE
            rv_extra_ix = '" . $_POST['rv_extra_id'] . "'
    ",1);

    if ($extra['invoiced'] != 0) {      // Folio has been invoiced while Extra being edited
        $response['message'] = "<div>This folio has been invoiced, thus this Extra can not be saved.</div>";
        $response['status'] = false;
        $response['error'] = 'invoiced';
        echo json_encode($response, true);
        die;
    }

    $lastEditExpected = new DateTime($_POST['rv_extra_timestamp']);
    $lastEditReality = new DateTime($extra['rv_extra_timestamp']);
    $interval = $lastEditReality->diff($lastEditExpected);
    $timeDiff = $interval->format('%H%i%s');

    if ($timeDiff == "0000") {
        $response['status'] = true;     // All good
    } else {    // Someone has edited this extra behind our backs, gather and return the details
        $now = new DateTime();
        $interval = $lastEditReality->diff($now);
        $time = "";
        if ($interval->format('%H') != 0) {
            $time .= $interval->format('%H') . "h ";
        }
        if ($interval->format('%i') != 0) {
            $time .= $interval->format('%i') . "mins ";
        }
        if ($interval->format('%s') != 0) {
            $time .= $interval->format('%s') . "s ";
        }
        $response['message'] = "<div>This extra has been edited by " . db_per_persona_get_name($extra['modifyUser']) . " " . $time . "ago, and can not be saved.</div><p>Discard all changes and reload?</p>";
        $response['status'] = false;
        $response['error'] = 'edited';
    }

    echo json_encode($response, true);
    die;
}

if (isset($_POST['action']) && $_POST['action'] == "refreshExtraData") {
    if (!isset($_POST['rv_extra_id']) || $_POST['rv_extra_id'] == "") {
        die;
    }
    $extra = $GLOBALS['lDB']->get("
        SELECT
            rv_extra.rv_extra_date_serv,
            ac_extra.ac_ext_desc,
            ac_extra_category.ac_extra_cat_desc,
            pr_persona.pr_name_last,
            rv_extra.rv_extra_units,
            ac_extra_category.ac_extra_cat_ind,
            rv_extra.rv_extra_supplier_conf_yn,
            rv_extra.pr_supplier_id,
            CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
            rv_extra.rv_extra_charge,
            rv_extra.rv_extra_tax_perc,
            rv_extra.rf_tax_id,
            rv_extra.rv_extra_tax_ind,
            rv_extra.rv_extra_discount,
            rv_extra.rv_extra_comm_rec,
            rv_extra.rv_extra_comm_pay,
            rv_extra.rf_currency_id as extra_currency_id,
            rv_extra.rv_extra_inv_curr_id as folio_currency_id,
            from_currency.rf_currency_symbol as extra_currency_symbol,
            to_currency.rf_currency_symbol as folio_currency_symbol,
            rv_extra.rv_extra_exch_rate,
            rv_extra.rv_extra_exch_expiry,
            rv_extra.fn_folio_id,
            fn_folio.fn_folio_folio_num,
            ac_extra.ac_extra_ix,
            pr_persona.pr_persona_ix,
            rv_res_item_group.rv_res_item_group_ix AS rv_res_item_group_id,
            rv_extra.pr_business_id,
            rv_extra.rv_extra_adult_count,
            rv_extra.rv_extra_child_count,
            rv_extra.rv_extra_nights,
            rv_extra.rv_extra_date_depart,
            rv_extra.rv_extra_timestamp,
            ac_accomm_room.ac_desc       
        FROM
            rv_extra
            INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
            INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
            LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_extra.pr_business_id
            LEFT JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rv_extra.rf_currency_id
            LEFT JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rv_extra.rv_extra_inv_curr_id
            LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_extra.rv_res_item_group_id
            LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
            LEFT JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
            LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = rv_extra.pr_supplier_id
        WHERE
            rv_extra.rv_extra_ix = '" . $_POST['rv_extra_id'] . "'
    ",1);

	$extra['rv_extra_exch_rate'] = trimExchangeRate($extra['rv_extra_exch_rate']);

    // Find the billing entity
    $businessId = "";
    $currId = $extra['pr_business_id'];
    while($businessId == "" && $currId != "0" && trim($currId) != "") {
        if(!$GLOBALS['isPropServer']) {
            $billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
        } else {
            $billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
        }
        if($billingYN == "1") {
            $businessId = $currId;
        } else {
            $currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
        }
    }
    $extra['billing_entity_id'] = $businessId;

    $guestList = $GLOBALS['lDB']->get("
        SELECT
            pr_persona.pr_name_first,
            pr_persona.pr_name_last
        FROM
            rv_res_item_guest
            INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id AND rv_res_item_guest.rv_res_item_group_id != ''
        WHERE
            rv_res_item_guest.rv_res_item_group_id = '$extra[rv_res_item_group_id]'
    ",2);

    $roomInfo = trim($extra['ac_desc']);
    $guestNames = "";
    foreach($guestList as $guestItem) {
        if($guestNames != "") {
            $guestNames .= ", ";
        }
        $guestNames .= trim($guestItem['pr_name_first'] . " " . $guestItem['pr_name_last']);
    }
    if($roomInfo != "" && $guestNames != "") {
        $roomInfo .= ": ";
    }
    if($guestNames != "") {
        $roomInfo .= $guestNames;
    }
    $extra['roomInfo'] = $roomInfo;

    echo json_encode($extra);
    die;
}

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/reservation_extras.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$resId = $_SERVER['argv'][1]; // Reservation Number
addLastRes($resId);
$extraId = $_SERVER['argv'][2]; // Current Extra Id

$wetu = new Wetu($record, $GLOBALS['lDB']);
$GLOBALS['temp']['wetuDropdownOptions'] = $wetu->GenerateButtontext();

$GLOBALS['temp']['commissionLabel'] = commissionLabel();

// Check if user is allowed to do cross invoicing
$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_cross_invoice_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);
$GLOBALS['temp']['sc_grp_cross_invoice_yn'] = $sc_grp_cross_invoice_yn ? "true" : "false";

# Display/hide notes icon
$GLOBALS['temp']['nflag'] = "noNotes";
$sql = "select rv_note_general from rv_reservation where rv_reservation_ix = '$record'";
$nflag = $GLOBALS['lDB']->get($sql,4);

$sql = "select rv_note_internal from rv_reservation where rv_reservation_ix = '$record'";
$iflag = $GLOBALS['lDB']->get($sql, 4);
   
$sql = "select rv_note_guests from rv_reservation where rv_reservation_ix = '$record'";
$gflag = $GLOBALS['lDB']->get($sql, 4);

if ($_SESSION['userStatusId'] > 1 && $GLOBALS['jobLevelArray'][$_SERVER['argv'][0]] > 5) { //security?
	$GLOBALS['temp']['hideAdd'] = "";
	$GLOBALS['temp']['showDeleteButton'] = "expand";
	$GLOBALS['temp']['hideDelete'] = "button bDelete";
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($iflag)) > 0) || (strlen(trim($gflag)) > 0))) {
		$GLOBALS['temp']['nflag'] = "notes";
	}  
}else{
	$GLOBALS['temp']['hideAdd'] = "collapse";
	$GLOBALS['temp']['showDeleteButton'] = "collapse printCollapse";
	$GLOBALS['temp']['hideDelete'] = "collapse";
	if (((strlen(trim($nflag)) > 0) || (strlen(trim($gflag)) > 0))) {
		$GLOBALS['temp']['nflag'] = "notes";
	}
}
   
$GLOBALS['temp']['eflag'] = "noExtras";
$sql = "SELECT COUNT(*) FROM rv_extra WHERE rv_reservation_id = '$record'";
$eflag = $GLOBALS['lDB']->get($sql, 1);
if ($eflag[0] > 0) {
	$GLOBALS['temp']['eflag'] = "";
}

   $GLOBALS['temp']['rtabflag'] = "";
   $rtabflag = getReservationRooming($record);      
   if(sizeof($rtabflag['guests']) > 0 || sizeof($rtabflag['rooms']) > 0){
	   $GLOBALS['temp']['rtabflag'] = "signal_cellular_4_bar";
   }
   $commsql = "SELECT COUNT(*) FROM em_mail INNER JOIN em_mail_log ON em_mail.em_mail_ix = em_mail_log.em_mail_id WHERE em_action = '-1' AND rv_reservation_id LIKE '$record'";
   $ctabflag = $GLOBALS['lDB']->get($commsql,4);
	  $commProvCheck = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM ad_reservation WHERE ad_reservation.rv_reservation_id LIKE '$record' AND ad_reservation.ad_res_form = 'Sent Prov Notification'",4);
   $GLOBALS['temp']['ctabflag'] = "";
   if($ctabflag > 0 || $commProvCheck > 0){
   	 $GLOBALS['temp']['ctabflag'] = "bEmail";
   }

$remSQL = "SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id  = '{$record}'";
$GLOBALS['temp']['retabflag'] = ($GLOBALS['lDB']->get($remSQL,4) > 0 ) ? "show" : "";


$roomCheckIn = $GLOBALS['lDB']->get("
   	SELECT 
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '5'
	",4);
	$roomCheckOut = $GLOBALS['lDB']->get("
   	SELECT 
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$record'
		AND rv_res_item_group.rv_grp_status_ind = '8'
	",4);

	$GLOBALS['temp']['rflag'] = "bRoomNone";
	if($roomCheckIn > 0 || $roomCheckOut > 0) {
		$roomCheckTime = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_group.rv_grp_status_time
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = '$record'
				AND (
					rv_res_item_group.rv_grp_status_ind = '5'
					OR rv_res_item_group.rv_grp_status_ind = '8'
				)
			ORDER BY
				rv_res_item_group.rv_grp_status_time DESC
		",4);
	}
	if($roomCheckIn > 0) {
		$GLOBALS['temp']['rflag'] = "bRoomIn";
	}
	if($roomCheckOut > 0) {
		$GLOBALS['temp']['rflag'] = "bRoomOut";
	}

$GLOBALS['temp']['errorMsg'] = isset($_SESSION['errorMsg'])?$_SESSION['errorMsg']:"";
session_set("errorMsg",null);

// Details for the Itinerary Summary Popup in functions.reservation.php
getItinSummary($record);

$GLOBALS['temp']['resId'] = $resId;
$resInfo = $GLOBALS['lDB']->get("
	SELECT
		rv_res_name,
		pr_create.pr_name_last as create_name_last,
		pr_create.pr_name_first as create_name_first,
		rv_date_recorded,
		rv_date_changed,
		rv_date_arrive
	FROM
		rv_reservation
		LEFT JOIN pr_persona AS pr_create ON pr_create.pr_persona_ix = rv_reservation.pr_reservation_user_id 
	WHERE
		rv_reservation_ix = '$resId'
",1);
$GLOBALS['temp']['rv_res_name'] = $resInfo['rv_res_name'];
$resPersonaName = trim($resInfo['create_name_first'] . " " . $resInfo['create_name_last']); 
if(trim($resPersonaName) == "") {
	$resPersonaName = "N/A";
}
$GLOBALS['temp']['user_created'] = $resPersonaName;
$GLOBALS['temp']['date_create'] = chng_date($resInfo['rv_date_recorded'],"-");
$GLOBALS['temp']['date_ammend'] = chng_date($resInfo['rv_date_changed'],"-");
$GLOBALS['temp']['rv_date_arrive'] = $resInfo['rv_date_arrive'];
$GLOBALS['temp']['auditCurrentDate'] = date("Ymd");
//Reservation Status
$resStatus = $GLOBALS['lDB']->get("SELECT 
  rf_reservation_status.rf_reservation_status_id as resStatusId,
  rf_reservation_status.rf_reservation_status_desc as resStatusDesc
	FROM 
	rv_reservation
	INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id 
	WHERE 
	rv_reservation.rv_reservation_ix = '$record'
",1);
$GLOBALS['temp']['statusDesc'] = $resStatus['resStatusDesc'];
$GLOBALS['temp']['statusClass'] = "txt";
if($resStatus['resStatusId'] == "90"){
  $GLOBALS['temp']['statusClass'] = "txtb";
}
if($resStatus['resStatusId'] == "20"){
  $expDate = $lDB->get("SELECT
	    rv_provision_expiry_date
			FROM
			rv_reservation
			WHERE
			rv_reservation_ix = '$record'
	 ",4);

    $today = date("Y-m-d");
    if ($today == $expDate) {
      $GLOBALS['temp']['provBg'] = "#F1C55D";
		  $GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
    } elseif ($today > $expDate) {
      $GLOBALS['temp']['provBg'] = "#DB4242";
		  $GLOBALS['temp']['statusDesc'] .= " (Expires: ".chng_date($expDate, "-").")";
    }
}

if($action == ACT_DELETE) {
	if(isset($_POST['extraDelete'])) {
		$extraList = explode(":",$_POST['extraDelete']);
		foreach($extraList as $item) {
			if(!db_rv_extra_delete($item,$_POST['auditReason'])) {
				session_set("errorMsg",$GLOBALS['db_rv_extra_error']);
			}
		}
	}
} else {
	if ($pmode == 1 && $_SERVER['REQUEST_METHOD'] === 'POST') {
		// Ignore passed percentage, look up percentage from Tax Code Table
		$taxPerc = taxPercentage($_POST['rf_tax_rate'], $_POST['rf_tax_ind']);
		
		$_POST['exchangeRate'] = trimExchangeRate($_POST['exchangeRate']);
		$_POST['rv_extra_charge'] = isset($_POST['rv_extra_charge'])?$_POST['rv_extra_charge']:"";
		$_POST['rv_extra_discount'] = isset($_POST['rv_extra_discount'])?$_POST['rv_extra_discount']:"";
		$_POST['rv_extra_tax_perc'] = isset($_POST['rv_extra_tax_perc'])?$_POST['rv_extra_tax_perc']:"";
		$_POST['rv_extra_comm_rec'] = isset($_POST['rv_extra_comm_rec'])?$_POST['rv_extra_comm_rec']:"";
		$_POST['rv_extra_comm_pay'] = isset($_POST['rv_extra_comm_pay'])?$_POST['rv_extra_comm_pay']:"";
		if ( $extraId == "" ) { // new
			$extraId = db_rv_extra_insert($resId, $_POST['ac_extra_id'], $_POST['pr_business_id'], $_POST['rv_extra_units'], $_POST['rv_extra_date_serv'], $_POST['rv_extra_charge'], $_POST['rv_extra_discount'], $taxPerc,  $_POST['rv_extra_comm_rec'], $_POST['rv_extra_comm_pay'], $_POST['rv_extra_note'], $_POST['rv_extra_note_internal'], $_POST['rv_res_item_group_id'], $_POST['extra_currency_id'], $_POST['folio_currency_id'], $_POST['exchangeRate'], $_POST['rv_extra_exch_expiry'] , $_POST['folio_business_id'], $_POST['rv_extra_travel_eta'], $_POST['rv_extra_travel_etd'], $_POST['rv_extra_adult_count'], $_POST['rv_extra_child_count'], $_POST['rv_extra_date_depart'], $_POST['rv_extra_ref'], $_POST['rv_extra_supplier_conf_yn'], $_POST['pr_supplier_id']);
			db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rf_tax_rate']);
		} else { // update 
			db_rv_extra_update($extraId, $_POST['rv_extra_units'], $_POST['rv_extra_date_serv'], $_POST['rv_extra_charge'], $_POST['rv_extra_discount'], $taxPerc,  $_POST['rv_extra_comm_rec'], $_POST['rv_extra_comm_pay'], $_POST['rv_extra_note'], $_POST['rv_extra_note_internal'], $_POST['rv_res_item_group_id'], $_POST['extra_currency_id'], $_POST['folio_currency_id'], $_POST['exchangeRate'], $_POST['rv_extra_exch_expiry'], $_POST['folio_business_id'], $_POST['auditReason'], $_POST['rv_extra_travel_eta'], $_POST['rv_extra_travel_etd'], $_POST['rv_extra_adult_count'], $_POST['rv_extra_child_count'], $_POST['rv_extra_date_depart'],$_POST['rv_extra_ref'], $_POST['rv_extra_supplier_conf_yn'], $_POST['pr_supplier_id']);
			db_rv_extra_tax_insert($extraId, $_POST['rf_tax_ind'], $_POST['rf_tax_rate']);
		}
		verify_extra($extraId);
		
		if ( $_POST['fn_folio_id'] == "" || $_POST['fn_folio_id'] == "1" ) {
			$folioId = db_fn_folio_insert_extra($extraId, $_POST['fn_folio_group_id'],$_POST['fn_folio_to_id'], true);
		} else {
			$folioId = $_POST['fn_folio_id'];
		}
	
		if ( $folioId != "2" ) { // No folio (zero cost extra)
			$oldFolioId = $GLOBALS['lDB']->get("SELECT fn_folio_id FROM rv_extra WHERE rv_extra_ix = '$extraId'",4);
			$totalCount = 0;
			$paymentTotal = 0;
			if($folioId != $oldFolioId) {
				$resItemCount = $GLOBALS['lDB']->get("
					SELECT
						COUNT(rv_reservation_item_ix)
					FROM
						rv_reservation_item
					WHERE
						fn_folio_id = '$oldFolioId'
				",4);
				$extraCount = $GLOBALS['lDB']->get("
					SELECT
						COUNT(rv_extra_id)
					FROM
						rv_extra
					WHERE
						fn_folio_id = '$oldFolioId'
						AND rv_extra.rv_extra_ix <> '$extraId'
				",4);
				$totalCount = $resItemCount + $extraCount;
				$paymentTotal = $GLOBALS['lDB']->get("
					SELECT
						SUM(rv_payment_item_amt)
					FROM
						rv_payment_item
					WHERE
						fn_folio_id = '$oldFolioId'
				",4);
			}
			if($totalCount == 0 && $paymentTotal != 0 && $folioId != $oldFolioId) {
				session_set("errorMsg","Any other changes you made have been saved, but the extra could not be allocated to the requested folio due to a payment amount on the existing folio.");
			} else {
				db_rv_extra_set_folio($extraId, $folioId);
			}
		}
		db_rf_exchange_rate_set($_POST['extra_currency_id'],$_POST['folio_currency_id'],$_POST['exchangeRate']);
	}
}

$folioList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio_ix,
		fn_folio_folio_num,
		pr_invoice.pr_name_last as invoice_name_last,
		pr_invoice.pr_name_first as invoice_name_first,
		pr_invoice.pr_persona_ix as invoice_ix,
		rf_title.rf_title_desc,
		rf_name_suffix.rf_suffix_desc,
		business.pr_name_last as businessName,
		business.pr_persona_ix as billing_unit_id,
		rf_currency.rf_currency_ix,
		rf_currency.rf_currency_symbol,
		ac_accomm_room.ac_desc,
		fn_folio.rv_res_item_group_id
	FROM
		fn_folio
		LEFT JOIN pr_persona AS pr_invoice ON pr_invoice.pr_persona_ix = fn_folio.fn_folio_to_id
    LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_invoice.pr_title_id
    LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_invoice.pr_name_suffix_id
		LEFT JOIN pr_persona AS business ON business.pr_persona_ix = fn_folio.pr_business_id    
		LEFT JOIN rf_currency ON rf_currency.rf_currency_ix = fn_folio.rf_currency_id
		LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_id = '$resId'
		AND fn_folio.fn_folio_db IN ('".join("','",getDBCodes())."')
		AND (
			fn_folio.fn_invoice_id IS NULL 
			OR fn_folio.fn_invoice_id = '0'
			OR fn_folio.fn_invoice_id = ''
		)
	ORDER BY
		fn_folio.fn_folio_folio_num + 0
		
",2);

$folioRows = "";
foreach($folioList as $item) {
	$to = trim($item['invoice_name_last']);
	if($item['rf_suffix_desc'] != "") {
		if(trim($to) != "") {
			$to .= " ";
		}
		$to .= $item['rf_suffix_desc'];
	}
  if(trim($item['invoice_name_first']) != ""){
		if(trim($to) != "") {
			$to .= ", ";
		}
		$to .= trim($item['invoice_name_first']);
  }
  if($item['rf_title_desc'] != "") {
		if(trim($to) != "") {
			$to .= " ";
		}
		$to .= $item['rf_title_desc'];
	} 
	if($to == "") {
		$to = "Cash";
	}
	if($to == "") {
		$to = "&nbsp;";
	}
	$room = trim($item['ac_desc']);
	if($room == "") {
		$room = "&nbsp;";
	}
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_id]' 
			AND '$item[rv_res_item_group_id]' != ''
	",2);
	$guestNames = "";
	foreach($guestList as $guestItem) {
		if($guestNames != "") {
			$guestNames .= "<BR>";
		}
		$guestNames .= $guestItem['pr_name_last'];
		if(trim($guestItem['pr_name_first']) != "") {
			$guestNames .= ", " . $guestItem['pr_name_first'];
		}
	}
	if($guestNames == "") {
		$guestNames = "&nbsp;";
	}
	$to = t_encodeOverlib($to);
	$folioRoom = $GLOBALS['lDB']->get("
		SELECT
			ac_desc
		FROM
			fn_folio
			LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = fn_folio.rv_res_item_group_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			fn_folio_ix = '$item[fn_folio_ix]'
	",4);
	if(trim($folioRoom) != "" && $folioRoom != "0") {
		$folioRoom = $folioRoom . ", ";
	} else {
		$folioRoom = "";
	}
	$folioRows .= "
		<tr class=\"imgLink\" billing_unit_id=\"$item[billing_unit_id]\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\"  onmouseout=\"this.style.backgroundColor = ''\" onclick=\"selectFolio(event,'$item[fn_folio_ix]','$item[fn_folio_folio_num]: $folioRoom$to','$item[rf_currency_ix]','$item[rf_currency_symbol]', '$item[invoice_ix]','$to','$item[rv_res_item_group_id]','$item[ac_desc]');\">
			<td class=\"br\" valign=\"top\" align=\"center\">$item[fn_folio_folio_num]</td>
			<td class=\"br\" valign=\"top\">$to</td>
			<td class=\"br\" valign=\"top\">$item[businessName]</td>
			<td class=\"br\" valign=\"top\" align=\"center\">$item[rf_currency_symbol]</td>
			<td class=\"br\" valign=\"top\">$room</td>
			<td valign=\"top\">$guestNames</td>
		</tr>		
	";
}
$GLOBALS['temp']['folioList'] = $folioRows;

$localPropertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",4);

$resItemList = $GLOBALS['lDB']->get("
	SELECT
		pr_business_id
	FROM
		rv_reservation_item
	WHERE
		rv_reservation_id = '$resId'
",3);

$entityACL = array();
foreach($resItemList as $item) {
	$businessId = "";
	$currId = $item;
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		if(!$GLOBALS['isPropServer']) {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
				$businessId = $currId;
		} else {
				$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id ='$currId'",4);
		}
	}
	if($businessId != "" && $businessId != "0") {
		array_push($entityACL, $businessId);
	}
}
$entityACL = array_unique($entityACL);


/*$currencyList = $GLOBALS['lDB']->get("
	SELECT
		rf_currency_id
	FROM
		fn_folio
	WHERE
		fn_folio.rv_reservation_id = '$resId'
",3);
array_splice($currencyList, count($currencyList), 0, $GLOBALS['lDB']->get("
	SELECT
		pr_bus_home_curr_id
	FROM
		pr_business
	WHERE
		pr_bus_billing_yn
		",3));*/
$currencyList = $GLOBALS['lDB']->get("SELECT rf_currency_ix FROM rf_currency ORDER BY rf_currency_symbol",3);

$currencyList = array_unique($currencyList);
$currencyOptions = "";
foreach($currencyList as $item) {
	$currencySymbol = $GLOBALS['lDB']->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency.rf_currency_ix = '$item'",4);
	$currencyName = $GLOBALS['lDB']->get("SELECT rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix = '$item'",4);
	if(!$GLOBALS['isPropServer']) {
		$localCheck = $GLOBALS['lDB']->get("SELECT count(*) FROM rv_reservation WHERE rv_reservation_ix = '$resId' AND rv_invoice_currency_id = '$item'",4);

	} else {
		$localCheck = $GLOBALS['lDB']->get("SELECT count(*) FROM pr_business WHERE pr_business_id = '$localPropertyId' AND pr_bus_prop_curr_id = '$item'",4);
	}
	if($localCheck > 0) {
		$currencySelected = " selected ";
	} else {
		$currencySelected = "";
	}
	$currencyOptions .= "<option value=\"" . $item . "\" " . $currencySelected . ">" . $currencyName  . " (" . $currencySymbol . ")</option>";
}
$GLOBALS['temp']['currencyOptions'] = $currencyOptions;

$contactList = $GLOBALS['lDB']->get("
	SELECT
		fn_folio_to_id
	FROM
		fn_folio
	WHERE
		fn_folio.rv_reservation_id = '$resId'
		AND fn_folio_to_id IS NOT NULL
		AND fn_folio_to_id <> ''
		AND fn_folio_to_id <> '0'
",3);
array_splice($contactList,sizeof($contactList), 0, $GLOBALS['lDB']->get("
	SELECT
		rv_billing_persona_id,
		rv_invoice_persona_id 
	FROM
		rv_reservation
	WHERE
		rv_reservation_ix = '$resId'
",1));

$contactList= array_unique($contactList);
$contactOptions = "";
foreach($contactList as $item) {
	$contact = $GLOBALS['lDB']->get("
		SELECT
			pr_name_last,
			pr_name_first
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$item'
	",1);
	$name = trim($contact['pr_name_first']);
	if($name != "") {
		$name .= " ";
	}
	$name .= trim($contact['pr_name_last']);
	$contactOptions .= "<option value=\"$item\">$name</option>";
}
$GLOBALS['temp']['contactOptions'] = $contactOptions;

$entityList = $GLOBALS['lDB']->get("
	SELECT
		pr_business_id
	FROM
		pr_business
	WHERE
		pr_bus_billing_yn = '1'
		OR pr_bus_billing_prop_yn = '1'
",3);
$entityList = array_intersect($entityACL, $entityList);
$entityOptions = "";
foreach($entityList as $item) {
	$name = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$item'",4);
	if($localPropertyId == $item) {
		$entitySelected = " selected ";
	} else {
		$entitySelected = "";
	}
	$entityOptions .= "<OPTION value=\"$item\" $entitySelected>$name</option>";
}
$GLOBALS['temp']['entityOptions'] = $entityOptions;


$roomList = $GLOBALS['lDB']->get("
	SELECT
		rv_res_item_group.rv_res_item_group_ix,
		ac_accomm_room.ac_desc,
		rv_res_item_group.rv_reservation_item_id,
		pr_persona.pr_name_last,
		ac_accomm_type.ac_accomm_desc,
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
	FROM
		rv_res_item_group
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
		LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
	WHERE
		rv_reservation_item.rv_reservation_id = '$resId'
	ORDER BY
		rv_reservation_item.rv_item_date_arrive,
		rv_reservation_item.rv_item_date_depart
",2);



$newRoomList = array();
foreach($roomList as $item) {
	$item['rv_item_date_arrive'] = chng_date($item['rv_item_date_arrive'],"-");
	$item['rv_item_date_depart'] = chng_date($item['rv_item_date_depart'],"-");
	$item['ac_desc_raw'] = $item['ac_desc'];
	if(trim($item['ac_desc']) == "") {
		$item['ac_desc'] = "&nbsp;";
	}
	$guestList = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_persona_ix,
			pr_guest.pr_guest_primary_yn,
			rf_title.rf_title_desc,
			rf_name_suffix.rf_suffix_desc
		FROM
			rv_res_item_guest
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			LEFT JOIN rf_title ON rf_title.rf_title_ix = pr_persona.pr_title_id
			LEFT JOIN rf_name_suffix ON rf_name_suffix.rf_name_suffix_ix = pr_persona.pr_name_suffix_id
		WHERE
			rv_res_item_group_id = '$item[rv_res_item_group_ix]'
	",2);
	if(sizeof($guestList) > 0) {
		$guestNames = "";
		foreach($guestList as $guestItem) {
			/*if($guestNames != "") {
				$guestNames .= "<BR>";
			}*/
			$guestNames = $guestItem['pr_name_last'];
      if(trim($guestItem['rf_suffix_desc']) != "") {
				$guestNames .= " " . $guestItem['rf_suffix_desc'];
			}
			if(trim($guestItem['pr_name_first']) != "") {
				$guestNames .= ", " . $guestItem['pr_name_first'];
			}
			if(trim($guestItem['rf_title_desc']) != "") {
				$guestNames .= " " . $guestItem['rf_title_desc'];
			}
				
			$item['guestNames'] = $guestNames;
			if($guestItem['pr_guest_primary_yn'] == "1") {
				$item['guestNames'] = "<span class=\"txtb\">$guestNames</span>";
			}
			$item['guestNamesRaw'] = $guestNames;
			$item['role'] = "Guest";
			$item['pr_persona_ix'] = $guestItem['pr_persona_ix'];
			array_push($newRoomList,$item);
		}
		/*if($guestNames == "") {
			$guestNames = "&nbsp;";
		}
		$item['guestNames'] = $guestNames;
		$item['role'] = "Guest";
		array_push($newRoomList,$item);*/
	} elseif( $item['ac_desc'] != "0" && trim($item['ac_desc']) != "") {
		$item['guestNamesRaw'] = "";
		$item['guestNames'] = "&nbsp;";
		$item['role'] = "Room";
		$item['pr_persona_ix'] = "";
		array_push($newRoomList, $item);
	}
}

$agentInfo = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
	WHERE
		rv_reservation_ix = '$resId'
",1);

array_unshift($newRoomList,array('role'=>'Agent', 'guestNames'=>$agentInfo['pr_name_last'],'guestNamesRaw'=>$agentInfo['pr_name_last'], 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;", 'pr_persona_ix'=>$agentInfo['pr_persona_ix'],'rv_res_item_group_ix'=>""));

$billing = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_billing_persona_id 
	WHERE
		rv_reservation_ix = '$resId'
",1);

$billingName = trim($billing['pr_name_first']);
if($billingName != "") { $billingName .= " "; }
$billingName .= trim($billing['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Billing Contact','guestNames'=>$billingName, 'guestNamesRaw'=>$billingName, 'ac_desc'=>"&nbsp;", 'ac_desc_raw'=>"",'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$billing['pr_persona_ix'],'rv_res_item_group_ix'=>""));
$invoice = $GLOBALS['lDB']->get("
	SELECT
		pr_persona.pr_name_first,
		pr_persona.pr_name_last,
		pr_persona.pr_persona_ix
	FROM
		rv_reservation
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id  
	WHERE
		rv_reservation_ix = '$resId'
",1);

$invoiceName = trim($invoice['pr_name_first']);
if($invoiceName != "") { $invoiceName .= " "; }
$invoiceName .= trim($invoice['pr_name_last']);
array_unshift($newRoomList,array('role'=>'Invoice Contact','guestNames'=>$invoiceName, 'guestNamesRaw'=>$invoiceName, 'ac_desc'=>"&nbsp;",'ac_desc_raw'=>"", 'rv_item_date_arrive'=>"&nbsp;", 'rv_item_date_depart'=>"&nbsp;", 'pr_name_last'=>"&nbsp;", 'ac_accomm_desc'=>"&nbsp;",'pr_persona_ix'=>$invoice['pr_persona_ix'],'rv_res_item_group_ix'=>""));
$roomList = null;
//debug($newRoomList);


$rowHTML = join("\n",file(__DIR__ . "/../../../public/html/reservation_extras_room_pop_rows.htm"));
$rows = "";
foreach($newRoomList as $item) {
	$item['guestNamesRaw'] = t_encodeOverlib($item['guestNamesRaw']);
	$rows .= showpage($item,$rowHTML);
}
$GLOBALS['temp']['contactRows'] = $rows;

$exchangeList = db_rf_exchange_rate_get_all_rates();
$rows = "";
foreach($exchangeList as $item) {
	$rows .= "<input type=\"hidden\" id=\"curr" . $item['rf_exch_curr_from_id'] . "_" . $item['rf_exch_curr_to_id'] . "\" value=\"" . $item['rf_exch_rate'] . "\" />\n";
}
$GLOBALS['temp']['exchangeList'] = $rows;

$expiryDays = $GLOBALS['lDB']->get("select rf_exch_expiry_days from rf_default",4);
$expiryDate = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryDays,date("Y")));
list($expiryYear, $expiryMonth, $expiryDay) = explode("-",$expiryDate);
$GLOBALS['temp']['expiryDate'] = $expiryDate;
$GLOBALS['temp']['expiryYear'] = $expiryYear;
$GLOBALS['temp']['expiryMonth'] = $expiryMonth;
$GLOBALS['temp']['expiryDay'] = $expiryDay;

// Tax rates dropdown
$sql = " 
	SELECT
		rf_tax_rate_ix,
		IF(rf_tax_rate_inactive_yn <> '0',concat('*',rf_tax_rate_desc),rf_tax_rate_desc) as rf_tax_rate_desc
	FROM
		rf_tax_rate
	WHERE
		rf_tax_rate_inactive_yn = '0'
	ORDER BY rf_tax_rate_desc
";

$tax_rates = $GLOBALS['lDB']->get($sql,2);

$rfTaxRateSelect = '<select id="rf_tax_rate" name="rf_tax_rate" class="forminput" style="width: 110px"  tabindex="23" >';
$rfTaxRateSelect .= '<option value=""></option>';
foreach ($tax_rates as $tax_rate) {
	$id = $tax_rate['rf_tax_rate_ix'];
	$rfTaxRateSelect .= '<option value="'.$id.'">'.$tax_rate['rf_tax_rate_desc'].'</option>';
}
$rfTaxRateSelect .= '</select>';

$GLOBALS['temp']['rf_tax_rate'] = $rfTaxRateSelect;

// Tax groups dropdown
$sql = " 
	SELECT
		rt_tax_group_ix,
		IF(rt_tax_group_inactive_yn <> '0',concat('*',rt_tax_group_desc),rt_tax_group_desc) as rt_tax_group_desc,
		(SELECT count(rt_tax_group_item.rt_tax_group_item_ix) from rt_tax_group_item WHERE rt_tax_group_item.rt_tax_group_id = rt_tax_group_ix) AS 'items'
	FROM
		rt_tax_group
	WHERE
		rt_tax_group_inactive_yn = '0'
	ORDER BY rt_tax_group_desc
";

$tax_groups = $GLOBALS['lDB']->get($sql,2);

$rtTaxGroupSelect = '<select id="rt_tax_group" name="rt_tax_group" class="forminput" style="width: 110px"  tabindex="23" >';
$rtTaxGroupSelect .= '<option value=""></option>';
foreach ($tax_groups as $tax_group) {
	$id = $tax_group['rt_tax_group_ix'];
	$itemCount = $tax_group['items'] == 0 ? 'disabled' : '';
	$rtTaxGroupSelect .= '<option value="'.$id.'" '.$itemCount.'>'.$tax_group['rt_tax_group_desc'].'</option>';
}
$rtTaxGroupSelect .= '</select>';

$GLOBALS['temp']['rt_tax_group'] = $rtTaxGroupSelect;

/*	JOB SQL
		INSERT INTO sc_job VALUES (609, 'Display Extra', 4, '"1:196:1","1:197:1"', 1);
		INSERT INTO sc_job VALUES (610, 'Add New Extra', 5, '"2,0:196:1","1:197:1"', 0);
		INSERT INTO sc_job VALUES (611, 'Save New Extra', 5, '"2,1:196:1","2,0:196:1","1:197:1"', 0);
		INSERT INTO sc_job VALUES (612, 'Edit Extra', 6, '"3,0:196:1","3:197:1"', 0);
		INSERT INTO sc_job VALUES (613, 'Save Updated Extra', 6, '"3,1:196:1","2,0:196:1","1:197:1"', 0);
		INSERT INTO sc_job VALUES (614, 'Delete Extra', 7, '"4,1:196:1","2,0:196:1","1:197:1"', 0);
		INSERT INTO sc_job VALUES (615, 'Select Extra (List)', 2, '"1:198:1"', 0);
		INSERT INTO sc_job VALUES (616, 'Extra Exch Rate', 2, '"3:199:1"', 0);
	END SQL
*/

$newr = 610;
$edit = 612;
$view = 609;
$dele = 614;
$sedit = 613;
$snewr = 611;
// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)|| canEditReservation($resId)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == ACT_NEW || $action == ACT_EDIT) {
	$pgJOBS['save'] = "1";
}
if ($action == ACT_NEW || $action == ACT_DELETE || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == ACT_EDIT) {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele) && ($userStatusId > "1" || isMasterDB())) {
		$pgJOBS['del'] = "1";
	}
}
$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"".$pgJOBS['add']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"".$pgJOBS['del']."\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\">\n";
// End Access Control Toolbar Setup
$GLOBALS['temp']['new_record'] = "reservation.php?".$newr."+".$record;
$GLOBALS['temp']['showSearch'] = " style=\"display:none\"";
$GLOBALS['temp']['showExchTab'] = " style=\"display:none\"";
$GLOBALS['temp']['del_record2'] = "reservation.php?".$dele."+".$record;
$GLOBALS['temp']['noDateClass'] = "collapse";

switch ($action) {
	case (0) : // List Records
		break;
	case (ACT_DISPLAY) : // Display Record
		$GLOBALS['mode'] = "display";
		$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+".$record2;
		$GLOBALS['temp']['save_record'] = "#";
		$GLOBALS['temp']['del_record'] = "#";
		#$GLOBALS['temp']['def_check'] .= " disabled";
		break;
	case (ACT_NEW) : // Add Record
		$GLOBALS[$form]->Arguments = (string) $snewr."+".$record;
		$GLOBALS['temp']['edit_view'] = "#";
		$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
		$GLOBALS['temp']['del_record'] = "#";
		$GLOBALS['mode'] = "new";
		$GLOBALS['temp']['noDateClass'] = "button";
		if($pmode == 1) {
			header("location:reservation.php?".$newr."+".$record);
		}
		break;
	case (ACT_EDIT) : // Edit Record
		$GLOBALS[$form]->Arguments = (string) $sedit."+".$record."+".$record2;
		$GLOBALS['mode'] = "edit";
		$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+".$record2;
		$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
		$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record."+".$record2;
		$GLOBALS['temp']['showSearch'] = "";
		$GLOBALS['temp']['noDateClass'] = "but";
		break;
	case (ACT_DELETE) : // Delete Record
		$GLOBALS['initrecord'] = $record2;
		$GLOBALS['delrecord'] = $record2;
		break;
}


$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['notesDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][138])) {
	$GLOBALS['temp']['notesTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['notesDisabled'] = "disabled";
}

$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['roomingDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][215])) {
	$GLOBALS['temp']['roomingTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['roomingDisabled'] = "disabled";
}

$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink";
$GLOBALS['temp']['financialDisabled'] = "";
if(empty($GLOBALS['jobLevelArray'][646])) {
	$GLOBALS['temp']['financialTabClass'] = "tab tabInactive tabLink tabDisabled";
	$GLOBALS['temp']['financialDisabled'] = "disabled";
}


$GLOBALS['temp']['resnotejob'] = "";
if (
	array_key_exists(137,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][137] > 5 &&	// Reservation Notes Add Note
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) {
	$GLOBALS['temp']['resnotejob'] = "reservation.php?137+".$record;
} else {
	$GLOBALS['temp']['resnotejob'] = "reservation.php?138+".$record;
}

$GLOBALS['temp']['resRoomJob'] = "";
if (
	array_key_exists(216,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][216] > 5 &&		// Edit rooming tab
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5				// Res tabs
) {
	$GLOBALS['temp']['resRoomJob'] = "reservation.php?216+".$record;
} else {
	$GLOBALS['temp']['resRoomJob'] = "reservation.php?215+".$record;
}

$GLOBALS['temp']['ressumjob'] = "";
if (
	array_key_exists(647,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][647] > 5 &&		// Reservation Billings Edit
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5				// Res tabs
) {
	$GLOBALS['temp']['ressumjob'] = "reservation.php?647+".$record;
} else {
	$GLOBALS['temp']['ressumjob'] = "reservation.php?646+".$record;
}

$GLOBALS['temp']['reslinkjob'] = "";
if (
	array_key_exists(2,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][2] > 5 &&		// Edit reservation form
	array_key_exists(0,$GLOBALS['jobLevelArray']) && $GLOBALS['jobLevelArray'][0] > 5			// Res tabs
) { 
	$GLOBALS['temp']['reslinkjob'] = "reservation.php?2+".$resId;
} else {
	$GLOBALS['temp']['reslinkjob'] = "reservation.php?0+".$resId;
}

// Prepare an array of tax rates
$sql =  "
	SELECT
		rf_tax_rate.rf_tax_rate_ix AS id,
		rf_tax_rate.rf_tax_rate_perc AS perc
	FROM
		rf_tax_rate
	WHERE
		rf_tax_rate.rf_tax_rate_inactive_yn = 0
";
$rates = $GLOBALS['lDB']->get($sql,2);
$tax_rate_array = array();
foreach ($rates as $tax_rate) {
	$tax_rate_array[$tax_rate['id']] = $tax_rate['perc'];
}
$GLOBALS['temp']['tax_rate_array'] = json_encode($tax_rate_array);

// Prepare an array of tax groups with their total percentages
$sql =  "
	SELECT
		rt_tax_group.rt_tax_group_ix AS id,
		SUM(rf_tax_rate.rf_tax_rate_perc) AS perc
	FROM
		rt_tax_group
		LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
		LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
	WHERE
		rf_tax_rate.rf_tax_rate_inactive_yn = 0
	GROUP BY rt_tax_group.rt_tax_group_ix
";
$groups = $GLOBALS['lDB']->get($sql,2);
$tax_group_array = array();
foreach ($groups as $tax_group) {
	$tax_group_array[$tax_group['id']] = $tax_group['perc'];
}
$GLOBALS['temp']['tax_group_array'] = json_encode($tax_group_array);

$isPublicOrExternal = $userStatusId < 2;		// 0 - Public, 1 - External
if ($isPublicOrExternal) {
	$GLOBALS['temp']['internalOnly'] = 'collapse';
} else {
	$GLOBALS['temp']['internalOnly'] = '';
}
