<?php

/**
 * init.form198.php - Reservation Extras Search Popup
 * Job: 615
 * Function: 52 (Reservation: Tabs)
 */

if(!isset($GLOBALS[$form])) {   
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/reservation_extras_pop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

$resId = $_SERVER['argv'][1];
$GLOBALS['temp']['resId'] = $resId;
$propertyId = $_SERVER['argv'][2];
if(trim($propertyId) == "") {
	$propertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
	if(empty($propertyId)) {
		$propertyId = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$resId'",4);
	}
	else{
	    //check if property business_id matches reservation business_id
        $res_property_id = $GLOBALS['lDB']->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_id = '$resId'",4);
        $propertyId = (isset($res_property_id) && ($res_property_id != $propertyId)) ? $res_property_id : $propertyId;
    }
	$propertyCount = $lDB->get("SELECT COUNT(*) FROM ac_extra_prop WHERE pr_business_id = '$propertyId'",4);
	if($propertyCount == 0) $propertyId = "0";
}
$catId = $_SERVER['argv'][3];
$description = isset($_POST['description'])?$_POST['description']:"";
$type = $_SERVER['argv'][4];
if(empty($type)) {
	$type = "1";
}
$GLOBALS['temp']['type'] = $type;

if ($description == "") {
	$description = "*";
}

$GLOBALS['temp']['description'] = t_encodeHTMLField($description);

// Check if user is allowed to do cross invoicing
$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
	SELECT
		sc_group.sc_grp_cross_invoice_yn
	FROM
		sc_user
		INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
	WHERE
		sc_user.pr_user_id = '$GLOBALS[userid]'
",4);

// Build property list
if(!empty($resId)) {
	$resItemPropertyList = "('" . join("','",$GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_reservation_item.pr_business_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_id = '$resId'
	",3)) . "')";
} else {
	$resItemPropertyList = "('" . join("','",$GLOBALS['lDB']->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_bus_property_yn = '1'
	",3)) . "')";
}
$propertyList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_extra_prop.pr_business_id,
		pr_persona.pr_name_last
	FROM
		ac_extra_prop
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra_prop.pr_business_id
	WHERE
		ac_extra_prop.pr_business_id IN $resItemPropertyList 
	ORDER BY
		pr_persona.pr_name_last
",2);

if($propertyId == "0") {
	$GLOBALS['temp']['noPropertySelected'] = "SELECTED";
} else {
	$GLOBALS['temp']['noPropertySelected'] = "";
}
$propertyOptions = "";
foreach($propertyList as $item) {
	if($item['pr_business_id'] == $propertyId) {
		$selected = "SELECTED";
	} else {
		$selected = "";
	}
	$propertyOptions .= "<OPTION VALUE=\"$item[pr_business_id]\" $selected>".t_encodeHTMLField($item['pr_name_last'])."</OPTION>\n";
}
if($propertyId == "0") {
	$propertyWhere = "
		AND
		( 
			ac_extra_prop.pr_business_id IS NULL
			OR ac_extra_prop.pr_business_id = '0'
			OR ac_extra_prop.pr_business_id = ''
		)
	";
} else {
	$propertyWhere = "AND ac_extra_prop.pr_business_id = '$propertyId'";
}

$GLOBALS['temp']['propertyList'] = $propertyOptions;
// Finish property list build
// Build category list
$catList = $GLOBALS['lDB']->get("
	SELECT DISTINCT
		ac_extra_category_ix,
		ac_extra_cat_desc,
		ac_extra_cat_ind
	FROM
		ac_extra_category
		INNER JOIN ac_extra ON ac_extra.ac_extra_category_id = ac_extra_category.ac_extra_category_ix
		LEFT JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
	WHERE
		ac_extra.ac_inactive_yn = 0
		AND ac_extra_category.ac_extra_category_inactive_yn = 0
		$propertyWhere
	ORDER BY
		ac_extra_cat_desc
",2);

$catOptions = "";
$foundCat = false;
$GLOBALS['temp']['categoryName'] = "";
$catRowHTML = Join("",file(__DIR__ . "/../../../public/html/code_extras_category_rows.htm"));
$catHTML = '';
$extraCat = "Select a category";
$selCatImg = "&nbsp;<b>X</b>";
foreach($catList as $item) {
	//start 6 may 2009
	switch($item['ac_extra_cat_ind']) {
	case DB_AC_EXTRA_CAT_GENERAL:
		$ac_extra_cat = "General";
		$ac_extra_cat_img = "<i class='material-icons'>collections</i>";
		break;
	case DB_AC_EXTRA_CAT_ACTIVITY:
		$ac_extra_cat = "Activity";
		$ac_extra_cat_img = "<i class='material-icons'>photo_camera</i>";
		break;
	case DB_AC_EXTRA_CAT_TRAVEL:
		$ac_extra_cat = "Travel";
		$ac_extra_cat_img = "<i class='material-icons'>flight</i>";
		break;
	case DB_AC_EXTRA_CAT_ACCOMMODATION:
		$ac_extra_cat = "Accommodation";
		$extra_desc = "Prop/Accom descrip";
		$ac_extra_cat_img = "<i class='material-icons'>pin_drop</i>";
		break;
	}
	$accommHTML = array(
		'ac_extra_category_ix'=>$item['ac_extra_category_ix'],
		'ac_extra_cat'=>$ac_extra_cat,
		'ac_extra_cat_img'=>$ac_extra_cat_img,
		'ac_extra_cat_ind'=>$item['ac_extra_cat_ind'],
		'ac_extra_cat_desc'=>t_encodeHTMLField($item['ac_extra_cat_desc']),
    'ac_extra_cat_desc_js'=>addslashes($item['ac_extra_cat_desc']),
		'accommHead'=>"",
		'accommRow'=>""
	);		
	$catHTML .= showpage($accommHTML,$catRowHTML);
	//end 6 may 2009

	if($item['ac_extra_category_ix'] == $catId) {
		$selected = "SELECTED";
		$foundCat = true;
		$selCatImg = "<i class='material-icons'>".$ac_extra_cat_img."</i>";
		$GLOBALS['temp']['categoryName'] = t_encodeHTMLField($item['ac_extra_cat_desc']);
		$extraCat = $item['ac_extra_cat_desc'];
		$GLOBALS['temp']['extraCatId'] = $catId;
	} else {
		$selected = "";
		$GLOBALS['temp']['extraCatId'] = '';
	}
}
$GLOBALS['temp']['extraCat'] = t_encodeHTMLField($extraCat);
$GLOBALS['temp']['catImg'] = $selCatImg;

if($GLOBALS['temp']['categoryName'] == "" && isset($catList[0])) {
	$GLOBALS['temp']['categoryName'] = $catList[0]['ac_extra_cat_desc'];
}
$GLOBALS['temp']['catList'] = $catOptions;
if(!$foundCat && isset($catList[0])) {
	$catId = $catList[0]['ac_extra_category_ix'];
}

$GLOBALS['temp']['category_rows'] = $catHTML;
// Finish category list

$GLOBALS['temp']['propertyId'] = $propertyId;
$GLOBALS['temp']['catId'] = $catId;

if($description != "*") {
	$GLOBALS['temp']['showSearch'] = "true";
	$where = "
		AND ac_extra.ac_ext_desc LIKE '".$lDB->like($description)."'
		AND (
				ac_extra_prop.pr_business_id IS NULL
				OR ac_extra_prop.pr_business_id = ''
				OR ac_extra_prop.pr_business_id = '0'
				OR ac_extra_prop.pr_business_id IN $resItemPropertyList 
		)
		".($sc_grp_cross_invoice_yn == 0 ? $propertyWhere : "")."
	";
} else {
	$GLOBALS['temp']['showSearch'] = "false";
	$where = "
		AND ac_extra.ac_extra_category_id = '$catId'
		$propertyWhere
	";
}
$GLOBALS['temp']['rows'] = "";
if($foundCat == 1) {
	$sql =  "
		SELECT DISTINCT
			ac_extra.ac_extra_ix,
			ac_extra.ac_ext_desc,
			ac_extra.ac_ext_travel_eta,
			ac_extra.ac_ext_travel_etd,
			ac_extra.ac_ext_adult_count,
			ac_extra.ac_ext_child_count,
			ac_extra.ac_ext_nights,
			ac_extra.ac_extra_xref,
			ac_extra.ac_ext_supplier_conf_yn,
			ac_extra.ac_ext_amount,
			ac_extra.ac_ext_child_disc,
			ac_extra.ac_ext_comm_pay,
			ac_extra.ac_ext_comm_rec,
			rf_currency.rf_currency_ix,
			rf_currency.rf_currency_symbol,
			ac_extra_category.ac_extra_cat_desc,
			ac_extra_category.ac_extra_cat_ind,
			CONCAT_WS(' ',pr_extra_supplier.pr_name_first,pr_extra_supplier.pr_name_last) AS supplier_name,
			pr_extra_supplier.pr_persona_ix AS pr_supplier_id,
			ac_extra.ac_ext_note,
			ac_extra.ac_ext_note_internal,
			rf_tax_rate.rf_tax_rate_perc,
			pr_persona.pr_name_last,
			pr_persona.pr_persona_ix,
			'$resId' as rv_reservation_ix,
			ac_extra.rf_tax_id,
			ac_extra.rf_tax_ind
		FROM
			ac_extra
			LEFT JOIN rf_currency ON ac_extra.rf_currency_id = rf_currency.rf_currency_ix
			LEFT JOIN ac_extra_prop ON ac_extra_prop.ac_extra_id = ac_extra.ac_extra_ix
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_extra_prop.pr_business_id
			LEFT JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = ac_extra.rf_tax_id 
			LEFT JOIN pr_persona AS pr_extra_supplier ON pr_extra_supplier.pr_persona_ix = ac_extra.pr_supplier_id
		WHERE
			ac_extra.ac_inactive_yn = 0
			AND ac_extra_category.ac_extra_category_inactive_yn = 0
			$where
		ORDER BY
			ac_extra.ac_ext_desc";

	$extras = $GLOBALS['lDB']->get($sql,2);

	$GLOBALS['temp']['recordsFound'] = (string) sizeof($extras);
	$GLOBALS['temp']['rv_extra_exch_expiry'] = date("Y-m-d");

	# Move to output array

	$rowHtml = Join("",File(__DIR__ . "/../../../public/html/reservation_extras_pop_rows.htm"));
	foreach($extras as $item) {
		// Find the billing entity
		$businessId = "";
		$currId = $propertyId;
		while($businessId == "" && $currId != "0" && trim($currId) != "") {
			if(!$GLOBALS['isPropServer']) {
				$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			} else {
				$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			}
			if($billingYN == "1") {
				$businessId = $currId;
			} else {
				$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
			}
		}
		$item['billingEntityId'] = $businessId;
		
			
		if($item['pr_name_last'] != "0" && $item['pr_name_last'] != "") {
			$item['propertyList'] = t_encodeHTMLField($item['pr_name_last']);
		} else {
			$item['propertyList'] = "Not property specific";
		}
		$item['ac_ext_desc_encoded'] = t_encodeOverlib($item['ac_ext_desc']);
		$item['supplier_name_encoded'] = t_encodeOverlib($item['supplier_name']);
		$item['ac_extra_xref'] = t_encodeOverlib($item['ac_extra_xref']);

		if($item['rf_currency_symbol'] != "") {
			$item['rf_currency_symbol_format'] = t_encodeHTMLField($item['rf_currency_symbol']);
		} else {
			$item['rf_currency_symbol_format'] = "&nbsp;";
		}	
		$item['rf_currency_symbol'] = t_encodeOverlib(t_encodeHTMLField(t_encodeHTMLField($item['rf_currency_symbol'])));

		if(trim($item['rf_currency_ix']) == "" || $item['rf_currency_ix'] == "0") {
			$item['ac_ext_amount'] = "No charge";
		}

		$item['type'] = $type;

		$item['ac_ext_desc'] = t_encodeHTMLField($item['ac_ext_desc']);
		$item['ac_extra_cat_desc'] = t_encodeHTMLField($item['ac_extra_cat_desc']);

		$GLOBALS['temp']['rows'] .= showpage($item,$rowHtml);
	}
} else {
	$GLOBALS['temp']['recordsFound'] = 0;	
}
// This shouldn't happen anymore, unless there are absolutely no extras defined...
if ($GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] = "<tr>\n<td colspan=\"2\" align=\"left\" class=\"txt\">&nbsp;&nbsp;Your search - ".t_encodeHTMLField($description)." - did not match any records.<br><br>&nbsp;&nbsp;<b>Suggestions:</b>
      <br>&nbsp;&nbsp;- Use wildcards to assist in your search<br>&nbsp;&nbsp;&nbsp;&nbsp;(e.g. B* to list all records starting with B)
      <br>&nbsp;&nbsp;- Use a different keyword.</td>\n</tr>\n";
}
