<?php

/*
 * $Id: init.form199.php,v 1.2 2010-11-24 14:15:34 light Exp $
 *
 * $Log: init.form199.php,v $
 * Revision 1.2  2010-11-24 14:15:34  light
 * Bug #7385 - Add daily exchange rate to invoicing (plus enhancements)
 *
 *
 */

/**
 * init.form199.php - Exchange rate popup
 * Job: 616
 * Function: 52 (Reservation: Tabs)
*/

if (isset($_SERVER['argv'][5]) && strpos($_SERVER['argv'][5], 'ajax') !== false) {
	// Return exchange details to Ajax call
	$exchRate = db_rf_exchange_rate_get_rate_by_all($_SERVER['argv'][1], $_SERVER['argv'][2]);
	$expiryPad = $GLOBALS['lDB']->get("SELECT rf_exch_expiry_days FROM rf_default", 4);
	$expiryDate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d") + $expiryPad, date("Y")));
	$dateparts = ($expiryDate != "" && $expiryDate != "0000-00-00") ? explode("-", $expiryDate) : [];

	echo json_encode([
		"exchangeRate" => $exchRate ?? '',
		"expiryDay" => $dateparts[2] ?? '',
		"expiryMonth" => $dateparts[1] ?? '',
		"expiryYear" => $dateparts[0] ?? ''
	]);
	die;
}

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/change_exchange.htm");
}

$fromCurrency = $_SERVER['argv'][1];
$toCurrency = $_SERVER['argv'][2];

$today = date("Y-M-d");
$extraId = $_SERVER['argv'][3];
$resId = $_SERVER['argv'][4];

if($extraId == "wizard") {
	$extraId = "";
	$toCurrency = $GLOBALS['lDB']->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$toCurrency'",4);
}

// Get the exchange rate from the code table if this isn't an edit.
if($extraId == "") {
	$exchRate = db_rf_exchange_rate_get_rate_by_all($fromCurrency,$toCurrency);
	if(empty($exchRate)) {
		$exchRate = db_rf_exchange_rate_get_rate_by_all($toCurrency,$fromCurrency);
		if(!empty($exchRate)) {
			$exchRate = round(1 / $exchRate, exchDecimalPlaces());
		}
	}
}

if($resId != "") {
	$resExch = $GLOBALS['lDB']->get("SELECT rv_exchg_rate FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	if(!empty($resExch) && $resExch != "1") {
		$exchRate = $resExch;
	}
}

if(!empty($exchRate)) {
	fixAmtDisplay($exchRate, exchDecimalPlaces());
}

$curr = $GLOBALS['lDB']->get("SELECT rf_currency_ix, rf_currency_symbol FROM rf_currency WHERE rf_currency_ix IN ('$fromCurrency','$toCurrency')",2);

for($i=0;$i<sizeof($curr);$i++) {
	if($curr[$i][0] == $fromCurrency){
		$GLOBALS['temp']['fromSymbol'] = $curr[$i][1];
	} else {
		$GLOBALS['temp']['toSymbol'] = $curr[$i][1];
	}
}

$days = array("0" => "00:|:");
for($x=1;$x<32;$x++) {
	$days[$x] = $x.":|:".date("d",mktime(0,0,0,1,$x,2000));
}

$months = array("0" => "00:|:");
for($x=1;$x<13;$x++) {
	$months[$x] = $x.":|:".date("M",mktime(0,0,0,$x,1,2000));
}

$expiryPad = $GLOBALS['lDB']->get("SELECT rf_exch_expiry_days FROM rf_default",4);
$start = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$expiryPad,date("Y")));

$GLOBALS['temp']['exchRateVal'] = "";

if($extraId != "") {
	$temp = $GLOBALS['lDB']->get("SELECT rv_extra_exch_rate, rv_extra_exch_expiry FROM rv_extra WHERE rv_extra_ix = '$extraId'",1);
	if($temp[0] != "0.0000") {
		$GLOBALS['temp']['exchRateVal'] = $temp[0];
	}
	$start = $temp[1];
} else {
	if($exchRate != "0.0000" && $exchRate != "0" && $exchRate != "") {
		$GLOBALS['temp']['exchRateVal'] = $exchRate;
	}
}

if($start != "" && $start != "0000-00-00") {
	$temp = explode("-",$start);
	$SdValue = $temp[2];
	$SmValue = $temp[1];
	$SyValue = $temp[0];
}
$tabcount = 1;
$newDfield = "exchDateD";
$GLOBALS[$form]->AddField($newDfield,$newDfield,$SdValue,0);
$GLOBALS[$newDfield]->Select($days);
$GLOBALS[$newDfield]->Size = "4";
$GLOBALS[$newDfield]->TabIndex = $tabcount++;

$newMfield = "exchDateM";
$GLOBALS[$form]->AddField($newMfield,$newMfield,$SmValue,0);
$GLOBALS[$newMfield]->Select($months);
$GLOBALS[$newMfield]->Size = "7";
$GLOBALS[$newMfield]->TabIndex = $tabcount++;
$GLOBALS[$newMfield]->onChange = "select_daymonth_changed();";

$newYfield = "exchDateY";
$GLOBALS[$form]->AddField($newYfield,$newYfield,$SyValue,0);
$GLOBALS[$newYfield]->Size = "2";
$GLOBALS[$newYfield]->StyleType = "txt";
$GLOBALS[$newYfield]->TabIndex = $tabcount++;
$GLOBALS[$newYfield]->onChange = "select_daymonth_changed();";

