<?php

/**
 * init.form2000.php - Rate Calculator
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
} 
 
if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rate_calc.htm");
}

$rt_rate_id = $_SERVER['argv'][1];
$ac_accomm_type_id = $lDB->get("SELECT ac_accomm_type_id FROM rt_rate WHERE rt_rate_ix = '" . $lDB->escape($rt_rate_id) . "'",4);
$ac_accomm_capacity = $lDB->get("SELECT ac_accomm_capacity FROM ac_accomm_type WHERE ac_accomm_type_ix = '". $lDB->escape($ac_accomm_type_id). "'", 4);
$rt_rate_group_unit_id = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_sys_code = 1",4);
$rt_rate_group_adult_id = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_sys_code = 2",4);

$rateHeader = getRateHeader($rt_rate_id);
$rateCompGroupHeaders = getRateComponentGroupHeaders($rt_rate_id);
foreach($rateCompGroupHeaders as &$group) {
	if($group['rt_rate_group_ix'] == $rt_rate_group_unit_id) {
		$group['qty'] = 1;
	} elseif($group['rt_rate_group_ix'] == $rt_rate_group_adult_id) {
		$group['qty'] = $ac_accomm_capacity;
	} else {
		$group['qty'] = 0;
	}
}
unset($group);

$commPerc = 0;
$defaultOptionalYn = true;

$componentHTML = "<tr><td colspan=\"4\" align=\"center\">No results to display...</td></tr>";
$taxHTML = "<tr><td colspan=\"2\" align=\"center\">No results to display...</td></tr>";
$rateGroupHTML = "<tr><td colspan=\"4\" align=\"center\">No results to display...</td></tr>";
if($_SERVER['argc'] > 2) {
	$componentHTML = "";
	$taxHTML = "";
	$rateGroupHTML = "";
	$rateGroups = json_decode($_SERVER['argv'][2],true);
	$commPerc = $_SERVER['argv'][3] ?? 0;
	$deduct = ($commPerc != 0 ? 1 : 0);
	$defaultOptionalYn = ($_SERVER['argv'][4] == "1" ? true : false);

	foreach($rateCompGroupHeaders as &$group) {
		foreach($rateGroups as $rateGroup) {
			if($group['rt_rate_group_ix'] == $rateGroup['rt_rate_group_ix']) {
				$group['qty'] = $rateGroup['qty'];
			}
		}
	}
	unset($group);

	$toDate = date("Y-m-d",strtotime($rateHeader['rt_period_date_from'] . " +1 day"));

	$override = false;
		
/*		FOR TESTING ONLY
	$override = array(
		"level"		=> "3",
		"amounts"	=> array(
			"stay"			=>	"390083.00",
			"rate_group"	=>	array(
				"RS1"	=>	"450.00",
				"RS2"	=>	"350.00",
				"RS3"	=>	"300.00"
			)
		)
	);*/

	$optionals = [];
	if($defaultOptionalYn) {
		$optionals = array_map(function($optional) {
			return $optional['rt_component_ix'];
		},getDefaultOptionalComponents($rateHeader['ac_accomm_type_ix'], $rateHeader['rt_rate_type_ix'], $rateHeader['rt_period_date_from'], $toDate));
	}
	$rate = new Rate($rateHeader['ac_accomm_type_ix'],$rateHeader['rt_period_date_from'],$toDate,$rateGroups,$rateHeader['rt_rate_type_ix'],$optionals,$override,false,$commPerc,false,$deduct);
		
	$periods = $rate->ToPeriods();

	$allTaxes = array();	
	$allRateGroups = array();
	$rateGroupFields = [
		'rate',
		'rate_comm',
		'gross',
		'comm_calc',
		'comm',
		'nett',
		'payable',
		'tax'
	];
	foreach($periods as $period) {
		$total_chg_amt = 0;
		$total_extax = 0;
		$total_tax = 0;
		foreach($period['components'] as $component) {
			$componentName = $lDB->get("SELECT rt_component_desc FROM rt_component WHERE rt_component_ix = '".$component['rt_component_id']."'",4);
			if($component['ac_acc_cmp_option_yn'] == 1) {
				$componentName = "* ".$componentName;
			}
			$comp_chg = $component['rv_item_comp_amt_payable'];
			$comp_tax = $component['rv_item_comp_amt_tax'];
			$comp_extax = ($comp_chg-$comp_tax);
			
			fixAmtDisplay($comp_chg,2);
			fixAmtDisplay($comp_extax,2);
			fixAmtDisplay($comp_tax,2);

			$componentHTML .= "
				<tr>
					<td>".$componentName."</td>
					<td class=\"bl\" align=\"right\">".$comp_chg."</td>
					<td class=\"bl\" align=\"right\">".$comp_extax."</td>
					<td class=\"bl\" align=\"right\">".$comp_tax."</td>
				</tr>			
			";				
			
			$total_chg_amt += $component['rv_item_comp_amt_payable'];
			$total_extax += $comp_extax;
			$total_tax += $comp_tax;

			// Tax table
			foreach($component['tax_detail'] as $key=>$taxItem) {
				if(!isset($allTaxes[$key])) {
					$allTaxes[$key]['perc'] = $taxItem['perc'];
					$allTaxes[$key]['amount'] = 0;
				}

				$allTaxes[$key]['amount'] += $taxItem['amount'];
			}

			foreach($component['rate_groups'] as $key=>$group) {
				if(!isset($allRateGroups[$key])) {
					$desc = "Unknown";
					foreach($rateCompGroupHeaders as $header) {
						if($header['rt_rate_group_ix'] == $key) {
							$desc = $header['rt_rate_group_desc'];
							$qty = $header['qty'];
						}
					}
					$allRateGroups[$key] = [
						'rt_rate_group_ix'=>$key,
						'rt_rate_group_desc'=>$desc,
						'qty'=>$qty
					];
					foreach($rateGroupFields as $field) {
						$allRateGroups[$key][$field] = 0;
					}
				}
				foreach($rateGroupFields as $field) {
					$allRateGroups[$key][$field] += $group[$field];
				}
			}
		}
	
	}

	fixAmtDisplay($total_chg_amt, 2);
	fixAmtDisplay($total_extax, 2);
	fixAmtDisplay($total_tax, 2);
		
	if($rate->ToPeople() > 0) {
		$avg = $total_chg_amt / $rate->ToPeople();
		fixAmtDisplay($avg, 2);
	} else {
		$avg = "N/A";
	}

	$componentHTML .= "
		<tr>
			<td>&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
		</tr>	
		<tr>
			<td class=\"txtb\">Total per night</td>
			<td class=\"bl txtb\" align=\"right\">$total_chg_amt</td>
			<td class=\"bl txtb\" align=\"right\">$total_extax</td>
			<td class=\"bl txtb\" align=\"right\">$total_tax</td>
		</tr>	
		<tr>
			<td>Average per person</td>
			<td class=\"bl\" align=\"right\">$avg</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
		</tr>		
	";		
		
	// Tax table
	foreach($allTaxes as $key=>$taxItem) {
		$taxDesc = $lDB->get("SELECT rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate_ix = '".$key."'",4);
		$taxAmount = $taxItem['amount'];
		fixAmtDisplay($taxAmount,2);
		$taxHTML .= "
			<tr>
				<td>$taxDesc</td>
				<td class=\"bl\" align=\"right\">$taxAmount</td>
			</tr>			
		";
	}

	$rateGroupTotal = 0;
	foreach($allRateGroups as $rt_rate_group_id=>$allRateGroup) {
		$total = $allRateGroup['nett'];
		$qty = $allRateGroup['qty'];
		$perPerson = $total / $qty;
		if($rt_rate_group_id == $rt_rate_group_unit_id) {
			$qty = 1;
		} else {
			$perPerson /= $allRateGroups[$rt_rate_group_unit_id]['qty'];
		}
		$total /= $allRateGroups[$rt_rate_group_unit_id]['qty'];
		$rateGroupTotal += $total;

		fixAmtDisplay($perPerson,2);
		fixAmtDisplay($total,2);

		$rateGroupHTML .= "
			<tr>
				<td>$allRateGroup[rt_rate_group_desc]</td>
				<td class=\"bl\" align=\"right\">$perPerson</td>
				<td class=\"bl\" align=\"right\">$qty</td>
				<td class=\"bl\" align=\"right\">$total</td>
			</tr>
		";
	}
	fixAmtDisplay($rateGroupTotal);
	$rateGroupHTML .= "
		<tr>
			<td>&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
		</tr>
		<tr>
			<td class=\"txtb\">Total per unit</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"bl\">&nbsp;</td>
			<td class=\"txtb bl\" align=\"right\">$rateGroupTotal</td>
		</tr>
	";
		
		
}

$rowHTML = "";

$rowCollapse = ($_SERVER['argv'][5] ?? "0") != "1";
if($rowCollapse) {
	$rowCollapseAt = 4;
} else {
	$rowCollapseAt = sizeof($rateCompGroupHeaders);
}
$rowCount = 0;
foreach($rateCompGroupHeaders as $rateCompGroupHeader) {
	$rowCount++;
	$rowClass = "";
	if($rowCount > $rowCollapseAt) {
		$rowClass = "collapse rateGroupHidden";
	}
	$rowHTML .= "
			<tr class=\"$rowClass\">
				<td>".$rateCompGroupHeader['rt_rate_group_desc']."</td>
				<td align=\"right\">
					<input class=\"inputRateGroup txtr\" style=\"width: 30px\" value=\"$rateCompGroupHeader[qty]\" id=\"rateGroup_$rateCompGroupHeader[rt_rate_group_ix]\">
				</td>
			</tr>		
	";
}
$rowClass = "collapse";
if($rowCount > $rowCollapseAt) {
	$rowClass = "";
}
$rowHTML .= "
			<tr class=\"rateGroupMoreButton $rowClass\">
				<td colspan=\"2\"><button class=\"button\" type=\"button\" onclick=\"rateGroupMore()\">Show all rate groups</button></td>
			</tr>
";

$GLOBALS['temp']['rt_rate_id'] = $rt_rate_id;
$GLOBALS['temp']['rows'] = $rowHTML;
$GLOBALS['temp']['commPerc'] = $commPerc;
$GLOBALS['temp']['defaultOptionalChecked'] = "";
if($defaultOptionalYn) {
	$GLOBALS['temp']['defaultOptionalChecked'] = "checked";
}
$GLOBALS['temp']['components'] = $componentHTML;
$GLOBALS['temp']['tax'] = $taxHTML;
$GLOBALS['temp']['rate_groups'] = $rateGroupHTML;
