<?php

require_once(__DIR__ . '/db.rt_rate.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.csv.php');
require_once(__DIR__ . '/functions.pdf.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/init.form2002.func.profile.php');
require_once(__DIR__ . "/class.xls.php");
require_once(__DIR__ . "/class.newrelic.php");

function getYesNo($field_yn) {
	if(empty($field_yn)) {
		return "No";
	} else {
		return "Yes";
	}
}

function getCol($id) {
	global $cols;

	foreach($cols as $item) {
		if($item['id'] == $id) {
			return $item;
		}
	}
	return false;
}

function getOverideLevel($rt_rate_overide_level_ind) {
	switch ($rt_rate_overide_level_ind){
		case 0:
			return "None";
		case 1:
			return "Person";
		case 2:
			return "Unit";
		case 3:
			return "Stay";	
	}
}

function getRoundType($rt_rate_round_ind) {
	return db_rt_rate_round_type_desc($rt_rate_round_ind);
}

function getRoundDir($rt_rate_round_dir) {
	return db_rt_rate_round_dir_desc($rt_rate_round_dir);
}

function getRoundScale($rt_rate_round_scale) {
	return db_rt_rate_round_scale_desc($rt_rate_round_scale);
}

function getRateStatus($rt_rate_status_ind) {
	switch ($rt_rate_status_ind){
		case 0:
			return "Inactive";
		case 1:
			return "Active";
	}
}

function getCompComm($rt_comp_comm_yn) {
	switch ($rt_comp_comm_yn){
		case 0:
			return "Not Commissionable";
		case 1:
			return "Calculate";
		case 2:
			return "Calc & deduct";
		case 3:
			return "Calc & deduct all";	
	}
}	

function getCompFreq($rt_comp_freq_ind, $rt_comp_freq_factor=1) {
	if ($rt_comp_freq_ind == 1){
		return "Per Night (".$rt_comp_freq_factor.")";
	} else {
		return "Per Stay";
	}	
}	

function getCompTax($rt_tax_ind,$rt_tax_id) {
	switch($rt_tax_ind){
		case "10":
			$taxRate = $GLOBALS['lDB']->get("
				SELECT
					rf_tax_rate.rf_tax_rate_desc
				FROM
					rf_tax_rate
				WHERE
					rf_tax_rate.rf_tax_rate_ix = '$rt_tax_id'
			",4);

				if (trim($taxRate) == "" || $taxRate == "0") {
					$taxRate = "";
				}	
				return $taxRate;
		case "20":

				$taxGroup = $GLOBALS['lDB']->get("
					SELECT
						rt_tax_group.rt_tax_group_desc
					FROM
						rt_tax_group
					WHERE
						rt_tax_group.rt_tax_group_ix = '$rt_tax_id'
				",4);

				if (trim($taxGroup) == "" || $taxGroup == "0") {
					$taxGroup = "";
				}	
				return $taxGroup;		
	}
}

function getGroupAmount($rt_rate_component_id,$rt_rate_group_id){
	$groupAmount = $GLOBALS['lDB']->get("
		SELECT
			rt_rate_comp_grp.rt_rate_comp_amt,
			rt_rate_comp_grp.rt_rate_comp_perc
		FROM
			rt_rate_comp_grp
		WHERE
			rt_rate_comp_grp.rt_rate_component_id = '$rt_rate_component_id' 
			AND rt_rate_comp_grp.rt_rate_group_id = '$rt_rate_group_id'
	",1);
	if ($groupAmount['rt_rate_comp_amt'] <> 0){
		return $groupAmount['rt_rate_comp_amt'];
	} else {
		return $groupAmount['rt_rate_comp_perc']."%";
	}
}

function getAmountQty($rt_rate_grp_amt_qty) {
	switch ($rt_rate_grp_amt_qty){
		case 0:
			return "1 Sharing";
		case 1:
			return "1 Single";
		default:
			return $rt_rate_grp_amt_qty;
	
	}
}


function outputMail($form,$options,$fromDate,$toDate) {
	global $lDB;
	global $temp;

	$pdfName = "Rate Sheet";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $pdfName . ".pdf</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~3) + 3;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,30))."+$newOptions";

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$pdfName.".pdf",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!",$pdfName,
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

function colCompare($a, $b){
	if ($a['label'] == $b['label']) {
		return 0;
	}
	return ($a['label'] < $b['label']) ? -1 : 1;
}

function getColData(){
	global $cols;
	global $colArray;
	global $colSort;
	global $joins;
	global $colData;
	global $colOrder;
	global $colHeader;

	$cols = array(
		array('id'=>1,'label'=>"Property",'type'=>"string",'fields'=>array("pr_business.pr_bus_name_short"),'width'=>"60"),
		array('id'=>2,'label'=>"Accommodation",'type'=>"string",'fields'=>array("ac_accomm_type.ac_accomm_desc"),'width'=>"90"),
		array('id'=>3,'label'=>"Rate Type",'type'=>"string",'fields'=>array("rt_rate_type.rt_rate_type_desc"),'width'=>"90"),
		array('id'=>4,'label'=>"Currency",'type'=>"string",'fields'=>array("rf_currency.rf_currency_name"),'width'=>"70"),
		array('id'=>5,'label'=>"Period",'type'=>"string",'fields'=>array("rt_period.rt_period_desc"),'width'=>"200"),
		array('id'=>6,'label'=>"O/ride Access",'type'=>"complex",'fields'=>array(),'width'=>"60",'disabled'=>true),
		array('id'=>7,'label'=>"O/ride Level",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_overide_level_ind"),'function'=>"getOverideLevel",'width'=>"60"),
		array('id'=>8,'label'=>"Rnd Scale",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_round_scale"),'function'=>"getRoundScale",'width'=>"60"),
		array('id'=>9,'label'=>"Rnd Dir",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_round_dir"),'function'=>"getRoundDir",'width'=>"60"),
		array('id'=>10,'label'=>"TBA",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_tba_yn"),'function'=>"getYesNo",'width'=>"50"),
		array('id'=>11,'label'=>"Waive checks",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_waive_checks_yn"),'function'=>"getYesNo",'width'=>"50"),
		array('id'=>12,'label'=>"Status",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_status_ind"),'function'=>"getRateStatus",'width'=>"50"),
		array('id'=>13,'label'=>"O/ride Comm.",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_oride_comm_yn"),'function'=>"getYesNo",'width'=>"60"),
		array('id'=>14,'label'=>"S/supp Comm.",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_ssupp_comm_yn"),'function'=>"getYesNo",'width'=>"60"),
		array('id'=>15,'label'=>"Pax Rate Group",'type'=>"complex",'fields'=>array("rt_rate.rt_pax_rate_group_yn"),'function'=>"getYesNo",'width'=>"100"),
		array('id'=>16,'label'=>"Commission",'type'=>"complex",'fields'=>array("rt_rate.rt_rate_comm_yn"),'function'=>"getYesNo",'width'=>"100"),
		array('id'=>17,'label'=>"Rnd Type", 'type'=>"complex",'fields'=>array("rt_rate.rt_rate_round_ind"),'function'=>"getRoundType",'width'=>"60")

	);	
		
	usort($cols, "colCompare");

	$joins = array(
		array('table'=>"rt_rate"),
		array('table'=>"ac_accomm_type",'type'=>"INNER",'on'=>"ac_accomm_type.ac_accomm_type_ix = rt_rate.ac_accomm_type_id",'requires'=>"rt_rate"),
		array('table'=>"pr_business",'type'=>"INNER",'on'=>"pr_business.pr_business_id = ac_accomm_type.pr_business_id",'requires'=>"ac_accomm_type"),
		array('table'=>"rt_rate_type",'type'=>"LEFT",'on'=>"rt_rate_type.rt_rate_type_ix = rt_rate.rt_rate_type_id",'requires'=>"rt_rate"),
		array('table'=>"rf_currency",'type'=>"LEFT",'on'=>"rt_rate_type.rf_currency_id  = rf_currency.rf_currency_ix",'requires'=>"rt_rate_type"),
		array('table'=>"rt_period",'type'=>"INNER",'on'=>"rt_period.rt_period_ix = rt_rate.rt_period_id",'requires'=>"rt_rate"),
		array('table'=>"rt_period_dates",'type'=>"INNER",'on'=>"rt_period_dates.rt_period_id = rt_period.rt_period_ix",'requires'=>"rt_period"),
		array('table'=>"rt_rate_component",'type'=>"INNER",'on'=>"rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix",'requires'=>"rt_rate"),
		array('table'=>"rt_component",'type'=>"INNER",'on'=>"rt_component.rt_component_ix = rt_rate_component.rt_component_id",'requires'=>"rt_rate_component"),
		array('table'=>"rt_rate_comp_grp",'type'=>"INNER",'on'=>"rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix",'requires'=>"rt_rate_component"),
		array('table'=>"rt_rate_grp_amt",'type'=>"INNER",'on'=>"rt_rate_grp_amt.rt_rate_id = rt_rate.rt_rate_ix",'requires'=>"rt_rate"),
	);

	$colArg = $_SERVER['argv'][29];
	$colArray = array();
	$colOrder = array();
	$colSort = array();
	$colHeader = false;
	if(trim($colArg) != "") {
		$count = 0;
		foreach(explode(":",$colArg) as $item) {
			$col = explode(",",$item);
			if($col[8] != "") {
				$id = $col[8];
			} else {
				$id = $count+1;
			}
			$colItem = getCol($id);
			$colActive[$id] = $col[0];
			$colOrder[$id] = $col[1];
			$colSort[$id] = $col[2];
			$width = $col[4];
			if(!is_numeric($width)) {
				$width = $colItem['width'];
			}
			$label = trim($col[5]);
			if($label == "") {
				$label = $colItem['label'];
			}
			
			$disabled = isset($colItem['disabled']) ? $colItem['disabled'] : "";
			
			$header = trim($col[6]);
			if($header != "") {
				$colHeader = true;
			}
			$align = trim($col[7]);
			if($align == "") {
				$align = isset($colItem['align']) ? $colItem['align'] : "";
			}
			$colArray[$id] = array(
				"active"=>$col[0],
				"order"=>$col[1],
				"sort"=>$col[2],
				"direction"=>$col[3],
				"width"=>$width,
				"label"=>$label,
				"header"=>$header,
				"align"=>$align,
				"disabled"=>$disabled
			);
			$count++;
		}
	}

	asort($colOrder);
	asort($colSort);

	$colData = array();

	foreach($cols as $colKey=>$colItem) {
		$width = $colItem['width'];
		$sort = "";
		$direction = "";
		$label = $colItem['label'];
		$active = "";
		$order = "";
		$header = "";
		$align = isset($colItem['align']) ? $colItem['align'] : "";
		$id = $colItem['id'];
		$disabled = isset($colItem['disabled']) ? $colItem['disabled'] : "";

		if(array_key_exists($id, $colArray) && $colArray[$id]['active'] == "1") {
			$width = $colArray[$id]['width'];
			$sort = $colArray[$id]['sort'];
			$direction = $colArray[$id]['direction'];		
			$label = $colArray[$id]['label'];
			$active = "1";
			$order = $colArray[$id]['order'];
			$header = $colArray[$id]['header'];
			$align = $colArray[$id]['align'];
			$disabled = $colArray[$id]['disabled'];
		}
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			'"sort":"'.$sort.'"',
			'"direction":"'.$direction.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"align":"'.$align.'"',
			'"disabled":"'.$disabled.'"'
		);
		array_push($colData,'{'.join(",",$colDataItem)."}\n");
	}

	$colData = '['.join(",",$colData).']';

}

function buildSQL($cols,$colArray,$colSort,$joins) {

	$select = array();
	$from = array();
	foreach($cols as $key=>$item) {		
		$id = $item['id'];
		if($colArray[$id]['active'] == "1") {
			$fields = array();
			if(is_array($item['fields'])) {
				$fields = $item['fields'];
			}
			foreach($fields as $field) {
				if(inJoin(getFieldTable($field),$joins) && !in_array($field,$select)) {
					array_push($select,$field);
					$fieldArray = explode(".",$field);
					$from = array_merge($from,getJoins($fieldArray[0],$joins));
				}
			}	
		}
	}
	$select = array_unique($select);
	$from = array_unique($from);

	$sort = array();
	foreach($colSort as $key=>$item) {
		if($colArray[$key]['active'] == "1" && $item != "") {
			$colItem = getCol($key);
			if(is_array($colItem['fields'])) {
				$fields = $colItem['fields'];
			}
			if($colArray[$key]['direction'] == "a") {
				$direction = "asc";
			} else {
				$direction = "desc";
			}
			foreach($fields as $fieldKey=>$field) {
				$fields[$fieldKey] = $field . " " . $direction;
			}
			$sort = array_merge($sort,$fields);
		}
	}
	return array('select'=>$select, 'from'=>$from,'sort'=>$sort);
}

function getJoins($alias,$joins) {
	foreach($joins as $join) {
		if((isset($join['alias']) && $join['alias'] == $alias) || (isset($join['alias']) && $join['alias'] == "" && $join['table'] == $alias) || (!isset($join['alias']) && $join['table'] == $alias)) {
			if(!array_key_exists("type",$join)) {
				return array($join['table']);
			} else {
				if(!isset($join['alias']) || $join['alias'] == "") {
					$result = array("$join[type] JOIN $join[table] ON $join[on]");
				} else {
					$result = array("$join[type] JOIN $join[table] AS $join[alias] ON $join[on]");
				}
				if($join['requires'] != "") {
					$require = getJoins($join['requires'],$joins);
					return array_merge($require,$result);
				} else {
					return $result;
				}
			}
		}
	}
	return array();  // If we get to this point, return an empty array
}

function getFieldArray($field) {
	$fieldList = preg_split("/ as /i",$field);
	$alias = isset($fieldList[1]) ? trim($fieldList[1]) : "";
	$fieldList = explode(".",$fieldList[0]);
	$table = trim($fieldList[0]);
	$field = isset($fieldList[1]) ? trim($fieldList[1]) : "";
	return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
}

function getFieldName($field) {
	$fieldArray = getFieldArray($field);
	if($fieldArray['alias'] != "") {
		return $fieldArray['alias'];
	} else {
		return $fieldArray['field'];
	}
}

function getFieldTable($field) {
	$fieldArray = getFieldArray($field);
	return $fieldArray['table'];
}

function inJoin($alias,$joins) {
	foreach($joins as $join) {
		if((isset($join['alias']) && $join['alias'] == $alias) || $join['table'] == $alias) {
			return true;
		}
	}
	return false;
}

function buildHeaderArray($accommFilter,$ratePeriodFilter,$rateTypeFilter){
	global $cols;
	global $colArray;
	global $colSort;
	global $joins;
	global $lDB;
	global $fromDate;
	global $toDate;
	
	$wheresql = "";
	$sql = buildSQL($cols,$colArray,$colSort,$joins);

	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",preg_split("/:/",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",preg_split("/:/",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",preg_split("/:/",$rateTypeFilter['ids']))."')";
	}

	$select = array(
		"rt_rate.rt_rate_ix",
		"rt_rate.ac_accomm_type_id",
		"rt_rate.rt_period_id",
		"rt_rate.rt_pax_rate_group_yn",
		"rt_rate.rt_rate_type_id"
	);
	
	$from = array(
		"rt_rate",
		"INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id",
		"INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix"
	);	
	
	$select = array_unique(array_merge($sql['select'],$select));
	$from = array_unique(array_merge($sql['from'],$from));	
		
		
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}

	
	$finalSelectSQL = "
		SELECT
			".join(",\n",$select)."
	";
	$finalFromSQL = "
		FROM
			".join("\n",$from)."
		WHERE
			1			
		$wheresql
		$dateRangeSQL
	";	

	
	$order = trim(join(",",$sql['sort']));
	if($order != "") {
		$order = " ORDER BY $order ";
	}	
	
	$limit = "";	

	return $lDB->get($finalSelectSQL . $finalFromSQL . $order,2);
	
}

function buildComponentArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateComponentFilter,$taxRateFilter,$taxGroupFilter){
	global $lDB;
	global $fromDate;
	global $toDate;
	
	$wheresql = "";

	$select = array(
		"rt_rate.rt_rate_ix",
		"rt_component.rt_component_desc",
		"rt_rate_component.rt_rate_component_ix",
		"rt_rate_component.rt_comp_opt_yn",
		"rt_rate_component.rt_comp_opt_def_yn",
		"rt_rate_component.rt_comp_comm_yn",
		"rt_rate_component.rt_comp_freq_ind",
		"rt_rate_component.rt_comp_freq_factor",
		"rt_rate_component.rt_comp_separate_yn",
		"rt_rate_component.rt_tax_ind",
		"rt_rate_component.rt_tax_id"
	);	
	
	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",preg_split("/:/",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",preg_split("/:/",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",preg_split("/:/",$rateTypeFilter['ids']))."')";
	}
	
	$from = array(
		"rt_rate_component",
		"INNER JOIN rt_rate ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix",
		"INNER JOIN rt_component ON rt_component.rt_component_ix = rt_rate_component.rt_component_id",
		"INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id",
		"INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix"
	);	
		
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}

	if($rateComponentFilter['ids'] != ""){
		$wheresql .= " AND rt_rate_component.rt_component_id  IN ('".join("','",preg_split("/:/",$rateComponentFilter['ids']))."')";
	}	

	$compOptionalArray = array();
	$compCommArray = array();
	$compFreqArray = array();
	$compSeparateArray  = array();
	

	if ($_SERVER['argv'][12] == "1"){
		$compOptionalArray[] = "1";
	}
	if ($_SERVER['argv'][13] == "1"){
		$compOptionalArray[] = "0";
	}
	if (count($compOptionalArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_opt_yn  IN ('".join("','",$compOptionalArray)."')";		
	}	

	if ($_SERVER['argv'][14] == "1"){
		$compCommArray[] = "0";
	}
	if ($_SERVER['argv'][15] == "1"){
		$compCommArray[] = "1";
	}	
	if ($_SERVER['argv'][16] == "1"){
		$compCommArray[] = "2";
	}
	if ($_SERVER['argv'][17] == "1"){
		$compCommArray[] = "3";
	}		
	if (count($compCommArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_comm_yn  IN ('".join("','",$compCommArray)."')";		
	}	
	
	if ($_SERVER['argv'][18] == "1"){
		$compFreqArray[] = "1";
	}
	if ($_SERVER['argv'][19] == "1"){
		$compFreqArray[] = "2";
	}		
	if (count($compFreqArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_freq_ind  IN ('".join("','",$compFreqArray)."')";		
	}	

	if ($_SERVER['argv'][20] == "1"){
		$compSeparateArray[] = "1";
	}
	if ($_SERVER['argv'][21] == "1"){
		$compSeparateArray[] = "0";
	}
	if (count($compSeparateArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_separate_yn  IN ('".join("','",$compSeparateArray)."')";		
	}	
	
	if($taxRateFilter['ids'] != "" && $taxGroupFilter['ids'] == ""){
		$wheresql .= " AND (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxRateFilter['ids']))."')
			AND rt_rate_component.rt_tax_ind = '10')";
	} elseif ($taxRateFilter['ids'] == "" && $taxGroupFilter['ids'] != ""){
		$wheresql .= " AND (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxGroupFilter['ids']))."') 
			AND rt_rate_component.rt_tax_ind = '20')";		
	} elseif ($taxRateFilter['ids'] != "" && $taxGroupFilter['ids'] != ""){
		$wheresql .= " 
			AND ((rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxRateFilter['ids']))."')
			AND rt_rate_component.rt_tax_ind = '10') OR (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxGroupFilter['ids']))."') 
			AND rt_rate_component.rt_tax_ind = '20'))
		";		
	}	
	
	
	
	$finalSelectSQL = "
		SELECT
			".join(",\n",$select)."
	";
	$finalFromSQL = "
		FROM
			".join("\n",$from)."
		WHERE
			1			
		$wheresql
		$dateRangeSQL
		ORDER BY
			rt_component.rt_component_desc
	";	

	return $lDB->get($finalSelectSQL . $finalFromSQL,2);


}

function buildCompSplitArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateComponentFilter,$rateGroupSplitFilter,$taxRateFilter,$taxGroupFilter){
	global $lDB;
	global $fromDate;
	global $toDate;	

	$wheresql = "";

	$select = array(
		"rt_rate.rt_rate_ix",
		"rt_rate_component.rt_rate_component_ix",
		"rt_rate_comp_grp.rt_rate_group_id",		
		"rt_rate_comp_grp.rt_rate_comp_amt",
		"rt_rate_comp_grp.rt_rate_comp_perc",
		"rt_rate_comp_grp.rt_rate_comp_val_ind",
		"rt_rate_group.rt_rate_group_desc"
	);	
	
	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",preg_split("/:/",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",preg_split("/:/",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",preg_split("/:/",$rateTypeFilter['ids']))."')";
	}
	
	$from = array(
		"rt_rate",
		"INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_id = rt_rate.rt_rate_ix",
		"INNER JOIN rt_rate_comp_grp ON rt_rate_comp_grp.rt_rate_component_id = rt_rate_component.rt_rate_component_ix",
		"INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_comp_grp.rt_rate_group_id",
		"INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id",
		"INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix"
	);	
		
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}
	

	// Component Splits should never show PAX rate group
	$wheresql .= " AND rt_rate_group.rt_rate_group_sys_code  != 99";

	if($rateGroupSplitFilter['ids'] != ""){
		$wheresql .= " AND rt_rate_comp_grp.rt_rate_group_id  IN ('".join("','",preg_split("/:/",$rateGroupSplitFilter['ids']))."')";
	}
	
	if ($_SERVER['argv'][28] == 1){
		$wheresql .= " AND NOT (rt_rate_comp_grp.rt_rate_comp_amt = 0 AND rt_rate_comp_grp.rt_rate_comp_perc = 0)";		
	}	

	// Include component filters as well
	if($rateComponentFilter['ids'] != ""){
		$wheresql .= " AND rt_rate_component.rt_component_id  IN ('".join("','",preg_split("/:/",$rateComponentFilter['ids']))."')";
	}	

	$compOptionalArray = array();
	$compCommArray = array();
	$compFreqArray = array();
	$compSeparateArray  = array();

	if ($_SERVER['argv'][12] == "1"){
		$compOptionalArray[] = "1";
	}
	if ($_SERVER['argv'][13] == "1"){
		$compOptionalArray[] = "0";
	}
	if (count($compOptionalArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_opt_yn  IN ('".join("','",$compOptionalArray)."')";		
	}	

	if ($_SERVER['argv'][14] == "1"){
		$compCommArray[] = "0";
	}
	if ($_SERVER['argv'][15] == "1"){
		$compCommArray[] = "1";
	}	
	if ($_SERVER['argv'][16] == "1"){
		$compCommArray[] = "2";
	}
	if ($_SERVER['argv'][17] == "1"){
		$compCommArray[] = "3";
	}		
	if (count($compCommArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_comm_yn  IN ('".join("','",$compCommArray)."')";		
	}	
	
	if ($_SERVER['argv'][18] == "1"){
		$compFreqArray[] = "1";
	}
	if ($_SERVER['argv'][19] == "1"){
		$compFreqArray[] = "2";
	}		
	if (count($compFreqArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_freq_ind  IN ('".join("','",$compFreqArray)."')";		
	}	

	if ($_SERVER['argv'][20] == "1"){
		$compSeparateArray[] = "1";
	}
	if ($_SERVER['argv'][21] == "1"){
		$compSeparateArray[] = "0";
	}
	if (count($compSeparateArray) > 0){
		$wheresql .= " AND rt_rate_component.rt_comp_separate_yn  IN ('".join("','",$compSeparateArray)."')";		
	}	
	
	if($taxRateFilter['ids'] != "" && $taxGroupFilter['ids'] == ""){
		$wheresql .= " AND (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxRateFilter['ids']))."')
			AND rt_rate_component.rt_tax_ind = '10')";
	} elseif ($taxRateFilter['ids'] == "" && $taxGroupFilter['ids'] != ""){
		$wheresql .= " AND (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxGroupFilter['ids']))."') 
			AND rt_rate_component.rt_tax_ind = '20')";		
	} elseif ($taxRateFilter['ids'] != "" && $taxGroupFilter['ids'] != ""){
		$wheresql .= " 
			AND ((rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxRateFilter['ids']))."')
			AND rt_rate_component.rt_tax_ind = '10') OR (rt_rate_component.rt_tax_id  IN ('".join("','",preg_split("/:/",$taxGroupFilter['ids']))."') 
			AND rt_rate_component.rt_tax_ind = '20'))
		";		
	}	
	
	$finalSelectSQL = "
		SELECT
			".join(",\n",$select)."
	";
	$finalFromSQL = "
		FROM
			".join("\n",$from)."
		WHERE
			1			
		$wheresql
		$dateRangeSQL
		ORDER BY 
			CASE rt_rate_comp_grp.rt_rate_comp_grp_seq WHEN 0 THEN 1 ELSE 0 END,
			rt_rate_comp_grp.rt_rate_comp_grp_seq, rt_rate_group.rt_rate_group_desc
	";	

	return $lDB->get($finalSelectSQL . $finalFromSQL,2);
}

function buildAmountsArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateGroupAmountFilter){
	global $lDB;
	global $fromDate;
	global $toDate;	

	$wheresql = "";

	$select = array(
		"rt_rate.rt_rate_ix",
		"rt_rate_grp_amt.rt_rate_grp_amt_amount",		
		"rt_rate_grp_amt.rt_rate_grp_amt_qty",
		"rt_rate_grp_amt.rt_rate_group_id",
		"rt_rate_group.rt_rate_group_desc"
	);	
	
	if($accommFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.ac_accomm_type_id IN ('".join("','",preg_split("/:/",$accommFilter['ids']))."')";
	}
	
	if($ratePeriodFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_period_id IN ('".join("','",preg_split("/:/",$ratePeriodFilter['ids']))."')";
	}

	if($rateTypeFilter['ids'] != ""){
		$wheresql .= " AND rt_rate.rt_rate_type_id  IN ('".join("','",preg_split("/:/",$rateTypeFilter['ids']))."')";
	}
	
	$from = array(
		"rt_rate_grp_amt",
		"INNER JOIN rt_rate ON rt_rate_grp_amt.rt_rate_id = rt_rate.rt_rate_ix",
		"INNER JOIN rt_period ON rt_period.rt_period_ix = rt_rate.rt_period_id",
		"INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix",
		"INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rt_rate_grp_amt.rt_rate_group_id"
	);	
		
	switch ($_SERVER['argv'][5]){
		case 1:					// All
			$GLOBALS['temp']['dateAllChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "1";
			$dateRangeSQL = "";
			break;
		case 2:					// Future
			$GLOBALS['temp']['dateFutureChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "2";
			
			$maxDate = $GLOBALS['lDB']->get("SELECT MAX(rt_period_to) FROM rt_period_dates",4);
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_from <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_to >= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to <= '".$maxDate."'
					) OR (
						rt_period_dates.rt_period_from <= '".date("Y-m-d")."'
						AND rt_period_dates.rt_period_to >= '".$maxDate."'
					)
				)
			";
			break;
		case 3:					// Date Range
			$GLOBALS['temp']['dateRangeChecked'] = "checked";
			$GLOBALS['temp']['dateRangeOpt'] = "3";
			$dateRangeSQL = "
				AND ( 
					(
						rt_period_dates.rt_period_from >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_from <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_to >= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to <= '".$toDate['jsDate']."'
					) OR (
						rt_period_dates.rt_period_from <= '".$fromDate['jsDate']."'
						AND rt_period_dates.rt_period_to >= '".$toDate['jsDate']."'
					)
				)
			";			
			break;
			
	}

	if($rateGroupAmountFilter['ids'] != ""){
		$wheresql .= " AND rt_rate_grp_amt.rt_rate_group_id  IN ('".join("','",preg_split("/:/",$rateGroupAmountFilter['ids']))."')";
	}
	
	if ($_SERVER['argv'][25] != ""){
		$quantity = $_SERVER['argv'][25];
		
		switch($_SERVER['argv'][24]){
			case 0:
				$operator = "<";
				break;
			case 1:
				$operator = "=";
				break;		
			case 2:
				$operator = ">";
				break;	
		}
		
		$wheresql .= " AND rt_rate_grp_amt.rt_rate_grp_amt_qty $operator $quantity ";
		
	}

	
	$finalSelectSQL = "
		SELECT
			".join(",\n",$select)."
	";
	$finalFromSQL = "
		FROM
			".join("\n",$from)."
		WHERE
			1			
		$wheresql
		$dateRangeSQL
		ORDER BY rt_rate_grp_amt_qty, rt_rate_group_desc
	";	

	return $lDB->get($finalSelectSQL . $finalFromSQL,2);
}

function getRateGroupNames(){
	global $lDB;
	
	$sql = "
		SELECT
			rt_rate_group_ix,
			rt_rate_group_desc
		FROM
			rt_rate_group
	";
	$result = $lDB->get($sql,2);
	
	foreach ($result as $rateGroup){
		$rateGroupNames[$rateGroup['rt_rate_group_ix']] = $rateGroup['rt_rate_group_desc'];
	}

	return $rateGroupNames;

}

function outputCSV($exportData, $renderType="view", $repName="", $repType="xls", $grid=false, $rawCSV=false) {
	global $colArray;
	global $colOrder;
	global $rateGroupNames;

	$rows = array();
	$cells = array();
	$tables = array();
	$tempCell = array();
	$showCompSplits = false;
	$compSplitHeaders = array();
	$headerSet = false;
	$headerRows1 = array();

	$headerRows2 = array();
	$headerRows2Temp = array();
	$headerRows2ComponentRateGroups = array();

	$headerRows3 = array();
	$headerRows3RateHeader = array();
	$headerRows3RateGroupCommission = array();
	$headerRows3Components = array();
	$headerRows3RateGroupSplit = array();
	$headerRows3RateGroupSplitOrder = array();
	$headerRows3Amounts = array();
	$headerRows3AmountsOrder = array();
	$headerRows3Temp = array();
	$headerRows3TempOrder = array();

	$headerRowsRateBuilt = false;
	$gridRows = array();
	$rowNumber = 0;
	$rateColCount = 0;
	$rateColData = array();
	$componentColCount = 0;
	$rowCount = 0;
	$firstRate = true;
	$showAmounts = false;
	$showComponents = false;
	$showRateGroupCommission = false;

	$csv = array();
	$csvFinal = array();
	$csvRows = array();
	$csvRowsTemp = array();
	$headerRows3RateHeaderCSV = array();
	$headerRows3RateGroupCommissionCSV = array();
	$headerRows3ComponentsCSV = array();
	$headerRows3RateGroupSplitCSV = array();
	$headerRows3RateGroupSplitOrderCSV = array();
	$headerRows3AmountsCSV = array();
	$headerRows2ComponentRateGroupsCSV = array();
	
	$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
	$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');
	
	$defaultStyle = array( 
			"alignment" =>array("Horizontal" => "Left", "Vertical" => "Top", "WrapText" => '0')
	);
	
	$defaultStyleCenter = array( 
			"alignment" =>array("Horizontal" => "Center", "Vertical" => "Top", "WrapText" => '0')
	);	

	
	
	$xls = new XLS($defaultStyle);

	$defaultStyleCenter = $xls->addStyle($defaultStyleCenter);

	$header_style1 = array( 
		'interior' => array('Color' => '#F8E8BB', 'Pattern'=>'Solid'),
		'font' =>array('Bold' => '1'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
					
	$header_style1 = $xls->addStyle($header_style1);
	
	$header_style2 = array( 
		'interior' => array('Color' => '#FCF3DA', 'Pattern'=>'Solid'),
		'font' =>array('Bold' => '1'),
		'border' => array($borderL, $borderR, $borderT, $borderB)
	);
					
	$header_style2 = $xls->addStyle($header_style2);
	
	$header_style3 = array( 
		'interior' => array('Color' => '#FCF3DA', 'Pattern'=>'Solid'),
		'font' =>array('Bold' => '1'),
		'border' => array($borderL, $borderR, $borderT, $borderB),
		"alignment" => array("Horizontal" => "Center")
	);
					
	$header_style3 = $xls->addStyle($header_style3);		

	$cell_styleCurrency = array( 
		"alignment" => array("Horizontal" => "Right", "Vertical" => "Top", "WrapText" => '1')
	);
					
	$cell_styleCurrency = $xls->addStyle($cell_styleCurrency);
	
	if ($grid) {

		// START MAIN RATE HEADER
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1" && $colArray[$key]['disabled'] != "1") {
				$cell = $xls->Cell(array("type"=>"String", "data" => $colArray[$key]['label']), $header_style3, '', '', '', '', 0);
				array_push($headerRows3RateHeader, $cell);
				array_push($headerRows3RateHeaderCSV, $colArray[$key]['label']);
				$xls->Column($colArray[$key]['width'],1,0);
			}
		}
		// END MAIN RATE HEADER
		$max = 0;

		// Build Headers

		// Amount Header Row first col
		$cell = $xls->Cell(array("type"=>'String', "data" => "Quantity"), $header_style3, '', '', '', '', 0);
		array_push($headerRows3Amounts, $cell);
		array_push($headerRows3AmountsCSV, "Quantity");

		foreach($exportData as $line) {
			
			if (array_key_exists("components", $line) && count($line['components']) > 0){
				$showComponents = true;
				$rateId = "";
				// Get all Splits columns
				$allRateGroups = array();
				foreach($line['components'] as $compItem){
					if ($rateId == "") $rateId = $compItem['rt_rate_ix'];
					if (array_key_exists('splits', $compItem) && !empty($compItem['splits']) ){
						$showCompSplits = true;
						foreach($compItem['splits'] as $rateGroup =>$compSplitItem){
							if (!in_array($rateGroup,$allRateGroups)){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}
				
				// Component Header Row
				if (!$headerRowsRateBuilt) {
					$cell = $xls->Cell(array("type"=>'String', "data" => "Description"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Description");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Optional"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Optional");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Default"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Default");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Commissionable"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Commissionable");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Frequency"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Frequency");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Separate"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Separate");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Tax"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Tax");
					$cell = $xls->Cell(array("type"=>'String', "data" => "Tax Group"), $header_style3, '', '', '', '', 0);
					array_push($headerRows3Components, $cell);
					array_push($headerRows3ComponentsCSV, "Tax Group");
					$headerRowsRateBuilt = true;
				}
				
				if ($showCompSplits){
					foreach ($allRateGroups as $rateGroup){
						if (!in_array($rateGroup, $headerRows3RateGroupSplitOrder)) {
							$headerRows3RateGroupSplitOrder[] = $rateGroup;
							$cell = $xls->Cell(array("type"=>'String', "data" => "Fixed"), $header_style3, '', '', '', '', 0);
							array_push($headerRows3RateGroupSplit, $cell);
							array_push($headerRows3RateGroupSplitCSV, "Fixed");
							$cell = $xls->Cell(array("type"=>'String', "data" => "%"), $header_style3, '', '', '', '', 0);
							array_push($headerRows3RateGroupSplit, $cell);
							array_push($headerRows3RateGroupSplitCSV, "%");

							$headerRows2ComponentRateGroups[] = $rateGroupNames[$rateGroup];
							$headerRows2ComponentRateGroupsCSV[] = $rateGroupNames[$rateGroup];
						}
					}
					$headerRows3Temp = array();
					$headerRows3TempOrder = array();
					$csvRowsTemp = array();
				}
			}

			if (array_key_exists("amounts", $line) && count($line['amounts']) > 0){
				$showAmounts = true;

				if (!isset($allRateGroups) || empty($allRateGroups)){
					$allRateGroups = array();
					foreach($line['amounts'] as $amtItem){
						if (count($amtItem) > count($allRateGroups)){
							$allRateGroups = array();
							foreach ($amtItem as $rateGroup => $ignoredAmount){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}

				// Amount Header Row
				foreach($allRateGroups as $rateGroup){
					if (!in_array($rateGroup, $headerRows3AmountsOrder)) {
						$headerRows3AmountsOrder[] = $rateGroup;
						$cell = $xls->Cell(array("type"=>'String', "data" => $rateGroupNames[$rateGroup]), $header_style3, '', '', '', '');
						array_push($headerRows3Amounts, $cell);
						array_push($headerRows3AmountsCSV, $rateGroupNames[$rateGroup]);
					}
				}
			}

			if ( ( ($showComponents && $showAmounts) || $showCompSplits ) && empty($headerRows3RateGroupCommission) ) {
				$cell = $xls->Cell(array("type"=>'String', "data" => "Rate Group"), $header_style3, '', '', '', '', 0);
				array_push($headerRows3RateGroupCommission, $cell);
				array_push($headerRows3RateGroupCommissionCSV, "Rate Group");
				$cell = $xls->Cell(array("type"=>'String', "data" => "Commission"), $header_style3, '', '', '', '', 0);
				array_push($headerRows3RateGroupCommission, $cell);
				array_push($headerRows3RateGroupCommissionCSV, "Commission");
				$showRateGroupCommission = true;
			}
		}

		// Build data rows
		foreach($exportData as $line) {
			// Space between rates
			if (!$firstRate) {
				if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
				$cell = $xls->Cell(array("type"=>'String', "data" => ''));
				array_push($gridRows[$rowNumber], $cell);
				array_push($csvRows[$rowNumber], '');
				$rowNumber++;
			}

			if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }

			if(count($line) > $max) {
				$max = count($line);
			}
			foreach($line as $key => $reportItem) {
				if (!is_array($reportItem)){
					if(is_numeric($reportItem)) {
						$dtype = "Number";
					} else {
						$dtype = "String";
					}
					$cell = $xls->Cell(array("type"=>$dtype, "data" => $reportItem));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], $reportItem);
				}
			}
			$rateColData = $gridRows[$rowNumber];
			$rateColDataCSV = $csvRows[$rowNumber];
			
			if (array_key_exists("components", $line) && count($line['components']) > 0){
				$rateId = "";
				// Get all Splits columns
				$allRateGroups = array();
				foreach($line['components'] as $compItem){
					if ($rateId == "") $rateId = $compItem['rt_rate_ix'];
					if (array_key_exists('splits', $compItem) && !empty($compItem['splits'])){
						$showCompSplits = true;			
						foreach($compItem['splits'] as $rateGroup =>$compSplitItem){
							if (!in_array($rateGroup,$allRateGroups)){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}
				
				// If we're going to be showing the Amounts table too, make sure we have all the columns required
				if (isset($line['amounts']) && count($line['amounts']) > 0){
					foreach($line['amounts'] as $amtItem){
							foreach ($amtItem as $rateGroup => $ignoredAmount){
								if (!in_array($rateGroup,$allRateGroups)){
									$allRateGroups[] = $rateGroup;
								}
							}
					}						
				}
				
				// Component commission row

				foreach ($allRateGroups as $rateGroup){
					$commYN = getRateComponentGroupCommissionable($rateId, $rateGroup);
					
					if ($commYN == 1){
						$commCheck = "Yes";
					} else {
						$commCheck = "No";
					}

					if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
					if (empty($gridRows[$rowNumber])) {
						$gridRows[$rowNumber] = $rateColData;
						$csvRows[$rowNumber] = $rateColDataCSV;
					}
					$cell = $xls->Cell(array("type"=>'String', "data" => $rateGroupNames[$rateGroup]));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], $rateGroupNames[$rateGroup]);
					$cell = $xls->Cell(array("type"=>'String', "data" => $commCheck));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], $commCheck);
					$rowNumber++;
				}
				if (empty($allRateGroups)) {
					$cell = $xls->Cell(array("type"=>'String', "data" => ''));

				}

				$rowNumber = !$firstRate ? 1 : 0;

				foreach ($line['components'] as $component){
					if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
					if (empty($gridRows[$rowNumber])) {
						$gridRows[$rowNumber] = $rateColData;
						$csvRows[$rowNumber] = $rateColDataCSV;
						if ( ($showComponents && $showAmounts) || $showCompSplits ) {
							$cell = $xls->Cell(array("type"=>'String', "data" => ''));
							array_push($gridRows[$rowNumber], $cell);
							array_push($csvRows[$rowNumber], '');
							array_push($gridRows[$rowNumber], $cell);
							array_push($csvRows[$rowNumber], '');
						}
					}

					$cell = $xls->Cell(array("type"=>'String', "data" => $component['rt_component_desc']));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], $component['rt_component_desc']);
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_opt_yn'])));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], getYesNo($component['rt_comp_opt_yn']));
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_opt_def_yn'])));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], getYesNo($component['rt_comp_opt_def_yn']));
					$cell = $xls->Cell(array("type"=>'String', "data" => getCompComm($component['rt_comp_comm_yn'])));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], getCompComm($component['rt_comp_comm_yn']));
					$cell = $xls->Cell(array("type"=>'String', "data" => getCompFreq($component['rt_comp_freq_ind'],$component['rt_comp_freq_factor'])));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], getCompFreq($component['rt_comp_freq_ind'],$component['rt_comp_freq_factor']));
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_separate_yn'])));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], getYesNo($component['rt_comp_separate_yn']));
					$cell = $xls->Cell(array("type"=>'String', "data" => ($component['rt_tax_ind'] == 10 ? getCompTax($component['rt_tax_ind'],$component['rt_tax_id']) : '') ));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], ($component['rt_tax_ind'] == 10 ? getCompTax($component['rt_tax_ind'],$component['rt_tax_id']) : ''));
					$cell = $xls->Cell(array("type"=>'String', "data" => ($component['rt_tax_ind'] == 20 ? getCompTax($component['rt_tax_ind'],$component['rt_tax_id']) : '') ));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], ($component['rt_tax_ind'] == 20 ? getCompTax($component['rt_tax_ind'],$component['rt_tax_id']) : ''));

					if ( ($showComponents && $showAmounts) || $showCompSplits ){
						foreach ($headerRows3RateGroupSplitOrder as $rateGroupQueue) {
							if (!in_array($rateGroupQueue, $allRateGroups)) {
								$cell = $xls->Cell(array("type"=>'String', "data" => ''));
								array_push($gridRows[$rowNumber], $cell);
								array_push($gridRows[$rowNumber], $cell);
								array_push($csvRows[$rowNumber], '');
								array_push($csvRows[$rowNumber], '');
							} else {
								foreach($allRateGroups as $rateGroup){							
									if (array_key_exists($rateGroup, $component['splits']) && $component['splits'][$rateGroup] && $rateGroup == $rateGroupQueue){
										$dtype = is_numeric($component['splits'][$rateGroup]['rt_rate_comp_amt']) ? "Number" : "String";
										$cell = $xls->Cell(array("type"=>$dtype, "data" => $component['splits'][$rateGroup]['rt_rate_comp_amt']), $cell_styleCurrency, '', '', '', '', 0);
										array_push($gridRows[$rowNumber], $cell);
										array_push($csvRows[$rowNumber], $component['splits'][$rateGroup]['rt_rate_comp_amt']);
										$dtype = is_numeric($component['splits'][$rateGroup]['rt_rate_comp_perc']) ? "Number" : "String";
										$cell = $xls->Cell(array("type"=>$dtype, "data" => $component['splits'][$rateGroup]['rt_rate_comp_perc']), $cell_styleCurrency, '', '', '', '', 0);
										array_push($gridRows[$rowNumber], $cell);
										array_push($csvRows[$rowNumber], $component['splits'][$rateGroup]['rt_rate_comp_perc']);
									}
								}
							}
						}
					}				
					$rowNumber++;
					$rowCount++;
				}
			}

			
			if (array_key_exists("amounts", $line) && count($line['amounts']) > 0){

				if (!isset($allRateGroups) || empty($allRateGroups)){
					$allRateGroups = array();
					foreach($line['amounts'] as $amtItem){
						if (count($amtItem) > count($allRateGroups)){
							$allRateGroups = array();
							foreach ($amtItem as $rateGroup => $ignoredAmount){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}

				if ($showCompSplits){
					$rateGroupWidth = count($allRateGroups)*2;
				} else {
					$rateGroupWidth = count($allRateGroups);
				}			
				
				$rowNumber = 0;
				
				// Space between rates
				if (!$firstRate) {
					if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
					$cell = $xls->Cell(array("type"=>'String', "data" => ''));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], '');
					$rowNumber++;
				}

				foreach ($line['amounts'] as $quantity => $amtItem){
					if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }

					$headerLenght = count($headerRows3RateHeader) + count($headerRows3RateGroupCommission) + count($headerRows3Components) + count($headerRows3RateGroupSplit);
					if (empty($gridRows[$rowNumber])) {
						$gridRows[$rowNumber] = $rateColData;
					}
					if (count($gridRows[$rowNumber]) < $headerLenght ) {
						$diff = ( $headerLenght - count($gridRows[$rowNumber]) );
						$cell = $xls->Cell(array("type"=>'String', "data" => ''));
						for ($x = 0; $x < $diff; $x++) {
							array_push($gridRows[$rowNumber], $cell);
							array_push($csvRows[$rowNumber], '');
						}
					}

					$cell = $xls->Cell(array("type"=>'Number', "data" => $quantity));
					array_push($gridRows[$rowNumber], $cell);
					array_push($csvRows[$rowNumber], $quantity);
					foreach ($headerRows3AmountsOrder as $amountQueue) {
						if (!in_array($amountQueue, $allRateGroups)) {
							if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
							$cell = $xls->Cell(array("type"=>'Number', "data" => 0));
							array_push($gridRows[$rowNumber], $cell);
							array_push($csvRows[$rowNumber], '');
						} else {
							foreach($allRateGroups as $rateGroup){
								if ($rateGroup == $amountQueue){
									if (!isset($gridRows[$rowNumber])) { $gridRows[$rowNumber] = array(); $csvRows[$rowNumber] = array(); }
									if (!array_key_exists($rateGroup, $amtItem)){
										$cell = $xls->Cell(array("type"=>'Number', "data" => ''), $cell_styleCurrency, '', '', '', '');
										array_push($csvRows[$rowNumber], '');
									} else {
										$cell = $xls->Cell(array("type"=>'Number', "data" => $amtItem[$rateGroup]), $cell_styleCurrency, '', '', '', '');
										array_push($csvRows[$rowNumber], $amtItem[$rateGroup]);
									}
									array_push($gridRows[$rowNumber], $cell);
								}
							}
						}
					}
					$rowNumber++;
				}

			}		
			
			foreach ($gridRows as $gridRow) {
				$row = $xls->Row($gridRow);
				array_push($rows,$row);
				array_push($csv,$csvRows);
			}
			
			$gridRows = array();
			$csvRows = array();
			$rowNumber = 0;
			$firstRate = false;
			$rateColData = array();
		}

		// Build header rows

		// Row 3
		$headerRows3 = array_merge($headerRows3RateHeader, $headerRows3RateGroupCommission, $headerRows3Components, $headerRows3RateGroupSplit, $headerRows3Amounts);
		$headerRows3CSV = array_merge($headerRows3RateHeaderCSV, $headerRows3RateGroupCommissionCSV, $headerRows3ComponentsCSV, $headerRows3RateGroupSplitCSV, $headerRows3AmountsCSV);
		$row = $xls->Row($headerRows3);
		array_unshift($rows,$row);
		array_push($csvFinal, $headerRows3CSV);

		// Row 2
		$cell = $xls->Cell(array("type"=>'String', "data" => ''), $header_style3, '', '', '', '', count($headerRows3RateHeader)-1 );
		array_push($headerRows2, $cell);
		for ($x = 0; $x < count($headerRows3RateHeader)-1; $x++) {
			array_push($csvRowsTemp, '');
		}
		if ($showRateGroupCommission) {
			$cell = $xls->Cell(array("type"=>'String', "data" => ''), $header_style3, '', '', '', '', 1 );
			array_push($headerRows2, $cell);
			array_push($csvRowsTemp, '');
			array_push($csvRowsTemp, '');
		}
		if ($showComponents) {
			$cell = $xls->Cell(array("type"=>'String', "data" => ''), $header_style3, '', '', '', '', count($headerRows3Components)-1 );
			array_push($headerRows2, $cell);
			for ($x = 0; $x < count($headerRows3Components)-1; $x++) {
				array_push($csvRowsTemp, '');
			}
		}

		if ($showCompSplits) {
			foreach ($headerRows2ComponentRateGroups as $headerRows2ComponentRateGroup) {
				$cell = $xls->Cell(array("type"=>'String', "data" => $headerRows2ComponentRateGroup), $header_style3, '', '', '', '', 1 );
				array_push($headerRows2, $cell);
				array_push($csvRowsTemp, $headerRows2ComponentRateGroup);
				array_push($csvRowsTemp, '');
			}
		}
		if ($showAmounts) {
			$cell = $xls->Cell(array("type"=>'String', "data" => ''), $header_style3, '', '', '', '' );
			array_push($headerRows2, $cell);
			array_push($csvRowsTemp, '');
			$cell = $xls->Cell(array("type"=>'String', "data" => 'Rate Group'), $header_style3, '', '', '', '', count($headerRows3Amounts)-2 );
			array_push($headerRows2, $cell);
			array_push($csvRowsTemp, 'Rate Group');
			for ($x = 0; $x < count($headerRows3Amounts)-3; $x++) {
				array_push($csvRowsTemp, '');
			}
		}
		$row = $xls->Row($headerRows2);
		array_unshift($rows,$row);
		array_unshift($csvFinal,$csvRowsTemp);
		$csvRowsTemp = array();

		// Row 1
		$cell = $xls->Cell(array("type"=>'String', "data" => 'Rate Header'), $header_style3, '', '', '', '', count($headerRows3RateHeader)-1 );
		array_push($headerRows1, $cell);
		array_push($csvRowsTemp, 'Rate Header');
		for ($x = 0; $x < count($headerRows3RateHeader)-2; $x++) {
			array_push($csvRowsTemp, '');
		}
		if ($showRateGroupCommission) {
			$cell = $xls->Cell(array("type"=>'String', "data" => 'Rate Group Commission'), $header_style3, '', '', '', '', 1 );
			array_push($headerRows1, $cell);
			array_push($csvRowsTemp, 'Rate Group Commission');
			array_push($csvRowsTemp, '');
		}
		if ($showComponents) {
			$cell = $xls->Cell(array("type"=>'String', "data" => 'Component'), $header_style3, '', '', '', '', count($headerRows3Components)-1 );
			array_push($headerRows1, $cell);
			array_push($csvRowsTemp, 'Component');
			for ($x = 0; $x < count($headerRows3Components)-2; $x++) {
				array_push($csvRowsTemp, '');
			}
		}
		if ($showCompSplits) {
			$cell = $xls->Cell(array("type"=>'String', "data" => 'Rate Group Split'), $header_style3, '', '', '', '', count($headerRows3RateGroupSplit)-1 );
			array_push($headerRows1, $cell);
			array_push($csvRowsTemp, 'Rate Group Split');
			for ($x = 0; $x < count($headerRows3RateGroupSplit)-2; $x++) {
				array_push($csvRowsTemp, '');
			}
		}
		if ($showAmounts) {
			$cell = $xls->Cell(array("type"=>'String', "data" => 'Amounts'), $header_style3, '', '', '', '', count($headerRows3Amounts)-1 );
			array_push($headerRows1, $cell);
			array_push($csvRowsTemp, 'Amounts');
			for ($x = 0; $x < count($headerRows3Amounts)-1; $x++) {
				array_push($csvRowsTemp, '');
			}
		}

		$row = $xls->Row($headerRows1);
		array_unshift($rows,$row);
		array_unshift($csvFinal,$csvRowsTemp);

		foreach ($csv as $lines) {
			if (!empty($lines)) {
				foreach ($lines as $line) {
					array_push($csvFinal, $line);
				}
			}
		}

		$csvRowsTemp = array();

	} else {

		// START MAIN RATE HEADER
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1" && $colArray[$key]['disabled'] != "1") {
				$cell = $xls->Cell(array("type"=>"String", "data" => $colArray[$key]['label']), $header_style1, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$xls->Column($colArray[$key]['width'],1,0);	
			}
		}
		$headerRow = $xls->Row($tempCell);
		$tempCell = array();
		// END MAIN RATE HEADER
		$max = 0;
		foreach($exportData as $line) {
			$showCompSplits = false;	
			if (array_key_exists('components', $line) || array_key_exists('amounts', $line) || !$headerSet){
				array_push($rows,$headerRow);
				$headerSet = true;
			}		
			
			if(count($line) > $max) {
				$max = count($line);
			}
			foreach($line as $key => $reportItem) {
				if (!is_array($reportItem)){
					if(is_numeric($reportItem)) {
						$dtype = "Number";
					} else {
						$dtype = "String";
					}
					$cell = $xls->Cell(array("type"=>$dtype, "data" => $reportItem));
					array_push($tempCell, $cell);
				}
			}
			$row = $xls->Row($tempCell);
			array_push($rows,$row);
			$tempCell = array();
			
			if (array_key_exists("components", $line) && count($line['components']) > 0){
				$rateId = "";
				// Get all Splits columns
				$allRateGroups = array();
				foreach($line['components'] as $compItem){
					if ($rateId == "") $rateId = $compItem['rt_rate_ix'];
					if (array_key_exists('splits', $compItem)){
						$showCompSplits = true;			
						foreach($compItem['splits'] as $rateGroup =>$compSplitItem){
							if (!in_array($rateGroup,$allRateGroups)){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}
				
				// If we're going to be showing the Amounts table too, make sure we have all the columns required
				if (isset($line['amounts']) && count($line['amounts']) > 0){
					foreach($line['amounts'] as $amtItem){
							foreach ($amtItem as $rateGroup => $ignoredAmount){
								if (!in_array($rateGroup,$allRateGroups)){
									$allRateGroups[] = $rateGroup;
								}
							}
					}						
				}
			
				//array_push($rows,$xls->Row(""));
				$tempCell = array(
					$xls->Cell(array("type"=>'String', "data" => "Component Summary"),$header_style2, '', '', '', '', 6)
				);

				if ($showCompSplits){
					foreach ($allRateGroups as $rateGroup){
						$cell = $xls->Cell(array("type"=>'String', "data" => $rateGroupNames[$rateGroup]), $header_style3, '', '', '', '', 1);
						array_push($tempCell, $cell);
					}					
				}
		
				array_push($rows,$xls->Row($tempCell));	
				$tempCell = array();
				
				// Component commission row
				$tempCell = array(
					$xls->Cell(array("type"=>'String', "data" => "Component commission applied"),$header_style2, '', '', '', '', 6)
				);

				if ($showCompSplits){
					foreach ($allRateGroups as $rateGroup){
						$commYN = getRateComponentGroupCommissionable($rateId, $rateGroup);
						
						if ($commYN == 1){
							$commCheck = "Yes";
						} else {
							$commCheck = "No";
						}					
					
						$cell = $xls->Cell(array("type"=>'String', "data" => $commCheck), $header_style3, '', '', '', '', 1);
						array_push($tempCell, $cell);
					}					
				}

				array_push($rows,$xls->Row($tempCell));	
				$tempCell = array();			
				
				// Component Header Row
				$cell = $xls->Cell(array("type"=>'String', "data" => "Description"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Optional"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Commissionable"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Frequency"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Separate"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Tax"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Default"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);

				if ($showCompSplits){
					foreach ($allRateGroups as $rateGroup){
						$cell = $xls->Cell(array("type"=>'String', "data" => "Fixed"), $header_style3, '', '', '', '', 0);
						array_push($tempCell, $cell);
						$cell = $xls->Cell(array("type"=>'String', "data" => "%"), $header_style3, '', '', '', '', 0);
						array_push($tempCell, $cell);
					}
				}

				
				$row = $xls->Row($tempCell);
				array_push($rows,$row);	
				$tempCell = array();			
			
				foreach ($line['components'] as $component){
			
					$cell = $xls->Cell(array("type"=>'String', "data" => $component['rt_component_desc']));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_opt_yn'])));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getCompComm($component['rt_comp_comm_yn'])));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getCompFreq($component['rt_comp_freq_ind'],$component['rt_comp_freq_factor'])));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_separate_yn'])));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getCompTax($component['rt_tax_ind'],$component['rt_tax_id'])));
					array_push($tempCell, $cell);
					$cell = $xls->Cell(array("type"=>'String', "data" => getYesNo($component['rt_comp_opt_def_yn'])));
					array_push($tempCell, $cell);
					if ($showCompSplits){
						foreach($allRateGroups as $rateGroup){
							if (array_key_exists($rateGroup, $component['splits']) && $component['splits'][$rateGroup]){
								$cell = $xls->Cell(array("type"=>'String', "data" => $component['splits'][$rateGroup]['rt_rate_comp_amt']), $cell_styleCurrency, '', '', '', '', 0);
								array_push($tempCell, $cell);
								$cell = $xls->Cell(array("type"=>'String', "data" => $component['splits'][$rateGroup]['rt_rate_comp_perc']), $cell_styleCurrency, '', '', '', '', 0);
								array_push($tempCell, $cell);
							} else {
								$cell = $xls->Cell(array("type"=>'String', "data" => ""), $cell_styleCurrency, '', '', '', '', 0);
								array_push($tempCell, $cell);
								$cell = $xls->Cell(array("type"=>'String', "data" => ""), $cell_styleCurrency, '', '', '', '', 0);
								array_push($tempCell, $cell);						
							}
						}
					}				
					$row = $xls->Row($tempCell);
					array_push($rows,$row);	
					$tempCell = array();
				}
			}
			
			if (array_key_exists("amounts", $line) && count($line['amounts']) > 0){

				if (!isset($allRateGroups) || empty($allRateGroups)){
					$allRateGroups = array();
					foreach($line['amounts'] as $amtItem){
						if (count($amtItem) > count($allRateGroups)){
							$allRateGroups = array();
							foreach ($amtItem as $rateGroup => $ignoredAmount){
								$allRateGroups[] = $rateGroup;
							}
						}
					}
				}

				if ($showCompSplits){
					$rateGroupWidth = count($allRateGroups)*2;
				} else {
					$rateGroupWidth = count($allRateGroups);
				}			
				
				//array_push($rows,$xls->Row(""));
				array_push($rows,$xls->Row(array(
					$xls->Cell(array("type"=>'String', "data" => ""), '', '', '', '', '', 5),
					$xls->Cell(array("type"=>'String', "data" => "Amounts"), $header_style2, '', '', '', '', $rateGroupWidth))
				));				
				
				
				// Amount Header Row
				$cell = $xls->Cell(array("type"=>'String', "data" => ""), '', '', '', '', '', 5);
				array_push($tempCell, $cell);
				$cell = $xls->Cell(array("type"=>'String', "data" => "Quantity"), $header_style2, '', '', '', '', 0);
				array_push($tempCell, $cell);
				if ($showCompSplits){
					$colSpan = 1;
				} else {
					$colSpan = 0;
				}
				foreach($allRateGroups as $rateGroup){
					$cell = $xls->Cell(array("type"=>'String', "data" => $rateGroupNames[$rateGroup]), $header_style3, '', '', '', '', $colSpan);
					array_push($tempCell, $cell);				
				}
				
				$row = $xls->Row($tempCell);
				array_push($rows,$row);	
				$tempCell = array();

				
				foreach ($line['amounts'] as $quantity => $amtItem){
					$cell = $xls->Cell(array("type"=>'String', "data" => ""), '', '', '', '', '', 5);
					array_push($tempCell, $cell);			
					$cell = $xls->Cell(array("type"=>'Number', "data" => $quantity));
					array_push($tempCell, $cell);
					foreach($allRateGroups as $rateGroup){
						if (!array_key_exists($rateGroup, $amtItem)){
							// $cell = $xls->Cell(array("type"=>'String', "data" => '&lt;none&gt;'), $cell_styleCurrency, '', '', '', '', $colSpan);
							$cell = $xls->Cell(array("type"=>'String', "data" => '<none>'), $cell_styleCurrency, '', '', '', '', $colSpan);
						} else {
							$cell = $xls->Cell(array("type"=>'String', "data" => $amtItem[$rateGroup]), $cell_styleCurrency, '', '', '', '', $colSpan);
						}					
						array_push($tempCell, $cell);					
					}
					$row = $xls->Row($tempCell);
					array_push($rows,$row);	
					$tempCell = array();				
				}
			}		
			
			array_push($rows,$xls->Row(""));
		}
	}

	if ($rawCSV) {
		$csvText = "";
		foreach($csvFinal as $csvLine) {
			$first = true;
			foreach($csvLine as $csvItem) {
				if(!$first) {
					$csvText .= ",";
				} else {
					$first = false;
				}
				$csvText .= "\"".str_replace("\"","\"\"",$csvItem)."\"";
			}
			$csvText .= "\n";
		}
		header('Content-Type: text/csv');
		header("Cache-control: private");
		header('Content-Length: '.strlen($csvText));
		header("Content-Disposition: inline; filename=".$repName);
		echo $csvText;
		flush();
		die();
	}

	$table = $xls->Table($rows);
	array_push($tables, $table);
	$xls->Worksheet($tables);
	if ( $renderType == 'view' ) {
		$xls->genrateWorkbook($repName, $repType);
	}
	if ( $renderType == 'send' ) {
		$to = $_POST['mail_to'];
		$from = $_POST['mail_from'];
		$subject = stripslashes($_POST['mail_subj']);
		$message = stripslashes($_POST['mail_body']);
		$attachmentName = $_POST['attachmentName'];

		$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
		$xlsSheet = $xls->genrateWorkbook($repName, $repType, 1);
		
		// and now mail it
		if ( $attachmentName != '!attachmentName!' ) {
			$pdfName = $attachmentName;
		} else {
			$pdfName = $repName;
		}

		// (from, to, subject, headers, message, action, emailID, resID)
		$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$xlsSheet,$pdfName);
		if ( !$error ) {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								a = opener.openMessage("Your email has been sent.");
								a.focus();
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		} else {
			echo '
						<script type="text/javascript" charset="utf-8">
							// <![CDATA[
							if ( opener && !opener.closed ) {
								a = opener.openMessage("Error sending email!");
								a.focus();
							}
							window.close();
							// ]]>
						</script>
					</body>
				</html>
			';
			die();
		}
	}	
}

