<?php

/**
 * init.form2002.php - Rate Sheet
 * Job: 2002
 * Function: 58 (Rates)
*/

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],31,"");

global $cols;
global $colArray;
global $colSort;
global $joins;
global $colData;
global $colOrder;
global $colHeader;
global $fromDate;
global $toDate;
global $rateGroupNames;

$newRelic = new NewRelic();
$newRelic->record_transaction("Rate Sheet");

$pf_object_id = db_pf_object_by_name("rate_sheet");
processProfileAction($pf_object_id,$profileFields);
$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Rate Sheet";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();


if (!array_key_exists($form,$GLOBALS)) {
   $GLOBALS[$form] = "";
}

if (!is_object($GLOBALS[$form])) {
   $GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/rep_rate_sheet.htm");
}

$accommList = "";
$newAccommList = array();

// List of accommodation types that the user has access to
$sql = "SELECT
			sc_accomm.ac_accomm_type_id
		FROM
			sc_accomm
			INNER JOIN sc_user ON sc_accomm.sc_group_id = sc_user.sc_group_id
		WHERE
			sc_user.pr_user_id = '".$GLOBALS['userid']."'";
$userAccommList = $GLOBALS['lDB']->get($sql, 3);

// List of accommodation types passed using the Prop/Accomm Filter
$passedAccommList = $_SERVER['argv'][1];

if (trim($passedAccommList) == "") {
	// If no accommodation types passed, and we default to All, use only All accommodation types that the user has access to
	$accommList = implode(":", $userAccommList);
} else {
	// Check each passed accommodation type against the list of allowed types, and build shortlist
	$passedAccommListArray = explode(":", $passedAccommList);
	foreach ($passedAccommListArray as $accomm) {
		if (in_array($accomm, $userAccommList)) {
			$newAccommList[] = $accomm;
		}
	}
	$accommList = !empty($newAccommList) ? implode(":", $newAccommList) : implode(":", $userAccommList) ;
	$newAccommList = array();
}

$accommFilter = useFilter("accomm",$accommList,"SELECT CONCAT(ac_accomm_type.ac_accomm_desc,CONCAT(' - ',pr_business.pr_bus_name_short)) FROM ac_accomm_type INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id WHERE ac_accomm_type_ix =","",false,false,false);	
$ratePeriodFilter = useFilter("ratePeriod",$_SERVER['argv'][2],"SELECT rt_period.rt_period_desc FROM rt_period WHERE rt_period.rt_period_ix=","",false,false,false);
$rateTypeFilter = useFilter("rate",$_SERVER['argv'][3],"SELECT rt_rate_type.rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type.rt_rate_type_ix =","",false,false,false);

$fromDate = useDate("from",$_SERVER['argv'][6]);
$toDate = useDate("to",$_SERVER['argv'][7]);

$GLOBALS['temp']['dateAllChecked'] = "checked";
$GLOBALS['temp']['dateRangeOpt'] = "1";

if($_SERVER['argv'][8] == "1") {
	$GLOBALS['temp']['reportDetailComponentsChecked'] = "checked";
	$GLOBALS['temp']['ComponentFiltersClass'] = "expand";
	$GLOBALS['temp']['compSplitEnabled'] = "";
} else {
	$GLOBALS['temp']['reportDetailComponentsChecked'] = "";
	$GLOBALS['temp']['ComponentFiltersClass'] = "collapse printCollapse";
	$GLOBALS['temp']['compSplitEnabled'] = "disabled";
}
if($_SERVER['argv'][9] == "1") {
	$GLOBALS['temp']['reportDetailCompSplitsChecked'] = "checked";
	$GLOBALS['temp']['CompSplitFiltersClass'] = "expand";
	// Force components checked too
	$GLOBALS['temp']['reportDetailComponentsChecked'] = "checked";
	$GLOBALS['temp']['ComponentFiltersClass'] = "expand";
	$GLOBALS['temp']['compSplitEnabled'] = "";
} else {
	$GLOBALS['temp']['reportDetailCompSplitsChecked'] = "";
	$GLOBALS['temp']['CompSplitFiltersClass'] = "collapse printCollapse";
}
if($_SERVER['argv'][10] == "1") {
	$GLOBALS['temp']['reportDetailAmountsChecked'] = "checked";
	$GLOBALS['temp']['AmountFiltersClass'] = "expand";
} else {
	$GLOBALS['temp']['reportDetailAmountsChecked'] = "";
	$GLOBALS['temp']['AmountFiltersClass'] = "collapse printCollapse";
}


$rateComponentFilter = useFilter("rateComponent",$_SERVER['argv'][11],"SELECT rt_component.rt_component_desc FROM rt_component WHERE rt_component.rt_component_ix =","",false,false,false);

if($_SERVER['argv'][12] == "1") {
	$GLOBALS['temp']['compOptionalNoChecked'] = "checked";
}
if($_SERVER['argv'][13] == "1") {
	$GLOBALS['temp']['compOptionalYesChecked'] = "checked";
}

if($_SERVER['argv'][14] == "1") {
	$GLOBALS['temp']['compCommissionNCChecked'] = "checked";
}
if($_SERVER['argv'][15] == "1") {
	$GLOBALS['temp']['compCommissionCChecked'] = "checked";
}
if($_SERVER['argv'][16] == "1") {
	$GLOBALS['temp']['compCommissionCDChecked'] = "checked";
}
if($_SERVER['argv'][17] == "1") {
	$GLOBALS['temp']['compCommissionCDAChecked'] = "checked";
}

if($_SERVER['argv'][18] == "1") {
	$GLOBALS['temp']['compFrequencyPNChecked'] = "checked";
}
if($_SERVER['argv'][19] == "1") {
	$GLOBALS['temp']['compFrequencyPSChecked'] = "checked";
}

if($_SERVER['argv'][20] == "1") {
	$GLOBALS['temp']['compSeparateNoChecked'] = "checked";
}
if($_SERVER['argv'][21] == "1") {
	$GLOBALS['temp']['compSeparateYesChecked'] = "checked";
}

$taxRateFilter = useFilter("taxRate",$_SERVER['argv'][26],"SELECT rf_tax_rate.rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate.rf_tax_rate_ix =","",false,false,false);

$taxGroupFilter = useFilter("taxGroup",$_SERVER['argv'][27],"SELECT rt_tax_group.rt_tax_group_desc FROM rt_tax_group WHERE rt_tax_group.rt_tax_group_ix =","",false,false,false);

$rateGroupSplitFilter = useFilter("rateGroupSplit",$_SERVER['argv'][22],"SELECT rt_rate_group.rt_rate_group_desc FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_ix =","",false,false,false);

if($_SERVER['argv'][28] == "1") {
	$GLOBALS['temp']['splitIgnoreZerosChecked'] = "checked";
}

$rateGroupAmountFilter = useFilter("rateGroupAmount",$_SERVER['argv'][23],"SELECT rt_rate_group.rt_rate_group_desc FROM rt_rate_group WHERE rt_rate_group.rt_rate_group_ix =","",false,false,false);

switch($_SERVER['argv'][24]){
	case 0:
		$GLOBALS['temp']['amountQtySelect0Selected'] = "selected";
		break;
	case 1:
		$GLOBALS['temp']['amountQtySelect1Selected'] = "selected";
		break;		
	case 2:
		$GLOBALS['temp']['amountQtySelect2Selected'] = "selected";
		break;	
}

if($_SERVER['argv'][25] != "") {
	$GLOBALS['temp']['amountQty'] = $_SERVER['argv'][25];
} else {
	$GLOBALS['temp']['amountQty'] = "";
}


if (strtolower($GLOBALS['username']) == "censysad"){
	$GLOBALS['temp']['button_duplicate'] = "

		<td align=\"center\"><input onclick=\"duplicateRatesPopup();\" type=\"button\" style=\"width:90; height:20; \" class=\"button\" disabled=\"disabled\" id=\"btnDuplicate\" value=\"Duplicate\"></td>
		<td width=\"10\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>

	";
} else {
	$GLOBALS['temp']['button_duplicate'] = "";
}

getColData();
$GLOBALS['temp']['colData'] = $colData;

$page = $_SERVER['argv'][4];
if (trim($page) == "") {
	$page = "1";
}
$GLOBALS['temp']['page'] = $page;
$options = $_SERVER['argv'][30];

$renderMode = "";
switch ( $options) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_PDF:
	$renderMode = "pdf";
	$renderType = "email";
	break;
case REP_SEND_PDF:
	$renderMode = "pdf";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "oofice";
	$renderType = "view";
	break;	
case REP_VIEW_CSV_GRID:
	$renderMode = "csvgrid";
	$renderType = "view";
	break;
case REP_VIEW_OO_GRID:
	$renderMode = "ooficegrid";
	$renderType = "view";
	break;
case REP_VIEW_CSV_GRID_RAW:
	$renderMode = "csvgridraw";
	$renderType = "view";
	break;
}

if ( $renderMode == "pdf" && $renderType == "email" ) {
	outputMail($form,$options,$fromDate['htmlDate'],$toDate['htmlDate']);
}

$GLOBALS['temp']['makeReport'] = "collapse printCollapse";
$GLOBALS['temp']['filterDivClass'] = "expand";
$GLOBALS['temp']['showHideFilterButtonText'] = "<< Hide Filters"; 
$GLOBALS['temp']['dateRangeOpt'] = "1";

if($_SERVER['argc'] > 1) {
	$masterArray = array();
	$rateGroupNames = getRateGroupNames();
	
	$GLOBALS['temp']['filterDivClass'] = "collapse printCollapse";
	$GLOBALS['temp']['showHideFilterButtonText'] = "<< Show Filters"; 
	$reportTitle = $GLOBALS['temp']['title'];
	
	$headerArray = buildHeaderArray($accommFilter,$ratePeriodFilter,$rateTypeFilter);

	foreach ($headerArray as $row){
		$masterArray[$row['rt_rate_ix']] = $row;
		$masterArray[$row['rt_rate_ix']]['components'] = array();
		$masterArray[$row['rt_rate_ix']]['amounts'] = array();
	}
	unset($headerArray);
	
	if ($_SERVER['argv'][8] == "1"){
		$componentArray = buildComponentArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateComponentFilter,$taxRateFilter,$taxGroupFilter);	
		
		foreach ($componentArray as $row){
			if(isset($masterArray[$row['rt_rate_ix']])) {
				$masterArray[$row['rt_rate_ix']]['components'][$row['rt_rate_component_ix']] = $row;
				$masterArray[$row['rt_rate_ix']]['components'][$row['rt_rate_component_ix']]['splits'] = array();
			}
		}
		unset($componentArray);
	}
	
	if ($_SERVER['argv'][9] == "1"){
		$compSplitArray = buildCompSplitArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateComponentFilter,$rateGroupSplitFilter,$taxRateFilter,$taxGroupFilter);	
		
		foreach ($compSplitArray as $row){
			if(isset($masterArray[$row['rt_rate_ix']])) {
				$masterArray[$row['rt_rate_ix']]['components'][$row['rt_rate_component_ix']]['splits'][$row['rt_rate_group_id']] = $row;
			}
		}	
		unset($compSplitArray);
	}	
	
	if ($_SERVER['argv'][10] == "1"){
		$amountsArray = buildAmountsArray($accommFilter,$ratePeriodFilter,$rateTypeFilter,$rateGroupAmountFilter);	
		
		foreach ($amountsArray as $row){
			if(isset($masterArray[$row['rt_rate_ix']])) {
				$masterArray[$row['rt_rate_ix']]['amounts'][$row['rt_rate_grp_amt_qty']][$row['rt_rate_group_id']] = $row['rt_rate_grp_amt_amount'];
			}
		}	
		unset($amountsArray);		
	}	
	
	
//	debug($masterArray['WB545']);
	
	// if($renderMode == "html") {

		// $rows = $lDB->get($finalSelectSQL . $finalFromSQL,2);
		// $totalRows = count($rows);

		// $pageLength = 35;
		// $GLOBALS['temp']['pageCount'] = ceil($totalRows/$pageLength);
		// $GLOBALS['temp']['pageNum'] = $page;
		// $GLOBALS['temp']['nextPageNum'] = $page+1;
		// $GLOBALS['temp']['prevPageNum'] = $page-1;
		// if ($page == 1) {
			// $GLOBALS['temp']['hidePrevButton'] = "class=\"collapse printCollapse\"";
		// } else {
			// $GLOBALS['temp']['hidePrevButton'] = "class=\"button printCollapse\"";
		// }
		// if ($page >= $GLOBALS['temp']['pageCount']) {
			// $GLOBALS['temp']['hideNextButton'] = "class=\"collapse printCollapse\"";
		// } else {
			// $GLOBALS['temp']['hideNextButton'] = "class=\"button printCollapse\"";
		// }
		// $totalPages = ceil($totalRows/$pageLength);
		// if (($totalPages - $page) < 2 ) {
			// $startPage = $totalPages - 2;
		// } elseif($page < 4) {
			// $startPage = 4;
		// } else {
			// $startPage = $page;
		// }
		// if ($page != 1) {
			// $pageList .= "<A class=\"txtbr\" href=\"#\" onclick=\"setPage(1);\">1</A>";
		// } else {
			// $pageList = "<B>1</B>";
		// }
		// for($count = 2; $count <= ($totalPages > 8?8:$totalPages); $count++) {
			// if ($count == $page) {
				// $pageList .= ", <B>$count</B>";
			// } else {
				// $pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($count);\">$count</A>";
			// }
		// }
		// if (($totalPages - $page) > 3 ) {
			// $pageList .= ", <A class=\"txtbr\" href=\"#\" onclick=\"setPage($totalPages);\">Last</SPAN>";
		// }
		// $GLOBALS['temp']['pageList'] = $pageList;

		// $limit = " LIMIT ". (($page-1) * $pageLength ) .",".$pageLength;
		// $GLOBALS['temp']['recFound'] = $totalRows;//sizeof($rowArray);
	// }

	$newList = array();
	$rateList = array();
	
	foreach($masterArray as $item) {
		$newItem = array();

		foreach($colOrder as $key=>$colItem) {
			if($colArray[$key]['active'] == "1") {
				$values = array();
				$colItem = getCol($key);

				foreach($colItem['fields'] as $field) {
					array_push($values,$item[getFieldName($field)]);
				}
				switch($colItem['type']) {
				default:
				case "string":
					$value = trim(str_replace("\r","",join(" ",$values)));
					break;
				case "date":
					$value = "";
					if($values[0] != "0000-00-00") {
						$value = chng_date($values[0],"-");
					}
					break;
				case "complex":
					if(isset($colItem['function']) && function_exists($colItem['function'])) {
						$value = call_user_func_array($colItem['function'],$values);
					} else {
						$value = "NOT IMPLEMENTED";
					}
					break;
				}
				
				if (isset($colItem['disabled'])) {
					// Ignore this field (for example if we've deleted a field and don't want to break profiles)
				} else {
					$newItem[$key] = $value;
				}				

			}
		}


		if ($_SERVER['argv'][8] == "1"){
			$newItem['components'] = $item['components'];
		}
		
		if ($_SERVER['argv'][10] == "1"){
			$newItem['amounts'] = $item['amounts'];
		}		
		
		if(sizeof($newItem) > 0) {
			array_push($newList,$newItem);
			$rate = array(
				"rt_rate_ix" => $item['rt_rate_ix'],
				"ac_accomm_type_ix" => $item['ac_accomm_type_id'],
				"rt_period_ix" => $item['rt_period_id'],
				"rt_rate_type_ix" => $item['rt_rate_type_id'],
			);
			array_push($rateList,$rate);
		}
	}
	$list = $newList;
	$newList = null;
	
	if($renderMode == "html") {		
		$GLOBALS['temp']['makeReport'] = "";
		setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
		$compHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_comp_rows.htm"));
		$compListHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_comp_list_rows.htm"));
		$compSplitHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_comp_split_rows.htm"));
		$compSplitListHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_comp_split_list_rows.htm"));
		$amtHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_amt_rows.htm"));
		$amtListHTML = join("", file(__DIR__ . "/../../../public/html/rate_sheet_amt_list_rows.htm"));				
		$dataCol = "";
		$dataHeader1 = "";
		$dataHeader2 = "";
		$dataColCount = 0;
		$lastHeader = "";
		$lastHeaderCount = 0;
		$headerSet = false;
		if (count($list) == 0){
			$GLOBALS['temp']['dataCol'] = "";
			$GLOBALS['temp']['dataHeader'] = "";
			$GLOBALS['temp']['dataColCount'] = "";
			$GLOBALS['temp']['dataRows'] = "
				<table id=\"dataTable\" cellspacing=\"0\" cellpadding=\"2\" align=\"left\" style=\"table-layout:fixed;\">
					<tr>
						<td height=\"20\">
							Your search did not match any records.<p><b>Suggestions:</b>
							<br>- Use wildcards to assist in your search<br>&nbsp;(e.g. B* to list all records starting with B)<br>- Use a different keyword.
						</td>
					</tr>
				</table>
			";
			
		} else {
			$dataHeader1 .= "<td class=\"outLt\" style=\"width: 19px\" >&nbsp;</td>";
			$dataHeader2 .= "<td class=\"outLt\" style=\"width: 19px\" >&nbsp;</td>";
			//$dataCol .= "<col width=\"5\" />";
			$align = "";
			foreach($colOrder as $key=>$item) {
				if($colArray[$key]['active'] == "1" && $colArray[$key]['disabled'] != "1") {
					//$dataCol .= "<col width=\"".$colArray[$key]['width']."px\" />";
					$align = "";
					if($colArray[$key]['align'] == "c") {
						$align = "align=\"center\"";
					}
					if($colArray[$key]['align'] == "r") {
						$align = "align=\"right\"";
					}
					if($colHeader) {
						if($lastHeader != "" && $lastHeader != $colArray[$key]['header']) {
							$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\" style=\"width: ".$combinedHeaderWidth."px\">".$lastHeader."</td>";
							$lastHeader = "";
							$lastHeaderCount = 0;
						}	
						if($colArray[$key]['header'] != "") {
							$dataHeader2 .= "<td class=\"outLt\" $align style=\"width: ".($colArray[$key]['width']+1)."px\">".$colArray[$key]['label']."</td>";
							$lastHeader = $colArray[$key]['header'];
							$lastHeaderCount++;
							$combinedHeaderWidth = $combinedHeaderWidth + $colArray[$key]['width'] + 4;
						} else {
							$dataHeader1 .= "<td class=\"outLt\" rowspan=\"2\" $align style=\"width: ".($colArray[$key]['width']+1)."px\">".$colArray[$key]['label']."</td>";
						}
					} else {
						$dataHeader1 .= "<td class=\"outLt\" $align style=\"width: ".($colArray[$key]['width']+1)."px\">".$colArray[$key]['label']."</td>";
					}
					$dataColCount++;

				}
			}
			
			if($lastHeader != "") {
				$dataHeader1 .= "<td class=\"outLt\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
			}
			$dataHeader = "<tr>$dataHeader1</tr>";
			if($colHeader) {
				$dataHeader .= "<tr>$dataHeader2</tr>";
			}

			$rows = "";
			
			foreach($list as $listKey=>$item) {
			    $compOutput = "";
				$compSplitOutput = "";
				$amtOutput = "";
				$prevRateId = isset($rateList[$listKey-1]) ? $rateList[$listKey-1] : "";
				$rateId = $rateList[$listKey]['rt_rate_ix'];			
				$tableWidth = 20;
				foreach($item as $key=>$cell) {
					$tableWidth += isset($colArray[$key]['width']) ? $colArray[$key]['width'] : 0;
				}
				
				if ($_SERVER['argv'][8] == "1" || $_SERVER['argv'][10] == "1"){
					$scrollSub = "scrollX";
				} else {
					$scrollSub = "";
				}
				
				$rows .= "
					<div class=\"$scrollSub\" style=\"width: 768px; margin: 0 auto;\">
					<table id=\"dataTable\" width=\"".$tableWidth."px\" cellspacing=\"0\" cellpadding=\"2\" align=\"left\" style=\"clear: both; table-layout:fixed;\">
					<tbody>
				";

				if ($_SERVER['argv'][8] == "1" || $_SERVER['argv'][10] == "1" || !$headerSet){
					$rows .= "$dataHeader";
					$headerSet = true;
				}

				$rows .= "<tr class='linkrow' onclick=\"unloadP('RateSheetScroll');rateEditPage('404', '$rateId');\" onmouseover=\"this.style.backgroundColor = '#CCFFCC'\" onmouseout=\"this.style.backgroundColor = 'white'\" style=\"background-color: white;\">";

				// Selection box
				if ($rateId != $prevRateId){
					$rows .= "
						<td class=\"br bb\" style=\"width: 20px\" $align>
							<input id=\"tick".$listKey."\" name=\"tick\" class=\"forminput\"  type=\"checkbox\" onclick=\"event.cancelBubble = true;checkCanDuplicate();\">
							<input id=\"detail".$listKey."\" type=\"hidden\" value=\"".$rateList[$listKey]['ac_accomm_type_ix'].":".$rateList[$listKey]['rt_period_ix'].":".$rateList[$listKey]['rt_rate_type_ix']."\"></input>
							<input id=\"rateId".$listKey."\" type=\"hidden\" value=\"$rateId\">
						</td>
					";
				} else {
					$rows .= "<td class=\"br bb\" style=\"width: 20px\" $align></td>";
				}	
				foreach($item as $key=>$cell) {
					if (is_numeric($key)){
						$align = "";
						if($colArray[$key]['align'] == "c") {
							$align = "align=\"center\"";
						}
						if($colArray[$key]['align'] == "r") {
							$align = "align=\"right\"";
						}
						if($cell == "") {
							$cell = "&nbsp;";
						} else {
							$cell = str_replace("\n","<br />",$cell);
						}
						$rows .= "<td class=\"br bb\" $align style=\"width: ".($colArray[$key]['width']+2)."px\">$cell</td>";
					}
				}
				$rows .= "</tr>";
				//$rows .= "<td height=\"10\"><img src=\"/resource/Resrequest/Application/public/img/1x1.gif\"></td>";
				$rows .= "</tbody></table></div>";				
				
				//$rows .= "<div style=\"width: 750px;padding: 10px;\" class=\"scrollX\">";
				// Show components table?
				$GLOBALS['temp']['scrollAll'] = "scrollX";
				if ($_SERVER['argv'][8] == "1"){
					$GLOBALS['temp']['scrollAll'] = "";
					if (count($item['components']) > 0){
						foreach($item['components'] as $compItem){
							$compSplits = "";
							$compRow['compDesc'] = $compItem['rt_component_desc'];
							$compRow['compOpt'] = getYesNo($compItem['rt_comp_opt_yn']);
							$compRow['compDef'] = getYesNo($compItem['rt_comp_opt_def_yn']);
							$compRow['compComm'] = getCompComm($compItem['rt_comp_comm_yn']);
							$compRow['compFreq'] = getCompFreq($compItem['rt_comp_freq_ind'], $compItem['rt_comp_freq_factor']);
							$compRow['compSep'] = getYesNo($compItem['rt_comp_separate_yn']);
							$compRow['compTax'] = getCompTax($compItem['rt_tax_ind'],$compItem['rt_tax_id']);
							$compOutput .= showpage($compRow, $compListHTML);     				
						}
						$thisCompHTML = str_replace("!compListRow!", $compOutput, $compHTML);
					} else {
						$thisCompHTML = "";
					}
				}

				// Show component splits table?
				if ($_SERVER['argv'][9] == "1"){
					if (count($item['components']) > 0){
						// Get all Splits columns
						$allRateGroups = array();
						foreach($item['components'] as $compItem){
							if (array_key_exists("splits", $compItem)){
								foreach($compItem['splits'] as $rateGroup =>$compSplitItem){
									if (!in_array($rateGroup,$allRateGroups)){
										$allRateGroups[] = $rateGroup;
									}
								}								
							}

						}
						
						// If we're going to be showing the Amounts table too, make sure we have all the columns required
						if ($_SERVER['argv'][10] == "1"){
							foreach($item['amounts'] as $amtItem){
									foreach ($amtItem as $rateGroup => $ignoredAmount){
										if (!in_array($rateGroup,$allRateGroups)){
											$allRateGroups[] = $rateGroup;
										}
									}
							}						
						}
						
						$colSpan = 1;
						$tableWidth = 0;							
						$rateGroupHeaders = "";
						$rateGroupSubHeaders = "";
						$rateGroupCommYN = "";
						foreach($allRateGroups as $rateGroup){
							$colSpan = $colSpan + 2;
							$tableWidth += 100;
							$commYN = getRateComponentGroupCommissionable($rateId, $rateGroup);
							
							if ($commYN == 1){
								$commCheck = "Yes";
							} else {
								$commCheck = "No";
							}
						
							$rateGroupHeaders .= "<td class=\"br bb\" colspan=\"2\" align=\"center\" style=\"width: 100px\">".$rateGroupNames[$rateGroup]."</td>";
							$rateGroupSubHeaders .= "<td class=\"br bb\" align=\"center\" style=\"width: 50px\">Fixed</td><td class=\"br bb\" align=\"center\" style=\"width: 50px\">%</td>";
							$rateGroupCommYN .= "<td class=\"br bb\" colspan=\"2\" align=\"center\" style=\"width: 100px\">".$commCheck."</td>";
						}
					
						foreach($item['components'] as $compItem){
							$compSplits	= "";
							foreach($allRateGroups as $rateGroup){
								if (array_key_exists($rateGroup, $compItem['splits'])){
									$compSplits .= "<td class=\"br\" align=\"right\" style=\"width: 50px\">".$compItem['splits'][$rateGroup]['rt_rate_comp_amt']."</td>";
									$compSplits .= "<td class=\"br\" align=\"right\" style=\"width: 50px\">".$compItem['splits'][$rateGroup]['rt_rate_comp_perc']."</td>";									
								} else {
									$compSplits .= "<td class=\"br\" align=\"right\" style=\"width: 50px\">N/A</td>";
									$compSplits .= "<td class=\"br\" align=\"right\" style=\"width: 50px\">N/A</td>";																		
								}
							}
							$compSplitOutput .=  str_replace("!compSplits!", $compSplits, $compSplitListHTML);
						}
						$thisCompSplitHTML = str_replace("!rateGroupHeaders!", $rateGroupHeaders, $compSplitHTML);
						$thisCompSplitHTML = str_replace("!rateGroupCommYN!", $rateGroupCommYN, $thisCompSplitHTML);
						$thisCompSplitHTML = str_replace("!rateGroupSubHeaders!", $rateGroupSubHeaders, $thisCompSplitHTML);
						$thisCompSplitHTML = str_replace("!tableWidth!", $tableWidth."px", $thisCompSplitHTML);
						$thisCompSplitHTML = str_replace("!colSpan!", $colSpan, $thisCompSplitHTML);
						$thisCompSplitHTML = str_replace("!compSplitListRows!", $compSplitOutput, $thisCompSplitHTML);	
						$thisCompSplitHTML = str_replace("!rateId!", $rateId, $thisCompSplitHTML);
						
						$thisCompHTML = str_replace("!compSplits!", $thisCompSplitHTML, $thisCompHTML);
					} else {
						$thisCompHTML = "";
					}
				} else {
					if (isset($thisCompHTML)){
						$thisCompHTML = str_replace("!compSplits!", "", $thisCompHTML);
					}  else {
						$thisCompHTML = "";
					}
					
				}

				$rows .= $thisCompHTML;
				
				// Show Amounts table?
				if ($_SERVER['argv'][10] == "1"){
					$GLOBALS['temp']['scrollAll'] = "";
					if (count($item['amounts']) > 0){
						// Basically what we're doing here if finding the largest "set" of Rate Groups, as this will form the headers of our Amounts table
						// UNLESS we already have a list of rate groups from the Comp Splits table above
						if (!isset($allRateGroups) || empty($allRateGroups)){
							$allRateGroups = array();
							foreach($item['amounts'] as $amtItem){
								if (count($amtItem) > count($allRateGroups)){
									$allRateGroups = array();
									foreach ($amtItem as $rateGroup => $ignoredAmount){
										$allRateGroups[] = $rateGroup;
									}
								}
							}
						}
						$amtListQtyRow = "";
						foreach($item['amounts'] as $qty => $amtItem){
							switch ($qty){
								case 0:
									$qtyLabel = "1 Sharing";
									break;
								case 1:
									$qtyLabel = "1 Single";
									break;
								default:
									$qtyLabel = $qty;
							}
							$amtListQtyRow .= "
								<tr class=\"colWh\">
									<td class=\"br\" style=\"width: 50px\">$qtyLabel</td>
								</tr>
							";
							$rateGroupColWidths = "";
							$amtRow['amtRateGroups'] = "";
							$tableWidth = 0;
							$rateGroupHeaders = "";
							foreach($allRateGroups as $rateGroup){
								if (!array_key_exists($rateGroup, $amtItem)){
									if (isset($item['rt_pax_rate_group_yn']) && $item['rt_pax_rate_group_yn'] == 1){
										$amtRow['amtRateGroups'] .= "<td class=\"br\" align=\"right\"><span style=\"white-space: nowrap\" style=\"width: 100px\">N/A</span></td>";	
									} else {
										$amtRow['amtRateGroups'] .= "<td class=\"br\" align=\"right\"><span style=\"white-space: nowrap\" style=\"width: 100px\">&lt;none&gt;</span></td>";	
									}
									
								} else {
									$amtRow['amtRateGroups'] .= "<td class=\"br\" align=\"right\"><span style=\"white-space: nowrap\" style=\"width: 106px\">".$amtItem[$rateGroup]."</span></td>";
								}
								$tableWidth += 106;
								$rateGroupHeaders .= "<td class=\"br bb bt\" align=\"center\" style=\"width: 106px\">".$rateGroupNames[$rateGroup]."</td>";
								//$rateGroupColWidths .= "<col width=\"100px\" />";
							}
							$amtOutput .= showpage($amtRow, $amtListHTML);
						}
						$thisAmtHTML = str_replace("!amtListQtyRow!", $amtListQtyRow, $amtHTML);
						$thisAmtHTML = str_replace("!amtListRow!", $amtOutput, $thisAmtHTML);
						$thisAmtHTML = str_replace("!amtRateGroupHeaders!",$rateGroupHeaders, $thisAmtHTML);
						$thisAmtHTML = str_replace("!tableWidth!",$tableWidth."px", $thisAmtHTML);
						$thisAmtHTML = str_replace("!colSpan!",count($allRateGroups)+1, $thisAmtHTML);
						$thisAmtHTML = str_replace("!rateId!", $rateId, $thisAmtHTML);
						$rows .= $thisAmtHTML;
					}
				}

				$rows .= "<br />";	
			}

			$GLOBALS['temp']['dataRows'] = $rows;
		}
	}
	if($renderMode == "pdf" && ($renderType == "view" || $renderType == "send")) {
		$pdf = new PDF($reportTitle,"L");


		$pdf->SetFont('Arial', '', 9);
		$pdf->Row(array(
			array(data=>"<B>$reportTitle: $GLOBALS[principal_name]</B>")
		));
		$pdf->SetFont('Arial', '', 8);
		$pdf->Row(array(
			array(data=>"Date range: " . $fromDate['htmlDate'] . " to " . $toDate['htmlDate'])
		));

		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->Row(array(array()));
		// Main PDF header
		$headerArray = array();

		$header1 = array();
		$header2 = array();
		$totalWidth = 0;
		$lastHeader = "";
		$lastHeaderWidth = 0;
		foreach($colOrder as $key=>$item) {
			if($colArray[$key]['active'] == "1" && $colArray[$key]['disabled'] != "1") {
				$width = $colArray[$key]['width'] / 770 * 100;
				$align = strtoupper($colArray[$key]['align']);
				if($colHeader) {
					if($lastHeader != "" && $lastHeader != $colArray[$key]['header']) {
						array_push($header1,array('width'=>$lastHeaderWidth."%",'data'=>$lastHeader,'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
						$lastHeader = "";
						$lastHeaderWidth = 0;
					}					
					if($colArray[$key]['header'] != "") {
						$lastHeader = $colArray[$key]['header'];
						$lastHeaderWidth += $width;
					} else {
						array_push($header1,array('width'=>$width."%",'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
					}
					array_push($header2,array('width'=>$width . "%", 'data'=>$colArray[$key]['label'],'fill'=>"1",'border'=>"LRTB",'align'=>$align));
				} else {
					array_push($header1,array('width'=>$width . "%", 'data'=>$colArray[$key]['label'],'fill'=>"1",'border'=>"LRTB",'align'=>$align));
				}
				$totalWidth += $width;

			}
		}
		if($colHeader) {
			if($lastHeader != "") {
				array_push($header1,array('width'=>$lastHeaderWidth."%",'data'=>$lastHeader,'fill'=>"1",'align'=>"C",'border'=>"LRTB"));
			}
			$pdf->Row($header1);
			$pdf->Row($header2);
		} else {
			$pdf->Row($header1);
		}

		foreach($list as $item) {
			$row = array();
			foreach($item as $key=>$cell) {
				$align = strtoupper($colArray[$key]['align']);
				array_push($row,array('width'=>($colArray[$key]['width'] / 770 * 100) . "%",'data'=>$cell,'border'=>"LR",'align'=>$align));
			}
			$pdf->Row($row);
		}
		$pdf->Row(array(array('width'=>$totalWidth."%",'border'=>"T")));

		$pdf->Ln(2);
		$pdfFontSize = 6;
		$pdf->SetFont('Arial', '', $pdfFontSize);
		$pdf->ReportHeader($reportTitle, $headerArray);
		
		if($renderType == "view") {
			pdf_view($pdf);
		}
		if($renderType == "send") {
			pdf_send($pdf,$reportTitle);
		}
		
	}
	// if ( $renderMode == "csv" ) {
		// $csv = array();
		// array_push($csv,array($reportTitle));
		// array_push($csv,array());
		// array_push($csv,array());

		// $header1 = array();
		// $header2 = array();
		// foreach($colOrder as $key=>$item) {
			// if($colArray[$key]['active'] == "1") {
				// if($colHeader) {
					// array_push($header1,$colArray[$key]['header']);
					// array_push($header2,$colArray[$key]['label']);
				// } else {
					// array_push($header1,$colArray[$key]['label']);
				// }
			// }
		// }
		// if($colHeader) {
			// array_push($csv,$header1,$header2);
		// } else {
			// array_push($csv,$header1);
		// }

		// foreach($list as $listKey=>$item) {
		
			// $csv[] = $item;
			

					// if ($_SERVER['argv'][8] == "1"){
						// $csv[] = array("");
						// foreach($item['components'] as $compItem){
							// $componentArray = array(
								// "",
								// $compItem['rt_component_desc'],
								// getCompOptional($compItem['rt_comp_opt_yn']),
								// getCompComm($compItem['rt_comp_comm_yn']),
								// getCompFreq($compItem['rt_comp_freq_ind']),
								// getCompSeparate($compItem['rt_comp_separate_yn']),
								// getCompTax($compItem['rt_tax_ind'],$compItem['rt_tax_id'])
							// );
							// $csv[] = $componentArray;				
						// }
					// }
					
			// $csv[] = array("");
		// }

		// csv_output("rate_sheet_".$fromDate['jsDate']."_to_".$toDate['jsDate'],$csv);
	// }
	
	if ( $renderMode == "csv" || $renderMode == "oofice" && ($renderType == "view" || $renderType == "send") ) {
		$fromDate = date("d-m-Y");
		$repName = "Rate_sheet_$fromDate";
		if ( $renderMode == "oofice" ) {
			$repName = $repName.".xml";
			$repType = "xml";
		} else {
			$repName = $repName.".xlsx";
			$repType = "xls";
		}
		outputCSV($list, $renderType="view", $repName, "xls");
	}

	if ( $renderMode == "csvgrid" || $renderMode == "ooficegrid" || $renderMode == "csvgridraw" && ($renderType == "view" || $renderType == "send") ) {
		$fromDate = date("d-m-Y");
		$repName = "Rate_sheet_grid_$fromDate";
		$csvgridraw = false;
		$grid = true;
		if ( $renderMode == "ooficegrid" ) {
			$repName = $repName.".xml";
			$repType = "xml";
		} else if ( $renderMode == "csvgridraw" ) {
			$repName = $repName.".csv";
			$repType = "csv";
			$csvgridraw = true;
		} else {
			$repName = $repName.".xlsx";
			$repType = "xls";
		}
		outputCSV($list, $renderType="view", $repName, "xls", $grid, $csvgridraw);
	}
	
}

$newRelic->stop_transaction();

