<?php

/**
 * init.form2003.php - Debtors Report
 */
 
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once "class.xls.php";

$profileFields = array(
	/*  1 */ "invFromDate",
	/*  2 */ "invToDate", // toDate
	/*  3 */ "folioContactFilter",
	/*  4 */ "agentFilterType",
	/*  5 */ "agentFilter",
	/*  6 */ "agentCountryFilter",
	/*  7 */ "originatorFilter",
	/*  8 */ "sourceFilter",
	/*  9 */ "createdByFilter",
	/* 10 */ "nationalityFilter",
	/* 11 */ "rateFilter",
	/* 12 */ "statusFilter",
	/* 13 */ "paymentPlanFilter",
	/* 14 */ "invoiceStatus",
	/* 15 */ "",
	/* 16 */ "",
	/* 17 */ "folioCurrencyFilter",
	/* 18 */ "",
	/* 19 */ "",
	/* 20 */ "groups",
	/* 21 */ "folioDetailCols",
	/* 22 */ "folioAmountCols",
	/* 23 */ "",
	/* 24 */ "trvlFromDate",
	/* 25 */ "trvlToDate",	
	/* 26 */ "pr_business_id",
	/* 27 */ "checkOutstanding",
	/* 28 */ "checkOutstandingLimit",
	/* 29 */ "outstandingLimit",
	/* 30 */ "checkOverpaid",
	/* 31 */ "checkOverpaidLimit",
	/* 32 */ "overpaidLimit",
	/* 33 */ "checkPaid",
	/* 34 */ "",
	/* 35 */ "outstandingLimitType",
	/* 36 */ "overpaidLimitType",
	/* 37 */ "checkBalance",	
	/* 38 */ "checkUnInvChargeable",
	/* 39 */ "checkUnInvPaid",
	/* 40 */ "renderOption",
	/* 41 */ "serverFilter",
	/* 42 */ "DisplayCurrency",
	/* 43 */ "checkNonzero",
	/* 44 */ "payToDate",
);

function outputMail($form,$options) {
	global $lDB;
	global $temp;
	$fromDate = date("d-m-Y");
	$csvName = "debtor_analysis_$fromDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $csvName . ".xlsx</td>
		</tr>
		</table>
	";

	$newOptions = ($options & ~7) + REP_SEND_CSV;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,40))."+$newOptions+".join("+",array_slice($_SERVER['argv'],41,5));

	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$csvName.".xlsx",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!","Debtors Analysis Report: ".chng_date(date("Y-m-d"),"-"),
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

function getPersonaDetail($personaId) {
	global $lDB;
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}
