<?php

/**
 * init.form2003.php - Debtors Analysis Report
 */

if(isset($_POST['url']) && $_POST['url'] != "") {
   $_SERVER['argv'] = explode("+",substr($_POST['url'],strlen("reservation.php?")));
   $_SERVER['argc'] = sizeof($_SERVER['argv']);
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],45,"");

$jobId = $_SERVER['argv'][0];
$GLOBALS['temp']['jobId'] = $jobId;

$pf_object_id = db_pf_object_by_name("debtors_analysis_report");
processProfileAction($pf_object_id,$profileFields);

$pf_option_id = applyProfile($pf_object_id,$profileFields);
$title = db_pf_option_get_title($pf_option_id);
if(trim($title) == "") {
	$title = "Debtors Analysis Report";
}
$GLOBALS['temp']['title'] = $title;

$GLOBALS['temp']['profile_area'] = createProfileArea($pf_object_id,$pf_option_id);
$GLOBALS['temp']['profile_save'] = createProfileSave($pf_option_id);
$GLOBALS['temp']['profile_save_as'] = createProfileSaveAs();
$GLOBALS['temp']['profile_ids'] = createProfileIds($pf_option_id);
$GLOBALS['temp']['profile_name'] = createProfileName($pf_option_id);
$GLOBALS['temp']['profile_filter_class'] = createProfileFilterClass();

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/rep_debtors.htm");
}

$folioContactFilter = useFilter("folioContact",$_SERVER['argv'][3],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","fn_folio.fn_folio_to_id",false,"Cash","0");
$agentFilter = useFilter("agent",$_SERVER['argv'][5],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_agent_id",false,"Direct booking","0");
$agentCountryFilter = useFilter("agentCountry",$_SERVER['argv'][6],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","pr_ag.pr_corr_country_id",false,false,false);

$agentFilterType = $_SERVER['argv'][4];
$GLOBALS['temp']['agentNameRadioChecked'] = "checked";
$GLOBALS['temp']['agentCountryRadioChecked'] = "";
if($agentFilterType == "2") {
   $GLOBALS['temp']['agentNameRadioChecked'] = "";
   $GLOBALS['temp']['agentCountryRadioChecked'] = "checked";
   $agentWhere = $agentCountryFilter['where'];
} else {
   $agentWhere = $agentFilter['where'];
}

$originatorFilter = useFilter("originator",$_SERVER['argv'][7],"SELECT pr_persona.pr_name_first,pr_persona.pr_name_last FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.rv_origin_agent_id",false,"No originator","0");
$sourceFilter = useFilter("source",$_SERVER['argv'][8],"SELECT rf_source.rf_source_desc FROM rf_source WHERE rf_source_ix =","rv_reservation.rf_source_ix",false,"No source","0");
$createdByFilter = useFilter("createdBy",$_SERVER['argv'][9],"SELECT IFNULL(concat(concat(pr_persona.pr_name_first, ' '), pr_persona.pr_name_last),pr_persona.pr_name_last) FROM pr_persona WHERE pr_persona.pr_persona_ix =","rv_reservation.pr_reservation_user_id",false,"No created by","0");
$nationalityFilter = useFilter("nationality",$_SERVER['argv'][10],"SELECT rf_country_name FROM rf_country WHERE rf_country_ix =","rv_reservation.rf_country_id",false,"No nationality","0");
$rateFilter = useFilter("rate",$_SERVER['argv'][11],"SELECT rt_rate_type_desc FROM rt_rate_type WHERE rt_rate_type_ix=","rv_reservation.rt_rate_type_id",false,false,false);
$statusFilter = useFilter("status",$_SERVER['argv'][12],"SELECT rf_reservation_status.rf_reservation_status_desc FROM rf_reservation_status WHERE rf_reservation_status_id =","rv_reservation.rf_reservation_status_id",false,false,false);			
$paymentPlanFilter = useFilter("paymentPlan",$_SERVER['argv'][13],"SELECT IF(ac_pay_plan.ac_pay_plan_inactive_yn<>0,CONCAT('* ',ac_pay_plan_desc),ac_pay_plan_desc) as nameLast FROM ac_pay_plan WHERE ac_pay_plan.ac_pay_plan_ix =","rv_reservation.ac_pay_plan_id",false,false,false);
$serverFilter = useFilter("server",$_SERVER['argv'][41],"SELECT rf_db_description FROM rf_database WHERE  rf_db_code=","fn_folio.fn_folio_db",false,"Reservation Office","Res");
$resList = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
$serverFilter['where'] = str_replace("'Res'","'".join("','",$resList)."'",$serverFilter['where']);

$invStatusText = array();

$invoiceStatus = $_SERVER['argv'][14];
if($invoiceStatus < 1 || $invoiceStatus > 3) {
	$invoiceStatus = 3;
}
$GLOBALS['temp']['showInvoicedChecked'] = "";
$GLOBALS['temp']['showUninvoicedChecked'] = "";
if( ($invoiceStatus & 1) == 1) {
	$GLOBALS['temp']['showInvoicedChecked'] = "checked";
	$invStatusText[] = "Invoiced";
}
if( ($invoiceStatus & 2) == 2) {
	$GLOBALS['temp']['showUninvoicedChecked'] = "checked";
	$invStatusText[] = "Uninvoiced";
}

$checkUnInvChargeable = true;
$checkUnInvPaid = true;
$GLOBALS['temp']['checkUnInvChargeable'] = "checked";
$GLOBALS['temp']['checkUnInvPaid'] = "checked";


if($_SERVER['argv'][38] == "0") {
	$checkUnInvChargeable = false;
	$GLOBALS['temp']['checkUnInvChargeable'] = "";
} else {
	$invStatusText[] = "Chargeable";
}
if($_SERVER['argv'][39] == "0") {
	$checkUnInvPaid = false;
	$GLOBALS['temp']['checkUnInvPaid'] = "";
} else {
	$invStatusText[] = "Paid";
}

// *** [START] Billing Options (Invoice From)

$billingList = $lDB->get("
	SELECT DISTINCT
			pr_business.pr_business_id as id,
            pr_persona.pr_name_last as namelast,
			pr_business.pr_bus_billing_yn
	FROM
		fn_folio
		INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id
",2);

function getHighestBilling($id) {
	global $lDB;
	$list = $lDB->get("
		SELECT
			pr_business_id
		FROM
			pr_business
		WHERE
			pr_business_parent = '$id'
		ORDER BY
			pr_business_sequence
	",3);
	foreach($list as $item) {
		$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$item'",4);
		if($isInvoice == "1") {
			return $item;
		} else {
			return getHighestBilling($item);
		}
	}
	return "";
}

if(trim($_SERVER['argv'][26]) == "") {
	$_SERVER['argv'][26] = $lDB->get("
		SELECT
			pr_business_id
		FROM
			rf_db_business
		WHERE
			rf_db_code = '$GLOBALS[dbcode]'
	",4);
	if($_SERVER['argv'][26] == "0" || trim($_SERVER['argv'][26]) == "") {
		$topLevel = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '0'",3);
		$finalId = "";
		foreach($topLevel as $topId) {
			$currId = $topId;
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") {
				$finalId = $currId; 
				break;
			} else {
				$finalId =	getHighestBilling($currId);
			}			
		}
		$_SERVER['argv'][26] = "";
		if($finalId != "") {
			$_SERVER['argv'][26] = $finalId;
		}
	} else {
		$currId = $_SERVER['argv'][26];
		$finalId = "";
		while($currId != "0" && trim($currId) != "" && $finalId == "") {
			$isInvoice = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
			if($isInvoice == "1") { $finalId = $currId; }
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($finalId != "") {
			$_SERVER['argv'][26] = $finalId;
		}
	}
}
$billingOptions = "";
foreach($billingList as $billingItem) {
	$selected = "";
	if($_SERVER['argv'][26] == $billingItem['id']) {
		$selected = "selected";
		$billingEntitiesFilter['names'] = $billingItem['namelast'];
	}
	$prefix = "";
	if($billingItem['pr_bus_billing_yn'] != "1") {
		$prefix = "* ";
	}
	$billingOptions .= "<option $selected value=\"$billingItem[id]\">$prefix$billingItem[namelast]</option>";
}

if(trim($_SERVER['argv'][26]) != "") {
	$billingEntitiesFilter['where'] = " AND fn_folio.pr_business_id = '".$_SERVER['argv'][26]."' ";
}
$businessInfo = $lDB->get("
	SELECT
		pr_business.pr_bus_home_curr_id,
		rf_currency.rf_currency_symbol,
		pr_persona.pr_name_last		
	FROM
		pr_business
		INNER JOIN rf_currency  ON rf_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_business.pr_business_id		
	WHERE
		pr_business_id = '".$_SERVER['argv'][26]."'
",1);
$GLOBALS['temp']['businessCurrencyId'] = $businessInfo['pr_bus_home_curr_id'];
$GLOBALS['temp']['businessCurrencySymbol'] = $businessInfo['rf_currency_symbol'];

$businessName = $businessInfo['pr_name_last'];

$GLOBALS['temp']['billingOptions'] = $billingOptions;


$displayCurrency = $_SERVER['argv'][42];
if ($displayCurrency == "1"){
	$GLOBALS['temp']['GLCurrencyChecked'] = "selected";
	$GLOBALS['temp']['folioCurrencyChecked'] = "";
	$currSelectSQL = "
			(fn_folio.fn_folio_amt_paid * fn_invoice.fn_inv_exch_rate_balance) AS fn_folio_amt_paid,
			(fn_folio.fn_folio_amount * fn_invoice.fn_inv_exch_rate_balance) AS fn_folio_amount,
			'".$GLOBALS['temp']['businessCurrencyId']."' AS rf_currency_id,
			(fn_folio.fn_folio_amt_comm * fn_invoice.fn_inv_exch_rate_balance) AS fn_folio_amt_comm,
			(fn_folio.fn_folio_amt_tax * fn_invoice.fn_inv_exch_rate_balance) AS fn_folio_amt_tax,
			((fn_folio.fn_folio_amount * fn_invoice.fn_inv_exch_rate_balance) - (fn_folio.fn_folio_amt_paid * fn_invoice.fn_inv_exch_rate_balance)) AS foloutstanding,			
	";

	
} else {
	$GLOBALS['temp']['folioCurrencyChecked'] = "selected";
	$GLOBALS['temp']['GLCurrencyChecked'] = "";
	$currSelectSQL = "
			fn_folio.fn_folio_amt_paid,
			fn_folio.fn_folio_amount,	
			fn_folio.rf_currency_id,
			fn_folio.fn_folio_amt_comm,
			fn_folio.fn_folio_amt_tax,			
			(fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) AS foloutstanding,	
	";	
}



// *** [END] Billing Options (Invoice From)


//$resInvCurrencyFilter = useFilter("resInvCurrency",$_SERVER['argv'][16],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rv_reservation.rv_invoice_currency_id",false,false,false);
$folioCurrencyFilter = useFilter("folioCurrency",$_SERVER['argv'][17],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","fn_folio.rf_currency_id",false,false,false);
//$rateCurrencyFilter = useFilter("rateCurrency",$_SERVER['argv'][18],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","rt_rate_type.rf_currency_id",false,false,false);
//$GLCurrencyFilter = useFilter("GLCurrency",$_SERVER['argv'][19],"SELECT rf_currency.rf_currency_name FROM rf_currency WHERE rf_currency.rf_currency_ix =","fn_folio.rf_currency_id",false,false,false);


$invFromD = $_SERVER['argv'][1];
$invToD = $_SERVER['argv'][2];

$payToD = $_SERVER['argv'][44];

$trvlFromD = $_SERVER['argv'][24];
$trvlToD = $_SERVER['argv'][25];

$checkOverpaid = false;
$checkOverpaidLimit = false;
$checkPaid = false;
$checkNonzero = false;
$checkBalance = false;
$checkOutstanding = false;
$checkOutstandingLimit = false;
$payDateLimit = false;

$GLOBALS['temp']['checkBalance'] = "";
$GLOBALS['temp']['checkOutstanding'] = "";
$GLOBALS['temp']['overpaidChecked'] = "";
$GLOBALS['temp']['paidChecked'] = "";
$GLOBALS['temp']['checkOutstandingLimit'] = "";
$GLOBALS['temp']['checkOverpaidLimit'] = "";
$balanceText = "";
if($_SERVER['argv'][27] == 1) {
	$checkOutstanding = true;
	$balanceText = "Amount Owing";
	$GLOBALS['temp']['checkOutstanding'] = "checked";
}
if($_SERVER['argv'][28] == 1) {
	$checkOutstandingLimit = true;
	$GLOBALS['temp']['checkOutstandingLimit'] = "checked";
}

if($_SERVER['argv'][30] == 1) {
	$checkOverpaid = true;
	$balanceText = "Overpaid";	
	$GLOBALS['temp']['checkOverpaid'] = "checked";
}
if($_SERVER['argv'][31] == 1) {
	$checkOverpaidLimit = true;
	$balanceText = "Overpaid";
	$GLOBALS['temp']['checkOverpaidLimit'] = "checked";
}

if($_SERVER['argv'][33] == 1) {
	$checkPaid = true;
	$balanceText = "Fully Paid";
	$GLOBALS['temp']['paidChecked'] = "checked";
}

if($_SERVER['argv'][43] == 1) {
	$checkNonzero = true;
	$balanceText = "Non-zero";
	$GLOBALS['temp']['nonzeroChecked'] = "checked";
}

$outstandingLimitType = $_SERVER['argv'][35];
$GLOBALS['temp']['outstandingLimitTypeAbove'] = "";
$GLOBALS['temp']['outstandingLimitTypeBelow'] = "";
if($outstandingLimitType == "above") {
	$GLOBALS['temp']['outstandingLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['outstandingLimitTypeBelow'] = "selected";
}


$outstandingLimit = $_SERVER['argv'][29];
$GLOBALS['temp']['outstandingLimit'] = $outstandingLimit;


$outstandingLimit = $_SERVER['argv'][29];
$GLOBALS['temp']['outstandingLimit'] = $outstandingLimit;

$overpaidLimitType = $_SERVER['argv'][36];
$GLOBALS['temp']['overpaidLimitTypeAbove'] = "";
$GLOBALS['temp']['overpaidLimitTypeBelow'] = "";
if($overpaidLimitType == "above") {
	$GLOBALS['temp']['overpaidLimitTypeAbove'] = "selected";
} else {
	$GLOBALS['temp']['overpaidLimitTypeBelow'] = "selected";
}

$overpaidLimit = $_SERVER['argv'][32];
$GLOBALS['temp']['overpaidLimit'] = $overpaidLimit;

if($_SERVER['argv'][37] == 1) {
	$checkBalance = true;
	$GLOBALS['temp']['checkBalance'] = "checked";
} else {
	$checkBalance = false;
}

$folioDetailCols = array();
$folioDetailCols = array(
	array('id'=>'1' , 'label'=>'Res no.', 'type'=>"string", 'fields'=>array("rv_reservation_ix"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'2' , 'label'=>'Res name', 'type'=>"string", 'fields'=>array("rv_res_name"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'3' , 'label'=>'Invoice date', 'type'=>"string", 'fields'=>array("fn_inv_date"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'4' , 'label'=>'Invoice no.', 'type'=>"string", 'fields'=>array("fn_invoice_ix"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'5' , 'label'=>'Voucher', 'type'=>"string", 'fields'=>array("rv_agent_ref"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'6' , 'label'=>'Arrive date', 'type'=>"string", 'fields'=>array("rv_date_arrive"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l"),
	array('id'=>'7' , 'label'=>'Depart date', 'type'=>"string", 'fields'=>array("rv_date_depart"), 'style'=>array('bold'=>"1"), 'width'=>"70", 'align'=>"l")
);

$folioDetailColArg = $_SERVER['argv'][21];
$colArray = array();
$folioDetailColOrder = array();
$folioDetailColSort = array();
$colHeader = false;
if(trim($folioDetailColArg) != "") {
	$count = 0;
	foreach(explode(":",$folioDetailColArg) as $item) {
		$col = explode(",",$item);
		$colActive[$count] = isset($col[0]) ? $col[0] : "";
		$folioDetailColOrder[$count] = isset($col[1]) ? $col[1] : "";
		$folioDetailColSort[$count] = isset($col[2]) ? $col[2] : "";
		$width = isset($col[3]) ? $col[3] : 0;
		if(!is_numeric($width)) {
			$width = isset($folioDetailCols[$count]['width']) ? $folioDetailCols[$count]['width'] : 0;
		}
		$label = isset($col[4]) ? trim(urldecode($col[4])) : "";
		if($label == "") {
			$label = isset($folioDetailCols[$count]['label']) ? $folioDetailCols[$count]['label'] : "";
		}
		$header = isset($col[5]) ? trim($col[5]) : "";
		if($header != "") {
			$colHeader = true;
		}
		$align = isset($col[6]) ? trim($col[6]) : "";
		if($align == "") {
			$align = isset($folioDetailCols[$count]['align']) ? $folioDetailCols[$count]['align'] : "";
		}
		$objType = isset($col[7]) ? trim($col[7]) : "";
		if($objType == "") {
			$objType = isset($folioDetailCols[$count]['objType']) ? $folioDetailCols[$count]['objType'] : "";
		}
		$guestId = isset($col[8]) ? trim($col[8]) : "";
		if($guestId == "") {
			$guestId = isset($folioDetailCols[$count]['rf_obj_guest_ix']) ? $folioDetailCols[$count]['rf_obj_guest_ix'] : "";
		}
		$split = isset($col[9]) ? trim($col[9]) : "";
		$disable = isset($col[10]) ? trim($col[10]) : "";
		if($disable == "") {
			$disable = isset($folioDetailCols[$count]['disable']) ? $folioDetailCols[$count]['disable'] : "";
		}
		
		$colArray[$count] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			//"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"disable"=>$disable,
			"rf_obj_guest_ix"=>$guestId
		);
		$folioDetailCols[$count]['active'] = $col[0];
		$folioDetailCols[$count]['order'] = $col[1];
		$folioDetailCols[$count]['sort'] = $col[2];
		$folioDetailCols[$count]['width'] = $width;
		$folioDetailCols[$count]['label'] = $label;
		$folioDetailCols[$count]['header'] = $header;
		$folioDetailCols[$count]['split'] = $split;
		$folioDetailCols[$count]['align'] = $align;
		$folioDetailCols[$count]['objType'] = $objType;
		$folioDetailCols[$count]['rf_obj_guest_ix'] = $guestId;
		$folioDetailCols[$count]['disable'] = $disable;
		$count++;
	}
}
asort($folioDetailColOrder);
asort($folioDetailColSort);
$colData = array();

foreach($folioDetailCols as $colKey=>$colItem) {
	$width = isset($colItem['width']) ? $colItem['width'] : 0;
	$sort = "";
	$col_direction = "";
	$label = isset($colItem['label']) ? $colItem['label'] : "";
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$objType = isset($colItem['objType']) ? $colItem['objType'] : "";
	$disable = isset($colItem['disable']) ? $colItem['disable'] : "";
	$guestId = isset($colItem['rf_obj_guest_ix']) ? $colItem['rf_obj_guest_ix'] : "";

	if(isset($colArray[$colKey]['active']) && $colArray[$colKey]['active'] == "1") {
		$width = isset($colArray[$colKey]['width']) ? $colArray[$colKey]['width'] : 0;
		$sort = isset($colArray[$colKey]['sort']) ? $colArray[$colKey]['sort'] : "";
		//$col_direction = $colArray[$colKey]['direction'];		
		$label = isset($colArray[$colKey]['label']) ? $colArray[$colKey]['label'] : "";
		$active = "1";
		$order = isset($colArray[$colKey]['order']) ? $colArray[$colKey]['order'] : "";
		$split = isset($colArray[$colKey]['split']) ? $colArray[$colKey]['split'] : "";
		$header = isset($colArray[$colKey]['header']) ? $colArray[$colKey]['header'] : "";
		$align = isset($colArray[$colKey]['align']) ? $colArray[$colKey]['align'] : "";
		$objType = isset($colArray[$colKey]['objType']) ? $colArray[$colKey]['objType'] : "";
		$disable = isset($colArray[$colKey]['disable']) ? $colArray[$colKey]['disable'] : "";
		$guestId = isset($colArray[$colKey]['rf_obj_guest_ix']) ? $colArray[$colKey]['rf_obj_guest_ix'] : "";
	}
	
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			'"sort":"'.$sort.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"split":"'.$split.'"',
			'"align":"'.$align.'"',
			'"objType":"'.$objType.'"',
			'"disable":"'.$disable.'"',
			'"rf_obj_guest_ix":"'.$guestId.'"'
		);
	
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}

$folioDetailColData = '['.join(",",$colData).']';
$GLOBALS['temp']['folioDetailColData'] = $folioDetailColData;

$sort_array = array();
$orderArr = array();
 foreach ($folioDetailCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $folioDetailCols);

$folioAmountsCols = array();
$folioAmountsCols = array(
	array('id'=>'1' , 'label'=>'Amt payable', 'type'=>"string", 'fields'=>array("fn_folio_amount"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'2' , 'label'=>'Amt paid', 'type'=>"string", 'fields'=>array("fn_folio_amt_paid"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'3' , 'label'=>'Balance', 'type'=>"string", 'fields'=>array("foloutstanding"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'4' , 'label'=>'Amt commission', 'type'=>"string", 'fields'=>array("fn_folio_amt_comm"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r"),
	array('id'=>'5' , 'label'=>'Amt tax', 'type'=>"string", 'fields'=>array("fn_folio_amt_tax"), 'style'=>array('bold'=>"1"), 'width'=>"80", 'align'=>"r")
);

$folioAmountsColArg = $_SERVER['argv'][22];
$colArray = array();
$folioAmountsColOrder = array();
$folioAmountsColSort = array();
$colHeader = false;
if(trim($folioAmountsColArg) != "") {
	$count = 0;
	foreach(explode(":",$folioAmountsColArg) as $item) {
		$col = explode(",",$item);
		$colActive[$count] = isset($col[0]) ? $col[0] : "";
		$folioAmountsColOrder[$count] = isset($col[1]) ? $col[1] : "";
		$folioAmountsColSort[$count] = isset($col[2]) ? $col[2] : "";
		$width = isset($col[3]) ? $col[3] : 0;
		if(!is_numeric($width)) {
			$width = isset($folioAmountsCols[$count]['width']) ? $folioAmountsCols[$count]['width'] : 0;
		}
		$label = isset($col[4]) ? trim(urldecode($col[4])) : "";
		if($label == "") {
			$label = isset($folioAmountsCols[$count]['label']) ? $folioAmountsCols[$count]['label'] : "";
		}
		$header = isset($col[5]) ? trim($col[5]) : "";
		if($header != "") {
			$colHeader = true;
		}
		$align = isset($col[6]) ? trim($col[6]) : "";
		if($align == "") {
			$align = isset($folioAmountsCols[$count]['align']) ? $folioAmountsCols[$count]['align'] : "";
		}
		$objType = isset($col[7]) ? trim($col[7]) : "";
		if($objType == "") {
			$objType = isset($folioAmountsCols[$count]['objType']) ? $folioAmountsCols[$count]['objType'] : "";
		}
		$guestId = isset($col[8]) ? trim($col[8]) : "";
		if($guestId == "") {
			$guestId = isset($folioAmountsCols[$count]['rf_obj_guest_ix']) ? $folioAmountsCols[$count]['rf_obj_guest_ix'] : "";
		}
		$split = isset($col[9]) ? trim($col[9]) : "";
		$disable = isset($col[10]) ? trim($col[10]) : "";
		if($disable == "") {
			$disable = isset($folioAmountsCols[$count]['disable']) ? $folioAmountsCols[$count]['disable'] : "";
		}
		
		$colArray[$count] = array(
			"active"=>$col[0],
			"order"=>$col[1],
			"sort"=>$col[2],
			//"direction"=>$col[3],
			"width"=>$width,
			"label"=>$label,
			"header"=>$header,
			"split"=>$split,
			"align"=>$align,
			"objType"=>$objType,
			"disable"=>$disable,
			"rf_obj_guest_ix"=>$guestId
		);
		$folioAmountsCols[$count]['active'] = $col[0];
		$folioAmountsCols[$count]['order'] = $col[1];
		$folioAmountsCols[$count]['sort'] = $col[2];
		$folioAmountsCols[$count]['width'] = $width;
		$folioAmountsCols[$count]['label'] = $label;
		$folioAmountsCols[$count]['header'] = $header;
		$folioAmountsCols[$count]['split'] = $split;
		$folioAmountsCols[$count]['align'] = $align;
		$folioAmountsCols[$count]['objType'] = $objType;
		$folioAmountsCols[$count]['rf_obj_guest_ix'] = $guestId;
		$folioAmountsCols[$count]['disable'] = $disable;
		$count++;
	}
}
asort($folioAmountsColOrder);
asort($folioAmountsColSort);
$colData = array();

foreach($folioAmountsCols as $colKey=>$colItem) {
	$width = isset($colItem['width']) ? $colItem['width'] : "";
	$sort = "";
	$col_direction = "";
	$label = isset($colItem['label']) ? $colItem['label'] : "";
	$active = "";
	$order = "";
	$header = "";
	$split = "";
	$align = isset($colItem['align']) ? $colItem['align'] : "";
	$objType = isset($colItem['objType']) ? $colItem['objType'] : "";
	$disable = isset($colItem['disable']) ? $colItem['disable'] : "";
	$guestId = isset($colItem['rf_obj_guest_ix']) ? $colItem['rf_obj_guest_ix'] : "";

	if(isset($colArray[$colKey]['active']) && $colArray[$colKey]['active'] == "1") {
		$width = $colArray[$colKey]['width'];
		$sort = $colArray[$colKey]['sort'];
		//$col_direction = $colArray[$colKey]['direction'];		
		$label = $colArray[$colKey]['label'];
		$active = "1";
		$order = $colArray[$colKey]['order'];
		$split = $colArray[$colKey]['split'];
		$header = $colArray[$colKey]['header'];
		$align = $colArray[$colKey]['align'];
		$objType = $colArray[$colKey]['objType'];
		$disable = $colArray[$colKey]['disable'];
		$guestId = $colArray[$colKey]['rf_obj_guest_ix'];
	}
	
		$colDataItem = array(
			'"id":"'.$colItem['id'].'"',
			'"name":"'.$colItem['label'].'"',
			'"width":"'.$width.'"',
			'"sort":"'.$sort.'"',
			'"label":"'.$label.'"',
			'"active":"'.$active.'"',
			'"order":"'.$order.'"',
			'"header":"'.$header.'"',
			'"split":"'.$split.'"',
			'"align":"'.$align.'"',
			'"objType":"'.$objType.'"',
			'"disable":"'.$disable.'"',
			'"rf_obj_guest_ix":"'.$guestId.'"'
		);
	
	array_push($colData,'{'.join(",",$colDataItem)."}\n");
}

$folioAmountsColData = '['.join(",",$colData).']';
$GLOBALS['temp']['folioAmountsColData'] = $folioAmountsColData;

$sort_array = array();
$orderArr = array();
 foreach ($folioAmountsCols as $key => $row) {
   $sort_array[$key]  = $row['id'];
   if(empty($row['order']))
		$orderArr[$key]  = 9999;
   else
	   $orderArr[$key]  = $row['order'];
}
array_multisort($orderArr, SORT_ASC, $sort_array, SORT_ASC, $folioAmountsCols);

switch($invFromD) {
case "all":
	$GLOBALS['temp']['invDateRangeOptAll'] = "checked=\"checked\"";
	$invFromDate = "All";
	$tmpDate = date("Y-m-d");
	$tmpArray = explode("-",$tmpDate);	

	$GLOBALS['temp']['invFromY']	= $tmpArray[0];
	$GLOBALS['temp']['invFromM']	= $tmpArray[1];
	$GLOBALS['temp']['invFromD']	= $tmpArray[2];
	$GLOBALS['temp']['invToY']		= $tmpArray[0];
	$GLOBALS['temp']['invToM']		= $tmpArray[1];
	$GLOBALS['temp']['invToD']		= $tmpArray[2];
	break;
case "today":
	$GLOBALS['temp']['invDateRangeOptToday'] = "checked=\"checked\"";
	$invFromDate = useDate("invFrom","");
	$invToDate = useDate("invTo","");
	break;
default:
	$GLOBALS['temp']['invDateRangeOptCustomDate'] = "checked=\"checked\"";
	$invFromDate = useDate("invFrom", $invFromD);
	$invToDate = useDate("invTo", $invToD);
	break;
}

switch($payToD) {
	case "" :
		$payToD = "today";
	case "today":
		$GLOBALS['temp']['payDateRangeOptToday'] = "checked=\"checked\"";
		$payToDate = useDate("payTo","");
		break;
	default:
		$GLOBALS['temp']['payDateRangeOptCustomDate'] = "checked=\"checked\"";
		$payDateLimit = true;
		$payToDate = useDate("payTo", $payToD);
		break;
}

switch($trvlFromD) {
case "all":
	$GLOBALS['temp']['trvlDateRangeOptAll'] = "checked=\"checked\"";
	$trvlFromDate = "All";
	$tmpDate = date("Y-m-d");
	$tmpArray = explode("-",$tmpDate);	

	$GLOBALS['temp']['trvlFromY']	= $tmpArray[0];
	$GLOBALS['temp']['trvlFromM']	= $tmpArray[1];
	$GLOBALS['temp']['trvlFromD']	= $tmpArray[2];
	$GLOBALS['temp']['trvlToY']		= $tmpArray[0];
	$GLOBALS['temp']['trvlToM']		= $tmpArray[1];
	$GLOBALS['temp']['trvlToD']		= $tmpArray[2];
	break;
default:
	$GLOBALS['temp']['trvlDateRangeOptCustomDate'] = "checked=\"checked\"";
	$trvlFromDate = useDate("trvlFrom", $trvlFromD);
	$trvlToDate = useDate("trvlTo", $trvlToD);
	break;
}

$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");

$groupBy = explode(":",$_SERVER['argv'][20]);

$groupByArray = array(
	"all"=>array(
		'name'=>"All",
		'select'=>"
			'' AS id@,
			'All' AS name@
		",
		'order'=>"
			name@
		",
	),
	"agent"=>array(
		'name'=>"Agent",
		'select'=>"
			rv_reservation.rv_agent_id AS id@,
			groupTable@.pr_name_last AS name@
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.rv_agent_id
		",
		'order'=>"
			name@
		",
		'blank'=>"Direct"
	),
	"consultant"=>array(
		'name'=>"Consultant",
		'select'=>"
			rv_reservation.rv_consultant_id as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'join'=>"
			INNER JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.rv_consultant_id
		",
		'order'=>"
			name@_1, name@_2
		",
		'blank'=>"No consultant"
	),
	"contact"=>array(
		'name'=>"Contact",
		'select'=>"
			rv_reservation.rv_corr_persona_id as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.rv_corr_persona_id
		",
		'order'=>"
			name@_1, name@_2
		",
		'blank'=>"No contact"
	),
	"originator"=>array(
		'name'=>"Originator",
		'select'=>"
			groupTable@.pr_persona_ix as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'order'=>"
			name@_1, name@_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.rv_origin_agent_id
		",
		'blank'=>"No originator"
	),
	"rateType"=>array(
		'name'=>"Rate type",
		'select'=>"
			groupTable@.rt_rate_type_ix as id@,
			groupTable@.rt_rate_type_desc as name@
		",
		'join'=>"
			LEFT JOIN rt_rate_type AS groupTable@ ON groupTable@.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		",
		'order'=>"
			name@
		",
		'blank'=>"No rate type"
	),
	"source"=>array(
		'name'=>"Source",
		'select'=>"
			rv_reservation.rf_source_ix as id@,
			groupTable@.rf_source_desc as name@
		",
		'join'=>"
			LEFT JOIN rf_source AS groupTable@ ON groupTable@.rf_source_ix = rv_reservation.rf_source_ix
		",
		'order'=>"
			name@
		",
		'blank'=>"No source"
	),
	"status"=>array(
		'name'=>"Status",
		'select'=>"
			groupTable@.rf_reservation_status_id as id@,
			groupTable@.rf_reservation_status_desc as name@
		",
		'join'=>"
			LEFT JOIN rf_reservation_status AS groupTable@ ON groupTable@.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		",
		'order'=>"
			name@
		",
		'blank'=>"No status"
	),
	"reservation_number"=>array(
		'name'=>"Reservation number",
		'select'=>"
			rv_reservation.rv_reservation_ix as id@,
			rv_reservation.rv_reservation_ix as name@
		",
		'join'=>"",
		'order'=>"
			name@
		",
		'blank'=>"No reservation number"
	),
	"reservation_name"=>array(
		'name'=>"Reservation name",
		'select'=>"
			rv_reservation.rv_reservation_ix as id@,
			rv_reservation.rv_res_name as name@
		",
		'join'=>"",
		'order'=>"
			name@
		",
		'blank'=>"No reservation name"
	),
	"debtor"=>array(
		'name'=>"Debtor",
		'select'=>"
			fn_folio.fn_folio_to_id as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = fn_folio.fn_folio_to_id
		",
		'order'=>"
			name@_1, name@_2
		",
		'blank'=>"No debtor"
	),
	"created_by"=>array(
		'name'=>"Created By",
		'select'=>"
			rv_reservation.pr_reservation_user_id as id@,
			groupTable@.pr_name_first as name@_1,
			groupTable@.pr_name_last as name@_2
		",
		'join'=>"
			LEFT JOIN pr_persona AS groupTable@ ON groupTable@.pr_persona_ix = rv_reservation.pr_reservation_user_id
		",
		'order'=>"
			name@_1, name@_2
		",
		'blank'=>"None"
	),
	"payment_plan"=>array(
		'name'=>"Payment Plan",
		'select'=>"
			groupTable@.ac_pay_plan_ix as id@,
			groupTable@.ac_pay_plan_desc as name@
		",
		'join'=>"
			LEFT JOIN ac_pay_plan AS groupTable@ ON groupTable@.ac_pay_plan_ix = rv_reservation.ac_pay_plan_id
		",
		'order'=>"
			name@
		",
		'blank'=>"No Payment Plan"
	),
	"arrive_month"=>array(
		'name'=>"Arrive Month",
		'select'=>"
			date_format(rv_reservation.rv_date_arrive, '%M %Y') AS id@,
			date_format(rv_reservation.rv_date_arrive, '%M') AS name@_1,
			date_format(rv_reservation.rv_date_arrive, '%Y') AS name@_2
		",
		'join'=>"
		",
		'order'=>"
			name@_2,date_format(rv_reservation.rv_date_arrive, '%m')
		",
		'blank'=>"No Arrive Month"
	),
	"depart_month"=>array(
		'name'=>"Depart Month",
		'select'=>"
			date_format(rv_reservation.rv_date_depart, '%M %Y') AS id@,
			date_format(rv_reservation.rv_date_depart, '%M') AS name@_1,
			date_format(rv_reservation.rv_date_depart, '%Y') AS name@_2
		",
		'join'=>"
		",
		'order'=>"
			name@_2,date_format(rv_reservation.rv_date_depart, '%m')
		",
		'blank'=>"No Depart Month"
	),
	"invoice_month"=>array(
		'name'=>"Invoice Month",
		'select'=>"
			date_format(fn_invoice.fn_inv_date, '%M %Y') AS id@,
			date_format(fn_invoice.fn_inv_date, '%M') AS name@_1,
			date_format(fn_invoice.fn_inv_date, '%Y') AS name@_2
		",
		'join'=>"
		",
		'order'=>"
			name@_2,date_format(fn_invoice.fn_inv_date, '%m')
		",
		'blank'=>"No Invoice Month"
	)
);
asort($groupByArray);

$groupRows = "";
$groups = 10;
$GLOBALS['temp']['groupCount'] = $groups;
$groupRowHTML = join("",file(__DIR__ . "/../../../public/html/rep_debtors_group_row.htm"));
for($count=0;$count<$groups;$count++) {
	$groupByOptions = "";
	foreach($groupByArray as $groupByKey=>$groupByItem) {
		$selected = "";
		if(isset($groupBy[$count]) && $groupBy[$count] == $groupByKey) {
			$selected = "selected";
		}
		$groupByOptions .= "
			<option value=\"$groupByKey\" $selected>$groupByItem[name]</option>
		";

	}
	$groupRows .= str_replace("!group!",$count,
		str_replace("!level!",$count+1,
		str_replace("!groupByOptions!",$groupByOptions,$groupRowHTML)));
}
$GLOBALS['temp']['groupRows'] = $groupRows;

$renderOption = $_SERVER['argv'][40];

switch ($renderOption & 7) {
case REP_VIEW_HTML:
	$renderMode = "html";
	$renderType = "";
	break;
case REP_VIEW_PDF:
	$renderMode = "pdf";
	$renderType = "view";
	break;
case REP_EMAIL_CSV:
	$renderMode = "csv";
	$renderType = "email";
	break;
case REP_SEND_CSV:
	$renderMode = "csv";
	$renderType = "send";
	break;
case REP_VIEW_CSV:
	$renderMode = "csv";
	$renderType = "view";
	break;
case REP_VIEW_OO:
	$renderMode = "ooffice";
	$renderType = "view";
	break;
}

$balanceWhere = "";

if($_SERVER['argc'] > 1) {
	$GLOBALS['temp']['reportGenerated'] = "";
	if($checkBalance && !$payDateLimit) {
		if($checkOutstanding) {
			if(!$checkOutstandingLimit) {
				$balanceWhere = "
					AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
				";
			} else {
				if($outstandingLimitType == "above") {
					$balanceWhere = "
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $outstandingLimit
					";
				} else {
					$balanceWhere = "
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $outstandingLimit
					";
				}
			}
		}
		if($checkOverpaid) {
			if(!$checkOverpaidLimit) {
				$balanceWhere = "
					AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
				";
			} else {
				$overpaidLimit = -$overpaidLimit;
				if($overpaidLimitType == "above") {
					$balanceWhere = "
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < $overpaidLimit
					";
				} else {
					$balanceWhere = "
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) < 0
						AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) > $overpaidLimit
					";
				}
			}
		}
		if($checkPaid) {
			$balanceWhere = "
				AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) = 0
			";
		}
		
		if($checkNonzero) {
			$balanceWhere = "
				AND (fn_folio.fn_folio_amount - fn_folio.fn_folio_amt_paid) != 0
			";
		}
	}
	
	
	$joins = array();
	$selects = array();
	$orders = array();
	for($count=0;$count<$groups;$count++) {
		if($count > 0 && $groupBy[$count] == "all") {
			$groups = $count;
			break;
		}
		array_push($joins,str_replace("@",$count,(isset($groupByArray[$groupBy[$count]]['join']) ? $groupByArray[$groupBy[$count]]['join'] : "") ));
		array_push($selects,str_replace("@",$count,(isset($groupByArray[$groupBy[$count]]['select']) ? $groupByArray[$groupBy[$count]]['select'] : "") ));
		array_push($orders,str_replace("@",$count,(isset($groupByArray[$groupBy[$count]]['order']) ? $groupByArray[$groupBy[$count]]['order'] : "") ));
	}

	$sqlSelect = "
		SELECT
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_to_id,
			$currSelectSQL
			fn_invoice.fn_inv_date,
			fn_invoice.fn_invoice_ix,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_date_arrive,
			rv_reservation.rv_date_depart,			
			rv_reservation.rv_res_name,
			rv_reservation.rv_agent_ref,
			".join(",",$selects)."
			
	";

	$sqlFrom = "
		FROM 
			fn_folio
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
		INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
		LEFT JOIN pr_persona as pr_ag ON rv_reservation.rv_agent_id = pr_ag.pr_persona_ix
		LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind = 2
		".join("\n",$joins)."
	";

	$folioContactFilter['where'] = isset($folioContactFilter['where']) ? $folioContactFilter['where'] : "";
	$originatorFilter['where'] = isset($originatorFilter['where']) ? $originatorFilter['where'] : "";
	$sourceFilter['where'] = isset($sourceFilter['where']) ? $sourceFilter['where'] : "";
	$createdByFilter['where'] = isset($createdByFilter['where']) ? $createdByFilter['where'] : "";
	$nationalityFilter['where'] = isset($nationalityFilter['where']) ? $nationalityFilter['where'] : "";
	$rateFilter['where'] = isset($rateFilter['where']) ? $rateFilter['where'] : "";
	$statusFilter['where'] = isset($statusFilter['where']) ? $statusFilter['where'] : "";
	$paymentPlanFilter['where'] = isset($paymentPlanFilter['where']) ? $paymentPlanFilter['where'] : "";
	$resInvCurrencyFilter['where'] = isset($resInvCurrencyFilter['where']) ? $resInvCurrencyFilter['where'] : "";
	$folioCurrencyFilter['where'] = isset($folioCurrencyFilter['where']) ? $folioCurrencyFilter['where'] : "";
	$rateCurrencyFilter['where'] = isset($rateCurrencyFilter['where']) ? $rateCurrencyFilter['where'] : "";
	$billingEntitiesFilter['where'] = isset($billingEntitiesFilter['where']) ? $billingEntitiesFilter['where'] : "";
	$serverFilter['where'] = isset($serverFilter['where']) ? $serverFilter['where'] : "";

	$sqlWhere = "
		WHERE 
			fn_folio.fn_folio_amt_tba_yn = 0
			$agentWhere
			$balanceWhere
			".$folioContactFilter['where']."
			".$originatorFilter['where']."
			".$sourceFilter['where']."
			".$createdByFilter['where']."
			".$nationalityFilter['where']."
			".$rateFilter['where']."
			".$statusFilter['where']."
			".$paymentPlanFilter['where']."
			".$resInvCurrencyFilter['where']."
			".$folioCurrencyFilter['where']."
			".$rateCurrencyFilter['where']."
			".$billingEntitiesFilter['where']."
			".$serverFilter['where']."
	";

	if($invoiceStatus < 3) { // not all
		if($invoiceStatus == 1) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NOT NULL
			";
		} elseif($invoiceStatus == 2) {
			$sqlWhere .= "
				AND fn_invoice.fn_invoice_ix IS NULL
			";
		}
	}	
	
	if ($invFromDate != "All"){

		$folioDateWhere = "
			fn_folio.fn_folio_date BETWEEN '$invFromDate[jsDate]' AND '$invToDate[jsDate]'
		";
	
		$sqlWhere .= "
				AND (
					(/* folio */
						fn_invoice.fn_invoice_ix IS NULL
						AND $folioDateWhere
					) OR (/* invoice */
						fn_invoice.fn_invoice_ix IS NOT NULL
						AND fn_invoice.fn_inv_date BETWEEN '$invFromDate[jsDate]' AND '$invToDate[jsDate]'
					) 
				)
		";
	}	

	if ( $trvlFromDate != "All" ) {
		$sqlWhere .= "
			AND (
				(
					rv_reservation.rv_date_arrive >= '$trvlFromDate[jsDate]' 
					AND rv_reservation.rv_date_arrive <= '$trvlToDate[jsDate]'
				) OR (
					rv_reservation.rv_date_depart >= '$trvlFromDate[jsDate]' 
					AND rv_reservation.rv_date_depart <= '$trvlToDate[jsDate]'
				) OR (
					rv_reservation.rv_date_arrive < '$trvlFromDate[jsDate]' 
					AND rv_reservation.rv_date_depart > '$trvlToDate[jsDate]'
				)
			)
		";
	}

	$orderSQL = " ORDER BY ".join(",",$orders);

	$debtors = $lDB->get($sqlSelect.$sqlFrom.$sqlWhere.$orderSQL,2);

	if ($payDateLimit) {
		// Recalculate balances and payments
		foreach($debtors as $key => &$item) {
			if ($item['fn_folio_amt_paid'] > 0) {
				$paidAfterLimit =  $lDB->get("SELECT sum(rv_payment_item_amt) 
					FROM rv_payment_item
					left join rv_payment on rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					where fn_folio_id = '" . $item['fn_folio_ix'] . "'
					AND rv_pmnt_date > '$payToD'
				", 4);
			
				if ($paidAfterLimit) {
					$item['fn_folio_amt_paid'] -= $paidAfterLimit;
					$item['foloutstanding'] += $paidAfterLimit;
				}
			}

			if ($checkBalance) {
				if ($checkOutstanding) {
					if (!$checkOutstandingLimit) {
						if ($item['foloutstanding'] <= 0) { 
							unset($debtors[$key]); 
							continue;
						}
					} else {
						if ($outstandingLimitType == "above") {
							if ($item['foloutstanding'] < $outstandingLimit) { 
								unset($debtors[$key]); 
								continue;
							}
						} else {
							if ($item['foloutstanding'] <= 0 || $item['foloutstanding'] > $outstandingLimit) { 
								unset($debtors[$key]); 
								continue;
							}
						}
					}
				}

				if ($checkOverpaid) {
					if (!$checkOverpaidLimit) {
						if ($item['foloutstanding'] >= 0) { 
							unset($debtors[$key]); 
							continue;
						}
					} else {
						if ($overpaidLimit > 0) { $overpaidLimit = -$overpaidLimit; }
						if ($overpaidLimitType == "above") {
							if($item['foloutstanding'] > $overpaidLimit) { 
								unset($debtors[$key]); 
								continue;
							}
						} else {
							if ($item['foloutstanding'] >= 0 || $item['foloutstanding'] < $overpaidLimit) { 
								unset($debtors[$key]); 
								continue;
							}
						}
					}
				}

				if ($checkPaid) {
					if ($item['foloutstanding'] != 0) { 
						unset($debtors[$key]); 
						continue;
					}
				}

				if ($checkNonzero) {
					if ($item['foloutstanding'] == 0) { 
						unset($debtors[$key]); 
						continue;
					}
				}
			}
		}
	}

	$data = array();
	$total = array();
	$label = array();
	foreach($debtors as $item) {
		$curr = array();
		for($count=0;$count<$groups;$count++) {
			if( (isset($item['name'.$count."_1"]) && trim($item['name'.$count."_1"]) != "") || (isset($item['name'.$count."_2"]) && trim($item['name'.$count."_2"]) != "") ) {
				$name = trim($item['name'.$count."_1"] . " " . $item['name'.$count."_2"]);
			} else {
				$name = isset($item['name'.$count]) ? $item['name'.$count] : "";
			}
			if(empty($name)) {
				$name = $groupByArray[$groupBy[$count]]['blank'];
			}
			$label[$count][$item['id'.$count]] = $name;
			array_push($curr,$item['id'.$count]);
		}
		array_push($curr,$item['rf_currency_id']);
		if(!isset($label['currency']) || !is_array($label['currency'])) {
			$label['currency'] = array();
		}
		if(!isset($label['currency'][$item['rf_currency_id']]) || !is_string($label['currency'][$item['rf_currency_id']])) {
			$label['currency'][$item['rf_currency_id']] = $lDB->get("
				SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$item[rf_currency_id]'
			",4);
		}

		$curr = join("_",$curr);
		if(!isset($data[$curr]) || !is_array($data[$curr])) {
			if ($item['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
				$data[$curr]['fn_folio_amount'] = 0;
			} else {		
				$data[$curr]['fn_folio_amount'] = $item['fn_folio_amount'];
			}
			if ($item['fn_invoice_ix'] == "" && !$checkUnInvPaid){
				// Do Nothing
			} else {
				$data[$curr]['fn_folio_amt_paid'] = $item['fn_folio_amt_paid'];
			}
			//$data[$curr]['foloutstanding'] = $item['foloutstanding'];
			$data[$curr]['fn_folio_amt_comm'] = $item['fn_folio_amt_comm'];
			$data[$curr]['fn_folio_amt_tax'] = $item['fn_folio_amt_tax'];
		} else {
			if ($item['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
				$data[$curr]['fn_folio_amount'] += 0;
			} else {		
				$data[$curr]['fn_folio_amount'] += $item['fn_folio_amount'];
			}		
			if ($item['fn_invoice_ix'] == "" && !$checkUnInvPaid){
				// Do nothing
			} else {
				$data[$curr]['fn_folio_amt_paid'] += $item['fn_folio_amt_paid'];
			}
			//$data[$curr]['foloutstanding'] = $data[$curr]['foloutstanding'] + $item['foloutstanding'];
			$data[$curr]['fn_folio_amt_comm'] = $data[$curr]['fn_folio_amt_comm'] + $item['fn_folio_amt_comm'];
			$data[$curr]['fn_folio_amt_tax'] = $data[$curr]['fn_folio_amt_tax'] + $item['fn_folio_amt_tax'];
		}
		$data[$curr]['fn_folio_amt_paid'] = isset($data[$curr]['fn_folio_amt_paid']) ? $data[$curr]['fn_folio_amt_paid'] : 0;
		$data[$curr]['foloutstanding'] = $data[$curr]['fn_folio_amount'] - $data[$curr]['fn_folio_amt_paid'];
		
		$data[$curr]['folios'][] = $item;
	}
	foreach ($data as $level){
		foreach ($level['folios'] as $folio){
			if ($folio['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
				$total[$folio['rf_currency_id']]['fn_folio_amount'] = 0;
			} else {
				if (isset($total[$folio['rf_currency_id']]['fn_folio_amount'])) {
					$total[$folio['rf_currency_id']]['fn_folio_amount'] += $folio['fn_folio_amount'];
				} else {
					$total[$folio['rf_currency_id']]['fn_folio_amount'] = $folio['fn_folio_amount'];
				}
			}
			if ($folio['fn_invoice_ix'] == "" && !$checkUnInvPaid){
				$total[$folio['rf_currency_id']]['fn_folio_amt_paid'] = 0;
			} else {
				if (isset($total[$folio['rf_currency_id']]['fn_folio_amt_paid'])) {
					$total[$folio['rf_currency_id']]['fn_folio_amt_paid'] += $folio['fn_folio_amt_paid'] ;
				} else {
					$total[$folio['rf_currency_id']]['fn_folio_amt_paid'] = $folio['fn_folio_amt_paid'] ;
				}
			}			
			
			//$total[$folio['rf_currency_id']]['foloutstanding'] += $folio['foloutstanding'] ;
			$total[$folio['rf_currency_id']]['foloutstanding'] = $total[$folio['rf_currency_id']]['fn_folio_amount'] - $total[$folio['rf_currency_id']]['fn_folio_amt_paid'] ;
			
			if (isset($total[$folio['rf_currency_id']]['fn_folio_amt_comm'])) {
				$total[$folio['rf_currency_id']]['fn_folio_amt_comm'] += $folio['fn_folio_amt_comm'] ;
			} else {
				$total[$folio['rf_currency_id']]['fn_folio_amt_comm'] = $folio['fn_folio_amt_comm'] ;
			}
			if (isset($total[$folio['rf_currency_id']]['fn_folio_amt_tax'])) {
				$total[$folio['rf_currency_id']]['fn_folio_amt_tax'] += $folio['fn_folio_amt_tax'] ;
			} else {
				$total[$folio['rf_currency_id']]['fn_folio_amt_tax'] = $folio['fn_folio_amt_tax'] ;
			}
		}
	}

	if ( isset($renderMode) && $renderMode == "csv" && isset($renderType) && $renderType == "email" ) {
		outputMail($form,$renderOption);
	}	

	if(isset($renderMode) && $renderMode == "html") {
		session_set("reportURL","reservation.php?" . join("+",$_SERVER['argv']));
		$GLOBALS['temp']['today'] = chng_date(date("Y-m-d"),"-");

		$GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
		$GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

		$width = 0;
		$rows = "";
		$cols = "";

		// *** [START] Headers
		$folioDetailColCount = 0;
		$folioAmountsColCount = 0;
		foreach($folioDetailCols as $col) {
			if($col['active'] == 1) {
				$folioDetailColCount++;
			}
		}
		foreach($folioAmountsCols as $col) {

			if($col['active'] == 1) {
				$folioAmountsColCount++;
			}
		}		
		$rows .= "
			<tr>
				<td colspan=\"".($groups+1)."\" class=\"outDk\" align=\"left\">Grouping</td>
		";
		if ($folioDetailColCount > 0){
			$rows .= "			
					<td colspan=\"".($folioDetailColCount)."\" class=\"outDk\" align=\"center\">Folio details</td>
			";
		}
		if ($folioAmountsColCount > 0){
			$rows .= "					
					<td colspan=\"".($folioAmountsColCount)."\" class=\"outDk\" align=\"center\">Folio amounts</td>				
			";
		}
		$rows .= "			
			</tr>
		";	

		// [START] Folio Detail and Amount Header Row if needed
		$hasHeaderRow = false;
		foreach($folioDetailCols as $col) {
			if ($col['header'] != ""){
				$hasHeaderRow = true;
			}
		}
		
		foreach($folioAmountsCols as $col) {		
			if ($col['header'] != ""){
				$hasHeaderRow = true;
			}		
		}
		
		if ($hasHeaderRow){
			$rows .= "			
				<tr>
					<td colspan=\"".($groups+1)."\" class=\"outDk\" align=\"left\">&nbsp;</td>
			";				
			$lastHeader = "";
			$lastHeaderCount = 0;				
			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					if($lastHeader != "" && $lastHeader != $col['header']) {
						$rows .= "<td class=\"outDk\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
						$lastHeader = "";
						$lastHeaderCount = 0;
					}
					if($col['header'] != "") {
						$lastHeader = $col['header'];
						$lastHeaderCount++;
					} else {
						$rows .= "<td class=\"outDk\" align=\"center\">&nbsp;</td>";
					}				
				}
			}
						
			foreach($folioAmountsCols as $col) {
				if($col['active'] == 1) {
					if($lastHeader != "" && $lastHeader != $col['header']) {
						$rows .= "<td class=\"outDk\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
						$lastHeader = "";
						$lastHeaderCount = 0;
					}
					if($col['header'] != "") {
						$lastHeader = $col['header'];
						$lastHeaderCount++;
					} else {
						$rows .= "<td class=\"outDk\" align=\"center\">&nbsp;</td>";
					}				
				}
			}			

			if($lastHeader != "") {
				$rows .= "<td class=\"outDk\" colspan=\"$lastHeaderCount\" align=\"center\">".$lastHeader."</td>";
			}			
			
			$rows .= "			
				</tr>
			";				
			
		}

		// [END] Folio Detail and Amount Header Row if needed

		
		
		$rows .= "
			<tr>
		";		
		for($count=0;$count<$groups;$count++) { 
			$width += 200;
			$cols .= "
				<col width=\"200\" />
			";
			$rows .= "
				<td class=\"outDk\" align=\"left\">".$groupByArray[$groupBy[$count]]['name']."</td>
			";
		}
		$width += 40;
		$cols .= "
			<col width=\"40\" />
		";
		$rows .= "
			<td class=\"outDk\" align=\"center\">Curr</td>
		";
		
		foreach($folioDetailCols as $col) {
			
			if($col['align'] == "r") {
				$align = "right";
			} else if($col['align'] == "c") {
				$align = "center";
			} else {
				$align = "left";
			}
			if($col['active'] == 1) {

			
				$width += $col['width'];
				$cols .= "
					<col width=\"".$col['width']."\" />
				";
				$rows .= "
					<td class=\"outDk\" align = '$align'>".$col['label']."</td>
				";
			}
		}		
		
		foreach($folioAmountsCols as $col) {
			
			if($col['align'] == "r") {
				$align = "right";
			} else if($col['align'] == "c") {
				$align = "center";
			} else {
				$align = "left";
			}
			if($col['active'] == 1) {

				$width += $col['width'];
				$cols .= "
					<col width=\"".$col['width']."\" />
				";
				$rows .= "
					<td class=\"outDk\" align = '$align'>".$col['label']."</td>
				";

			}
		}
		$rows .= "
			</tr>
		";			
		
		// *** [END] Headers

		foreach($data as $key=>$item) {
			$groupKeys = explode("_",$key);
			$rows .= "
				<tr class=\"imgLink\">
			";			
			$count = 0;
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				if(empty($finalLabel)) {
					$finalLabel = "&nbsp;";
				}
				$rows .= "
					<td class=\"Ltln bt\" align=\"left\">".$finalLabel."</td>
				";
			}
			$rows .= "
				<td class=\"Ltln br bt\" align=\"center\">".$label['currency'][$groupKeys[sizeof($groupKeys)-1]]."</td>
			";			
			$folioDetailColNum	= 1;
			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					if ($folioDetailColNum < $folioDetailColCount){
						$rows .= "
							<td class=\"Ltln bl bt\">&nbsp;</td>
						";
					} else {
						$rows .= "
							<td class=\"Ltln bl br bt\">&nbsp;</td>
						";					
					}
					$folioDetailColNum++;
				}
			}				
			
			foreach($folioAmountsCols as $col) {
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {
					
					$finalLabel = $item[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$rows .= "
						<td align='$align' class=\"Ltln bl bt\">".$finalLabel."</td>
					";					
				}
			}			
			
			$rows .= "
				</tr>
			";
			
			// If we want folio detail, create new rows
			if ($folioDetailColCount > 0){
				foreach($item['folios'] as $folio){
		
					$onclick = "onclick=\"window.location = '/reservation.php?647+".$folio['rv_reservation_ix']."';\"";
					$onMouseOver = "onmouseover=\"rowOn(this);\"";
					$onMouseOut = "onmouseout=\"rowOff(this);\"";
					$rows .= "
						<tr $onclick $onMouseOver $onMouseOut>
							<td colspan=\"".($groups+1)."\" class=\"br\">&nbsp;</td>
					";
					$folioDetailColNum = 1;
					foreach($folioDetailCols as $subCol) {
						
						if($subCol['align'] == "r") {
							$align = "right";
						} else if($subCol['align'] == "c") {
							$align = "center";
						} else {
							$align = "left";
						}
						if($subCol['active'] == 1) {

							$finalLabel = $folio[$subCol['fields'][0]];
							//fixAmtDisplay($finalLabel);
							
							if ($folioDetailColNum < $folioDetailColCount){
								$rows .= "
									<td align='$align' style=\"white-space: nowrap; overflow: hidden;\" class=\"bl\">".$finalLabel."</td>
								";
							} else {
								$rows .= "
									<td align='$align' style=\"white-space: nowrap; overflow: hidden;\" class=\"bl br\">".$finalLabel."</td>
								";							
							}
							$folioDetailColNum++;
						}
					} 

					foreach($folioAmountsCols as $subCol) {
						
						if($subCol['align'] == "r") {
							$align = "right";
						} else if($subCol['align'] == "c") {
							$align = "center";
						} else {
							$align = "left";
						}
						if($subCol['active'] == 1) {
							if ($subCol['fields'][0] == "fn_folio_amt_paid" && $folio['fn_invoice_ix'] == "" && !$checkUnInvPaid){
								$rows .= "
									<td align='$align'>0.00</td>
								";	
							} elseif ($subCol['fields'][0] == "fn_folio_amount" && $folio['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
								$rows .= "
									<td align='$align'>0.00</td>
								";
							} elseif ($subCol['fields'][0] == "foloutstanding"){
								$folAmount = $folio['fn_folio_amount'];
								$folPaid = $folio['fn_folio_amt_paid'];
								if ($folio['fn_invoice_ix'] == "" && !$checkUnInvPaid){
									$folPaid = 0;								
								} 
								if ($folio['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
									$folAmount = 0;								
								}
								$finalLabel = ($folAmount - $folPaid);
								fixAmtDisplay($finalLabel);
								$rows .= "
									<td align='$align' class=\"bl\">".$finalLabel."</td>
								";	
							} else {
							
								$finalLabel = $folio[$subCol['fields'][0]];
								fixAmtDisplay($finalLabel);

								$rows .= "
									<td align='$align' class=\"bl\">".$finalLabel."</td>
								";	
							}							
						}
					}					
					
					$rows .= "
						</tr>
					";					
				}
			}
		
		}
		
		// *** [START] Total rows
		foreach ($total as $currency => $totalItem){
			$rows .= "
				<tr>
					<td colspan=\"".($groups)."\" class=\"outLt txtb bt\" align=\"left\">Total</td>
					<td class=\"outLt txtb bt\" align=\"center\">".$label['currency'][$currency]."</td>
			";
			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					$rows .= "
						<td class=\"outLt bt\">&nbsp;</td>
					";					
				}
			}
			foreach($folioAmountsCols as $col) {
				
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {

					$finalLabel = $totalItem[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$rows .= "
						<td align='$align' class=\"outLt txtb bt\">".$finalLabel."</td>
					";					
				}
			}

			$rows .= "
				</tr>
			";		
		}
		// *** [END] Total row			
		
		
		$GLOBALS['temp']['dataWidth'] = $width;
		$GLOBALS['temp']['cols'] = $cols;
		$GLOBALS['temp']['rows'] = $rows;
		 
		if(sizeof($data) == 0) {
			$GLOBALS['temp']['dataWidth'] = 750;
			$GLOBALS['temp']['cols'] = "<col width=\"750\">";
			$GLOBALS['temp']['rows'] = "
				<tr>
					<td class=\"txti\" align=\"center\">No data matched your filter criteria.</td> 
				</tr>
			";
		}	
	
	}
	
	if(isset($renderMode) && ($renderMode == "csv" || $renderMode == "ooffice")) {

		define("COLWIDTH",150);
		$rows = array();
		$cells = array();
		$tables = array();
		$multiCell = array();
		$tempCell = array();
		$tempCell_nxt = array();
		$rowCount = 1;
		$multiCell[$rowCount] = array();	
		
		$borderL = array('Position' => 'Left', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderR = array('Position' => 'Right', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderT = array('Position' => 'Top', 'LineStyle' => 'Continuous', 'Weight' => '1');
		$borderB = array('Position' => 'Bottom', 'LineStyle' => 'Continuous', 'Weight' => '1');

		$defaultStyle = array( 
			'alignment' =>array('Horizontal' => 'Left', 'Vertical' => 'Top', 'WrapText' => '1'),
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'font' => array('Size' => '8')
		);
		
		$xls = new XLS($defaultStyle);

		$header_style = array( 
			'interior' => array('Color' => '#dddddd', 'Pattern'=>'Solid'),
			'font' =>array('Bold' => '1'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$header_styleId = $xls->addStyle($header_style);

		$group_style = array( 
			'interior' => array('Color' => '#f7f2d9', 'Pattern'=>'Solid'),
			'font' =>array('Bold' => '1'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);
						
		$group_styleId = $xls->addStyle($group_style);		
		
		$cell_style = array( 
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT, $borderB)
		);

		$cell_styleLR = array( 
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR)
		);

		$cell_styleLRT = array( 
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderT)
		);

		$cell_styleLRB = array( 
			'interior' => array('Color' => '#FFFFFF', 'Pattern'=>'Solid'),
			'border' => array($borderL, $borderR, $borderB)
		);
						
		$cell_styleId = $xls->addStyle($cell_style);
		$cell_styleIdLR = $xls->addStyle($cell_styleLR);
		$cell_styleIdLRT = $xls->addStyle($cell_styleLRT);
		$cell_styleIdLRB = $xls->addStyle($cell_styleLRB);
		
		$xls->Column(COLWIDTH,1,0);
		$xls->Column(COLWIDTH,1,0);		

		// *** [START] Headers
		$folioDetailColCount = 0;
		$folioAmountsColCount = 0;
		$hasHeaderRow = false;
		
		for($count=0;$count<$groups;$count++) { 
			$xls->Column(200,1,0);

		}
		
		foreach($folioDetailCols as $col) {
			if($col['active'] == 1) {
				$folioDetailColCount++;
				$xls->Column($col['width'],1,0);
			}
			if ($col['header'] != ""){
				$hasHeaderRow = true;
			}			
		}
		foreach($folioAmountsCols as $col) {

			if($col['active'] == 1) {
				$folioAmountsColCount++;
				$xls->Column($col['width'],1,0);
			}
			if ($col['header'] != ""){
				$hasHeaderRow = true;
			}			
		}	

		$cell = $xls->Cell(array('type'=>'String', 'data' => "Grouping"), $header_styleId, '', '', '', '', $groups);
		array_push($tempCell, $cell);		
		
		if($folioDetailColCount > 0) {
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Folio details"), $header_styleId, '', '', '', '', $folioDetailColCount-1);
			array_push($tempCell, $cell);
		}
		if($folioAmountsColCount > 0) {
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Folio amounts"), $header_styleId, '', '', '', '', $folioAmountsColCount-1);
			array_push($tempCell, $cell);
		}

		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();

		
		// [START] Folio Detail and Amount Header Row if needed
		if ($hasHeaderRow){
			$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $header_styleId, '', '', '', '', $groups);
			array_push($tempCell, $cell);				
			$lastHeader = "";
			$lastHeaderCount = 0;				
			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					if($lastHeader != "" && $lastHeader != $col['header']) {
						$cell = $xls->Cell(array('type'=>'String', 'data' => "$lastHeader"), $header_styleId, '', '', '', '', $lastHeaderCount-1);
						array_push($tempCell, $cell);							
						$lastHeader = "";
						$lastHeaderCount = 0;
					}
					if($col['header'] != "") {
						$lastHeader = $col['header'];
						$lastHeaderCount++;
					} else {
						$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $header_styleId, '', '', '', '');
						array_push($tempCell, $cell);		
					}				
				}
			}
						
			foreach($folioAmountsCols as $col) {
				if($col['active'] == 1) {
					if($lastHeader != "" && $lastHeader != $col['header']) {
						$cell = $xls->Cell(array('type'=>'String', 'data' => "$lastHeader"), $header_styleId, '', '', '', '', $lastHeaderCount-1);
						array_push($tempCell, $cell);							
						$lastHeader = "";
						$lastHeaderCount = 0;
					}
					if($col['header'] != "") {
						$lastHeader = $col['header'];
						$lastHeaderCount++;
					} else {
						$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $header_styleId, '', '', '', '');
						array_push($tempCell, $cell);		
					}				
				}
			}			

			if($lastHeader != "") {
				$cell = $xls->Cell(array('type'=>'String', 'data' => "$lastHeader"), $header_styleId, '', '', '', '', $lastHeaderCount-1);
				array_push($tempCell, $cell);		
			}			
			
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();	
			
		}

		// [END] Folio Detail and Amount Header Row if needed		

		for($count=0;$count<$groups;$count++) { 
			$cell = $xls->Cell(array('type'=>'String', 'data' => $groupByArray[$groupBy[$count]]['name']), $header_styleId, '', '', '', '');
			array_push($tempCell, $cell);

		}
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Curr"), $header_styleId, '', '', '', '');
		array_push($tempCell, $cell);

		foreach($folioDetailCols as $col) {
			if($col['active'] == 1) {
				$cell = $xls->Cell(array('type'=>'String', 'data' => $col['label']), $header_styleId, '', '', '', '');
				array_push($tempCell, $cell);				
			}
		}		
		
		foreach($folioAmountsCols as $col) {
			if($col['active'] == 1) {
				$cell = $xls->Cell(array('type'=>'String', 'data' => $col['label']), $header_styleId, '', '', '', '');
				array_push($tempCell, $cell);	
			}
		}

		array_push($multiCell[$rowCount], $tempCell);
		$tempCell = array();
		$rowCount += 1;
		$multiCell[$rowCount] = array();	
		
		// *** [END] Headers		
		
		// *** [START] Data		

		foreach($data as $key=>$item) {
			$groupKeys = explode("_",$key);

			$count = 0;
			for($count=0; $count<sizeof($groupKeys)-1; $count++) {
				$finalLabel = $label[$count][$groupKeys[$count]];
				if(empty($finalLabel)) {
					$finalLabel = "";
				}
				$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $group_styleId, '', '', '', '');
				array_push($tempCell, $cell);	
			}
		
			$cell = $xls->Cell(array('type'=>'String', 'data' => $label['currency'][$groupKeys[sizeof($groupKeys)-1]]), $group_styleId, '', '', '', '');
			array_push($tempCell, $cell);			

			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $group_styleId, '', '', '', '');
					array_push($tempCell, $cell);	
				}
			}				
			
			foreach($folioAmountsCols as $col) {
				
				if($col['align'] == "r") {
					$align = "right";
				} else if($col['align'] == "c") {
					$align = "center";
				} else {
					$align = "left";
				}
				if($col['active'] == 1) {

					$finalLabel = $item[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $group_styleId, '', '', '', '');
					array_push($tempCell, $cell);					
				}
			}			
			
			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();
			
			// If we want folio detail, create new rows
			if ($folioDetailColCount > 0){
				foreach($item['folios'] as $folio){
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $cell_styleId, '', '', '', '', $groups);
					array_push($tempCell, $cell);						
					
					foreach($folioDetailCols as $subCol) {

						if($subCol['active'] == 1) {

							$finalLabel = $folio[$subCol['fields'][0]];

							$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $cell_styleId, '', '', '', '');
							array_push($tempCell, $cell);				
						}
					}

					foreach($folioAmountsCols as $subCol) {
						if($subCol['active'] == 1) {
							if ($subCol['fields'][0] == "fn_folio_amt_paid" && $folio['fn_invoice_ix'] == "" && !$checkUnInvPaid){
								$cell = $xls->Cell(array('type'=>'String', 'data' => "0.00"), $cell_styleId, '', '', '', '');
								array_push($tempCell, $cell);		
							} elseif ($subCol['fields'][0] == "fn_folio_amount" && $folio['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
								$cell = $xls->Cell(array('type'=>'String', 'data' => "0.00"), $cell_styleId, '', '', '', '');
								array_push($tempCell, $cell);
							} elseif ($subCol['fields'][0] == "foloutstanding"){
								$folAmount = $folio['fn_folio_amount'];
								$folPaid = $folio['fn_folio_amt_paid'];
								if ($folio['fn_invoice_ix'] == "" && !$checkUnInvPaid){
									$folPaid = 0;								
								} 
								if ($folio['fn_invoice_ix'] == "" && !$checkUnInvChargeable){
									$folAmount = 0;								
								}
								$finalLabel = ($folAmount - $folPaid);
								fixAmtDisplay($finalLabel);
								$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $cell_styleId, '', '', '', '');
								array_push($tempCell, $cell);	
							} else {
							
								$finalLabel = $folio[$subCol['fields'][0]];
								fixAmtDisplay($finalLabel);

								$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $cell_styleId, '', '', '', '');
								array_push($tempCell, $cell);
							}							
						}
					}					
					
					array_push($multiCell[$rowCount], $tempCell);
					$tempCell = array();
					$rowCount += 1;
					$multiCell[$rowCount] = array();				
				}
			}
		
		}		

		
		// *** [END] Data	
		
		// *** [START] Total rows
		foreach ($total as $currency => $totalItem){
			$cell = $xls->Cell(array('type'=>'String', 'data' => "Total"), $header_styleId, '', '', '', '',$groups-1);
			array_push($tempCell, $cell);
			$cell = $xls->Cell(array('type'=>'String', 'data' => $label['currency'][$currency]), $header_styleId, '', '', '', '');
			array_push($tempCell, $cell);						
			foreach($folioDetailCols as $col) {
				if($col['active'] == 1) {
					$cell = $xls->Cell(array('type'=>'String', 'data' => ""), $header_styleId, '', '', '', '');
					array_push($tempCell, $cell);						
				}
			}
			foreach($folioAmountsCols as $col) {

				if($col['active'] == 1) {

					$finalLabel = $totalItem[$col['fields'][0]];
					fixAmtDisplay($finalLabel);

					$cell = $xls->Cell(array('type'=>'String', 'data' => $finalLabel), $header_styleId, '', '', '', '');
					array_push($tempCell, $cell);					
				}
			}

			array_push($multiCell[$rowCount], $tempCell);
			$tempCell = array();
			$rowCount += 1;
			$multiCell[$rowCount] = array();		
		}
		
		// *** [END] Total row			
		
		// *** [START] Summary Block

		$tempCell = array();
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Filter Summary"), $header_styleId, '', '', '', '', 1);
		array_push($tempCell, $cell);	
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();	
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Debtor"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $folioContactFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Agent Name"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $agentFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Agent Country"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $agentCountryFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Originator"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $originatorFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Source"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $sourceFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Created By"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $createdByFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Nationality"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $nationalityFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Rate Type"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $rateFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Status"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $statusFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Payment Plan"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $paymentPlanFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Invoice Status"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => join(',',$invStatusText)), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Display Currency"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $displayCurrency=="0"?"Folio Currency":"GL Currency"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Invoice Date Range"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		if ($invFromDate != "All"){
			$invoiceDateText = $invFromDate['jsDate'] . " to " . $invToDate['jsDate'];
		} else {
			$invoiceDateText = $invFromDate;
		}
		$cell = $xls->Cell(array('type'=>'String', 'data' => $invoiceDateText), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Payment Date Limit"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		if ($payToDate != "All"){
			$paymentDateText = " To " . $payToDate['jsDate'];
		} else {
			$paymentDateText = $payToDate;
		}
		$cell = $xls->Cell(array('type'=>'String', 'data' => $paymentDateText), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();

		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Travel Date Range"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		if ($trvlFromDate != "All"){
			$travelDateText = $trvlFromDate['jsDate'] . " to " . $trvlToDate['jsDate'];
		} else {
			$travelDateText = $trvlFromDate;
		}
		$cell = $xls->Cell(array('type'=>'String', 'data' => $travelDateText), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Owner Environment"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $serverFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Invoice From"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $billingEntitiesFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
				
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Folio Currency"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $folioCurrencyFilter['names']), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
		
		$tempCell = array();		
		$cell = $xls->Cell(array('type'=>'String', 'data' => "Amounts"), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);
		$cell = $xls->Cell(array('type'=>'String', 'data' => $balanceText), $cell_styleId, '', '', '', '');
		array_push($tempCell, $cell);		
		array_push($multiCell[$rowCount], $tempCell);
		$rowCount += 1;
		$multiCell[$rowCount] = array();
	
		
		// *** [END] Summary Block
		
		
		$cells = array();
		$rows = array();
		$temparr=array();
		$headerFlag = 1;
		
		foreach($multiCell as $rowId=>$temparr) {
			foreach($temparr as $cellArr) {
				foreach($cellArr as $tmp) {
					array_push($cells,$tmp);
				}
				
				if($headerFlag<=3) {
					$row = $xls->Row($cells, 20, 1);
				} else {
					$row = $xls->Row($cells);
				}
				$cells = array();
				array_push($rows,$row);
			}
			$headerFlag++;
		}	
		
		$table = $xls->Table($rows);
		array_push($tables, $table);
		$xls->Worksheet($tables);
		if ( $renderType == 'view') {
			$fromDate = date("d-m-Y");
			$csvName = "debtors_analysis_$fromDate";		
			if ( $renderMode == "ooffice" ) {
				$repName = $csvName.".xml";
				$repType = "xml";
			} else {
				$repName = $csvName.".xlsx";
				$repType = "xls";
			}		
			$xls->genrateWorkbook($repName, $repType);
		}		

		if ( $renderType == 'send' ) {

			$to = $_POST['mail_to'];
			$from = $_POST['mail_from'];
			$subject = stripslashes($_POST['mail_subj']);
			$message = stripslashes($_POST['mail_body']);
			$attachmentName = $_POST['attachmentName'];
			$repType = $renderMode == "ooffice" ? "xml" : "xls"; 

			$headers = "From: ".$GLOBALS['princName']."<$from>\r\n";
			$xlsSheet = $xls->genrateWorkbook($attachmentName, $repType, 1);
			
			// and now mail it
			if ( $attachmentName != '!attachmentName!' ) {
				$pdfName = $attachmentName;
			} else {
				$pdfName = $repName;
			}

			// (from, to, subject, headers, message, action, emailID, resID)
			$error = email($from, $to, $subject, $headers, $message, 0, 0, "", $GLOBALS['princName'],$xlsSheet,$pdfName);

			if ( !$error ) {
				echo '
							<script type="text/javascript" charset="utf-8">
								// <![CDATA[
								if ( opener && !opener.closed ) {
									opener.openMessage("Your email has been sent.");
								}
								window.close();
								// ]]>
							</script>
						</body>
					</html>
				';
				die();
			} else {
				echo '
							<script type="text/javascript" charset="utf-8">
								// <![CDATA[
								if ( opener && !opener.closed ) {
									opener.openMessage("Error sending email!");
								}
								window.close();
								// ]]>
							</script>
						</body>
					</html>
				';
				die();
			}
		}		
			
	}

	
} else {
	$GLOBALS['temp']['reportGenerated'] = " class=\"collapse printCollapse\" ";
	$GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
	$GLOBALS['temp']['filterStatus'] = "";		
}

