<?php

/*
 * $Id: init.form2004.func.php,v 1.3 2011-12-22 12:59:22 light Exp $
 *
 * $Log: init.form2004.func.php,v $
 * Revision 1.3  2011-12-22 12:59:22  light
 * Bug #7724 - FINREP: Tax analysis report
 *
 * Revision 1.2  2011-08-11 15:24:50  light
 * Bug #7695 - Tax Analysis report
 *
 */

/**
 * init.form2004.php - Tax Analysis Report
 */
 
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');   
require_once(__DIR__ . "/class.xls.php");

$profileFields = array(
	/*  1 */ "invFromDate",
	/*  2 */ "invToDate",
	/*  3 */ "totalDisplay",
	/*  4 */ "",
	/*  5 */ "",		
	/*  6 */ "agentFilterType",
	/*  7 */ "agentFilter",
	/*  8 */ "agentCountryFilter",
	/*  9 */ "folioContactFilter",
	/* 10 */ "originatorFilter",
	/* 11 */ "sourceFilter",
	/* 12 */ "createdByFilter",
	/* 13 */ "nationalityFilter",
	/* 14 */ "rateFilter",
	/* 15 */ "statusFilter",
	/* 16 */ "accommFilter",
	/* 17 */ "paymentPlanFilter",
	/* 18 */ "componentsFilter",
	/* 19 */ "taxRateFilter",
	/* 20 */ "consultantFilter",
	/* 21 */ "serverFilter",
	/* 22 */ "folioCurrencyFilter",
	/* 23 */ "invoiceFrom",
	/* 24 */ "invoiceStatus",
	/* 25 */ "",
	/* 26 */ "",
	/* 27 */ "checkInclPos",
	/* 28 */ "checkInclNeg",
	/* 29 */ "checkInclZero",
	/* 30 */ "",
	/* 31 */ "",
	/* 32 */ "",
	/* 33 */ "",
	/* 34 */ "",
	/* 35 */ "",
	/* 36 */ "",
	/* 37 */ "",	
	/* 38 */ "extraFilterType",
	/* 39 */ "extraCategoryIds",
	/* 40 */ "extrasIds",
	/* 41 */ "extraPropertyCheck",
	/* 42 */ "groups",
	/* 43 */ "taxDetailCols",
	/* 44 */ "taxAmountsCols",
	/* 45 */ "renderOption",
	/* 46 */ "DisplayCurrency",
	
);

function outputMail($form,$options) {
	global $lDB;
	global $temp;
	$fromDate = date("d-m-Y");
	$csvName = "tax_analysis_$fromDate";
	$attachmentTable = "
		<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
		<tr valign=\"top\">
			<td><img src=\"/resource/Resrequest/Application/public/img/eml_pdf.gif\" alt=\"\" /></td>
			<td id=\"attachmentLabel\" width=\"100%\">" . $csvName . ".xlsx</td>
		</tr>
		</table>
	";
	$newOptions = ($options & ~7) + 6;
	$formAction = "reservation.php?".join("+",array_slice($_SERVER['argv'],0,45))."+$newOptions+".join("+",array_slice($_SERVER['argv'],46,1));
	
	$GLOBALS[$form]->FormHTML =	str_replace("!formAction!",$formAction,
								str_replace("!attachmentInfo!",$attachmentTable,
								str_replace("!attachmentName!",$csvName.".xlsx",
								str_replace("!hasAttachment!","expand",
								str_replace("!emailBody!","",
								str_replace("!emailSubject!","Tax Analysis Report: ".chng_date(date("Y-m-d"),"-"),
								Join("", file(__DIR__ . "/../../../public/html/email_popup.htm"))))))));

	// Get principal
	$principalId = $lDB->get("SELECT rf_principal_id FROM rf_default", 4);
	$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);

	$principalInfo = getPersonaDetail($principalId);
	$resOfficeInfo = getPersonaDetail($resOfficeId);

	$addressee = t_encodeHTML(getContactCorrAddress($resOfficeId));
	
	$temp['princName'] = $principalInfo['name'];
	$temp['fax'] = $resOfficeInfo['fax'];
	$temp['resOffTel'] = $resOfficeInfo['telephone'];
	
	$userId = $_SESSION['userid'];
	
	$temp['emailFrom'] = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '$userId'",4);
	$temp['emailTo'] = "";
}

function getPersonaDetail($personaId) {
	$detail = $GLOBALS['lDB']->get("
		SELECT
			pr_persona.pr_name_first,
			pr_persona.pr_name_second,
			pr_persona.pr_name_last,
			pr_persona.pr_email
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '$personaId'
	",1);
	$name = "";
	if (trim($detail['pr_name_first']) != "" && $detail['pr_name_first'] != "0") {
		$name .= $detail['pr_name_first'] . " ";
	}
	if (trim($detail['pr_name_second']) != "" && $detail['pr_name_second'] != "0") {
		$name .= $detail['pr_name_second'] . " ";
	}
	if (trim($detail['pr_name_last']) != "" && $detail['pr_name_last'] != "0") {
		$name .= $detail['pr_name_last'] . " ";
	}
	$result = array();
	$result['name'] = trim($name);
	$result['fax'] = getPersonaFax($personaId);
	$result['telephone'] = getPersonaTelephone($personaId);
	$result['email'] = $detail['pr_email'];
	if (trim($result['email']) == "" || $result['email'] == "0") {
		$result['email'] = "";
	}
	return $result;
}

// Auxillary functions
function getPersonaFax($personaId) {
	$fax = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
			INNER JOIN rf_phone_type ON rf_phone_type.rf_phone_type_ix = pr_phone.rf_phone_type_id
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND rf_phone_type.rf_phone_type_sys_code = '1'
	", 4);
	if (trim($fax) == "" || $fax == "0") {
		$fax = "";
	}
	return $fax;
}

function getPersonaTelephone($personaId) {
	$tel = $GLOBALS['lDB']->get("
		SELECT
			pr_phone.pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_phone.pr_persona_id = '$personaId'
			AND pr_phone.pr_default_yn = '1'
	",4);
	if (trim($tel) == "" || $tel == "0") {
		$tel = "";
	}
	return $tel;
}

